/*
 * Copyright (c) 2024 Christians Martínez Alvarado
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.mardous.booming.data.remote.lyrics.api

import com.mardous.booming.data.model.Song
import com.mardous.booming.data.remote.lyrics.model.DownloadedLyrics

const val AppleMusicSource = "appleMusic"
const val SpotifySource = "spotify"

interface LyricsApi {
    suspend fun songLyrics(song: Song, title: String, artist: String): DownloadedLyrics?
}