/*
 * Copyright (c) 2024 Christians Martínez Alvarado
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.mardous.booming.data.local.room

import android.os.Parcelable
import androidx.room.Embedded
import androidx.room.Relation
import kotlinx.parcelize.Parcelize

@Parcelize
data class PlaylistWithSongs(
    @Embedded
    val playlistEntity: PlaylistEntity,
    @Relation(parentColumn = "playlist_id", entityColumn = "playlist_creator_id")
    val songs: List<SongEntity>
) : Parcelable {
    val songCount get() = songs.size

    companion object {
        val Empty = PlaylistWithSongs(PlaylistEntity.Empty, emptyList())
    }
}