package com.mardous.booming.coil.store

import coil3.key.Keyer
import coil3.request.Options
import com.mardous.booming.coil.CustomArtistImageManager
import com.mardous.booming.coil.model.ArtistImage
import com.mardous.booming.coil.model.AudioCover
import com.mardous.booming.coil.model.AutoGeneratedImage
import com.mardous.booming.coil.model.PlaylistImage

class AudioCoverKeyer : Keyer<AudioCover> {
    override fun key(data: AudioCover, options: Options): String? {
        return buildString {
            if (data.isAlbum) {
                append("album::")
            } else {
                append("song::")
            }
            append("albumId=").append(data.albumId)
            append("|uri=").append(data.uri.toString())
            append("|path=").append(data.path)
            append("|folderArt=").append(data.isUseFolderArt)
            append("|lastModified=").append(data.lastModified)
        }
    }
}

class ArtistImageKeyer(
    private val customArtistImageManager: CustomArtistImageManager
) : Keyer<ArtistImage> {
    override fun key(data: ArtistImage, options: Options): String? {
        val signature = customArtistImageManager.getSignature(data)
        return "artist::id=${data.id}|name=${data.name}|coverUri=${data.coverUri}|signature=$signature"
    }
}

class PlaylistImageKeyer : Keyer<PlaylistImage> {
    override fun key(data: PlaylistImage, options: Options): String? {
        return "playlist::id=${data.playlistEntity.playListId}" +
                "|customCoverUri=${data.playlistEntity.customCoverUri}" +
                "|songs=${data.songs.size}"
    }
}

class AutoGeneratedImageKeyer : Keyer<AutoGeneratedImage> {
    override fun key(
        data: AutoGeneratedImage,
        options: Options
    ): String? {
        return "auto-generated::type=${data.type}|id=${data.id}|songCount=${data.songCount}"
    }
}