package com.mardous.booming.coil.fetcher

import android.content.Context
import coil3.ImageLoader
import coil3.SingletonImageLoader
import coil3.decode.DataSource
import coil3.fetch.FetchResult
import coil3.fetch.Fetcher
import coil3.fetch.ImageFetchResult
import coil3.request.ImageRequest
import coil3.request.Options
import coil3.size.Size
import com.mardous.booming.coil.model.PlaylistImage
import com.mardous.booming.coil.util.AutoGeneratedImageUtil
import com.mardous.booming.data.local.room.PlaylistEntity

class PlaylistImageFetcher(
    private val context: Context,
    private val size: Size,
    private val image: PlaylistImage
) : Fetcher {

    private val playlistEntity = image.playlistEntity

    override suspend fun fetch(): FetchResult? {
        if (image.playlistEntity == PlaylistEntity.Empty) return null

        val customCoverUri = playlistEntity.customCoverUri
        val image = if (!customCoverUri.isNullOrEmpty()) {
            val result = SingletonImageLoader.get(context)
                .execute(
                    ImageRequest.Builder(context)
                        .data(customCoverUri)
                        .size(size)
                        .build()
                )

            // If custom cover fails to load, fall back to auto-generated
            result.image ?: AutoGeneratedImageUtil.getImage(context, image.songs)
        } else {
            // No custom cover, use auto-generated
            AutoGeneratedImageUtil.getImage(context, image.songs)
        } ?: return null

        return ImageFetchResult(
            image = image,
            isSampled = false,
            dataSource = DataSource.DISK
        )
    }

    class Factory : Fetcher.Factory<PlaylistImage> {
        override fun create(
            data: PlaylistImage,
            options: Options,
            imageLoader: ImageLoader
        ): Fetcher? {
            return PlaylistImageFetcher(options.context, options.size, data)
        }
    }
}