package com.mardous.booming.coil.fetcher

import android.content.Context
import coil3.ImageLoader
import coil3.decode.DataSource
import coil3.fetch.FetchResult
import coil3.fetch.Fetcher
import coil3.fetch.ImageFetchResult
import coil3.request.Options
import com.mardous.booming.coil.model.AutoGeneratedImage
import com.mardous.booming.coil.util.AutoGeneratedImageUtil
import com.mardous.booming.data.local.repository.Repository

class AutoGeneratedImageFetcher(
    private val context: Context,
    private val repository: Repository,
    private val image: AutoGeneratedImage,
) : Fetcher {

    override suspend fun fetch(): FetchResult? {
        if (image.id == -1L) return null

        val songs = when (image.type) {
            AutoGeneratedImage.TYPE_GENRE -> repository.songsByGenre(image.id)
            AutoGeneratedImage.TYPE_YEAR -> repository.songsByYear(image.id.toInt())
            else -> emptyList()
        }
        val image = AutoGeneratedImageUtil.getImage(context, songs)
            ?: return null

        return ImageFetchResult(
            image = image,
            isSampled = false,
            dataSource = DataSource.DISK
        )
    }

    class Factory(private val repository: Repository) : Fetcher.Factory<AutoGeneratedImage> {
        override fun create(
            data: AutoGeneratedImage,
            options: Options,
            imageLoader: ImageLoader
        ): Fetcher? {
            return AutoGeneratedImageFetcher(options.context, repository, data)
        }
    }
}