# Requested permissions

Booming Music requests the following permissions:

| Permission                   | Description                                                                                 | Android version |
|------------------------------|---------------------------------------------------------------------------------------------|-----------------|
| **READ\_MEDIA\_AUDIO**       | Allows access to audio files on the device. Required starting from Android 13.              | From 13         |
| **READ\_MEDIA\_IMAGES**      | Allows the app to read image files (such as album covers) stored on the device.             | From 13         |
| **POST\_NOTIFICATIONS**      | Required to show playback notifications on Android 13 or higher.                            | From 13         |
| **SCHEDULE\_EXACT\_ALARM**   | Allows the sleep timer to work with precision on Android 12 and above.                      | From 12         |
| **BLUETOOTH\_CONNECT**       | Replaces `BLUETOOTH` on Android 12+ for detecting and interacting with Bluetooth devices.   | From 12         |
| **READ\_EXTERNAL\_STORAGE**  | Needed to list music files on devices running Android 12 or lower.                          | Up to 12        |
| **BLUETOOTH**                | Used on Android 11 and below to detect Bluetooth devices (e.g., headphones) or share files. | Up to 11        |
| **WRITE\_SETTINGS**          | Needed to set a song as ringtone directly from the app.                                     | Up to 10        |
| **WRITE\_EXTERNAL\_STORAGE** | Required on older versions to fully access external storage.                                | Up to 10        |
| **FOREGROUND\_SERVICE**      | Allows the app to run a foreground service, essential for continuous playback.              | All             |
| **INTERNET**                 | Used to download artist images, artwork, lyrics, and check for updates.                     | All             |
| **ACCESS\_NETWORK\_STATE**   | Checks internet connection status before downloading content.                               | All             |
| **MODIFY\_AUDIO\_SETTINGS**  | Required to apply audio effects and control volume from within the app.                     | All             |
| **WAKE\_LOCK**               | Prevents the device from sleeping during playback.                                          | All             |

If you still have questions about the permissions requested by the app, or if we have missed placing any on this list, feel free to contact us through this email: mardous.contact@gmail.com