# Contributing

## About the issue tracker
First, I clarify that the [Issue Tracker](https://github.com/mardous/BoomingMusic/issues) is the preferred channel for bug reports and feature requests. I do this in order to keep everything centralized in one place, therefore, do not contact me by email for this purpose.

Secondly, everyone is welcome to the discussion as long as the following guidelines are met:

* Do not insult other users: avoid using offensive language when referring to others. You can review our [Code of Conduct](CODE_OF_CONDUCT.md) for more details on this.
* Avoid unnecessary comments: don't make comments that contain only a "+1" or a 👍, use GitHub Reactions for that.
* Don't open issues repeatedly just to try to get a response quickly. All issues will be addressed in due course by the devs or collaborators.

## Bug Reports
If you are interested in reporting bugs, thank you! Helping us find bugs is a great way to contribute.

Please note the following to open a report:

* Make sure the bug you want to report has not been previously discussed. You can use GitHub search for that, checking both open and closed issues. In case there is already an open issue for the same bug, you are welcome to participate in the discussion to provide more details.
* If the bug you noticed has not been reported, try to reproduce it using the most recent build.
* Try to show in detail the steps to reproduce the error. If possible, use screenshots or screen recordings for this purpose.
* Do not use the same issue to report multiple errors, even if they are similar or occur in common areas of the application. That would make everything more confusing.
* You should provide as many details as possible when opening the ticket. Try not to use comments to explain as you go as this would make it more difficult for devs and collaborators to understand the idea.

## Feature Requests
If you have an interesting proposal or there is something you think needs to be implemented, you are welcome to request it.

## Pull Requests
We will evaluate all pull requests we receive, however, take the following points into account:

* If the changes you want to implement change a large amount of code, it is preferable that you first open a "Feature Request" to discuss it, this way, if the implementation does not proceed, you will avoid wasting some of your time and effort.
* Each pull request you open must address a specific feature or point of the app. In other words, don't try to implement different functionalities or modify different parts of the app under the same PR.
* Pull requests that solve bugs or serious problems will always have higher priority than others.

## License
By contributing to this project:
* You agree that your contribution will be licensed under the terms of the [GNU General Public License](LICENSE.md).
* You have read and agreed to participate under the terms of our [Code of Conduct](CODE_OF_CONDUCT.md).
