# RF Analyzer 2.0 User Manual

<div style="display: flex; align-items: center; flex-wrap: wrap;">
  <div style="flex: 1; min-width: 250px;">
    <p>
      Welcome to the <b>RF Analyzer 2.0</b> user manual. This guide will help you to
      install, configure, and effectively use the app for spectrum analysis and
      signal demodulation.
    </p>
  </div>
  <div style="flex-shrink: 0; margin-left: 20px; margin-top: 10px;">
    <a href="https://play.google.com/store/apps/details?id=com.mantz_it.rfanalyzer">
      <img src="./assets/google_play_badge.png" style="max-width: 100%; height: auto; width: 200px;" alt="Get it on Google Play">
    </a>
  </div>
</div>

## Quick Start Tutorial (YouTube)

<div style="text-align: center;">
  <a target="_blank" href="https://www.youtube.com/watch?v=sui54fqbImw">
    <img src="./assets/RF Analyzer Quick Start Tutorial Thumbnail.png" style="max-width: 100%; height: auto; width: 400px; border: 2px solid #888; border-radius: 28px;" alt="YouTube Tutorial">
  </a>
</div>

## Features
- Real-time FFT & waterfall spectrum visualization
- Support for **HackRF, RTL-SDR, Airspy, HydraSDR and IQ file playback**
- Analog signal demodulation (CW, AM, nFM, wFM, LSB, USB)
- Adjustable SDR settings (frequency, gain, sample rate, etc.)
- Adjustable FFT settings (FFT size, averaging, peak hold, frame rate, etc.)
- Raw IQ recording and playback

<p float="left">
  <img src="./assets/rtlsdr_source_tab.png" width="45%" />
  <img src="./assets/rtlsdr_demodulation_tab_fm.png" width="45%" />
</p>

### New in RF Analyzer 2.0
- Complete rework of the app in a modern language (Kotlin) and with a modern Material Design based UI
- Demodulation can run as **background service** without a foreground app
- Significant performance improvements
- Built-in context-aware help and a full offline in-app manual
- Compatible with the RTL-SDR Blog v4

---

Refer to the [Quick Start](./quickstart.md) section for your first steps.

For information on how to install the app and connect your SDR device look into
the [Installation & Setup](./setup.md) section.

