package com.maksimowiczm.foodyou.importexport.domain.entity

/**
 * CSV header mapping for [ProductField]. Kept in the domain layer so both export and import UIs can
 * share a single source of truth.
 */
fun ProductField.csvHeader(): String =
    when (this) {
        ProductField.Name -> "Name"
        ProductField.Brand -> "Brand"
        ProductField.Barcode -> "Barcode"
        ProductField.Note -> "Note"
        ProductField.IsLiquid -> "Is Liquid"
        ProductField.PackageWeight -> "Package Weight (g)"
        ProductField.ServingWeight -> "Serving Weight (g)"
        ProductField.SourceUrl -> "Source URL"
        ProductField.Proteins -> "Proteins (g)"
        ProductField.Carbohydrates -> "Carbohydrates (g)"
        ProductField.Energy -> "Energy (kcal)"
        ProductField.Fats -> "Fats (g)"
        ProductField.SaturatedFats -> "Saturated Fats (g)"
        ProductField.TransFats -> "Trans Fats (g)"
        ProductField.MonounsaturatedFats -> "Monounsaturated Fats (g)"
        ProductField.PolyunsaturatedFats -> "Polyunsaturated Fats (g)"
        ProductField.Omega3 -> "Omega-3 (g)"
        ProductField.Omega6 -> "Omega-6 (g)"
        ProductField.Sugars -> "Sugars (g)"
        ProductField.AddedSugars -> "Added Sugars (g)"
        ProductField.DietaryFiber -> "Dietary Fiber (g)"
        ProductField.SolubleFiber -> "Soluble Fiber (g)"
        ProductField.InsolubleFiber -> "Insoluble Fiber (g)"
        ProductField.Salt -> "Salt (g)"
        ProductField.Cholesterol -> "Cholesterol (g)"
        ProductField.Caffeine -> "Caffeine (g)"
        ProductField.VitaminA -> "Vitamin A (g)"
        ProductField.VitaminB1 -> "Vitamin B1 (g)"
        ProductField.VitaminB2 -> "Vitamin B2 (g)"
        ProductField.VitaminB3 -> "Vitamin B3 (g)"
        ProductField.VitaminB5 -> "Vitamin B5 (g)"
        ProductField.VitaminB6 -> "Vitamin B6 (g)"
        ProductField.VitaminB7 -> "Vitamin B7 (g)"
        ProductField.VitaminB9 -> "Vitamin B9 (g)"
        ProductField.VitaminB12 -> "Vitamin B12 (g)"
        ProductField.VitaminC -> "Vitamin C (g)"
        ProductField.VitaminD -> "Vitamin D (g)"
        ProductField.VitaminE -> "Vitamin E (g)"
        ProductField.VitaminK -> "Vitamin K (g)"
        ProductField.Manganese -> "Manganese (g)"
        ProductField.Magnesium -> "Magnesium (g)"
        ProductField.Potassium -> "Potassium (g)"
        ProductField.Calcium -> "Calcium (g)"
        ProductField.Copper -> "Copper (g)"
        ProductField.Zinc -> "Zinc (g)"
        ProductField.Sodium -> "Sodium (g)"
        ProductField.Iron -> "Iron (g)"
        ProductField.Phosphorus -> "Phosphorus (g)"
        ProductField.Selenium -> "Selenium (g)"
        ProductField.Iodine -> "Iodine (g)"
        ProductField.Chromium -> "Chromium (g)"
    }
