package com.maksimowiczm.foodyou.common.compose.component

import androidx.compose.material3.LocalTextStyle
import androidx.compose.runtime.*
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.ParagraphStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.rememberTextMeasurer
import androidx.compose.ui.text.style.TextIndent
import androidx.compose.ui.text.withStyle

@Composable
fun unorderedList(items: List<String>, prefix: String = "\u2022\t\t") =
    unorderedList(*items.toTypedArray(), prefix = prefix)

@Composable
fun unorderedList(vararg items: String, prefix: String = "\u2022\t\t"): AnnotatedString {
    val textStyle = LocalTextStyle.current
    val textMeasurer = rememberTextMeasurer()
    val bulletStringWidth =
        remember(textStyle, textMeasurer) {
            textMeasurer.measure(text = prefix, style = textStyle).size.width
        }
    val restLine = with(LocalDensity.current) { bulletStringWidth.toSp() }
    val paragraphStyle = ParagraphStyle(textIndent = TextIndent(restLine = restLine))

    return buildAnnotatedString {
        items.forEach { text ->
            withStyle(style = paragraphStyle) {
                append(prefix)
                append(text)
            }
        }
    }
}
