package com.maksimowiczm.foodyou.changelog.infrastructure

import com.maksimowiczm.foodyou.changelog.domain.Changelog
import com.maksimowiczm.foodyou.changelog.domain.Version
import com.maksimowiczm.foodyou.common.config.AppConfig
import kotlinx.datetime.LocalDate

internal class StaticChangelog(private val appConfig: AppConfig) : Changelog {
    override val currentVersion: Version?
        get() = versions.firstOrNull { it.version == appConfig.versionName }

    override val versions: List<Version>
        get() =
            listOf(
                v_3_4_1,
                v_3_4_0,
                v_3_3_5,
                v_3_3_4,
                v_3_3_3,
                v_3_3_1,
                v_3_3_0,
                v_3_2_2,
                v_3_2_1,
                v_3_1_0,
                v_3_0_0,
                v_3_0_0_rc_2,
                v_3_0_0_rc_1,
                v_3_0_0_beta_3,
                v_3_0_0_beta_2,
                v_3_0_0_beta_1,
                v2_10_1,
                v2_10_0,
                v2_9_0,
                v2_8_0,
                v2_7_2,
                v2_7_1,
                v2_7_0,
                v2_6_0,
                v2_5_0,
                v2_4_0,
                v2_3_2,
                v2_3_1,
                v2_3_0,
                v2_2_0,
                v2_1_1,
                v2_1_0,
                v2_0_0,
            )

    val v_3_4_1 =
        Version(
            version = "3.4.1",
            date = LocalDate(2025, 12, 28),
            bugFixes = listOf("Fixed crash occurring while downloading from USDA FoodData Central."),
        )

    val v_3_4_0 =
        Version(
            version = "3.4.0",
            date = LocalDate(2025, 11, 15),
            newFeatures = listOf("Added a color picker for customizable themes."),
            changes =
                listOf(
                    "Renamed Database Developer Options to Database Backup and Restore and marked it as experimental.",
                    "Updated the About screen design.",
                    "Updated the design of the external food databases management screen.",
                    "Increased the Open Food Facts request timeout to 60 seconds.",
                ),
            bugFixes =
                listOf(
                    "Fixed an issue where the barcode scanner was focusing at infinity on some devices."
                ),
        )

    val v_3_3_5 =
        Version(
            version = "3.3.5",
            date = LocalDate(2025, 10, 28),
            newFeatures =
                listOf("Preserve search scroll position when switching between food sources."),
            bugFixes = listOf("Fixed unpacking recipes."),
        )

    val v_3_3_4 =
        Version(
            version = "3.3.4",
            date = LocalDate(2025, 10, 16),
            newFeatures = listOf("Added automatic column selection when importing CSV files."),
            bugFixes =
                listOf(
                    "Fixed partial matching for barcode searches.",
                    "Corrected invalid release date in 3.2.2 notes.",
                ),
        )

    val v_3_3_3 =
        Version(
            version = "3.3.3",
            date = LocalDate(2025, 10, 5),
            bugFixes = listOf("Searching with Cyrillic characters is now case-insensitive."),
        )

    val v_3_3_1 =
        Version(
            version = "3.3.1",
            date = LocalDate(2025, 10, 3),
            bugFixes =
                listOf(
                    "Fixed search to use substring matching (e.g., \"app\" now matches \"apple\")."
                ),
        )

    val v_3_3_0 =
        Version(
            version = "3.3.0",
            date = LocalDate(2025, 10, 2),
            newFeatures =
                listOf(
                    "Added database developer options (export and import the app database).",
                    "Improved food search results.",
                    "Added randomized themes (random theme at each app start).",
                ),
            bugFixes = listOf("Cleaned up duplicated sponsorships."),
        )

    val v_3_2_2 =
        Version(
            version = "3.2.2",
            date = LocalDate(2025, 9, 26),
            newFeatures = listOf("Use dynamic colors as default theme on Android 12+."),
            changes =
                listOf("Use GitHub Pages as sponsorship API.", "Updated Monero donation address."),
            bugFixes = listOf("Fix dynamic colors switch when default theme is selected."),
        )

    val v_3_2_1 =
        Version(
            version = "3.2.1",
            date = LocalDate(2025, 9, 21),
            newFeatures = listOf("Added fully customizable theme; it's now truly Material You."),
            changes =
                listOf(
                    "Transitioned to GPL-3.0 license.",
                    "Refreshed sponsors screen to use Material 3 Expressive.",
                    "Updated daily goals form behavior. Nutrient goals have been reset to default values (sorry for the inconvenience).",
                ),
            bugFixes =
                listOf(
                    "Fixed unexpected meal reordering after editing a meal.",
                    "Fixed button contrast issues on the food search screen.",
                ),
        )

    // 3.2.0 blocked by Google Play Protect as harmful
    // https://github.com/maksimowiczm/FoodYou/issues/265

    val v_3_1_0 =
        Version(
            version = "3.1.0",
            date = LocalDate(2025, 9, 10),
            newFeatures =
                listOf(
                    "Added quick add diary entry.",
                    "Added rate limiting for Open Food Facts API requests to prevent IP bans.",
                    "Added feature poll, vote for what should be built next.",
                ),
            changes = listOf("Updated recipe icon size in food lists."),
            bugFixes =
                listOf(
                    "Fix sponsor bubbles not displaying correctly for messages sent on the same day."
                ),
        )

    val v_3_0_0 =
        Version(
            version = "3.0.0",
            date = LocalDate(2025, 9, 1),
            newFeatures =
                listOf(
                    "Added in-app search integration for OpenFoodFacts and FoodData Central (USDA).",
                    "Added recent food list.",
                    "Added food product source.",
                    "Added food history, view when food was created or updated.",
                    "Added kilojoules support.",
                    "Added US ounces support.",
                    "Added SQLite database export.",
                    "Added onboarding.",
                    "Added sponsors list, thanks to everyone supporting the app financially. ❤️",
                    "Added recipe icon in food lists.",
                    "Added new goals handling. You can set goal for each nutrient and each weekday.",
                ),
            changes =
                listOf(
                    "BREAKING CHANGE Unlinked food diary from the food database.",
                    "Refreshed some UI components.",
                    "Updated Swiss Food Composition Database to v7.0.",
                    "Updated CSV import/export flow.",
                ),
        )

    val v_3_0_0_rc_2 =
        Version(
            version = "3.0.0-rc.2",
            date = LocalDate(2025, 8, 28),
            bugFixes =
                listOf(
                    "Resolved crashes when logging food for users upgrading from beta.1 or beta.2.",
                    "Fixed database migration issues on devices running Android 13 or lower.",
                    "Goals personalization: the daily goals settings button now correctly opens the goals settings screen.",
                    "Sharing links to the app now works as expected.",
                    "Editing meals now supports times past midnight.",
                    "Separate the brand name from the food name on meal cards.",
                    "Deleting food entries no longer breaks the recent food list.",
                    "Fixed the default measurement for recipes in the food search list.",
                ),
            translations =
                listOf("General translation updates and improvements. Thanks to all contributors!"),
            isPreview = true,
        )

    val v_3_0_0_rc_1 =
        Version(
            version = "3.0.0-rc.1",
            date = LocalDate(2025, 8, 17),
            newFeatures =
                listOf(
                    "Added CSV import and export support for food products.",
                    "Added support for US ounces as a measurement unit.",
                    "Added energy unit settings, kilojoules are now supported.",
                    "You can now navigate directly to an ingredient from the add entry screen.",
                    "Automatic switching between food sources during search.",
                    "Added new sponsorship methods.",
                ),
            bugFixes =
                listOf(
                    "Don't insert duplicate entries when searching Open Food Facts or FoodData Central (USDA).",
                    "Fixed incorrect measurements in recent recipes.",
                    "Invalid measurements are no longer shown for foods.",
                    "Food search queries are now case-insensitive.",
                    "Fixed crashes when updating from beta.1 or beta.2 to beta.3.",
                ),
            notes =
                "This is a preview version. Please don't report missing features, as this is still a work-in-progress.",
            isPreview = true,
        )

    val v_3_0_0_beta_3 =
        Version(
            version = "3.0.0-beta.3",
            date = LocalDate(2025, 8, 14),
            newFeatures =
                listOf(
                    "Unlinked food diary from the food database.",
                    "Added loading indicator to the Goals screen.",
                    "Added database export, you can now export the app database as a SQLite file.",
                ),
            changes =
                listOf(
                    "Added option to hide the preview release dialog.",
                    "Updated Translate button appearance.",
                    "Recipe icon is now always visible.",
                    "Goals screen progress tracks color now changes when the value is exceeded.",
                ),
            bugFixes =
                listOf(
                    "Prevented users from leaving the app while on boarding imports food.",
                    "Fixed date picker to work correctly in all time zones.",
                    "Creating a diary entry now shows the correct date.",
                    "Goals screen progress bars now capped at 200%.",
                ),
            notes =
                "This is a preview version. Please don't report missing features, as this is still a work-in-progress.",
            isPreview = true,
        )

    val v_3_0_0_beta_2 =
        Version(
            version = "3.0.0-beta.2",
            date = LocalDate(2025, 8, 3),
            newFeatures =
                listOf(
                    "Added incomplete foods list to the nutrients section.",
                    "Added daily goals.",
                ),
            changes =
                listOf(
                    "Recent foods can now be queried.",
                    "Recent foods now suggest the latest measurement for each item.",
                ),
            bugFixes =
                listOf("Fixed incorrect values displayed in the home screen meal card summary."),
            notes =
                """
                    This is a preview version. Please don't report missing features, as this is still a work-in-progress.
                """
                    .trimIndent(),
            isPreview = true,
        )

    val v_3_0_0_beta_1 =
        Version(
            version = "3.0.0-beta.1",
            date = LocalDate(2025, 7, 31),
            newFeatures =
                listOf(
                    "Added in-app search integration for OpenFoodFacts.",
                    "Added in-app search integration for FoodData Central (USDA).",
                    "Introduced sponsors screen to thank everyone supporting the app financially.",
                    "Implemented on boarding flow to let you choose which databases to use.",
                    "Added food source for each item.",
                    "Redesigned food search screen with filtering options.",
                ),
            changes =
                listOf(
                    "Refreshed food search.",
                    "Refreshed settings.",
                    "Refreshed measurement screen.",
                    "Refreshed product and recipe forms.",
                    "Simplified nutrition facts preferences: only reordering is allowed, hiding is no longer supported.",
                    "Changed default nutrition facts order to: proteins, fats, carbohydrates.",
                    "Updated Swiss Food Composition Database to version v7.0.",
                ),
            notes =
                """
                    This is a preview version. Please don't report missing features, as this is still a work-in-progress.
                """
                    .trimIndent(),
            isPreview = true,
        )

    val v2_10_1 =
        Version(
            version = "2.10.1",
            date = LocalDate(2025, 7, 16),
            bugFixes =
                listOf(
                    "Fixed search bar not working on the food search screen on Android 8.1 and below."
                ),
        )

    val v2_10_0 =
        Version(
            version = "2.10.0",
            date = LocalDate(2025, 7, 3),
            newFeatures =
                listOf(
                    "Added nutrition facts list size preference. You can now choose between compact and full sizes on the measurement screen.",
                    "Added food note. You can now add a note to a food, which will be displayed on the food measurement screen.",
                ),
            changes =
                listOf(
                    "Added background to the status bar on the food search screen.",
                    "The product form discard dialog will now appear only if the form has been modified (i.e., when the user makes a change).",
                ),
            bugFixes =
                listOf(
                    "Fixed an issue where the energy value was overridden when opening the product update form.",
                    "The app will now show the default measurement for serving and package if the food has no defined measurements.",
                ),
            translations = listOf("Added Catalan.", "Added Spanish."),
            notes = null,
        )

    val v2_9_0 =
        Version(
            version = "2.9.0",
            date = LocalDate(2025, 6, 18),
            newFeatures =
                listOf(
                    "Added donation screen. You can now support the app development by donating.",
                    "Added liquid food. You can now create and track liquid products and recipes.",
                    "Added personalization settings",
                    "Added nutrition facts personalization. You can now choose which nutrition facts to display and in what order within the app.",
                ),
            changes =
                listOf(
                    "Updated about screen",
                    "Move home settings to the personalize settings",
                    "Fixed monochrome icon",
                ),
            bugFixes = listOf(),
            translations = listOf(),
            notes = null,
        )

    val v2_8_0 =
        Version(
            version = "2.8.0",
            date = LocalDate(2025, 6, 13),
            newFeatures =
                listOf(
                    "Added recipe unpacking. You can now unpack recipe measurement into individual ingredients."
                ),
            bugFixes = listOf("Fixed an app crash when creating a new meal"),
            translations = listOf("Added Chinese Simplified"),
        )

    val v2_7_2 =
        Version(
            version = "2.7.2",
            date = LocalDate(2025, 6, 11),
            changes =
                listOf(
                    "Select latest measurement on the create measurement screen. Most of the time, this will be the same measurement as shown on the food search screen."
                ),
            bugFixes =
                listOf(
                    "Use proper measurement date when updating product measurement",
                    "Stop displaying deleted measurements",
                ),
        )

    val v2_7_1 =
        Version(
            version = "2.7.1",
            date = LocalDate(2025, 6, 10),
            newFeatures = listOf("App now supports Android 7.0 and above"),
            bugFixes =
                listOf(
                    "Fixed products export header, it will now write a valid CSV file",
                    "Fixed app crashes on some older Android version when migrating database to the new version",
                ),
        )

    val v2_7_0 =
        Version(
            version = "2.7.0",
            date = LocalDate(2025, 6, 10),
            newFeatures =
                listOf(
                    "Added new mineral - Chromium",
                    "Added FoodData Central (USDA) support. You can now download product data from new remote database.",
                    "Added Swiss Food Composition Database support",
                    "Added external databases settings screen to manage remote databases",
                ),
            bugFixes =
                listOf(
                    "Stop overriding calories value when updating product or downloading product data from remote databases"
                ),
            notes =
                "Even the best food tracking app is useless without a good database of food products. This update adds support for two new databases: FoodData Central (USDA) and the Swiss Food Composition Database.",
        )

    val v2_6_0 =
        Version(
            version = "2.6.0",
            date = LocalDate(2025, 6, 5),
            newFeatures =
                listOf("Recipe can now contain other recipes. Go easy on the recursion. 😉"),
            changes =
                listOf(
                    "Limit food search results to 100 items. If you need more results, please refine your search query.",
                    "Removed recipe clone feature",
                    "Updated toggle button in the food search screen",
                ),
            notes =
                "This update introduces a significant change to the recipe system, allowing recipes to include other recipes.",
        )

    val v2_5_0 =
        Version(
            version = "2.5.0",
            date = LocalDate(2025, 5, 29),
            newFeatures =
                listOf(
                    "Added a new screen for food measurement",
                    "Added crash handler to display a crash report screen when the app crashes",
                    "Added goals card settings",
                ),
            changes =
                listOf(
                    "Display the brand name after the product name",
                    "Updated barcode scanner icon",
                    "Updated recipe icon",
                    "Removed meal screen; all meal items are now displayed directly on the home screen",
                    "Renamed calories card to goals card",
                    "Reset home screen cards order. Default order is now Calendar, Goals, Meals",
                    "Reset meal cards layout; default is now vertical",
                    "Updated food search screen",
                ),
            bugFixes =
                listOf(
                    "Fixed empty recipes, app won't crash when the recipe has no ingredients",
                    "Fixed home settings back navigation; it now returns to settings instead of home screen",
                ),
            notes = null,
        )

    val v2_4_0 =
        Version(
            version = "2.4.0",
            date = LocalDate(2025, 5, 23),
            newFeatures =
                listOf(
                    "Added experimental support for importing and exporting food products via CSV file",
                    "Added copying recipe into product",
                ),
            changes =
                listOf(
                    "Updated meals cards settings layout picker",
                    "Updated settings screen",
                    "Use custom tabs for Open Food Facts links if available",
                ),
            bugFixes = listOf("Open valid recipe when editing entry in the meal screen"),
            translations = listOf("Added Dutch (Thanks to GrizzleNL)"),
            notes =
                "Since recipes can't contain other recipes for now, copying a recipe serves as a workaround. This is currently limited to the search screen and is expected to be replaced with proper recipe support in the future.",
        )

    val v2_3_2 =
        Version(
            version = "2.3.2",
            date = LocalDate(2025, 5, 19),
            newFeatures = listOf("Sort food by name and brand in the meal screen"),
            bugFixes =
                listOf(
                    "Fix food search sorting by name and brand. Stop taking letter case into account."
                ),
            translations = listOf("Added Hungarian", "Updated German"),
        )

    val v2_3_1 =
        Version(
            version = "2.3.1",
            date = LocalDate(2025, 5, 17),
            changes = listOf("Sort food by name and brand in the food search screen"),
            bugFixes =
                listOf(
                    "App won't crash when the user attempts to paste with an empty clipboard",
                    "Fix crashes when creating a new recipe",
                    "Display the correct suffix for calories in the product form",
                    "Move focus to the next field in barcode field in the product form",
                ),
            translations = listOf("Updated Italian"),
            notes =
                """
                    This is a hotfix release that addresses some issues with the previous version.
                """
                    .trimIndent(),
        )

    val v2_3_0 =
        Version(
            version = "2.3.0",
            date = LocalDate(2025, 5, 15),
            newFeatures =
                listOf(
                    "Add new nutrition facts, such as caffeine, vitamins, minerals, and more",
                    "Share Open Food Facts product URL to add it to the app",
                ),
            changes = listOf("Redesign the download product screen to be generic"),
            translations =
                listOf(
                    """Fix \' strings. It now displays correctly without escaping.""",
                    "Added French",
                    "Added Ukrainian",
                ),
            notes = "You can suggest new external databases to download products from on GitHub",
        )

    val v2_2_0 =
        Version(
            version = "2.2.0",
            date = LocalDate(2025, 5, 10),
            newFeatures =
                listOf(
                    "Home page customization, edit the home page to your liking",
                    "Meals cards customization, use vertical or horizontal layout",
                ),
            changes =
                listOf(
                    "Small visual adjustments made to the meal screen",
                    "Meals time-based ordering \"include all-day meals\" option changed to \"ignore all-day meals\". All-day meals are now included in the meal list by default.",
                ),
        )

    val v2_1_1 =
        Version(
            version = "2.1.1",
            date = LocalDate(2025, 4, 24),
            translations =
                listOf(
                    "Updated Arabic",
                    "Updated Danish",
                    "Updated German",
                    "Updated Italian",
                    "Updated Polish",
                    "Updated Portuguese (Brazilian)",
                    "Updated Russian",
                    "Updated Turkish",
                ),
        )

    val v2_1_0 =
        Version(
            version = "2.1.0",
            date = LocalDate(2025, 4, 22),
            newFeatures = listOf("Changelog", "Add Open Food Facts product manually"),
            changes =
                listOf(
                    "Remove Open Food Facts in-app search",
                    "Remove all unused Open Food Facts products",
                ),
            bugFixes =
                listOf(
                    "Product barcode can be edited in the product form",
                    "Display valid meal summary on the meal screen and cards",
                    "Don't crash on meal screen when there is more than one measurement with the same product in the meal",
                ),
            notes =
                """
                    Why was the Open Food Facts search removed?
                    It was removed because it wasn't working as expected. The search often caused confusion among users, as it frequently returned inaccurate or irrelevant results. This led to my decision to remove the in-app search feature altogether and replace it with a manual entry option. This isn't a rant against Open Food Facts, as it's a great and free project. To be fair, the app used the deprecated V1 API, which seems inadequate for a modern app.
                """
                    .trimIndent(),
        )

    val v2_0_0 =
        Version(
            version = "2.0.0",
            date = LocalDate(2025, 4, 14),
            newFeatures =
                listOf(
                    "Recipes",
                    "Open food facts global search",
                    "Delete unused open food facts products",
                    "Show remote database error details",
                    "Show warning dialog for incomplete translations when changing language",
                ),
            changes = listOf("Calorie summary won't display empty meals in filter chips"),
            bugFixes =
                listOf(
                    "Product form no longer crashes when requesting the next field on \"fats\" if the \"sugars\" field was hidden"
                ),
            translations = listOf("Added Portuguese (Brazilian)", "Added Russian", "Added Arabic"),
            notes =
                """
                    This release is marked as 2.0.0 because of significant source code changes that affect the overall structure of the app. The internal codebase has been heavily updated. The major version bump reflects these foundational changes.

                    Possible other unintended changes. If you notice something odd happening, please report it
                """
                    .trimIndent(),
        )
}
