package com.maksimowiczm.foodyou.app.ui.language

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Translate
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier
import foodyou.app.generated.resources.*
import org.jetbrains.compose.resources.stringResource

@Composable
internal fun LanguageWarningDialog(
    onDismissRequest: () -> Unit,
    onConfirm: () -> Unit,
    modifier: Modifier = Modifier,
) {
    AlertDialog(
        onDismissRequest = onDismissRequest,
        modifier = modifier,
        confirmButton = {
            TextButton(onClick = onConfirm) { Text(stringResource(Res.string.positive_ok)) }
        },
        icon = { Icon(imageVector = Icons.Default.Translate, contentDescription = null) },
        text = { Text(stringResource(Res.string.description_translation_warning)) },
    )
}
