package com.maksimowiczm.foodyou.app.ui.database.master

import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Archive
import androidx.compose.material.icons.outlined.CloudDownload
import androidx.compose.material.icons.outlined.FileOpen
import androidx.compose.material3.Icon
import androidx.compose.material3.LargeFlexibleTopAppBar
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import com.maksimowiczm.foodyou.app.ui.common.component.ArrowBackIconButton
import com.maksimowiczm.foodyou.app.ui.common.component.SettingsListItem
import foodyou.app.generated.resources.*
import org.jetbrains.compose.resources.painterResource
import org.jetbrains.compose.resources.stringResource

@Composable
fun DatabaseSettingsScreen(
    onBack: () -> Unit,
    onExternalDatabases: () -> Unit,
    onImportCsvProducts: () -> Unit,
    onExportCsvProducts: () -> Unit,
    onDatabaseBackup: () -> Unit,
    modifier: Modifier = Modifier,
) {
    val scrollBehavior = TopAppBarDefaults.exitUntilCollapsedScrollBehavior()
    Scaffold(
        modifier = modifier,
        topBar = {
            LargeFlexibleTopAppBar(
                title = { Text(stringResource(Res.string.headline_database)) },
                subtitle = { Text(stringResource(Res.string.description_manage_database)) },
                navigationIcon = { ArrowBackIconButton(onBack) },
                scrollBehavior = scrollBehavior,
            )
        },
    ) { paddingValues ->
        LazyColumn(
            modifier = Modifier.fillMaxSize().nestedScroll(scrollBehavior.nestedScrollConnection),
            contentPadding = paddingValues,
        ) {
            item { ExternalDatabasesSettingsListItem(onExternalDatabases) }
            item { ImportCsvProductsSettingsListItem(onImportCsvProducts) }
            item { ExportCsvProductsSettingsListItem(onExportCsvProducts) }
            item { DatabaseBackup(onDatabaseBackup) }
        }
    }
}

@Composable
private fun ExternalDatabasesSettingsListItem(onClick: () -> Unit, modifier: Modifier = Modifier) {
    SettingsListItem(
        icon = { Icon(imageVector = Icons.Outlined.CloudDownload, contentDescription = null) },
        label = { Text(stringResource(Res.string.headline_external_databases)) },
        supportingContent = { Text(stringResource(Res.string.description_external_databases)) },
        onClick = onClick,
        modifier = modifier,
    )
}

@Composable
private fun ImportCsvProductsSettingsListItem(onClick: () -> Unit, modifier: Modifier = Modifier) {
    SettingsListItem(
        icon = { Icon(Icons.Outlined.FileOpen, null) },
        label = { Text(stringResource(Res.string.action_import_csv_food_products)) },
        supportingContent = {
            Text(stringResource(Res.string.description_import_csv_food_products))
        },
        onClick = onClick,
        modifier = modifier,
    )
}

@Composable
private fun ExportCsvProductsSettingsListItem(onClick: () -> Unit, modifier: Modifier = Modifier) {
    SettingsListItem(
        icon = { Icon(painterResource(Res.drawable.ic_file_export), null) },
        label = { Text(stringResource(Res.string.action_export_csv_food_products)) },
        supportingContent = {
            Text(stringResource(Res.string.description_export_csv_food_products))
        },
        onClick = onClick,
        modifier = modifier,
    )
}

@Composable
private fun DatabaseBackup(onClick: () -> Unit, modifier: Modifier = Modifier) {
    SettingsListItem(
        icon = { Icon(Icons.Outlined.Archive, null) },
        label = { Text(stringResource(Res.string.headline_database_backup)) },
        onClick = onClick,
        modifier = modifier,
    )
}
