package com.maksimowiczm.foodyou.food.infrastructure.common

import com.maksimowiczm.foodyou.food.domain.NutrientValue.Companion.toNutrientValue
import com.maksimowiczm.foodyou.food.domain.NutritionFacts

class NutrientsMapper {
    fun toNutritionFats(entity: NutrientsEntity): NutritionFacts =
        NutritionFacts.requireAll(
            proteins = entity.proteins.toNutrientValue(),
            carbohydrates = entity.carbohydrates.toNutrientValue(),
            energy = entity.energy.toNutrientValue(),
            fats = entity.fats.toNutrientValue(),
            saturatedFats = entity.saturatedFats.toNutrientValue(),
            transFats = entity.transFats.toNutrientValue(),
            monounsaturatedFats = entity.monounsaturatedFats.toNutrientValue(),
            polyunsaturatedFats = entity.polyunsaturatedFats.toNutrientValue(),
            omega3 = entity.omega3.toNutrientValue(),
            omega6 = entity.omega6.toNutrientValue(),
            sugars = entity.sugars.toNutrientValue(),
            addedSugars = entity.addedSugars.toNutrientValue(),
            dietaryFiber = entity.dietaryFiber.toNutrientValue(),
            solubleFiber = entity.solubleFiber.toNutrientValue(),
            insolubleFiber = entity.insolubleFiber.toNutrientValue(),
            salt = entity.salt.toNutrientValue(),
            cholesterol = entity.cholesterol.toNutrientValue(),
            caffeine = entity.caffeine.toNutrientValue(),
            vitaminA = entity.vitaminA.toNutrientValue(),
            vitaminB1 = entity.vitaminB1.toNutrientValue(),
            vitaminB2 = entity.vitaminB2.toNutrientValue(),
            vitaminB3 = entity.vitaminB3.toNutrientValue(),
            vitaminB5 = entity.vitaminB5.toNutrientValue(),
            vitaminB6 = entity.vitaminB6.toNutrientValue(),
            vitaminB7 = entity.vitaminB7.toNutrientValue(),
            vitaminB9 = entity.vitaminB9.toNutrientValue(),
            vitaminB12 = entity.vitaminB12.toNutrientValue(),
            vitaminC = entity.vitaminC.toNutrientValue(),
            vitaminD = entity.vitaminD.toNutrientValue(),
            vitaminE = entity.vitaminE.toNutrientValue(),
            vitaminK = entity.vitaminK.toNutrientValue(),
            manganese = entity.manganese.toNutrientValue(),
            magnesium = entity.magnesium.toNutrientValue(),
            potassium = entity.potassium.toNutrientValue(),
            calcium = entity.calcium.toNutrientValue(),
            copper = entity.copper.toNutrientValue(),
            zinc = entity.zinc.toNutrientValue(),
            sodium = entity.sodium.toNutrientValue(),
            iron = entity.iron.toNutrientValue(),
            phosphorus = entity.phosphorus.toNutrientValue(),
            selenium = entity.selenium.toNutrientValue(),
            iodine = entity.iodine.toNutrientValue(),
            chromium = entity.chromium.toNutrientValue(),
        )

    fun toNutrientsEntity(nutrients: NutritionFacts): NutrientsEntity =
        NutrientsEntity(
            proteins = nutrients.proteins.value,
            carbohydrates = nutrients.carbohydrates.value,
            energy = nutrients.energy.value,
            fats = nutrients.fats.value,
            saturatedFats = nutrients.saturatedFats.value,
            transFats = nutrients.transFats.value,
            monounsaturatedFats = nutrients.monounsaturatedFats.value,
            polyunsaturatedFats = nutrients.polyunsaturatedFats.value,
            omega3 = nutrients.omega3.value,
            omega6 = nutrients.omega6.value,
            sugars = nutrients.sugars.value,
            addedSugars = nutrients.addedSugars.value,
            dietaryFiber = nutrients.dietaryFiber.value,
            solubleFiber = nutrients.solubleFiber.value,
            insolubleFiber = nutrients.insolubleFiber.value,
            salt = nutrients.salt.value,
            cholesterol = nutrients.cholesterol.value,
            caffeine = nutrients.caffeine.value,
            vitaminA = nutrients.vitaminA.value,
            vitaminB1 = nutrients.vitaminB1.value,
            vitaminB2 = nutrients.vitaminB2.value,
            vitaminB3 = nutrients.vitaminB3.value,
            vitaminB5 = nutrients.vitaminB5.value,
            vitaminB6 = nutrients.vitaminB6.value,
            vitaminB7 = nutrients.vitaminB7.value,
            vitaminB9 = nutrients.vitaminB9.value,
            vitaminB12 = nutrients.vitaminB12.value,
            vitaminC = nutrients.vitaminC.value,
            vitaminD = nutrients.vitaminD.value,
            vitaminE = nutrients.vitaminE.value,
            vitaminK = nutrients.vitaminK.value,
            manganese = nutrients.manganese.value,
            magnesium = nutrients.magnesium.value,
            potassium = nutrients.potassium.value,
            calcium = nutrients.calcium.value,
            copper = nutrients.copper.value,
            zinc = nutrients.zinc.value,
            sodium = nutrients.sodium.value,
            iron = nutrients.iron.value,
            phosphorus = nutrients.phosphorus.value,
            selenium = nutrients.selenium.value,
            iodine = nutrients.iodine.value,
            chromium = nutrients.chromium.value,
        )
}
