// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Simple, local, material design notes';

  @override
  String app_about(String appName) {
    return '$appName is a text-based note-taking application, aimed at simplicity. It embraces Material Design. It stores the notes locally and doesn\'t have any internet permissions, so you are the only one that can access the notes.';
  }

  @override
  String get error_snack_bar => 'Error:';

  @override
  String get error_widget_title => 'An error has occurred.';

  @override
  String get error_widget_description =>
      'Please report this issue on GitHub or via mail. Attach a screenshot of this page and the logs that you can copy or export below. As a precaution, you should also export your notes.';

  @override
  String get error_widget_disabled_secure_flag =>
      'The setting to flag the app as secure is disabled until the next restart to enable screenshots.';

  @override
  String get error_widget_button_export_notes => 'Export notes';

  @override
  String get error_widget_button_copy_logs => 'Copy logs';

  @override
  String get error_widget_button_export_logs => 'Export logs';

  @override
  String get error_widget_button_create_github_issue => 'Create GitHub issue';

  @override
  String get error_widget_button_send_mail => 'Send mail';

  @override
  String get navigation_notes => 'Notes';

  @override
  String get navigation_manage_labels_destination => 'Manage tags';

  @override
  String get navigation_manage_labels_page => 'Tags';

  @override
  String get navigation_archives => 'Archives';

  @override
  String get navigation_bin => 'Bin';

  @override
  String get navigation_settings => 'Settings';

  @override
  String get navigation_settings_appearance => 'Appearance';

  @override
  String get navigation_settings_notes_types => 'Notes types';

  @override
  String get navigation_settings_notes_tiles => 'Notes tiles';

  @override
  String get navigation_settings_behavior => 'Behavior';

  @override
  String get navigation_settings_editor => 'Editor';

  @override
  String get navigation_settings_labels => 'Tags';

  @override
  String get navigation_settings_backup => 'Backup';

  @override
  String get navigation_settings_security => 'Security';

  @override
  String get navigation_settings_accessibility => 'Accessibility';

  @override
  String get navigation_settings_help => 'Help';

  @override
  String get navigation_settings_about => 'About';

  @override
  String get button_sort_title => 'Title';

  @override
  String get button_sort_ascending => 'Ascending';

  @override
  String get settings_page_appearance => 'Appearance';

  @override
  String get settings_page_appearance_description => 'Language, theming, fonts';

  @override
  String get settings_language => 'Language';

  @override
  String get settings_language_contribute => 'Contribute';

  @override
  String get settings_appearance_section_theming => 'Theming';

  @override
  String get settings_theme => 'Theme';

  @override
  String get settings_theme_system => 'System';

  @override
  String get settings_theme_light => 'Light';

  @override
  String get settings_theme_dark => 'Dark';

  @override
  String get settings_dynamic_theming => 'Dynamic theming';

  @override
  String get settings_dynamic_theming_description => 'Generate colors from the system';

  @override
  String get settings_black_theming => 'Black theming';

  @override
  String get settings_black_theming_description => 'Use a black background in dark mode';

  @override
  String get settings_appearance_section_fonts => 'Fonts';

  @override
  String get settings_app_font => 'App font';

  @override
  String get settings_app_font_description =>
      'Font used for all the texts in the application, except in the notes editor';

  @override
  String get settings_editor_font => 'Editor font';

  @override
  String get settings_editor_font_description => 'Font used only for the text in the notes editor';

  @override
  String get settings_page_notes_tiles => 'Notes tiles';

  @override
  String get settings_page_notes_tiles_description => 'Appearance, content';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Appearance';

  @override
  String get settings_page_notes_tiles_content_section => 'Content';

  @override
  String get settings_show_tiles_background => 'Background';

  @override
  String get settings_show_tiles_background_description => 'Show the background of the notes tiles';

  @override
  String get settings_show_separators => 'Separators';

  @override
  String get settings_show_separators_description => 'Show a separator between the notes tiles';

  @override
  String get settings_show_note_type_icon => 'Show type icon';

  @override
  String get settings_show_note_type_icon_description => 'Show the icon of the type of the note';

  @override
  String get settings_show_titles_only => 'Titles only';

  @override
  String get settings_show_titles_only_description => 'Only show the titles of the notes';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Disable titles only in search view';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Disable the option to only show the titles when in the search view';

  @override
  String get settings_content_preview_max_lines => 'Maximum preview lines';

  @override
  String get settings_content_preview_max_lines_description => 'Maximum number of lines of the content preview to show';

  @override
  String get settings_behavior => 'Behavior';

  @override
  String get settings_behavior_description => 'Confirmations, swipe actions';

  @override
  String get settings_behavior_application => 'Application';

  @override
  String get settings_confirmations => 'Confirmation dialog';

  @override
  String get settings_confirmations_description =>
      'When to show a confirmation dialog when performing an action on a note';

  @override
  String get settings_confirmations_title_none => 'Never';

  @override
  String get settings_confirmations_title_irreversible => 'Irreversible actions only';

  @override
  String get settings_confirmations_title_all => 'Always';

  @override
  String get settings_auto_remove_from_bin_title => 'Auto remove from bin';

  @override
  String get settings_auto_remove_from_bin_description => 'Automatically remove notes from the bin';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'After 1 week',
      '14': 'After 2 weeks',
      '30': 'After 1 month',
      '90': 'After 3 months',
      '180': 'After 6 month',
      '365': 'After 1 year',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Swipe actions';

  @override
  String get settings_behavior_swipe_actions_archives => 'Swipe actions (archives)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Swipe actions (bin)';

  @override
  String get settings_swipe_action_right => 'Right swipe action';

  @override
  String get settings_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a note tile';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a note tile in the bin';

  @override
  String get settings_swipe_action_left => 'Left swipe action';

  @override
  String get settings_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a note tile';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a note tile in the bin';

  @override
  String get settings_page_notes_types => 'Notes types';

  @override
  String get settings_page_notes_types_description => 'Types to use, rich text';

  @override
  String get settings_section_types_to_use => 'Types to use';

  @override
  String get settings_available_notes_types => 'Available notes types';

  @override
  String get settings_available_notes_types_description =>
      'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally';

  @override
  String get settings_available_default_share_type => 'Default share type';

  @override
  String get settings_available_default_share_type_description =>
      'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button';

  @override
  String get settings_editor => 'Editor';

  @override
  String get settings_editor_description => 'Behavior';

  @override
  String get settings_editor_behavior => 'Behavior';

  @override
  String get settings_show_editor_mode_button => 'Editor mode button';

  @override
  String get settings_show_editor_mode_button_description =>
      'Enable the button to toggle the editor between editing mode and reading mode';

  @override
  String get settings_open_editor_reading_mode => 'Open in reading mode';

  @override
  String get settings_open_editor_reading_mode_description => 'Open the editor in reading mode by default';

  @override
  String get settings_focus_title_on_new_note => 'Focus the title';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Focus the title instead of the content when creating a new note';

  @override
  String get settings_editor_appearance => 'Appearance';

  @override
  String get settings_toolbar_style_title => 'Toolbar style';

  @override
  String get settings_toolbar_style_description => 'The style of the toolbar of the rich text editor';

  @override
  String get settings_use_paragraph_spacing => 'Paragraph spacing';

  @override
  String get settings_use_paragraph_spacing_description => 'Use spacing between paragraphs';

  @override
  String get settings_labels => 'Tags';

  @override
  String get settings_labels_description => 'Enable, appearance';

  @override
  String get settings_enable_labels => 'Enable';

  @override
  String get settings_enable_labels_description =>
      'Allow to categorize the notes with tags (disabling it doesn\'t delete tags nor remove them from the notes, it only hides them)';

  @override
  String get settings_labels_appearance => 'Appearance';

  @override
  String get settings_show_labels_note_tile => 'Show tags on note tile';

  @override
  String get settings_show_labels_note_tile_description => 'Show the list of tags of the note tiles';

  @override
  String get settings_show_labels_editor => 'Show tags in editor';

  @override
  String get settings_show_labels_editor_description => 'Show the list of tags at the bottom of the editor';

  @override
  String get settings_labels_section_behavior => 'Behavior';

  @override
  String get settings_labels_swipe_action_right => 'Right swipe action';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Action to trigger when a right swipe is performed on a label tile';

  @override
  String get settings_labels_swipe_action_left => 'Left swipe action';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Action to trigger when a left swipe is performed on a label tile';

  @override
  String get settings_backup => 'Backup';

  @override
  String get settings_backup_description => 'Manual and automatic export, encryption, import';

  @override
  String get settings_backup_import => 'Import';

  @override
  String get settings_import => 'Import';

  @override
  String get settings_import_description => 'Import notes, tags and settings from a JSON file';

  @override
  String get settings_backup_manual_export => 'Manual export';

  @override
  String get settings_export_json => 'Export as JSON';

  @override
  String get settings_export_json_description =>
      'Immediately export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_export_markdown => 'Export as Markdown';

  @override
  String get settings_export_markdown_description => 'Immediately export all the notes to a Markdown file';

  @override
  String get settings_backup_auto_export => 'Automatic export';

  @override
  String get settings_auto_export => 'Automatic export';

  @override
  String get settings_auto_export_description =>
      'Automatically export all the notes, tags and settings to a JSON file that can be imported back';

  @override
  String get settings_auto_export_frequency => 'Frequency';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'day',
      '7': 'week',
      '14': '2 weeks',
      '30': 'month',
      'other': '',
    });
    return 'Every $_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Frequency of the automatic export';

  @override
  String get settings_auto_export_encryption => 'Encryption';

  @override
  String get settings_auto_export_encryption_description =>
      'Encrypt the title and the content of the notes with a password';

  @override
  String get settings_auto_export_directory => 'Directory';

  @override
  String get settings_auto_export_directory_description => 'Directory where to store the automatic exports';

  @override
  String get settings_security => 'Security';

  @override
  String get settings_security_description => 'Secure flag, application lock, note lock';

  @override
  String get settings_security_application => 'Application';

  @override
  String get settings_security_application_lock => 'Application lock';

  @override
  String get settings_security_note_lock => 'Note lock';

  @override
  String get settings_flag_secure => 'Flag the app as secure';

  @override
  String get settings_flag_secure_description =>
      'Hide the app from the recent apps and prevent screenshots from being made';

  @override
  String get settings_application_lock_title => 'Lock';

  @override
  String get settings_application_lock_description =>
      'Lock the application and require to authenticate with the device to unlock it';

  @override
  String get settings_application_lock_delay_title => 'Lock delay';

  @override
  String get settings_application_lock_delay_description =>
      'Delay after which the application locks itself when moved to the background';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Immediately',
      '3': 'After 3 seconds',
      '5': 'After 5 seconds',
      '10': 'After 10 seconds',
      '30': 'After 30 seconds',
      '60': 'After 1 minute',
      '120': 'After 2 minutes',
      '300': 'After 5 minutes',
      'other': 'Never',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Note lock';

  @override
  String get settings_note_lock_description =>
      'Lock the note and require to authenticate with the device to view and edit it';

  @override
  String get settings_label_lock_title => 'Tag lock';

  @override
  String get settings_label_lock_description =>
      'Lock the tag and require to authenticate with the device to view and edit any note that contains it';

  @override
  String get settings_note_lock_delay_title => 'Lock delay';

  @override
  String get settings_note_lock_delay_description =>
      'Delay after which the note locks itself when the application is moved to the background';

  @override
  String get settings_accessibility => 'Accessibility';

  @override
  String get settings_accessibility_text_size => 'Text size';

  @override
  String get settings_accessibility_text_color => 'Text color';

  @override
  String get settings_accessibility_description => 'Text color, text scaling';

  @override
  String get settings_text_scaling => 'Text scaling';

  @override
  String get settings_bigger_titles => 'Bigger titles';

  @override
  String get settings_bigger_titles_description => 'Show bigger titles on the the notes tiles and in the editor';

  @override
  String get settings_white_text_dark_mode => 'White text in dark mode';

  @override
  String get settings_white_text_dark_mode_description => 'Use a white color for the text in dark mode';

  @override
  String get settings_disable_subdued_note_content_preview => 'Non-subdued preview';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Disable the subdued text color of the notes content preview';

  @override
  String get settings_help_section_contact => 'Contact';

  @override
  String get settings_github_issues => 'Report a bug or request a feature';

  @override
  String get settings_github_issues_description => 'Report a bug or request a feature by creating a GitHub issue';

  @override
  String get settings_github_discussions => 'Ask a question';

  @override
  String get settings_github_discussions_description => 'Ask a question on GitHub discussions';

  @override
  String get settings_contact_developer => 'Contact the developer';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Contact the developer via mail at $email';
  }

  @override
  String get settings_help => 'Help';

  @override
  String get settings_help_description => 'Contact, logs';

  @override
  String get settings_help_section_logs => 'Logs';

  @override
  String get settings_copy_logs => 'Copy the logs';

  @override
  String get settings_copy_logs_description => 'Copy the logs of the application to the clipboard';

  @override
  String get settings_export_logs => 'Export the logs';

  @override
  String get settings_export_logs_description => 'Export the logs of the application to a text file';

  @override
  String get settings_about => 'About';

  @override
  String get settings_about_description => 'Information, links, donate';

  @override
  String get settings_about_application => 'Application';

  @override
  String get settings_build_mode => 'Build mode';

  @override
  String get settings_build_mode_release => 'Release';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Links';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Take a look at the source code';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Add or improve the localizations on the Crowdin project';

  @override
  String get settings_licence => 'License';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Donate';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Title';

  @override
  String get hint_content => 'Note';

  @override
  String get hint_link => 'Link';

  @override
  String get hint_label_name => 'Name';

  @override
  String get dialog_export_encryption_password => 'Password';

  @override
  String get dialog_select_labels => 'Select tags';

  @override
  String get dialog_select_labels_to_add => 'Select tags to add';

  @override
  String get tooltip_undo => 'Undo the last action';

  @override
  String get tooltip_redo => 'Redo the last action';

  @override
  String get tooltip_fab_add_note => 'Add a note';

  @override
  String get tooltip_fab_add_plain_text_note => 'Add a plain text note';

  @override
  String get tooltip_fab_add_markdown_note => 'Add a markdown note';

  @override
  String get tooltip_fab_add_rich_text_note => 'Add a rich text note';

  @override
  String get tooltip_fab_add_checklist_note => 'Add a checklist note';

  @override
  String get tooltip_fab_add_label => 'Add a tag';

  @override
  String get tooltip_fab_empty_bin => 'Empty the bin';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Switch to editing mode';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Switch to reading mode';

  @override
  String get tooltip_layout_list => 'List view';

  @override
  String get tooltip_layout_grid => 'Grid view';

  @override
  String get tooltip_sort => 'Sort the notes';

  @override
  String get tooltip_search => 'Search the notes';

  @override
  String get tooltip_unselect_all => 'Unselect all';

  @override
  String get tooltip_reset => 'Reset';

  @override
  String get dialog_add_link => 'Add a link';

  @override
  String get dialog_archive => 'Archive';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to archive $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Unarchive';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to unarchive $count $_temp0?';
  }

  @override
  String get dialog_delete => 'Delete';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to delete $count $_temp0? You can restore $_temp1 from the bin.';
  }

  @override
  String get dialog_permanently_delete => 'Delete permanently';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to permanently delete $count $_temp0? You will not be able to restore $_temp1.';
  }

  @override
  String get dialog_restore => 'Restore';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Do you really want to restore $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Empty the bin';

  @override
  String get dialog_empty_bin_body =>
      'Do you really want to permanently empty the bin? You will not be able to restore the notes it contains.';

  @override
  String get dialog_delete_label => 'Delete';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'tags', one: 'tag');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'They', one: 'It');
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: 'them', one: 'it');
    return 'Do you really want to delete $count $_temp0? $_temp1 will be removed from the notes where you added $_temp2.';
  }

  @override
  String get dialog_export_encryption_switch => 'Encrypt the JSON export';

  @override
  String get dialog_export_encryption_description =>
      'The title and the content of the notes will be encrypted using your password. It should be randomly generated, exactly 32 characters long, strong (at least 1 lowercase, 1 uppercase, 1 number and 1 special character) and securely stored.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'This password will be used for all future automatic exports.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'This password will only be used for this export.';

  @override
  String get dialog_export_encryption_password_invalid => 'Invalid';

  @override
  String get dialog_import_encryption_password_description =>
      'This export is encrypted. To import it, you need to provide the password used to encrypt it.';

  @override
  String get dialog_import_encryption_password_error =>
      'the decrypting of the export failed. Please check that you provided the same password that the one you used for encrypting the export.';

  @override
  String get dialog_label_add => 'Add tag';

  @override
  String get dialog_label_edit => 'Edit tag';

  @override
  String get dialog_label_name_cannot_be_empty => 'The name cannot be empty.';

  @override
  String get dialog_label_name_already_used => 'This name is already used.';

  @override
  String get button_sort_creation_date => 'Creation date';

  @override
  String get button_sort_edition_date => 'Edition date';

  @override
  String get placeholder_notes => 'No notes';

  @override
  String get placeholder_labels => 'No tags';

  @override
  String get placeholder_archives => 'No archived notes';

  @override
  String get placeholder_bin => 'No deleted notes';

  @override
  String get action_disabled => 'Disabled';

  @override
  String get action_toggle_pin => 'Toggle pins';

  @override
  String get action_pin_unpin => 'Pin / Unpin';

  @override
  String get action_pin => 'Pin';

  @override
  String get action_unpin => 'Unpin';

  @override
  String get action_toggle_lock => 'Toggle lock';

  @override
  String get action_lock_unlock => 'Lock / Unlock';

  @override
  String get action_lock => 'Lock';

  @override
  String get action_unlock => 'Unlock';

  @override
  String get action_share => 'Share';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return '$count $_temp0 shared from Material Notes';
  }

  @override
  String get action_archive => 'Archive';

  @override
  String get action_unarchive => 'Unarchive';

  @override
  String get action_delete => 'Delete';

  @override
  String get action_restore => 'Restore';

  @override
  String get action_delete_permanently => 'Delete permanently';

  @override
  String get action_about => 'About';

  @override
  String get about_last_edited => 'Last edited';

  @override
  String get about_type => 'Type';

  @override
  String get about_created => 'Created';

  @override
  String get about_labels => 'Tags';

  @override
  String get about_words => 'Words';

  @override
  String get about_characters => 'Characters';

  @override
  String get about_time_at => 'at';

  @override
  String get menu_action_select_labels => 'Tags';

  @override
  String get menu_action_add_labels => 'Add tags';

  @override
  String get action_labels_toggle_visibile => 'Toggle visibility';

  @override
  String get action_labels_show_hide => 'Show / Hide';

  @override
  String get action_labels_show => 'Show';

  @override
  String get action_labels_hide => 'Hide';

  @override
  String get action_labels_toggle_pins => 'Toggle pins';

  @override
  String get action_labels_pin_unpin => 'Pin / Unpin';

  @override
  String get action_labels_pin => 'Pin';

  @override
  String get action_labels_unpin => 'Unpin';

  @override
  String get action_labels_toggle_lock => 'Toggle lock';

  @override
  String get action_labels_lock_unlock => 'Lock / Unlock';

  @override
  String get action_labels_lock => 'Lock';

  @override
  String get action_labels_unlock => 'Unlock';

  @override
  String get action_labels_edit => 'Edit';

  @override
  String get action_labels_delete => 'Delete';

  @override
  String get filter_labels_all => 'All';

  @override
  String get filter_labels_visible => 'Visible';

  @override
  String get filter_labels_hidden => 'Hidden';

  @override
  String get filter_labels_pinned => 'Pinned';

  @override
  String get filter_labels_locked => 'Locked';

  @override
  String get snack_bar_authentication_failed => 'The authentication failed, please try again.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 archived';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 unarchived';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 deleted';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes were', one: 'note was');
    return 'The $_temp0 restored';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notes', one: 'note');
    return 'Content of the $_temp0 copied to the clipboard.';
  }

  @override
  String get snack_bar_import_success => 'The backup was successfully imported.';

  @override
  String get snack_bar_export_success => 'The backup were successfully exported.';

  @override
  String get snack_bar_logs_copied => 'The logs were copied to your clipboard.';

  @override
  String get snack_bar_logs_exported => 'The logs were successfully exported.';

  @override
  String get snack_bar_no_labels => 'There are no tags.';

  @override
  String get quick_action_add_plain_text_note_title => 'Add a plain text note';

  @override
  String get quick_action_add_markdown_note_title => 'Add a markdown note';

  @override
  String get quick_action_add_rich_text_note_title => 'Add a rich text note';

  @override
  String get quick_action_add_checklist_note_title => 'Add a checklist note';

  @override
  String get welcome_note_title => 'Welcome to Material Notes!';

  @override
  String get welcome_note_content => 'Simple, local, material design notes';

  @override
  String get font_system_default => 'System default';

  @override
  String get note_type_plain_text => 'Plain text';

  @override
  String get note_type_markdown => 'Markdown';

  @override
  String get note_type_rich_text => 'Rich text';

  @override
  String get note_type_checklist => 'Checklist';

  @override
  String get lock_page_reason_app => 'Unlock Material Notes';

  @override
  String get lock_page_reason_note => 'Unlock this note';

  @override
  String get lock_page_reason_action => 'Authorize this action';

  @override
  String get lock_page_description_app => 'The application is locked.';

  @override
  String get lock_page_description_note => 'This note is locked.';

  @override
  String get lock_page_unlock => 'Unlock';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Foreground color';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Background color';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Foreground color';

  @override
  String get toolbar_style_one_row_simple_title => 'One row (simple options)';

  @override
  String get toolbar_style_one_row_simple_description => 'Only simple formatting options on one row';

  @override
  String get toolbar_style_one_row_all_title => 'One row (all options)';

  @override
  String get toolbar_style_one_row_all_description => 'All formatting formatting options on one row';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Two rows (stacked)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'All formatting formatting options on two stacked rows';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Two rows (toggleable)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'All formatting formatting options on two toggleable rows';

  @override
  String get settings_confirm_before_exiting_title => 'Confirm before exiting';

  @override
  String get settings_confirm_before_exiting_description => 'Ask for a confirmation before exiting the application';

  @override
  String get snack_bar_confirm_exiting => 'Press back again to exit the application.';
}
