import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_cs.g.dart';
import 'app_localizations_de.g.dart';
import 'app_localizations_en.g.dart';
import 'app_localizations_es.g.dart';
import 'app_localizations_fr.g.dart';
import 'app_localizations_hi.g.dart';
import 'app_localizations_it.g.dart';
import 'app_localizations_pl.g.dart';
import 'app_localizations_pt.g.dart';
import 'app_localizations_ru.g.dart';
import 'app_localizations_tr.g.dart';
import 'app_localizations_uk.g.dart';
import 'app_localizations_zh.g.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'app_localizations/app_localizations.g.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale) : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations)!;
  }

  static const LocalizationsDelegate<AppLocalizations> delegate = _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates = <LocalizationsDelegate<dynamic>>[
    delegate,
    GlobalMaterialLocalizations.delegate,
    GlobalCupertinoLocalizations.delegate,
    GlobalWidgetsLocalizations.delegate,
  ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('cs'),
    Locale('de'),
    Locale('en'),
    Locale('es'),
    Locale('fr'),
    Locale('hi'),
    Locale('it'),
    Locale('pl'),
    Locale('pt'),
    Locale('ru'),
    Locale('tr'),
    Locale('uk'),
    Locale.fromSubtags(languageCode: 'zh', scriptCode: 'Hant'),
    Locale('zh'),
  ];

  /// Name of the application.
  ///
  /// In en, this message translates to:
  /// **'Material Notes'**
  String get app_name;

  /// Tagline of the application, shown in the about popup.
  ///
  /// In en, this message translates to:
  /// **'Simple, local, material design notes'**
  String get app_tagline;

  /// Description of the application, shown in the about popup.
  ///
  /// In en, this message translates to:
  /// **'{appName} is a text-based note-taking application, aimed at simplicity. It embraces Material Design. It stores the notes locally and doesn\'\'t have any internet permissions, so you are the only one that can access the notes.'**
  String app_about(String appName);

  /// Prefix for the error message shown in the error snack bar, before the actual error message.
  ///
  /// In en, this message translates to:
  /// **'Error:'**
  String get error_snack_bar;

  /// Message shown in the error widget shown when a widget fails to build.
  ///
  /// In en, this message translates to:
  /// **'An error has occurred.'**
  String get error_widget_title;

  /// Message shown in the error widget shown when a widget fails to build.
  ///
  /// In en, this message translates to:
  /// **'Please report this issue on GitHub or via mail. Attach a screenshot of this page and the logs that you can copy or export below. As a precaution, you should also export your notes.'**
  String get error_widget_description;

  /// Tag shown on the error widget when the setting to flag the app as secure is enabled, but was disabled until the next restart to allow taking screenshots of the screen where the error occurred.
  ///
  /// In en, this message translates to:
  /// **'The setting to flag the app as secure is disabled until the next restart to enable screenshots.'**
  String get error_widget_disabled_secure_flag;

  /// Title of the button to export the notes as JSON on the error widget.
  ///
  /// In en, this message translates to:
  /// **'Export notes'**
  String get error_widget_button_export_notes;

  /// Title of the button to copy the logs to the clipboard on the error widget.
  ///
  /// In en, this message translates to:
  /// **'Copy logs'**
  String get error_widget_button_copy_logs;

  /// Title of the button to export the logs in a text file on the error widget.
  ///
  /// In en, this message translates to:
  /// **'Export logs'**
  String get error_widget_button_export_logs;

  /// Title of the button to create a new GitHub issue on the error widget.
  ///
  /// In en, this message translates to:
  /// **'Create GitHub issue'**
  String get error_widget_button_create_github_issue;

  /// Title of the button to end a bug report mail on the error widget.
  ///
  /// In en, this message translates to:
  /// **'Send mail'**
  String get error_widget_button_send_mail;

  /// Title of the notes page.
  ///
  /// In en, this message translates to:
  /// **'Notes'**
  String get navigation_notes;

  /// Title of the button in the side navigation drawer to got to the page to manage the tags.
  ///
  /// In en, this message translates to:
  /// **'Manage tags'**
  String get navigation_manage_labels_destination;

  /// Title of the page to manage the tags.
  ///
  /// In en, this message translates to:
  /// **'Tags'**
  String get navigation_manage_labels_page;

  /// Title of the archives page.
  ///
  /// In en, this message translates to:
  /// **'Archives'**
  String get navigation_archives;

  /// Title of the bin page.
  ///
  /// In en, this message translates to:
  /// **'Bin'**
  String get navigation_bin;

  /// Title of the settings page.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get navigation_settings;

  /// Title of the settings page regarding the application's appearance.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get navigation_settings_appearance;

  /// Title of the settings page regarding the notes types.
  ///
  /// In en, this message translates to:
  /// **'Notes types'**
  String get navigation_settings_notes_types;

  /// Title of the settings page regarding the notes tiles appearance.
  ///
  /// In en, this message translates to:
  /// **'Notes tiles'**
  String get navigation_settings_notes_tiles;

  /// Title of the settings page regarding the application's behavior.
  ///
  /// In en, this message translates to:
  /// **'Behavior'**
  String get navigation_settings_behavior;

  /// Title of the settings page regarding the notes content editor.
  ///
  /// In en, this message translates to:
  /// **'Editor'**
  String get navigation_settings_editor;

  /// Title of the settings page regarding the tags.
  ///
  /// In en, this message translates to:
  /// **'Tags'**
  String get navigation_settings_labels;

  /// Title of the settings page regarding the backup functionality.
  ///
  /// In en, this message translates to:
  /// **'Backup'**
  String get navigation_settings_backup;

  /// Title of the settings page regarding the security.
  ///
  /// In en, this message translates to:
  /// **'Security'**
  String get navigation_settings_security;

  /// Title of the settings page regarding the accessibility.
  ///
  /// In en, this message translates to:
  /// **'Accessibility'**
  String get navigation_settings_accessibility;

  /// Title of the settings page to receive help.
  ///
  /// In en, this message translates to:
  /// **'Help'**
  String get navigation_settings_help;

  /// Title of the settings page regarding the information about the application.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get navigation_settings_about;

  /// Text of the button to sort the notes list by title.
  ///
  /// In en, this message translates to:
  /// **'Title'**
  String get button_sort_title;

  /// Text of the button to sort the notes list in ascending order.
  ///
  /// In en, this message translates to:
  /// **'Ascending'**
  String get button_sort_ascending;

  /// Title of the settings page regarding the application's appearance.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get settings_page_appearance;

  /// Description of the appearance settings page.
  ///
  /// In en, this message translates to:
  /// **'Language, theming, fonts'**
  String get settings_page_appearance_description;

  /// Title of the language setting tile.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get settings_language;

  /// Button to contribute to the localizations, shown on the language setting tile.
  ///
  /// In en, this message translates to:
  /// **'Contribute'**
  String get settings_language_contribute;

  /// Title of the section regarding the theming under the appearance settings.
  ///
  /// In en, this message translates to:
  /// **'Theming'**
  String get settings_appearance_section_theming;

  /// Title of the theming setting tile.
  ///
  /// In en, this message translates to:
  /// **'Theme'**
  String get settings_theme;

  /// Theming setting to use the theme of the system.
  ///
  /// In en, this message translates to:
  /// **'System'**
  String get settings_theme_system;

  /// Theming setting to use the light theme.
  ///
  /// In en, this message translates to:
  /// **'Light'**
  String get settings_theme_light;

  /// Theming setting to use the dark theme.
  ///
  /// In en, this message translates to:
  /// **'Dark'**
  String get settings_theme_dark;

  /// Title of the dynamic theming setting tile (to use colors generated from the system).
  ///
  /// In en, this message translates to:
  /// **'Dynamic theming'**
  String get settings_dynamic_theming;

  /// Description of the dynamic theming setting tile.
  ///
  /// In en, this message translates to:
  /// **'Generate colors from the system'**
  String get settings_dynamic_theming_description;

  /// Title of the black theming setting tile (to use a black background in dark mode).
  ///
  /// In en, this message translates to:
  /// **'Black theming'**
  String get settings_black_theming;

  /// Description of the black theming setting tile.
  ///
  /// In en, this message translates to:
  /// **'Use a black background in dark mode'**
  String get settings_black_theming_description;

  /// Title of the section regarding the theming under the appearance settings.
  ///
  /// In en, this message translates to:
  /// **'Fonts'**
  String get settings_appearance_section_fonts;

  /// Title of the setting tile to choose the font of the app.
  ///
  /// In en, this message translates to:
  /// **'App font'**
  String get settings_app_font;

  /// Description of the setting tile to choose the font of the app.
  ///
  /// In en, this message translates to:
  /// **'Font used for all the texts in the application, except in the notes editor'**
  String get settings_app_font_description;

  /// Title of the setting tile to choose the font of the notes.
  ///
  /// In en, this message translates to:
  /// **'Editor font'**
  String get settings_editor_font;

  /// Description of the setting tile to choose the font of the app.
  ///
  /// In en, this message translates to:
  /// **'Font used only for the text in the notes editor'**
  String get settings_editor_font_description;

  /// Title of the settings page regarding the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Notes tiles'**
  String get settings_page_notes_tiles;

  /// Description of the notes tiles settings page.
  ///
  /// In en, this message translates to:
  /// **'Appearance, content'**
  String get settings_page_notes_tiles_description;

  /// Title of the section regarding the appearance under the notes tiles settings.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get settings_page_notes_tiles_appearance_section;

  /// Title of the section regarding the content under the notes tiles settings.
  ///
  /// In en, this message translates to:
  /// **'Content'**
  String get settings_page_notes_tiles_content_section;

  /// Title of the setting tile to show the background of the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Background'**
  String get settings_show_tiles_background;

  /// Description of the setting tile to show the background of the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Show the background of the notes tiles'**
  String get settings_show_tiles_background_description;

  /// Title of the setting tile to show the separators between the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Separators'**
  String get settings_show_separators;

  /// Description of the setting tile to show the separators between the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Show a separator between the notes tiles'**
  String get settings_show_separators_description;

  /// Title of the setting tile to show the icon of the type of the note.
  ///
  /// In en, this message translates to:
  /// **'Show type icon'**
  String get settings_show_note_type_icon;

  /// Description of the setting tile to show the icon of the type of the note.
  ///
  /// In en, this message translates to:
  /// **'Show the icon of the type of the note'**
  String get settings_show_note_type_icon_description;

  /// Title of the setting tile to only show the titles of the notes in the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Titles only'**
  String get settings_show_titles_only;

  /// Description of the setting tile to only show the titles of the notes in the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Only show the titles of the notes'**
  String get settings_show_titles_only_description;

  /// Title of the setting tile to disable only showing the titles of the notes in the search view.
  ///
  /// In en, this message translates to:
  /// **'Disable titles only in search view'**
  String get settings_show_titles_only_disable_in_search_view;

  /// Description of the setting tile to disable only showing the titles of the notes in the search view.
  ///
  /// In en, this message translates to:
  /// **'Disable the option to only show the titles when in the search view'**
  String get settings_show_titles_only_disable_in_search_view_description;

  /// Title of the setting tile to choose the maximum number of content preview lines to show.
  ///
  /// In en, this message translates to:
  /// **'Maximum preview lines'**
  String get settings_content_preview_max_lines;

  /// Description of the setting tile to choose the maximum number of content preview lines to show.
  ///
  /// In en, this message translates to:
  /// **'Maximum number of lines of the content preview to show'**
  String get settings_content_preview_max_lines_description;

  /// Title of the settings page regarding the application's behavior.
  ///
  /// In en, this message translates to:
  /// **'Behavior'**
  String get settings_behavior;

  /// Description of the behavior settings page.
  ///
  /// In en, this message translates to:
  /// **'Confirmations, swipe actions'**
  String get settings_behavior_description;

  /// Title of the sub-section regarding the application under the behavior settings.
  ///
  /// In en, this message translates to:
  /// **'Application'**
  String get settings_behavior_application;

  /// Title of the setting tile to choose when to show the confirmation dialog when performing an action on a note.
  ///
  /// In en, this message translates to:
  /// **'Confirmation dialog'**
  String get settings_confirmations;

  /// Description of the setting tile to choose when to show the confirmation dialog when performing an action on a note.
  ///
  /// In en, this message translates to:
  /// **'When to show a confirmation dialog when performing an action on a note'**
  String get settings_confirmations_description;

  /// Value of the setting to never show a confirmation dialog when performing an action on a note.
  ///
  /// In en, this message translates to:
  /// **'Never'**
  String get settings_confirmations_title_none;

  /// Value of the setting to only show a confirmation dialog when performing an action on a note if it is irreversible.
  ///
  /// In en, this message translates to:
  /// **'Irreversible actions only'**
  String get settings_confirmations_title_irreversible;

  /// Value of the setting to always show a confirmation dialog when performing an action on a note.
  ///
  /// In en, this message translates to:
  /// **'Always'**
  String get settings_confirmations_title_all;

  /// Title of the setting tile to automatically remove notes from the bin after a certain delay.
  ///
  /// In en, this message translates to:
  /// **'Auto remove from bin'**
  String get settings_auto_remove_from_bin_title;

  /// Description of the setting tile to automatically remove notes from the bin after a certain delay.
  ///
  /// In en, this message translates to:
  /// **'Automatically remove notes from the bin'**
  String get settings_auto_remove_from_bin_description;

  /// Value of the setting tile to choose after which amount of time the application/note/label locks itself after the application was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'{delay, select, 7{After 1 week} 14{After 2 weeks} 30{After 1 month} 90{After 3 months} 180{After 6 month} 365{After 1 year} other{Never}}'**
  String settings_auto_remove_from_bin_value(String delay);

  /// Title of the section regarding the swipe actions on the notes tiles under the behavior settings.
  ///
  /// In en, this message translates to:
  /// **'Swipe actions'**
  String get settings_behavior_swipe_actions;

  /// Title of the section regarding the swipe actions on the notes tiles in the archives under the behavior settings.
  ///
  /// In en, this message translates to:
  /// **'Swipe actions (archives)'**
  String get settings_behavior_swipe_actions_archives;

  /// Title of the section regarding the swipe actions on the notes tiles in the bin under the behavior settings.
  ///
  /// In en, this message translates to:
  /// **'Swipe actions (bin)'**
  String get settings_behavior_swipe_actions_bin;

  /// Title of the setting tile to choose which action to trigger when a right swapping a note tile.
  ///
  /// In en, this message translates to:
  /// **'Right swipe action'**
  String get settings_swipe_action_right;

  /// Description of the setting tile to choose which action to trigger when a right swipe is performed on a note tile.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a right swipe is performed on a note tile'**
  String get settings_swipe_action_right_description;

  /// Description of the setting tile to choose which action to trigger when a right swipe is performed on a note tile in the bin.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a right swipe is performed on a note tile in the bin'**
  String get settings_bin_swipe_action_right_description;

  /// Title of the setting tile to choose which action to trigger when a left swipe is performed on a note tile.
  ///
  /// In en, this message translates to:
  /// **'Left swipe action'**
  String get settings_swipe_action_left;

  /// Description of the setting tile to choose which action to trigger when a left swipe is performed on a note tile.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a left swipe is performed on a note tile'**
  String get settings_swipe_action_left_description;

  /// Description of the setting tile to choose which action to trigger when a left swipe is performed on a note tile in the bin.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a left swipe is performed on a note tile in the bin'**
  String get settings_bin_swipe_action_left_description;

  /// Title of the settings page regarding the notes types.
  ///
  /// In en, this message translates to:
  /// **'Notes types'**
  String get settings_page_notes_types;

  /// Description of the settings page regarding the notes types.
  ///
  /// In en, this message translates to:
  /// **'Types to use, rich text'**
  String get settings_page_notes_types_description;

  /// Title of the settings section regarding the notes types to use.
  ///
  /// In en, this message translates to:
  /// **'Types to use'**
  String get settings_section_types_to_use;

  /// Title of the setting tile to choose the available notes types.
  ///
  /// In en, this message translates to:
  /// **'Available notes types'**
  String get settings_available_notes_types;

  /// Description of the setting tile to choose the available notes types.
  ///
  /// In en, this message translates to:
  /// **'The list of notes types that can be created with the \"Add\" button from the notes page. When removing a type, already existing notes with that type are not deleted and can still be used normally'**
  String get settings_available_notes_types_description;

  /// Title of the setting tile to choose the default note type to use when creating a note from a share action.
  ///
  /// In en, this message translates to:
  /// **'Default share type'**
  String get settings_available_default_share_type;

  /// Description of the setting tile to choose the default note type to use when creating a note from a share action.
  ///
  /// In en, this message translates to:
  /// **'The default note type to use when creating a note from a share action. It can be a type that is not available from the \"Add\" button'**
  String get settings_available_default_share_type_description;

  /// Title of the settings page regarding the notes content editor.
  ///
  /// In en, this message translates to:
  /// **'Editor'**
  String get settings_editor;

  /// Description of the editor settings page.
  ///
  /// In en, this message translates to:
  /// **'Behavior'**
  String get settings_editor_description;

  /// Title of the settings section regarding the behavior of the editor
  ///
  /// In en, this message translates to:
  /// **'Behavior'**
  String get settings_editor_behavior;

  /// Title of the setting tile to enable the button to toggle between editing mode and reading mode in the editor.
  ///
  /// In en, this message translates to:
  /// **'Editor mode button'**
  String get settings_show_editor_mode_button;

  /// Description of the setting tile to enable the button to toggle between editing mode and reading mode in the editor.
  ///
  /// In en, this message translates to:
  /// **'Enable the button to toggle the editor between editing mode and reading mode'**
  String get settings_show_editor_mode_button_description;

  /// Title of the setting tile to enable opening the editor in reading mode by default.
  ///
  /// In en, this message translates to:
  /// **'Open in reading mode'**
  String get settings_open_editor_reading_mode;

  /// Description of the setting tile to enable opening the editor in reading mode by default.
  ///
  /// In en, this message translates to:
  /// **'Open the editor in reading mode by default'**
  String get settings_open_editor_reading_mode_description;

  /// Title of the setting tile to enable focusing the title when creating a new note by default.
  ///
  /// In en, this message translates to:
  /// **'Focus the title'**
  String get settings_focus_title_on_new_note;

  /// Description of the setting tile to enable focusing the title when creating a new note by default.
  ///
  /// In en, this message translates to:
  /// **'Focus the title instead of the content when creating a new note'**
  String get settings_focus_title_on_new_note_description;

  /// Title of the settings section regarding the appearance of the editor
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get settings_editor_appearance;

  /// Title of the setting tile to choose the toolbar style.
  ///
  /// In en, this message translates to:
  /// **'Toolbar style'**
  String get settings_toolbar_style_title;

  /// Description of the setting tile to choose the toolbar style.
  ///
  /// In en, this message translates to:
  /// **'The style of the toolbar of the rich text editor'**
  String get settings_toolbar_style_description;

  /// Title of the setting tile to enable the spacing between paragraphs in the notes content.
  ///
  /// In en, this message translates to:
  /// **'Paragraph spacing'**
  String get settings_use_paragraph_spacing;

  /// Description of the setting tile to enable the spacing between paragraphs in the notes content.
  ///
  /// In en, this message translates to:
  /// **'Use spacing between paragraphs'**
  String get settings_use_paragraph_spacing_description;

  /// Title of the settings page regarding the tags functionality.
  ///
  /// In en, this message translates to:
  /// **'Tags'**
  String get settings_labels;

  /// Description of the tags settings page.
  ///
  /// In en, this message translates to:
  /// **'Enable, appearance'**
  String get settings_labels_description;

  /// Title of the setting tile to enable the tags.
  ///
  /// In en, this message translates to:
  /// **'Enable'**
  String get settings_enable_labels;

  /// Description of the setting tile to enable the tags.
  ///
  /// In en, this message translates to:
  /// **'Allow to categorize the notes with tags (disabling it doesn\'\'t delete tags nor remove them from the notes, it only hides them)'**
  String get settings_enable_labels_description;

  /// Title of the settings section regarding the appearance of the tags.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get settings_labels_appearance;

  /// Title of the setting tile to show the tags on the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Show tags on note tile'**
  String get settings_show_labels_note_tile;

  /// Description of the setting tile to show the tags on the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Show the list of tags of the note tiles'**
  String get settings_show_labels_note_tile_description;

  /// Title of the setting tile to show the tags in the editor.
  ///
  /// In en, this message translates to:
  /// **'Show tags in editor'**
  String get settings_show_labels_editor;

  /// Description of the setting tile to show the tags in the editor.
  ///
  /// In en, this message translates to:
  /// **'Show the list of tags at the bottom of the editor'**
  String get settings_show_labels_editor_description;

  /// Title of the settings section regarding the behavior of the tags.
  ///
  /// In en, this message translates to:
  /// **'Behavior'**
  String get settings_labels_section_behavior;

  /// Title of the setting tile to choose which action to trigger when a right swapping a label tile.
  ///
  /// In en, this message translates to:
  /// **'Right swipe action'**
  String get settings_labels_swipe_action_right;

  /// Description of the setting tile to choose which action to trigger when a right swipe is performed on a label tile.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a right swipe is performed on a label tile'**
  String get settings_labels_swipe_action_right_description;

  /// Title of the setting tile to choose which action to trigger when a left swapping a label tile.
  ///
  /// In en, this message translates to:
  /// **'Left swipe action'**
  String get settings_labels_swipe_action_left;

  /// Description of the setting tile to choose which action to trigger when a left swipe is performed on a label tile.
  ///
  /// In en, this message translates to:
  /// **'Action to trigger when a left swipe is performed on a label tile'**
  String get settings_labels_swipe_action_left_description;

  /// Title of the settings page regarding the backup functionality.
  ///
  /// In en, this message translates to:
  /// **'Backup'**
  String get settings_backup;

  /// Description of the backup settings page.
  ///
  /// In en, this message translates to:
  /// **'Manual and automatic export, encryption, import'**
  String get settings_backup_description;

  /// Title of the settings section regarding the import of a backup.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get settings_backup_import;

  /// Title of the setting tile to import a backup.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get settings_import;

  /// Description of the setting tile to import a backup.
  ///
  /// In en, this message translates to:
  /// **'Import notes, tags and settings from a JSON file'**
  String get settings_import_description;

  /// Title of the settings section regarding the manual export of the notes.
  ///
  /// In en, this message translates to:
  /// **'Manual export'**
  String get settings_backup_manual_export;

  /// Title of the setting tile to manually export the notes as JSON.
  ///
  /// In en, this message translates to:
  /// **'Export as JSON'**
  String get settings_export_json;

  /// Description of the setting tile to manually export the notes as JSON.
  ///
  /// In en, this message translates to:
  /// **'Immediately export all the notes, tags and settings to a JSON file that can be imported back'**
  String get settings_export_json_description;

  /// Title of the setting tile to manually export the notes as Markdown.
  ///
  /// In en, this message translates to:
  /// **'Export as Markdown'**
  String get settings_export_markdown;

  /// Description of the setting tile to manually export the notes as Markdown.
  ///
  /// In en, this message translates to:
  /// **'Immediately export all the notes to a Markdown file'**
  String get settings_export_markdown_description;

  /// Title of the settings section regarding the automatic export of the notes.
  ///
  /// In en, this message translates to:
  /// **'Automatic export'**
  String get settings_backup_auto_export;

  /// Title of the settings tile to enable the automatic export of the notes.
  ///
  /// In en, this message translates to:
  /// **'Automatic export'**
  String get settings_auto_export;

  /// Description of the settings tile to enable the automatic export.
  ///
  /// In en, this message translates to:
  /// **'Automatically export all the notes, tags and settings to a JSON file that can be imported back'**
  String get settings_auto_export_description;

  /// Title of the settings tile to choose the frequency of the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Frequency'**
  String get settings_auto_export_frequency;

  /// Frequency of the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Every {frequency, select, 1{day} 7{week} 14{2 weeks} 30{month} other{}}'**
  String settings_auto_export_frequency_value(String frequency);

  /// Description of the settings tile to choose the frequency of the automatic exports of the notes.
  ///
  /// In en, this message translates to:
  /// **'Frequency of the automatic export'**
  String get settings_auto_export_frequency_description;

  /// Title of the settings tile to enable the encryption of the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Encryption'**
  String get settings_auto_export_encryption;

  /// Description of the settings tile to enable the encryption of the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Encrypt the title and the content of the notes with a password'**
  String get settings_auto_export_encryption_description;

  /// Title of the settings tile to choose the directory where to save the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Directory'**
  String get settings_auto_export_directory;

  /// Description of the settings tile to choose the directory where to save the automatic exports.
  ///
  /// In en, this message translates to:
  /// **'Directory where to store the automatic exports'**
  String get settings_auto_export_directory_description;

  /// Title of the settings page regarding the security.
  ///
  /// In en, this message translates to:
  /// **'Security'**
  String get settings_security;

  /// Description of the settings page regarding the security.
  ///
  /// In en, this message translates to:
  /// **'Secure flag, application lock, note lock'**
  String get settings_security_description;

  /// Title of the sub-section regarding the application under the security settings.
  ///
  /// In en, this message translates to:
  /// **'Application'**
  String get settings_security_application;

  /// Title of the sub-section regarding the application lock under the security settings.
  ///
  /// In en, this message translates to:
  /// **'Application lock'**
  String get settings_security_application_lock;

  /// Title of the sub-section regarding the note lock under the security settings.
  ///
  /// In en, this message translates to:
  /// **'Note lock'**
  String get settings_security_note_lock;

  /// Title of the setting tile to flag the application as secure (hiding it from the recent apps and prevent screenshots from being made).
  ///
  /// In en, this message translates to:
  /// **'Flag the app as secure'**
  String get settings_flag_secure;

  /// Description of the setting tile to flag the application as secure (hiding it from the recent apps and prevent screenshots from being made).
  ///
  /// In en, this message translates to:
  /// **'Hide the app from the recent apps and prevent screenshots from being made'**
  String get settings_flag_secure_description;

  /// Title of the setting tile to toggle whether the application is locked.
  ///
  /// In en, this message translates to:
  /// **'Lock'**
  String get settings_application_lock_title;

  /// Description of the setting tile to toggle whether the application is locked.
  ///
  /// In en, this message translates to:
  /// **'Lock the application and require to authenticate with the device to unlock it'**
  String get settings_application_lock_description;

  /// Title of the setting tile to choose after which amount of time the application locks itself after it was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'Lock delay'**
  String get settings_application_lock_delay_title;

  /// Description of the setting tile to choose after which amount of time the application locks itself after it was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'Delay after which the application locks itself when moved to the background'**
  String get settings_application_lock_delay_description;

  /// Value of the setting tile to choose after which amount of time the application/note/label locks itself after the application was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'{delay, select, 0{Immediately} 3{After 3 seconds} 5{After 5 seconds} 10{After 10 seconds} 30{After 30 seconds} 60{After 1 minute} 120{After 2 minutes} 300{After 5 minutes} other{Never}}'**
  String settings_lock_delay_value(String delay);

  /// Title of the setting tile to toggle whether the notes can be locked.
  ///
  /// In en, this message translates to:
  /// **'Note lock'**
  String get settings_note_lock_title;

  /// Description of the setting tile to toggle whether the notes can be locked.
  ///
  /// In en, this message translates to:
  /// **'Lock the note and require to authenticate with the device to view and edit it'**
  String get settings_note_lock_description;

  /// Title of the setting tile to toggle whether the tags can be locked.
  ///
  /// In en, this message translates to:
  /// **'Tag lock'**
  String get settings_label_lock_title;

  /// Description of the setting tile to toggle whether the tags can be locked.
  ///
  /// In en, this message translates to:
  /// **'Lock the tag and require to authenticate with the device to view and edit any note that contains it'**
  String get settings_label_lock_description;

  /// Title of the setting tile to choose after which amount of time the note locks itself after the application was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'Lock delay'**
  String get settings_note_lock_delay_title;

  /// Description of the setting tile to choose after which amount of time the note locks itself after the application was moved to the background.
  ///
  /// In en, this message translates to:
  /// **'Delay after which the note locks itself when the application is moved to the background'**
  String get settings_note_lock_delay_description;

  /// Title of the settings page regarding the accessibility
  ///
  /// In en, this message translates to:
  /// **'Accessibility'**
  String get settings_accessibility;

  /// Title of the accessibility settings section regarding the text size.
  ///
  /// In en, this message translates to:
  /// **'Text size'**
  String get settings_accessibility_text_size;

  /// Title of the accessibility settings section regarding the text color.
  ///
  /// In en, this message translates to:
  /// **'Text color'**
  String get settings_accessibility_text_color;

  /// Description of the accessibility settings page.
  ///
  /// In en, this message translates to:
  /// **'Text color, text scaling'**
  String get settings_accessibility_description;

  /// Title of the text scale setting tile.
  ///
  /// In en, this message translates to:
  /// **'Text scaling'**
  String get settings_text_scaling;

  /// Title of the setting tile to use bigger titles on the notes tiles and in the editor.
  ///
  /// In en, this message translates to:
  /// **'Bigger titles'**
  String get settings_bigger_titles;

  /// Description of the setting tile to use bigger titles on the notes tiles and in the editor.
  ///
  /// In en, this message translates to:
  /// **'Show bigger titles on the the notes tiles and in the editor'**
  String get settings_bigger_titles_description;

  /// Title of the text scale setting tile.
  ///
  /// In en, this message translates to:
  /// **'White text in dark mode'**
  String get settings_white_text_dark_mode;

  /// Description of the text scale setting tile.
  ///
  /// In en, this message translates to:
  /// **'Use a white color for the text in dark mode'**
  String get settings_white_text_dark_mode_description;

  /// Title of the setting tile to disable the subdued color of the notes content preview text in the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Non-subdued preview'**
  String get settings_disable_subdued_note_content_preview;

  /// Description of the setting tile to disable the subdued color of the notes content preview text in the notes tiles.
  ///
  /// In en, this message translates to:
  /// **'Disable the subdued text color of the notes content preview'**
  String get settings_disable_subdued_note_content_preview_description;

  /// Title of the settings section regarding how to get in contact.
  ///
  /// In en, this message translates to:
  /// **'Contact'**
  String get settings_help_section_contact;

  /// Title of the settings tile to open the GitHub issues and report a bug or request a feature.
  ///
  /// In en, this message translates to:
  /// **'Report a bug or request a feature'**
  String get settings_github_issues;

  /// Description of the settings tile to open the GitHub issues and report a bug or request a feature.
  ///
  /// In en, this message translates to:
  /// **'Report a bug or request a feature by creating a GitHub issue'**
  String get settings_github_issues_description;

  /// Title of the settings tile to open the GitHub discussions and ask a question.
  ///
  /// In en, this message translates to:
  /// **'Ask a question'**
  String get settings_github_discussions;

  /// Description of the settings tile to open the GitHub discussions and ask a question.
  ///
  /// In en, this message translates to:
  /// **'Ask a question on GitHub discussions'**
  String get settings_github_discussions_description;

  /// Title of the settings tile to contact the developer via mail.
  ///
  /// In en, this message translates to:
  /// **'Contact the developer'**
  String get settings_contact_developer;

  /// Description of the settings tile to contact the developer via mail.
  ///
  /// In en, this message translates to:
  /// **'Contact the developer via mail at {email}'**
  String settings_get_in_touch_description(Object email);

  /// Title of the settings page to receive help.
  ///
  /// In en, this message translates to:
  /// **'Help'**
  String get settings_help;

  /// Description of the settings page to receive help.
  ///
  /// In en, this message translates to:
  /// **'Contact, logs'**
  String get settings_help_description;

  /// Title of the settings section regarding the logs of the application.
  ///
  /// In en, this message translates to:
  /// **'Logs'**
  String get settings_help_section_logs;

  /// Title of the settings tile to copy the logs of the application to the clipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy the logs'**
  String get settings_copy_logs;

  /// Description of the settings tile to copy the logs of the application to the clipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy the logs of the application to the clipboard'**
  String get settings_copy_logs_description;

  /// Title of the settings tile to export the logs of the application to a text file.
  ///
  /// In en, this message translates to:
  /// **'Export the logs'**
  String get settings_export_logs;

  /// Description of the settings tile to export the logs of the application to a text file.
  ///
  /// In en, this message translates to:
  /// **'Export the logs of the application to a text file'**
  String get settings_export_logs_description;

  /// Title of the settings page regarding the information about the application.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get settings_about;

  /// Description of the settings page regarding the information about the application.
  ///
  /// In en, this message translates to:
  /// **'Information, links, donate'**
  String get settings_about_description;

  /// Title of the settings section regarding the information about the application.
  ///
  /// In en, this message translates to:
  /// **'Application'**
  String get settings_about_application;

  /// Title of the settings tile displaying the build mode of the application.
  ///
  /// In en, this message translates to:
  /// **'Build mode'**
  String get settings_build_mode;

  /// Value of the settings tile displaying the build mode if the application is built in release mode (the mode used in the stores).
  ///
  /// In en, this message translates to:
  /// **'Release'**
  String get settings_build_mode_release;

  /// Value of the settings tile displaying the build mode if the application is built in debug mode (the mode used for development and ).
  ///
  /// In en, this message translates to:
  /// **'Debug'**
  String get settings_build_mode_debug;

  /// Title of the settings section regarding the outside links related to the application.
  ///
  /// In en, this message translates to:
  /// **'Links'**
  String get settings_about_links;

  /// Title of the settings tile to open the GitHub repository of the application.
  ///
  /// In en, this message translates to:
  /// **'GitHub'**
  String get settings_github;

  /// Description of the settings tile to open the GitHub repository of the application.
  ///
  /// In en, this message translates to:
  /// **'Take a look at the source code'**
  String get settings_github_description;

  /// Title of the settings tile to open the Crowdin project managing the localization of the application.
  ///
  /// In en, this message translates to:
  /// **'Crowdin'**
  String get settings_localizations;

  /// Description of the settings tile to open the Crowdin project managing the localization of the application.
  ///
  /// In en, this message translates to:
  /// **'Add or improve the localizations on the Crowdin project'**
  String get settings_localizations_description;

  /// Title of the settings tile to open the license of the application.
  ///
  /// In en, this message translates to:
  /// **'License'**
  String get settings_licence;

  /// Description of the settings tile to open the license of the application.
  ///
  /// In en, this message translates to:
  /// **'AGPL-3.0'**
  String get settings_licence_description;

  /// Title of the settings section to donate.
  ///
  /// In en, this message translates to:
  /// **'Donate'**
  String get settings_about_section_donate;

  /// Title of the settings tile to donate via Ko-fi.
  ///
  /// In en, this message translates to:
  /// **'Ko-fi'**
  String get settings_donate_kofi;

  /// Title of the settings tile to donate via PayPal.
  ///
  /// In en, this message translates to:
  /// **'PayPal'**
  String get settings_donate_paypal;

  /// Hint for the text field of the title of the notes.
  ///
  /// In en, this message translates to:
  /// **'Title'**
  String get hint_title;

  /// Hint for the text field of the content of the notes.
  ///
  /// In en, this message translates to:
  /// **'Note'**
  String get hint_content;

  /// Hint for the link text field in the dialog to add a link in the editor.
  ///
  /// In en, this message translates to:
  /// **'Link'**
  String get hint_link;

  /// Hint for the text field of the name of a tag.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get hint_label_name;

  /// Hint for the password text field in the dialog to configure the encryption of an automatic or manual export.
  ///
  /// In en, this message translates to:
  /// **'Password'**
  String get dialog_export_encryption_password;

  /// Title of the dialog to select the tags of a note.
  ///
  /// In en, this message translates to:
  /// **'Select tags'**
  String get dialog_select_labels;

  /// Title of the dialog to select the tags to add to the currently selected notes.
  ///
  /// In en, this message translates to:
  /// **'Select tags to add'**
  String get dialog_select_labels_to_add;

  /// Tooltip for the button to undo the last action in the editor.
  ///
  /// In en, this message translates to:
  /// **'Undo the last action'**
  String get tooltip_undo;

  /// Tooltip for the button to redo the last action in the editor.
  ///
  /// In en, this message translates to:
  /// **'Redo the last action'**
  String get tooltip_redo;

  /// Floating action button in the notes page to add a new note.
  ///
  /// In en, this message translates to:
  /// **'Add a note'**
  String get tooltip_fab_add_note;

  /// Floating action button in the notes page to add a new plain text note.
  ///
  /// In en, this message translates to:
  /// **'Add a plain text note'**
  String get tooltip_fab_add_plain_text_note;

  /// Floating action button in the notes page to add a new markdown note.
  ///
  /// In en, this message translates to:
  /// **'Add a markdown note'**
  String get tooltip_fab_add_markdown_note;

  /// Floating action button in the notes page to add a new rich text note.
  ///
  /// In en, this message translates to:
  /// **'Add a rich text note'**
  String get tooltip_fab_add_rich_text_note;

  /// Floating action button in the notes page to add a new checklist note.
  ///
  /// In en, this message translates to:
  /// **'Add a checklist note'**
  String get tooltip_fab_add_checklist_note;

  /// Floating action button in the tags page to add a new tag.
  ///
  /// In en, this message translates to:
  /// **'Add a tag'**
  String get tooltip_fab_add_label;

  /// Floating action button in the bin to empty it.
  ///
  /// In en, this message translates to:
  /// **'Empty the bin'**
  String get tooltip_fab_empty_bin;

  /// Floating action button in the notes editor to switch to editing mode.
  ///
  /// In en, this message translates to:
  /// **'Switch to editing mode'**
  String get tooltip_fab_toggle_editor_mode_edit;

  /// Floating action button in the notes editor to switch to reading mode.
  ///
  /// In en, this message translates to:
  /// **'Switch to reading mode'**
  String get tooltip_fab_toggle_editor_mode_read;

  /// Tooltip for the button to use the list layout in the notes list.
  ///
  /// In en, this message translates to:
  /// **'List view'**
  String get tooltip_layout_list;

  /// Tooltip for the button to use the grid layout in the notes list.
  ///
  /// In en, this message translates to:
  /// **'Grid view'**
  String get tooltip_layout_grid;

  /// Tooltip for the button to open the menu to choose the sorting method of the notes list.
  ///
  /// In en, this message translates to:
  /// **'Sort the notes'**
  String get tooltip_sort;

  /// Tooltip for the button to open the search view to search through the notes.
  ///
  /// In en, this message translates to:
  /// **'Search the notes'**
  String get tooltip_search;

  /// Tooltip for the button to unselect all the notes while in selection mode in the notes list.
  ///
  /// In en, this message translates to:
  /// **'Unselect all'**
  String get tooltip_unselect_all;

  /// Tooltip for the button to reset the value of a setting to its default value in a settings page.
  ///
  /// In en, this message translates to:
  /// **'Reset'**
  String get tooltip_reset;

  /// Tooltip for the button to validate the dialog to add a link in the note editor.
  ///
  /// In en, this message translates to:
  /// **'Add a link'**
  String get dialog_add_link;

  /// Title of the the dialog to archive one or multiple notes (moving them to the archives), and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Archive'**
  String get dialog_archive;

  /// Text for the dialog to confirm the archival of one or multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to archive {count} {count, plural, one{note} other{notes}}?'**
  String dialog_archive_body(int count);

  /// Title of the the dialog to unarchive one or multiple notes, and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Unarchive'**
  String get dialog_unarchive;

  /// Text for the dialog to confirm the unarchival of one or multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to unarchive {count} {count, plural, one{note} other{notes}}?'**
  String dialog_unarchive_body(int count);

  /// Title of the the dialog to delete one or multiple notes (moving them to the bin), and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get dialog_delete;

  /// Text for the dialog to confirm the deletion of one or multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to delete {count} {count, plural, one{note} other{notes}}? You can restore {count, plural, one{it} other{them}} from the bin.'**
  String dialog_delete_body(int count);

  /// Title of the the dialog to permanently delete one or multiple notes, and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Delete permanently'**
  String get dialog_permanently_delete;

  /// Text for the dialog to confirm the permanent deletion of one or multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to permanently delete {count} {count, plural, one{note} other{notes}}? You will not be able to restore {count, plural, one{it} other{them}}.'**
  String dialog_permanently_delete_body(int count);

  /// Title of the the dialog to restore one or multiple notes from the bin, and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Restore'**
  String get dialog_restore;

  /// Text for the dialog to confirm restoring one or multiple notes from the bin.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to restore {count} {count, plural, one{note} other{notes}}?'**
  String dialog_restore_body(int count);

  /// Title of the the dialog to empty the bin, and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Empty the bin'**
  String get dialog_empty_bin;

  /// Text for the dialog to confirm emptying the bin.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to permanently empty the bin? You will not be able to restore the notes it contains.'**
  String get dialog_empty_bin_body;

  /// Title of the the dialog to delete one or multiple tags, and text for the confirmation button.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get dialog_delete_label;

  /// Text for the dialog to confirm the deletion of one or multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Do you really want to delete {count} {count, plural, one{tag} other{tags}}? {count, plural, one{It} other{They}} will be removed from the notes where you added {count, plural, one{it} other{them}}.'**
  String dialog_delete_label_body(int count);

  /// Text for the switch to toggle the encryption of the export in the dialog to manually or automatically exporting the notes as JSON.
  ///
  /// In en, this message translates to:
  /// **'Encrypt the JSON export'**
  String get dialog_export_encryption_switch;

  /// Description for the encryption feature when the switch to toggle the encryption of the export is enabled.
  ///
  /// In en, this message translates to:
  /// **'The title and the content of the notes will be encrypted using your password. It should be randomly generated, exactly 32 characters long, strong (at least 1 lowercase, 1 uppercase, 1 number and 1 special character) and securely stored.'**
  String get dialog_export_encryption_description;

  /// Secondary description for the encryption feature in the case of an automatic export.
  ///
  /// In en, this message translates to:
  /// **'This password will be used for all future automatic exports.'**
  String get dialog_export_encryption_secondary_description_auto;

  /// Secondary description for the encryption feature in the case of a manual export.
  ///
  /// In en, this message translates to:
  /// **'This password will only be used for this export.'**
  String get dialog_export_encryption_secondary_description_manual;

  /// Error message displayed under the text field for the encryption password if it does not meet the strength requirements.
  ///
  /// In en, this message translates to:
  /// **'Invalid'**
  String get dialog_export_encryption_password_invalid;

  /// Description in the import dialog when an import is encrypted and the password is needed.
  ///
  /// In en, this message translates to:
  /// **'This export is encrypted. To import it, you need to provide the password used to encrypt it.'**
  String get dialog_import_encryption_password_description;

  /// Error when the decryption of an encrypted import failed.
  ///
  /// In en, this message translates to:
  /// **'the decrypting of the export failed. Please check that you provided the same password that the one you used for encrypting the export.'**
  String get dialog_import_encryption_password_error;

  /// Title of the dialog to add a tag.
  ///
  /// In en, this message translates to:
  /// **'Add tag'**
  String get dialog_label_add;

  /// Title of the dialog to edit a tag.
  ///
  /// In en, this message translates to:
  /// **'Edit tag'**
  String get dialog_label_edit;

  /// Error message shown when relevant on the text field of the name of the tag.
  ///
  /// In en, this message translates to:
  /// **'The name cannot be empty.'**
  String get dialog_label_name_cannot_be_empty;

  /// Error message shown when relevant on the text field of the name of the tag.
  ///
  /// In en, this message translates to:
  /// **'This name is already used.'**
  String get dialog_label_name_already_used;

  /// Text of the button to sort the notes list by their creation date.
  ///
  /// In en, this message translates to:
  /// **'Creation date'**
  String get button_sort_creation_date;

  /// Text of the button to sort the notes list by their last edition date.
  ///
  /// In en, this message translates to:
  /// **'Edition date'**
  String get button_sort_edition_date;

  /// Placeholder on the notes page when there are no notes.
  ///
  /// In en, this message translates to:
  /// **'No notes'**
  String get placeholder_notes;

  /// Placeholder on the tags page when there are no tags.
  ///
  /// In en, this message translates to:
  /// **'No tags'**
  String get placeholder_labels;

  /// Placeholder on the archives notes page when there are no archived notes.
  ///
  /// In en, this message translates to:
  /// **'No archived notes'**
  String get placeholder_archives;

  /// Placeholder on the bin page when there are no deleted notes.
  ///
  /// In en, this message translates to:
  /// **'No deleted notes'**
  String get placeholder_bin;

  /// Swipe action that is disabled in the settings.
  ///
  /// In en, this message translates to:
  /// **'Disabled'**
  String get action_disabled;

  /// Menu action to toggle whether the notes are pinned.
  ///
  /// In en, this message translates to:
  /// **'Toggle pins'**
  String get action_toggle_pin;

  /// Swipe action to pin or unpin a note.
  ///
  /// In en, this message translates to:
  /// **'Pin / Unpin'**
  String get action_pin_unpin;

  /// Swipe or menu action to pin a note.
  ///
  /// In en, this message translates to:
  /// **'Pin'**
  String get action_pin;

  /// Swipe or menu action to unpin a note.
  ///
  /// In en, this message translates to:
  /// **'Unpin'**
  String get action_unpin;

  /// Menu action to toggle whether the notes are locked.
  ///
  /// In en, this message translates to:
  /// **'Toggle lock'**
  String get action_toggle_lock;

  /// Swipe action to lock or unlock a note.
  ///
  /// In en, this message translates to:
  /// **'Lock / Unlock'**
  String get action_lock_unlock;

  /// Swipe or menu action to lock a note.
  ///
  /// In en, this message translates to:
  /// **'Lock'**
  String get action_lock;

  /// Swipe or menu action to unlock a note.
  ///
  /// In en, this message translates to:
  /// **'Unlock'**
  String get action_unlock;

  /// Swipe or menu action to share a note.
  ///
  /// In en, this message translates to:
  /// **'Share'**
  String get action_share;

  /// Subject of the text that is shared when multiple notes are shared at the same time.
  ///
  /// In en, this message translates to:
  /// **'{count} {count, plural, one{note} other{notes}} shared from Material Notes'**
  String action_share_subject(int count);

  /// Swipe or menu action to archive a note (moving it to the archives).
  ///
  /// In en, this message translates to:
  /// **'Archive'**
  String get action_archive;

  /// Swipe or menu action to unarchive a note.
  ///
  /// In en, this message translates to:
  /// **'Unarchive'**
  String get action_unarchive;

  /// Swipe or menu action to delete a note (moving it to the bin).
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get action_delete;

  /// Swipe or menu action to restore a note from the bin.
  ///
  /// In en, this message translates to:
  /// **'Restore'**
  String get action_restore;

  /// Swipe or menu action to permanently delete a note.
  ///
  /// In en, this message translates to:
  /// **'Delete permanently'**
  String get action_delete_permanently;

  /// Swipe or menu action to show information about a note.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get action_about;

  /// Date when the note was edited for the last time.
  ///
  /// In en, this message translates to:
  /// **'Last edited'**
  String get about_last_edited;

  /// Type of the note.
  ///
  /// In en, this message translates to:
  /// **'Type'**
  String get about_type;

  /// Date when the note was created.
  ///
  /// In en, this message translates to:
  /// **'Created'**
  String get about_created;

  /// Number of tags of the note.
  ///
  /// In en, this message translates to:
  /// **'Tags'**
  String get about_labels;

  /// Number of words in the content of the note.
  ///
  /// In en, this message translates to:
  /// **'Words'**
  String get about_words;

  /// Number of characters in the content of the note.
  ///
  /// In en, this message translates to:
  /// **'Characters'**
  String get about_characters;

  /// Preposition shown between the date and the time in the about dialog (example: 'January 5, 2024 at 5:15 PM').
  ///
  /// In en, this message translates to:
  /// **'at'**
  String get about_time_at;

  /// Menu action to select the tags of a note.
  ///
  /// In en, this message translates to:
  /// **'Tags'**
  String get menu_action_select_labels;

  /// Menu action to add tags to multiple notes.
  ///
  /// In en, this message translates to:
  /// **'Add tags'**
  String get menu_action_add_labels;

  /// Tooltip for the button to toggle whether the selected tags are visible.
  ///
  /// In en, this message translates to:
  /// **'Toggle visibility'**
  String get action_labels_toggle_visibile;

  /// Swipe action to show or hide a tag.
  ///
  /// In en, this message translates to:
  /// **'Show / Hide'**
  String get action_labels_show_hide;

  /// Menu or swipe action to make tag visible.
  ///
  /// In en, this message translates to:
  /// **'Show'**
  String get action_labels_show;

  /// Menu or swipe action to hide a tag.
  ///
  /// In en, this message translates to:
  /// **'Hide'**
  String get action_labels_hide;

  /// Menu action to toggle whether the selected tags are pinned.
  ///
  /// In en, this message translates to:
  /// **'Toggle pins'**
  String get action_labels_toggle_pins;

  /// Swipe action to pin or unpin a tag.
  ///
  /// In en, this message translates to:
  /// **'Pin / Unpin'**
  String get action_labels_pin_unpin;

  /// Menu or swipe action to pin a tag.
  ///
  /// In en, this message translates to:
  /// **'Pin'**
  String get action_labels_pin;

  /// Menu or swipe action to unpin a tag.
  ///
  /// In en, this message translates to:
  /// **'Unpin'**
  String get action_labels_unpin;

  /// Tooltip for the button to toggle whether the selected tags are locked.
  ///
  /// In en, this message translates to:
  /// **'Toggle lock'**
  String get action_labels_toggle_lock;

  /// Swipe action to lock or unlock a tag.
  ///
  /// In en, this message translates to:
  /// **'Lock / Unlock'**
  String get action_labels_lock_unlock;

  /// Menu or swipe action to lock a tag.
  ///
  /// In en, this message translates to:
  /// **'Lock'**
  String get action_labels_lock;

  /// Menu or swipe action to unlock a tag.
  ///
  /// In en, this message translates to:
  /// **'Unlock'**
  String get action_labels_unlock;

  /// Menu or swipe action to edit a tag.
  ///
  /// In en, this message translates to:
  /// **'Edit'**
  String get action_labels_edit;

  /// Menu or swipe action to delete a tag.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get action_labels_delete;

  /// Filter chip in the tags page to all tags.
  ///
  /// In en, this message translates to:
  /// **'All'**
  String get filter_labels_all;

  /// Filter chip in the tags page to show only the visible tags.
  ///
  /// In en, this message translates to:
  /// **'Visible'**
  String get filter_labels_visible;

  /// Filter chip in the tags page to show only the hidden tags.
  ///
  /// In en, this message translates to:
  /// **'Hidden'**
  String get filter_labels_hidden;

  /// Filter chip in the tags page to show only the pinned tags.
  ///
  /// In en, this message translates to:
  /// **'Pinned'**
  String get filter_labels_pinned;

  /// Filter chip in the tags page to show only the locked tags.
  ///
  /// In en, this message translates to:
  /// **'Locked'**
  String get filter_labels_locked;

  /// Snack bar informing that the authentication on the lock screen has failed.
  ///
  /// In en, this message translates to:
  /// **'The authentication failed, please try again.'**
  String get snack_bar_authentication_failed;

  /// Snack bar informing that the note was archived.
  ///
  /// In en, this message translates to:
  /// **'The {count, plural, one{note was} other{notes were}} archived'**
  String snack_bar_archived(int count);

  /// Snack bar informing that the note was unarchived.
  ///
  /// In en, this message translates to:
  /// **'The {count, plural, one{note was} other{notes were}} unarchived'**
  String snack_bar_unarchived(int count);

  /// Snack bar informing that the note was deleted.
  ///
  /// In en, this message translates to:
  /// **'The {count, plural, one{note was} other{notes were}} deleted'**
  String snack_bar_deleted(int count);

  /// Snack bar informing that the note was restored.
  ///
  /// In en, this message translates to:
  /// **'The {count, plural, one{note was} other{notes were}} restored'**
  String snack_bar_restored(int count);

  /// Snack bar informing that the content of the note was copied to clipboard.
  ///
  /// In en, this message translates to:
  /// **'Content of the {count, plural, one{note} other{notes}} copied to the clipboard.'**
  String snack_bar_copied(int count);

  /// Snack bar informing that the backup was successfully imported.
  ///
  /// In en, this message translates to:
  /// **'The backup was successfully imported.'**
  String get snack_bar_import_success;

  /// Snack bar informing that the backup was successfully manually exported.
  ///
  /// In en, this message translates to:
  /// **'The backup were successfully exported.'**
  String get snack_bar_export_success;

  /// Snack bar message shown when the logs where copied to the clipboard from the error widget.
  ///
  /// In en, this message translates to:
  /// **'The logs were copied to your clipboard.'**
  String get snack_bar_logs_copied;

  /// Snack bar message shown when the logs where successfully exported in a text file from the error widget.
  ///
  /// In en, this message translates to:
  /// **'The logs were successfully exported.'**
  String get snack_bar_logs_exported;

  /// Snack bar message shown when the user tries to select the tags for a note, but there are no tags available.
  ///
  /// In en, this message translates to:
  /// **'There are no tags.'**
  String get snack_bar_no_labels;

  /// Title of the home screen action to add a new plain text note.
  ///
  /// In en, this message translates to:
  /// **'Add a plain text note'**
  String get quick_action_add_plain_text_note_title;

  /// Title of the home screen action to add a new markdown note.
  ///
  /// In en, this message translates to:
  /// **'Add a markdown note'**
  String get quick_action_add_markdown_note_title;

  /// Title of the home screen action to add a new rich text note.
  ///
  /// In en, this message translates to:
  /// **'Add a rich text note'**
  String get quick_action_add_rich_text_note_title;

  /// Title of the home screen action to add a new checklist note.
  ///
  /// In en, this message translates to:
  /// **'Add a checklist note'**
  String get quick_action_add_checklist_note_title;

  /// Title of the welcome note automatically created on the first run of the application.
  ///
  /// In en, this message translates to:
  /// **'Welcome to Material Notes!'**
  String get welcome_note_title;

  /// Content of the welcome note automatically created on the first run of the application.
  ///
  /// In en, this message translates to:
  /// **'Simple, local, material design notes'**
  String get welcome_note_content;

  /// Name of the font settings that uses the default font of the system.
  ///
  /// In en, this message translates to:
  /// **'System default'**
  String get font_system_default;

  /// Note with plain text.
  ///
  /// In en, this message translates to:
  /// **'Plain text'**
  String get note_type_plain_text;

  /// Note with markdown text.
  ///
  /// In en, this message translates to:
  /// **'Markdown'**
  String get note_type_markdown;

  /// Note with rich text.
  ///
  /// In en, this message translates to:
  /// **'Rich text'**
  String get note_type_rich_text;

  /// Note with a checklist.
  ///
  /// In en, this message translates to:
  /// **'Checklist'**
  String get note_type_checklist;

  /// Reason for the lock screen of the application to request a system authentication.
  ///
  /// In en, this message translates to:
  /// **'Unlock Material Notes'**
  String get lock_page_reason_app;

  /// Reason for the lock screen of a locked note to request a system authentication.
  ///
  /// In en, this message translates to:
  /// **'Unlock this note'**
  String get lock_page_reason_note;

  /// Reason for the lock screen for a secure action to request a system authentication.
  ///
  /// In en, this message translates to:
  /// **'Authorize this action'**
  String get lock_page_reason_action;

  /// Description shown in the lock page for the application.
  ///
  /// In en, this message translates to:
  /// **'The application is locked.'**
  String get lock_page_description_app;

  /// Description shown in the lock page for a locked note.
  ///
  /// In en, this message translates to:
  /// **'This note is locked.'**
  String get lock_page_description_note;

  /// Button to unlock the lock page by requesting a system authentication.
  ///
  /// In en, this message translates to:
  /// **'Unlock'**
  String get lock_page_unlock;

  /// Title of the dialog to choose the foreground color of the text in the rich text editor.
  ///
  /// In en, this message translates to:
  /// **'Foreground color'**
  String get rich_text_editor_toolbar_dialog_color_title_foreground;

  /// Title of the dialog to choose the background color of the text in the rich text editor.
  ///
  /// In en, this message translates to:
  /// **'Background color'**
  String get rich_text_editor_toolbar_dialog_color_title_background;

  /// Description of the dialog to choose the foreground/background color of the text.
  ///
  /// In en, this message translates to:
  /// **'Foreground color'**
  String get rich_text_editor_toolbar_dialog_color_description;

  /// Title for the style of the rich text editor toolbar with one row and only simple formatting options.
  ///
  /// In en, this message translates to:
  /// **'One row (simple options)'**
  String get toolbar_style_one_row_simple_title;

  /// Description for the style of the rich text editor toolbar with one row and only simple formatting options.
  ///
  /// In en, this message translates to:
  /// **'Only simple formatting options on one row'**
  String get toolbar_style_one_row_simple_description;

  /// Title for the style of the rich text editor toolbar with one row and all formatting options.
  ///
  /// In en, this message translates to:
  /// **'One row (all options)'**
  String get toolbar_style_one_row_all_title;

  /// Description for the style of the rich text editor toolbar with one row and all formatting options.
  ///
  /// In en, this message translates to:
  /// **'All formatting formatting options on one row'**
  String get toolbar_style_one_row_all_description;

  /// Title for the style of the rich text editor toolbar with two stacked rows.
  ///
  /// In en, this message translates to:
  /// **'Two rows (stacked)'**
  String get toolbar_style_two_rows_stacked_title;

  /// Description for the style of the rich text editor toolbar with two stacked rows.
  ///
  /// In en, this message translates to:
  /// **'All formatting formatting options on two stacked rows'**
  String get toolbar_style_two_rows_stacked_description;

  /// Title for the style of the rich text editor toolbar with two toggleable rows.
  ///
  /// In en, this message translates to:
  /// **'Two rows (toggleable)'**
  String get toolbar_style_two_rows_toggleable_title;

  /// Description for the style of the rich text editor toolbar with two toggleable rows.
  ///
  /// In en, this message translates to:
  /// **'All formatting formatting options on two toggleable rows'**
  String get toolbar_style_two_rows_toggleable_description;

  /// Title of the setting tile for whether a confirmation is required before exiting the application.
  ///
  /// In en, this message translates to:
  /// **'Confirm before exiting'**
  String get settings_confirm_before_exiting_title;

  /// Description of the setting tile for whether a confirmation is required before exiting the application.
  ///
  /// In en, this message translates to:
  /// **'Ask for a confirmation before exiting the application'**
  String get settings_confirm_before_exiting_description;

  /// Snack bar asking the user to confirm exiting the application by pressing back again.
  ///
  /// In en, this message translates to:
  /// **'Press back again to exit the application.'**
  String get snack_bar_confirm_exiting;
}

class _AppLocalizationsDelegate extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'cs',
    'de',
    'en',
    'es',
    'fr',
    'hi',
    'it',
    'pl',
    'pt',
    'ru',
    'tr',
    'uk',
    'zh',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when language+script codes are specified.
  switch (locale.languageCode) {
    case 'zh':
      {
        switch (locale.scriptCode) {
          case 'Hant':
            return AppLocalizationsZhHant();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'cs':
      return AppLocalizationsCs();
    case 'de':
      return AppLocalizationsDe();
    case 'en':
      return AppLocalizationsEn();
    case 'es':
      return AppLocalizationsEs();
    case 'fr':
      return AppLocalizationsFr();
    case 'hi':
      return AppLocalizationsHi();
    case 'it':
      return AppLocalizationsIt();
    case 'pl':
      return AppLocalizationsPl();
    case 'pt':
      return AppLocalizationsPt();
    case 'ru':
      return AppLocalizationsRu();
    case 'tr':
      return AppLocalizationsTr();
    case 'uk':
      return AppLocalizationsUk();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
