// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.g.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get app_name => 'Material Notes';

  @override
  String get app_tagline => 'Proste, lokalne notatki w stylu Material Design';

  @override
  String app_about(String appName) {
    return '$appName to prosta, tekstowa aplikacja do robienia notatek, stworzona w stylu Material Design. Wszystko jest przechowywane lokalnie, nie ma nawet uprawnienia do internetu, dzięki czemu tylko Ty masz dostęp do swoich notatek.';
  }

  @override
  String get error_snack_bar => 'Błąd:';

  @override
  String get error_widget_title => 'Wystąpił błąd.';

  @override
  String get error_widget_description =>
      'Zgłoś ten problem na GitHubie lub przez e-mail. Dołącz zrzut ekranu i logi, które możesz skopiować lub wyeksportować poniżej. Aby uniknąć ewentualnej utraty lub uszkodzenia notatek, zalecane jest zrobienie kopii zapasowej.';

  @override
  String get error_widget_disabled_secure_flag =>
      'Ustawienie oznaczające aplikację jako bezpieczną jest wyłączone do następnego restartu, aby włączyć zrzuty ekranu.';

  @override
  String get error_widget_button_export_notes => 'Wyeksportuj notatki';

  @override
  String get error_widget_button_copy_logs => 'Skopiuj logi';

  @override
  String get error_widget_button_export_logs => 'Wyeksportuj logi';

  @override
  String get error_widget_button_create_github_issue => 'Utwórz problem na GitHubie';

  @override
  String get error_widget_button_send_mail => 'Wyślij e-mail';

  @override
  String get navigation_notes => 'Notatki';

  @override
  String get navigation_manage_labels_destination => 'Zarządzaj tagami';

  @override
  String get navigation_manage_labels_page => 'Tagi';

  @override
  String get navigation_archives => 'Archiwum';

  @override
  String get navigation_bin => 'Kosz';

  @override
  String get navigation_settings => 'Ustawienia';

  @override
  String get navigation_settings_appearance => 'Wygląd';

  @override
  String get navigation_settings_notes_types => 'Typy notatek';

  @override
  String get navigation_settings_notes_tiles => 'Kafelki notatek';

  @override
  String get navigation_settings_behavior => 'Zachowanie';

  @override
  String get navigation_settings_editor => 'Edytor';

  @override
  String get navigation_settings_labels => 'Tagi';

  @override
  String get navigation_settings_backup => 'Kopia zapasowa';

  @override
  String get navigation_settings_security => 'Bezpieczeństwo';

  @override
  String get navigation_settings_accessibility => 'Dostępność';

  @override
  String get navigation_settings_help => 'Pomoc';

  @override
  String get navigation_settings_about => 'O aplikacji';

  @override
  String get button_sort_title => 'Tytuł';

  @override
  String get button_sort_ascending => 'Rosnąco';

  @override
  String get settings_page_appearance => 'Wygląd';

  @override
  String get settings_page_appearance_description => 'Język, motywy, czcionki';

  @override
  String get settings_language => 'Język';

  @override
  String get settings_language_contribute => 'Przetłumacz';

  @override
  String get settings_appearance_section_theming => 'Motywy';

  @override
  String get settings_theme => 'Motyw';

  @override
  String get settings_theme_system => 'Systemowy';

  @override
  String get settings_theme_light => 'Jasny';

  @override
  String get settings_theme_dark => 'Ciemny';

  @override
  String get settings_dynamic_theming => 'Kolory dynamiczne';

  @override
  String get settings_dynamic_theming_description => 'Kolory aplikacji dopasują się do reszty systemu';

  @override
  String get settings_black_theming => 'Czarne tło w ciemnym motywie';

  @override
  String get settings_black_theming_description => 'Użyj czarnego tła w ciemnym motywie';

  @override
  String get settings_appearance_section_fonts => 'Czcionki';

  @override
  String get settings_app_font => 'Czcionka aplikacji';

  @override
  String get settings_app_font_description =>
      'Czcionka używana do wszystkich tekstów w aplikacji, z wyjątkiem edytora notatek';

  @override
  String get settings_editor_font => 'Czcionka edytora';

  @override
  String get settings_editor_font_description => 'Czcionka używana tylko dla tekstu w edytorze notatek';

  @override
  String get settings_page_notes_tiles => 'Kafelki notatek';

  @override
  String get settings_page_notes_tiles_description => 'Wygląd, zawartość';

  @override
  String get settings_page_notes_tiles_appearance_section => 'Wygląd';

  @override
  String get settings_page_notes_tiles_content_section => 'Zawartość';

  @override
  String get settings_show_tiles_background => 'Tło';

  @override
  String get settings_show_tiles_background_description => 'Pokaż tło kafelków notatek';

  @override
  String get settings_show_separators => 'Separatory';

  @override
  String get settings_show_separators_description => 'Pokaż separatory między kafelkami notatek';

  @override
  String get settings_show_note_type_icon => 'Pokaż ikonę typu';

  @override
  String get settings_show_note_type_icon_description => 'Pokaż ikonę typu notatki';

  @override
  String get settings_show_titles_only => 'Tylko tytuł';

  @override
  String get settings_show_titles_only_description => 'Pokazuj tylko tytuły notatek';

  @override
  String get settings_show_titles_only_disable_in_search_view => 'Pokazuj fragmenty notatek podczas wyszukiwania';

  @override
  String get settings_show_titles_only_disable_in_search_view_description =>
      'Ignoruj opcję \"Tylko tytuły\" podczas wyszukiwania';

  @override
  String get settings_content_preview_max_lines => 'Maksymalna podgląd wierszy';

  @override
  String get settings_content_preview_max_lines_description =>
      'Maksymalna liczba linii podglądu zawartości do pokazania';

  @override
  String get settings_behavior => 'Zachowanie';

  @override
  String get settings_behavior_description => 'Potwierdzenia, akcje przesuwania palcem';

  @override
  String get settings_behavior_application => 'Aplikacja';

  @override
  String get settings_confirmations => 'Dialogi potwierdzenia';

  @override
  String get settings_confirmations_description => 'Kiedy pokazywać potwierdzenie podczas wykonywania akcji na notatce';

  @override
  String get settings_confirmations_title_none => 'Nigdy';

  @override
  String get settings_confirmations_title_irreversible => 'Tylko akcje nieodwracalne';

  @override
  String get settings_confirmations_title_all => 'Zawsze';

  @override
  String get settings_auto_remove_from_bin_title => 'Automatyczne usuwanie z kosza';

  @override
  String get settings_auto_remove_from_bin_description => 'Automatyczne usuwanie notatek z kosza';

  @override
  String settings_auto_remove_from_bin_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '7': 'Po tygodniu',
      '14': 'Po dwóch tygodniach',
      '30': 'Po miesiącu',
      '90': 'Po trzech miesiącach',
      '180': 'Po pół roku',
      '365': 'Po roku',
      'other': 'Nigdy',
    });
    return '$_temp0';
  }

  @override
  String get settings_behavior_swipe_actions => 'Gesty przesunięcia palcem';

  @override
  String get settings_behavior_swipe_actions_archives => 'Akcje przesuwania (archiwum)';

  @override
  String get settings_behavior_swipe_actions_bin => 'Akcje przesuwania (kosz)';

  @override
  String get settings_swipe_action_right => 'Akcja przesunięcia w prawo';

  @override
  String get settings_swipe_action_right_description => 'Akcja uruchamiana, gdy przesuwasz kafelek notatki w prawo';

  @override
  String get settings_bin_swipe_action_right_description =>
      'Akcja uruchamiana, gdy przesuwasz w prawo, kafelek notatki w koszu';

  @override
  String get settings_swipe_action_left => 'Akcja przesunięcia w lewo';

  @override
  String get settings_swipe_action_left_description => 'Akcja uruchamiana, gdy przesuwasz kafelek notatki w lewo';

  @override
  String get settings_bin_swipe_action_left_description =>
      'Akcja uruchamiana, gdy przesuwasz w lewo, kafelek notatki w koszu';

  @override
  String get settings_page_notes_types => 'Typy notatek';

  @override
  String get settings_page_notes_types_description => 'Typy do użycia, wzbogacony tekst';

  @override
  String get settings_section_types_to_use => 'Typy do użycia';

  @override
  String get settings_available_notes_types => 'Dostępne typy notatek';

  @override
  String get settings_available_notes_types_description =>
      'Lista typów notatek, które można utworzyć za pomocą przycisku \"Dodaj\" ze strony notatki. Podczas usuwania typu już istniejące notatki tego typu nie są usuwane i nadal mogą być używane normalnie';

  @override
  String get settings_available_default_share_type => 'Domyślny typ udostępniania';

  @override
  String get settings_available_default_share_type_description =>
      'Domyślny typ notatki podczas tworzenia notatki z akcji współdzielenia. Może to być typ, który nie jest dostępny z przycisku \"Dodaj\"';

  @override
  String get settings_editor => 'Edytor';

  @override
  String get settings_editor_description => 'Zachowanie';

  @override
  String get settings_editor_behavior => 'Zachowanie';

  @override
  String get settings_show_editor_mode_button => 'Przycisk trybu edycji';

  @override
  String get settings_show_editor_mode_button_description =>
      'Pokaż przycisk przełączający pomiędzy trybem edycji a trybem czytania';

  @override
  String get settings_open_editor_reading_mode => 'Otwórz w trybie czytania';

  @override
  String get settings_open_editor_reading_mode_description => 'Domyślnie otwieraj edytor w trybie czytania';

  @override
  String get settings_focus_title_on_new_note => 'Skup się na tytule';

  @override
  String get settings_focus_title_on_new_note_description =>
      'Skup się na tytule, zamiast na zawartości, podczas tworzenia nowej notatki';

  @override
  String get settings_editor_appearance => 'Wygląd';

  @override
  String get settings_toolbar_style_title => 'Styl paska narzędzi';

  @override
  String get settings_toolbar_style_description => 'Styl paska narzędzi bogatego edytora tekstu';

  @override
  String get settings_use_paragraph_spacing => 'Odstęp między akapitami';

  @override
  String get settings_use_paragraph_spacing_description => 'Zachowaj odstęp między akapitami';

  @override
  String get settings_labels => 'Tagi';

  @override
  String get settings_labels_description => 'Włącz, wygląd';

  @override
  String get settings_enable_labels => 'Włącz';

  @override
  String get settings_enable_labels_description =>
      'Pozwala skategoryzować notatki tagami (nie usuwa tagów ani nie usuwa ich z notatek, tylko je ukrywa)';

  @override
  String get settings_labels_appearance => 'Wygląd';

  @override
  String get settings_show_labels_note_tile => 'Pokaż tagi na kafelku notatki';

  @override
  String get settings_show_labels_note_tile_description => 'Pokaż listę tagów na kafelku notatki';

  @override
  String get settings_show_labels_editor => 'Pokaż tagi w edytorze';

  @override
  String get settings_show_labels_editor_description => 'Pokaż listę tagów na dole edytora';

  @override
  String get settings_labels_section_behavior => 'Zachowanie';

  @override
  String get settings_labels_swipe_action_right => 'Akcja przesunięcia w prawo';

  @override
  String get settings_labels_swipe_action_right_description =>
      'Akcja uruchamiana, gdy przesuwasz kafelek notatki w prawo';

  @override
  String get settings_labels_swipe_action_left => 'Akcja przesunięcia w lewo';

  @override
  String get settings_labels_swipe_action_left_description =>
      'Akcja uruchamiana, gdy przesuwasz kafelek notatki w lewo';

  @override
  String get settings_backup => 'Kopia zapasowa';

  @override
  String get settings_backup_description => 'Ręczny i automatyczny eksport, szyfrowanie, import';

  @override
  String get settings_backup_import => 'Importuj';

  @override
  String get settings_import => 'Importuj';

  @override
  String get settings_import_description => 'Importuj notatki, tagi i ustawienia z pliku JSON';

  @override
  String get settings_backup_manual_export => 'Eksportuj ręcznie';

  @override
  String get settings_export_json => 'Eksportuj jako JSON';

  @override
  String get settings_export_json_description =>
      'Natychmiast wyeksportuj wszystkie notatki, tagi i ustawienia do pliku JSON, który może być importowany z powrotem';

  @override
  String get settings_export_markdown => 'Wyeksportuj jako Markdown';

  @override
  String get settings_export_markdown_description => 'Natychmiast wyeksportuj wszystkie notatki do pliku Markdown';

  @override
  String get settings_backup_auto_export => 'Automatyczny eksport';

  @override
  String get settings_auto_export => 'Automatyczny eksport';

  @override
  String get settings_auto_export_description =>
      'Automatycznie wyeksportuj wszystkie notatki, tagi i ustawienia do pliku JSON, który można importować z powrotem';

  @override
  String get settings_auto_export_frequency => 'Częstotliwość';

  @override
  String settings_auto_export_frequency_value(String frequency) {
    String _temp0 = intl.Intl.selectLogic(frequency, {
      '1': 'Codziennie',
      '7': 'Co tydzień',
      '14': 'Co 2 tygodnie',
      '30': 'Co miesiąc',
      'other': '',
    });
    return '$_temp0';
  }

  @override
  String get settings_auto_export_frequency_description => 'Częstotliwość automatycznego eksportowania notatek';

  @override
  String get settings_auto_export_encryption => 'Szyfrowanie';

  @override
  String get settings_auto_export_encryption_description => 'Zaszyfruj tytuł i zawartość notatek hasłem';

  @override
  String get settings_auto_export_directory => 'Katalog';

  @override
  String get settings_auto_export_directory_description =>
      'Katalog do przechowywania automatycznie wyeksportowanych notatek';

  @override
  String get settings_security => 'Bezpieczeństwo';

  @override
  String get settings_security_description => 'Bezpieczna flaga, blokada aplikacji, blokada notatek';

  @override
  String get settings_security_application => 'Aplikacja';

  @override
  String get settings_security_application_lock => 'Blokada aplikacji';

  @override
  String get settings_security_note_lock => 'Blokada notatki';

  @override
  String get settings_flag_secure => 'Oflaguj aplikację jako bezpieczną';

  @override
  String get settings_flag_secure_description =>
      'Ukryj treść aplikacji w ostatnich aplikacjach oraz zapobiegaj zrzutom ekranu';

  @override
  String get settings_application_lock_title => 'Blokada';

  @override
  String get settings_application_lock_description =>
      'Zablokuj aplikację i wymagaj uwierzytelnienia na urządzeniu, aby ją odblokować';

  @override
  String get settings_application_lock_delay_title => 'Opóźnienie blokady';

  @override
  String get settings_application_lock_delay_description =>
      'Opóźnienie, po którym aplikacja blokuje się po przeniesieniu do tła';

  @override
  String settings_lock_delay_value(String delay) {
    String _temp0 = intl.Intl.selectLogic(delay, {
      '0': 'Natychmiast',
      '3': 'Po 3 sekundach',
      '5': 'Po 5 sekundach',
      '10': 'Po 10 sekundach',
      '30': 'Po 30 sekundach',
      '60': 'Po 1 minucie',
      '120': 'Po 2 minutach',
      '300': 'Po 5 minutach',
      'other': 'Nigdy',
    });
    return '$_temp0';
  }

  @override
  String get settings_note_lock_title => 'Blokada notatki';

  @override
  String get settings_note_lock_description =>
      'Zablokuj notatkę i wymagaj uwierzytelnienia na urządzeniu, aby ją przeglądać i edytować';

  @override
  String get settings_label_lock_title => 'Blokada tagu';

  @override
  String get settings_label_lock_description =>
      'Zablokuj tag i wymaga uwierzytelnienia na urządzeniu, aby wyświetlić i edytować każdą notatkę go zawierającą';

  @override
  String get settings_note_lock_delay_title => 'Opóźnienie blokady';

  @override
  String get settings_note_lock_delay_description =>
      'Opóźnienie, po którym notatka blokuje się, gdy aplikacja jest przeniesiona do tła';

  @override
  String get settings_accessibility => 'Dostępność';

  @override
  String get settings_accessibility_text_size => 'Rozmiar tekstu';

  @override
  String get settings_accessibility_text_color => 'Kolor tekstu';

  @override
  String get settings_accessibility_description => 'Kolor tekstu, skalowanie tekstu';

  @override
  String get settings_text_scaling => 'Wielkość tekstu';

  @override
  String get settings_bigger_titles => 'Większe tytuły';

  @override
  String get settings_bigger_titles_description => 'Pokaż większe tytuły na płytkach notatki oraz w edytorze';

  @override
  String get settings_white_text_dark_mode => 'Tekst w trybie ciemnym';

  @override
  String get settings_white_text_dark_mode_description => 'Użyj białego koloru tekstu w trybie ciemnym';

  @override
  String get settings_disable_subdued_note_content_preview => 'Kontrastowy kolor dla podglądu notatki';

  @override
  String get settings_disable_subdued_note_content_preview_description =>
      'Kolor podglądu notatki będzie taki sam jak kolor tytułu, co skutkuje lepszym kontrastem';

  @override
  String get settings_help_section_contact => 'Kontakt';

  @override
  String get settings_github_issues => 'Zgłoś błąd lub zaproponuj nową funkcję';

  @override
  String get settings_github_issues_description =>
      'Zgłoś błąd lub poproś o nową funkcję tworząc zgłoszenie na GitHubie';

  @override
  String get settings_github_discussions => 'Zadaj pytanie';

  @override
  String get settings_github_discussions_description => 'Zadaj pytanie w dyskusjach na GitHubie';

  @override
  String get settings_contact_developer => 'Kontakt z twórcą aplikacji';

  @override
  String settings_get_in_touch_description(Object email) {
    return 'Skontaktuj się z twórcą aplikacji - $email';
  }

  @override
  String get settings_help => 'Pomoc';

  @override
  String get settings_help_description => 'Kontakt, logi';

  @override
  String get settings_help_section_logs => 'Logi';

  @override
  String get settings_copy_logs => 'Skopiuj logi';

  @override
  String get settings_copy_logs_description => 'Skopiuj logi aplikacji do schowka';

  @override
  String get settings_export_logs => 'Wyeksportuj logi';

  @override
  String get settings_export_logs_description => 'Eksportuj logi aplikacji do pliku tekstowego';

  @override
  String get settings_about => 'O aplikacji';

  @override
  String get settings_about_description => 'Informacje, linki, darowizna';

  @override
  String get settings_about_application => 'Aplikacja';

  @override
  String get settings_build_mode => 'Typ kompilacji';

  @override
  String get settings_build_mode_release => 'Produkcyjna';

  @override
  String get settings_build_mode_debug => 'Debug';

  @override
  String get settings_about_links => 'Linki';

  @override
  String get settings_github => 'GitHub';

  @override
  String get settings_github_description => 'Zobacz kod źródłowy';

  @override
  String get settings_localizations => 'Crowdin';

  @override
  String get settings_localizations_description => 'Przetłumacz aplikację na Twój język';

  @override
  String get settings_licence => 'Licencja';

  @override
  String get settings_licence_description => 'AGPL-3.0';

  @override
  String get settings_about_section_donate => 'Przekaż darowiznę';

  @override
  String get settings_donate_kofi => 'Ko-fi';

  @override
  String get settings_donate_paypal => 'PayPal';

  @override
  String get hint_title => 'Tytuł';

  @override
  String get hint_content => 'Notatka';

  @override
  String get hint_link => 'Odnośnik';

  @override
  String get hint_label_name => 'Nazwa';

  @override
  String get dialog_export_encryption_password => 'Hasło';

  @override
  String get dialog_select_labels => 'Wybierz tagi';

  @override
  String get dialog_select_labels_to_add => 'Wybierz tagi do dodania';

  @override
  String get tooltip_undo => 'Cofnij ostatnią akcję';

  @override
  String get tooltip_redo => 'Ponów ostatnią akcję';

  @override
  String get tooltip_fab_add_note => 'Dodaj notatkę';

  @override
  String get tooltip_fab_add_plain_text_note => 'Dodaj zwykłą notatkę tekstową';

  @override
  String get tooltip_fab_add_markdown_note => 'Dodaj notatkę z formatowaniem';

  @override
  String get tooltip_fab_add_rich_text_note => 'Dodaj wzbogaconą notatkę tekstową';

  @override
  String get tooltip_fab_add_checklist_note => 'Dodaj listę kontrolną';

  @override
  String get tooltip_fab_add_label => 'Dodaj tag';

  @override
  String get tooltip_fab_empty_bin => 'Opróżnij kosz';

  @override
  String get tooltip_fab_toggle_editor_mode_edit => 'Przełącz na tryb edycji';

  @override
  String get tooltip_fab_toggle_editor_mode_read => 'Przełącz na tryb czytania';

  @override
  String get tooltip_layout_list => 'Lista';

  @override
  String get tooltip_layout_grid => 'Siatka';

  @override
  String get tooltip_sort => 'Sortowanie notatek';

  @override
  String get tooltip_search => 'Przeszukaj notatki';

  @override
  String get tooltip_unselect_all => 'Odznacz wszystko';

  @override
  String get tooltip_reset => 'Zresetuj';

  @override
  String get dialog_add_link => 'Dodaj odnośnik';

  @override
  String get dialog_archive => 'Archiwizuj';

  @override
  String dialog_archive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notatki', one: 'notatkę');
    return 'Czy na pewno chcesz zarchiwizować $count $_temp0?';
  }

  @override
  String get dialog_unarchive => 'Usuń z archiwum';

  @override
  String dialog_unarchive_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'te notatki', one: 'tą notatkę');
    return 'Czy na pewno chcesz usunąć $count $_temp0 z archiwum?';
  }

  @override
  String get dialog_delete => 'Usuń';

  @override
  String dialog_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'te notatki', one: 'tą notatkę');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'je', one: 'ją');
    return 'Czy na pewno chcesz skasować $count $_temp0? Możesz przywrócić $_temp1 z kosza.';
  }

  @override
  String get dialog_permanently_delete => 'Usuń trwale';

  @override
  String dialog_permanently_delete_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'te notatki', one: 'tą notatkę');
    String _temp1 = intl.Intl.pluralLogic(count, locale: localeName, other: 'ich', one: 'jej');
    return 'Czy na pewno chcesz trwale skasować $count $_temp0? Ta operacja jest nieodwracalna i nie będziesz mógł $_temp1 przywrócić.';
  }

  @override
  String get dialog_restore => 'Przywróć';

  @override
  String dialog_restore_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'te notatki', one: 'tą notatkę');
    return 'Czy na pewno chcesz przywrócić $count $_temp0?';
  }

  @override
  String get dialog_empty_bin => 'Opróżnij kosz';

  @override
  String get dialog_empty_bin_body => 'Opróżnić kosz? Tego nie da się cofnąć.';

  @override
  String get dialog_delete_label => 'Skasuj';

  @override
  String dialog_delete_label_body(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'te tagi', one: 'tego taga');
    String _temp1 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Tagi będą usunięte',
      one: 'Tag będzie usunięty',
    );
    String _temp2 = intl.Intl.pluralLogic(count, locale: localeName, other: 'nimi', one: 'nim');
    return 'Czy na pewno chcesz skasować $count $_temp0? $_temp1 z notatek $_temp2 oznaczonych.';
  }

  @override
  String get dialog_export_encryption_switch => 'Zaszyfruj JSON podczas eksportu';

  @override
  String get dialog_export_encryption_description =>
      'Tytuł i treść notatek będą zaszyfrowane przy użyciu hasła. Powinno być ono wygenerowane losowo, mieć 32 znaki, być silne (co najmniej 1 mała litera, 1 duża litera, 1 liczba i 1 znak specjalny) i bezpiecznie przechowywane.';

  @override
  String get dialog_export_encryption_secondary_description_auto =>
      'To hasło będzie używane dla wszystkich przyszłych automatycznych eksportów.';

  @override
  String get dialog_export_encryption_secondary_description_manual =>
      'To hasło zostanie użyte tylko dla tego eksportu.';

  @override
  String get dialog_export_encryption_password_invalid => 'Nieprawidłowe hasło';

  @override
  String get dialog_import_encryption_password_description =>
      'Ten eksport jest zaszyfrowany. Aby go zaimportować, musisz podać hasło użyte do szyfrowania go.';

  @override
  String get dialog_import_encryption_password_error =>
      'nie udało się odszyfrować notatek. Upewnij się, że podałeś to samo hasło, którego użyłeś do szyfrowania eksportu.';

  @override
  String get dialog_label_add => 'Dodaj tag';

  @override
  String get dialog_label_edit => 'Edytuj tag';

  @override
  String get dialog_label_name_cannot_be_empty => 'Nazwa nie może być pusta.';

  @override
  String get dialog_label_name_already_used => 'Ta nazwa jest już używana.';

  @override
  String get button_sort_creation_date => 'Data utworzenia ';

  @override
  String get button_sort_edition_date => 'Data edycji';

  @override
  String get placeholder_notes => 'Brak notatek';

  @override
  String get placeholder_labels => 'Brak tagów';

  @override
  String get placeholder_archives => 'Brak notatek w archiwum';

  @override
  String get placeholder_bin => 'Brak usuniętych notatek';

  @override
  String get action_disabled => 'Wyłączone';

  @override
  String get action_toggle_pin => 'Przełącz piny';

  @override
  String get action_pin_unpin => 'Przypnij / Odepnij';

  @override
  String get action_pin => 'Przypnij';

  @override
  String get action_unpin => 'Odepnij';

  @override
  String get action_toggle_lock => 'Przełącz blokadę';

  @override
  String get action_lock_unlock => 'Zablokuj / Odblokuj';

  @override
  String get action_lock => 'Zablokuj';

  @override
  String get action_unlock => 'Odblokuj';

  @override
  String get action_share => 'Udostępnij';

  @override
  String action_share_subject(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notatki udostępnione',
      one: 'Notatka udostępniona',
    );
    return '$count $_temp0 z Material Notes';
  }

  @override
  String get action_archive => 'Archiwizuj';

  @override
  String get action_unarchive => 'Usuń z archiwum';

  @override
  String get action_delete => 'Usuń';

  @override
  String get action_restore => 'Przywróć';

  @override
  String get action_delete_permanently => 'Usuń trwale';

  @override
  String get action_about => 'Informacja';

  @override
  String get about_last_edited => 'Ostatnio edytowane';

  @override
  String get about_type => 'Typ';

  @override
  String get about_created => 'Utworzono';

  @override
  String get about_labels => 'Tagi';

  @override
  String get about_words => 'Słowa';

  @override
  String get about_characters => 'Znaki';

  @override
  String get about_time_at => 'na';

  @override
  String get menu_action_select_labels => 'Tagi';

  @override
  String get menu_action_add_labels => 'Dodaj tagi';

  @override
  String get action_labels_toggle_visibile => 'Przełącz widzialność';

  @override
  String get action_labels_show_hide => 'Pokaż/ Ukryj';

  @override
  String get action_labels_show => 'Pokaż';

  @override
  String get action_labels_hide => 'Ukryj';

  @override
  String get action_labels_toggle_pins => 'Przypnij / Odepnij';

  @override
  String get action_labels_pin_unpin => 'Przypnij / Odepnij';

  @override
  String get action_labels_pin => 'Przypnij';

  @override
  String get action_labels_unpin => 'Odepnij';

  @override
  String get action_labels_toggle_lock => 'Przełącz blokadę';

  @override
  String get action_labels_lock_unlock => 'Zablokuj / Odblokuj';

  @override
  String get action_labels_lock => 'Zablokuj';

  @override
  String get action_labels_unlock => 'Odblokuj';

  @override
  String get action_labels_edit => 'Edytuj';

  @override
  String get action_labels_delete => 'Skasuj';

  @override
  String get filter_labels_all => 'Wszystkie';

  @override
  String get filter_labels_visible => 'Ukryte';

  @override
  String get filter_labels_hidden => 'Ukryte';

  @override
  String get filter_labels_pinned => 'Przypięte';

  @override
  String get filter_labels_locked => 'Zablokowany';

  @override
  String get snack_bar_authentication_failed => 'Uwierzytelnianie nie powiodło się, spróbuj ponownie.';

  @override
  String snack_bar_archived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notatki zostały dodane',
      one: 'Notatka została dodana',
    );
    return '$_temp0 do archiwum';
  }

  @override
  String snack_bar_unarchived(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notatki zostały usunięte',
      one: 'Notatka została usunięta',
    );
    return '$_temp0 z archiwum';
  }

  @override
  String snack_bar_deleted(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notatki zostały skasowane',
      one: 'Notatka została skasowana',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_restored(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Notatki zostały przywrócone',
      one: 'Notatka została przywrócona',
    );
    return '$_temp0';
  }

  @override
  String snack_bar_copied(int count) {
    String _temp0 = intl.Intl.pluralLogic(count, locale: localeName, other: 'notatek', one: 'notatki');
    return 'Zawartość $_temp0 skopiowano do schowka.';
  }

  @override
  String get snack_bar_import_success => 'Notatki zostały zaimportowane.';

  @override
  String get snack_bar_export_success => 'Notatki zostały wyeksportowane.';

  @override
  String get snack_bar_logs_copied => 'Skopiowano logi do schowka.';

  @override
  String get snack_bar_logs_exported => 'Logi zostały wyeksportowane.';

  @override
  String get snack_bar_no_labels => 'Brak tagów.';

  @override
  String get quick_action_add_plain_text_note_title => 'Dodaj zwykłą notatkę tekstową';

  @override
  String get quick_action_add_markdown_note_title => 'Dodaj notatkę z formatowaniem';

  @override
  String get quick_action_add_rich_text_note_title => 'Dodaj wzbogaconą notatkę tekstową';

  @override
  String get quick_action_add_checklist_note_title => 'Dodaj listę kontrolną';

  @override
  String get welcome_note_title => 'Witaj w Material Notes!';

  @override
  String get welcome_note_content => 'Proste, lokalne notatki w stylu Material Design';

  @override
  String get font_system_default => 'Domyślny systemowy';

  @override
  String get note_type_plain_text => 'Zwykły tekst';

  @override
  String get note_type_markdown => 'Formatowanie';

  @override
  String get note_type_rich_text => 'Tekst wzbogacony';

  @override
  String get note_type_checklist => 'Lista kontrolna';

  @override
  String get lock_page_reason_app => 'Odblokuj Material Notes';

  @override
  String get lock_page_reason_note => 'Odblokuj tę notatkę';

  @override
  String get lock_page_reason_action => 'Autoryzuj tę akcję';

  @override
  String get lock_page_description_app => 'Aplikacja jest zablokowana.';

  @override
  String get lock_page_description_note => 'Ta notatka jest zablokowana.';

  @override
  String get lock_page_unlock => 'Odblokuj';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_foreground => 'Kolor pierwszego planu';

  @override
  String get rich_text_editor_toolbar_dialog_color_title_background => 'Kolor tła';

  @override
  String get rich_text_editor_toolbar_dialog_color_description => 'Kolor pierwszego planu';

  @override
  String get toolbar_style_one_row_simple_title => 'Jeden wiersz (opcje proste)';

  @override
  String get toolbar_style_one_row_simple_description => 'Tylko proste opcje formatowania w jednym wierszu';

  @override
  String get toolbar_style_one_row_all_title => 'Jeden wiersz (wszystkie opcje)';

  @override
  String get toolbar_style_one_row_all_description => 'Wszystkie opcje formatowania w jednym wierszu';

  @override
  String get toolbar_style_two_rows_stacked_title => 'Dwa wiersze (złożone)';

  @override
  String get toolbar_style_two_rows_stacked_description => 'Wszystkie opcje formatowania w dwóch złożonych wierszach';

  @override
  String get toolbar_style_two_rows_toggleable_title => 'Dwa wiersze (przełączalne)';

  @override
  String get toolbar_style_two_rows_toggleable_description =>
      'Wszystkie opcje formatowania w dwóch wierszach, które można przełączyć';

  @override
  String get settings_confirm_before_exiting_title => 'Potwierdź przed wyjściem';

  @override
  String get settings_confirm_before_exiting_description => 'Poproś o potwierdzenie przed wyjściem z aplikacji';

  @override
  String get snack_bar_confirm_exiting => 'Naciśnij ponownie, aby wyjść z aplikacji.';
}
