/// This file contains the raw data of the timezones.
Map<String, Map<String, dynamic>> getTimezonesRawData() => {
      'Africa/Bissau': {
        'timezone': 'Africa/Bissau',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'Africa/Maputo': {
        'timezone': 'Africa/Maputo',
        'raw_offset': 7200,
        'abbreviation': 'CAT',
        'dst_offset': 0,
      },
      'Africa/Monrovia': {
        'timezone': 'Africa/Monrovia',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'Africa/Sao_Tome': {
        'timezone': 'Africa/Sao_Tome',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'Africa/Tunis': {
        'timezone': 'Africa/Tunis',
        'raw_offset': 3600,
        'abbreviation': 'CET',
        'dst_offset': 0,
      },
      'Africa/Windhoek': {
        'timezone': 'Africa/Windhoek',
        'raw_offset': 7200,
        'abbreviation': 'CAT',
        'dst_offset': 0,
      },
      'America/Anchorage': {
        'timezone': 'America/Anchorage',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'America/Araguaina': {
        'timezone': 'America/Araguaina',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Cordoba': {
        'timezone': 'America/Argentina/Cordoba',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Mendoza': {
        'timezone': 'America/Argentina/Mendoza',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Tucuman': {
        'timezone': 'America/Argentina/Tucuman',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Asuncion': {
        'timezone': 'America/Asuncion',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Bahia': {
        'timezone': 'America/Bahia',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Barbados': {
        'timezone': 'America/Barbados',
        'raw_offset': -14400,
        'abbreviation': 'AST',
        'dst_offset': 0,
      },
      'America/Chihuahua': {
        'timezone': 'America/Chihuahua',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Ciudad_Juarez': {
        'timezone': 'America/Ciudad_Juarez',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Costa_Rica': {
        'timezone': 'America/Costa_Rica',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Cuiaba': {
        'timezone': 'America/Cuiaba',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Danmarkshavn': {
        'timezone': 'America/Danmarkshavn',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'America/Edmonton': {
        'timezone': 'America/Edmonton',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Fort_Nelson': {
        'timezone': 'America/Fort_Nelson',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Glace_Bay': {
        'timezone': 'America/Glace_Bay',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'America/Guyana': {
        'timezone': 'America/Guyana',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Halifax': {
        'timezone': 'America/Halifax',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'America/Havana': {
        'timezone': 'America/Havana',
        'raw_offset': -18000,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Knox': {
        'timezone': 'America/Indiana/Knox',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Marengo': {
        'timezone': 'America/Indiana/Marengo',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Winamac': {
        'timezone': 'America/Indiana/Winamac',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Inuvik': {
        'timezone': 'America/Inuvik',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Matamoros': {
        'timezone': 'America/Matamoros',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Mexico_City': {
        'timezone': 'America/Mexico_City',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/New_York': {
        'timezone': 'America/New_York',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/North_Dakota/Center': {
        'timezone': 'America/North_Dakota/Center',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Phoenix': {
        'timezone': 'America/Phoenix',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Porto_Velho': {
        'timezone': 'America/Porto_Velho',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Recife': {
        'timezone': 'America/Recife',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Rio_Branco': {
        'timezone': 'America/Rio_Branco',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'America/Santarem': {
        'timezone': 'America/Santarem',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Santiago': {
        'timezone': 'America/Santiago',
        'raw_offset': -14400,
        'abbreviation': '-03',
        'dst_offset': 3600,
      },
      'America/Sao_Paulo': {
        'timezone': 'America/Sao_Paulo',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/St_Johns': {
        'timezone': 'America/St_Johns',
        'raw_offset': -12600,
        'abbreviation': 'NDT',
        'dst_offset': 3600,
      },
      'America/Toronto': {
        'timezone': 'America/Toronto',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Whitehorse': {
        'timezone': 'America/Whitehorse',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'Antarctica/Mawson': {
        'timezone': 'Antarctica/Mawson',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Antarctica/Vostok': {
        'timezone': 'Antarctica/Vostok',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Amman': {
        'timezone': 'Asia/Amman',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Asia/Ashgabat': {
        'timezone': 'Asia/Ashgabat',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Atyrau': {
        'timezone': 'Asia/Atyrau',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Baghdad': {
        'timezone': 'Asia/Baghdad',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Asia/Barnaul': {
        'timezone': 'Asia/Barnaul',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Dhaka': {
        'timezone': 'Asia/Dhaka',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Asia/Hong_Kong': {
        'timezone': 'Asia/Hong_Kong',
        'raw_offset': 28800,
        'abbreviation': 'HKT',
        'dst_offset': 0,
      },
      'Asia/Jerusalem': {
        'timezone': 'Asia/Jerusalem',
        'raw_offset': 7200,
        'abbreviation': 'IDT',
        'dst_offset': 3600,
      },
      'Asia/Karachi': {
        'timezone': 'Asia/Karachi',
        'raw_offset': 18000,
        'abbreviation': 'PKT',
        'dst_offset': 0,
      },
      'Asia/Kathmandu': {
        'timezone': 'Asia/Kathmandu',
        'raw_offset': 20700,
        'abbreviation': '+0545',
        'dst_offset': 0,
      },
      'Asia/Kolkata': {
        'timezone': 'Asia/Kolkata',
        'raw_offset': 19800,
        'abbreviation': 'IST',
        'dst_offset': 0,
      },
      'Asia/Macau': {
        'timezone': 'Asia/Macau',
        'raw_offset': 28800,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'Asia/Manila': {
        'timezone': 'Asia/Manila',
        'raw_offset': 28800,
        'abbreviation': 'PST',
        'dst_offset': 0,
      },
      'Asia/Novosibirsk': {
        'timezone': 'Asia/Novosibirsk',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Omsk': {
        'timezone': 'Asia/Omsk',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Asia/Pontianak': {
        'timezone': 'Asia/Pontianak',
        'raw_offset': 25200,
        'abbreviation': 'WIB',
        'dst_offset': 0,
      },
      'Asia/Qyzylorda': {
        'timezone': 'Asia/Qyzylorda',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Riyadh': {
        'timezone': 'Asia/Riyadh',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Asia/Samarkand': {
        'timezone': 'Asia/Samarkand',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Tehran': {
        'timezone': 'Asia/Tehran',
        'raw_offset': 12600,
        'abbreviation': '+0330',
        'dst_offset': 0,
      },
      'Asia/Thimphu': {
        'timezone': 'Asia/Thimphu',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Asia/Vladivostok': {
        'timezone': 'Asia/Vladivostok',
        'raw_offset': 36000,
        'abbreviation': '+10',
        'dst_offset': 0,
      },
      'Asia/Yangon': {
        'timezone': 'Asia/Yangon',
        'raw_offset': 23400,
        'abbreviation': '+0630',
        'dst_offset': 0,
      },
      'Australia/Darwin': {
        'timezone': 'Australia/Darwin',
        'raw_offset': 34200,
        'abbreviation': 'ACST',
        'dst_offset': 0,
      },
      'Australia/Melbourne': {
        'timezone': 'Australia/Melbourne',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'EET': {
        'timezone': 'EET',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'EST5EDT': {
        'timezone': 'EST5EDT',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'Etc/GMT': {
        'timezone': 'Etc/GMT',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'Etc/GMT+1': {
        'timezone': 'Etc/GMT+1',
        'raw_offset': -3600,
        'abbreviation': '-01',
        'dst_offset': 0,
      },
      'Etc/GMT+6': {
        'timezone': 'Etc/GMT+6',
        'raw_offset': -21600,
        'abbreviation': '-06',
        'dst_offset': 0,
      },
      'Etc/GMT+7': {
        'timezone': 'Etc/GMT+7',
        'raw_offset': -25200,
        'abbreviation': '-07',
        'dst_offset': 0,
      },
      'Etc/GMT+9': {
        'timezone': 'Etc/GMT+9',
        'raw_offset': -32400,
        'abbreviation': '-09',
        'dst_offset': 0,
      },
      'Etc/GMT-11': {
        'timezone': 'Etc/GMT-11',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Etc/GMT-13': {
        'timezone': 'Etc/GMT-13',
        'raw_offset': 46800,
        'abbreviation': '+13',
        'dst_offset': 0,
      },
      'Etc/GMT-5': {
        'timezone': 'Etc/GMT-5',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Etc/GMT-6': {
        'timezone': 'Etc/GMT-6',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Etc/UTC': {
        'timezone': 'Etc/UTC',
        'raw_offset': 0,
        'abbreviation': 'UTC',
        'dst_offset': 0,
      },
      'Europe/Astrakhan': {
        'timezone': 'Europe/Astrakhan',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Europe/Brussels': {
        'timezone': 'Europe/Brussels',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Chisinau': {
        'timezone': 'Europe/Chisinau',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Gibraltar': {
        'timezone': 'Europe/Gibraltar',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Paris': {
        'timezone': 'Europe/Paris',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Prague': {
        'timezone': 'Europe/Prague',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Samara': {
        'timezone': 'Europe/Samara',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Europe/Tirane': {
        'timezone': 'Europe/Tirane',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Vienna': {
        'timezone': 'Europe/Vienna',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'HST': {
        'timezone': 'HST',
        'raw_offset': -36000,
        'abbreviation': 'HST',
        'dst_offset': 0,
      },
      'MST7MDT': {
        'timezone': 'MST7MDT',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'PST8PDT': {
        'timezone': 'PST8PDT',
        'raw_offset': -28800,
        'abbreviation': 'PDT',
        'dst_offset': 3600,
      },
      'Pacific/Auckland': {
        'timezone': 'Pacific/Auckland',
        'raw_offset': 43200,
        'abbreviation': 'NZST',
        'dst_offset': 0,
      },
      'Pacific/Chatham': {
        'timezone': 'Pacific/Chatham',
        'raw_offset': 45900,
        'abbreviation': '+1245',
        'dst_offset': 0,
      },
      'Pacific/Galapagos': {
        'timezone': 'Pacific/Galapagos',
        'raw_offset': -21600,
        'abbreviation': '-06',
        'dst_offset': 0,
      },
      'Pacific/Guam': {
        'timezone': 'Pacific/Guam',
        'raw_offset': 36000,
        'abbreviation': 'ChST',
        'dst_offset': 0,
      },
      'Pacific/Honolulu': {
        'timezone': 'Pacific/Honolulu',
        'raw_offset': -36000,
        'abbreviation': 'HST',
        'dst_offset': 0,
      },
      'Pacific/Marquesas': {
        'timezone': 'Pacific/Marquesas',
        'raw_offset': -34200,
        'abbreviation': '-0930',
        'dst_offset': 0,
      },
      'Pacific/Norfolk': {
        'timezone': 'Pacific/Norfolk',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Africa/Algiers': {
        'timezone': 'Africa/Algiers',
        'raw_offset': 3600,
        'abbreviation': 'CET',
        'dst_offset': 0,
      },
      'Africa/Casablanca': {
        'timezone': 'Africa/Casablanca',
        'raw_offset': 3600,
        'abbreviation': '+01',
        'dst_offset': 0,
      },
      'Africa/El_Aaiun': {
        'timezone': 'Africa/El_Aaiun',
        'raw_offset': 3600,
        'abbreviation': '+01',
        'dst_offset': 0,
      },
      'Africa/Khartoum': {
        'timezone': 'Africa/Khartoum',
        'raw_offset': 7200,
        'abbreviation': 'CAT',
        'dst_offset': 0,
      },
      'Africa/Nairobi': {
        'timezone': 'Africa/Nairobi',
        'raw_offset': 10800,
        'abbreviation': 'EAT',
        'dst_offset': 0,
      },
      'Africa/Ndjamena': {
        'timezone': 'Africa/Ndjamena',
        'raw_offset': 3600,
        'abbreviation': 'WAT',
        'dst_offset': 0,
      },
      'Africa/Tripoli': {
        'timezone': 'Africa/Tripoli',
        'raw_offset': 7200,
        'abbreviation': 'EET',
        'dst_offset': 0,
      },
      'America/Argentina/Jujuy': {
        'timezone': 'America/Argentina/Jujuy',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Rio_Gallegos': {
        'timezone': 'America/Argentina/Rio_Gallegos',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Salta': {
        'timezone': 'America/Argentina/Salta',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/San_Juan': {
        'timezone': 'America/Argentina/San_Juan',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Belem': {
        'timezone': 'America/Belem',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Bogota': {
        'timezone': 'America/Bogota',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'America/Boise': {
        'timezone': 'America/Boise',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Cambridge_Bay': {
        'timezone': 'America/Cambridge_Bay',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Campo_Grande': {
        'timezone': 'America/Campo_Grande',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Cancun': {
        'timezone': 'America/Cancun',
        'raw_offset': -18000,
        'abbreviation': 'EST',
        'dst_offset': 0,
      },
      'America/Chicago': {
        'timezone': 'America/Chicago',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Dawson': {
        'timezone': 'America/Dawson',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Denver': {
        'timezone': 'America/Denver',
        'raw_offset': -25200,
        'abbreviation': 'MDT',
        'dst_offset': 3600,
      },
      'America/Detroit': {
        'timezone': 'America/Detroit',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/El_Salvador': {
        'timezone': 'America/El_Salvador',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Fortaleza': {
        'timezone': 'America/Fortaleza',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Goose_Bay': {
        'timezone': 'America/Goose_Bay',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'America/Grand_Turk': {
        'timezone': 'America/Grand_Turk',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Hermosillo': {
        'timezone': 'America/Hermosillo',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Indiana/Indianapolis': {
        'timezone': 'America/Indiana/Indianapolis',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Petersburg': {
        'timezone': 'America/Indiana/Petersburg',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Tell_City': {
        'timezone': 'America/Indiana/Tell_City',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Indiana/Vevay': {
        'timezone': 'America/Indiana/Vevay',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Iqaluit': {
        'timezone': 'America/Iqaluit',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Jamaica': {
        'timezone': 'America/Jamaica',
        'raw_offset': -18000,
        'abbreviation': 'EST',
        'dst_offset': 0,
      },
      'America/Kentucky/Monticello': {
        'timezone': 'America/Kentucky/Monticello',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/La_Paz': {
        'timezone': 'America/La_Paz',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Lima': {
        'timezone': 'America/Lima',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'America/Los_Angeles': {
        'timezone': 'America/Los_Angeles',
        'raw_offset': -28800,
        'abbreviation': 'PDT',
        'dst_offset': 3600,
      },
      'America/Maceio': {
        'timezone': 'America/Maceio',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Managua': {
        'timezone': 'America/Managua',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Manaus': {
        'timezone': 'America/Manaus',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Martinique': {
        'timezone': 'America/Martinique',
        'raw_offset': -14400,
        'abbreviation': 'AST',
        'dst_offset': 0,
      },
      'America/Miquelon': {
        'timezone': 'America/Miquelon',
        'raw_offset': -10800,
        'abbreviation': '-02',
        'dst_offset': 3600,
      },
      'America/Moncton': {
        'timezone': 'America/Moncton',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'America/Monterrey': {
        'timezone': 'America/Monterrey',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Montevideo': {
        'timezone': 'America/Montevideo',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Nome': {
        'timezone': 'America/Nome',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'America/Noronha': {
        'timezone': 'America/Noronha',
        'raw_offset': -7200,
        'abbreviation': '-02',
        'dst_offset': 0,
      },
      'America/North_Dakota/Beulah': {
        'timezone': 'America/North_Dakota/Beulah',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/North_Dakota/New_Salem': {
        'timezone': 'America/North_Dakota/New_Salem',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Nuuk': {
        'timezone': 'America/Nuuk',
        'raw_offset': -7200,
        'abbreviation': '-01',
        'dst_offset': 3600,
      },
      'America/Ojinaga': {
        'timezone': 'America/Ojinaga',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Panama': {
        'timezone': 'America/Panama',
        'raw_offset': -18000,
        'abbreviation': 'EST',
        'dst_offset': 0,
      },
      'America/Puerto_Rico': {
        'timezone': 'America/Puerto_Rico',
        'raw_offset': -14400,
        'abbreviation': 'AST',
        'dst_offset': 0,
      },
      'America/Punta_Arenas': {
        'timezone': 'America/Punta_Arenas',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Regina': {
        'timezone': 'America/Regina',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Resolute': {
        'timezone': 'America/Resolute',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Santo_Domingo': {
        'timezone': 'America/Santo_Domingo',
        'raw_offset': -14400,
        'abbreviation': 'AST',
        'dst_offset': 0,
      },
      'America/Scoresbysund': {
        'timezone': 'America/Scoresbysund',
        'raw_offset': -7200,
        'abbreviation': '-01',
        'dst_offset': 3600,
      },
      'America/Sitka': {
        'timezone': 'America/Sitka',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'America/Swift_Current': {
        'timezone': 'America/Swift_Current',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Tegucigalpa': {
        'timezone': 'America/Tegucigalpa',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Thule': {
        'timezone': 'America/Thule',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'America/Tijuana': {
        'timezone': 'America/Tijuana',
        'raw_offset': -28800,
        'abbreviation': 'PDT',
        'dst_offset': 3600,
      },
      'Antarctica/Troll': {
        'timezone': 'Antarctica/Troll',
        'raw_offset': 0,
        'abbreviation': '+02',
        'dst_offset': 7200,
      },
      'Asia/Aqtau': {
        'timezone': 'Asia/Aqtau',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Bangkok': {
        'timezone': 'Asia/Bangkok',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Beirut': {
        'timezone': 'Asia/Beirut',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Asia/Bishkek': {
        'timezone': 'Asia/Bishkek',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Asia/Chita': {
        'timezone': 'Asia/Chita',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Asia/Dubai': {
        'timezone': 'Asia/Dubai',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Asia/Dushanbe': {
        'timezone': 'Asia/Dushanbe',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Gaza': {
        'timezone': 'Asia/Gaza',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Asia/Ho_Chi_Minh': {
        'timezone': 'Asia/Ho_Chi_Minh',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Hovd': {
        'timezone': 'Asia/Hovd',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Kamchatka': {
        'timezone': 'Asia/Kamchatka',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Asia/Krasnoyarsk': {
        'timezone': 'Asia/Krasnoyarsk',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Kuching': {
        'timezone': 'Asia/Kuching',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Asia/Magadan': {
        'timezone': 'Asia/Magadan',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Asia/Makassar': {
        'timezone': 'Asia/Makassar',
        'raw_offset': 28800,
        'abbreviation': 'WITA',
        'dst_offset': 0,
      },
      'Asia/Oral': {
        'timezone': 'Asia/Oral',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Pyongyang': {
        'timezone': 'Asia/Pyongyang',
        'raw_offset': 32400,
        'abbreviation': 'KST',
        'dst_offset': 0,
      },
      'Asia/Sakhalin': {
        'timezone': 'Asia/Sakhalin',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Asia/Srednekolymsk': {
        'timezone': 'Asia/Srednekolymsk',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Asia/Tokyo': {
        'timezone': 'Asia/Tokyo',
        'raw_offset': 32400,
        'abbreviation': 'JST',
        'dst_offset': 0,
      },
      'Asia/Tomsk': {
        'timezone': 'Asia/Tomsk',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Ulaanbaatar': {
        'timezone': 'Asia/Ulaanbaatar',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Asia/Urumqi': {
        'timezone': 'Asia/Urumqi',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Asia/Ust-Nera': {
        'timezone': 'Asia/Ust-Nera',
        'raw_offset': 36000,
        'abbreviation': '+10',
        'dst_offset': 0,
      },
      'Asia/Yakutsk': {
        'timezone': 'Asia/Yakutsk',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Atlantic/Bermuda': {
        'timezone': 'Atlantic/Bermuda',
        'raw_offset': -14400,
        'abbreviation': 'ADT',
        'dst_offset': 3600,
      },
      'Atlantic/Canary': {
        'timezone': 'Atlantic/Canary',
        'raw_offset': 0,
        'abbreviation': 'WEST',
        'dst_offset': 3600,
      },
      'Atlantic/Madeira': {
        'timezone': 'Atlantic/Madeira',
        'raw_offset': 0,
        'abbreviation': 'WEST',
        'dst_offset': 3600,
      },
      'Australia/Adelaide': {
        'timezone': 'Australia/Adelaide',
        'raw_offset': 34200,
        'abbreviation': 'ACST',
        'dst_offset': 0,
      },
      'Australia/Broken_Hill': {
        'timezone': 'Australia/Broken_Hill',
        'raw_offset': 34200,
        'abbreviation': 'ACST',
        'dst_offset': 0,
      },
      'Australia/Hobart': {
        'timezone': 'Australia/Hobart',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'Australia/Lindeman': {
        'timezone': 'Australia/Lindeman',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'Australia/Lord_Howe': {
        'timezone': 'Australia/Lord_Howe',
        'raw_offset': 37800,
        'abbreviation': '+1030',
        'dst_offset': 0,
      },
      'CST6CDT': {
        'timezone': 'CST6CDT',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'EST': {
        'timezone': 'EST',
        'raw_offset': -18000,
        'abbreviation': 'EST',
        'dst_offset': 0,
      },
      'Etc/GMT+11': {
        'timezone': 'Etc/GMT+11',
        'raw_offset': -39600,
        'abbreviation': '-11',
        'dst_offset': 0,
      },
      'Etc/GMT+12': {
        'timezone': 'Etc/GMT+12',
        'raw_offset': -43200,
        'abbreviation': '-12',
        'dst_offset': 0,
      },
      'Etc/GMT+3': {
        'timezone': 'Etc/GMT+3',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'Etc/GMT+5': {
        'timezone': 'Etc/GMT+5',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'Etc/GMT+8': {
        'timezone': 'Etc/GMT+8',
        'raw_offset': -28800,
        'abbreviation': '-08',
        'dst_offset': 0,
      },
      'Etc/GMT-1': {
        'timezone': 'Etc/GMT-1',
        'raw_offset': 3600,
        'abbreviation': '+01',
        'dst_offset': 0,
      },
      'Etc/GMT-10': {
        'timezone': 'Etc/GMT-10',
        'raw_offset': 36000,
        'abbreviation': '+10',
        'dst_offset': 0,
      },
      'Etc/GMT-14': {
        'timezone': 'Etc/GMT-14',
        'raw_offset': 50400,
        'abbreviation': '+14',
        'dst_offset': 0,
      },
      'Etc/GMT-2': {
        'timezone': 'Etc/GMT-2',
        'raw_offset': 7200,
        'abbreviation': '+02',
        'dst_offset': 0,
      },
      'Etc/GMT-7': {
        'timezone': 'Etc/GMT-7',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Etc/GMT-8': {
        'timezone': 'Etc/GMT-8',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Europe/Belgrade': {
        'timezone': 'Europe/Belgrade',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Budapest': {
        'timezone': 'Europe/Budapest',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Dublin': {
        'timezone': 'Europe/Dublin',
        'raw_offset': 3600,
        'abbreviation': 'IST',
        'dst_offset': 0,
      },
      'Europe/Helsinki': {
        'timezone': 'Europe/Helsinki',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Kaliningrad': {
        'timezone': 'Europe/Kaliningrad',
        'raw_offset': 7200,
        'abbreviation': 'EET',
        'dst_offset': 0,
      },
      'Europe/Kyiv': {
        'timezone': 'Europe/Kyiv',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Lisbon': {
        'timezone': 'Europe/Lisbon',
        'raw_offset': 0,
        'abbreviation': 'WEST',
        'dst_offset': 3600,
      },
      'Europe/Madrid': {
        'timezone': 'Europe/Madrid',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Minsk': {
        'timezone': 'Europe/Minsk',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Europe/Riga': {
        'timezone': 'Europe/Riga',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Rome': {
        'timezone': 'Europe/Rome',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Sofia': {
        'timezone': 'Europe/Sofia',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Tallinn': {
        'timezone': 'Europe/Tallinn',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Ulyanovsk': {
        'timezone': 'Europe/Ulyanovsk',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Europe/Vilnius': {
        'timezone': 'Europe/Vilnius',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Warsaw': {
        'timezone': 'Europe/Warsaw',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Zurich': {
        'timezone': 'Europe/Zurich',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Pacific/Apia': {
        'timezone': 'Pacific/Apia',
        'raw_offset': 46800,
        'abbreviation': '+13',
        'dst_offset': 0,
      },
      'Pacific/Easter': {
        'timezone': 'Pacific/Easter',
        'raw_offset': -21600,
        'abbreviation': '-05',
        'dst_offset': 3600,
      },
      'Pacific/Efate': {
        'timezone': 'Pacific/Efate',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Pacific/Fakaofo': {
        'timezone': 'Pacific/Fakaofo',
        'raw_offset': 46800,
        'abbreviation': '+13',
        'dst_offset': 0,
      },
      'Pacific/Gambier': {
        'timezone': 'Pacific/Gambier',
        'raw_offset': -32400,
        'abbreviation': '-09',
        'dst_offset': 0,
      },
      'Pacific/Guadalcanal': {
        'timezone': 'Pacific/Guadalcanal',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Pacific/Kanton': {
        'timezone': 'Pacific/Kanton',
        'raw_offset': 46800,
        'abbreviation': '+13',
        'dst_offset': 0,
      },
      'Pacific/Kiritimati': {
        'timezone': 'Pacific/Kiritimati',
        'raw_offset': 50400,
        'abbreviation': '+14',
        'dst_offset': 0,
      },
      'Pacific/Kosrae': {
        'timezone': 'Pacific/Kosrae',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Pacific/Kwajalein': {
        'timezone': 'Pacific/Kwajalein',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Pacific/Nauru': {
        'timezone': 'Pacific/Nauru',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Pacific/Noumea': {
        'timezone': 'Pacific/Noumea',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Pacific/Palau': {
        'timezone': 'Pacific/Palau',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Pacific/Rarotonga': {
        'timezone': 'Pacific/Rarotonga',
        'raw_offset': -36000,
        'abbreviation': '-10',
        'dst_offset': 0,
      },
      'Pacific/Tarawa': {
        'timezone': 'Pacific/Tarawa',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Pacific/Tongatapu': {
        'timezone': 'Pacific/Tongatapu',
        'raw_offset': 46800,
        'abbreviation': '+13',
        'dst_offset': 0,
      },
      'WET': {
        'timezone': 'WET',
        'raw_offset': 0,
        'abbreviation': 'WEST',
        'dst_offset': 3600,
      },
      'Africa/Abidjan': {
        'timezone': 'Africa/Abidjan',
        'raw_offset': 0,
        'abbreviation': 'GMT',
        'dst_offset': 0,
      },
      'Africa/Cairo': {
        'timezone': 'Africa/Cairo',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Africa/Johannesburg': {
        'timezone': 'Africa/Johannesburg',
        'raw_offset': 7200,
        'abbreviation': 'SAST',
        'dst_offset': 0,
      },
      'Africa/Juba': {
        'timezone': 'Africa/Juba',
        'raw_offset': 7200,
        'abbreviation': 'CAT',
        'dst_offset': 0,
      },
      'Africa/Lagos': {
        'timezone': 'Africa/Lagos',
        'raw_offset': 3600,
        'abbreviation': 'WAT',
        'dst_offset': 0,
      },
      'America/Argentina/Buenos_Aires': {
        'timezone': 'America/Argentina/Buenos_Aires',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Catamarca': {
        'timezone': 'America/Argentina/Catamarca',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/Ushuaia': {
        'timezone': 'America/Argentina/Ushuaia',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Bahia_Banderas': {
        'timezone': 'America/Bahia_Banderas',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Belize': {
        'timezone': 'America/Belize',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Boa_Vista': {
        'timezone': 'America/Boa_Vista',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Cayenne': {
        'timezone': 'America/Cayenne',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Eirunepe': {
        'timezone': 'America/Eirunepe',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'America/Guatemala': {
        'timezone': 'America/Guatemala',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Indiana/Vincennes': {
        'timezone': 'America/Indiana/Vincennes',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Juneau': {
        'timezone': 'America/Juneau',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'America/Kentucky/Louisville': {
        'timezone': 'America/Kentucky/Louisville',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Mazatlan': {
        'timezone': 'America/Mazatlan',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Paramaribo': {
        'timezone': 'America/Paramaribo',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Rankin_Inlet': {
        'timezone': 'America/Rankin_Inlet',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Yakutat': {
        'timezone': 'America/Yakutat',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'Antarctica/Macquarie': {
        'timezone': 'Antarctica/Macquarie',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'Antarctica/Palmer': {
        'timezone': 'Antarctica/Palmer',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'Asia/Almaty': {
        'timezone': 'Asia/Almaty',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Irkutsk': {
        'timezone': 'Asia/Irkutsk',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Asia/Jakarta': {
        'timezone': 'Asia/Jakarta',
        'raw_offset': 25200,
        'abbreviation': 'WIB',
        'dst_offset': 0,
      },
      'Asia/Jayapura': {
        'timezone': 'Asia/Jayapura',
        'raw_offset': 32400,
        'abbreviation': 'WIT',
        'dst_offset': 0,
      },
      'Asia/Kabul': {
        'timezone': 'Asia/Kabul',
        'raw_offset': 16200,
        'abbreviation': '+0430',
        'dst_offset': 0,
      },
      'Asia/Qatar': {
        'timezone': 'Asia/Qatar',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Asia/Seoul': {
        'timezone': 'Asia/Seoul',
        'raw_offset': 32400,
        'abbreviation': 'KST',
        'dst_offset': 0,
      },
      'Asia/Singapore': {
        'timezone': 'Asia/Singapore',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Asia/Tashkent': {
        'timezone': 'Asia/Tashkent',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Yerevan': {
        'timezone': 'Asia/Yerevan',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Atlantic/Azores': {
        'timezone': 'Atlantic/Azores',
        'raw_offset': -3600,
        'abbreviation': '+00',
        'dst_offset': 3600,
      },
      'Atlantic/Cape_Verde': {
        'timezone': 'Atlantic/Cape_Verde',
        'raw_offset': -3600,
        'abbreviation': '-01',
        'dst_offset': 0,
      },
      'Atlantic/South_Georgia': {
        'timezone': 'Atlantic/South_Georgia',
        'raw_offset': -7200,
        'abbreviation': '-02',
        'dst_offset': 0,
      },
      'Atlantic/Stanley': {
        'timezone': 'Atlantic/Stanley',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'Australia/Brisbane': {
        'timezone': 'Australia/Brisbane',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'Australia/Eucla': {
        'timezone': 'Australia/Eucla',
        'raw_offset': 31500,
        'abbreviation': '+0845',
        'dst_offset': 0,
      },
      'Australia/Perth': {
        'timezone': 'Australia/Perth',
        'raw_offset': 28800,
        'abbreviation': 'AWST',
        'dst_offset': 0,
      },
      'Australia/Sydney': {
        'timezone': 'Australia/Sydney',
        'raw_offset': 36000,
        'abbreviation': 'AEST',
        'dst_offset': 0,
      },
      'CET': {
        'timezone': 'CET',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Etc/GMT+2': {
        'timezone': 'Etc/GMT+2',
        'raw_offset': -7200,
        'abbreviation': '-02',
        'dst_offset': 0,
      },
      'Etc/GMT-12': {
        'timezone': 'Etc/GMT-12',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Etc/GMT-3': {
        'timezone': 'Etc/GMT-3',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Etc/GMT-4': {
        'timezone': 'Etc/GMT-4',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Europe/Andorra': {
        'timezone': 'Europe/Andorra',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Moscow': {
        'timezone': 'Europe/Moscow',
        'raw_offset': 10800,
        'abbreviation': 'MSK',
        'dst_offset': 0,
      },
      'Europe/Simferopol': {
        'timezone': 'Europe/Simferopol',
        'raw_offset': 10800,
        'abbreviation': 'MSK',
        'dst_offset': 0,
      },
      'Indian/Chagos': {
        'timezone': 'Indian/Chagos',
        'raw_offset': 21600,
        'abbreviation': '+06',
        'dst_offset': 0,
      },
      'Indian/Mauritius': {
        'timezone': 'Indian/Mauritius',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'MST': {
        'timezone': 'MST',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'Pacific/Pago_Pago': {
        'timezone': 'Pacific/Pago_Pago',
        'raw_offset': -39600,
        'abbreviation': 'SST',
        'dst_offset': 0,
      },
      'Pacific/Pitcairn': {
        'timezone': 'Pacific/Pitcairn',
        'raw_offset': -28800,
        'abbreviation': '-08',
        'dst_offset': 0,
      },
      'Pacific/Port_Moresby': {
        'timezone': 'Pacific/Port_Moresby',
        'raw_offset': 36000,
        'abbreviation': '+10',
        'dst_offset': 0,
      },
      'Africa/Ceuta': {
        'timezone': 'Africa/Ceuta',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'America/Adak': {
        'timezone': 'America/Adak',
        'raw_offset': -36000,
        'abbreviation': 'HDT',
        'dst_offset': 3600,
      },
      'America/Argentina/La_Rioja': {
        'timezone': 'America/Argentina/La_Rioja',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Argentina/San_Luis': {
        'timezone': 'America/Argentina/San_Luis',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'America/Caracas': {
        'timezone': 'America/Caracas',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'America/Dawson_Creek': {
        'timezone': 'America/Dawson_Creek',
        'raw_offset': -25200,
        'abbreviation': 'MST',
        'dst_offset': 0,
      },
      'America/Guayaquil': {
        'timezone': 'America/Guayaquil',
        'raw_offset': -18000,
        'abbreviation': '-05',
        'dst_offset': 0,
      },
      'America/Menominee': {
        'timezone': 'America/Menominee',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'America/Merida': {
        'timezone': 'America/Merida',
        'raw_offset': -21600,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'America/Metlakatla': {
        'timezone': 'America/Metlakatla',
        'raw_offset': -32400,
        'abbreviation': 'AKDT',
        'dst_offset': 3600,
      },
      'America/Port-au-Prince': {
        'timezone': 'America/Port-au-Prince',
        'raw_offset': -18000,
        'abbreviation': 'EDT',
        'dst_offset': 3600,
      },
      'America/Vancouver': {
        'timezone': 'America/Vancouver',
        'raw_offset': -28800,
        'abbreviation': 'PDT',
        'dst_offset': 3600,
      },
      'America/Winnipeg': {
        'timezone': 'America/Winnipeg',
        'raw_offset': -21600,
        'abbreviation': 'CDT',
        'dst_offset': 3600,
      },
      'Antarctica/Casey': {
        'timezone': 'Antarctica/Casey',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Antarctica/Davis': {
        'timezone': 'Antarctica/Davis',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Antarctica/Rothera': {
        'timezone': 'Antarctica/Rothera',
        'raw_offset': -10800,
        'abbreviation': '-03',
        'dst_offset': 0,
      },
      'Asia/Anadyr': {
        'timezone': 'Asia/Anadyr',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Asia/Aqtobe': {
        'timezone': 'Asia/Aqtobe',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Baku': {
        'timezone': 'Asia/Baku',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Asia/Choibalsan': {
        'timezone': 'Asia/Choibalsan',
        'raw_offset': 28800,
        'abbreviation': '+08',
        'dst_offset': 0,
      },
      'Asia/Colombo': {
        'timezone': 'Asia/Colombo',
        'raw_offset': 19800,
        'abbreviation': '+0530',
        'dst_offset': 0,
      },
      'Asia/Damascus': {
        'timezone': 'Asia/Damascus',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Asia/Dili': {
        'timezone': 'Asia/Dili',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Asia/Famagusta': {
        'timezone': 'Asia/Famagusta',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Asia/Hebron': {
        'timezone': 'Asia/Hebron',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Asia/Khandyga': {
        'timezone': 'Asia/Khandyga',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Asia/Nicosia': {
        'timezone': 'Asia/Nicosia',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Asia/Novokuznetsk': {
        'timezone': 'Asia/Novokuznetsk',
        'raw_offset': 25200,
        'abbreviation': '+07',
        'dst_offset': 0,
      },
      'Asia/Qostanay': {
        'timezone': 'Asia/Qostanay',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'Asia/Shanghai': {
        'timezone': 'Asia/Shanghai',
        'raw_offset': 28800,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'Asia/Taipei': {
        'timezone': 'Asia/Taipei',
        'raw_offset': 28800,
        'abbreviation': 'CST',
        'dst_offset': 0,
      },
      'Asia/Tbilisi': {
        'timezone': 'Asia/Tbilisi',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Atlantic/Faroe': {
        'timezone': 'Atlantic/Faroe',
        'raw_offset': 0,
        'abbreviation': 'WEST',
        'dst_offset': 3600,
      },
      'Etc/GMT+10': {
        'timezone': 'Etc/GMT+10',
        'raw_offset': -36000,
        'abbreviation': '-10',
        'dst_offset': 0,
      },
      'Etc/GMT+4': {
        'timezone': 'Etc/GMT+4',
        'raw_offset': -14400,
        'abbreviation': '-04',
        'dst_offset': 0,
      },
      'Etc/GMT-9': {
        'timezone': 'Etc/GMT-9',
        'raw_offset': 32400,
        'abbreviation': '+09',
        'dst_offset': 0,
      },
      'Europe/Athens': {
        'timezone': 'Europe/Athens',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Berlin': {
        'timezone': 'Europe/Berlin',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Bucharest': {
        'timezone': 'Europe/Bucharest',
        'raw_offset': 7200,
        'abbreviation': 'EEST',
        'dst_offset': 3600,
      },
      'Europe/Istanbul': {
        'timezone': 'Europe/Istanbul',
        'raw_offset': 10800,
        'abbreviation': '+03',
        'dst_offset': 0,
      },
      'Europe/Kirov': {
        'timezone': 'Europe/Kirov',
        'raw_offset': 10800,
        'abbreviation': 'MSK',
        'dst_offset': 0,
      },
      'Europe/London': {
        'timezone': 'Europe/London',
        'raw_offset': 0,
        'abbreviation': 'BST',
        'dst_offset': 3600,
      },
      'Europe/Malta': {
        'timezone': 'Europe/Malta',
        'raw_offset': 3600,
        'abbreviation': 'CEST',
        'dst_offset': 3600,
      },
      'Europe/Saratov': {
        'timezone': 'Europe/Saratov',
        'raw_offset': 14400,
        'abbreviation': '+04',
        'dst_offset': 0,
      },
      'Europe/Volgograd': {
        'timezone': 'Europe/Volgograd',
        'raw_offset': 10800,
        'abbreviation': 'MSK',
        'dst_offset': 0,
      },
      'Indian/Maldives': {
        'timezone': 'Indian/Maldives',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
      'MET': {
        'timezone': 'MET',
        'raw_offset': 3600,
        'abbreviation': 'MEST',
        'dst_offset': 3600,
      },
      'Pacific/Bougainville': {
        'timezone': 'Pacific/Bougainville',
        'raw_offset': 39600,
        'abbreviation': '+11',
        'dst_offset': 0,
      },
      'Pacific/Fiji': {
        'timezone': 'Pacific/Fiji',
        'raw_offset': 43200,
        'abbreviation': '+12',
        'dst_offset': 0,
      },
      'Pacific/Niue': {
        'timezone': 'Pacific/Niue',
        'raw_offset': -39600,
        'abbreviation': '-11',
        'dst_offset': 0,
      },
      'Pacific/Tahiti': {
        'timezone': 'Pacific/Tahiti',
        'raw_offset': -36000,
        'abbreviation': '-10',
        'dst_offset': 0,
      },
      'Asia/Yekaterinburg': {
        'timezone': 'Asia/Yekaterinburg',
        'raw_offset': 18000,
        'abbreviation': '+05',
        'dst_offset': 0,
      },
    };
