package com.machiav3lli.backup.ui.compose.icons.phosphor


import androidx.compose.foundation.Image
import androidx.compose.runtime.Composable
import androidx.compose.ui.tooling.preview.Preview

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.machiav3lli.backup.ui.compose.icons.Phosphor

val Phosphor.ChatDots: ImageVector
    get() {
        if (_chat_dots != null) {
            return _chat_dots!!
        }
        _chat_dots = Builder(
            name = "Chat-dots",
            defaultWidth = 24.0.dp,
            defaultHeight = 24.0.dp,
            viewportWidth = 256.0f,
            viewportHeight = 256.0f,
        ).apply {
            path(
                fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                pathFillType = NonZero
            ) {
                moveTo(216.0f, 48.0f)
                lineTo(40.0f, 48.0f)
                arcTo(16.0f, 16.0f, 0.0f, false, false, 24.0f, 64.0f)
                lineTo(24.0f, 222.8f)
                arcToRelative(15.7f, 15.7f, 0.0f, false, false, 9.2f, 14.5f)
                arcToRelative(15.1f, 15.1f, 0.0f, false, false, 6.8f, 1.6f)
                arcToRelative(16.0f, 16.0f, 0.0f, false, false, 10.3f, -3.8f)
                lineTo(82.5f, 208.0f)
                lineTo(216.0f, 208.0f)
                arcToRelative(16.0f, 16.0f, 0.0f, false, false, 16.0f, -16.0f)
                lineTo(232.0f, 64.0f)
                arcTo(16.0f, 16.0f, 0.0f, false, false, 216.0f, 48.0f)
                close()
                moveTo(216.0f, 192.0f)
                lineTo(82.5f, 192.0f)
                arcToRelative(15.6f, 15.6f, 0.0f, false, false, -10.3f, 3.8f)
                lineTo(40.0f, 222.8f)
                lineTo(40.0f, 64.0f)
                lineTo(216.0f, 64.0f)
                close()
                moveTo(116.0f, 128.0f)
                arcToRelative(12.0f, 12.0f, 0.0f, true, true, 12.0f, 12.0f)
                arcTo(12.0f, 12.0f, 0.0f, false, true, 116.0f, 128.0f)
                close()
                moveTo(68.0f, 128.0f)
                arcToRelative(12.0f, 12.0f, 0.0f, true, true, 12.0f, 12.0f)
                arcTo(12.0f, 12.0f, 0.0f, false, true, 68.0f, 128.0f)
                close()
                moveTo(164.0f, 128.0f)
                arcToRelative(12.0f, 12.0f, 0.0f, true, true, 12.0f, 12.0f)
                arcTo(12.0f, 12.0f, 0.0f, false, true, 164.0f, 128.0f)
                close()
            }
        }
            .build()
        return _chat_dots!!
    }

private var _chat_dots: ImageVector? = null



@Preview
@Composable
fun ChatDotsPreview() {
    Image(
        Phosphor.ChatDots,
        null
    )
}
