package com.machiav3lli.backup.ui.compose.icons.phosphor


import androidx.compose.foundation.Image
import androidx.compose.runtime.Composable
import androidx.compose.ui.tooling.preview.Preview

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType.Companion.NonZero
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap.Companion.Butt
import androidx.compose.ui.graphics.StrokeJoin.Companion.Miter
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.ImageVector.Builder
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import com.machiav3lli.backup.ui.compose.icons.Phosphor

val Phosphor.FingerprintSimple: ImageVector
    get() {
        if (_fingerprint_simple != null) {
            return _fingerprint_simple!!
        }
        _fingerprint_simple = Builder(
            name = "Fingerprint-simple",
            defaultWidth = 24.0.dp,
            defaultHeight = 24.0.dp,
            viewportWidth = 256.0f,
            viewportHeight = 256.0f,
        ).apply {
            path(
                fill = SolidColor(Color(0xFF000000)), stroke = null, strokeLineWidth = 0.0f,
                strokeLineCap = Butt, strokeLineJoin = Miter, strokeLineMiter = 4.0f,
                pathFillType = NonZero
            ) {
                moveTo(184.0f, 128.0f)
                arcToRelative(246.4f, 246.4f, 0.0f, false, true, -18.5f, 94.2f)
                arcToRelative(8.1f, 8.1f, 0.0f, false, true, -7.4f, 5.0f)
                arcToRelative(8.5f, 8.5f, 0.0f, false, true, -3.1f, -0.6f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, true, -4.3f, -10.4f)
                arcTo(231.1f, 231.1f, 0.0f, false, false, 168.0f, 128.0f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, true, 16.0f, 0.0f)
                close()
                moveTo(128.0f, 88.0f)
                arcToRelative(40.2f, 40.2f, 0.0f, false, true, 29.8f, 13.3f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 11.3f, 0.7f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 0.6f, -11.3f)
                arcTo(56.0f, 56.0f, 0.0f, false, false, 72.0f, 128.0f)
                arcToRelative(136.4f, 136.4f, 0.0f, false, true, -17.0f, 65.9f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 3.2f, 10.8f)
                arcToRelative(7.5f, 7.5f, 0.0f, false, false, 3.8f, 1.0f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 7.0f, -4.1f)
                arcTo(152.2f, 152.2f, 0.0f, false, false, 88.0f, 128.0f)
                arcTo(40.1f, 40.1f, 0.0f, false, true, 128.0f, 88.0f)
                close()
                moveTo(128.0f, 24.0f)
                arcToRelative(105.0f, 105.0f, 0.0f, false, false, -34.7f, 5.9f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, -4.8f, 10.2f)
                arcTo(7.9f, 7.9f, 0.0f, false, false, 98.7f, 45.0f)
                arcTo(88.1f, 88.1f, 0.0f, false, true, 216.0f, 128.0f)
                arcToRelative(281.7f, 281.7f, 0.0f, false, true, -6.9f, 62.2f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 6.0f, 9.6f)
                lineToRelative(1.8f, 0.2f)
                arcToRelative(8.1f, 8.1f, 0.0f, false, false, 7.8f, -6.2f)
                arcTo(302.3f, 302.3f, 0.0f, false, false, 232.0f, 128.0f)
                arcTo(104.1f, 104.1f, 0.0f, false, false, 128.0f, 24.0f)
                close()
                moveTo(69.3f, 62.4f)
                arcTo(8.0f, 8.0f, 0.0f, false, false, 70.0f, 51.1f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, -11.3f, -0.6f)
                arcTo(104.0f, 104.0f, 0.0f, false, false, 24.0f, 128.0f)
                arcToRelative(87.6f, 87.6f, 0.0f, false, true, -8.0f, 36.7f)
                arcToRelative(8.1f, 8.1f, 0.0f, false, false, 4.0f, 10.6f)
                arcToRelative(7.8f, 7.8f, 0.0f, false, false, 3.3f, 0.7f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 7.3f, -4.7f)
                arcTo(103.8f, 103.8f, 0.0f, false, false, 40.0f, 128.0f)
                arcTo(88.3f, 88.3f, 0.0f, false, true, 69.3f, 62.4f)
                close()
                moveTo(113.9f, 200.7f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, -10.6f, 4.0f)
                curveToRelative(-1.9f, 4.2f, -4.0f, 8.3f, -6.3f, 12.4f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 7.0f, 11.9f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 7.0f, -4.1f)
                curveToRelative(2.5f, -4.4f, 4.8f, -9.0f, 6.9f, -13.6f)
                arcTo(8.1f, 8.1f, 0.0f, false, false, 113.9f, 200.7f)
                close()
                moveTo(128.0f, 120.0f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, -8.0f, 8.0f)
                arcToRelative(186.5f, 186.5f, 0.0f, false, true, -5.8f, 46.0f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 5.8f, 9.7f)
                arcToRelative(6.4f, 6.4f, 0.0f, false, false, 2.0f, 0.3f)
                arcToRelative(8.0f, 8.0f, 0.0f, false, false, 7.7f, -6.0f)
                arcToRelative(200.4f, 200.4f, 0.0f, false, false, 6.3f, -50.0f)
                arcTo(8.0f, 8.0f, 0.0f, false, false, 128.0f, 120.0f)
                close()
            }
        }
            .build()
        return _fingerprint_simple!!
    }

private var _fingerprint_simple: ImageVector? = null



@Preview
@Composable
fun FingerprintSimplePreview() {
    Image(
        Phosphor.FingerprintSimple,
        null
    )
}
