"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = nodesIteration;

var _assert = _interopRequireDefault(require("assert"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Graphology Nodes Iteration Specs
 * =================================
 *
 * Testing the nodes iteration-related methods of the graph.
 */
function nodesIteration(Graph, checkers) {
  var invalid = checkers.invalid;
  return {
    '#.nodes': {
      'it should return the list of nodes of the graph.': function itShouldReturnTheListOfNodesOfTheGraph() {
        var graph = new Graph();
        (0, _helpers.addNodesFrom)(graph, ['one', 'two', 'three']);

        _assert["default"].deepStrictEqual(graph.nodes(), ['one', 'two', 'three']);
      }
    },
    '#.forEachNode': {
      'it should throw if given callback is not a function.': function itShouldThrowIfGivenCallbackIsNotAFunction() {
        var graph = new Graph();

        _assert["default"]["throws"](function () {
          graph.forEachNode(null);
        }, invalid());
      },
      'it should be possible to iterate over nodes and their attributes.': function itShouldBePossibleToIterateOverNodesAndTheirAttributes() {
        var graph = new Graph();
        graph.addNode('John', {
          age: 34
        });
        graph.addNode('Martha', {
          age: 33
        });
        var count = 0;
        graph.forEachNode(function (key, attributes) {
          _assert["default"].strictEqual(key, count ? 'Martha' : 'John');

          _assert["default"].deepStrictEqual(attributes, count ? {
            age: 33
          } : {
            age: 34
          });

          count++;
        });

        _assert["default"].strictEqual(count, 2);
      }
    },
    '#.forEachNodeUntil': {
      'it should throw if given callback is not a function.': function itShouldThrowIfGivenCallbackIsNotAFunction() {
        var graph = new Graph();

        _assert["default"]["throws"](function () {
          graph.forEachNodeUntil(null);
        }, invalid());
      },
      'it should be possible to iterate over nodes and their attributes until the callback returns true.': function itShouldBePossibleToIterateOverNodesAndTheirAttributesUntilTheCallbackReturnsTrue() {
        var graph = new Graph();
        graph.addNode('John', {
          age: 34
        });
        graph.addNode('Martha', {
          age: 33
        });
        var count = 0;
        graph.forEachNodeUntil(function (key, attributes) {
          _assert["default"].strictEqual(key, 'John');

          _assert["default"].deepStrictEqual(attributes, {
            age: 34
          });

          count++;
          if (key === 'John') return true;
        });

        _assert["default"].strictEqual(count, 1);
      }
    },
    '#.nodeEntries': {
      'it should be possible to create a nodes iterator.': function itShouldBePossibleToCreateANodesIterator() {
        var graph = new Graph();
        (0, _helpers.addNodesFrom)(graph, ['one', 'two', 'three']);
        graph.replaceNodeAttributes('two', {
          hello: 'world'
        });
        var iterator = graph.nodeEntries();

        _assert["default"].deepStrictEqual(iterator.next().value, ['one', {}]);

        _assert["default"].deepStrictEqual(iterator.next().value, ['two', {
          hello: 'world'
        }]);

        _assert["default"].deepStrictEqual(iterator.next().value, ['three', {}]);

        _assert["default"].strictEqual(iterator.next().done, true);
      }
    }
  };
}