# Installation
> `npm install --save @types/undertaker-registry`

# Summary
This package contains type definitions for undertaker-registry (https://github.com/gulpjs/undertaker-registry).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/undertaker-registry.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/undertaker-registry/index.d.ts)
````ts
declare class UndertakerRegistry {
    /**
     * Returns the task with that name or undefined if no task is registered with that name.
     * Useful for custom task storage.
     * Custom registries can override this method when inheriting from this default registry.
     * @param taskName - Name of task.
     */
    get<TTaskFunction>(taskName: string): TTaskFunction;

    /**
     * No-op method that receives the undertaker instance.
     * Useful to set pre-defined tasks using the undertaker.task(taskName, fn) method.
     * Custom registries can override this method when inheriting from this default registry.
     * @param taker - Instance of undertaker.
     */
    init(taker: any): void;

    /**
     * Adds a task to the registry.
     * If set modifies a task, it should return the new task so Undertaker can properly maintain metadata for the task.
     * Useful for adding custom behavior to every task as it is registered in the system.
     * Custom registries can override this method when inheriting from this default registry.
     * @param taskName - Name of task.
     * @param fn - Task function.
     */
    set<TTaskFunction>(taskName: string, fn: TTaskFunction): TTaskFunction;

    /**
     * Returns an object listing all tasks in the registry.
     * Necessary to override if the get method is overridden for custom task storage.
     * Custom registries can override this when when inheriting from this default registry.
     */
    tasks(): { [taskName: string]: (...args: any[]) => any };
}

declare namespace UndertakerRegistry {}

export = UndertakerRegistry;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 15:11:36 GMT
 * Dependencies: none

# Credits
These definitions were written by [Giedrius Grabauskas](https://github.com/GiedriusGrabauskas).
