/*!
 * @pixi/text - v6.2.0
 * Compiled Mon, 01 Nov 2021 16:52:10 UTC
 *
 * @pixi/text is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var sprite=require("@pixi/sprite"),core=require("@pixi/core"),settings=require("@pixi/settings"),math=require("@pixi/math"),utils=require("@pixi/utils"),extendStatics=function(t,e){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)};function __extends(t,e){function i(){this.constructor=t}extendStatics(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}!function(t){t[t.LINEAR_VERTICAL=0]="LINEAR_VERTICAL",t[t.LINEAR_HORIZONTAL=1]="LINEAR_HORIZONTAL"}(exports.TEXT_GRADIENT||(exports.TEXT_GRADIENT={}));var defaultStyle={align:"left",breakWords:!1,dropShadow:!1,dropShadowAlpha:1,dropShadowAngle:Math.PI/6,dropShadowBlur:0,dropShadowColor:"black",dropShadowDistance:5,fill:"black",fillGradientType:exports.TEXT_GRADIENT.LINEAR_VERTICAL,fillGradientStops:[],fontFamily:"Arial",fontSize:26,fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",letterSpacing:0,lineHeight:0,lineJoin:"miter",miterLimit:10,padding:0,stroke:"black",strokeThickness:0,textBaseline:"alphabetic",trim:!1,whiteSpace:"pre",wordWrap:!1,wordWrapWidth:100,leading:0},genericFontFamilies=["serif","sans-serif","monospace","cursive","fantasy","system-ui"],TextStyle=function(){function t(t){this.styleID=0,this.reset(),deepCopyProperties(this,t,t)}return t.prototype.clone=function(){var e={};return deepCopyProperties(e,this,defaultStyle),new t(e)},t.prototype.reset=function(){deepCopyProperties(this,defaultStyle,defaultStyle)},Object.defineProperty(t.prototype,"align",{get:function(){return this._align},set:function(t){this._align!==t&&(this._align=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"breakWords",{get:function(){return this._breakWords},set:function(t){this._breakWords!==t&&(this._breakWords=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadow",{get:function(){return this._dropShadow},set:function(t){this._dropShadow!==t&&(this._dropShadow=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadowAlpha",{get:function(){return this._dropShadowAlpha},set:function(t){this._dropShadowAlpha!==t&&(this._dropShadowAlpha=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadowAngle",{get:function(){return this._dropShadowAngle},set:function(t){this._dropShadowAngle!==t&&(this._dropShadowAngle=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadowBlur",{get:function(){return this._dropShadowBlur},set:function(t){this._dropShadowBlur!==t&&(this._dropShadowBlur=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadowColor",{get:function(){return this._dropShadowColor},set:function(t){var e=getColor(t);this._dropShadowColor!==e&&(this._dropShadowColor=e,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dropShadowDistance",{get:function(){return this._dropShadowDistance},set:function(t){this._dropShadowDistance!==t&&(this._dropShadowDistance=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fill",{get:function(){return this._fill},set:function(t){var e=getColor(t);this._fill!==e&&(this._fill=e,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fillGradientType",{get:function(){return this._fillGradientType},set:function(t){this._fillGradientType!==t&&(this._fillGradientType=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fillGradientStops",{get:function(){return this._fillGradientStops},set:function(t){areArraysEqual(this._fillGradientStops,t)||(this._fillGradientStops=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontFamily",{get:function(){return this._fontFamily},set:function(t){this.fontFamily!==t&&(this._fontFamily=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontSize",{get:function(){return this._fontSize},set:function(t){this._fontSize!==t&&(this._fontSize=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontStyle",{get:function(){return this._fontStyle},set:function(t){this._fontStyle!==t&&(this._fontStyle=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontVariant",{get:function(){return this._fontVariant},set:function(t){this._fontVariant!==t&&(this._fontVariant=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"fontWeight",{get:function(){return this._fontWeight},set:function(t){this._fontWeight!==t&&(this._fontWeight=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"letterSpacing",{get:function(){return this._letterSpacing},set:function(t){this._letterSpacing!==t&&(this._letterSpacing=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"lineHeight",{get:function(){return this._lineHeight},set:function(t){this._lineHeight!==t&&(this._lineHeight=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"leading",{get:function(){return this._leading},set:function(t){this._leading!==t&&(this._leading=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"lineJoin",{get:function(){return this._lineJoin},set:function(t){this._lineJoin!==t&&(this._lineJoin=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"miterLimit",{get:function(){return this._miterLimit},set:function(t){this._miterLimit!==t&&(this._miterLimit=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"padding",{get:function(){return this._padding},set:function(t){this._padding!==t&&(this._padding=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"stroke",{get:function(){return this._stroke},set:function(t){var e=getColor(t);this._stroke!==e&&(this._stroke=e,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"strokeThickness",{get:function(){return this._strokeThickness},set:function(t){this._strokeThickness!==t&&(this._strokeThickness=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"textBaseline",{get:function(){return this._textBaseline},set:function(t){this._textBaseline!==t&&(this._textBaseline=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"trim",{get:function(){return this._trim},set:function(t){this._trim!==t&&(this._trim=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"whiteSpace",{get:function(){return this._whiteSpace},set:function(t){this._whiteSpace!==t&&(this._whiteSpace=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"wordWrap",{get:function(){return this._wordWrap},set:function(t){this._wordWrap!==t&&(this._wordWrap=t,this.styleID++)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"wordWrapWidth",{get:function(){return this._wordWrapWidth},set:function(t){this._wordWrapWidth!==t&&(this._wordWrapWidth=t,this.styleID++)},enumerable:!1,configurable:!0}),t.prototype.toFontString=function(){var t="number"==typeof this.fontSize?this.fontSize+"px":this.fontSize,e=this.fontFamily;Array.isArray(this.fontFamily)||(e=this.fontFamily.split(","));for(var i=e.length-1;i>=0;i--){var r=e[i].trim();!/([\"\'])[^\'\"]+\1/.test(r)&&genericFontFamilies.indexOf(r)<0&&(r='"'+r+'"'),e[i]=r}return this.fontStyle+" "+this.fontVariant+" "+this.fontWeight+" "+t+" "+e.join(",")},t}();function getSingleColor(t){return"number"==typeof t?utils.hex2string(t):("string"==typeof t&&0===t.indexOf("0x")&&(t=t.replace("0x","#")),t)}function getColor(t){if(Array.isArray(t)){for(var e=0;e<t.length;++e)t[e]=getSingleColor(t[e]);return t}return getSingleColor(t)}function areArraysEqual(t,e){if(!Array.isArray(t)||!Array.isArray(e))return!1;if(t.length!==e.length)return!1;for(var i=0;i<t.length;++i)if(t[i]!==e[i])return!1;return!0}function deepCopyProperties(t,e,i){for(var r in i)Array.isArray(e[r])?t[r]=e[r].slice():t[r]=e[r]}var TextMetrics=function(){function t(t,e,i,r,n,o,s,a,h){this.text=t,this.style=e,this.width=i,this.height=r,this.lines=n,this.lineWidths=o,this.lineHeight=s,this.maxLineWidth=a,this.fontProperties=h}return t.measureText=function(e,i,r,n){void 0===n&&(n=t._canvas),r=null==r?i.wordWrap:r;var o=i.toFontString(),s=t.measureFont(o);0===s.fontSize&&(s.fontSize=i.fontSize,s.ascent=i.fontSize);var a=n.getContext("2d");a.font=o;for(var h=(r?t.wordWrap(e,i,n):e).split(/(?:\r\n|\r|\n)/),l=new Array(h.length),c=0,u=0;u<h.length;u++){var f=a.measureText(h[u]).width+(h[u].length-1)*i.letterSpacing;l[u]=f,c=Math.max(c,f)}var p=c+i.strokeThickness;i.dropShadow&&(p+=i.dropShadowDistance);var d=i.lineHeight||s.fontSize+i.strokeThickness,g=Math.max(d,s.fontSize+i.strokeThickness)+(h.length-1)*(d+i.leading);return i.dropShadow&&(g+=i.dropShadowDistance),new t(e,i,p,g,h,l,d+i.leading,c,s)},t.wordWrap=function(e,i,r){void 0===r&&(r=t._canvas);for(var n=r.getContext("2d"),o=0,s="",a="",h=Object.create(null),l=i.letterSpacing,c=i.whiteSpace,u=t.collapseSpaces(c),f=t.collapseNewlines(c),p=!u,d=i.wordWrapWidth+l,g=t.tokenize(e),y=0;y<g.length;y++){var _=g[y];if(t.isNewline(_)){if(!f){a+=t.addLine(s),p=!u,s="",o=0;continue}_=" "}if(u){var S=t.isBreakingSpace(_),b=t.isBreakingSpace(s[s.length-1]);if(S&&b)continue}var x=t.getFromCache(_,l,h,n);if(x>d)if(""!==s&&(a+=t.addLine(s),s="",o=0),t.canBreakWords(_,i.breakWords))for(var m=t.wordWrapSplit(_),w=0;w<m.length;w++){for(var v=m[w],T=1;m[w+T];){var I=m[w+T],k=v[v.length-1];if(t.canBreakChars(k,I,_,w,i.breakWords))break;v+=I,T++}w+=v.length-1;var L=t.getFromCache(v,l,h,n);L+o>d&&(a+=t.addLine(s),p=!1,s="",o=0),s+=v,o+=L}else{s.length>0&&(a+=t.addLine(s),s="",o=0);var O=y===g.length-1;a+=t.addLine(_,!O),p=!1,s="",o=0}else x+o>d&&(p=!1,a+=t.addLine(s),s="",o=0),(s.length>0||!t.isBreakingSpace(_)||p)&&(s+=_,o+=x)}return a+=t.addLine(s,!1)},t.addLine=function(e,i){return void 0===i&&(i=!0),e=t.trimRight(e),e=i?e+"\n":e},t.getFromCache=function(t,e,i,r){var n=i[t];if("number"!=typeof n){var o=t.length*e;n=r.measureText(t).width+o,i[t]=n}return n},t.collapseSpaces=function(t){return"normal"===t||"pre-line"===t},t.collapseNewlines=function(t){return"normal"===t},t.trimRight=function(e){if("string"!=typeof e)return"";for(var i=e.length-1;i>=0;i--){var r=e[i];if(!t.isBreakingSpace(r))break;e=e.slice(0,-1)}return e},t.isNewline=function(e){return"string"==typeof e&&t._newlines.indexOf(e.charCodeAt(0))>=0},t.isBreakingSpace=function(e,i){return"string"==typeof e&&t._breakingSpaces.indexOf(e.charCodeAt(0))>=0},t.tokenize=function(e){var i=[],r="";if("string"!=typeof e)return i;for(var n=0;n<e.length;n++){var o=e[n],s=e[n+1];t.isBreakingSpace(o,s)||t.isNewline(o)?(""!==r&&(i.push(r),r=""),i.push(o)):r+=o}return""!==r&&i.push(r),i},t.canBreakWords=function(t,e){return e},t.canBreakChars=function(t,e,i,r,n){return!0},t.wordWrapSplit=function(t){return t.split("")},t.measureFont=function(e){if(t._fonts[e])return t._fonts[e];var i={ascent:0,descent:0,fontSize:0},r=t._canvas,n=t._context;n.font=e;var o=t.METRICS_STRING+t.BASELINE_SYMBOL,s=Math.ceil(n.measureText(o).width),a=Math.ceil(n.measureText(t.BASELINE_SYMBOL).width),h=Math.ceil(t.HEIGHT_MULTIPLIER*a);a=a*t.BASELINE_MULTIPLIER|0,r.width=s,r.height=h,n.fillStyle="#f00",n.fillRect(0,0,s,h),n.font=e,n.textBaseline="alphabetic",n.fillStyle="#000",n.fillText(o,0,a);var l=n.getImageData(0,0,s,h).data,c=l.length,u=4*s,f=0,p=0,d=!1;for(f=0;f<a;++f){for(var g=0;g<u;g+=4)if(255!==l[p+g]){d=!0;break}if(d)break;p+=u}for(i.ascent=a-f,p=c-u,d=!1,f=h;f>a;--f){for(g=0;g<u;g+=4)if(255!==l[p+g]){d=!0;break}if(d)break;p-=u}return i.descent=f-a,i.fontSize=i.ascent+i.descent,t._fonts[e]=i,i},t.clearMetrics=function(e){void 0===e&&(e=""),e?delete t._fonts[e]:t._fonts={}},t}(),canvas=function(){try{var t=new OffscreenCanvas(0,0),e=t.getContext("2d");return e&&e.measureText?t:document.createElement("canvas")}catch(t){return document.createElement("canvas")}}();canvas.width=canvas.height=10,TextMetrics._canvas=canvas,TextMetrics._context=canvas.getContext("2d"),TextMetrics._fonts={},TextMetrics.METRICS_STRING="|ÉqÅ",TextMetrics.BASELINE_SYMBOL="M",TextMetrics.BASELINE_MULTIPLIER=1.4,TextMetrics.HEIGHT_MULTIPLIER=2,TextMetrics._newlines=[10,13],TextMetrics._breakingSpaces=[9,32,8192,8193,8194,8195,8196,8197,8198,8200,8201,8202,8287,12288];var defaultDestroyOptions={texture:!0,children:!1,baseTexture:!0},supportLetterSpacing="letterSpacing"in CanvasRenderingContext2D.prototype||"textLetterSpacing"in CanvasRenderingContext2D.prototype,Text=function(t){function e(e,i,r){var n=this,o=!1;r||(r=document.createElement("canvas"),o=!0),r.width=3,r.height=3;var s=core.Texture.from(r);return s.orig=new math.Rectangle,s.trim=new math.Rectangle,(n=t.call(this,s)||this)._ownCanvas=o,n.canvas=r,n.context=n.canvas.getContext("2d"),n._resolution=settings.settings.RESOLUTION,n._autoResolution=!0,n._text=null,n._style=null,n._styleListener=null,n._font="",n.text=e,n.style=i,n.localStyleID=-1,n}return __extends(e,t),e.prototype.updateText=function(t){var i=this._style;if(this.localStyleID!==i.styleID&&(this.dirty=!0,this.localStyleID=i.styleID),this.dirty||!t){this._font=this._style.toFontString();var r,n,o=this.context,s=TextMetrics.measureText(this._text||" ",this._style,this._style.wordWrap,this.canvas),a=s.width,h=s.height,l=s.lines,c=s.lineHeight,u=s.lineWidths,f=s.maxLineWidth,p=s.fontProperties;this.canvas.width=Math.ceil(Math.ceil(Math.max(1,a)+2*i.padding)*this._resolution),this.canvas.height=Math.ceil(Math.ceil(Math.max(1,h)+2*i.padding)*this._resolution),o.scale(this._resolution,this._resolution),o.clearRect(0,0,this.canvas.width,this.canvas.height),o.font=this._font,o.lineWidth=i.strokeThickness,o.textBaseline=i.textBaseline,o.lineJoin=i.lineJoin,o.miterLimit=i.miterLimit;for(var d=i.dropShadow?2:1,g=0;g<d;++g){var y=i.dropShadow&&0===g,_=y?Math.ceil(Math.max(1,h)+2*i.padding):0,S=_*this._resolution;if(y){o.fillStyle="black",o.strokeStyle="black";var b=i.dropShadowColor,x=utils.hex2rgb("number"==typeof b?b:utils.string2hex(b));o.shadowColor="rgba("+255*x[0]+","+255*x[1]+","+255*x[2]+","+i.dropShadowAlpha+")",o.shadowBlur=i.dropShadowBlur,o.shadowOffsetX=Math.cos(i.dropShadowAngle)*i.dropShadowDistance,o.shadowOffsetY=Math.sin(i.dropShadowAngle)*i.dropShadowDistance+S}else o.fillStyle=this._generateFillStyle(i,l,s),o.strokeStyle=i.stroke,o.shadowColor="black",o.shadowBlur=0,o.shadowOffsetX=0,o.shadowOffsetY=0;var m=(c-p.fontSize)/2;(!e.nextLineHeightBehavior||c-p.fontSize<0)&&(m=0);for(var w=0;w<l.length;w++)r=i.strokeThickness/2,n=i.strokeThickness/2+w*c+p.ascent+m,"right"===i.align?r+=f-u[w]:"center"===i.align&&(r+=(f-u[w])/2),i.stroke&&i.strokeThickness&&this.drawLetterSpacing(l[w],r+i.padding,n+i.padding-_,!0),i.fill&&this.drawLetterSpacing(l[w],r+i.padding,n+i.padding-_)}this.updateTexture()}},e.prototype.drawLetterSpacing=function(t,e,i,r){void 0===r&&(r=!1);var n=this._style.letterSpacing;if(0===n||supportLetterSpacing)return supportLetterSpacing&&(this.context.letterSpacing=n,this.context.textLetterSpacing=n),void(r?this.context.strokeText(t,e,i):this.context.fillText(t,e,i));for(var o=e,s=Array.from?Array.from(t):t.split(""),a=this.context.measureText(t).width,h=0,l=0;l<s.length;++l){var c=s[l];r?this.context.strokeText(c,o,i):this.context.fillText(c,o,i),o+=a-(h=this.context.measureText(t.substring(l+1)).width)+n,a=h}},e.prototype.updateTexture=function(){var t=this.canvas;if(this._style.trim){var e=utils.trimCanvas(t);e.data&&(t.width=e.width,t.height=e.height,this.context.putImageData(e.data,0,0))}var i=this._texture,r=this._style,n=r.trim?0:r.padding,o=i.baseTexture;i.trim.width=i._frame.width=t.width/this._resolution,i.trim.height=i._frame.height=t.height/this._resolution,i.trim.x=-n,i.trim.y=-n,i.orig.width=i._frame.width-2*n,i.orig.height=i._frame.height-2*n,this._onTextureUpdate(),o.setRealSize(t.width,t.height,this._resolution),i.updateUvs(),this._recursivePostUpdateTransform(),this.dirty=!1},e.prototype._render=function(e){this._autoResolution&&this._resolution!==e.resolution&&(this._resolution=e.resolution,this.dirty=!0),this.updateText(!0),t.prototype._render.call(this,e)},e.prototype.getLocalBounds=function(e){return this.updateText(!0),t.prototype.getLocalBounds.call(this,e)},e.prototype._calculateBounds=function(){this.updateText(!0),this.calculateVertices(),this._bounds.addQuad(this.vertexData)},e.prototype._generateFillStyle=function(t,e,i){var r,n=t.fill;if(!Array.isArray(n))return n;if(1===n.length)return n[0];var o=t.dropShadow?t.dropShadowDistance:0,s=t.padding||0,a=this.canvas.width/this._resolution-o-2*s,h=this.canvas.height/this._resolution-o-2*s,l=n.slice(),c=t.fillGradientStops.slice();if(!c.length)for(var u=l.length+1,f=1;f<u;++f)c.push(f/u);if(l.unshift(n[0]),c.unshift(0),l.push(n[n.length-1]),c.push(1),t.fillGradientType===exports.TEXT_GRADIENT.LINEAR_VERTICAL){r=this.context.createLinearGradient(a/2,s,a/2,h+s);var p=i.fontProperties.fontSize+t.strokeThickness;for(f=0;f<e.length;f++){var d=i.lineHeight*(f-1)+p,g=i.lineHeight*f,y=g;f>0&&d>g&&(y=(g+d)/2);var _=g+p,S=i.lineHeight*(f+1),b=_;f+1<e.length&&S<_&&(b=(_+S)/2);for(var x=(b-y)/h,m=0;m<l.length;m++){var w=0;w="number"==typeof c[m]?c[m]:m/l.length;var v=Math.min(1,Math.max(0,y/h+w*x));v=Number(v.toFixed(5)),r.addColorStop(v,l[m])}}}else{r=this.context.createLinearGradient(s,h/2,a+s,h/2);var T=l.length+1,I=1;for(f=0;f<l.length;f++){var k=void 0;k="number"==typeof c[f]?c[f]:I/T,r.addColorStop(k,l[f]),I++}}return r},e.prototype.destroy=function(e){"boolean"==typeof e&&(e={children:e}),e=Object.assign({},defaultDestroyOptions,e),t.prototype.destroy.call(this,e),this._ownCanvas&&(this.canvas.height=this.canvas.width=0),this.context=null,this.canvas=null,this._style=null},Object.defineProperty(e.prototype,"width",{get:function(){return this.updateText(!0),Math.abs(this.scale.x)*this._texture.orig.width},set:function(t){this.updateText(!0);var e=utils.sign(this.scale.x)||1;this.scale.x=e*t/this._texture.orig.width,this._width=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"height",{get:function(){return this.updateText(!0),Math.abs(this.scale.y)*this._texture.orig.height},set:function(t){this.updateText(!0);var e=utils.sign(this.scale.y)||1;this.scale.y=e*t/this._texture.orig.height,this._height=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"style",{get:function(){return this._style},set:function(t){t=t||{},this._style=t instanceof TextStyle?t:new TextStyle(t),this.localStyleID=-1,this.dirty=!0},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"text",{get:function(){return this._text},set:function(t){t=String(null==t?"":t),this._text!==t&&(this._text=t,this.dirty=!0)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"resolution",{get:function(){return this._resolution},set:function(t){this._autoResolution=!1,this._resolution!==t&&(this._resolution=t,this.dirty=!0)},enumerable:!1,configurable:!0}),e.nextLineHeightBehavior=!1,e}(sprite.Sprite);exports.Text=Text,exports.TextMetrics=TextMetrics,exports.TextStyle=TextStyle;
//# sourceMappingURL=text.min.js.map
