/*!
 * @pixi/sprite-tiling - v6.2.0
 * Compiled Mon, 01 Nov 2021 16:52:10 UTC
 *
 * @pixi/sprite-tiling is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var core=require("@pixi/core"),math=require("@pixi/math"),sprite=require("@pixi/sprite"),constants=require("@pixi/constants"),utils=require("@pixi/utils"),extendStatics=function(e,t){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)};function __extends(e,t){function r(){this.constructor=e}extendStatics(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}var tempPoint=new math.Point,TilingSprite=function(e){function t(t,r,n){void 0===r&&(r=100),void 0===n&&(n=100);var o=e.call(this,t)||this;return o.tileTransform=new math.Transform,o._width=r,o._height=n,o.uvMatrix=o.texture.uvMatrix||new core.TextureMatrix(t),o.pluginName="tilingSprite",o.uvRespectAnchor=!1,o}return __extends(t,e),Object.defineProperty(t.prototype,"clampMargin",{get:function(){return this.uvMatrix.clampMargin},set:function(e){this.uvMatrix.clampMargin=e,this.uvMatrix.update(!0)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"tileScale",{get:function(){return this.tileTransform.scale},set:function(e){this.tileTransform.scale.copyFrom(e)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"tilePosition",{get:function(){return this.tileTransform.position},set:function(e){this.tileTransform.position.copyFrom(e)},enumerable:!1,configurable:!0}),t.prototype._onTextureUpdate=function(){this.uvMatrix&&(this.uvMatrix.texture=this._texture),this._cachedTint=16777215},t.prototype._render=function(e){var t=this._texture;t&&t.valid&&(this.tileTransform.updateLocalTransform(),this.uvMatrix.update(),e.batch.setObjectRenderer(e.plugins[this.pluginName]),e.plugins[this.pluginName].render(this))},t.prototype._calculateBounds=function(){var e=this._width*-this._anchor._x,t=this._height*-this._anchor._y,r=this._width*(1-this._anchor._x),n=this._height*(1-this._anchor._y);this._bounds.addFrame(this.transform,e,t,r,n)},t.prototype.getLocalBounds=function(t){return 0===this.children.length?(this._bounds.minX=this._width*-this._anchor._x,this._bounds.minY=this._height*-this._anchor._y,this._bounds.maxX=this._width*(1-this._anchor._x),this._bounds.maxY=this._height*(1-this._anchor._y),t||(this._localBoundsRect||(this._localBoundsRect=new math.Rectangle),t=this._localBoundsRect),this._bounds.getRectangle(t)):e.prototype.getLocalBounds.call(this,t)},t.prototype.containsPoint=function(e){this.worldTransform.applyInverse(e,tempPoint);var t=this._width,r=this._height,n=-t*this.anchor._x;if(tempPoint.x>=n&&tempPoint.x<n+t){var o=-r*this.anchor._y;if(tempPoint.y>=o&&tempPoint.y<o+r)return!0}return!1},t.prototype.destroy=function(t){e.prototype.destroy.call(this,t),this.tileTransform=null,this.uvMatrix=null},t.from=function(e,r){return new t(e instanceof core.Texture?e:core.Texture.from(e,r),r.width,r.height)},Object.defineProperty(t.prototype,"width",{get:function(){return this._width},set:function(e){this._width=e},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._height},set:function(e){this._height=e},enumerable:!1,configurable:!0}),t}(sprite.Sprite),fragmentSimpleSrc="#version 100\n#define SHADER_NAME Tiling-Sprite-Simple-100\n\nprecision lowp float;\n\nvarying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\n\nvoid main(void)\n{\n    vec4 texSample = texture2D(uSampler, vTextureCoord);\n    gl_FragColor = texSample * uColor;\n}\n",gl1VertexSrc="#version 100\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nattribute vec2 aVertexPosition;\nattribute vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform mat3 uTransform;\n\nvarying vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = (uTransform * vec3(aTextureCoord, 1.0)).xy;\n}\n",gl1FragmentSrc="#version 100\n#ifdef GL_EXT_shader_texture_lod\n    #extension GL_EXT_shader_texture_lod : enable\n#endif\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nvarying vec2 vTextureCoord;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\nuniform mat3 uMapCoord;\nuniform vec4 uClampFrame;\nuniform vec2 uClampOffset;\n\nvoid main(void)\n{\n    vec2 coord = vTextureCoord + ceil(uClampOffset - vTextureCoord);\n    coord = (uMapCoord * vec3(coord, 1.0)).xy;\n    vec2 unclamped = coord;\n    coord = clamp(coord, uClampFrame.xy, uClampFrame.zw);\n\n    #ifdef GL_EXT_shader_texture_lod\n        vec4 texSample = unclamped == coord\n            ? texture2D(uSampler, coord) \n            : texture2DLodEXT(uSampler, coord, 0);\n    #else\n        vec4 texSample = texture2D(uSampler, coord);\n    #endif\n\n    gl_FragColor = texSample * uColor;\n}\n",gl2VertexSrc="#version 300 es\n#define SHADER_NAME Tiling-Sprite-300\n\nprecision lowp float;\n\nin vec2 aVertexPosition;\nin vec2 aTextureCoord;\n\nuniform mat3 projectionMatrix;\nuniform mat3 translationMatrix;\nuniform mat3 uTransform;\n\nout vec2 vTextureCoord;\n\nvoid main(void)\n{\n    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);\n\n    vTextureCoord = (uTransform * vec3(aTextureCoord, 1.0)).xy;\n}\n",gl2FragmentSrc="#version 300 es\n#define SHADER_NAME Tiling-Sprite-100\n\nprecision lowp float;\n\nin vec2 vTextureCoord;\n\nout vec4 fragmentColor;\n\nuniform sampler2D uSampler;\nuniform vec4 uColor;\nuniform mat3 uMapCoord;\nuniform vec4 uClampFrame;\nuniform vec2 uClampOffset;\n\nvoid main(void)\n{\n    vec2 coord = vTextureCoord + ceil(uClampOffset - vTextureCoord);\n    coord = (uMapCoord * vec3(coord, 1.0)).xy;\n    vec2 unclamped = coord;\n    coord = clamp(coord, uClampFrame.xy, uClampFrame.zw);\n\n    vec4 texSample = texture(uSampler, coord, unclamped == coord ? 0.0f : -32.0f);// lod-bias very negative to force lod 0\n\n    fragmentColor = texSample * uColor;\n}\n",tempMat=new math.Matrix,TilingSpriteRenderer=function(e){function t(t){var r=e.call(this,t)||this;return t.runners.contextChange.add(r),r.quad=new core.QuadUv,r.state=core.State.for2d(),r}return __extends(t,e),t.prototype.contextChange=function(){var e=this.renderer,t={globals:e.globalUniforms};this.simpleShader=core.Shader.from(gl1VertexSrc,fragmentSimpleSrc,t),this.shader=e.context.webGLVersion>1?core.Shader.from(gl2VertexSrc,gl2FragmentSrc,t):core.Shader.from(gl1VertexSrc,gl1FragmentSrc,t)},t.prototype.render=function(e){var t=this.renderer,r=this.quad,n=r.vertices;n[0]=n[6]=e._width*-e.anchor.x,n[1]=n[3]=e._height*-e.anchor.y,n[2]=n[4]=e._width*(1-e.anchor.x),n[5]=n[7]=e._height*(1-e.anchor.y);var o=e.uvRespectAnchor?e.anchor.x:0,i=e.uvRespectAnchor?e.anchor.y:0;(n=r.uvs)[0]=n[6]=-o,n[1]=n[3]=-i,n[2]=n[4]=1-o,n[5]=n[7]=1-i,r.invalidate();var a=e._texture,s=a.baseTexture,u=e.tileTransform.localTransform,c=e.uvMatrix,l=s.isPowerOfTwo&&a.frame.width===s.width&&a.frame.height===s.height;l&&(s._glTextures[t.CONTEXT_UID]?l=s.wrapMode!==constants.WRAP_MODES.CLAMP:s.wrapMode===constants.WRAP_MODES.CLAMP&&(s.wrapMode=constants.WRAP_MODES.REPEAT));var p=l?this.simpleShader:this.shader,d=a.width,m=a.height,h=e._width,f=e._height;tempMat.set(u.a*d/h,u.b*d/f,u.c*m/h,u.d*m/f,u.tx/h,u.ty/f),tempMat.invert(),l?tempMat.prepend(c.mapCoord):(p.uniforms.uMapCoord=c.mapCoord.toArray(!0),p.uniforms.uClampFrame=c.uClampFrame,p.uniforms.uClampOffset=c.uClampOffset),p.uniforms.uTransform=tempMat.toArray(!0),p.uniforms.uColor=utils.premultiplyTintToRgba(e.tint,e.worldAlpha,p.uniforms.uColor,s.alphaMode),p.uniforms.translationMatrix=e.transform.worldTransform.toArray(!0),p.uniforms.uSampler=a,t.shader.bind(p),t.geometry.bind(r),this.state.blendMode=utils.correctBlendMode(e.blendMode,s.alphaMode),t.state.set(this.state),t.geometry.draw(this.renderer.gl.TRIANGLES,6,0)},t}(core.ObjectRenderer);exports.TilingSprite=TilingSprite,exports.TilingSpriteRenderer=TilingSpriteRenderer;
//# sourceMappingURL=sprite-tiling.min.js.map
