/*!
 * @pixi/math - v6.2.0
 * Compiled Mon, 01 Nov 2021 16:52:10 UTC
 *
 * @pixi/math is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var PI_2=2*Math.PI,RAD_TO_DEG=180/Math.PI,DEG_TO_RAD=Math.PI/180;!function(t){t[t.POLY=0]="POLY",t[t.RECT=1]="RECT",t[t.CIRC=2]="CIRC",t[t.ELIP=3]="ELIP",t[t.RREC=4]="RREC"}(exports.SHAPES||(exports.SHAPES={}));var Rectangle=function(){function t(t,i,s,h){void 0===t&&(t=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===h&&(h=0),this.x=Number(t),this.y=Number(i),this.width=Number(s),this.height=Number(h),this.type=exports.SHAPES.RECT}return Object.defineProperty(t.prototype,"left",{get:function(){return this.x},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x+this.width},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y+this.height},enumerable:!1,configurable:!0}),Object.defineProperty(t,"EMPTY",{get:function(){return new t(0,0,0,0)},enumerable:!1,configurable:!0}),t.prototype.clone=function(){return new t(this.x,this.y,this.width,this.height)},t.prototype.copyFrom=function(t){return this.x=t.x,this.y=t.y,this.width=t.width,this.height=t.height,this},t.prototype.copyTo=function(t){return t.x=this.x,t.y=this.y,t.width=this.width,t.height=this.height,t},t.prototype.contains=function(t,i){return!(this.width<=0||this.height<=0)&&(t>=this.x&&t<this.x+this.width&&i>=this.y&&i<this.y+this.height)},t.prototype.pad=function(t,i){return void 0===t&&(t=0),void 0===i&&(i=t),this.x-=t,this.y-=i,this.width+=2*t,this.height+=2*i,this},t.prototype.fit=function(t){var i=Math.max(this.x,t.x),s=Math.min(this.x+this.width,t.x+t.width),h=Math.max(this.y,t.y),o=Math.min(this.y+this.height,t.y+t.height);return this.x=i,this.width=Math.max(s-i,0),this.y=h,this.height=Math.max(o-h,0),this},t.prototype.ceil=function(t,i){void 0===t&&(t=1),void 0===i&&(i=.001);var s=Math.ceil((this.x+this.width-i)*t)/t,h=Math.ceil((this.y+this.height-i)*t)/t;return this.x=Math.floor((this.x+i)*t)/t,this.y=Math.floor((this.y+i)*t)/t,this.width=s-this.x,this.height=h-this.y,this},t.prototype.enlarge=function(t){var i=Math.min(this.x,t.x),s=Math.max(this.x+this.width,t.x+t.width),h=Math.min(this.y,t.y),o=Math.max(this.y+this.height,t.y+t.height);return this.x=i,this.width=s-i,this.y=h,this.height=o-h,this},t}(),Circle=function(){function t(t,i,s){void 0===t&&(t=0),void 0===i&&(i=0),void 0===s&&(s=0),this.x=t,this.y=i,this.radius=s,this.type=exports.SHAPES.CIRC}return t.prototype.clone=function(){return new t(this.x,this.y,this.radius)},t.prototype.contains=function(t,i){if(this.radius<=0)return!1;var s=this.radius*this.radius,h=this.x-t,o=this.y-i;return(h*=h)+(o*=o)<=s},t.prototype.getBounds=function(){return new Rectangle(this.x-this.radius,this.y-this.radius,2*this.radius,2*this.radius)},t}(),Ellipse=function(){function t(t,i,s,h){void 0===t&&(t=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===h&&(h=0),this.x=t,this.y=i,this.width=s,this.height=h,this.type=exports.SHAPES.ELIP}return t.prototype.clone=function(){return new t(this.x,this.y,this.width,this.height)},t.prototype.contains=function(t,i){if(this.width<=0||this.height<=0)return!1;var s=(t-this.x)/this.width,h=(i-this.y)/this.height;return(s*=s)+(h*=h)<=1},t.prototype.getBounds=function(){return new Rectangle(this.x-this.width,this.y-this.height,this.width,this.height)},t}(),Polygon=function(){function t(){for(var t=arguments,i=[],s=0;s<arguments.length;s++)i[s]=t[s];var h=Array.isArray(i[0])?i[0]:i;if("number"!=typeof h[0]){for(var o=[],r=0,e=h.length;r<e;r++)o.push(h[r].x,h[r].y);h=o}this.points=h,this.type=exports.SHAPES.POLY,this.closeStroke=!0}return t.prototype.clone=function(){var i=new t(this.points.slice());return i.closeStroke=this.closeStroke,i},t.prototype.contains=function(t,i){for(var s=!1,h=this.points.length/2,o=0,r=h-1;o<h;r=o++){var e=this.points[2*o],n=this.points[2*o+1],a=this.points[2*r],u=this.points[2*r+1];n>i!=u>i&&t<(i-n)/(u-n)*(a-e)+e&&(s=!s)}return s},t}(),RoundedRectangle=function(){function t(t,i,s,h,o){void 0===t&&(t=0),void 0===i&&(i=0),void 0===s&&(s=0),void 0===h&&(h=0),void 0===o&&(o=20),this.x=t,this.y=i,this.width=s,this.height=h,this.radius=o,this.type=exports.SHAPES.RREC}return t.prototype.clone=function(){return new t(this.x,this.y,this.width,this.height,this.radius)},t.prototype.contains=function(t,i){if(this.width<=0||this.height<=0)return!1;if(t>=this.x&&t<=this.x+this.width&&i>=this.y&&i<=this.y+this.height){if(i>=this.y+this.radius&&i<=this.y+this.height-this.radius||t>=this.x+this.radius&&t<=this.x+this.width-this.radius)return!0;var s=t-(this.x+this.radius),h=i-(this.y+this.radius),o=this.radius*this.radius;if(s*s+h*h<=o)return!0;if((s=t-(this.x+this.width-this.radius))*s+h*h<=o)return!0;if(s*s+(h=i-(this.y+this.height-this.radius))*h<=o)return!0;if((s=t-(this.x+this.radius))*s+h*h<=o)return!0}return!1},t}(),Point=function(){function t(t,i){void 0===t&&(t=0),void 0===i&&(i=0),this.x=0,this.y=0,this.x=t,this.y=i}return t.prototype.clone=function(){return new t(this.x,this.y)},t.prototype.copyFrom=function(t){return this.set(t.x,t.y),this},t.prototype.copyTo=function(t){return t.set(this.x,this.y),t},t.prototype.equals=function(t){return t.x===this.x&&t.y===this.y},t.prototype.set=function(t,i){return void 0===t&&(t=0),void 0===i&&(i=t),this.x=t,this.y=i,this},t}(),ObservablePoint=function(){function t(t,i,s,h){void 0===s&&(s=0),void 0===h&&(h=0),this._x=s,this._y=h,this.cb=t,this.scope=i}return t.prototype.clone=function(i,s){return void 0===i&&(i=this.cb),void 0===s&&(s=this.scope),new t(i,s,this._x,this._y)},t.prototype.set=function(t,i){return void 0===t&&(t=0),void 0===i&&(i=t),this._x===t&&this._y===i||(this._x=t,this._y=i,this.cb.call(this.scope)),this},t.prototype.copyFrom=function(t){return this._x===t.x&&this._y===t.y||(this._x=t.x,this._y=t.y,this.cb.call(this.scope)),this},t.prototype.copyTo=function(t){return t.set(this._x,this._y),t},t.prototype.equals=function(t){return t.x===this._x&&t.y===this._y},Object.defineProperty(t.prototype,"x",{get:function(){return this._x},set:function(t){this._x!==t&&(this._x=t,this.cb.call(this.scope))},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this._y},set:function(t){this._y!==t&&(this._y=t,this.cb.call(this.scope))},enumerable:!1,configurable:!0}),t}(),Matrix=function(){function t(t,i,s,h,o,r){void 0===t&&(t=1),void 0===i&&(i=0),void 0===s&&(s=0),void 0===h&&(h=1),void 0===o&&(o=0),void 0===r&&(r=0),this.array=null,this.a=t,this.b=i,this.c=s,this.d=h,this.tx=o,this.ty=r}return t.prototype.fromArray=function(t){this.a=t[0],this.b=t[1],this.c=t[3],this.d=t[4],this.tx=t[2],this.ty=t[5]},t.prototype.set=function(t,i,s,h,o,r){return this.a=t,this.b=i,this.c=s,this.d=h,this.tx=o,this.ty=r,this},t.prototype.toArray=function(t,i){this.array||(this.array=new Float32Array(9));var s=i||this.array;return t?(s[0]=this.a,s[1]=this.b,s[2]=0,s[3]=this.c,s[4]=this.d,s[5]=0,s[6]=this.tx,s[7]=this.ty,s[8]=1):(s[0]=this.a,s[1]=this.c,s[2]=this.tx,s[3]=this.b,s[4]=this.d,s[5]=this.ty,s[6]=0,s[7]=0,s[8]=1),s},t.prototype.apply=function(t,i){i=i||new Point;var s=t.x,h=t.y;return i.x=this.a*s+this.c*h+this.tx,i.y=this.b*s+this.d*h+this.ty,i},t.prototype.applyInverse=function(t,i){i=i||new Point;var s=1/(this.a*this.d+this.c*-this.b),h=t.x,o=t.y;return i.x=this.d*s*h+-this.c*s*o+(this.ty*this.c-this.tx*this.d)*s,i.y=this.a*s*o+-this.b*s*h+(-this.ty*this.a+this.tx*this.b)*s,i},t.prototype.translate=function(t,i){return this.tx+=t,this.ty+=i,this},t.prototype.scale=function(t,i){return this.a*=t,this.d*=i,this.c*=t,this.b*=i,this.tx*=t,this.ty*=i,this},t.prototype.rotate=function(t){var i=Math.cos(t),s=Math.sin(t),h=this.a,o=this.c,r=this.tx;return this.a=h*i-this.b*s,this.b=h*s+this.b*i,this.c=o*i-this.d*s,this.d=o*s+this.d*i,this.tx=r*i-this.ty*s,this.ty=r*s+this.ty*i,this},t.prototype.append=function(t){var i=this.a,s=this.b,h=this.c,o=this.d;return this.a=t.a*i+t.b*h,this.b=t.a*s+t.b*o,this.c=t.c*i+t.d*h,this.d=t.c*s+t.d*o,this.tx=t.tx*i+t.ty*h+this.tx,this.ty=t.tx*s+t.ty*o+this.ty,this},t.prototype.setTransform=function(t,i,s,h,o,r,e,n,a){return this.a=Math.cos(e+a)*o,this.b=Math.sin(e+a)*o,this.c=-Math.sin(e-n)*r,this.d=Math.cos(e-n)*r,this.tx=t-(s*this.a+h*this.c),this.ty=i-(s*this.b+h*this.d),this},t.prototype.prepend=function(t){var i=this.tx;if(1!==t.a||0!==t.b||0!==t.c||1!==t.d){var s=this.a,h=this.c;this.a=s*t.a+this.b*t.c,this.b=s*t.b+this.b*t.d,this.c=h*t.a+this.d*t.c,this.d=h*t.b+this.d*t.d}return this.tx=i*t.a+this.ty*t.c+t.tx,this.ty=i*t.b+this.ty*t.d+t.ty,this},t.prototype.decompose=function(t){var i=this.a,s=this.b,h=this.c,o=this.d,r=t.pivot,e=-Math.atan2(-h,o),n=Math.atan2(s,i),a=Math.abs(e+n);return a<1e-5||Math.abs(PI_2-a)<1e-5?(t.rotation=n,t.skew.x=t.skew.y=0):(t.rotation=0,t.skew.x=e,t.skew.y=n),t.scale.x=Math.sqrt(i*i+s*s),t.scale.y=Math.sqrt(h*h+o*o),t.position.x=this.tx+(r.x*i+r.y*h),t.position.y=this.ty+(r.x*s+r.y*o),t},t.prototype.invert=function(){var t=this.a,i=this.b,s=this.c,h=this.d,o=this.tx,r=t*h-i*s;return this.a=h/r,this.b=-i/r,this.c=-s/r,this.d=t/r,this.tx=(s*this.ty-h*o)/r,this.ty=-(t*this.ty-i*o)/r,this},t.prototype.identity=function(){return this.a=1,this.b=0,this.c=0,this.d=1,this.tx=0,this.ty=0,this},t.prototype.clone=function(){var i=new t;return i.a=this.a,i.b=this.b,i.c=this.c,i.d=this.d,i.tx=this.tx,i.ty=this.ty,i},t.prototype.copyTo=function(t){return t.a=this.a,t.b=this.b,t.c=this.c,t.d=this.d,t.tx=this.tx,t.ty=this.ty,t},t.prototype.copyFrom=function(t){return this.a=t.a,this.b=t.b,this.c=t.c,this.d=t.d,this.tx=t.tx,this.ty=t.ty,this},Object.defineProperty(t,"IDENTITY",{get:function(){return new t},enumerable:!1,configurable:!0}),Object.defineProperty(t,"TEMP_MATRIX",{get:function(){return new t},enumerable:!1,configurable:!0}),t}(),ux=[1,1,0,-1,-1,-1,0,1,1,1,0,-1,-1,-1,0,1],uy=[0,1,1,1,0,-1,-1,-1,0,1,1,1,0,-1,-1,-1],vx=[0,-1,-1,-1,0,1,1,1,0,1,1,1,0,-1,-1,-1],vy=[1,1,0,-1,-1,-1,0,1,-1,-1,0,1,1,1,0,-1],rotationCayley=[],rotationMatrices=[],signum=Math.sign;function init(){for(var t=0;t<16;t++){var i=[];rotationCayley.push(i);for(var s=0;s<16;s++)for(var h=signum(ux[t]*ux[s]+vx[t]*uy[s]),o=signum(uy[t]*ux[s]+vy[t]*uy[s]),r=signum(ux[t]*vx[s]+vx[t]*vy[s]),e=signum(uy[t]*vx[s]+vy[t]*vy[s]),n=0;n<16;n++)if(ux[n]===h&&uy[n]===o&&vx[n]===r&&vy[n]===e){i.push(n);break}}for(t=0;t<16;t++){var a=new Matrix;a.set(ux[t],uy[t],vx[t],vy[t],0,0),rotationMatrices.push(a)}}init();var groupD8={E:0,SE:1,S:2,SW:3,W:4,NW:5,N:6,NE:7,MIRROR_VERTICAL:8,MAIN_DIAGONAL:10,MIRROR_HORIZONTAL:12,REVERSE_DIAGONAL:14,uX:function(t){return ux[t]},uY:function(t){return uy[t]},vX:function(t){return vx[t]},vY:function(t){return vy[t]},inv:function(t){return 8&t?15&t:7&-t},add:function(t,i){return rotationCayley[t][i]},sub:function(t,i){return rotationCayley[t][groupD8.inv(i)]},rotate180:function(t){return 4^t},isVertical:function(t){return 2==(3&t)},byDirection:function(t,i){return 2*Math.abs(t)<=Math.abs(i)?i>=0?groupD8.S:groupD8.N:2*Math.abs(i)<=Math.abs(t)?t>0?groupD8.E:groupD8.W:i>0?t>0?groupD8.SE:groupD8.SW:t>0?groupD8.NE:groupD8.NW},matrixAppendRotationInv:function(t,i,s,h){void 0===s&&(s=0),void 0===h&&(h=0);var o=rotationMatrices[groupD8.inv(i)];o.tx=s,o.ty=h,t.append(o)}},Transform=function(){function t(){this.worldTransform=new Matrix,this.localTransform=new Matrix,this.position=new ObservablePoint(this.onChange,this,0,0),this.scale=new ObservablePoint(this.onChange,this,1,1),this.pivot=new ObservablePoint(this.onChange,this,0,0),this.skew=new ObservablePoint(this.updateSkew,this,0,0),this._rotation=0,this._cx=1,this._sx=0,this._cy=0,this._sy=1,this._localID=0,this._currentLocalID=0,this._worldID=0,this._parentID=0}return t.prototype.onChange=function(){this._localID++},t.prototype.updateSkew=function(){this._cx=Math.cos(this._rotation+this.skew.y),this._sx=Math.sin(this._rotation+this.skew.y),this._cy=-Math.sin(this._rotation-this.skew.x),this._sy=Math.cos(this._rotation-this.skew.x),this._localID++},t.prototype.updateLocalTransform=function(){var t=this.localTransform;this._localID!==this._currentLocalID&&(t.a=this._cx*this.scale.x,t.b=this._sx*this.scale.x,t.c=this._cy*this.scale.y,t.d=this._sy*this.scale.y,t.tx=this.position.x-(this.pivot.x*t.a+this.pivot.y*t.c),t.ty=this.position.y-(this.pivot.x*t.b+this.pivot.y*t.d),this._currentLocalID=this._localID,this._parentID=-1)},t.prototype.updateTransform=function(t){var i=this.localTransform;if(this._localID!==this._currentLocalID&&(i.a=this._cx*this.scale.x,i.b=this._sx*this.scale.x,i.c=this._cy*this.scale.y,i.d=this._sy*this.scale.y,i.tx=this.position.x-(this.pivot.x*i.a+this.pivot.y*i.c),i.ty=this.position.y-(this.pivot.x*i.b+this.pivot.y*i.d),this._currentLocalID=this._localID,this._parentID=-1),this._parentID!==t._worldID){var s=t.worldTransform,h=this.worldTransform;h.a=i.a*s.a+i.b*s.c,h.b=i.a*s.b+i.b*s.d,h.c=i.c*s.a+i.d*s.c,h.d=i.c*s.b+i.d*s.d,h.tx=i.tx*s.a+i.ty*s.c+s.tx,h.ty=i.tx*s.b+i.ty*s.d+s.ty,this._parentID=t._worldID,this._worldID++}},t.prototype.setFromMatrix=function(t){t.decompose(this),this._localID++},Object.defineProperty(t.prototype,"rotation",{get:function(){return this._rotation},set:function(t){this._rotation!==t&&(this._rotation=t,this.updateSkew())},enumerable:!1,configurable:!0}),t.IDENTITY=new t,t}();exports.Circle=Circle,exports.DEG_TO_RAD=DEG_TO_RAD,exports.Ellipse=Ellipse,exports.Matrix=Matrix,exports.ObservablePoint=ObservablePoint,exports.PI_2=PI_2,exports.Point=Point,exports.Polygon=Polygon,exports.RAD_TO_DEG=RAD_TO_DEG,exports.Rectangle=Rectangle,exports.RoundedRectangle=RoundedRectangle,exports.Transform=Transform,exports.groupD8=groupD8;
//# sourceMappingURL=math.min.js.map
