/*!
 * @pixi/graphics - v6.2.0
 * Compiled Mon, 01 Nov 2021 16:52:10 UTC
 *
 * @pixi/graphics is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 */
"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var core=require("@pixi/core"),math=require("@pixi/math"),utils=require("@pixi/utils"),constants=require("@pixi/constants"),display=require("@pixi/display");!function(t){t.MITER="miter",t.BEVEL="bevel",t.ROUND="round"}(exports.LINE_JOIN||(exports.LINE_JOIN={})),function(t){t.BUTT="butt",t.ROUND="round",t.SQUARE="square"}(exports.LINE_CAP||(exports.LINE_CAP={}));var GRAPHICS_CURVES={adaptive:!0,maxLength:10,minSegments:8,maxSegments:2048,epsilon:1e-4,_segmentsCount:function(t,e){if(void 0===e&&(e=20),!this.adaptive||!t||isNaN(t))return e;var i=Math.ceil(t/this.maxLength);return i<this.minSegments?i=this.minSegments:i>this.maxSegments&&(i=this.maxSegments),i}},FillStyle=function(){function t(){this.color=16777215,this.alpha=1,this.texture=core.Texture.WHITE,this.matrix=null,this.visible=!1,this.reset()}return t.prototype.clone=function(){var e=new t;return e.color=this.color,e.alpha=this.alpha,e.texture=this.texture,e.matrix=this.matrix,e.visible=this.visible,e},t.prototype.reset=function(){this.color=16777215,this.alpha=1,this.texture=core.Texture.WHITE,this.matrix=null,this.visible=!1},t.prototype.destroy=function(){this.texture=null,this.matrix=null},t}(),extendStatics=function(t,e){return(extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])})(t,e)};function __extends(t,e){function i(){this.constructor=t}extendStatics(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}var buildPoly={build:function(t){t.points=t.shape.points.slice()},triangulate:function(t,e){var i=t.points,r=t.holes,s=e.points,n=e.indices;if(i.length>=6){for(var a=[],h=0;h<r.length;h++){var o=r[h];a.push(i.length/2),i=i.concat(o.points)}var l=utils.earcut(i,a,2);if(!l)return;var u=s.length/2;for(h=0;h<l.length;h+=3)n.push(l[h]+u),n.push(l[h+1]+u),n.push(l[h+2]+u);for(h=0;h<i.length;h++)s.push(i[h])}}},buildCircle={build:function(t){var e,i,r=t.shape,s=t.points,n=r.x,a=r.y;if(s.length=0,t.type===math.SHAPES.CIRC)e=r.radius,i=r.radius;else{var h=t.shape;e=h.width,i=h.height}if(0!==e&&0!==i){var o=Math.floor(30*Math.sqrt(r.radius))||Math.floor(15*Math.sqrt(e+i));o/=2.3;for(var l=2*Math.PI/o,u=0;u<o-.5;u++)s.push(n+Math.sin(-l*u)*e,a+Math.cos(-l*u)*i);s.push(s[0],s[1])}},triangulate:function(t,e){var i=t.points,r=e.points,s=e.indices,n=r.length/2,a=n,h=t.shape,o=t.matrix,l=h.x,u=h.y;r.push(t.matrix?o.a*l+o.c*u+o.tx:l,t.matrix?o.b*l+o.d*u+o.ty:u);for(var c=0;c<i.length;c+=2)r.push(i[c],i[c+1]),s.push(n++,a,n)}},buildRectangle={build:function(t){var e=t.shape,i=e.x,r=e.y,s=e.width,n=e.height,a=t.points;a.length=0,a.push(i,r,i+s,r,i+s,r+n,i,r+n)},triangulate:function(t,e){var i=t.points,r=e.points,s=r.length/2;r.push(i[0],i[1],i[2],i[3],i[6],i[7],i[4],i[5]),e.indices.push(s,s+1,s+2,s+1,s+2,s+3)}};function getPt(t,e,i){return t+(e-t)*i}function quadraticBezierCurve(t,e,i,r,s,n,a){void 0===a&&(a=[]);for(var h=a,o=0,l=0,u=0,c=0,p=0,d=0,y=0,f=0;y<=20;++y)o=getPt(t,i,f=y/20),l=getPt(e,r,f),u=getPt(i,s,f),c=getPt(r,n,f),p=getPt(o,u,f),d=getPt(l,c,f),0===y&&h[h.length-2]===p&&h[h.length-1]===d||h.push(p,d);return h}var buildRoundedRectangle={build:function(t){var e=t.shape,i=t.points,r=e.x,s=e.y,n=e.width,a=e.height,h=Math.max(0,Math.min(e.radius,Math.min(n,a)/2));i.length=0,h?(quadraticBezierCurve(r,s+h,r,s,r+h,s,i),quadraticBezierCurve(r+n-h,s,r+n,s,r+n,s+h,i),quadraticBezierCurve(r+n,s+a-h,r+n,s+a,r+n-h,s+a,i),quadraticBezierCurve(r+h,s+a,r,s+a,r,s+a-h,i)):i.push(r,s,r+n,s,r+n,s+a,r,s+a)},triangulate:function(t,e){for(var i=t.points,r=e.points,s=e.indices,n=r.length/2,a=utils.earcut(i,null,2),h=0,o=a.length;h<o;h+=3)s.push(a[h]+n),s.push(a[h+1]+n),s.push(a[h+2]+n);for(h=0,o=i.length;h<o;h++)r.push(i[h],i[++h])}};function square(t,e,i,r,s,n,a,h){var o,l;a?(o=r,l=-i):(o=-r,l=i);var u=t-i*s+o,c=e-r*s+l,p=t+i*n+o,d=e+r*n+l;return h.push(u,c),h.push(p,d),2}function round(t,e,i,r,s,n,a,h){var o=i-t,l=r-e,u=Math.atan2(o,l),c=Math.atan2(s-t,n-e);h&&u<c?u+=2*Math.PI:!h&&u>c&&(c+=2*Math.PI);var p=u,d=c-u,y=Math.abs(d),f=Math.sqrt(o*o+l*l),g=1+(15*y*Math.sqrt(f)/Math.PI>>0),v=d/g;if(p+=v,h){a.push(t,e),a.push(i,r);for(var b=1,m=p;b<g;b++,m+=v)a.push(t,e),a.push(t+Math.sin(m)*f,e+Math.cos(m)*f);a.push(t,e),a.push(s,n)}else{a.push(i,r),a.push(t,e);for(b=1,m=p;b<g;b++,m+=v)a.push(t+Math.sin(m)*f,e+Math.cos(m)*f),a.push(t,e);a.push(s,n),a.push(t,e)}return 2*g}function buildNonNativeLine(t,e){var i=t.shape,r=t.points||i.points.slice(),s=e.closePointEps;if(0!==r.length){var n=t.lineStyle,a=new math.Point(r[0],r[1]),h=new math.Point(r[r.length-2],r[r.length-1]),o=i.type!==math.SHAPES.POLY||i.closeStroke,l=Math.abs(a.x-h.x)<s&&Math.abs(a.y-h.y)<s;if(o){r=r.slice(),l&&(r.pop(),r.pop(),h.set(r[r.length-2],r[r.length-1]));var u=.5*(a.x+h.x),c=.5*(h.y+a.y);r.unshift(u,c),r.push(u,c)}var p=e.points,d=r.length/2,y=r.length,f=p.length/2,g=n.width/2,v=g*g,b=n.miterLimit*n.miterLimit,m=r[0],_=r[1],x=r[2],S=r[3],P=0,A=0,w=-(_-S),M=m-x,D=0,C=0,E=Math.sqrt(w*w+M*M);w/=E,M/=E,w*=g,M*=g;var L=n.alignment,T=2*(1-L),I=2*L;o||(n.cap===exports.LINE_CAP.ROUND?y+=round(m-w*(T-I)*.5,_-M*(T-I)*.5,m-w*T,_-M*T,m+w*I,_+M*I,p,!0)+2:n.cap===exports.LINE_CAP.SQUARE&&(y+=square(m,_,w,M,T,I,!0,p))),p.push(m-w*T,_-M*T),p.push(m+w*I,_+M*I);for(var R=1;R<d-1;++R){m=r[2*(R-1)],_=r[2*(R-1)+1],x=r[2*R],S=r[2*R+1],P=r[2*(R+1)],A=r[2*(R+1)+1],w=-(_-S),M=m-x,w/=E=Math.sqrt(w*w+M*M),M/=E,w*=g,M*=g,D=-(S-A),C=x-P,D/=E=Math.sqrt(D*D+C*C),C/=E,D*=g,C*=g;var O=x-m,B=_-S,N=x-P,U=A-S,H=B*N-U*O,F=H<0;if(Math.abs(H)<.1)p.push(x-w*T,S-M*T),p.push(x+w*I,S+M*I);else{var G=(-w+m)*(-M+S)-(-w+x)*(-M+_),q=(-D+P)*(-C+S)-(-D+x)*(-C+A),z=(O*q-N*G)/H,j=(U*G-B*q)/H,W=(z-x)*(z-x)+(j-S)*(j-S),k=x+(z-x)*T,V=S+(j-S)*T,J=x-(z-x)*I,Y=S-(j-S)*I,Q=F?T:I;W<=Math.min(O*O+B*B,N*N+U*U)+Q*Q*v?n.join===exports.LINE_JOIN.BEVEL||W/v>b?(F?(p.push(k,V),p.push(x+w*I,S+M*I),p.push(k,V),p.push(x+D*I,S+C*I)):(p.push(x-w*T,S-M*T),p.push(J,Y),p.push(x-D*T,S-C*T),p.push(J,Y)),y+=2):n.join===exports.LINE_JOIN.ROUND?F?(p.push(k,V),p.push(x+w*I,S+M*I),y+=round(x,S,x+w*I,S+M*I,x+D*I,S+C*I,p,!0)+4,p.push(k,V),p.push(x+D*I,S+C*I)):(p.push(x-w*T,S-M*T),p.push(J,Y),y+=round(x,S,x-w*T,S-M*T,x-D*T,S-C*T,p,!1)+4,p.push(x-D*T,S-C*T),p.push(J,Y)):(p.push(k,V),p.push(J,Y)):(p.push(x-w*T,S-M*T),p.push(x+w*I,S+M*I),n.join===exports.LINE_JOIN.BEVEL||W/v>b||(n.join===exports.LINE_JOIN.ROUND?y+=F?round(x,S,x+w*I,S+M*I,x+D*I,S+C*I,p,!0)+2:round(x,S,x-w*T,S-M*T,x-D*T,S-C*T,p,!1)+2:(F?(p.push(J,Y),p.push(J,Y)):(p.push(k,V),p.push(k,V)),y+=2)),p.push(x-D*T,S-C*T),p.push(x+D*I,S+C*I),y+=2)}}m=r[2*(d-2)],_=r[2*(d-2)+1],x=r[2*(d-1)],w=-(_-(S=r[2*(d-1)+1])),M=m-x,w/=E=Math.sqrt(w*w+M*M),M/=E,w*=g,M*=g,p.push(x-w*T,S-M*T),p.push(x+w*I,S+M*I),o||(n.cap===exports.LINE_CAP.ROUND?y+=round(x-w*(T-I)*.5,S-M*(T-I)*.5,x-w*T,S-M*T,x+w*I,S+M*I,p,!1)+2:n.cap===exports.LINE_CAP.SQUARE&&(y+=square(x,S,w,M,T,I,!1,p)));var X=e.indices,Z=GRAPHICS_CURVES.epsilon*GRAPHICS_CURVES.epsilon;for(R=f;R<y+f-2;++R)m=p[2*R],_=p[2*R+1],x=p[2*(R+1)],S=p[2*(R+1)+1],P=p[2*(R+2)],A=p[2*(R+2)+1],Math.abs(m*(S-A)+x*(A-_)+P*(_-S))<Z||X.push(R,R+1,R+2)}}function buildNativeLine(t,e){var i=0,r=t.shape,s=t.points||r.points,n=r.type!==math.SHAPES.POLY||r.closeStroke;if(0!==s.length){var a=e.points,h=e.indices,o=s.length/2,l=a.length/2,u=l;for(a.push(s[0],s[1]),i=1;i<o;i++)a.push(s[2*i],s[2*i+1]),h.push(u,u+1),u++;n&&h.push(u,l)}}function buildLine(t,e){t.lineStyle.native?buildNativeLine(t,e):buildNonNativeLine(t,e)}var _a,ArcUtils=function(){function t(){}return t.curveTo=function(t,e,i,r,s,n){var a=n[n.length-2],h=n[n.length-1]-e,o=a-t,l=r-e,u=i-t,c=Math.abs(h*u-o*l);if(c<1e-8||0===s)return n[n.length-2]===t&&n[n.length-1]===e||n.push(t,e),null;var p=h*h+o*o,d=l*l+u*u,y=h*l+o*u,f=s*Math.sqrt(p)/c,g=s*Math.sqrt(d)/c,v=f*y/p,b=g*y/d,m=f*u+g*o,_=f*l+g*h,x=o*(g+v),S=h*(g+v),P=u*(f+b),A=l*(f+b);return{cx:m+t,cy:_+e,radius:s,startAngle:Math.atan2(S-_,x-m),endAngle:Math.atan2(A-_,P-m),anticlockwise:o*l>u*h}},t.arc=function(t,e,i,r,s,n,a,h,o){for(var l=a-n,u=GRAPHICS_CURVES._segmentsCount(Math.abs(l)*s,40*Math.ceil(Math.abs(l)/math.PI_2)),c=l/(2*u),p=2*c,d=Math.cos(c),y=Math.sin(c),f=u-1,g=f%1/f,v=0;v<=f;++v){var b=c+n+p*(v+g*v),m=Math.cos(b),_=-Math.sin(b);o.push((d*m+y*_)*s+i,(d*-_+y*m)*s+r)}},t}(),BezierUtils=function(){function t(){}return t.curveLength=function(t,e,i,r,s,n,a,h){for(var o=0,l=0,u=0,c=0,p=0,d=0,y=0,f=0,g=0,v=0,b=0,m=t,_=e,x=1;x<=10;++x)v=m-(f=(y=(d=(p=1-(l=x/10))*p)*p)*t+3*d*l*i+3*p*(u=l*l)*s+(c=u*l)*a),b=_-(g=y*e+3*d*l*r+3*p*u*n+c*h),m=f,_=g,o+=Math.sqrt(v*v+b*b);return o},t.curveTo=function(e,i,r,s,n,a,h){var o=h[h.length-2],l=h[h.length-1];h.length-=2;var u=GRAPHICS_CURVES._segmentsCount(t.curveLength(o,l,e,i,r,s,n,a)),c=0,p=0,d=0,y=0,f=0;h.push(o,l);for(var g=1,v=0;g<=u;++g)d=(p=(c=1-(v=g/u))*c)*c,f=(y=v*v)*v,h.push(d*o+3*p*v*e+3*c*y*r+f*n,d*l+3*p*v*i+3*c*y*s+f*a)},t}(),QuadraticUtils=function(){function t(){}return t.curveLength=function(t,e,i,r,s,n){var a=t-2*i+s,h=e-2*r+n,o=2*i-2*t,l=2*r-2*e,u=4*(a*a+h*h),c=4*(a*o+h*l),p=o*o+l*l,d=2*Math.sqrt(u+c+p),y=Math.sqrt(u),f=2*u*y,g=2*Math.sqrt(p),v=c/y;return(f*d+y*c*(d-g)+(4*p*u-c*c)*Math.log((2*y+v+d)/(v+g)))/(4*f)},t.curveTo=function(e,i,r,s,n){for(var a=n[n.length-2],h=n[n.length-1],o=GRAPHICS_CURVES._segmentsCount(t.curveLength(a,h,e,i,r,s)),l=0,u=0,c=1;c<=o;++c){var p=c/o;l=a+(e-a)*p,u=h+(i-h)*p,n.push(l+(e+(r-e)*p-l)*p,u+(i+(s-i)*p-u)*p)}},t}(),BatchPart=function(){function t(){this.reset()}return t.prototype.begin=function(t,e,i){this.reset(),this.style=t,this.start=e,this.attribStart=i},t.prototype.end=function(t,e){this.attribSize=e-this.attribStart,this.size=t-this.start},t.prototype.reset=function(){this.style=null,this.size=0,this.start=0,this.attribStart=0,this.attribSize=0},t}(),FILL_COMMANDS=((_a={})[math.SHAPES.POLY]=buildPoly,_a[math.SHAPES.CIRC]=buildCircle,_a[math.SHAPES.ELIP]=buildCircle,_a[math.SHAPES.RECT]=buildRectangle,_a[math.SHAPES.RREC]=buildRoundedRectangle,_a),BATCH_POOL=[],DRAW_CALL_POOL=[];function isPolygonClockwise(t){for(var e=t.points,i=0,r=0;r<e.length-2;r+=2)i+=(e[r+2]-e[r])*(e[r+3]+e[r+1]);return i>0}var GraphicsData=function(){function t(t,e,i,r){void 0===e&&(e=null),void 0===i&&(i=null),void 0===r&&(r=null),this.points=[],this.holes=[],this.shape=t,this.lineStyle=i,this.fillStyle=e,this.matrix=r,this.type=t.type}return t.prototype.clone=function(){return new t(this.shape,this.fillStyle,this.lineStyle,this.matrix)},t.prototype.destroy=function(){this.shape=null,this.holes.length=0,this.holes=null,this.points.length=0,this.points=null,this.lineStyle=null,this.fillStyle=null},t}(),tmpPoint=new math.Point,tmpBounds=new display.Bounds,GraphicsGeometry=function(t){function e(){var e=t.call(this)||this;return e.closePointEps=1e-4,e.boundsPadding=0,e.uvsFloat32=null,e.indicesUint16=null,e.batchable=!1,e.points=[],e.colors=[],e.uvs=[],e.indices=[],e.textureIds=[],e.graphicsData=[],e.drawCalls=[],e.batchDirty=-1,e.batches=[],e.dirty=0,e.cacheDirty=-1,e.clearDirty=0,e.shapeIndex=0,e._bounds=new display.Bounds,e.boundsDirty=-1,e}return __extends(e,t),Object.defineProperty(e.prototype,"bounds",{get:function(){return this.boundsDirty!==this.dirty&&(this.boundsDirty=this.dirty,this.calculateBounds()),this._bounds},enumerable:!1,configurable:!0}),e.prototype.invalidate=function(){this.boundsDirty=-1,this.dirty++,this.batchDirty++,this.shapeIndex=0,this.points.length=0,this.colors.length=0,this.uvs.length=0,this.indices.length=0,this.textureIds.length=0;for(var t=0;t<this.drawCalls.length;t++)this.drawCalls[t].texArray.clear(),DRAW_CALL_POOL.push(this.drawCalls[t]);this.drawCalls.length=0;for(t=0;t<this.batches.length;t++){var e=this.batches[t];e.reset(),BATCH_POOL.push(e)}this.batches.length=0},e.prototype.clear=function(){return this.graphicsData.length>0&&(this.invalidate(),this.clearDirty++,this.graphicsData.length=0),this},e.prototype.drawShape=function(t,e,i,r){void 0===e&&(e=null),void 0===i&&(i=null),void 0===r&&(r=null);var s=new GraphicsData(t,e,i,r);return this.graphicsData.push(s),this.dirty++,this},e.prototype.drawHole=function(t,e){if(void 0===e&&(e=null),!this.graphicsData.length)return null;var i=new GraphicsData(t,null,null,e),r=this.graphicsData[this.graphicsData.length-1];return i.lineStyle=r.lineStyle,r.holes.push(i),this.dirty++,this},e.prototype.destroy=function(){t.prototype.destroy.call(this);for(var e=0;e<this.graphicsData.length;++e)this.graphicsData[e].destroy();this.points.length=0,this.points=null,this.colors.length=0,this.colors=null,this.uvs.length=0,this.uvs=null,this.indices.length=0,this.indices=null,this.indexBuffer.destroy(),this.indexBuffer=null,this.graphicsData.length=0,this.graphicsData=null,this.drawCalls.length=0,this.drawCalls=null,this.batches.length=0,this.batches=null,this._bounds=null},e.prototype.containsPoint=function(t){for(var e=this.graphicsData,i=0;i<e.length;++i){var r=e[i];if(r.fillStyle.visible&&(r.shape&&(r.matrix?r.matrix.applyInverse(t,tmpPoint):tmpPoint.copyFrom(t),r.shape.contains(tmpPoint.x,tmpPoint.y)))){var s=!1;if(r.holes)for(var n=0;n<r.holes.length;n++){if(r.holes[n].shape.contains(tmpPoint.x,tmpPoint.y)){s=!0;break}}if(!s)return!0}}return!1},e.prototype.updateBatches=function(t){if(this.graphicsData.length){if(this.validateBatching()){this.cacheDirty=this.dirty;var e=this.uvs,i=this.graphicsData,r=null,s=null;this.batches.length>0&&(s=(r=this.batches[this.batches.length-1]).style);for(var n=this.shapeIndex;n<i.length;n++){this.shapeIndex++;var a=i[n],h=a.fillStyle,o=a.lineStyle;FILL_COMMANDS[a.type].build(a),a.matrix&&this.transformPoints(a.points,a.matrix);for(var l=0;l<2;l++){var u=0===l?h:o;if(u.visible){var c=u.texture.baseTexture,p=this.indices.length,d=this.points.length/2;c.wrapMode=constants.WRAP_MODES.REPEAT,0===l?this.processFill(a):this.processLine(a);var y=this.points.length/2-d;0!==y&&(r&&!this._compareStyles(s,u)&&(r.end(p,d),r=null),r||((r=BATCH_POOL.pop()||new BatchPart).begin(u,p,d),this.batches.push(r),s=u),this.addUvs(this.points,e,u.texture,d,y,u.matrix))}}}var f=this.indices.length,g=this.points.length/2;if(r&&r.end(f,g),0!==this.batches.length){if(this.indicesUint16&&this.indices.length===this.indicesUint16.length)this.indicesUint16.set(this.indices);else{var v=g>65535&&t;this.indicesUint16=v?new Uint32Array(this.indices):new Uint16Array(this.indices)}this.batchable=this.isBatchable(),this.batchable?this.packBatches():this.buildDrawCalls()}else this.batchable=!0}}else this.batchable=!0},e.prototype._compareStyles=function(t,e){return!(!t||!e)&&(t.texture.baseTexture===e.texture.baseTexture&&(t.color+t.alpha===e.color+e.alpha&&!!t.native==!!e.native))},e.prototype.validateBatching=function(){if(this.dirty===this.cacheDirty||!this.graphicsData.length)return!1;for(var t=0,e=this.graphicsData.length;t<e;t++){var i=this.graphicsData[t],r=i.fillStyle,s=i.lineStyle;if(r&&!r.texture.baseTexture.valid)return!1;if(s&&!s.texture.baseTexture.valid)return!1}return!0},e.prototype.packBatches=function(){this.batchDirty++,this.uvsFloat32=new Float32Array(this.uvs);for(var t=this.batches,e=0,i=t.length;e<i;e++)for(var r=t[e],s=0;s<r.size;s++){var n=r.start+s;this.indicesUint16[n]=this.indicesUint16[n]-r.attribStart}},e.prototype.isBatchable=function(){if(this.points.length>131070)return!1;for(var t=this.batches,i=0;i<t.length;i++)if(t[i].style.native)return!1;return this.points.length<2*e.BATCHABLE_SIZE},e.prototype.buildDrawCalls=function(){for(var t=++core.BaseTexture._globalBatch,e=0;e<this.drawCalls.length;e++)this.drawCalls[e].texArray.clear(),DRAW_CALL_POOL.push(this.drawCalls[e]);this.drawCalls.length=0;var i=this.colors,r=this.textureIds,s=DRAW_CALL_POOL.pop();s||((s=new core.BatchDrawCall).texArray=new core.BatchTextureArray),s.texArray.count=0,s.start=0,s.size=0,s.type=constants.DRAW_MODES.TRIANGLES;var n=0,a=null,h=0,o=!1,l=constants.DRAW_MODES.TRIANGLES,u=0;this.drawCalls.push(s);for(e=0;e<this.batches.length;e++){var c=this.batches[e],p=c.style,d=p.texture.baseTexture;o!==!!p.native&&(l=(o=!!p.native)?constants.DRAW_MODES.LINES:constants.DRAW_MODES.TRIANGLES,a=null,n=8,t++),a!==d&&(a=d,d._batchEnabled!==t&&(8===n&&(t++,n=0,s.size>0&&((s=DRAW_CALL_POOL.pop())||((s=new core.BatchDrawCall).texArray=new core.BatchTextureArray),this.drawCalls.push(s)),s.start=u,s.size=0,s.texArray.count=0,s.type=l),d.touched=1,d._batchEnabled=t,d._batchLocation=n,d.wrapMode=constants.WRAP_MODES.REPEAT,s.texArray.elements[s.texArray.count++]=d,n++)),s.size+=c.size,u+=c.size,h=d._batchLocation,this.addColors(i,p.color,p.alpha,c.attribSize,c.attribStart),this.addTextureIds(r,h,c.attribSize,c.attribStart)}core.BaseTexture._globalBatch=t,this.packAttributes()},e.prototype.packAttributes=function(){for(var t=this.points,e=this.uvs,i=this.colors,r=this.textureIds,s=new ArrayBuffer(3*t.length*4),n=new Float32Array(s),a=new Uint32Array(s),h=0,o=0;o<t.length/2;o++)n[h++]=t[2*o],n[h++]=t[2*o+1],n[h++]=e[2*o],n[h++]=e[2*o+1],a[h++]=i[o],n[h++]=r[o];this._buffer.update(s),this._indexBuffer.update(this.indicesUint16)},e.prototype.processFill=function(t){t.holes.length?(this.processHoles(t.holes),buildPoly.triangulate(t,this)):FILL_COMMANDS[t.type].triangulate(t,this)},e.prototype.processLine=function(t){buildLine(t,this);for(var e=0;e<t.holes.length;e++)buildLine(t.holes[e],this)},e.prototype.processHoles=function(t){for(var e=0;e<t.length;e++){var i=t[e];FILL_COMMANDS[i.type].build(i),i.matrix&&this.transformPoints(i.points,i.matrix)}},e.prototype.calculateBounds=function(){var t=this._bounds,e=tmpBounds,i=math.Matrix.IDENTITY;this._bounds.clear(),e.clear();for(var r=0;r<this.graphicsData.length;r++){var s=this.graphicsData[r],n=s.shape,a=s.type,h=s.lineStyle,o=s.matrix||math.Matrix.IDENTITY,l=0;if(h&&h.visible){var u=h.alignment;l=h.width,a===math.SHAPES.POLY?isPolygonClockwise(n)?l*=1-u:l*=u:l*=Math.max(0,u)}if(i!==o&&(e.isEmpty()||(t.addBoundsMatrix(e,i),e.clear()),i=o),a===math.SHAPES.RECT||a===math.SHAPES.RREC){var c=n;e.addFramePad(c.x,c.y,c.x+c.width,c.y+c.height,l,l)}else if(a===math.SHAPES.CIRC){var p=n;e.addFramePad(p.x,p.y,p.x,p.y,p.radius+l,p.radius+l)}else if(a===math.SHAPES.ELIP){var d=n;e.addFramePad(d.x,d.y,d.x,d.y,d.width+l,d.height+l)}else{var y=n;t.addVerticesMatrix(i,y.points,0,y.points.length,l,l)}}e.isEmpty()||t.addBoundsMatrix(e,i),t.pad(this.boundsPadding,this.boundsPadding)},e.prototype.transformPoints=function(t,e){for(var i=0;i<t.length/2;i++){var r=t[2*i],s=t[2*i+1];t[2*i]=e.a*r+e.c*s+e.tx,t[2*i+1]=e.b*r+e.d*s+e.ty}},e.prototype.addColors=function(t,e,i,r,s){void 0===s&&(s=0);var n=(e>>16)+(65280&e)+((255&e)<<16),a=utils.premultiplyTint(n,i);t.length=Math.max(t.length,s+r);for(var h=0;h<r;h++)t[s+h]=a},e.prototype.addTextureIds=function(t,e,i,r){void 0===r&&(r=0),t.length=Math.max(t.length,r+i);for(var s=0;s<i;s++)t[r+s]=e},e.prototype.addUvs=function(t,e,i,r,s,n){void 0===n&&(n=null);for(var a=0,h=e.length,o=i.frame;a<s;){var l=t[2*(r+a)],u=t[2*(r+a)+1];if(n){var c=n.a*l+n.c*u+n.tx;u=n.b*l+n.d*u+n.ty,l=c}a++,e.push(l/o.width,u/o.height)}var p=i.baseTexture;(o.width<p.width||o.height<p.height)&&this.adjustUvs(e,i,h,s)},e.prototype.adjustUvs=function(t,e,i,r){for(var s=e.baseTexture,n=i+2*r,a=e.frame,h=a.width/s.width,o=a.height/s.height,l=a.x/a.width,u=a.y/a.height,c=Math.floor(t[i]+1e-6),p=Math.floor(t[i+1]+1e-6),d=i+2;d<n;d+=2)c=Math.min(c,Math.floor(t[d]+1e-6)),p=Math.min(p,Math.floor(t[d+1]+1e-6));l-=c,u-=p;for(d=i;d<n;d+=2)t[d]=(t[d]+l)*h,t[d+1]=(t[d+1]+u)*o},e.BATCHABLE_SIZE=100,e}(core.BatchGeometry),LineStyle=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e.width=0,e.alignment=.5,e.native=!1,e.cap=exports.LINE_CAP.BUTT,e.join=exports.LINE_JOIN.MITER,e.miterLimit=10,e}return __extends(e,t),e.prototype.clone=function(){var t=new e;return t.color=this.color,t.alpha=this.alpha,t.texture=this.texture,t.matrix=this.matrix,t.visible=this.visible,t.width=this.width,t.alignment=this.alignment,t.native=this.native,t.cap=this.cap,t.join=this.join,t.miterLimit=this.miterLimit,t},e.prototype.reset=function(){t.prototype.reset.call(this),this.color=0,this.alignment=.5,this.width=0,this.native=!1},e}(FillStyle),temp=new Float32Array(3),DEFAULT_SHADERS={},Graphics=function(t){function e(e){void 0===e&&(e=null);var i=t.call(this)||this;return i.shader=null,i.pluginName="batch",i.currentPath=null,i.batches=[],i.batchTint=-1,i.batchDirty=-1,i.vertexData=null,i._fillStyle=new FillStyle,i._lineStyle=new LineStyle,i._matrix=null,i._holeMode=!1,i.state=core.State.for2d(),i._geometry=e||new GraphicsGeometry,i._geometry.refCount++,i._transformID=-1,i.tint=16777215,i.blendMode=constants.BLEND_MODES.NORMAL,i}return __extends(e,t),Object.defineProperty(e.prototype,"geometry",{get:function(){return this._geometry},enumerable:!1,configurable:!0}),e.prototype.clone=function(){return this.finishPoly(),new e(this._geometry)},Object.defineProperty(e.prototype,"blendMode",{get:function(){return this.state.blendMode},set:function(t){this.state.blendMode=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"tint",{get:function(){return this._tint},set:function(t){this._tint=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"fill",{get:function(){return this._fillStyle},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"line",{get:function(){return this._lineStyle},enumerable:!1,configurable:!0}),e.prototype.lineStyle=function(t,e,i,r,s){return void 0===t&&(t=null),void 0===e&&(e=0),void 0===i&&(i=1),void 0===r&&(r=.5),void 0===s&&(s=!1),"number"==typeof t&&(t={width:t,color:e,alpha:i,alignment:r,native:s}),this.lineTextureStyle(t)},e.prototype.lineTextureStyle=function(t){t=Object.assign({width:0,texture:core.Texture.WHITE,color:t&&t.texture?16777215:0,alpha:1,matrix:null,alignment:.5,native:!1,cap:exports.LINE_CAP.BUTT,join:exports.LINE_JOIN.MITER,miterLimit:10},t),this.currentPath&&this.startPoly();var e=t.width>0&&t.alpha>0;return e?(t.matrix&&(t.matrix=t.matrix.clone(),t.matrix.invert()),Object.assign(this._lineStyle,{visible:e},t)):this._lineStyle.reset(),this},e.prototype.startPoly=function(){if(this.currentPath){var t=this.currentPath.points,e=this.currentPath.points.length;e>2&&(this.drawShape(this.currentPath),this.currentPath=new math.Polygon,this.currentPath.closeStroke=!1,this.currentPath.points.push(t[e-2],t[e-1]))}else this.currentPath=new math.Polygon,this.currentPath.closeStroke=!1},e.prototype.finishPoly=function(){this.currentPath&&(this.currentPath.points.length>2?(this.drawShape(this.currentPath),this.currentPath=null):this.currentPath.points.length=0)},e.prototype.moveTo=function(t,e){return this.startPoly(),this.currentPath.points[0]=t,this.currentPath.points[1]=e,this},e.prototype.lineTo=function(t,e){this.currentPath||this.moveTo(0,0);var i=this.currentPath.points,r=i[i.length-2],s=i[i.length-1];return r===t&&s===e||i.push(t,e),this},e.prototype._initCurve=function(t,e){void 0===t&&(t=0),void 0===e&&(e=0),this.currentPath?0===this.currentPath.points.length&&(this.currentPath.points=[t,e]):this.moveTo(t,e)},e.prototype.quadraticCurveTo=function(t,e,i,r){this._initCurve();var s=this.currentPath.points;return 0===s.length&&this.moveTo(0,0),QuadraticUtils.curveTo(t,e,i,r,s),this},e.prototype.bezierCurveTo=function(t,e,i,r,s,n){return this._initCurve(),BezierUtils.curveTo(t,e,i,r,s,n,this.currentPath.points),this},e.prototype.arcTo=function(t,e,i,r,s){this._initCurve(t,e);var n=this.currentPath.points,a=ArcUtils.curveTo(t,e,i,r,s,n);if(a){var h=a.cx,o=a.cy,l=a.radius,u=a.startAngle,c=a.endAngle,p=a.anticlockwise;this.arc(h,o,l,u,c,p)}return this},e.prototype.arc=function(t,e,i,r,s,n){if(void 0===n&&(n=!1),r===s)return this;if(!n&&s<=r?s+=math.PI_2:n&&r<=s&&(r+=math.PI_2),0===s-r)return this;var a=t+Math.cos(r)*i,h=e+Math.sin(r)*i,o=this._geometry.closePointEps,l=this.currentPath?this.currentPath.points:null;if(l){var u=Math.abs(l[l.length-2]-a),c=Math.abs(l[l.length-1]-h);u<o&&c<o||l.push(a,h)}else this.moveTo(a,h),l=this.currentPath.points;return ArcUtils.arc(a,h,t,e,i,r,s,n,l),this},e.prototype.beginFill=function(t,e){return void 0===t&&(t=0),void 0===e&&(e=1),this.beginTextureFill({texture:core.Texture.WHITE,color:t,alpha:e})},e.prototype.beginTextureFill=function(t){t=Object.assign({texture:core.Texture.WHITE,color:16777215,alpha:1,matrix:null},t),this.currentPath&&this.startPoly();var e=t.alpha>0;return e?(t.matrix&&(t.matrix=t.matrix.clone(),t.matrix.invert()),Object.assign(this._fillStyle,{visible:e},t)):this._fillStyle.reset(),this},e.prototype.endFill=function(){return this.finishPoly(),this._fillStyle.reset(),this},e.prototype.drawRect=function(t,e,i,r){return this.drawShape(new math.Rectangle(t,e,i,r))},e.prototype.drawRoundedRect=function(t,e,i,r,s){return this.drawShape(new math.RoundedRectangle(t,e,i,r,s))},e.prototype.drawCircle=function(t,e,i){return this.drawShape(new math.Circle(t,e,i))},e.prototype.drawEllipse=function(t,e,i,r){return this.drawShape(new math.Ellipse(t,e,i,r))},e.prototype.drawPolygon=function(){for(var t,e=arguments,i=[],r=0;r<arguments.length;r++)i[r]=e[r];var s=!0,n=i[0];n.points?(s=n.closeStroke,t=n.points):t=Array.isArray(i[0])?i[0]:i;var a=new math.Polygon(t);return a.closeStroke=s,this.drawShape(a),this},e.prototype.drawShape=function(t){return this._holeMode?this._geometry.drawHole(t,this._matrix):this._geometry.drawShape(t,this._fillStyle.clone(),this._lineStyle.clone(),this._matrix),this},e.prototype.clear=function(){return this._geometry.clear(),this._lineStyle.reset(),this._fillStyle.reset(),this._boundsID++,this._matrix=null,this._holeMode=!1,this.currentPath=null,this},e.prototype.isFastRect=function(){var t=this._geometry.graphicsData;return!(1!==t.length||t[0].shape.type!==math.SHAPES.RECT||t[0].holes.length||t[0].lineStyle.visible&&t[0].lineStyle.width)},e.prototype._render=function(t){this.finishPoly();var e=this._geometry,i=t.context.supports.uint32Indices;e.updateBatches(i),e.batchable?(this.batchDirty!==e.batchDirty&&this._populateBatches(),this._renderBatched(t)):(t.batch.flush(),this._renderDirect(t))},e.prototype._populateBatches=function(){var t=this._geometry,e=this.blendMode,i=t.batches.length;this.batchTint=-1,this._transformID=-1,this.batchDirty=t.batchDirty,this.batches.length=i,this.vertexData=new Float32Array(t.points);for(var r=0;r<i;r++){var s=t.batches[r],n=s.style.color,a=new Float32Array(this.vertexData.buffer,4*s.attribStart*2,2*s.attribSize),h=new Float32Array(t.uvsFloat32.buffer,4*s.attribStart*2,2*s.attribSize),o={vertexData:a,blendMode:e,indices:new Uint16Array(t.indicesUint16.buffer,2*s.start,s.size),uvs:h,_batchRGB:utils.hex2rgb(n),_tintRGB:n,_texture:s.style.texture,alpha:s.style.alpha,worldAlpha:1};this.batches[r]=o}},e.prototype._renderBatched=function(t){if(this.batches.length){t.batch.setObjectRenderer(t.plugins[this.pluginName]),this.calculateVertices(),this.calculateTints();for(var e=0,i=this.batches.length;e<i;e++){var r=this.batches[e];r.worldAlpha=this.worldAlpha*r.alpha,t.plugins[this.pluginName].render(r)}}},e.prototype._renderDirect=function(t){var e=this._resolveDirectShader(t),i=this._geometry,r=this.tint,s=this.worldAlpha,n=e.uniforms,a=i.drawCalls;n.translationMatrix=this.transform.worldTransform,n.tint[0]=(r>>16&255)/255*s,n.tint[1]=(r>>8&255)/255*s,n.tint[2]=(255&r)/255*s,n.tint[3]=s,t.shader.bind(e),t.geometry.bind(i,e),t.state.set(this.state);for(var h=0,o=a.length;h<o;h++)this._renderDrawCallDirect(t,i.drawCalls[h])},e.prototype._renderDrawCallDirect=function(t,e){for(var i=e.texArray,r=e.type,s=e.size,n=e.start,a=i.count,h=0;h<a;h++)t.texture.bind(i.elements[h],h);t.geometry.draw(r,s,n)},e.prototype._resolveDirectShader=function(t){var e=this.shader,i=this.pluginName;if(!e){if(!DEFAULT_SHADERS[i]){for(var r=t.plugins.batch.MAX_TEXTURES,s=new Int32Array(r),n=0;n<r;n++)s[n]=n;var a={tint:new Float32Array([1,1,1,1]),translationMatrix:new math.Matrix,default:core.UniformGroup.from({uSamplers:s},!0)},h=t.plugins[i]._shader.program;DEFAULT_SHADERS[i]=new core.Shader(h,a)}e=DEFAULT_SHADERS[i]}return e},e.prototype._calculateBounds=function(){this.finishPoly();var t=this._geometry;if(t.graphicsData.length){var e=t.bounds,i=e.minX,r=e.minY,s=e.maxX,n=e.maxY;this._bounds.addFrame(this.transform,i,r,s,n)}},e.prototype.containsPoint=function(t){return this.worldTransform.applyInverse(t,e._TEMP_POINT),this._geometry.containsPoint(e._TEMP_POINT)},e.prototype.calculateTints=function(){if(this.batchTint!==this.tint){this.batchTint=this.tint;for(var t=utils.hex2rgb(this.tint,temp),e=0;e<this.batches.length;e++){var i=this.batches[e],r=i._batchRGB,s=(t[0]*r[0]*255<<16)+(t[1]*r[1]*255<<8)+(0|t[2]*r[2]*255);i._tintRGB=(s>>16)+(65280&s)+((255&s)<<16)}}},e.prototype.calculateVertices=function(){var t=this.transform._worldID;if(this._transformID!==t){this._transformID=t;for(var e=this.transform.worldTransform,i=e.a,r=e.b,s=e.c,n=e.d,a=e.tx,h=e.ty,o=this._geometry.points,l=this.vertexData,u=0,c=0;c<o.length;c+=2){var p=o[c],d=o[c+1];l[u++]=i*p+s*d+a,l[u++]=n*d+r*p+h}}},e.prototype.closePath=function(){var t=this.currentPath;return t&&(t.closeStroke=!0,this.finishPoly()),this},e.prototype.setMatrix=function(t){return this._matrix=t,this},e.prototype.beginHole=function(){return this.finishPoly(),this._holeMode=!0,this},e.prototype.endHole=function(){return this.finishPoly(),this._holeMode=!1,this},e.prototype.destroy=function(e){this._geometry.refCount--,0===this._geometry.refCount&&this._geometry.dispose(),this._matrix=null,this.currentPath=null,this._lineStyle.destroy(),this._lineStyle=null,this._fillStyle.destroy(),this._fillStyle=null,this._geometry=null,this.shader=null,this.vertexData=null,this.batches.length=0,this.batches=null,t.prototype.destroy.call(this,e)},e._TEMP_POINT=new math.Point,e}(display.Container),graphicsUtils={buildPoly:buildPoly,buildCircle:buildCircle,buildRectangle:buildRectangle,buildRoundedRectangle:buildRoundedRectangle,buildLine:buildLine,ArcUtils:ArcUtils,BezierUtils:BezierUtils,QuadraticUtils:QuadraticUtils,BatchPart:BatchPart,FILL_COMMANDS:FILL_COMMANDS,BATCH_POOL:BATCH_POOL,DRAW_CALL_POOL:DRAW_CALL_POOL};exports.FillStyle=FillStyle,exports.GRAPHICS_CURVES=GRAPHICS_CURVES,exports.Graphics=Graphics,exports.GraphicsData=GraphicsData,exports.GraphicsGeometry=GraphicsGeometry,exports.LineStyle=LineStyle,exports.graphicsUtils=graphicsUtils;
//# sourceMappingURL=graphics.min.js.map
