import { BatchTextureArray } from '@pixi/core';
import { BLEND_MODES } from '@pixi/constants';
import { Bounds } from '@pixi/display';
import { Buffer as Buffer_2 } from '@pixi/core';
import type { Circle } from '@pixi/math';
import { Container } from '@pixi/display';
import type { Ellipse } from '@pixi/math';
import { Geometry } from '@pixi/core';
import type { IDestroyOptions } from '@pixi/display';
import type { IPointData } from '@pixi/math';
import type { IShape as IShape_2 } from '@pixi/math';
import { LINE_CAP } from '@pixi/graphics';
import { LINE_JOIN } from '@pixi/graphics';
import { Matrix } from '@pixi/math';
import { Point } from '@pixi/math';
import { Polygon } from '@pixi/math';
import { Program } from '@pixi/core';
import type { Rectangle } from '@pixi/math';
import { Renderer } from '@pixi/core';
import type { RoundedRectangle } from '@pixi/math';
import { Shader } from '@pixi/core';
import { SHAPES } from '@pixi/math';
import { Texture } from '@pixi/core';

export declare const BATCH_POOL: Array<BatchPart>;

export declare class BatchDrawCall {
    texArray: BatchTextureArray;
    styleArray: BatchStyleArray;
    blend: BLEND_MODES;
    start: number;
    size: number;
    data: any;
    shader: Shader;
    TICK: number;
    settings: IGraphicsBatchSettings;
    constructor();
    clear(): void;
    begin(settings: IGraphicsBatchSettings, shader: Shader): void;
    check(shader: Shader): boolean;
    add(texture: Texture, matrix: Matrix, lineWidth: number, lineAlignment: number): number;
}

export declare class BatchPart {
    style: LineStyle | FillStyle;
    start: number;
    size: number;
    jointEnd: number;
    attribStart: number;
    attribSize: number;
    styleId: number;
    rgba: number;
    constructor();
    begin(style: LineStyle | FillStyle, startIndex: number, attribStart: number): void;
    end(endIndex: number, endAttrib: number): void;
    reset(): void;
}

export declare class BatchStyleArray {
    textureIds: number[];
    matrices: Matrix[];
    lines: number[];
    count: number;
    constructor();
    clear(): void;
    add(textureId: number, matrix: Matrix, lineWidth: number, lineAlignment: number, settings: IGraphicsBatchSettings): number;
}

export declare class BuildData {
    verts: Array<number>;
    joints: Array<number>;
    vertexSize: number;
    indexSize: number;
    closePointEps: number;
    clear(): void;
    destroy(): void;
}

export declare class CircleBuilder implements IShapeBuilder {
    path(graphicsData: SmoothGraphicsData, _target: BuildData): void;
    fill(graphicsData: SmoothGraphicsData, target: BuildData): void;
    line(graphicsData: SmoothGraphicsData, target: BuildData): void;
}

export declare class DashLineShader extends SmoothGraphicsShader {
    constructor(dashParams?: IDashParams);
}

export declare const DRAW_CALL_POOL: Array<BatchDrawCall>;

export declare const FILL_COMMANDS: Record<SHAPES, IShapeBuilder>;

export declare class FillStyle {
    constructor();
    color: number;
    alpha: number;
    texture: Texture;
    matrix: Matrix;
    matrixTex: Matrix;
    shader: Shader;
    visible: boolean;
    smooth: boolean;
    toJSON(): any;
    clone(): FillStyle;
    copyTo(obj: any): any;
    packLineWidth(): number;
    reset(): void;
    destroy(): void;
    getTextureMatrix(): Matrix;
}

export declare interface IDashParams {
    dash: number;
    gap: number;
}

export declare interface IFillStyleOptions {
    color?: number;
    alpha?: number;
    texture?: Texture;
    matrix?: Matrix;
    smooth?: boolean;
    shader?: Shader;
}

export declare interface IGraphicsBatchSettings {
    maxStyles: number;
    maxTextures: number;
}

export declare interface ILineStyleOptions extends IFillStyleOptions {
    width?: number;
    alignment?: number;
    scaleMode: LINE_SCALE_MODE;
    cap?: LINE_CAP;
    join?: LINE_JOIN;
    miterLimit?: number;
}

export declare interface ISettings {
    LINE_SCALE_MODE: string;
    SHADER_MAX_STYLES: number;
    SHADER_MAX_TEXTURES: number;
}

export declare type IShape = Circle | Ellipse | Polygon | Rectangle | RoundedRectangle;

export declare interface IShapeBuilder {
    path(graphicsData: SmoothGraphicsData, target: BuildData): void;
    line(graphicsData: SmoothGraphicsData, target: BuildData): void;
    fill(graphicsData: SmoothGraphicsData, target: BuildData): void;
}

export declare enum JOINT_TYPE {
    NONE = 0,
    FILL = 1,
    JOINT_BEVEL = 4,
    JOINT_MITER = 8,
    JOINT_ROUND = 12,
    JOINT_CAP_BUTT = 16,
    JOINT_CAP_SQUARE = 18,
    JOINT_CAP_ROUND = 20,
    FILL_EXPAND = 24,
    CAP_BUTT = 32,
    CAP_SQUARE = 64,
    CAP_ROUND = 96,
    CAP_BUTT2 = 128
}

export declare enum LINE_SCALE_MODE {
    NONE = "none",
    NORMAL = "normal"
}

export declare class LineStyle extends FillStyle {
    width: number;
    alignment: number;
    cap: LINE_CAP;
    join: LINE_JOIN;
    miterLimit: number;
    scaleMode: LINE_SCALE_MODE;
    clone(): LineStyle;
    copyTo(obj: any): LineStyle;
    packLineWidth(): number;
    reset(): void;
}

export declare function matrixEquals(th: Matrix, matrix: Matrix, eps?: number): boolean;

export declare class PolyBuilder implements IShapeBuilder {
    path(graphicsData: SmoothGraphicsData, buildData: BuildData): void;
    line(graphicsData: SmoothGraphicsData, buildData: BuildData): void;
    fill(graphicsData: SmoothGraphicsData, buildData: BuildData): void;
}

export declare class RectangleBuilder implements IShapeBuilder {
    path(graphicsData: SmoothGraphicsData, _target: BuildData): void;
    line(graphicsData: SmoothGraphicsData, target: BuildData): void;
    fill(graphicsData: SmoothGraphicsData, target: BuildData): void;
}

export declare class RoundedRectangleBuilder implements IShapeBuilder {
    path(graphicsData: SmoothGraphicsData, _target: BuildData): void;
    line(graphicsData: SmoothGraphicsData, target: BuildData): void;
    fill(graphicsData: SmoothGraphicsData, target: BuildData): void;
}

export declare class SegmentPacker {
    static vertsByJoint: Array<number>;
    strideFloats: number;
    updateBufferSize(jointStart: number, jointLen: number, triangles: number, target: BuildData): void;
    bufferPos: number;
    indexPos: number;
    bufFloat: Float32Array;
    bufUint: Uint32Array;
    indices: Uint16Array;
    buildData: BuildData;
    beginPack(buildData: BuildData, bufFloat: Float32Array, bufUint: Uint32Array, indices: Uint16Array, bufferPos?: number, indexPos?: number): void;
    endPack(): void;
    packInterleavedGeometry(jointStart: number, jointLen: number, triangles: number[], lineStyle: number, color: number): void;
}

export declare const settings: ISettings;

export declare class SmoothGraphics extends Container {
    static _TEMP_POINT: Point;
    shader: Shader;
    shaderSettings: IGraphicsBatchSettings;
    pluginName: string;
    currentPath: Polygon;
    protected batches: Array<any>;
    protected batchTint: number;
    protected batchDirty: number;
    protected vertexData: Float32Array;
    protected _fillStyle: FillStyle;
    protected _lineStyle: LineStyle;
    protected _matrix: Matrix;
    protected _holeMode: boolean;
    protected _transformID: number;
    protected _tint: number;
    private state;
    private _geometry;
    get geometry(): SmoothGraphicsGeometry;
    constructor(geometry?: SmoothGraphicsGeometry);
    clone(): SmoothGraphics;
    set blendMode(value: BLEND_MODES);
    get blendMode(): BLEND_MODES;
    get tint(): number;
    set tint(value: number);
    get fill(): FillStyle;
    get line(): LineStyle;
    lineStyle(width: number, color?: number, alpha?: number, alignment?: number, scaleMode?: LINE_SCALE_MODE): this;
    lineStyle(options?: ILineStyleOptions): this;
    lineTextureStyle(options: ILineStyleOptions): this;
    protected startPoly(): void;
    finishPoly(): void;
    moveTo(x: number, y: number): this;
    lineTo(x: number, y: number): this;
    protected _initCurve(x?: number, y?: number): void;
    quadraticCurveTo(cpX: number, cpY: number, toX: number, toY: number): this;
    bezierCurveTo(cpX: number, cpY: number, cpX2: number, cpY2: number, toX: number, toY: number): this;
    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): this;
    arc(cx: number, cy: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): this;
    beginFill(color?: number, alpha?: number, smooth?: boolean): this;
    beginTextureFill(options?: IFillStyleOptions): this;
    endFill(): this;
    drawRect(x: number, y: number, width: number, height: number): this;
    drawRoundedRect(x: number, y: number, width: number, height: number, radius: number): this;
    drawCircle(x: number, y: number, radius: number): this;
    drawEllipse(x: number, y: number, width: number, height: number): this;
    drawPolygon(...path: Array<number> | Array<Point>): this;
    drawPolygon(path: Array<number> | Array<Point> | Polygon): this;
    drawShape(shape: IShape_2): this;
    clear(): this;
    isFastRect(): boolean;
    protected _renderCanvas(renderer: any): void;
    protected _render(renderer: Renderer): void;
    protected _populateBatches(): void;
    protected _renderBatched(renderer: Renderer): void;
    protected _renderDirect(renderer: Renderer): void;
    protected _resolveDirectShader(_renderer: Renderer): Shader;
    protected _calculateBounds(): void;
    containsPoint(point: IPointData): boolean;
    protected calculateTints(): void;
    protected calculateVertices(): void;
    closePath(): this;
    setMatrix(matrix: Matrix): this;
    beginHole(): this;
    endHole(): this;
    destroy(options?: IDestroyOptions | boolean): void;
    drawStar(x: number, y: number, points: number, radius: number, innerRadius: number, rotation?: number): SmoothGraphics;
}

export declare class SmoothGraphicsData {
    shape: IShape_2;
    lineStyle: LineStyle;
    fillStyle: FillStyle;
    matrix: Matrix;
    type: SHAPES;
    holes: Array<SmoothGraphicsData>;
    closeStroke: boolean;
    points: number[];
    triangles: number[];
    attribStart: number;
    fillStart: number;
    fillLen: number;
    strokeStart: number;
    strokeLen: number;
    fillAA: boolean;
    constructor(shape: IShape_2, fillStyle?: FillStyle, lineStyle?: LineStyle, matrix?: Matrix);
    clearPath(): void;
    clearBuild(): void;
    clone(): SmoothGraphicsData;
    capType(): number;
    goodJointType(): number;
    jointType(): number;
    destroy(): void;
}

export declare class SmoothGraphicsGeometry extends Geometry {
    static BATCHABLE_SIZE: number;
    boundsPadding: number;
    indicesUint16: Uint16Array | Uint32Array;
    batchable: boolean;
    buildData: BuildData;
    get points(): number[];
    get closePointEps(): number;
    graphicsData: Array<SmoothGraphicsData>;
    drawCalls: Array<BatchDrawCall>;
    batchDirty: number;
    batches: Array<BatchPart>;
    packer: SegmentPacker;
    packSize: number;
    pack32index: boolean;
    strideFloats: number;
    protected dirty: number;
    protected cacheDirty: number;
    protected clearDirty: number;
    protected shapeBuildIndex: number;
    protected shapeBatchIndex: number;
    protected _bounds: Bounds;
    protected boundsDirty: number;
    _buffer: Buffer_2;
    _indexBuffer: Buffer_2;
    _bufferFloats: Float32Array;
    _bufferUint: Uint32Array;
    initAttributes(_static: boolean): void;
    constructor();
    checkInstancing(instanced: boolean, allow32Indices: boolean): void;
    get bounds(): Bounds;
    protected invalidate(): void;
    clear(): SmoothGraphicsGeometry;
    drawShape(shape: IShape, fillStyle?: FillStyle, lineStyle?: LineStyle, matrix?: Matrix): SmoothGraphicsGeometry;
    drawHole(shape: IShape, matrix?: Matrix): SmoothGraphicsGeometry;
    destroy(): void;
    containsPoint(point: IPointData): boolean;
    updatePoints(): void;
    updateBufferSize(): void;
    updateBuild(): void;
    updateBatches(shaderSettings?: IGraphicsBatchSettings): void;
    updatePack(): void;
    protected _compareStyles(styleA: FillStyle | LineStyle, styleB: FillStyle | LineStyle): boolean;
    protected validateBatching(): boolean;
    protected packBatches(): void;
    protected isBatchable(): boolean;
    protected buildDrawCalls(shaderSettings?: IGraphicsBatchSettings): void;
    protected processHoles(holes: Array<SmoothGraphicsData>): void;
    protected calculateBounds(): void;
    protected transformPoints(points: Array<number>, matrix: Matrix): void;
}

export declare class SmoothGraphicsProgram extends Program {
    settings: IGraphicsBatchSettings;
    constructor(settings: IGraphicsBatchSettings, vert?: string, frag?: string, _uniforms?: {});
}

export declare class SmoothGraphicsShader extends Shader {
    settings: IGraphicsBatchSettings;
    constructor(settings: IGraphicsBatchSettings, prog?: SmoothGraphicsProgram, uniforms?: {});
    static generateSampleSrc(maxTextures: number): string;
}

export declare class Star extends Polygon {
    constructor(x: number, y: number, points: number, radius: number, innerRadius?: number, rotation?: number);
}

export { }
