import React from 'react';
import PropTypes from 'prop-types';
interface ITweetEmbedProps {
    id: string;
    options?: object;
    placeholder?: string | React.ReactNode;
    protocol?: string;
    onTweetLoadSuccess?: (twitterWidgetElement: HTMLElement) => any;
    onTweetLoadError?: (err: Error) => any;
    className?: string;
}
interface ITweetEmbedState {
    isLoading: boolean;
}
declare class TweetEmbed extends React.Component<ITweetEmbedProps> {
    _div?: HTMLDivElement;
    static propTypes: {
        id: PropTypes.Requireable<string>;
        options: PropTypes.Requireable<object>;
        protocol: PropTypes.Requireable<string>;
        onTweetLoadSuccess: PropTypes.Requireable<(...args: any[]) => any>;
        onTweetLoadError: PropTypes.Requireable<(...args: any[]) => any>;
        className: PropTypes.Requireable<string>;
    };
    static defaultProps: {
        protocol: string;
        options: {};
        className: any;
    };
    state: ITweetEmbedState;
    loadTweetForProps(props: ITweetEmbedProps): void;
    componentDidMount(): void;
    shouldComponentUpdate(nextProps: ITweetEmbedProps, nextState: ITweetEmbedState): boolean;
    componentWillUpdate(nextProps: any, nextState: any): void;
    render(): JSX.Element;
}
export default TweetEmbed;
