import { DMPOP } from "./lsq-hash";
import { Block } from "./mldoc";
export declare const dmp: any;
/**
 * Check if there's any block with different content in the equal ops
 * Only check body (content). Do not check the op type
 * So please make sure the "original" (e.g., base equal or base delete op) is provided for comparison
 *
 * @param equalOps the equal ops to find the modified blocks in
 * @returns true if there is any modified block, return false if all blocks are the same or no equal ops
 */
export declare function checkModified(equalOps: DMPOP<Block>[]): boolean;
export declare function resolveOnEquals(equalOps: DMPOP<Block>[]): DMPOP<Block>[];
export declare function resolveOnInserts(insertOps: DMPOP<Block>[]): DMPOP<Block>[];
