export type RawBlock = {
    lines: string[];
    uuid?: string;
    level?: number;
};
export declare enum BlockSourceType {
    BLOCK_SOURCE_BASE = 0,
    BLOCK_SOURCE_BRANCH = 1
}
export type Block = {
    body: string;
    level?: number;
    uuid?: string;
    meta?: any;
    src: BlockSourceType;
    srcBranch: number;
};
export declare const UUIDRegex: RegExp;
export declare const UUID_PLACEHOLDER = "$PROPERTY!!DRAWER!!UUID$";
export declare class Parser {
    mldoc: any;
    config: string;
    format: string;
    byteEncoder: TextEncoder;
    byteDecoder: TextDecoder;
    constructor(mldoc: any, config?: string);
    parse(text: string): any;
    parseBlocks(text: string): RawBlock[];
    /**
     * Don't use! For demo only! Doesn't fully support all features in Logseq
     */
    private parseMarkdownBlocksAndIndents;
    /**
     *
     * @param text
     * @returns the line bodies and their indents, indexed by block, without EOL
     */
    parseBlocksAndIndents(text: string, fromBase: number): Block[];
}
/**
 * Don't use! For demo only! Doesn't fully support all features in Logseq
 */
export declare function getMarkdownBlockContent(block: Block): string;
