import { DMPOP } from "./diff";
import { Block } from "./mldoc";
export type DMPOPbyType<CarryT> = [
    DMPOP<CarryT>[],
    DMPOP<CarryT>[],
    DMPOP<CarryT>[]
];
export declare function binDMPOPsByType<CarryT>(DMPOPs: DMPOP<CarryT>[]): DMPOPbyType<CarryT>;
export declare class Merger {
    /**
     * Merger with max 65536 unique blocks support
     *
     * @param timeout optional the timeout for the diff algorithm (in sec, 1 sec by default)
     */
    constructor();
    /**
     *
     * @param baseText the base text (the text to be merged into, the anchor of block index)
     * @param branchTexts  the texts to be merged
     * @returns the DMP operations of the final merged text (to be applied on the base text)
     *   resolvedDiffs[blockPos][DMPOP id][DMPOPType, text]
     *   where blockPos is the block # in the baseText
     */
    mergeBlocks(baseBlocks: Block[], branchsBlocks: Block[][]): DMPOP<Block>[][];
}
