import { Block } from "./mldoc";
export declare enum DMPOPTypes {
    DIFF_DELETE = -1,
    DIFF_EQUAL = 0,
    DIFF_INSERT = 1
}
export type DMPOP<CarryT> = [
    DMPOPTypes,
    CarryT,
    string?
];
export declare class BlockHash {
    uniqueBlocks: Block[][];
    blockContentHash: Map<string, number>;
    blockUUIDHash: Map<string, number>;
    blockArrayLength: number;
    /**
     * Storing the block->char hash table
     * CharHash for one transact (merging), call the base version first to ensure best indent resolution
     * > 65536 blocks might break DMP (see WATCH OUT 1)
     * It's tolerable for our use case as LCS doesn't require the char to be unique
     */
    constructor();
    diff_blocksToUniqueId(allBlocks: Block[]): number[];
    /**
     * We have to keep indents of each block to ensure the best indent resolution
     * @param allBlocks the lines, in the index of block
     * @return Encoded string and all indents by block
    */
    diff_blocksToChars(allBlocks: Block[]): string;
    /**
     * The golden standard of indentation is the blockIndentsTar
     *
     * @returns the diff of the blocks, with the original block position as index
     *   [  // #1 block of the original text
     *      [
     *         [0, ...], // Keep the first block
     *      ],
     *      // #2 block of the original text
     *      [
     *         [-1, ...], // Delete the original second block
     *         [1, ...], // Insert a new line at the position
     *         [1, ...], // Insert another new line at the same position
     *      ],
     *      // #3 block of the original text
     *      [
     *        [0, ...], // Keep the third block
     *        [1, ...], // Insert a new block at the same position
     *      ],
     * ]
     */
    diff_charsToBlocks(diffs: DMPOP<string[]>[], baseBlocks: Block[], newBlocks: Block[]): DMPOP<Block>[][];
}
