import { BlockHash, DMPOP, DMPOPTypes } from "./lsq-hash";
import { Block } from "./mldoc";
export declare class Differ {
    charHash: BlockHash;
    /**
     * Can be used for only one time (charHash is shared) with maximum 65536 unique blocks, or unexpected behavior may occur
     */
    constructor(timeout?: number);
    /**
     * The diff steps, in order of the block position in the base
     */
    diff_logseqMode(baseBlocks: Block[], tarBlocks: Block[]): DMPOP<Block>[][];
    /**
     * differentiate the baseInsert and newInsert, keep all the non-overlapping operations
     */
    diff_insert_ops(baseInsert: DMPOP<Block>[], newInsert: DMPOP<Block>[]): DMPOP<Block>[];
}
type Possibly<T> = T | undefined;
/**
 * Given the DMP operations from base -> tar in the order of the block position in the base
 * and the keys of the base blocks, return the mapped keys of the tar blocks
 */
export declare function attach_uuids(diffs: DMPOP<Block>[][], baseKeys: Possibly<string>[], defaultKey?: string): Possibly<string>[];
/**
 * Print the DMP operations into HTML format
 *
 * @param dmps the DMP operations to be printed
 */
export declare function visualizeAsHTML(dmpsByPos: DMPOP<Block>[][], baseKeys?: Possibly<string>[], tarKeys?: Possibly<string>[]): HTMLElement;
export type { DMPOP };
export { DMPOPTypes };
