# Logseq Diff & Merge:
Block level diff and merge for Logseq

## Progress:
- [x] Merge
- [x] Tests
- [x] Consider `id::`
- [x] Finalize language choice & rewrite - Typescript
- [x] Mldoc port in
- [x] Org-mode support - via Mldoc

## Usage:
- Refer to the demo at entry `src`. `yarn dev` to run it.
- Returning operations are indexed by the "original block position". For Diff, it's defined by the first (base) branch to diff; For Merge, it's defined by the base branch of the branches to merge.
  - The 0 index is reserved for the ops to be inserted before the first base block.
  - Ex. the following case would generate an empty `[]` at 0 index:
    base:
    ```
    ## hello
     - world
      - nice
       - nice
       - bingo
       - world
    ```
    branch:
    ```
    ## Halooooo
     - world
      - nice
       - nice
       - bingo
       - world
    ```
    result (notice the empty array at 0 index):
    ```
    Array(7) [ [], (2) […], (1) […], (1) […], (1) […], (1) […], (1) […] ]
    ```
    Reason: no insertion is needed before the first base block.  
- The op (DELETE/EQUAL/INSERT) represents the one-to-one correspondence between blocks before and after diff-merge. Equal doesn't mean equal in content, it means that the block is the same block as it was before (e.g., same block UUID)

## Strategy:
- Resolve inner block conflict by line if block are shipped with uuid (e.g., `id::` in Logseq Markdown)
- Do not execute delete operation if there is any "modified" equal block in the same position from other branches. This is to avoid deleting a block that is modified by other branches.

## Dev:
- Experiments: `yarn dev`
- Build dist: `yarn build`
- Publish to NPM: `yarn publish`
