import { WebPlugin } from '@capacitor/core';
import type { FileSyncPlugin } from './definitions';
export declare class FileSyncWeb extends WebPlugin implements FileSyncPlugin {
    fetchRemoteFiles(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
        token: string;
    }): Promise<void>;
    cancelAllRequests(_options: unknown): Promise<void>;
    keygen(): Promise<{
        secretKey: string;
        publicKey: string;
    }>;
    setEnv(_options: {
        graphUUID: string;
        env: string;
        secretKey: string;
        publicKey: string;
    }): Promise<void>;
    encryptFnames(_options: {
        graphUUID: string;
        filePaths: string[];
    }): Promise<{
        value: string[];
    }>;
    decryptFnames(_options: {
        graphUUID: string;
        filePaths: string[];
    }): Promise<{
        value: string[];
    }>;
    getLocalFilesMeta(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
    }): Promise<{
        result: any[];
    }>;
    getLocalAllFilesMeta(_options: {
        graphUUID: string;
        basePath: string;
    }): Promise<{
        result: any[];
    }>;
    deleteLocalFiles(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
    }): Promise<void>;
    updateLocalFiles(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
        token: string;
    }): Promise<void>;
    updateLocalVersionFiles(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
        token: string;
    }): Promise<void>;
    deleteRemoteFiles(_options: {
        graphUUID: string;
        filePaths: string[];
        token: string;
        txid: number;
    }): Promise<{
        txid: number;
    }>;
    updateRemoteFiles(_options: {
        graphUUID: string;
        basePath: string;
        filePaths: string[];
        token: string;
        txid: number;
    }): Promise<{
        txid: number;
    }>;
    encryptWithPassphrase(_options: {
        passphrase: string;
        content: string;
    }): Promise<{
        data: string;
    }>;
    decryptWithPassphrase(_options: {
        passphrase: string;
        content: string;
    }): Promise<{
        data: string;
    }>;
}
