import type { RoughCanvas } from "roughjs/bin/canvas";
import { Drawable } from "roughjs/bin/core";
import { ExcalidrawTextElement, NonDeletedExcalidrawElement } from "../element/types";
import { AppClassProperties, InteractiveCanvasAppState, StaticCanvasAppState } from "../types";
export type StaticCanvasRenderConfig = {
    imageCache: AppClassProperties["imageCache"];
    renderGrid: boolean;
    /** when exporting the behavior is slightly different (e.g. we can't use
     CSS filters), and we disable render optimizations for best output */
    isExporting: boolean;
};
export type InteractiveCanvasRenderConfig = {
    remoteSelectedElementIds: {
        [elementId: string]: string[];
    };
    remotePointerViewportCoords: {
        [id: string]: {
            x: number;
            y: number;
        };
    };
    remotePointerUserStates: {
        [id: string]: string;
    };
    remotePointerUsernames: {
        [id: string]: string;
    };
    remotePointerButton?: {
        [id: string]: string | undefined;
    };
    selectionColor?: string;
    renderScrollbars?: boolean;
};
export type RenderInteractiveSceneCallback = {
    atLeastOneVisibleElement: boolean;
    elements: readonly NonDeletedExcalidrawElement[];
    scrollBars?: ScrollBars;
};
export type StaticSceneRenderConfig = {
    canvas: HTMLCanvasElement;
    rc: RoughCanvas;
    elements: readonly NonDeletedExcalidrawElement[];
    visibleElements: readonly NonDeletedExcalidrawElement[];
    scale: number;
    appState: StaticCanvasAppState;
    renderConfig: StaticCanvasRenderConfig;
};
export type InteractiveSceneRenderConfig = {
    canvas: HTMLCanvasElement | null;
    elements: readonly NonDeletedExcalidrawElement[];
    visibleElements: readonly NonDeletedExcalidrawElement[];
    selectedElements: readonly NonDeletedExcalidrawElement[];
    scale: number;
    appState: InteractiveCanvasAppState;
    renderConfig: InteractiveCanvasRenderConfig;
    callback: (data: RenderInteractiveSceneCallback) => void;
};
export type SceneScroll = {
    scrollX: number;
    scrollY: number;
};
export interface Scene {
    elements: ExcalidrawTextElement[];
}
export type ExportType = "png" | "clipboard" | "clipboard-svg" | "backend" | "svg";
export type ScrollBars = {
    horizontal: {
        x: number;
        y: number;
        width: number;
        height: number;
    } | null;
    vertical: {
        x: number;
        y: number;
        width: number;
        height: number;
    } | null;
};
export type ElementShape = Drawable | Drawable[] | null;
export type ElementShapes = {
    rectangle: Drawable;
    ellipse: Drawable;
    diamond: Drawable;
    embeddable: Drawable;
    freedraw: Drawable | null;
    arrow: Drawable[];
    line: Drawable[];
    text: null;
    image: null;
    frame: null;
};
