'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@capacitor/core');

exports.ActionSheetButtonStyle = void 0;
(function (ActionSheetButtonStyle) {
    /**
     * Default style of the option.
     *
     * @since 1.0.0
     */
    ActionSheetButtonStyle["Default"] = "DEFAULT";
    /**
     * Style to use on destructive options.
     *
     * @since 1.0.0
     */
    ActionSheetButtonStyle["Destructive"] = "DESTRUCTIVE";
    /**
     * Style to use on the option that cancels the Action Sheet.
     * If used, should be on the latest availabe option.
     *
     * @since 1.0.0
     */
    ActionSheetButtonStyle["Cancel"] = "CANCEL";
})(exports.ActionSheetButtonStyle || (exports.ActionSheetButtonStyle = {}));
/**
 * @deprecated Use `ActionSheetButtonStyle`.
 * @since 1.0.0
 */
const ActionSheetOptionStyle = exports.ActionSheetButtonStyle;

const ActionSheet = core.registerPlugin('ActionSheet', {
    web: () => Promise.resolve().then(function () { return web; }).then(m => new m.ActionSheetWeb()),
});

class ActionSheetWeb extends core.WebPlugin {
    async showActions(options) {
        return new Promise((resolve, _reject) => {
            let actionSheet = document.querySelector('pwa-action-sheet');
            if (!actionSheet) {
                actionSheet = document.createElement('pwa-action-sheet');
                document.body.appendChild(actionSheet);
            }
            actionSheet.header = options.title;
            actionSheet.cancelable = false;
            actionSheet.options = options.options;
            actionSheet.addEventListener('onSelection', async (e) => {
                const selection = e.detail;
                resolve({
                    index: selection,
                });
            });
        });
    }
}

var web = /*#__PURE__*/Object.freeze({
    __proto__: null,
    ActionSheetWeb: ActionSheetWeb
});

exports.ActionSheet = ActionSheet;
exports.ActionSheetOptionStyle = ActionSheetOptionStyle;
//# sourceMappingURL=plugin.cjs.js.map
