"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.analyzePage = exports.normalizeContext = void 0;
/**
 * Get running context
 * @param Array include
 * @param Array exclude
 * @returns SerialContextObject
 */
var normalizeContext = function (includes, excludes) {
    var _a;
    var base = {
        exclude: []
    };
    if (excludes.length && Array.isArray(base.exclude)) {
        (_a = base.exclude).push.apply(_a, excludes);
    }
    if (includes.length) {
        base.include = includes;
    }
    return base;
};
exports.normalizeContext = normalizeContext;
/**
 * Analyze the page.
 * @param AnalyzePageParams analyzeContext
 * @returns Promise<AnalyzePageResponse>
 */
var analyzePage = function (_a) {
    var context = _a.context, options = _a.options;
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    var axeCore = window.axe;
    // Run axe-core
    return axeCore
        .run(context || document, options || {})
        .then(function (results) {
        return { error: null, results: results };
    })
        .catch(function (err) {
        return { error: err.message, results: null };
    });
};
exports.analyzePage = analyzePage;
//# sourceMappingURL=utils.js.map