"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert_1 = __importDefault(require("assert"));
var axe_core_1 = require("axe-core");
var utils_1 = require("./utils");
var browser_1 = require("./browser");
var AxePartialRunner_1 = __importDefault(require("./AxePartialRunner"));
var AxeBuilder = /** @class */ (function () {
    function AxeBuilder(_a) {
        var page = _a.page, axeSource = _a.axeSource;
        this.legacyMode = false;
        this.page = page;
        this.includes = [];
        this.excludes = [];
        this.option = {};
        this.source = axeSource || axe_core_1.source;
    }
    /**
     * Selector to include in analysis.
     * This may be called any number of times.
     * @param String selector
     * @returns this
     */
    AxeBuilder.prototype.include = function (selector) {
        selector = Array.isArray(selector) ? selector : [selector];
        this.includes.push(selector);
        return this;
    };
    /**
     * Selector to exclude in analysis.
     * This may be called any number of times.
     * @param String selector
     * @returns this
     */
    AxeBuilder.prototype.exclude = function (selector) {
        selector = Array.isArray(selector) ? selector : [selector];
        this.excludes.push(selector);
        return this;
    };
    /**
     * Set options to be passed into axe-core
     * @param RunOptions options
     * @returns AxeBuilder
     */
    AxeBuilder.prototype.options = function (options) {
        this.option = options;
        return this;
    };
    /**
     * Limit analysis to only the specified rules.
     * Cannot be used with `AxeBuilder#withTags`
     * @param String|Array rules
     * @returns this
     */
    AxeBuilder.prototype.withRules = function (rules) {
        rules = Array.isArray(rules) ? rules : [rules];
        /* istanbul ignore next */
        this.option = this.option || {};
        this.option.runOnly = {
            type: 'rule',
            values: rules
        };
        return this;
    };
    /**
     * Limit analysis to only specified tags.
     * Cannot be used with `AxeBuilder#withRules`
     * @param String|Array tags
     * @returns this
     */
    AxeBuilder.prototype.withTags = function (tags) {
        tags = Array.isArray(tags) ? tags : [tags];
        /* istanbul ignore next */
        this.option = this.option || {};
        this.option.runOnly = {
            type: 'tag',
            values: tags
        };
        return this;
    };
    /**
     * Set the list of rules to skip when running an analysis.
     * @param String|Array rules
     * @returns this
     */
    AxeBuilder.prototype.disableRules = function (rules) {
        rules = Array.isArray(rules) ? rules : [rules];
        /* istanbul ignore next */
        this.option = this.option || {};
        this.option.rules = {};
        for (var _i = 0, rules_1 = rules; _i < rules_1.length; _i++) {
            var rule = rules_1[_i];
            this.option.rules[rule] = { enabled: false };
        }
        return this;
    };
    /**
     * Use frameMessenger with <same_origin_only>
     *
     * This disables use of axe.runPartial() which is called in each frame, and
     * axe.finishRun() which is called in a blank page. This uses axe.run() instead,
     * but with the restriction that cross-origin frames will not be tested.
     */
    AxeBuilder.prototype.setLegacyMode = function (legacyMode) {
        if (legacyMode === void 0) { legacyMode = true; }
        this.legacyMode = legacyMode;
        return this;
    };
    /**
     * Perform analysis and retrieve results. *Does not chain.*
     * @return Promise<Result | Error>
     */
    AxeBuilder.prototype.analyze = function () {
        return __awaiter(this, void 0, void 0, function () {
            var context, _a, page, options, runPartialDefined, results, partialResults, partials, error_1;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        context = (0, utils_1.normalizeContext)(this.includes, this.excludes);
                        _a = this, page = _a.page, options = _a.option;
                        page.evaluate(this.script());
                        return [4 /*yield*/, page.evaluate('typeof window.axe.runPartial === "function"')];
                    case 1:
                        runPartialDefined = _b.sent();
                        if (!(!runPartialDefined || this.legacyMode)) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.runLegacy(context)];
                    case 2:
                        results = _b.sent();
                        return [2 /*return*/, results];
                    case 3: return [4 /*yield*/, this.runPartialRecursive(page.mainFrame(), context)];
                    case 4:
                        partialResults = _b.sent();
                        return [4 /*yield*/, partialResults.getPartials()];
                    case 5:
                        partials = _b.sent();
                        _b.label = 6;
                    case 6:
                        _b.trys.push([6, 8, , 9]);
                        return [4 /*yield*/, this.finishRun(partials)];
                    case 7: return [2 /*return*/, _b.sent()];
                    case 8:
                        error_1 = _b.sent();
                        throw new Error("".concat(error_1.message, "\n Please check out https://github.com/dequelabs/axe-core-npm/blob/develop/packages/playwright/error-handling.md"));
                    case 9: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Injects `axe-core` into all frames.
     * @param Page - playwright page object
     * @returns Promise<void>
     */
    AxeBuilder.prototype.inject = function (frames) {
        return __awaiter(this, void 0, void 0, function () {
            var _i, frames_1, iframe;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        _i = 0, frames_1 = frames;
                        _a.label = 1;
                    case 1:
                        if (!(_i < frames_1.length)) return [3 /*break*/, 4];
                        iframe = frames_1[_i];
                        return [4 /*yield*/, iframe.evaluate(this.script())];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        _i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Get axe-core source and configurations
     * @returns String
     */
    AxeBuilder.prototype.script = function () {
        return "\n      ".concat(this.source, "\n      axe.configure({\n        ").concat(this.legacyMode ? '' : 'allowedOrigins: ["<unsafe_all_origins>"],', "\n        branding: { application: 'playwright' }\n      })\n    ");
    };
    AxeBuilder.prototype.runLegacy = function (context) {
        return __awaiter(this, void 0, void 0, function () {
            var frames, axeResults;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        frames = this.page.frames();
                        return [4 /*yield*/, this.inject(frames)];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.page.evaluate(utils_1.analyzePage, {
                                context: context,
                                options: this.option
                            })];
                    case 2:
                        axeResults = _a.sent();
                        if (axeResults.error) {
                            throw new Error(axeResults.error);
                        }
                        return [2 /*return*/, axeResults.results];
                }
            });
        });
    };
    /**
     * Inject `axe-core` into each frame and run `axe.runPartial`.
     * Because we need to inject axe into all frames all at once
     * (to avoid any potential problems with the DOM becoming out-of-sync)
     * but also need to not process results for any child frames if the parent
     * frame throws an error (requirements of the data structure for `axe.finishRun`),
     *  we have to return a deeply nested array of Promises and then flatten
     * the array once all Promises have finished, throwing out any nested Promises
     * if the parent Promise is not fulfilled.
     * @param frame - playwright frame object
     * @param context - axe-core context object
     * @returns Promise<AxePartialRunner>
     */
    AxeBuilder.prototype.runPartialRecursive = function (frame, context) {
        return __awaiter(this, void 0, void 0, function () {
            var frameContexts, partialPromise, initiator, axePartialRunner, _i, frameContexts_1, _a, frameSelector, frameContext, childResults, iframeHandle, iframeElement, childFrame, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0: return [4 /*yield*/, frame.evaluate(browser_1.axeGetFrameContexts, {
                            context: context
                        })];
                    case 1:
                        frameContexts = _c.sent();
                        partialPromise = frame.evaluate(browser_1.axeRunPartial, {
                            context: context,
                            options: this.option
                        });
                        initiator = frame === this.page.mainFrame();
                        axePartialRunner = new AxePartialRunner_1.default(partialPromise, initiator);
                        _i = 0, frameContexts_1 = frameContexts;
                        _c.label = 2;
                    case 2:
                        if (!(_i < frameContexts_1.length)) return [3 /*break*/, 12];
                        _a = frameContexts_1[_i], frameSelector = _a.frameSelector, frameContext = _a.frameContext;
                        childResults = null;
                        _c.label = 3;
                    case 3:
                        _c.trys.push([3, 9, , 10]);
                        return [4 /*yield*/, frame.evaluateHandle(browser_1.axeShadowSelect, {
                                frameSelector: frameSelector
                            })];
                    case 4:
                        iframeHandle = _c.sent();
                        iframeElement = iframeHandle.asElement();
                        return [4 /*yield*/, iframeElement.contentFrame()];
                    case 5:
                        childFrame = _c.sent();
                        if (!childFrame) return [3 /*break*/, 8];
                        return [4 /*yield*/, this.inject([childFrame])];
                    case 6:
                        _c.sent();
                        return [4 /*yield*/, this.runPartialRecursive(childFrame, frameContext)];
                    case 7:
                        childResults = _c.sent();
                        _c.label = 8;
                    case 8: return [3 /*break*/, 10];
                    case 9:
                        _b = _c.sent();
                        return [3 /*break*/, 10];
                    case 10:
                        axePartialRunner.addChildResults(childResults);
                        _c.label = 11;
                    case 11:
                        _i++;
                        return [3 /*break*/, 2];
                    case 12: return [2 /*return*/, axePartialRunner];
                }
            });
        });
    };
    AxeBuilder.prototype.finishRun = function (partialResults) {
        return __awaiter(this, void 0, void 0, function () {
            var _a, page, options, context, blankPage;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, page = _a.page, options = _a.option;
                        context = page.context();
                        return [4 /*yield*/, context.newPage()];
                    case 1:
                        blankPage = _b.sent();
                        (0, assert_1.default)(blankPage, 'Please make sure that you have popup blockers disabled.');
                        blankPage.evaluate(this.script());
                        return [4 /*yield*/, blankPage
                                .evaluate(browser_1.axeFinishRun, {
                                partialResults: partialResults,
                                options: options
                            })
                                .finally(function () { return __awaiter(_this, void 0, void 0, function () {
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0: return [4 /*yield*/, blankPage.close()];
                                        case 1:
                                            _a.sent();
                                            return [2 /*return*/];
                                    }
                                });
                            }); })];
                    case 2: return [2 /*return*/, _b.sent()];
                }
            });
        });
    };
    return AxeBuilder;
}());
exports.default = AxeBuilder;
//# sourceMappingURL=index.js.map