import axe from 'axe-core';
/**
 * This class parallelizes the async calls to axe.runPartial.
 *
 * In this project, most async calls needs to block execution, such as
 * the axeGetFrameContext() and getChildFrame() and calls.
 *
 * Unlike those calls, axe.runPartial() calls must run in parallel, so that
 * frame tests don't wait for each other. This is necessary to minimize the time
 * between when axe-core finds a frame, and when it is tested.
 */
declare type GetPartialResultsResponse = Parameters<typeof axe.finishRun>[0];
export default class AxePartialRunner {
    private initiator;
    private partialPromise;
    private childRunners;
    constructor(partialPromise: Promise<axe.PartialResult>, initiator?: boolean);
    addChildResults(childResultRunner: AxePartialRunner | null): void;
    getPartials(): Promise<GetPartialResultsResponse>;
}
export declare const caught: <T>(p: Promise<T>) => Promise<T>;
export {};
