# Develop Logseq
## Requirements

- [Node.js](https://nodejs.org/en/download/) (See [build.yml](https://github.com/logseq/logseq/blob/master/.github/workflows/build.yml) for allowed version)  & [Yarn](https://classic.yarnpkg.com/en/docs/install/)
- [Java & Clojure](https://clojure.org/guides/getting_started). (If you run into `Execution error (FileNotFoundException) at java.io.FileInputStream/open0 (FileInputStream.java:-2). -M:cljs (No such file or directory)`, it means you have a wrong Clojure version installed. Please uninstall it and follow the instructions linked.)

## Clone project

This is a required step before doing any development or production builds.

```bash
git clone https://github.com/logseq/logseq
cd logseq
```

## Browser development

### Development

```bash
yarn
yarn watch
```

Then open the browser <http://localhost:3001>.

### REPL setup

#### VSCode + Calva
With ```yarn watch``` running, it should prints ``shadow-cljs - nREPL server started on port 8701``

You may connect to the nREPL server with:

``cmd + shift + p`` -> ``Calva: Connect to a Running REPL Server in the Project`` -> ``logseq`` -> ``shadow-cljs``->``:app`` ->``localhost:8701``

(change ``:app`` to ``:electron`` if you want to connect to the main thread of the Electron app)

Open a dev environment (Browser dev app on ``localhost:3000`` or Desktop dev app), then you can play REPL on the current editing file:

``cmd + shift + p`` -> ``Calva: Load/Evaluate Current File and its Requires/Dependencies``

### Production Build

```bash
yarn release
```

The released files will be at `static/` directory.

## Desktop app development

### Development

1. Install npm packages for building the desktop app

``` bash
yarn install
cd static
yarn install
cd ..
```

2. Compile to JavaScript and open the dev app

```bash
yarn watch
# Wait until watch reports `Build Completed.` for `:electron` and `:app`.
# Then, run the following command in a different shell.
# If you have opened desktop logseq, you should close it. Otherwise, this command will fail.
yarn dev-electron-app
```

Alternatively, run `bb dev:electron-start` to do this step with one command. To
download bb, see https://github.com/babashka/babashka#installation.

3. (Optional) Update dependencies if `resources/package.json` has changed since
the last time you used dev Logseq.

```bash
# pull new changes
git pull

cd static && yarn install && cd ..
```

Here `static/` is generated by `yarn watch` command.

### Production Build

Build a release:

```bash
yarn release-electron
```

The final released binaries or installers will be at `static/out/`.
