(ns logseq.shui.ui
  (:require [logseq.shui.util :as util]
            [logseq.shui.icon.v2 :as icon-v2]
            [logseq.shui.toaster.core :as toaster-core]
            [logseq.shui.select.core :as select-core]
            [logseq.shui.dialog.core :as dialog-core]
            [logseq.shui.form.core :as form-core]))

(def button (util/lsui-wrap "Button" {:static? false}))
(def link (util/lsui-wrap "Link"))
(def tabler-icon icon-v2/root)

(def alert (util/lsui-wrap "Alert"))
(def alert-title (util/lsui-wrap "AlertTitle"))
(def alert-description (util/lsui-wrap "AlertDescription"))
(def slider (util/lsui-wrap "Slider"))
(def badge (util/lsui-wrap "Badge"))
(def input (util/lsui-wrap "Input"))
(def textarea (util/lsui-wrap "Textarea"))
(def switch (util/lsui-wrap "Switch"))
(def checkbox (util/lsui-wrap "Checkbox"))
(def radio-group (util/lsui-wrap "RadioGroup"))
(def radio-group-item (util/lsui-wrap "RadioGroupItem"))
(def skeleton (util/lsui-wrap "Skeleton"))
(def calendar (util/lsui-wrap "Calendar"))
(def popover (util/lsui-wrap "Popover"))
(def popover-trigger (util/lsui-wrap "PopoverTrigger"))
(def popover-content (util/lsui-wrap "PopoverContent"))

(def tooltip (util/lsui-wrap "Tooltip"))
(def tooltip-trigger (util/lsui-wrap "TooltipTrigger"))
(def tooltip-content (util/lsui-wrap "TooltipContent"))
(def tooltip-provider (util/lsui-wrap "TooltipProvider"))

(def card (util/lsui-wrap "Card"))
(def card-header (util/lsui-wrap "CardHeader"))
(def card-title (util/lsui-wrap "CardTitle"))
(def card-description (util/lsui-wrap "CardDescription"))
(def card-content (util/lsui-wrap "CardContent"))
(def card-footer (util/lsui-wrap "CardFooter"))

(def form-provider form-core/form-provider)
(def form-item form-core/form-item)
(def form-label form-core/form-label)
(def form-description form-core/form-description)
(def form-message form-core/form-message)
(def form-field form-core/form-field)
(def form-control form-core/form-control)

(def select select-core/select)
(def select-group select-core/select-group)
(def select-value select-core/select-value)
(def select-trigger select-core/select-trigger)
(def select-content select-core/select-content)
(def select-label select-core/select-label)
(def select-item select-core/select-item)
(def select-separator select-core/select-separator)
(def select-scroll-up-button select-core/select-scroll-up-button)
(def select-scroll-down-button select-core/select-scroll-down-button)

(def dropdown-menu (util/lsui-wrap "DropdownMenu"))
(def dropdown-menu-trigger (util/lsui-wrap "DropdownMenuTrigger"))
(def dropdown-menu-content (util/lsui-wrap "DropdownMenuContent"))
(def dropdown-menu-group (util/lsui-wrap "DropdownMenuGroup"))
(def dropdown-menu-item (util/lsui-wrap "DropdownMenuItem"))
(def dropdown-menu-checkbox-item (util/lsui-wrap "DropdownMenuCheckboxItem"))
(def dropdown-menu-radio-group (util/lsui-wrap "DropdownMenuRadioGroup"))
(def dropdown-menu-radio-item (util/lsui-wrap "DropdownMenuRadioItem"))
(def dropdown-menu-label (util/lsui-wrap "DropdownMenuLabel"))
(def dropdown-menu-separator (util/lsui-wrap "DropdownMenuSeparator"))
(def dropdown-menu-shortcut (util/lsui-wrap "DropdownMenuShortcut"))
(def dropdown-menu-portal (util/lsui-wrap "DropdownMenuPortal"))
(def dropdown-menu-sub (util/lsui-wrap "DropdownMenuSub"))
(def dropdown-menu-sub-content (util/lsui-wrap "DropdownMenuSubContent"))
(def dropdown-menu-sub-trigger (util/lsui-wrap "DropdownMenuSubTrigger"))

(def context-menu (util/lsui-wrap "ContextMenu"))
(def context-menu-trigger (util/lsui-wrap "ContextMenuTrigger"))
(def context-menu-content (util/lsui-wrap "ContextMenuContent"))
(def context-menu-item (util/lsui-wrap "ContextMenuItem"))
(def context-menu-checkbox-item (util/lsui-wrap "ContextMenuCheckboxItem"))
(def context-menu-radio-item (util/lsui-wrap "ContextMenuRadioItem"))
(def context-menu-label (util/lsui-wrap "ContextMenuLabel"))
(def context-menu-separator (util/lsui-wrap "ContextMenuSeparator"))
(def context-menu-shortcut (util/lsui-wrap "ContextMenuShortcut"))
(def context-menu-group (util/lsui-wrap "ContextMenuGroup"))
(def context-menu-portal (util/lsui-wrap "ContextMenuPortal"))
(def context-menu-sub (util/lsui-wrap "ContextMenuSub"))
(def context-menu-sub-content (util/lsui-wrap "ContextMenuSubContent"))
(def context-menu-sub-trigger (util/lsui-wrap "ContextMenuSubTrigger"))
(def context-menu-radio-group (util/lsui-wrap "ContextMenuRadioGroup"))

(def dialog dialog-core/dialog)
(def dialog-portal dialog-core/dialog-portal)
(def dialog-overlay dialog-core/dialog-overlay)
(def dialog-close dialog-core/dialog-close)
(def dialog-trigger dialog-core/dialog-trigger)
(def dialog-content dialog-core/dialog-content)
(def dialog-header dialog-core/dialog-header)
(def dialog-footer dialog-core/dialog-footer)
(def dialog-title dialog-core/dialog-title)
(def dialog-description dialog-core/dialog-description)

(def toast! toaster-core/toast!)
(def toast-dismiss! toaster-core/dismiss!)
