<!-- logo -->
<p align="center">
    <a href="https://logseq.com" alt="Logseq Logo">
    <img src="https://user-images.githubusercontent.com/25513724/220608753-f33db466-af72-4611-b603-411440c15ed0.png?sanatize=true" height="173"/></a>
</p>

<h1 align="center"> Logseq </h1>

<h4 align="center">
    A privacy-first, open-source platform for knowledge management and collaboration
</h4>

<div align="center">
    <a href="https://logseq.com">Home Page</a> |
    <a href="https://blog.logseq.com/">Blog</a> |
    <a href="https://docs.logseq.com/">Documentation</a> |
    <a href="https://trello.com/b/8txSM12G/roadmap">Roadmap</a>
</div>
<br></br>

<p align="center">
    <a href="https://github.com/logseq/logseq/releases/latest/">
        <img src="https://img.shields.io/badge/Download_Logseq-100000?style=for-the-badge&logo=flatpak&logoColor=white&labelColor=002b36&color=85c8c8"
            alt="Download Logseq"/></a>
</p>

<!-- social badges -->
<p align="center">
    <a href="https://discuss.logseq.com">
        <img src="https://img.shields.io/badge/forum-Logseq-blue.svg?&color=%2385c8c8&logo=discourse&style=for-the-badge"
            alt="forum"></a>
    <a href="https://discord.gg/KpN4eHY">
        <img src="https://img.shields.io/discord/725182569297215569?color=%2385c8c8&label=Discord&logo=discord&style=for-the-badge"
            alt="chat on Discord"></a>
    <a href="https://twitter.com/intent/follow?screen_name=logseq">
        <img src="https://img.shields.io/badge/twitter-%40logseq-blue.svg?&color=%2385c8c8&logo=twitter&style=for-the-badge"
            alt="follow on Twitter"></a>
</p>

<!-- dev badges -->
<p align="center">
    <a href="https://github.com/logseq/logseq/graphs/contributors" alt="Contributors">
        <img src="https://img.shields.io/github/contributors/logseq/logseq?color=%2385c8c8&style=for-the-badge"/></a>
    <a href="#-backers" alt="Backers on Open Collective">
        <img src="https://img.shields.io/opencollective/backers/logseq?color=%2385c8c8&style=for-the-badge"/></a>
    <a href="#-sponsors" alt="Sponsors on Open Collective">
        <img src="https://img.shields.io/opencollective/sponsors/logseq?color=%2385c8c8&style=for-the-badge"/></a>
    <a href="https://github.com/logseq/logseq/blob/master/LICENSE.md" alt="Activity">
        <img src="https://img.shields.io/github/license/logseq/logseq?color=%2385c8c8&style=for-the-badge"/></a>
    <a href="https://github.com/logseq/logseq/releases">
        <img src="https://img.shields.io/github/v/release/logseq/logseq?color=%2385c8c8&style=for-the-badge"
            alt="latest release version"></a>
</p>

## Table of Contents

  * [<g-emoji class="g-emoji" alias="thinking" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f914.png">🤔</g-emoji> Why Logseq?](#-why-logseq)
  * [<g-emoji class="g-emoji" alias="eyes" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f440.png">👀</g-emoji> How can I use it?](#-how-can-i-use-it)
  * [<g-emoji class="g-emoji" alias="books" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f4da.png">📚</g-emoji> Learn more](#-learn-more)
  * [🫶 Support Logseq Development](#-support-logseq-development)
  * [<g-emoji class="g-emoji" alias="bulb" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f4a1.png">💡</g-emoji> Feature requests](#-feature-requests)
  * [<g-emoji class="g-emoji" alias="electric_plug" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f50c.png">🔌</g-emoji> Plugin API](#-plugin-api)
  * [<g-emoji class="g-emoji" alias="star2" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f31f.png">🌟</g-emoji> Contributing to Logseq](#-contributing-to-logseq)
    * [<g-emoji class="g-emoji" alias="hammer_and_wrench" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f6e0.png">🛠️</g-emoji> Setting Up a Development Environment](#️-setting-up-a-development-environment)
  * [<g-emoji class="g-emoji" alias="sparkles" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/2728.png">✨</g-emoji> Inspiration](#-inspiration)
* [<g-emoji class="g-emoji" alias="pray" fallback-src="https://github.githubassets.com/images/icons/emoji/unicode/1f64f.png">🙏</g-emoji> Thank You](#-thank-you)

## 🤔 Why Logseq?

[Logseq](https://logseq.com) is a **knowledge management** and **collaboration** platform. It focuses on **privacy**, **longevity**, and [**user control**](https://www.gnu.org/philosophy/free-sw.en.html). Logseq offers a range of **powerful tools** for **knowledge management**, **collaboration**, **PDF annotation**, and **task management** with support for multiple file formats, including **Markdown** and **Org-mode**, and **various features** for organizing and structuring your notes.

Logseq's **Whiteboard** feature lets you organize your knowledge and ideas using a spatial **canvas** with **shapes**, **drawings**, **website embeds**, and **connectors**. You can **visually group** and **link** your **notes** and external media (such as **videos** and **images**), enabling visual thinkers to compose, remix, **annotate**, and connect content from their knowledge base and emerging thoughts in a new way.

In addition to its core features, Logseq has a growing ecosystem of **plugins** and **themes** that enable a wide range of workflows and **customization** options. **Mobile apps** are also available, providing access to most of the features of the desktop application. Whether you're a student, a professional, or anyone who values a clear and organized approach to managing your ideas and notes, Logseq is an excellent choice for anyone looking to improve their productivity and streamline their workflow.

![logseq-demo](https://user-images.githubusercontent.com/25513724/221387376-4dc419c2-0d0a-460c-a920-2d211e78b456.gif)

<a href="https://github.com/logseq/logseq/releases/latest/">
        <img src="https://img.shields.io/badge/Download_Logseq-100000?style=for-the-badge&logo=flatpak&logoColor=white&labelColor=002b36&color=85c8c8"
            align="right"
            alt="Download Logseq"/></a>

## 👀 How can I use it?

To start using Logseq, follow these simple steps:

1. [Download](https://github.com/logseq/logseq/releases/latest) the latest version of Logseq
2. Install Logseq on your device and launch the application
3. Start writing ✍️

That's it! You can now enjoy the benefits of using Logseq to streamline your workflow, manage your projects, and stay on top of your goals. Have fun! 🎉

## 📚 Learn more

* Website: [logseq.com](https://logseq.com)
* Documentation: [docs.logseq.com](https://docs.logseq.com)
  * FAQ page: [Logseq Docs:  FAQ](https://docs.logseq.com/#/page/faq)
* Blog: [blog.logseq.com](https://blog.logseq.com)
  * Please visit our [About page](https://blog.logseq.com/about) for the latest updates.
* Logseq Hub: [hub.logseq.com](https://hub.logseq.com)
* Forum: [discuss.logseq.com](https://discuss.logseq.com) - Where we answer questions, discuss workflows, and share tips
  * FAQ forum section: [Logseq Forum: FAQ](https://discuss.logseq.com/c/faq/6)
* [Awesome Logseq](https://github.com/logseq/awesome-logseq) - Awesome Logseq extensions and resources created by the community <3
* Twitter: [@Logseq](https://twitter.com/logseq)
* Discord: [discord.gg/logseq](https://discord.gg/logseq)
  * [中文 Discord](https://discord.gg/xYqcrXWymg)

## 🫶 Support Logseq Development

If you find Logseq useful and want to help us keep the project growing, please consider supporting our contributors on [Open Collective](https://opencollective.com/logseq). Your support shows our contributors that their efforts are appreciated and motivates them to continue their excellent work. Every contribution, no matter how small, helps us keep improving Logseq.

## 💡 Feature requests

We value your input on improving Logseq and making it more useful for you. If you have any ideas or feature requests, please share them in the [Logseq Forum: Feature
Requests](https://discuss.logseq.com/new-topic?category=feature-requests) section.

Your feedback helps us understand our users' needs and prioritize the features that matter most to you. We appreciate your time and effort in sharing your thoughts with us.

We appreciate your support, and we look forward to hearing your ideas!

## 🔌 Plugin API

Logseq provides a plugin API that enables developers to create custom plugins and extend the functionality of Logseq. The plugin API documentation is available at [plugins-doc.logseq.com](https://plugins-doc.logseq.com/), where you can find everything needed to get started with plugin development.

We value your feedback and suggestions on how to improve our documentation. Please do not hesitate to contact us with any comments or questions. Your input helps us to provide a better experience for our users and developers.

Thank you for using Logseq, and we look forward to seeing what you create with our plugin API!

## 🌟 Contributing to Logseq

To start contributing to Logseq, please read [CONTRIBUTING.md](CONTRIBUTING.md).
There are ways to contribute [with code](https://github.com/logseq/logseq/blob/master/CONTRIBUTING.md#code-contributions) and [without code](https://github.com/logseq/logseq/blob/master/CONTRIBUTING.md#-how-can-i-help). We welcome all
contributions, big or small, and we appreciate your time and effort in helping
us improve Logseq. We look forward to your contributions 🚀

### 🛠️ Setting Up a Development Environment

If you want to set up a development environment for the Logseq web or desktop app, please refer to the [Develop Logseq](docs/develop-logseq.md) guide for macOS/Linux users and the [Develop Logseq on Windows](docs/develop-logseq-on-windows.md) guide for Windows users.

In addition to these guides, you can also find other helpful resources in the [docs/](docs/) folder, such as the [Guide for Contributing to Translations](docs/contributing-to-translations.md), the [Docker Web App Guide](docs/docker-web-app-guide.md) and the [mobile development guide](docs/develop-logseq-on-mobile.md)

## ✨ Inspiration

Logseq is inspired by several unique tools and projects, including [Roam Research](https://roamresearch.com/), [Org Mode](https://orgmode.org/), [TiddlyWiki](https://tiddlywiki.com/), [Workflowy](https://workflowy.com/), and [Cuekeeper](https://github.com/talex5/cuekeeper).

We owe a huge debt of gratitude to the developers and creators of these projects, and we hope that Logseq can continue to build on their innovative ideas and make them accessible to a broader audience.

Thank you to all those who inspire us, and we look forward to seeing what the Logseq community will create with this tool!

Logseq is also made possible by the following projects:

* [Clojure & ClojureScript](https://clojure.org/) - A dynamic, functional, general-purpose programming language
* [DataScript](https://github.com/tonsky/datascript) - An immutable database and Datalog query-engine for Clojure,
ClojureScript and JS
* [OCaml](https://ocaml.org/) & [Angstrom](https://github.com/inhabitedtype/angstrom), for the document parser [mldoc](https://github.com/logseq/mldoc)
* [isomorphic-git](https://isomorphic-git.org/) - A pure JavaScript implementation of Git for NodeJS and web browsers
* [SCI](https://github.com/borkdude/sci) - A Small Clojure Interpreter

# 🙏 Thank You

We want to express our sincere gratitude to our [Open Collective](https://opencollective.com/logseq) **sponsors**, **backers**, and **contributors**. Your support and contributions allow us to continue developing and improving Logseq. Thank you for being a part of our community and helping us make Logseq the best it can be!

## 💎 Sponsors

<p align="center">
    <a href="https://opencollective.com/logseq#sponsor"> [Become a sponsor]</a>
</p>
<p align="center">
    <a href="https://opencollective.com/logseq" alt="Sponsors on Open Collective">
        <img src="https://opencollective.com/logseq/tiers/sponsors.svg?avatarHeight=42&width=600"/></a>
</p>

## 🌟 Contributors

<p align="center">
    <a href="https://github.com/logseq/logseq/graphs/contributors">
        <img src="https://contrib.rocks/image?repo=logseq/logseq&max=300&columns=14" width="600"/></a>
</p>

## 🫶 Backers

<p align="center">
    <a href="https://opencollective.com/logseq" alt="Backers on Open Collective">
        <img src="https://opencollective.com/logseq/tiers/backers.svg?avatarHeight=24&width=600"/></a>
</p>

<!-- JetBrains Logo -->
<p align="center">
    <a href="https://jetbrains.com" alt="JetBrains">
        <img src="docs/assets/jetbrains.svg"/></a>
</p>

<!-- ProductHunt Review Button -->
<p align="center">
    <a href="https://www.producthunt.com/posts/logseq?utm_source=badge-review&utm_medium=badge&utm_souce=badge-logseq#discussion-body"
    target="_blank"><img
        src="https://api.producthunt.com/widgets/embed-image/v1/review.svg?post_id=298158&theme=dark"
        align="center"
        alt="Logseq - Your joyful, private digital garden | Product Hunt" style="width: 250px; height: 54px;"
        width="250" height="54"/></a>
</p>
