["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/react-transition-group/cjs/Transition.js"],"~:js","shadow$provide[253]=function(ra,X,Ra,P){function w(y){return y&&y.__esModule?y:{default:y}}function Z(y,x){y.prototype=Object.create(x.prototype);y.prototype.constructor=y;y.__proto__=x}function B(){}P.__esModule=!0;P.default=P.EXITING=P.ENTERED=P.ENTERING=P.EXITED=P.UNMOUNTED=void 0;w(X(245));var p=w(X(0)),c=w(X(1)),u=w(X(250));X(251);var A=w(X(252));P.UNMOUNTED=\"unmounted\";P.EXITED=\"exited\";P.ENTERING=\"entering\";P.ENTERED=\"entered\";P.EXITING=\"exiting\";ra=function(y){function x(g,h){var b=y.call(this,\ng,h)||this;h=h&&!h.isMounting?g.enter:g.appear;b.appearStatus=null;g.in?h?(g=\"exited\",b.appearStatus=\"entering\"):g=\"entered\":g=g.unmountOnExit||g.mountOnEnter?\"unmounted\":\"exited\";b.state={status:g};b.nextCallback=null;return b}Z(x,y);x.getDerivedStateFromProps=function(g,h){return g.in&&\"unmounted\"===h.status?{status:\"exited\"}:null};var Q=x.prototype;Q.componentDidMount=function(){this.updateStatus(!0,this.appearStatus)};Q.componentDidUpdate=function(g){var h=null;if(g!==this.props)if(g=this.state.status,\nthis.props.in)\"entering\"!==g&&\"entered\"!==g&&(h=\"entering\");else if(\"entering\"===g||\"entered\"===g)h=\"exiting\";this.updateStatus(!1,h)};Q.componentWillUnmount=function(){this.cancelNextCallback()};Q.getTimeouts=function(){var g=this.props.timeout,h,b;var l=h=b=g;null!=g&&\"number\"!==typeof g&&(l=g.exit,h=g.enter,b=void 0!==g.appear?g.appear:h);return{exit:l,enter:h,appear:b}};Q.updateStatus=function(g,h){void 0===g&&(g=!1);if(null!==h){this.cancelNextCallback();var b=c.default.findDOMNode(this);\"entering\"===\nh?this.performEnter(b,g):this.performExit(b)}else this.props.unmountOnExit&&\"exited\"===this.state.status&&this.setState({status:\"unmounted\"})};Q.performEnter=function(g,h){var b=this,l=this.props.enter,k=this.context?this.context.isMounting:h,r=this.getTimeouts(),D=k?r.appear:r.enter;!h&&!l||u.default.disabled?this.safeSetState({status:\"entered\"},function(){b.props.onEntered(g)}):(this.props.onEnter(g,k),this.safeSetState({status:\"entering\"},function(){b.props.onEntering(g,k);b.onTransitionEnd(g,\nD,function(){b.safeSetState({status:\"entered\"},function(){b.props.onEntered(g,k)})})}))};Q.performExit=function(g){var h=this,b=this.props.exit,l=this.getTimeouts();!b||u.default.disabled?this.safeSetState({status:\"exited\"},function(){h.props.onExited(g)}):(this.props.onExit(g),this.safeSetState({status:\"exiting\"},function(){h.props.onExiting(g);h.onTransitionEnd(g,l.exit,function(){h.safeSetState({status:\"exited\"},function(){h.props.onExited(g)})})}))};Q.cancelNextCallback=function(){null!==this.nextCallback&&\n(this.nextCallback.cancel(),this.nextCallback=null)};Q.safeSetState=function(g,h){h=this.setNextCallback(h);this.setState(g,h)};Q.setNextCallback=function(g){var h=this,b=!0;this.nextCallback=function(l){b&&(b=!1,h.nextCallback=null,g(l))};this.nextCallback.cancel=function(){b=!1};return this.nextCallback};Q.onTransitionEnd=function(g,h,b){this.setNextCallback(b);b=null==h&&!this.props.addEndListener;!g||b?setTimeout(this.nextCallback,0):(this.props.addEndListener&&this.props.addEndListener(g,this.nextCallback),\nnull!=h&&setTimeout(this.nextCallback,h))};Q.render=function(){var g=this.state.status;if(\"unmounted\"===g)return null;var h=this.props,b=h.children;var l=[\"children\"];if(null==h)h={};else{var k={},r=Object.keys(h),D;for(D=0;D<r.length;D++){var v=r[D];0<=l.indexOf(v)||(k[v]=h[v])}h=k}delete h.in;delete h.mountOnEnter;delete h.unmountOnExit;delete h.appear;delete h.enter;delete h.exit;delete h.timeout;delete h.addEndListener;delete h.onEnter;delete h.onEntering;delete h.onEntered;delete h.onExit;delete h.onExiting;\ndelete h.onExited;if(\"function\"===typeof b)return p.default.createElement(A.default.Provider,{value:null},b(g,h));g=p.default.Children.only(b);return p.default.createElement(A.default.Provider,{value:null},p.default.cloneElement(g,h))};return x}(p.default.Component);ra.contextType=A.default;ra.propTypes={};ra.defaultProps={in:!1,mountOnEnter:!1,unmountOnExit:!1,appear:!1,enter:!0,exit:!0,onEnter:B,onEntering:B,onEntered:B,onExit:B,onExiting:B,onExited:B};ra.UNMOUNTED=0;ra.EXITED=1;ra.ENTERING=2;ra.ENTERED=\n3;ra.EXITING=4;P.default=ra}","~:source","shadow$provide[253] = function(global,require,module,exports) {\n\"use strict\";\n\nexports.__esModule = true;\nexports.default = exports.EXITING = exports.ENTERED = exports.ENTERING = exports.EXITED = exports.UNMOUNTED = void 0;\n\nvar _propTypes = _interopRequireDefault(require(\"prop-types\"));\n\nvar _react = _interopRequireDefault(require(\"react\"));\n\nvar _reactDom = _interopRequireDefault(require(\"react-dom\"));\n\nvar _config = _interopRequireDefault(require(\"./config\"));\n\nvar _PropTypes = require(\"./utils/PropTypes\");\n\nvar _TransitionGroupContext = _interopRequireDefault(require(\"./TransitionGroupContext\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }\n\nvar UNMOUNTED = 'unmounted';\nexports.UNMOUNTED = UNMOUNTED;\nvar EXITED = 'exited';\nexports.EXITED = EXITED;\nvar ENTERING = 'entering';\nexports.ENTERING = ENTERING;\nvar ENTERED = 'entered';\nexports.ENTERED = ENTERED;\nvar EXITING = 'exiting';\n/**\n * The Transition component lets you describe a transition from one component\n * state to another _over time_ with a simple declarative API. Most commonly\n * it's used to animate the mounting and unmounting of a component, but can also\n * be used to describe in-place transition states as well.\n *\n * ---\n *\n * **Note**: `Transition` is a platform-agnostic base component. If you're using\n * transitions in CSS, you'll probably want to use\n * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)\n * instead. It inherits all the features of `Transition`, but contains\n * additional features necessary to play nice with CSS transitions (hence the\n * name of the component).\n *\n * ---\n *\n * By default the `Transition` component does not alter the behavior of the\n * component it renders, it only tracks \"enter\" and \"exit\" states for the\n * components. It's up to you to give meaning and effect to those states. For\n * example we can add styles to a component when it enters or exits:\n *\n * ```jsx\n * import { Transition } from 'react-transition-group';\n *\n * const duration = 300;\n *\n * const defaultStyle = {\n *   transition: `opacity ${duration}ms ease-in-out`,\n *   opacity: 0,\n * }\n *\n * const transitionStyles = {\n *   entering: { opacity: 1 },\n *   entered:  { opacity: 1 },\n *   exiting:  { opacity: 0 },\n *   exited:  { opacity: 0 },\n * };\n *\n * const Fade = ({ in: inProp }) => (\n *   <Transition in={inProp} timeout={duration}>\n *     {state => (\n *       <div style={{\n *         ...defaultStyle,\n *         ...transitionStyles[state]\n *       }}>\n *         I'm a fade Transition!\n *       </div>\n *     )}\n *   </Transition>\n * );\n * ```\n *\n * There are 4 main states a Transition can be in:\n *  - `'entering'`\n *  - `'entered'`\n *  - `'exiting'`\n *  - `'exited'`\n *\n * Transition state is toggled via the `in` prop. When `true` the component\n * begins the \"Enter\" stage. During this stage, the component will shift from\n * its current transition state, to `'entering'` for the duration of the\n * transition and then to the `'entered'` stage once it's complete. Let's take\n * the following example (we'll use the\n * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):\n *\n * ```jsx\n * function App() {\n *   const [inProp, setInProp] = useState(false);\n *   return (\n *     <div>\n *       <Transition in={inProp} timeout={500}>\n *         {state => (\n *           // ...\n *         )}\n *       </Transition>\n *       <button onClick={() => setInProp(true)}>\n *         Click to Enter\n *       </button>\n *     </div>\n *   );\n * }\n * ```\n *\n * When the button is clicked the component will shift to the `'entering'` state\n * and stay there for 500ms (the value of `timeout`) before it finally switches\n * to `'entered'`.\n *\n * When `in` is `false` the same thing happens except the state moves from\n * `'exiting'` to `'exited'`.\n */\n\nexports.EXITING = EXITING;\n\nvar Transition =\n/*#__PURE__*/\nfunction (_React$Component) {\n  _inheritsLoose(Transition, _React$Component);\n\n  function Transition(props, context) {\n    var _this;\n\n    _this = _React$Component.call(this, props, context) || this;\n    var parentGroup = context; // In the context of a TransitionGroup all enters are really appears\n\n    var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;\n    var initialStatus;\n    _this.appearStatus = null;\n\n    if (props.in) {\n      if (appear) {\n        initialStatus = EXITED;\n        _this.appearStatus = ENTERING;\n      } else {\n        initialStatus = ENTERED;\n      }\n    } else {\n      if (props.unmountOnExit || props.mountOnEnter) {\n        initialStatus = UNMOUNTED;\n      } else {\n        initialStatus = EXITED;\n      }\n    }\n\n    _this.state = {\n      status: initialStatus\n    };\n    _this.nextCallback = null;\n    return _this;\n  }\n\n  Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {\n    var nextIn = _ref.in;\n\n    if (nextIn && prevState.status === UNMOUNTED) {\n      return {\n        status: EXITED\n      };\n    }\n\n    return null;\n  }; // getSnapshotBeforeUpdate(prevProps) {\n  //   let nextStatus = null\n  //   if (prevProps !== this.props) {\n  //     const { status } = this.state\n  //     if (this.props.in) {\n  //       if (status !== ENTERING && status !== ENTERED) {\n  //         nextStatus = ENTERING\n  //       }\n  //     } else {\n  //       if (status === ENTERING || status === ENTERED) {\n  //         nextStatus = EXITING\n  //       }\n  //     }\n  //   }\n  //   return { nextStatus }\n  // }\n\n\n  var _proto = Transition.prototype;\n\n  _proto.componentDidMount = function componentDidMount() {\n    this.updateStatus(true, this.appearStatus);\n  };\n\n  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {\n    var nextStatus = null;\n\n    if (prevProps !== this.props) {\n      var status = this.state.status;\n\n      if (this.props.in) {\n        if (status !== ENTERING && status !== ENTERED) {\n          nextStatus = ENTERING;\n        }\n      } else {\n        if (status === ENTERING || status === ENTERED) {\n          nextStatus = EXITING;\n        }\n      }\n    }\n\n    this.updateStatus(false, nextStatus);\n  };\n\n  _proto.componentWillUnmount = function componentWillUnmount() {\n    this.cancelNextCallback();\n  };\n\n  _proto.getTimeouts = function getTimeouts() {\n    var timeout = this.props.timeout;\n    var exit, enter, appear;\n    exit = enter = appear = timeout;\n\n    if (timeout != null && typeof timeout !== 'number') {\n      exit = timeout.exit;\n      enter = timeout.enter; // TODO: remove fallback for next major\n\n      appear = timeout.appear !== undefined ? timeout.appear : enter;\n    }\n\n    return {\n      exit: exit,\n      enter: enter,\n      appear: appear\n    };\n  };\n\n  _proto.updateStatus = function updateStatus(mounting, nextStatus) {\n    if (mounting === void 0) {\n      mounting = false;\n    }\n\n    if (nextStatus !== null) {\n      // nextStatus will always be ENTERING or EXITING.\n      this.cancelNextCallback();\n\n      var node = _reactDom.default.findDOMNode(this);\n\n      if (nextStatus === ENTERING) {\n        this.performEnter(node, mounting);\n      } else {\n        this.performExit(node);\n      }\n    } else if (this.props.unmountOnExit && this.state.status === EXITED) {\n      this.setState({\n        status: UNMOUNTED\n      });\n    }\n  };\n\n  _proto.performEnter = function performEnter(node, mounting) {\n    var _this2 = this;\n\n    var enter = this.props.enter;\n    var appearing = this.context ? this.context.isMounting : mounting;\n    var timeouts = this.getTimeouts();\n    var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED\n    // if we are mounting and running this it means appear _must_ be set\n\n    if (!mounting && !enter || _config.default.disabled) {\n      this.safeSetState({\n        status: ENTERED\n      }, function () {\n        _this2.props.onEntered(node);\n      });\n      return;\n    }\n\n    this.props.onEnter(node, appearing);\n    this.safeSetState({\n      status: ENTERING\n    }, function () {\n      _this2.props.onEntering(node, appearing);\n\n      _this2.onTransitionEnd(node, enterTimeout, function () {\n        _this2.safeSetState({\n          status: ENTERED\n        }, function () {\n          _this2.props.onEntered(node, appearing);\n        });\n      });\n    });\n  };\n\n  _proto.performExit = function performExit(node) {\n    var _this3 = this;\n\n    var exit = this.props.exit;\n    var timeouts = this.getTimeouts(); // no exit animation skip right to EXITED\n\n    if (!exit || _config.default.disabled) {\n      this.safeSetState({\n        status: EXITED\n      }, function () {\n        _this3.props.onExited(node);\n      });\n      return;\n    }\n\n    this.props.onExit(node);\n    this.safeSetState({\n      status: EXITING\n    }, function () {\n      _this3.props.onExiting(node);\n\n      _this3.onTransitionEnd(node, timeouts.exit, function () {\n        _this3.safeSetState({\n          status: EXITED\n        }, function () {\n          _this3.props.onExited(node);\n        });\n      });\n    });\n  };\n\n  _proto.cancelNextCallback = function cancelNextCallback() {\n    if (this.nextCallback !== null) {\n      this.nextCallback.cancel();\n      this.nextCallback = null;\n    }\n  };\n\n  _proto.safeSetState = function safeSetState(nextState, callback) {\n    // This shouldn't be necessary, but there are weird race conditions with\n    // setState callbacks and unmounting in testing, so always make sure that\n    // we can cancel any pending setState callbacks after we unmount.\n    callback = this.setNextCallback(callback);\n    this.setState(nextState, callback);\n  };\n\n  _proto.setNextCallback = function setNextCallback(callback) {\n    var _this4 = this;\n\n    var active = true;\n\n    this.nextCallback = function (event) {\n      if (active) {\n        active = false;\n        _this4.nextCallback = null;\n        callback(event);\n      }\n    };\n\n    this.nextCallback.cancel = function () {\n      active = false;\n    };\n\n    return this.nextCallback;\n  };\n\n  _proto.onTransitionEnd = function onTransitionEnd(node, timeout, handler) {\n    this.setNextCallback(handler);\n    var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;\n\n    if (!node || doesNotHaveTimeoutOrListener) {\n      setTimeout(this.nextCallback, 0);\n      return;\n    }\n\n    if (this.props.addEndListener) {\n      this.props.addEndListener(node, this.nextCallback);\n    }\n\n    if (timeout != null) {\n      setTimeout(this.nextCallback, timeout);\n    }\n  };\n\n  _proto.render = function render() {\n    var status = this.state.status;\n\n    if (status === UNMOUNTED) {\n      return null;\n    }\n\n    var _this$props = this.props,\n        children = _this$props.children,\n        childProps = _objectWithoutPropertiesLoose(_this$props, [\"children\"]); // filter props for Transtition\n\n\n    delete childProps.in;\n    delete childProps.mountOnEnter;\n    delete childProps.unmountOnExit;\n    delete childProps.appear;\n    delete childProps.enter;\n    delete childProps.exit;\n    delete childProps.timeout;\n    delete childProps.addEndListener;\n    delete childProps.onEnter;\n    delete childProps.onEntering;\n    delete childProps.onEntered;\n    delete childProps.onExit;\n    delete childProps.onExiting;\n    delete childProps.onExited;\n\n    if (typeof children === 'function') {\n      // allows for nested Transitions\n      return _react.default.createElement(_TransitionGroupContext.default.Provider, {\n        value: null\n      }, children(status, childProps));\n    }\n\n    var child = _react.default.Children.only(children);\n\n    return (// allows for nested Transitions\n      _react.default.createElement(_TransitionGroupContext.default.Provider, {\n        value: null\n      }, _react.default.cloneElement(child, childProps))\n    );\n  };\n\n  return Transition;\n}(_react.default.Component);\n\nTransition.contextType = _TransitionGroupContext.default;\nTransition.propTypes = process.env.NODE_ENV !== \"production\" ? {\n  /**\n   * A `function` child can be used instead of a React element. This function is\n   * called with the current transition status (`'entering'`, `'entered'`,\n   * `'exiting'`, `'exited'`), which can be used to apply context\n   * specific props to a component.\n   *\n   * ```jsx\n   * <Transition in={this.state.in} timeout={150}>\n   *   {state => (\n   *     <MyComponent className={`fade fade-${state}`} />\n   *   )}\n   * </Transition>\n   * ```\n   */\n  children: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.element.isRequired]).isRequired,\n\n  /**\n   * Show the component; triggers the enter or exit states\n   */\n  in: _propTypes.default.bool,\n\n  /**\n   * By default the child component is mounted immediately along with\n   * the parent `Transition` component. If you want to \"lazy mount\" the component on the\n   * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay\n   * mounted, even on \"exited\", unless you also specify `unmountOnExit`.\n   */\n  mountOnEnter: _propTypes.default.bool,\n\n  /**\n   * By default the child component stays mounted after it reaches the `'exited'` state.\n   * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.\n   */\n  unmountOnExit: _propTypes.default.bool,\n\n  /**\n   * Normally a component is not transitioned if it is shown when the\n   * `<Transition>` component mounts. If you want to transition on the first\n   * mount set `appear` to `true`, and the component will transition in as soon\n   * as the `<Transition>` mounts.\n   *\n   * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop\n   * > only adds an additional enter transition. However, in the\n   * > `<CSSTransition>` component that first enter transition does result in\n   * > additional `.appear-*` classes, that way you can choose to style it\n   * > differently.\n   */\n  appear: _propTypes.default.bool,\n\n  /**\n   * Enable or disable enter transitions.\n   */\n  enter: _propTypes.default.bool,\n\n  /**\n   * Enable or disable exit transitions.\n   */\n  exit: _propTypes.default.bool,\n\n  /**\n   * The duration of the transition, in milliseconds.\n   * Required unless `addEndListener` is provided.\n   *\n   * You may specify a single timeout for all transitions:\n   *\n   * ```jsx\n   * timeout={500}\n   * ```\n   *\n   * or individually:\n   *\n   * ```jsx\n   * timeout={{\n   *  appear: 500,\n   *  enter: 300,\n   *  exit: 500,\n   * }}\n   * ```\n   *\n   * - `appear` defaults to the value of `enter`\n   * - `enter` defaults to `0`\n   * - `exit` defaults to `0`\n   *\n   * @type {number | { enter?: number, exit?: number, appear?: number }}\n   */\n  timeout: function timeout(props) {\n    var pt = _PropTypes.timeoutsShape;\n    if (!props.addEndListener) pt = pt.isRequired;\n\n    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n      args[_key - 1] = arguments[_key];\n    }\n\n    return pt.apply(void 0, [props].concat(args));\n  },\n\n  /**\n   * Add a custom transition end trigger. Called with the transitioning\n   * DOM node and a `done` callback. Allows for more fine grained transition end\n   * logic. **Note:** Timeouts are still used as a fallback if provided.\n   *\n   * ```jsx\n   * addEndListener={(node, done) => {\n   *   // use the css transitionend event to mark the finish of a transition\n   *   node.addEventListener('transitionend', done, false);\n   * }}\n   * ```\n   */\n  addEndListener: _propTypes.default.func,\n\n  /**\n   * Callback fired before the \"entering\" status is applied. An extra parameter\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\n   *\n   * @type Function(node: HtmlElement, isAppearing: bool) -> void\n   */\n  onEnter: _propTypes.default.func,\n\n  /**\n   * Callback fired after the \"entering\" status is applied. An extra parameter\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\n   *\n   * @type Function(node: HtmlElement, isAppearing: bool)\n   */\n  onEntering: _propTypes.default.func,\n\n  /**\n   * Callback fired after the \"entered\" status is applied. An extra parameter\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\n   *\n   * @type Function(node: HtmlElement, isAppearing: bool) -> void\n   */\n  onEntered: _propTypes.default.func,\n\n  /**\n   * Callback fired before the \"exiting\" status is applied.\n   *\n   * @type Function(node: HtmlElement) -> void\n   */\n  onExit: _propTypes.default.func,\n\n  /**\n   * Callback fired after the \"exiting\" status is applied.\n   *\n   * @type Function(node: HtmlElement) -> void\n   */\n  onExiting: _propTypes.default.func,\n\n  /**\n   * Callback fired after the \"exited\" status is applied.\n   *\n   * @type Function(node: HtmlElement) -> void\n   */\n  onExited: _propTypes.default.func // Name the function so it is clearer in the documentation\n\n} : {};\n\nfunction noop() {}\n\nTransition.defaultProps = {\n  in: false,\n  mountOnEnter: false,\n  unmountOnExit: false,\n  appear: false,\n  enter: true,\n  exit: true,\n  onEnter: noop,\n  onEntering: noop,\n  onEntered: noop,\n  onExit: noop,\n  onExiting: noop,\n  onExited: noop\n};\nTransition.UNMOUNTED = 0;\nTransition.EXITED = 1;\nTransition.ENTERING = 2;\nTransition.ENTERED = 3;\nTransition.EXITING = 4;\nvar _default = Transition;\nexports.default = _default;\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$react_transition_group$cjs$config","~$module$react","~$module$node_modules$prop_types$index","~$shadow.js","~$module$node_modules$react_transition_group$cjs$TransitionGroupContext","~$module$node_modules$react_transition_group$cjs$utils$PropTypes","~$module$react_dom"]],"~:properties",["^5",["appear","EXITED","getDerivedStateFromProps","onExited","cancel","prototype","unmountOnExit","cancelNextCallback","safeSetState","updateStatus","performEnter","__esModule","EXITING","propTypes","appearStatus","value","setNextCallback","UNMOUNTED","onEntering","getTimeouts","status","onExit","componentDidUpdate","performExit","onEntered","contextType","componentDidMount","defaultProps","render","onExiting","state","__proto__","exit","onTransitionEnd","componentWillUnmount","nextCallback","mountOnEnter","ENTERED","onEnter","ENTERING","enter","default","constructor","in"]],"~:compiled-at",1766065009602,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$react_transition_group$cjs$Transition.js\",\n\"lineCount\":9,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAkB9DC,QAASA,EAAsB,CAACC,CAAD,CAAM,CAAE,MAAOA,EAAA,EAAOA,CAAIC,CAAAA,UAAX,CAAwBD,CAAxB,CAA8B,CAAEE,QAASF,CAAX,CAAvC,CAIrCG,QAASA,EAAc,CAACC,CAAD,CAAWC,CAAX,CAAuB,CAAED,CAASE,CAAAA,SAAT,CAAqBC,MAAOC,CAAAA,MAAP,CAAcH,CAAWC,CAAAA,SAAzB,CAAqCF,EAASE,CAAAA,SAAUG,CAAAA,WAAnB,CAAiCL,CAAUA,EAASM,CAAAA,SAAT,CAAqBL,CAA5H,CAqjB9CM,QAASA,EAAI,EAAG,EAxkBhBb,CAAQG,CAAAA,UAAR,CAAqB,CAAA,CACrBH,EAAQI,CAAAA,OAAR,CAAkBJ,CAAQc,CAAAA,OAA1B,CAAoCd,CAAQe,CAAAA,OAA5C,CAAsDf,CAAQgB,CAAAA,QAA9D,CAAyEhB,CAAQiB,CAAAA,MAAjF,CAA0FjB,CAAQkB,CAAAA,SAAlG,CAA8G,IAAK,EAElGjB,EAAA,CAAuBH,CAAA,CAAQ,GAAR,CAAvB,CAEjB,KAAIqB,EAASlB,CAAA,CAAuBH,CAAA,CAAQ,CAAR,CAAvB,CAAb,CAEIsB,EAAYnB,CAAA,CAAuBH,CAAA,CAAQ,CAAR,CAAvB,CAFhB,CAIIuB,EAAUpB,CAAA,CAAuBH,CAAA,CAAQ,GAAR,CAAvB,CAEGA,EAAA,CAAQ,GAAR,CAEjB,KAAIwB,EAA0BrB,CAAA,CAAuBH,CAAA,CAAQ,GAAR,CAAvB,CAS9BE,EAAQkB,CAAAA,SAAR,CADgBA,WAGhBlB,EAAQiB,CAAAA,MAAR,CADaA,QAGbjB,EAAQgB,CAAAA,QAAR,CADeA,UAGfhB,EAAQe,CAAAA,OAAR,CADcA,SA+Fdf,EAAQc,CAAAA,OAAR,CA7FcA,SA+FVS,GAAAA,CAEJ,QAAS,CAACC,CAAD,CAAmB,CAG1BD,QAASA,EAAU,CAACE,CAAD,CAAQC,CAAR,CAAiB,CAGlC,IAAAC,EAAQH,CAAiBI,CAAAA,IAAjB,CAAsB,IAAtB;AAA4BH,CAA5B,CAAmCC,CAAnC,CAARC,EAAuD,IAGnDE,EAAAA,CAFcH,CAEL,EAAe,CAFVA,CAEuBI,CAAAA,UAA5B,CAAyCL,CAAMM,CAAAA,KAA/C,CAAuDN,CAAMI,CAAAA,MAE1EF,EAAMK,CAAAA,YAAN,CAAqB,IAEjBP,EAAMQ,CAAAA,EAAV,CACMJ,CAAJ,EACEK,CACA,CAvHKjB,QAuHL,CAAAU,CAAMK,CAAAA,YAAN,CArHOhB,UAmHT,EAIEkB,CAJF,CAjHQnB,SAgHV,CASImB,CATJ,CAQMT,CAAMU,CAAAA,aAAV,EAA2BV,CAAMW,CAAAA,YAAjC,CA9HUlB,WA8HV,CA5HOD,QAmITU,EAAMU,CAAAA,KAAN,CAAc,CACZC,OAAQJ,CADI,CAGdP,EAAMY,CAAAA,YAAN,CAAqB,IACrB,OAAOZ,EA7B2B,CAFpCtB,CAAA,CAAekB,CAAf,CAA2BC,CAA3B,CAkCAD,EAAWiB,CAAAA,wBAAX,CAAsCC,QAAiC,CAACC,CAAD,CAAOC,CAAP,CAAkB,CAGvF,MAFaD,EAAKT,CAAAA,EAElB,EA/IYf,WA+IZ,GAAcyB,CAAUL,CAAAA,MAAxB,CACS,CACLA,OA/IKrB,QA8IA,CADT,CAMO,IATgF,CA4BzF,KAAI2B,EAASrB,CAAWf,CAAAA,SAExBoC,EAAOC,CAAAA,iBAAP,CAA2BC,QAA0B,EAAG,CACtD,IAAKC,CAAAA,YAAL,CAAkB,CAAA,CAAlB,CAAwB,IAAKf,CAAAA,YAA7B,CADsD,CAIxDY,EAAOI,CAAAA,kBAAP,CAA4BC,QAA2B,CAACC,CAAD,CAAY,CACjE,IAAIC,EAAa,IAEjB,IAAID,CAAJ,GAAkB,IAAKzB,CAAAA,KAAvB,CAGE,GAFIa,CAEWL,CAFF,IAAKI,CAAAA,KAAMC,CAAAA,MAETL;AAAX,IAAKR,CAAAA,KAAMQ,CAAAA,EAAf,CAhLSjB,UAiLP,GAAIsB,CAAJ,EA/KMvB,SA+KN,GAA2BuB,CAA3B,GACEa,CADF,CAjLOnC,UAiLP,CADF,KAKE,IArLOA,UAqLP,GAAIsB,CAAJ,EAnLMvB,SAmLN,GAA2BuB,CAA3B,CACEa,CAAA,CAlLIrC,SAuLV,KAAKiC,CAAAA,YAAL,CAAkB,CAAA,CAAlB,CAAyBI,CAAzB,CAjBiE,CAoBnEP,EAAOQ,CAAAA,oBAAP,CAA8BC,QAA6B,EAAG,CAC5D,IAAKC,CAAAA,kBAAL,EAD4D,CAI9DV,EAAOW,CAAAA,WAAP,CAAqBC,QAAoB,EAAG,CAC1C,IAAIC,EAAU,IAAKhC,CAAAA,KAAMgC,CAAAA,OAAzB,CACU1B,CADV,CACiBF,CACjB,KAAA6B,EAAO3B,CAAP2B,CAAe7B,CAAf6B,CAAwBD,CAET,KAAf,EAAIA,CAAJ,EAA0C,QAA1C,GAAuB,MAAOA,EAA9B,GACEC,CAGA,CAHOD,CAAQC,CAAAA,IAGf,CAFA3B,CAEA,CAFQ0B,CAAQ1B,CAAAA,KAEhB,CAAAF,CAAA,CAA4B8B,IAAAA,EAAnB,GAAAF,CAAQ5B,CAAAA,MAAR,CAA+B4B,CAAQ5B,CAAAA,MAAvC,CAAgDE,CAJ3D,CAOA,OAAO,CACL2B,KAAMA,CADD,CAEL3B,MAAOA,CAFF,CAGLF,OAAQA,CAHH,CAZmC,CAmB5Ce,EAAOG,CAAAA,YAAP,CAAsBa,QAAqB,CAACC,CAAD,CAAWV,CAAX,CAAuB,CAC/C,IAAK,EAAtB,GAAIU,CAAJ,GACEA,CADF,CACa,CAAA,CADb,CAIA,IAAmB,IAAnB,GAAIV,CAAJ,CAAyB,CAEvB,IAAKG,CAAAA,kBAAL,EAEA,KAAIQ,EAAO1C,CAAUhB,CAAAA,OAAQ2D,CAAAA,WAAlB,CAA8B,IAA9B,CA9NF/C,WAgOT;AAAImC,CAAJ,CACE,IAAKa,CAAAA,YAAL,CAAkBF,CAAlB,CAAwBD,CAAxB,CADF,CAGE,IAAKI,CAAAA,WAAL,CAAiBH,CAAjB,CATqB,CAAzB,IAWW,KAAKrC,CAAAA,KAAMU,CAAAA,aAAf,EAvOElB,QAuOF,GAAgC,IAAKoB,CAAAA,KAAMC,CAAAA,MAA3C,EACL,IAAK4B,CAAAA,QAAL,CAAc,CACZ5B,OA3OQpB,WA0OI,CAAd,CAjB8D,CAuBlE0B,EAAOoB,CAAAA,YAAP,CAAsBG,QAAqB,CAACL,CAAD,CAAOD,CAAP,CAAiB,CAC1D,IAAIO,EAAS,IAAb,CAEIrC,EAAQ,IAAKN,CAAAA,KAAMM,CAAAA,KAFvB,CAGIsC,EAAY,IAAK3C,CAAAA,OAAL,CAAe,IAAKA,CAAAA,OAAQI,CAAAA,UAA5B,CAAyC+B,CAHzD,CAIIS,EAAW,IAAKf,CAAAA,WAAL,EAJf,CAKIgB,EAAeF,CAAA,CAAYC,CAASzC,CAAAA,MAArB,CAA8ByC,CAASvC,CAAAA,KAGtD,EAAC8B,CAAL,EAAiB,CAAC9B,CAAlB,EAA2BV,CAAQjB,CAAAA,OAAQoE,CAAAA,QAA3C,CACE,IAAKC,CAAAA,YAAL,CAAkB,CAChBnC,OArPMvB,SAoPU,CAAlB,CAEG,QAAS,EAAG,CACbqD,CAAO3C,CAAAA,KAAMiD,CAAAA,SAAb,CAAuBZ,CAAvB,CADa,CAFf,CADF,EASA,IAAKrC,CAAAA,KAAMkD,CAAAA,OAAX,CAAmBb,CAAnB,CAAyBO,CAAzB,CACA,CAAA,IAAKI,CAAAA,YAAL,CAAkB,CAChBnC,OAhQStB,UA+PO,CAAlB,CAEG,QAAS,EAAG,CACboD,CAAO3C,CAAAA,KAAMmD,CAAAA,UAAb,CAAwBd,CAAxB,CAA8BO,CAA9B,CAEAD,EAAOS,CAAAA,eAAP,CAAuBf,CAAvB;AAA6BS,CAA7B,CAA2C,QAAS,EAAG,CACrDH,CAAOK,CAAAA,YAAP,CAAoB,CAClBnC,OApQIvB,SAmQc,CAApB,CAEG,QAAS,EAAG,CACbqD,CAAO3C,CAAAA,KAAMiD,CAAAA,SAAb,CAAuBZ,CAAvB,CAA6BO,CAA7B,CADa,CAFf,CADqD,CAAvD,CAHa,CAFf,CAVA,CAT0D,CAkC5DzB,EAAOqB,CAAAA,WAAP,CAAqBa,QAAoB,CAAChB,CAAD,CAAO,CAC9C,IAAIiB,EAAS,IAAb,CAEIrB,EAAO,IAAKjC,CAAAA,KAAMiC,CAAAA,IAFtB,CAGIY,EAAW,IAAKf,CAAAA,WAAL,EAEX,EAACG,CAAL,EAAarC,CAAQjB,CAAAA,OAAQoE,CAAAA,QAA7B,CACE,IAAKC,CAAAA,YAAL,CAAkB,CAChBnC,OAxRKrB,QAuRW,CAAlB,CAEG,QAAS,EAAG,CACb8D,CAAOtD,CAAAA,KAAMuD,CAAAA,QAAb,CAAsBlB,CAAtB,CADa,CAFf,CADF,EASA,IAAKrC,CAAAA,KAAMwD,CAAAA,MAAX,CAAkBnB,CAAlB,CACA,CAAA,IAAKW,CAAAA,YAAL,CAAkB,CAChBnC,OA3RQxB,SA0RQ,CAAlB,CAEG,QAAS,EAAG,CACbiE,CAAOtD,CAAAA,KAAMyD,CAAAA,SAAb,CAAuBpB,CAAvB,CAEAiB,EAAOF,CAAAA,eAAP,CAAuBf,CAAvB,CAA6BQ,CAASZ,CAAAA,IAAtC,CAA4C,QAAS,EAAG,CACtDqB,CAAON,CAAAA,YAAP,CAAoB,CAClBnC,OAvSGrB,QAsSe,CAApB,CAEG,QAAS,EAAG,CACb8D,CAAOtD,CAAAA,KAAMuD,CAAAA,QAAb,CAAsBlB,CAAtB,CADa,CAFf,CADsD,CAAxD,CAHa,CAFf,CAVA,CAN8C,CA+BhDlB,EAAOU,CAAAA,kBAAP,CAA4B6B,QAA2B,EAAG,CAC9B,IAA1B,GAAI,IAAK5C,CAAAA,YAAT;CACE,IAAKA,CAAAA,YAAa6C,CAAAA,MAAlB,EACA,CAAA,IAAK7C,CAAAA,YAAL,CAAoB,IAFtB,CADwD,CAO1DK,EAAO6B,CAAAA,YAAP,CAAsBY,QAAqB,CAACC,CAAD,CAAYC,CAAZ,CAAsB,CAI/DA,CAAA,CAAW,IAAKC,CAAAA,eAAL,CAAqBD,CAArB,CACX,KAAKrB,CAAAA,QAAL,CAAcoB,CAAd,CAAyBC,CAAzB,CAL+D,CAQjE3C,EAAO4C,CAAAA,eAAP,CAAyBC,QAAwB,CAACF,CAAD,CAAW,CAC1D,IAAIG,EAAS,IAAb,CAEIC,EAAS,CAAA,CAEb,KAAKpD,CAAAA,YAAL,CAAoBqD,QAAS,CAACC,CAAD,CAAQ,CAC/BF,CAAJ,GACEA,CAEA,CAFS,CAAA,CAET,CADAD,CAAOnD,CAAAA,YACP,CADsB,IACtB,CAAAgD,CAAA,CAASM,CAAT,CAHF,CADmC,CAQrC,KAAKtD,CAAAA,YAAa6C,CAAAA,MAAlB,CAA2BU,QAAS,EAAG,CACrCH,CAAA,CAAS,CAAA,CAD4B,CAIvC,OAAO,KAAKpD,CAAAA,YAjB8C,CAoB5DK,EAAOiC,CAAAA,eAAP,CAAyBkB,QAAwB,CAACjC,CAAD,CAAOL,CAAP,CAAgBuC,CAAhB,CAAyB,CACxE,IAAKR,CAAAA,eAAL,CAAqBQ,CAArB,CACIC,EAAAA,CAA0C,IAA1CA,EAA+BxC,CAA/BwC,EAAkD,CAAC,IAAKxE,CAAAA,KAAMyE,CAAAA,cAE9D,EAACpC,CAAL,EAAamC,CAAb,CACEE,UAAA,CAAW,IAAK5D,CAAAA,YAAhB,CAA8B,CAA9B,CADF,EAKI,IAAKd,CAAAA,KAAMyE,CAAAA,cAIf,EAHE,IAAKzE,CAAAA,KAAMyE,CAAAA,cAAX,CAA0BpC,CAA1B,CAAgC,IAAKvB,CAAAA,YAArC,CAGF;AAAe,IAAf,EAAIkB,CAAJ,EACE0C,UAAA,CAAW,IAAK5D,CAAAA,YAAhB,CAA8BkB,CAA9B,CAVF,CAJwE,CAkB1Eb,EAAOwD,CAAAA,MAAP,CAAgBC,QAAe,EAAG,CAChC,IAAI/D,EAAS,IAAKD,CAAAA,KAAMC,CAAAA,MAExB,IAzWYpB,WAyWZ,GAAIoB,CAAJ,CACE,MAAO,KAJuB,KAO5BgE,EAAc,IAAK7E,CAAAA,KAPS,CAQ5B8E,EAAWD,CAAYC,CAAAA,QACiC,KAAA,EAAA,CAAC,UAAD,CAnXL,IAAc,IAAd,EAmXRD,CAnXQ,CAAoB,CAAA,CAAO,EAA3B,KAAA,CAA+B,IAAIE,EAAS,EAAb,CAAqBC,EAAahG,MAAOiG,CAAAA,IAAP,CAmXzEJ,CAnXyE,CAAlC,CAAgEK,CAAG,KAAKA,CAAL,CAAS,CAAT,CAAYA,CAAZ,CAAgBF,CAAWG,CAAAA,MAA3B,CAAmCD,CAAA,EAAnC,CAAwC,CAAE,IAAAE,EAAMJ,CAAA,CAAWE,CAAX,CAA4C,EAA7B,EAAIG,CAASC,CAAAA,OAAT,CAAiBF,CAAjB,CAAJ,GAA0CL,CAAA,CAAOK,CAAP,CAA1C,CAmXzKP,CAnXiO,CAAOO,CAAP,CAAxD,CAAvB,CAA8F,CAAA,CAAOL,CAA/O,CAsXvD,OAAOQ,CAAW/E,CAAAA,EAClB,QAAO+E,CAAW5E,CAAAA,YAClB,QAAO4E,CAAW7E,CAAAA,aAClB,QAAO6E,CAAWnF,CAAAA,MAClB,QAAOmF,CAAWjF,CAAAA,KAClB,QAAOiF,CAAWtD,CAAAA,IAClB,QAAOsD,CAAWvD,CAAAA,OAClB,QAAOuD,CAAWd,CAAAA,cAClB,QAAOc,CAAWrC,CAAAA,OAClB,QAAOqC,CAAWpC,CAAAA,UAClB,QAAOoC,CAAWtC,CAAAA,SAClB,QAAOsC,CAAW/B,CAAAA,MAClB,QAAO+B,CAAW9B,CAAAA,SAClB;OAAO8B,CAAWhC,CAAAA,QAElB,IAAwB,UAAxB,GAAI,MAAOuB,EAAX,CAEE,MAAOpF,EAAOf,CAAAA,OAAQ6G,CAAAA,aAAf,CAA6B3F,CAAwBlB,CAAAA,OAAQ8G,CAAAA,QAA7D,CAAuE,CAC5EC,MAAO,IADqE,CAAvE,CAEJZ,CAAA,CAASjE,CAAT,CAAiB0E,CAAjB,CAFI,CAKLI,EAAAA,CAAQjG,CAAOf,CAAAA,OAAQiH,CAAAA,QAASC,CAAAA,IAAxB,CAA6Bf,CAA7B,CAEZ,OACEpF,EAAOf,CAAAA,OAAQ6G,CAAAA,aAAf,CAA6B3F,CAAwBlB,CAAAA,OAAQ8G,CAAAA,QAA7D,CAAuE,CACrEC,MAAO,IAD8D,CAAvE,CAEGhG,CAAOf,CAAAA,OAAQmH,CAAAA,YAAf,CAA4BH,CAA5B,CAAmCJ,CAAnC,CAFH,CArC8B,CA2ClC,OAAOzF,EAxSmB,CAA5B,CAySEJ,CAAOf,CAAAA,OAAQoH,CAAAA,SAzSjB,CA2SAjG,GAAWkG,CAAAA,WAAX,CAAyBnG,CAAwBlB,CAAAA,OACjDmB,GAAWmG,CAAAA,SAAX,CA4JI,EAIJnG,GAAWoG,CAAAA,YAAX,CAA0B,CACxB1F,GAAI,CAAA,CADoB,CAExBG,aAAc,CAAA,CAFU,CAGxBD,cAAe,CAAA,CAHS,CAIxBN,OAAQ,CAAA,CAJgB,CAKxBE,MAAO,CAAA,CALiB,CAMxB2B,KAAM,CAAA,CANkB,CAOxBiB,QAAS9D,CAPe,CAQxB+D,WAAY/D,CARY,CASxB6D,UAAW7D,CATa,CAUxBoE,OAAQpE,CAVgB,CAWxBqE,UAAWrE,CAXa,CAYxBmE,SAAUnE,CAZc,CAc1BU,GAAWL,CAAAA,SAAX,CAAuB,CACvBK,GAAWN,CAAAA,MAAX,CAAoB,CACpBM,GAAWP,CAAAA,QAAX,CAAsB,CACtBO,GAAWR,CAAAA,OAAX;AAAqB,CACrBQ,GAAWT,CAAAA,OAAX,CAAqB,CAErBd,EAAQI,CAAAA,OAAR,CADemB,EAhmB+C;\",\n\"sources\":[\"node_modules/react-transition-group/cjs/Transition.js\"],\n\"sourcesContent\":[\"shadow$provide[253] = function(global,require,module,exports) {\\n\\\"use strict\\\";\\n\\nexports.__esModule = true;\\nexports.default = exports.EXITING = exports.ENTERED = exports.ENTERING = exports.EXITED = exports.UNMOUNTED = void 0;\\n\\nvar _propTypes = _interopRequireDefault(require(\\\"prop-types\\\"));\\n\\nvar _react = _interopRequireDefault(require(\\\"react\\\"));\\n\\nvar _reactDom = _interopRequireDefault(require(\\\"react-dom\\\"));\\n\\nvar _config = _interopRequireDefault(require(\\\"./config\\\"));\\n\\nvar _PropTypes = require(\\\"./utils/PropTypes\\\");\\n\\nvar _TransitionGroupContext = _interopRequireDefault(require(\\\"./TransitionGroupContext\\\"));\\n\\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\\n\\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\\n\\nfunction _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; subClass.__proto__ = superClass; }\\n\\nvar UNMOUNTED = 'unmounted';\\nexports.UNMOUNTED = UNMOUNTED;\\nvar EXITED = 'exited';\\nexports.EXITED = EXITED;\\nvar ENTERING = 'entering';\\nexports.ENTERING = ENTERING;\\nvar ENTERED = 'entered';\\nexports.ENTERED = ENTERED;\\nvar EXITING = 'exiting';\\n/**\\n * The Transition component lets you describe a transition from one component\\n * state to another _over time_ with a simple declarative API. Most commonly\\n * it's used to animate the mounting and unmounting of a component, but can also\\n * be used to describe in-place transition states as well.\\n *\\n * ---\\n *\\n * **Note**: `Transition` is a platform-agnostic base component. If you're using\\n * transitions in CSS, you'll probably want to use\\n * [`CSSTransition`](https://reactcommunity.org/react-transition-group/css-transition)\\n * instead. It inherits all the features of `Transition`, but contains\\n * additional features necessary to play nice with CSS transitions (hence the\\n * name of the component).\\n *\\n * ---\\n *\\n * By default the `Transition` component does not alter the behavior of the\\n * component it renders, it only tracks \\\"enter\\\" and \\\"exit\\\" states for the\\n * components. It's up to you to give meaning and effect to those states. For\\n * example we can add styles to a component when it enters or exits:\\n *\\n * ```jsx\\n * import { Transition } from 'react-transition-group';\\n *\\n * const duration = 300;\\n *\\n * const defaultStyle = {\\n *   transition: `opacity ${duration}ms ease-in-out`,\\n *   opacity: 0,\\n * }\\n *\\n * const transitionStyles = {\\n *   entering: { opacity: 1 },\\n *   entered:  { opacity: 1 },\\n *   exiting:  { opacity: 0 },\\n *   exited:  { opacity: 0 },\\n * };\\n *\\n * const Fade = ({ in: inProp }) => (\\n *   <Transition in={inProp} timeout={duration}>\\n *     {state => (\\n *       <div style={{\\n *         ...defaultStyle,\\n *         ...transitionStyles[state]\\n *       }}>\\n *         I'm a fade Transition!\\n *       </div>\\n *     )}\\n *   </Transition>\\n * );\\n * ```\\n *\\n * There are 4 main states a Transition can be in:\\n *  - `'entering'`\\n *  - `'entered'`\\n *  - `'exiting'`\\n *  - `'exited'`\\n *\\n * Transition state is toggled via the `in` prop. When `true` the component\\n * begins the \\\"Enter\\\" stage. During this stage, the component will shift from\\n * its current transition state, to `'entering'` for the duration of the\\n * transition and then to the `'entered'` stage once it's complete. Let's take\\n * the following example (we'll use the\\n * [useState](https://reactjs.org/docs/hooks-reference.html#usestate) hook):\\n *\\n * ```jsx\\n * function App() {\\n *   const [inProp, setInProp] = useState(false);\\n *   return (\\n *     <div>\\n *       <Transition in={inProp} timeout={500}>\\n *         {state => (\\n *           // ...\\n *         )}\\n *       </Transition>\\n *       <button onClick={() => setInProp(true)}>\\n *         Click to Enter\\n *       </button>\\n *     </div>\\n *   );\\n * }\\n * ```\\n *\\n * When the button is clicked the component will shift to the `'entering'` state\\n * and stay there for 500ms (the value of `timeout`) before it finally switches\\n * to `'entered'`.\\n *\\n * When `in` is `false` the same thing happens except the state moves from\\n * `'exiting'` to `'exited'`.\\n */\\n\\nexports.EXITING = EXITING;\\n\\nvar Transition =\\n/*#__PURE__*/\\nfunction (_React$Component) {\\n  _inheritsLoose(Transition, _React$Component);\\n\\n  function Transition(props, context) {\\n    var _this;\\n\\n    _this = _React$Component.call(this, props, context) || this;\\n    var parentGroup = context; // In the context of a TransitionGroup all enters are really appears\\n\\n    var appear = parentGroup && !parentGroup.isMounting ? props.enter : props.appear;\\n    var initialStatus;\\n    _this.appearStatus = null;\\n\\n    if (props.in) {\\n      if (appear) {\\n        initialStatus = EXITED;\\n        _this.appearStatus = ENTERING;\\n      } else {\\n        initialStatus = ENTERED;\\n      }\\n    } else {\\n      if (props.unmountOnExit || props.mountOnEnter) {\\n        initialStatus = UNMOUNTED;\\n      } else {\\n        initialStatus = EXITED;\\n      }\\n    }\\n\\n    _this.state = {\\n      status: initialStatus\\n    };\\n    _this.nextCallback = null;\\n    return _this;\\n  }\\n\\n  Transition.getDerivedStateFromProps = function getDerivedStateFromProps(_ref, prevState) {\\n    var nextIn = _ref.in;\\n\\n    if (nextIn && prevState.status === UNMOUNTED) {\\n      return {\\n        status: EXITED\\n      };\\n    }\\n\\n    return null;\\n  }; // getSnapshotBeforeUpdate(prevProps) {\\n  //   let nextStatus = null\\n  //   if (prevProps !== this.props) {\\n  //     const { status } = this.state\\n  //     if (this.props.in) {\\n  //       if (status !== ENTERING && status !== ENTERED) {\\n  //         nextStatus = ENTERING\\n  //       }\\n  //     } else {\\n  //       if (status === ENTERING || status === ENTERED) {\\n  //         nextStatus = EXITING\\n  //       }\\n  //     }\\n  //   }\\n  //   return { nextStatus }\\n  // }\\n\\n\\n  var _proto = Transition.prototype;\\n\\n  _proto.componentDidMount = function componentDidMount() {\\n    this.updateStatus(true, this.appearStatus);\\n  };\\n\\n  _proto.componentDidUpdate = function componentDidUpdate(prevProps) {\\n    var nextStatus = null;\\n\\n    if (prevProps !== this.props) {\\n      var status = this.state.status;\\n\\n      if (this.props.in) {\\n        if (status !== ENTERING && status !== ENTERED) {\\n          nextStatus = ENTERING;\\n        }\\n      } else {\\n        if (status === ENTERING || status === ENTERED) {\\n          nextStatus = EXITING;\\n        }\\n      }\\n    }\\n\\n    this.updateStatus(false, nextStatus);\\n  };\\n\\n  _proto.componentWillUnmount = function componentWillUnmount() {\\n    this.cancelNextCallback();\\n  };\\n\\n  _proto.getTimeouts = function getTimeouts() {\\n    var timeout = this.props.timeout;\\n    var exit, enter, appear;\\n    exit = enter = appear = timeout;\\n\\n    if (timeout != null && typeof timeout !== 'number') {\\n      exit = timeout.exit;\\n      enter = timeout.enter; // TODO: remove fallback for next major\\n\\n      appear = timeout.appear !== undefined ? timeout.appear : enter;\\n    }\\n\\n    return {\\n      exit: exit,\\n      enter: enter,\\n      appear: appear\\n    };\\n  };\\n\\n  _proto.updateStatus = function updateStatus(mounting, nextStatus) {\\n    if (mounting === void 0) {\\n      mounting = false;\\n    }\\n\\n    if (nextStatus !== null) {\\n      // nextStatus will always be ENTERING or EXITING.\\n      this.cancelNextCallback();\\n\\n      var node = _reactDom.default.findDOMNode(this);\\n\\n      if (nextStatus === ENTERING) {\\n        this.performEnter(node, mounting);\\n      } else {\\n        this.performExit(node);\\n      }\\n    } else if (this.props.unmountOnExit && this.state.status === EXITED) {\\n      this.setState({\\n        status: UNMOUNTED\\n      });\\n    }\\n  };\\n\\n  _proto.performEnter = function performEnter(node, mounting) {\\n    var _this2 = this;\\n\\n    var enter = this.props.enter;\\n    var appearing = this.context ? this.context.isMounting : mounting;\\n    var timeouts = this.getTimeouts();\\n    var enterTimeout = appearing ? timeouts.appear : timeouts.enter; // no enter animation skip right to ENTERED\\n    // if we are mounting and running this it means appear _must_ be set\\n\\n    if (!mounting && !enter || _config.default.disabled) {\\n      this.safeSetState({\\n        status: ENTERED\\n      }, function () {\\n        _this2.props.onEntered(node);\\n      });\\n      return;\\n    }\\n\\n    this.props.onEnter(node, appearing);\\n    this.safeSetState({\\n      status: ENTERING\\n    }, function () {\\n      _this2.props.onEntering(node, appearing);\\n\\n      _this2.onTransitionEnd(node, enterTimeout, function () {\\n        _this2.safeSetState({\\n          status: ENTERED\\n        }, function () {\\n          _this2.props.onEntered(node, appearing);\\n        });\\n      });\\n    });\\n  };\\n\\n  _proto.performExit = function performExit(node) {\\n    var _this3 = this;\\n\\n    var exit = this.props.exit;\\n    var timeouts = this.getTimeouts(); // no exit animation skip right to EXITED\\n\\n    if (!exit || _config.default.disabled) {\\n      this.safeSetState({\\n        status: EXITED\\n      }, function () {\\n        _this3.props.onExited(node);\\n      });\\n      return;\\n    }\\n\\n    this.props.onExit(node);\\n    this.safeSetState({\\n      status: EXITING\\n    }, function () {\\n      _this3.props.onExiting(node);\\n\\n      _this3.onTransitionEnd(node, timeouts.exit, function () {\\n        _this3.safeSetState({\\n          status: EXITED\\n        }, function () {\\n          _this3.props.onExited(node);\\n        });\\n      });\\n    });\\n  };\\n\\n  _proto.cancelNextCallback = function cancelNextCallback() {\\n    if (this.nextCallback !== null) {\\n      this.nextCallback.cancel();\\n      this.nextCallback = null;\\n    }\\n  };\\n\\n  _proto.safeSetState = function safeSetState(nextState, callback) {\\n    // This shouldn't be necessary, but there are weird race conditions with\\n    // setState callbacks and unmounting in testing, so always make sure that\\n    // we can cancel any pending setState callbacks after we unmount.\\n    callback = this.setNextCallback(callback);\\n    this.setState(nextState, callback);\\n  };\\n\\n  _proto.setNextCallback = function setNextCallback(callback) {\\n    var _this4 = this;\\n\\n    var active = true;\\n\\n    this.nextCallback = function (event) {\\n      if (active) {\\n        active = false;\\n        _this4.nextCallback = null;\\n        callback(event);\\n      }\\n    };\\n\\n    this.nextCallback.cancel = function () {\\n      active = false;\\n    };\\n\\n    return this.nextCallback;\\n  };\\n\\n  _proto.onTransitionEnd = function onTransitionEnd(node, timeout, handler) {\\n    this.setNextCallback(handler);\\n    var doesNotHaveTimeoutOrListener = timeout == null && !this.props.addEndListener;\\n\\n    if (!node || doesNotHaveTimeoutOrListener) {\\n      setTimeout(this.nextCallback, 0);\\n      return;\\n    }\\n\\n    if (this.props.addEndListener) {\\n      this.props.addEndListener(node, this.nextCallback);\\n    }\\n\\n    if (timeout != null) {\\n      setTimeout(this.nextCallback, timeout);\\n    }\\n  };\\n\\n  _proto.render = function render() {\\n    var status = this.state.status;\\n\\n    if (status === UNMOUNTED) {\\n      return null;\\n    }\\n\\n    var _this$props = this.props,\\n        children = _this$props.children,\\n        childProps = _objectWithoutPropertiesLoose(_this$props, [\\\"children\\\"]); // filter props for Transtition\\n\\n\\n    delete childProps.in;\\n    delete childProps.mountOnEnter;\\n    delete childProps.unmountOnExit;\\n    delete childProps.appear;\\n    delete childProps.enter;\\n    delete childProps.exit;\\n    delete childProps.timeout;\\n    delete childProps.addEndListener;\\n    delete childProps.onEnter;\\n    delete childProps.onEntering;\\n    delete childProps.onEntered;\\n    delete childProps.onExit;\\n    delete childProps.onExiting;\\n    delete childProps.onExited;\\n\\n    if (typeof children === 'function') {\\n      // allows for nested Transitions\\n      return _react.default.createElement(_TransitionGroupContext.default.Provider, {\\n        value: null\\n      }, children(status, childProps));\\n    }\\n\\n    var child = _react.default.Children.only(children);\\n\\n    return (// allows for nested Transitions\\n      _react.default.createElement(_TransitionGroupContext.default.Provider, {\\n        value: null\\n      }, _react.default.cloneElement(child, childProps))\\n    );\\n  };\\n\\n  return Transition;\\n}(_react.default.Component);\\n\\nTransition.contextType = _TransitionGroupContext.default;\\nTransition.propTypes = process.env.NODE_ENV !== \\\"production\\\" ? {\\n  /**\\n   * A `function` child can be used instead of a React element. This function is\\n   * called with the current transition status (`'entering'`, `'entered'`,\\n   * `'exiting'`, `'exited'`), which can be used to apply context\\n   * specific props to a component.\\n   *\\n   * ```jsx\\n   * <Transition in={this.state.in} timeout={150}>\\n   *   {state => (\\n   *     <MyComponent className={`fade fade-${state}`} />\\n   *   )}\\n   * </Transition>\\n   * ```\\n   */\\n  children: _propTypes.default.oneOfType([_propTypes.default.func.isRequired, _propTypes.default.element.isRequired]).isRequired,\\n\\n  /**\\n   * Show the component; triggers the enter or exit states\\n   */\\n  in: _propTypes.default.bool,\\n\\n  /**\\n   * By default the child component is mounted immediately along with\\n   * the parent `Transition` component. If you want to \\\"lazy mount\\\" the component on the\\n   * first `in={true}` you can set `mountOnEnter`. After the first enter transition the component will stay\\n   * mounted, even on \\\"exited\\\", unless you also specify `unmountOnExit`.\\n   */\\n  mountOnEnter: _propTypes.default.bool,\\n\\n  /**\\n   * By default the child component stays mounted after it reaches the `'exited'` state.\\n   * Set `unmountOnExit` if you'd prefer to unmount the component after it finishes exiting.\\n   */\\n  unmountOnExit: _propTypes.default.bool,\\n\\n  /**\\n   * Normally a component is not transitioned if it is shown when the\\n   * `<Transition>` component mounts. If you want to transition on the first\\n   * mount set `appear` to `true`, and the component will transition in as soon\\n   * as the `<Transition>` mounts.\\n   *\\n   * > **Note**: there are no special appear states like `appearing`/`appeared`, this prop\\n   * > only adds an additional enter transition. However, in the\\n   * > `<CSSTransition>` component that first enter transition does result in\\n   * > additional `.appear-*` classes, that way you can choose to style it\\n   * > differently.\\n   */\\n  appear: _propTypes.default.bool,\\n\\n  /**\\n   * Enable or disable enter transitions.\\n   */\\n  enter: _propTypes.default.bool,\\n\\n  /**\\n   * Enable or disable exit transitions.\\n   */\\n  exit: _propTypes.default.bool,\\n\\n  /**\\n   * The duration of the transition, in milliseconds.\\n   * Required unless `addEndListener` is provided.\\n   *\\n   * You may specify a single timeout for all transitions:\\n   *\\n   * ```jsx\\n   * timeout={500}\\n   * ```\\n   *\\n   * or individually:\\n   *\\n   * ```jsx\\n   * timeout={{\\n   *  appear: 500,\\n   *  enter: 300,\\n   *  exit: 500,\\n   * }}\\n   * ```\\n   *\\n   * - `appear` defaults to the value of `enter`\\n   * - `enter` defaults to `0`\\n   * - `exit` defaults to `0`\\n   *\\n   * @type {number | { enter?: number, exit?: number, appear?: number }}\\n   */\\n  timeout: function timeout(props) {\\n    var pt = _PropTypes.timeoutsShape;\\n    if (!props.addEndListener) pt = pt.isRequired;\\n\\n    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\\n      args[_key - 1] = arguments[_key];\\n    }\\n\\n    return pt.apply(void 0, [props].concat(args));\\n  },\\n\\n  /**\\n   * Add a custom transition end trigger. Called with the transitioning\\n   * DOM node and a `done` callback. Allows for more fine grained transition end\\n   * logic. **Note:** Timeouts are still used as a fallback if provided.\\n   *\\n   * ```jsx\\n   * addEndListener={(node, done) => {\\n   *   // use the css transitionend event to mark the finish of a transition\\n   *   node.addEventListener('transitionend', done, false);\\n   * }}\\n   * ```\\n   */\\n  addEndListener: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired before the \\\"entering\\\" status is applied. An extra parameter\\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\\n   *\\n   * @type Function(node: HtmlElement, isAppearing: bool) -> void\\n   */\\n  onEnter: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired after the \\\"entering\\\" status is applied. An extra parameter\\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\\n   *\\n   * @type Function(node: HtmlElement, isAppearing: bool)\\n   */\\n  onEntering: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired after the \\\"entered\\\" status is applied. An extra parameter\\n   * `isAppearing` is supplied to indicate if the enter stage is occurring on the initial mount\\n   *\\n   * @type Function(node: HtmlElement, isAppearing: bool) -> void\\n   */\\n  onEntered: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired before the \\\"exiting\\\" status is applied.\\n   *\\n   * @type Function(node: HtmlElement) -> void\\n   */\\n  onExit: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired after the \\\"exiting\\\" status is applied.\\n   *\\n   * @type Function(node: HtmlElement) -> void\\n   */\\n  onExiting: _propTypes.default.func,\\n\\n  /**\\n   * Callback fired after the \\\"exited\\\" status is applied.\\n   *\\n   * @type Function(node: HtmlElement) -> void\\n   */\\n  onExited: _propTypes.default.func // Name the function so it is clearer in the documentation\\n\\n} : {};\\n\\nfunction noop() {}\\n\\nTransition.defaultProps = {\\n  in: false,\\n  mountOnEnter: false,\\n  unmountOnExit: false,\\n  appear: false,\\n  enter: true,\\n  exit: true,\\n  onEnter: noop,\\n  onEntering: noop,\\n  onEntered: noop,\\n  onExit: noop,\\n  onExiting: noop,\\n  onExited: noop\\n};\\nTransition.UNMOUNTED = 0;\\nTransition.EXITED = 1;\\nTransition.ENTERING = 2;\\nTransition.ENTERED = 3;\\nTransition.EXITING = 4;\\nvar _default = Transition;\\nexports.default = _default;\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"_interopRequireDefault\",\"obj\",\"__esModule\",\"default\",\"_inheritsLoose\",\"subClass\",\"superClass\",\"prototype\",\"Object\",\"create\",\"constructor\",\"__proto__\",\"noop\",\"EXITING\",\"ENTERED\",\"ENTERING\",\"EXITED\",\"UNMOUNTED\",\"_react\",\"_reactDom\",\"_config\",\"_TransitionGroupContext\",\"Transition\",\"_React$Component\",\"props\",\"context\",\"_this\",\"call\",\"appear\",\"isMounting\",\"enter\",\"appearStatus\",\"in\",\"initialStatus\",\"unmountOnExit\",\"mountOnEnter\",\"state\",\"status\",\"nextCallback\",\"getDerivedStateFromProps\",\"Transition.getDerivedStateFromProps\",\"_ref\",\"prevState\",\"_proto\",\"componentDidMount\",\"_proto.componentDidMount\",\"updateStatus\",\"componentDidUpdate\",\"_proto.componentDidUpdate\",\"prevProps\",\"nextStatus\",\"componentWillUnmount\",\"_proto.componentWillUnmount\",\"cancelNextCallback\",\"getTimeouts\",\"_proto.getTimeouts\",\"timeout\",\"exit\",\"undefined\",\"_proto.updateStatus\",\"mounting\",\"node\",\"findDOMNode\",\"performEnter\",\"performExit\",\"setState\",\"_proto.performEnter\",\"_this2\",\"appearing\",\"timeouts\",\"enterTimeout\",\"disabled\",\"safeSetState\",\"onEntered\",\"onEnter\",\"onEntering\",\"onTransitionEnd\",\"_proto.performExit\",\"_this3\",\"onExited\",\"onExit\",\"onExiting\",\"_proto.cancelNextCallback\",\"cancel\",\"_proto.safeSetState\",\"nextState\",\"callback\",\"setNextCallback\",\"_proto.setNextCallback\",\"_this4\",\"active\",\"this.nextCallback\",\"event\",\"this.nextCallback.cancel\",\"_proto.onTransitionEnd\",\"handler\",\"doesNotHaveTimeoutOrListener\",\"addEndListener\",\"setTimeout\",\"render\",\"_proto.render\",\"_this$props\",\"children\",\"target\",\"sourceKeys\",\"keys\",\"i\",\"length\",\"key\",\"excluded\",\"indexOf\",\"childProps\",\"createElement\",\"Provider\",\"value\",\"child\",\"Children\",\"only\",\"cloneElement\",\"Component\",\"contextType\",\"propTypes\",\"defaultProps\"]\n}\n"]