["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/react-dom/cjs/react-dom-server.browser.development.js"],"~:js","shadow$provide[618]=function(ra,X,Ra,P){}","~:source","shadow$provide[618] = function(global,require,module,exports) {\n/** @license React v17.0.2\n * react-dom-server.browser.development.js\n *\n * Copyright (c) Facebook, Inc. and its affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n'use strict';\n\nif (process.env.NODE_ENV !== \"production\") {\n  (function() {\n'use strict';\n\nvar React = require('react');\nvar _assign = require('object-assign');\n\n// Do not require this module directly! Use normal `invariant` calls with\n// template literal strings. The messages will be replaced with error codes\n// during build.\nfunction formatProdErrorMessage(code) {\n  var url = 'https://reactjs.org/docs/error-decoder.html?invariant=' + code;\n\n  for (var i = 1; i < arguments.length; i++) {\n    url += '&args[]=' + encodeURIComponent(arguments[i]);\n  }\n\n  return \"Minified React error #\" + code + \"; visit \" + url + \" for the full message or \" + 'use the non-minified dev environment for full errors and additional ' + 'helpful warnings.';\n}\n\n// TODO: this is special because it gets imported during build.\nvar ReactVersion = '17.0.2';\n\nvar ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;\n\n// by calls to these methods by a Babel plugin.\n//\n// In PROD (or in packages without access to React internals),\n// they are left as they are instead.\n\nfunction warn(format) {\n  {\n    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n      args[_key - 1] = arguments[_key];\n    }\n\n    printWarning('warn', format, args);\n  }\n}\nfunction error(format) {\n  {\n    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {\n      args[_key2 - 1] = arguments[_key2];\n    }\n\n    printWarning('error', format, args);\n  }\n}\n\nfunction printWarning(level, format, args) {\n  // When changing this logic, you might want to also\n  // update consoleWithStackDev.www.js as well.\n  {\n    var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;\n    var stack = ReactDebugCurrentFrame.getStackAddendum();\n\n    if (stack !== '') {\n      format += '%s';\n      args = args.concat([stack]);\n    }\n\n    var argsWithFormat = args.map(function (item) {\n      return '' + item;\n    }); // Careful: RN currently depends on this prefix\n\n    argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it\n    // breaks IE9: https://github.com/facebook/react/issues/13610\n    // eslint-disable-next-line react-internal/no-production-logging\n\n    Function.prototype.apply.call(console[level], console, argsWithFormat);\n  }\n}\n\n// ATTENTION\n// When adding new symbols to this file,\n// Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'\n// The Symbol used to tag the ReactElement-like types. If there is no native Symbol\n// nor polyfill, then a plain number is used for performance.\nvar REACT_ELEMENT_TYPE = 0xeac7;\nvar REACT_PORTAL_TYPE = 0xeaca;\nvar REACT_FRAGMENT_TYPE = 0xeacb;\nvar REACT_STRICT_MODE_TYPE = 0xeacc;\nvar REACT_PROFILER_TYPE = 0xead2;\nvar REACT_PROVIDER_TYPE = 0xeacd;\nvar REACT_CONTEXT_TYPE = 0xeace;\nvar REACT_FORWARD_REF_TYPE = 0xead0;\nvar REACT_SUSPENSE_TYPE = 0xead1;\nvar REACT_SUSPENSE_LIST_TYPE = 0xead8;\nvar REACT_MEMO_TYPE = 0xead3;\nvar REACT_LAZY_TYPE = 0xead4;\nvar REACT_BLOCK_TYPE = 0xead9;\nvar REACT_SERVER_BLOCK_TYPE = 0xeada;\nvar REACT_FUNDAMENTAL_TYPE = 0xead5;\nvar REACT_SCOPE_TYPE = 0xead7;\nvar REACT_OPAQUE_ID_TYPE = 0xeae0;\nvar REACT_DEBUG_TRACING_MODE_TYPE = 0xeae1;\nvar REACT_OFFSCREEN_TYPE = 0xeae2;\nvar REACT_LEGACY_HIDDEN_TYPE = 0xeae3;\n\nif (typeof Symbol === 'function' && Symbol.for) {\n  var symbolFor = Symbol.for;\n  REACT_ELEMENT_TYPE = symbolFor('react.element');\n  REACT_PORTAL_TYPE = symbolFor('react.portal');\n  REACT_FRAGMENT_TYPE = symbolFor('react.fragment');\n  REACT_STRICT_MODE_TYPE = symbolFor('react.strict_mode');\n  REACT_PROFILER_TYPE = symbolFor('react.profiler');\n  REACT_PROVIDER_TYPE = symbolFor('react.provider');\n  REACT_CONTEXT_TYPE = symbolFor('react.context');\n  REACT_FORWARD_REF_TYPE = symbolFor('react.forward_ref');\n  REACT_SUSPENSE_TYPE = symbolFor('react.suspense');\n  REACT_SUSPENSE_LIST_TYPE = symbolFor('react.suspense_list');\n  REACT_MEMO_TYPE = symbolFor('react.memo');\n  REACT_LAZY_TYPE = symbolFor('react.lazy');\n  REACT_BLOCK_TYPE = symbolFor('react.block');\n  REACT_SERVER_BLOCK_TYPE = symbolFor('react.server.block');\n  REACT_FUNDAMENTAL_TYPE = symbolFor('react.fundamental');\n  REACT_SCOPE_TYPE = symbolFor('react.scope');\n  REACT_OPAQUE_ID_TYPE = symbolFor('react.opaque.id');\n  REACT_DEBUG_TRACING_MODE_TYPE = symbolFor('react.debug_trace_mode');\n  REACT_OFFSCREEN_TYPE = symbolFor('react.offscreen');\n  REACT_LEGACY_HIDDEN_TYPE = symbolFor('react.legacy_hidden');\n}\n\nfunction getWrappedName(outerType, innerType, wrapperName) {\n  var functionName = innerType.displayName || innerType.name || '';\n  return outerType.displayName || (functionName !== '' ? wrapperName + \"(\" + functionName + \")\" : wrapperName);\n}\n\nfunction getContextName(type) {\n  return type.displayName || 'Context';\n}\n\nfunction getComponentName(type) {\n  if (type == null) {\n    // Host root, text node or just invalid type.\n    return null;\n  }\n\n  {\n    if (typeof type.tag === 'number') {\n      error('Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');\n    }\n  }\n\n  if (typeof type === 'function') {\n    return type.displayName || type.name || null;\n  }\n\n  if (typeof type === 'string') {\n    return type;\n  }\n\n  switch (type) {\n    case REACT_FRAGMENT_TYPE:\n      return 'Fragment';\n\n    case REACT_PORTAL_TYPE:\n      return 'Portal';\n\n    case REACT_PROFILER_TYPE:\n      return 'Profiler';\n\n    case REACT_STRICT_MODE_TYPE:\n      return 'StrictMode';\n\n    case REACT_SUSPENSE_TYPE:\n      return 'Suspense';\n\n    case REACT_SUSPENSE_LIST_TYPE:\n      return 'SuspenseList';\n  }\n\n  if (typeof type === 'object') {\n    switch (type.$$typeof) {\n      case REACT_CONTEXT_TYPE:\n        var context = type;\n        return getContextName(context) + '.Consumer';\n\n      case REACT_PROVIDER_TYPE:\n        var provider = type;\n        return getContextName(provider._context) + '.Provider';\n\n      case REACT_FORWARD_REF_TYPE:\n        return getWrappedName(type, type.render, 'ForwardRef');\n\n      case REACT_MEMO_TYPE:\n        return getComponentName(type.type);\n\n      case REACT_BLOCK_TYPE:\n        return getComponentName(type._render);\n\n      case REACT_LAZY_TYPE:\n        {\n          var lazyComponent = type;\n          var payload = lazyComponent._payload;\n          var init = lazyComponent._init;\n\n          try {\n            return getComponentName(init(payload));\n          } catch (x) {\n            return null;\n          }\n        }\n    }\n  }\n\n  return null;\n}\n\n// Filter certain DOM attributes (e.g. src, href) if their values are empty strings.\n\nvar enableSuspenseServerRenderer = false;\n\n// Helpers to patch console.logs to avoid logging during side-effect free\n// replaying on render function. This currently only patches the object\n// lazily which won't cover if the log function was extracted eagerly.\n// We could also eagerly patch the method.\nvar disabledDepth = 0;\nvar prevLog;\nvar prevInfo;\nvar prevWarn;\nvar prevError;\nvar prevGroup;\nvar prevGroupCollapsed;\nvar prevGroupEnd;\n\nfunction disabledLog() {}\n\ndisabledLog.__reactDisabledLog = true;\nfunction disableLogs() {\n  {\n    if (disabledDepth === 0) {\n      /* eslint-disable react-internal/no-production-logging */\n      prevLog = console.log;\n      prevInfo = console.info;\n      prevWarn = console.warn;\n      prevError = console.error;\n      prevGroup = console.group;\n      prevGroupCollapsed = console.groupCollapsed;\n      prevGroupEnd = console.groupEnd; // https://github.com/facebook/react/issues/19099\n\n      var props = {\n        configurable: true,\n        enumerable: true,\n        value: disabledLog,\n        writable: true\n      }; // $FlowFixMe Flow thinks console is immutable.\n\n      Object.defineProperties(console, {\n        info: props,\n        log: props,\n        warn: props,\n        error: props,\n        group: props,\n        groupCollapsed: props,\n        groupEnd: props\n      });\n      /* eslint-enable react-internal/no-production-logging */\n    }\n\n    disabledDepth++;\n  }\n}\nfunction reenableLogs() {\n  {\n    disabledDepth--;\n\n    if (disabledDepth === 0) {\n      /* eslint-disable react-internal/no-production-logging */\n      var props = {\n        configurable: true,\n        enumerable: true,\n        writable: true\n      }; // $FlowFixMe Flow thinks console is immutable.\n\n      Object.defineProperties(console, {\n        log: _assign({}, props, {\n          value: prevLog\n        }),\n        info: _assign({}, props, {\n          value: prevInfo\n        }),\n        warn: _assign({}, props, {\n          value: prevWarn\n        }),\n        error: _assign({}, props, {\n          value: prevError\n        }),\n        group: _assign({}, props, {\n          value: prevGroup\n        }),\n        groupCollapsed: _assign({}, props, {\n          value: prevGroupCollapsed\n        }),\n        groupEnd: _assign({}, props, {\n          value: prevGroupEnd\n        })\n      });\n      /* eslint-enable react-internal/no-production-logging */\n    }\n\n    if (disabledDepth < 0) {\n      error('disabledDepth fell below zero. ' + 'This is a bug in React. Please file an issue.');\n    }\n  }\n}\n\nvar ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;\nvar prefix;\nfunction describeBuiltInComponentFrame(name, source, ownerFn) {\n  {\n    if (prefix === undefined) {\n      // Extract the VM specific prefix used by each line.\n      try {\n        throw Error();\n      } catch (x) {\n        var match = x.stack.trim().match(/\\n( *(at )?)/);\n        prefix = match && match[1] || '';\n      }\n    } // We use the prefix to ensure our stacks line up with native stack frames.\n\n\n    return '\\n' + prefix + name;\n  }\n}\nvar reentry = false;\nvar componentFrameCache;\n\n{\n  var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;\n  componentFrameCache = new PossiblyWeakMap();\n}\n\nfunction describeNativeComponentFrame(fn, construct) {\n  // If something asked for a stack inside a fake render, it should get ignored.\n  if (!fn || reentry) {\n    return '';\n  }\n\n  {\n    var frame = componentFrameCache.get(fn);\n\n    if (frame !== undefined) {\n      return frame;\n    }\n  }\n\n  var control;\n  reentry = true;\n  var previousPrepareStackTrace = Error.prepareStackTrace; // $FlowFixMe It does accept undefined.\n\n  Error.prepareStackTrace = undefined;\n  var previousDispatcher;\n\n  {\n    previousDispatcher = ReactCurrentDispatcher.current; // Set the dispatcher in DEV because this might be call in the render function\n    // for warnings.\n\n    ReactCurrentDispatcher.current = null;\n    disableLogs();\n  }\n\n  try {\n    // This should throw.\n    if (construct) {\n      // Something should be setting the props in the constructor.\n      var Fake = function () {\n        throw Error();\n      }; // $FlowFixMe\n\n\n      Object.defineProperty(Fake.prototype, 'props', {\n        set: function () {\n          // We use a throwing setter instead of frozen or non-writable props\n          // because that won't throw in a non-strict mode function.\n          throw Error();\n        }\n      });\n\n      if (typeof Reflect === 'object' && Reflect.construct) {\n        // We construct a different control for this case to include any extra\n        // frames added by the construct call.\n        try {\n          Reflect.construct(Fake, []);\n        } catch (x) {\n          control = x;\n        }\n\n        Reflect.construct(fn, [], Fake);\n      } else {\n        try {\n          Fake.call();\n        } catch (x) {\n          control = x;\n        }\n\n        fn.call(Fake.prototype);\n      }\n    } else {\n      try {\n        throw Error();\n      } catch (x) {\n        control = x;\n      }\n\n      fn();\n    }\n  } catch (sample) {\n    // This is inlined manually because closure doesn't do it for us.\n    if (sample && control && typeof sample.stack === 'string') {\n      // This extracts the first frame from the sample that isn't also in the control.\n      // Skipping one frame that we assume is the frame that calls the two.\n      var sampleLines = sample.stack.split('\\n');\n      var controlLines = control.stack.split('\\n');\n      var s = sampleLines.length - 1;\n      var c = controlLines.length - 1;\n\n      while (s >= 1 && c >= 0 && sampleLines[s] !== controlLines[c]) {\n        // We expect at least one stack frame to be shared.\n        // Typically this will be the root most one. However, stack frames may be\n        // cut off due to maximum stack limits. In this case, one maybe cut off\n        // earlier than the other. We assume that the sample is longer or the same\n        // and there for cut off earlier. So we should find the root most frame in\n        // the sample somewhere in the control.\n        c--;\n      }\n\n      for (; s >= 1 && c >= 0; s--, c--) {\n        // Next we find the first one that isn't the same which should be the\n        // frame that called our sample function and the control.\n        if (sampleLines[s] !== controlLines[c]) {\n          // In V8, the first line is describing the message but other VMs don't.\n          // If we're about to return the first line, and the control is also on the same\n          // line, that's a pretty good indicator that our sample threw at same line as\n          // the control. I.e. before we entered the sample frame. So we ignore this result.\n          // This can happen if you passed a class to function component, or non-function.\n          if (s !== 1 || c !== 1) {\n            do {\n              s--;\n              c--; // We may still have similar intermediate frames from the construct call.\n              // The next one that isn't the same should be our match though.\n\n              if (c < 0 || sampleLines[s] !== controlLines[c]) {\n                // V8 adds a \"new\" prefix for native classes. Let's remove it to make it prettier.\n                var _frame = '\\n' + sampleLines[s].replace(' at new ', ' at ');\n\n                {\n                  if (typeof fn === 'function') {\n                    componentFrameCache.set(fn, _frame);\n                  }\n                } // Return the line we found.\n\n\n                return _frame;\n              }\n            } while (s >= 1 && c >= 0);\n          }\n\n          break;\n        }\n      }\n    }\n  } finally {\n    reentry = false;\n\n    {\n      ReactCurrentDispatcher.current = previousDispatcher;\n      reenableLogs();\n    }\n\n    Error.prepareStackTrace = previousPrepareStackTrace;\n  } // Fallback to just using the name if we couldn't make it throw.\n\n\n  var name = fn ? fn.displayName || fn.name : '';\n  var syntheticFrame = name ? describeBuiltInComponentFrame(name) : '';\n\n  {\n    if (typeof fn === 'function') {\n      componentFrameCache.set(fn, syntheticFrame);\n    }\n  }\n\n  return syntheticFrame;\n}\nfunction describeFunctionComponentFrame(fn, source, ownerFn) {\n  {\n    return describeNativeComponentFrame(fn, false);\n  }\n}\n\nfunction shouldConstruct(Component) {\n  var prototype = Component.prototype;\n  return !!(prototype && prototype.isReactComponent);\n}\n\nfunction describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {\n\n  if (type == null) {\n    return '';\n  }\n\n  if (typeof type === 'function') {\n    {\n      return describeNativeComponentFrame(type, shouldConstruct(type));\n    }\n  }\n\n  if (typeof type === 'string') {\n    return describeBuiltInComponentFrame(type);\n  }\n\n  switch (type) {\n    case REACT_SUSPENSE_TYPE:\n      return describeBuiltInComponentFrame('Suspense');\n\n    case REACT_SUSPENSE_LIST_TYPE:\n      return describeBuiltInComponentFrame('SuspenseList');\n  }\n\n  if (typeof type === 'object') {\n    switch (type.$$typeof) {\n      case REACT_FORWARD_REF_TYPE:\n        return describeFunctionComponentFrame(type.render);\n\n      case REACT_MEMO_TYPE:\n        // Memo may contain any component type so we recursively resolve it.\n        return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);\n\n      case REACT_BLOCK_TYPE:\n        return describeFunctionComponentFrame(type._render);\n\n      case REACT_LAZY_TYPE:\n        {\n          var lazyComponent = type;\n          var payload = lazyComponent._payload;\n          var init = lazyComponent._init;\n\n          try {\n            // Lazy may contain any component type so we recursively resolve it.\n            return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);\n          } catch (x) {}\n        }\n    }\n  }\n\n  return '';\n}\n\nvar loggedTypeFailures = {};\nvar ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;\n\nfunction setCurrentlyValidatingElement(element) {\n  {\n    if (element) {\n      var owner = element._owner;\n      var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);\n      ReactDebugCurrentFrame.setExtraStackFrame(stack);\n    } else {\n      ReactDebugCurrentFrame.setExtraStackFrame(null);\n    }\n  }\n}\n\nfunction checkPropTypes(typeSpecs, values, location, componentName, element) {\n  {\n    // $FlowFixMe This is okay but Flow doesn't know it.\n    var has = Function.call.bind(Object.prototype.hasOwnProperty);\n\n    for (var typeSpecName in typeSpecs) {\n      if (has(typeSpecs, typeSpecName)) {\n        var error$1 = void 0; // Prop type validation may throw. In case they do, we don't want to\n        // fail the render phase where it didn't fail before. So we log it.\n        // After these have been cleaned up, we'll let them throw.\n\n        try {\n          // This is intentionally an invariant that gets caught. It's the same\n          // behavior as without this statement except with a better message.\n          if (typeof typeSpecs[typeSpecName] !== 'function') {\n            var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');\n            err.name = 'Invariant Violation';\n            throw err;\n          }\n\n          error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED');\n        } catch (ex) {\n          error$1 = ex;\n        }\n\n        if (error$1 && !(error$1 instanceof Error)) {\n          setCurrentlyValidatingElement(element);\n\n          error('%s: type specification of %s' + ' `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error$1);\n\n          setCurrentlyValidatingElement(null);\n        }\n\n        if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {\n          // Only monitor this failure once because there tends to be a lot of the\n          // same error.\n          loggedTypeFailures[error$1.message] = true;\n          setCurrentlyValidatingElement(element);\n\n          error('Failed %s type: %s', location, error$1.message);\n\n          setCurrentlyValidatingElement(null);\n        }\n      }\n    }\n  }\n}\n\nvar didWarnAboutInvalidateContextType;\n\n{\n  didWarnAboutInvalidateContextType = new Set();\n}\n\nvar emptyObject = {};\n\n{\n  Object.freeze(emptyObject);\n}\n\nfunction maskContext(type, context) {\n  var contextTypes = type.contextTypes;\n\n  if (!contextTypes) {\n    return emptyObject;\n  }\n\n  var maskedContext = {};\n\n  for (var contextName in contextTypes) {\n    maskedContext[contextName] = context[contextName];\n  }\n\n  return maskedContext;\n}\n\nfunction checkContextTypes(typeSpecs, values, location) {\n  {\n    checkPropTypes(typeSpecs, values, location, 'Component');\n  }\n}\n\nfunction validateContextBounds(context, threadID) {\n  // If we don't have enough slots in this context to store this threadID,\n  // fill it in without leaving any holes to ensure that the VM optimizes\n  // this as non-holey index properties.\n  // (Note: If `react` package is < 16.6, _threadCount is undefined.)\n  for (var i = context._threadCount | 0; i <= threadID; i++) {\n    // We assume that this is the same as the defaultValue which might not be\n    // true if we're rendering inside a secondary renderer but they are\n    // secondary because these use cases are very rare.\n    context[i] = context._currentValue2;\n    context._threadCount = i + 1;\n  }\n}\nfunction processContext(type, context, threadID, isClass) {\n  if (isClass) {\n    var contextType = type.contextType;\n\n    {\n      if ('contextType' in type) {\n        var isValid = // Allow null for conditional declaration\n        contextType === null || contextType !== undefined && contextType.$$typeof === REACT_CONTEXT_TYPE && contextType._context === undefined; // Not a <Context.Consumer>\n\n        if (!isValid && !didWarnAboutInvalidateContextType.has(type)) {\n          didWarnAboutInvalidateContextType.add(type);\n          var addendum = '';\n\n          if (contextType === undefined) {\n            addendum = ' However, it is set to undefined. ' + 'This can be caused by a typo or by mixing up named and default imports. ' + 'This can also happen due to a circular dependency, so ' + 'try moving the createContext() call to a separate file.';\n          } else if (typeof contextType !== 'object') {\n            addendum = ' However, it is set to a ' + typeof contextType + '.';\n          } else if (contextType.$$typeof === REACT_PROVIDER_TYPE) {\n            addendum = ' Did you accidentally pass the Context.Provider instead?';\n          } else if (contextType._context !== undefined) {\n            // <Context.Consumer>\n            addendum = ' Did you accidentally pass the Context.Consumer instead?';\n          } else {\n            addendum = ' However, it is set to an object with keys {' + Object.keys(contextType).join(', ') + '}.';\n          }\n\n          error('%s defines an invalid contextType. ' + 'contextType should point to the Context object returned by React.createContext().%s', getComponentName(type) || 'Component', addendum);\n        }\n      }\n    }\n\n    if (typeof contextType === 'object' && contextType !== null) {\n      validateContextBounds(contextType, threadID);\n      return contextType[threadID];\n    }\n\n    {\n      var maskedContext = maskContext(type, context);\n\n      {\n        if (type.contextTypes) {\n          checkContextTypes(type.contextTypes, maskedContext, 'context');\n        }\n      }\n\n      return maskedContext;\n    }\n  } else {\n    {\n      var _maskedContext = maskContext(type, context);\n\n      {\n        if (type.contextTypes) {\n          checkContextTypes(type.contextTypes, _maskedContext, 'context');\n        }\n      }\n\n      return _maskedContext;\n    }\n  }\n}\n\nvar nextAvailableThreadIDs = new Uint16Array(16);\n\nfor (var i = 0; i < 15; i++) {\n  nextAvailableThreadIDs[i] = i + 1;\n}\n\nnextAvailableThreadIDs[15] = 0;\n\nfunction growThreadCountAndReturnNextAvailable() {\n  var oldArray = nextAvailableThreadIDs;\n  var oldSize = oldArray.length;\n  var newSize = oldSize * 2;\n\n  if (!(newSize <= 0x10000)) {\n    {\n      throw Error( \"Maximum number of concurrent React renderers exceeded. This can happen if you are not properly destroying the Readable provided by React. Ensure that you call .destroy() on it if you no longer want to read from it, and did not read to the end. If you use .pipe() this should be automatic.\" );\n    }\n  }\n\n  var newArray = new Uint16Array(newSize);\n  newArray.set(oldArray);\n  nextAvailableThreadIDs = newArray;\n  nextAvailableThreadIDs[0] = oldSize + 1;\n\n  for (var _i = oldSize; _i < newSize - 1; _i++) {\n    nextAvailableThreadIDs[_i] = _i + 1;\n  }\n\n  nextAvailableThreadIDs[newSize - 1] = 0;\n  return oldSize;\n}\n\nfunction allocThreadID() {\n  var nextID = nextAvailableThreadIDs[0];\n\n  if (nextID === 0) {\n    return growThreadCountAndReturnNextAvailable();\n  }\n\n  nextAvailableThreadIDs[0] = nextAvailableThreadIDs[nextID];\n  return nextID;\n}\nfunction freeThreadID(id) {\n  nextAvailableThreadIDs[id] = nextAvailableThreadIDs[0];\n  nextAvailableThreadIDs[0] = id;\n}\n\n// A reserved attribute.\n// It is handled by React separately and shouldn't be written to the DOM.\nvar RESERVED = 0; // A simple string attribute.\n// Attributes that aren't in the filter are presumed to have this type.\n\nvar STRING = 1; // A string attribute that accepts booleans in React. In HTML, these are called\n// \"enumerated\" attributes with \"true\" and \"false\" as possible values.\n// When true, it should be set to a \"true\" string.\n// When false, it should be set to a \"false\" string.\n\nvar BOOLEANISH_STRING = 2; // A real boolean attribute.\n// When true, it should be present (set either to an empty string or its name).\n// When false, it should be omitted.\n\nvar BOOLEAN = 3; // An attribute that can be used as a flag as well as with a value.\n// When true, it should be present (set either to an empty string or its name).\n// When false, it should be omitted.\n// For any other value, should be present with that value.\n\nvar OVERLOADED_BOOLEAN = 4; // An attribute that must be numeric or parse as a numeric.\n// When falsy, it should be removed.\n\nvar NUMERIC = 5; // An attribute that must be positive numeric or parse as a positive numeric.\n// When falsy, it should be removed.\n\nvar POSITIVE_NUMERIC = 6;\n\n/* eslint-disable max-len */\nvar ATTRIBUTE_NAME_START_CHAR = \":A-Z_a-z\\\\u00C0-\\\\u00D6\\\\u00D8-\\\\u00F6\\\\u00F8-\\\\u02FF\\\\u0370-\\\\u037D\\\\u037F-\\\\u1FFF\\\\u200C-\\\\u200D\\\\u2070-\\\\u218F\\\\u2C00-\\\\u2FEF\\\\u3001-\\\\uD7FF\\\\uF900-\\\\uFDCF\\\\uFDF0-\\\\uFFFD\";\n/* eslint-enable max-len */\n\nvar ATTRIBUTE_NAME_CHAR = ATTRIBUTE_NAME_START_CHAR + \"\\\\-.0-9\\\\u00B7\\\\u0300-\\\\u036F\\\\u203F-\\\\u2040\";\nvar ROOT_ATTRIBUTE_NAME = 'data-reactroot';\nvar VALID_ATTRIBUTE_NAME_REGEX = new RegExp('^[' + ATTRIBUTE_NAME_START_CHAR + '][' + ATTRIBUTE_NAME_CHAR + ']*$');\nvar hasOwnProperty = Object.prototype.hasOwnProperty;\nvar illegalAttributeNameCache = {};\nvar validatedAttributeNameCache = {};\nfunction isAttributeNameSafe(attributeName) {\n  if (hasOwnProperty.call(validatedAttributeNameCache, attributeName)) {\n    return true;\n  }\n\n  if (hasOwnProperty.call(illegalAttributeNameCache, attributeName)) {\n    return false;\n  }\n\n  if (VALID_ATTRIBUTE_NAME_REGEX.test(attributeName)) {\n    validatedAttributeNameCache[attributeName] = true;\n    return true;\n  }\n\n  illegalAttributeNameCache[attributeName] = true;\n\n  {\n    error('Invalid attribute name: `%s`', attributeName);\n  }\n\n  return false;\n}\nfunction shouldIgnoreAttribute(name, propertyInfo, isCustomComponentTag) {\n  if (propertyInfo !== null) {\n    return propertyInfo.type === RESERVED;\n  }\n\n  if (isCustomComponentTag) {\n    return false;\n  }\n\n  if (name.length > 2 && (name[0] === 'o' || name[0] === 'O') && (name[1] === 'n' || name[1] === 'N')) {\n    return true;\n  }\n\n  return false;\n}\nfunction shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag) {\n  if (propertyInfo !== null && propertyInfo.type === RESERVED) {\n    return false;\n  }\n\n  switch (typeof value) {\n    case 'function': // $FlowIssue symbol is perfectly valid here\n\n    case 'symbol':\n      // eslint-disable-line\n      return true;\n\n    case 'boolean':\n      {\n        if (isCustomComponentTag) {\n          return false;\n        }\n\n        if (propertyInfo !== null) {\n          return !propertyInfo.acceptsBooleans;\n        } else {\n          var prefix = name.toLowerCase().slice(0, 5);\n          return prefix !== 'data-' && prefix !== 'aria-';\n        }\n      }\n\n    default:\n      return false;\n  }\n}\nfunction shouldRemoveAttribute(name, value, propertyInfo, isCustomComponentTag) {\n  if (value === null || typeof value === 'undefined') {\n    return true;\n  }\n\n  if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag)) {\n    return true;\n  }\n\n  if (isCustomComponentTag) {\n    return false;\n  }\n\n  if (propertyInfo !== null) {\n\n    switch (propertyInfo.type) {\n      case BOOLEAN:\n        return !value;\n\n      case OVERLOADED_BOOLEAN:\n        return value === false;\n\n      case NUMERIC:\n        return isNaN(value);\n\n      case POSITIVE_NUMERIC:\n        return isNaN(value) || value < 1;\n    }\n  }\n\n  return false;\n}\nfunction getPropertyInfo(name) {\n  return properties.hasOwnProperty(name) ? properties[name] : null;\n}\n\nfunction PropertyInfoRecord(name, type, mustUseProperty, attributeName, attributeNamespace, sanitizeURL, removeEmptyString) {\n  this.acceptsBooleans = type === BOOLEANISH_STRING || type === BOOLEAN || type === OVERLOADED_BOOLEAN;\n  this.attributeName = attributeName;\n  this.attributeNamespace = attributeNamespace;\n  this.mustUseProperty = mustUseProperty;\n  this.propertyName = name;\n  this.type = type;\n  this.sanitizeURL = sanitizeURL;\n  this.removeEmptyString = removeEmptyString;\n} // When adding attributes to this list, be sure to also add them to\n// the `possibleStandardNames` module to ensure casing and incorrect\n// name warnings.\n\n\nvar properties = {}; // These props are reserved by React. They shouldn't be written to the DOM.\n\nvar reservedProps = ['children', 'dangerouslySetInnerHTML', // TODO: This prevents the assignment of defaultValue to regular\n// elements (not just inputs). Now that ReactDOMInput assigns to the\n// defaultValue property -- do we need this?\n'defaultValue', 'defaultChecked', 'innerHTML', 'suppressContentEditableWarning', 'suppressHydrationWarning', 'style'];\nreservedProps.forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, RESERVED, false, // mustUseProperty\n  name, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // A few React string attributes have a different name.\n// This is a mapping from React prop names to the attribute names.\n\n[['acceptCharset', 'accept-charset'], ['className', 'class'], ['htmlFor', 'for'], ['httpEquiv', 'http-equiv']].forEach(function (_ref) {\n  var name = _ref[0],\n      attributeName = _ref[1];\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\n  attributeName, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are \"enumerated\" HTML attributes that accept \"true\" and \"false\".\n// In React, we let users pass `true` and `false` even though technically\n// these aren't boolean attributes (they are coerced to strings).\n\n['contentEditable', 'draggable', 'spellCheck', 'value'].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty\n  name.toLowerCase(), // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are \"enumerated\" SVG attributes that accept \"true\" and \"false\".\n// In React, we let users pass `true` and `false` even though technically\n// these aren't boolean attributes (they are coerced to strings).\n// Since these are SVG attributes, their attribute names are case-sensitive.\n\n['autoReverse', 'externalResourcesRequired', 'focusable', 'preserveAlpha'].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty\n  name, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are HTML boolean attributes.\n\n['allowFullScreen', 'async', // Note: there is a special case that prevents it from being written to the DOM\n// on the client side because the browsers are inconsistent. Instead we call focus().\n'autoFocus', 'autoPlay', 'controls', 'default', 'defer', 'disabled', 'disablePictureInPicture', 'disableRemotePlayback', 'formNoValidate', 'hidden', 'loop', 'noModule', 'noValidate', 'open', 'playsInline', 'readOnly', 'required', 'reversed', 'scoped', 'seamless', // Microdata\n'itemScope'].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, BOOLEAN, false, // mustUseProperty\n  name.toLowerCase(), // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are the few React props that we set as DOM properties\n// rather than attributes. These are all booleans.\n\n['checked', // Note: `option.selected` is not updated if `select.multiple` is\n// disabled with `removeAttribute`. We have special logic for handling this.\n'multiple', 'muted', 'selected' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, BOOLEAN, true, // mustUseProperty\n  name, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are HTML attributes that are \"overloaded booleans\": they behave like\n// booleans, but can also accept a string value.\n\n['capture', 'download' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, OVERLOADED_BOOLEAN, false, // mustUseProperty\n  name, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are HTML attributes that must be positive numbers.\n\n['cols', 'rows', 'size', 'span' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, POSITIVE_NUMERIC, false, // mustUseProperty\n  name, // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These are HTML attributes that must be numbers.\n\n['rowSpan', 'start'].forEach(function (name) {\n  properties[name] = new PropertyInfoRecord(name, NUMERIC, false, // mustUseProperty\n  name.toLowerCase(), // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n});\nvar CAMELIZE = /[\\-\\:]([a-z])/g;\n\nvar capitalize = function (token) {\n  return token[1].toUpperCase();\n}; // This is a list of all SVG attributes that need special casing, namespacing,\n// or boolean value assignment. Regular attributes that just accept strings\n// and have the same names are omitted, just like in the HTML attribute filter.\n// Some of these attributes can be hard to find. This list was created by\n// scraping the MDN documentation.\n\n\n['accent-height', 'alignment-baseline', 'arabic-form', 'baseline-shift', 'cap-height', 'clip-path', 'clip-rule', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'dominant-baseline', 'enable-background', 'fill-opacity', 'fill-rule', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'glyph-name', 'glyph-orientation-horizontal', 'glyph-orientation-vertical', 'horiz-adv-x', 'horiz-origin-x', 'image-rendering', 'letter-spacing', 'lighting-color', 'marker-end', 'marker-mid', 'marker-start', 'overline-position', 'overline-thickness', 'paint-order', 'panose-1', 'pointer-events', 'rendering-intent', 'shape-rendering', 'stop-color', 'stop-opacity', 'strikethrough-position', 'strikethrough-thickness', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'text-anchor', 'text-decoration', 'text-rendering', 'underline-position', 'underline-thickness', 'unicode-bidi', 'unicode-range', 'units-per-em', 'v-alphabetic', 'v-hanging', 'v-ideographic', 'v-mathematical', 'vector-effect', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'word-spacing', 'writing-mode', 'xmlns:xlink', 'x-height' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (attributeName) {\n  var name = attributeName.replace(CAMELIZE, capitalize);\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\n  attributeName, null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // String SVG attributes with the xlink namespace.\n\n['xlink:actuate', 'xlink:arcrole', 'xlink:role', 'xlink:show', 'xlink:title', 'xlink:type' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (attributeName) {\n  var name = attributeName.replace(CAMELIZE, capitalize);\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\n  attributeName, 'http://www.w3.org/1999/xlink', false, // sanitizeURL\n  false);\n}); // String SVG attributes with the xml namespace.\n\n['xml:base', 'xml:lang', 'xml:space' // NOTE: if you add a camelCased prop to this list,\n// you'll need to set attributeName to name.toLowerCase()\n// instead in the assignment below.\n].forEach(function (attributeName) {\n  var name = attributeName.replace(CAMELIZE, capitalize);\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\n  attributeName, 'http://www.w3.org/XML/1998/namespace', false, // sanitizeURL\n  false);\n}); // These attribute exists both in HTML and SVG.\n// The attribute name is case-sensitive in SVG so we can't just use\n// the React name like we do for attributes that exist only in HTML.\n\n['tabIndex', 'crossOrigin'].forEach(function (attributeName) {\n  properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty\n  attributeName.toLowerCase(), // attributeName\n  null, // attributeNamespace\n  false, // sanitizeURL\n  false);\n}); // These attributes accept URLs. These must not allow javascript: URLS.\n// These will also need to accept Trusted Types object in the future.\n\nvar xlinkHref = 'xlinkHref';\nproperties[xlinkHref] = new PropertyInfoRecord('xlinkHref', STRING, false, // mustUseProperty\n'xlink:href', 'http://www.w3.org/1999/xlink', true, // sanitizeURL\nfalse);\n['src', 'href', 'action', 'formAction'].forEach(function (attributeName) {\n  properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty\n  attributeName.toLowerCase(), // attributeName\n  null, // attributeNamespace\n  true, // sanitizeURL\n  true);\n});\n\n// and any newline or tab are filtered out as if they're not part of the URL.\n// https://url.spec.whatwg.org/#url-parsing\n// Tab or newline are defined as \\r\\n\\t:\n// https://infra.spec.whatwg.org/#ascii-tab-or-newline\n// A C0 control is a code point in the range \\u0000 NULL to \\u001F\n// INFORMATION SEPARATOR ONE, inclusive:\n// https://infra.spec.whatwg.org/#c0-control-or-space\n\n/* eslint-disable max-len */\n\nvar isJavaScriptProtocol = /^[\\u0000-\\u001F ]*j[\\r\\n\\t]*a[\\r\\n\\t]*v[\\r\\n\\t]*a[\\r\\n\\t]*s[\\r\\n\\t]*c[\\r\\n\\t]*r[\\r\\n\\t]*i[\\r\\n\\t]*p[\\r\\n\\t]*t[\\r\\n\\t]*\\:/i;\nvar didWarn = false;\n\nfunction sanitizeURL(url) {\n  {\n    if (!didWarn && isJavaScriptProtocol.test(url)) {\n      didWarn = true;\n\n      error('A future version of React will block javascript: URLs as a security precaution. ' + 'Use event handlers instead if you can. If you need to generate unsafe HTML try ' + 'using dangerouslySetInnerHTML instead. React was passed %s.', JSON.stringify(url));\n    }\n  }\n}\n\n// code copied and modified from escape-html\n\n/**\n * Module variables.\n * @private\n */\nvar matchHtmlRegExp = /[\"'&<>]/;\n/**\n * Escapes special characters and HTML entities in a given html string.\n *\n * @param  {string} string HTML string to escape for later insertion\n * @return {string}\n * @public\n */\n\nfunction escapeHtml(string) {\n  var str = '' + string;\n  var match = matchHtmlRegExp.exec(str);\n\n  if (!match) {\n    return str;\n  }\n\n  var escape;\n  var html = '';\n  var index;\n  var lastIndex = 0;\n\n  for (index = match.index; index < str.length; index++) {\n    switch (str.charCodeAt(index)) {\n      case 34:\n        // \"\n        escape = '&quot;';\n        break;\n\n      case 38:\n        // &\n        escape = '&amp;';\n        break;\n\n      case 39:\n        // '\n        escape = '&#x27;'; // modified from escape-html; used to be '&#39'\n\n        break;\n\n      case 60:\n        // <\n        escape = '&lt;';\n        break;\n\n      case 62:\n        // >\n        escape = '&gt;';\n        break;\n\n      default:\n        continue;\n    }\n\n    if (lastIndex !== index) {\n      html += str.substring(lastIndex, index);\n    }\n\n    lastIndex = index + 1;\n    html += escape;\n  }\n\n  return lastIndex !== index ? html + str.substring(lastIndex, index) : html;\n} // end code copied and modified from escape-html\n\n/**\n * Escapes text to prevent scripting attacks.\n *\n * @param {*} text Text value to escape.\n * @return {string} An escaped string.\n */\n\n\nfunction escapeTextForBrowser(text) {\n  if (typeof text === 'boolean' || typeof text === 'number') {\n    // this shortcircuit helps perf for types that we know will never have\n    // special characters, especially given that this function is used often\n    // for numeric dom ids.\n    return '' + text;\n  }\n\n  return escapeHtml(text);\n}\n\n/**\n * Escapes attribute value to prevent scripting attacks.\n *\n * @param {*} value Value to escape.\n * @return {string} An escaped string.\n */\n\nfunction quoteAttributeValueForBrowser(value) {\n  return '\"' + escapeTextForBrowser(value) + '\"';\n}\n\nfunction createMarkupForRoot() {\n  return ROOT_ATTRIBUTE_NAME + '=\"\"';\n}\n/**\n * Creates markup for a property.\n *\n * @param {string} name\n * @param {*} value\n * @return {?string} Markup string, or null if the property was invalid.\n */\n\nfunction createMarkupForProperty(name, value) {\n  var propertyInfo = getPropertyInfo(name);\n\n  if (name !== 'style' && shouldIgnoreAttribute(name, propertyInfo, false)) {\n    return '';\n  }\n\n  if (shouldRemoveAttribute(name, value, propertyInfo, false)) {\n    return '';\n  }\n\n  if (propertyInfo !== null) {\n    var attributeName = propertyInfo.attributeName;\n    var type = propertyInfo.type;\n\n    if (type === BOOLEAN || type === OVERLOADED_BOOLEAN && value === true) {\n      return attributeName + '=\"\"';\n    } else {\n      if (propertyInfo.sanitizeURL) {\n        value = '' + value;\n        sanitizeURL(value);\n      }\n\n      return attributeName + '=' + quoteAttributeValueForBrowser(value);\n    }\n  } else if (isAttributeNameSafe(name)) {\n    return name + '=' + quoteAttributeValueForBrowser(value);\n  }\n\n  return '';\n}\n/**\n * Creates markup for a custom property.\n *\n * @param {string} name\n * @param {*} value\n * @return {string} Markup string, or empty string if the property was invalid.\n */\n\nfunction createMarkupForCustomAttribute(name, value) {\n  if (!isAttributeNameSafe(name) || value == null) {\n    return '';\n  }\n\n  return name + '=' + quoteAttributeValueForBrowser(value);\n}\n\n/**\n * inlined Object.is polyfill to avoid requiring consumers ship their own\n * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is\n */\nfunction is(x, y) {\n  return x === y && (x !== 0 || 1 / x === 1 / y) || x !== x && y !== y // eslint-disable-line no-self-compare\n  ;\n}\n\nvar objectIs = typeof Object.is === 'function' ? Object.is : is;\n\nvar currentlyRenderingComponent = null;\nvar firstWorkInProgressHook = null;\nvar workInProgressHook = null; // Whether the work-in-progress hook is a re-rendered hook\n\nvar isReRender = false; // Whether an update was scheduled during the currently executing render pass.\n\nvar didScheduleRenderPhaseUpdate = false; // Lazily created map of render-phase updates\n\nvar renderPhaseUpdates = null; // Counter to prevent infinite loops.\n\nvar numberOfReRenders = 0;\nvar RE_RENDER_LIMIT = 25;\nvar isInHookUserCodeInDev = false; // In DEV, this is the name of the currently executing primitive hook\n\nvar currentHookNameInDev;\n\nfunction resolveCurrentlyRenderingComponent() {\n  if (!(currentlyRenderingComponent !== null)) {\n    {\n      throw Error( \"Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\\n1. You might have mismatching versions of React and the renderer (such as React DOM)\\n2. You might be breaking the Rules of Hooks\\n3. You might have more than one copy of React in the same app\\nSee https://reactjs.org/link/invalid-hook-call for tips about how to debug and fix this problem.\" );\n    }\n  }\n\n  {\n    if (isInHookUserCodeInDev) {\n      error('Do not call Hooks inside useEffect(...), useMemo(...), or other built-in Hooks. ' + 'You can only call Hooks at the top level of your React function. ' + 'For more information, see ' + 'https://reactjs.org/link/rules-of-hooks');\n    }\n  }\n\n  return currentlyRenderingComponent;\n}\n\nfunction areHookInputsEqual(nextDeps, prevDeps) {\n  if (prevDeps === null) {\n    {\n      error('%s received a final argument during this render, but not during ' + 'the previous render. Even though the final argument is optional, ' + 'its type cannot change between renders.', currentHookNameInDev);\n    }\n\n    return false;\n  }\n\n  {\n    // Don't bother comparing lengths in prod because these arrays should be\n    // passed inline.\n    if (nextDeps.length !== prevDeps.length) {\n      error('The final argument passed to %s changed size between renders. The ' + 'order and size of this array must remain constant.\\n\\n' + 'Previous: %s\\n' + 'Incoming: %s', currentHookNameInDev, \"[\" + nextDeps.join(', ') + \"]\", \"[\" + prevDeps.join(', ') + \"]\");\n    }\n  }\n\n  for (var i = 0; i < prevDeps.length && i < nextDeps.length; i++) {\n    if (objectIs(nextDeps[i], prevDeps[i])) {\n      continue;\n    }\n\n    return false;\n  }\n\n  return true;\n}\n\nfunction createHook() {\n  if (numberOfReRenders > 0) {\n    {\n      {\n        throw Error( \"Rendered more hooks than during the previous render\" );\n      }\n    }\n  }\n\n  return {\n    memoizedState: null,\n    queue: null,\n    next: null\n  };\n}\n\nfunction createWorkInProgressHook() {\n  if (workInProgressHook === null) {\n    // This is the first hook in the list\n    if (firstWorkInProgressHook === null) {\n      isReRender = false;\n      firstWorkInProgressHook = workInProgressHook = createHook();\n    } else {\n      // There's already a work-in-progress. Reuse it.\n      isReRender = true;\n      workInProgressHook = firstWorkInProgressHook;\n    }\n  } else {\n    if (workInProgressHook.next === null) {\n      isReRender = false; // Append to the end of the list\n\n      workInProgressHook = workInProgressHook.next = createHook();\n    } else {\n      // There's already a work-in-progress. Reuse it.\n      isReRender = true;\n      workInProgressHook = workInProgressHook.next;\n    }\n  }\n\n  return workInProgressHook;\n}\n\nfunction prepareToUseHooks(componentIdentity) {\n  currentlyRenderingComponent = componentIdentity;\n\n  {\n    isInHookUserCodeInDev = false;\n  } // The following should have already been reset\n  // didScheduleRenderPhaseUpdate = false;\n  // firstWorkInProgressHook = null;\n  // numberOfReRenders = 0;\n  // renderPhaseUpdates = null;\n  // workInProgressHook = null;\n\n}\nfunction finishHooks(Component, props, children, refOrContext) {\n  // This must be called after every function component to prevent hooks from\n  // being used in classes.\n  while (didScheduleRenderPhaseUpdate) {\n    // Updates were scheduled during the render phase. They are stored in\n    // the `renderPhaseUpdates` map. Call the component again, reusing the\n    // work-in-progress hooks and applying the additional updates on top. Keep\n    // restarting until no more updates are scheduled.\n    didScheduleRenderPhaseUpdate = false;\n    numberOfReRenders += 1; // Start over from the beginning of the list\n\n    workInProgressHook = null;\n    children = Component(props, refOrContext);\n  }\n\n  resetHooksState();\n  return children;\n} // Reset the internal hooks state if an error occurs while rendering a component\n\nfunction resetHooksState() {\n  {\n    isInHookUserCodeInDev = false;\n  }\n\n  currentlyRenderingComponent = null;\n  didScheduleRenderPhaseUpdate = false;\n  firstWorkInProgressHook = null;\n  numberOfReRenders = 0;\n  renderPhaseUpdates = null;\n  workInProgressHook = null;\n}\n\nfunction readContext(context, observedBits) {\n  var threadID = currentPartialRenderer.threadID;\n  validateContextBounds(context, threadID);\n\n  {\n    if (isInHookUserCodeInDev) {\n      error('Context can only be read while React is rendering. ' + 'In classes, you can read it in the render method or getDerivedStateFromProps. ' + 'In function components, you can read it directly in the function body, but not ' + 'inside Hooks like useReducer() or useMemo().');\n    }\n  }\n\n  return context[threadID];\n}\n\nfunction useContext(context, observedBits) {\n  {\n    currentHookNameInDev = 'useContext';\n  }\n\n  resolveCurrentlyRenderingComponent();\n  var threadID = currentPartialRenderer.threadID;\n  validateContextBounds(context, threadID);\n  return context[threadID];\n}\n\nfunction basicStateReducer(state, action) {\n  // $FlowFixMe: Flow doesn't like mixed types\n  return typeof action === 'function' ? action(state) : action;\n}\n\nfunction useState(initialState) {\n  {\n    currentHookNameInDev = 'useState';\n  }\n\n  return useReducer(basicStateReducer, // useReducer has a special case to support lazy useState initializers\n  initialState);\n}\nfunction useReducer(reducer, initialArg, init) {\n  {\n    if (reducer !== basicStateReducer) {\n      currentHookNameInDev = 'useReducer';\n    }\n  }\n\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\n  workInProgressHook = createWorkInProgressHook();\n\n  if (isReRender) {\n    // This is a re-render. Apply the new render phase updates to the previous\n    // current hook.\n    var queue = workInProgressHook.queue;\n    var dispatch = queue.dispatch;\n\n    if (renderPhaseUpdates !== null) {\n      // Render phase updates are stored in a map of queue -> linked list\n      var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);\n\n      if (firstRenderPhaseUpdate !== undefined) {\n        renderPhaseUpdates.delete(queue);\n        var newState = workInProgressHook.memoizedState;\n        var update = firstRenderPhaseUpdate;\n\n        do {\n          // Process this render phase update. We don't have to check the\n          // priority because it will always be the same as the current\n          // render's.\n          var action = update.action;\n\n          {\n            isInHookUserCodeInDev = true;\n          }\n\n          newState = reducer(newState, action);\n\n          {\n            isInHookUserCodeInDev = false;\n          }\n\n          update = update.next;\n        } while (update !== null);\n\n        workInProgressHook.memoizedState = newState;\n        return [newState, dispatch];\n      }\n    }\n\n    return [workInProgressHook.memoizedState, dispatch];\n  } else {\n    {\n      isInHookUserCodeInDev = true;\n    }\n\n    var initialState;\n\n    if (reducer === basicStateReducer) {\n      // Special case for `useState`.\n      initialState = typeof initialArg === 'function' ? initialArg() : initialArg;\n    } else {\n      initialState = init !== undefined ? init(initialArg) : initialArg;\n    }\n\n    {\n      isInHookUserCodeInDev = false;\n    }\n\n    workInProgressHook.memoizedState = initialState;\n\n    var _queue = workInProgressHook.queue = {\n      last: null,\n      dispatch: null\n    };\n\n    var _dispatch = _queue.dispatch = dispatchAction.bind(null, currentlyRenderingComponent, _queue);\n\n    return [workInProgressHook.memoizedState, _dispatch];\n  }\n}\n\nfunction useMemo(nextCreate, deps) {\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\n  workInProgressHook = createWorkInProgressHook();\n  var nextDeps = deps === undefined ? null : deps;\n\n  if (workInProgressHook !== null) {\n    var prevState = workInProgressHook.memoizedState;\n\n    if (prevState !== null) {\n      if (nextDeps !== null) {\n        var prevDeps = prevState[1];\n\n        if (areHookInputsEqual(nextDeps, prevDeps)) {\n          return prevState[0];\n        }\n      }\n    }\n  }\n\n  {\n    isInHookUserCodeInDev = true;\n  }\n\n  var nextValue = nextCreate();\n\n  {\n    isInHookUserCodeInDev = false;\n  }\n\n  workInProgressHook.memoizedState = [nextValue, nextDeps];\n  return nextValue;\n}\n\nfunction useRef(initialValue) {\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\n  workInProgressHook = createWorkInProgressHook();\n  var previousRef = workInProgressHook.memoizedState;\n\n  if (previousRef === null) {\n    var ref = {\n      current: initialValue\n    };\n\n    {\n      Object.seal(ref);\n    }\n\n    workInProgressHook.memoizedState = ref;\n    return ref;\n  } else {\n    return previousRef;\n  }\n}\n\nfunction useLayoutEffect(create, inputs) {\n  {\n    currentHookNameInDev = 'useLayoutEffect';\n\n    error('useLayoutEffect does nothing on the server, because its effect cannot ' + \"be encoded into the server renderer's output format. This will lead \" + 'to a mismatch between the initial, non-hydrated UI and the intended ' + 'UI. To avoid this, useLayoutEffect should only be used in ' + 'components that render exclusively on the client. ' + 'See https://reactjs.org/link/uselayouteffect-ssr for common fixes.');\n  }\n}\n\nfunction dispatchAction(componentIdentity, queue, action) {\n  if (!(numberOfReRenders < RE_RENDER_LIMIT)) {\n    {\n      throw Error( \"Too many re-renders. React limits the number of renders to prevent an infinite loop.\" );\n    }\n  }\n\n  if (componentIdentity === currentlyRenderingComponent) {\n    // This is a render phase update. Stash it in a lazily-created map of\n    // queue -> linked list of updates. After this render pass, we'll restart\n    // and apply the stashed updates on top of the work-in-progress hook.\n    didScheduleRenderPhaseUpdate = true;\n    var update = {\n      action: action,\n      next: null\n    };\n\n    if (renderPhaseUpdates === null) {\n      renderPhaseUpdates = new Map();\n    }\n\n    var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);\n\n    if (firstRenderPhaseUpdate === undefined) {\n      renderPhaseUpdates.set(queue, update);\n    } else {\n      // Append the update to the end of the list.\n      var lastRenderPhaseUpdate = firstRenderPhaseUpdate;\n\n      while (lastRenderPhaseUpdate.next !== null) {\n        lastRenderPhaseUpdate = lastRenderPhaseUpdate.next;\n      }\n\n      lastRenderPhaseUpdate.next = update;\n    }\n  }\n}\n\nfunction useCallback(callback, deps) {\n  return useMemo(function () {\n    return callback;\n  }, deps);\n} // TODO Decide on how to implement this hook for server rendering.\n// If a mutation occurs during render, consider triggering a Suspense boundary\n// and falling back to client rendering.\n\nfunction useMutableSource(source, getSnapshot, subscribe) {\n  resolveCurrentlyRenderingComponent();\n  return getSnapshot(source._source);\n}\n\nfunction useDeferredValue(value) {\n  resolveCurrentlyRenderingComponent();\n  return value;\n}\n\nfunction useTransition() {\n  resolveCurrentlyRenderingComponent();\n\n  var startTransition = function (callback) {\n    callback();\n  };\n\n  return [startTransition, false];\n}\n\nfunction useOpaqueIdentifier() {\n  return (currentPartialRenderer.identifierPrefix || '') + 'R:' + (currentPartialRenderer.uniqueID++).toString(36);\n}\n\nfunction noop() {}\n\nvar currentPartialRenderer = null;\nfunction setCurrentPartialRenderer(renderer) {\n  currentPartialRenderer = renderer;\n}\nvar Dispatcher = {\n  readContext: readContext,\n  useContext: useContext,\n  useMemo: useMemo,\n  useReducer: useReducer,\n  useRef: useRef,\n  useState: useState,\n  useLayoutEffect: useLayoutEffect,\n  useCallback: useCallback,\n  // useImperativeHandle is not run in the server environment\n  useImperativeHandle: noop,\n  // Effects are not run in the server environment.\n  useEffect: noop,\n  // Debugging effect\n  useDebugValue: noop,\n  useDeferredValue: useDeferredValue,\n  useTransition: useTransition,\n  useOpaqueIdentifier: useOpaqueIdentifier,\n  // Subscriptions are not setup in a server environment.\n  useMutableSource: useMutableSource\n};\n\nvar HTML_NAMESPACE = 'http://www.w3.org/1999/xhtml';\nvar MATH_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';\nvar SVG_NAMESPACE = 'http://www.w3.org/2000/svg';\nvar Namespaces = {\n  html: HTML_NAMESPACE,\n  mathml: MATH_NAMESPACE,\n  svg: SVG_NAMESPACE\n}; // Assumes there is no parent namespace.\n\nfunction getIntrinsicNamespace(type) {\n  switch (type) {\n    case 'svg':\n      return SVG_NAMESPACE;\n\n    case 'math':\n      return MATH_NAMESPACE;\n\n    default:\n      return HTML_NAMESPACE;\n  }\n}\nfunction getChildNamespace(parentNamespace, type) {\n  if (parentNamespace == null || parentNamespace === HTML_NAMESPACE) {\n    // No (or default) parent namespace: potential entry point.\n    return getIntrinsicNamespace(type);\n  }\n\n  if (parentNamespace === SVG_NAMESPACE && type === 'foreignObject') {\n    // We're leaving SVG.\n    return HTML_NAMESPACE;\n  } // By default, pass namespace below.\n\n\n  return parentNamespace;\n}\n\nvar hasReadOnlyValue = {\n  button: true,\n  checkbox: true,\n  image: true,\n  hidden: true,\n  radio: true,\n  reset: true,\n  submit: true\n};\nfunction checkControlledValueProps(tagName, props) {\n  {\n    if (!(hasReadOnlyValue[props.type] || props.onChange || props.onInput || props.readOnly || props.disabled || props.value == null)) {\n      error('You provided a `value` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultValue`. Otherwise, ' + 'set either `onChange` or `readOnly`.');\n    }\n\n    if (!(props.onChange || props.readOnly || props.disabled || props.checked == null)) {\n      error('You provided a `checked` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultChecked`. Otherwise, ' + 'set either `onChange` or `readOnly`.');\n    }\n  }\n}\n\n// For HTML, certain tags should omit their close tag. We keep a list for\n// those special-case tags.\nvar omittedCloseTags = {\n  area: true,\n  base: true,\n  br: true,\n  col: true,\n  embed: true,\n  hr: true,\n  img: true,\n  input: true,\n  keygen: true,\n  link: true,\n  meta: true,\n  param: true,\n  source: true,\n  track: true,\n  wbr: true // NOTE: menuitem's close tag should be omitted, but that causes problems.\n\n};\n\n// `omittedCloseTags` except that `menuitem` should still have its closing tag.\n\nvar voidElementTags = _assign({\n  menuitem: true\n}, omittedCloseTags);\n\nvar HTML = '__html';\n\nfunction assertValidProps(tag, props) {\n  if (!props) {\n    return;\n  } // Note the use of `==` which checks for null or undefined.\n\n\n  if (voidElementTags[tag]) {\n    if (!(props.children == null && props.dangerouslySetInnerHTML == null)) {\n      {\n        throw Error( tag + \" is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`.\" );\n      }\n    }\n  }\n\n  if (props.dangerouslySetInnerHTML != null) {\n    if (!(props.children == null)) {\n      {\n        throw Error( \"Can only set one of `children` or `props.dangerouslySetInnerHTML`.\" );\n      }\n    }\n\n    if (!(typeof props.dangerouslySetInnerHTML === 'object' && HTML in props.dangerouslySetInnerHTML)) {\n      {\n        throw Error( \"`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://reactjs.org/link/dangerously-set-inner-html for more information.\" );\n      }\n    }\n  }\n\n  {\n    if (!props.suppressContentEditableWarning && props.contentEditable && props.children != null) {\n      error('A component is `contentEditable` and contains `children` managed by ' + 'React. It is now your responsibility to guarantee that none of ' + 'those nodes are unexpectedly modified or duplicated. This is ' + 'probably not intentional.');\n    }\n  }\n\n  if (!(props.style == null || typeof props.style === 'object')) {\n    {\n      throw Error( \"The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX.\" );\n    }\n  }\n}\n\n/**\n * CSS properties which accept numbers but are not in units of \"px\".\n */\nvar isUnitlessNumber = {\n  animationIterationCount: true,\n  borderImageOutset: true,\n  borderImageSlice: true,\n  borderImageWidth: true,\n  boxFlex: true,\n  boxFlexGroup: true,\n  boxOrdinalGroup: true,\n  columnCount: true,\n  columns: true,\n  flex: true,\n  flexGrow: true,\n  flexPositive: true,\n  flexShrink: true,\n  flexNegative: true,\n  flexOrder: true,\n  gridArea: true,\n  gridRow: true,\n  gridRowEnd: true,\n  gridRowSpan: true,\n  gridRowStart: true,\n  gridColumn: true,\n  gridColumnEnd: true,\n  gridColumnSpan: true,\n  gridColumnStart: true,\n  fontWeight: true,\n  lineClamp: true,\n  lineHeight: true,\n  opacity: true,\n  order: true,\n  orphans: true,\n  tabSize: true,\n  widows: true,\n  zIndex: true,\n  zoom: true,\n  // SVG-related properties\n  fillOpacity: true,\n  floodOpacity: true,\n  stopOpacity: true,\n  strokeDasharray: true,\n  strokeDashoffset: true,\n  strokeMiterlimit: true,\n  strokeOpacity: true,\n  strokeWidth: true\n};\n/**\n * @param {string} prefix vendor-specific prefix, eg: Webkit\n * @param {string} key style name, eg: transitionDuration\n * @return {string} style name prefixed with `prefix`, properly camelCased, eg:\n * WebkitTransitionDuration\n */\n\nfunction prefixKey(prefix, key) {\n  return prefix + key.charAt(0).toUpperCase() + key.substring(1);\n}\n/**\n * Support style names that may come passed in prefixed by adding permutations\n * of vendor prefixes.\n */\n\n\nvar prefixes = ['Webkit', 'ms', 'Moz', 'O']; // Using Object.keys here, or else the vanilla for-in loop makes IE8 go into an\n// infinite loop, because it iterates over the newly added props too.\n\nObject.keys(isUnitlessNumber).forEach(function (prop) {\n  prefixes.forEach(function (prefix) {\n    isUnitlessNumber[prefixKey(prefix, prop)] = isUnitlessNumber[prop];\n  });\n});\n\n/**\n * Convert a value into the proper css writable value. The style name `name`\n * should be logical (no hyphens), as specified\n * in `CSSProperty.isUnitlessNumber`.\n *\n * @param {string} name CSS property name such as `topMargin`.\n * @param {*} value CSS property value such as `10px`.\n * @return {string} Normalized style value with dimensions applied.\n */\n\nfunction dangerousStyleValue(name, value, isCustomProperty) {\n  // Note that we've removed escapeTextForBrowser() calls here since the\n  // whole string will be escaped when the attribute is injected into\n  // the markup. If you provide unsafe user data here they can inject\n  // arbitrary CSS which may be problematic (I couldn't repro this):\n  // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet\n  // http://www.thespanner.co.uk/2007/11/26/ultimate-xss-css-injection/\n  // This is not an XSS hole but instead a potential CSS injection issue\n  // which has lead to a greater discussion about how we're going to\n  // trust URLs moving forward. See #2115901\n  var isEmpty = value == null || typeof value === 'boolean' || value === '';\n\n  if (isEmpty) {\n    return '';\n  }\n\n  if (!isCustomProperty && typeof value === 'number' && value !== 0 && !(isUnitlessNumber.hasOwnProperty(name) && isUnitlessNumber[name])) {\n    return value + 'px'; // Presumes implicit 'px' suffix for unitless numbers\n  }\n\n  return ('' + value).trim();\n}\n\nvar uppercasePattern = /([A-Z])/g;\nvar msPattern = /^ms-/;\n/**\n * Hyphenates a camelcased CSS property name, for example:\n *\n *   > hyphenateStyleName('backgroundColor')\n *   < \"background-color\"\n *   > hyphenateStyleName('MozTransition')\n *   < \"-moz-transition\"\n *   > hyphenateStyleName('msTransition')\n *   < \"-ms-transition\"\n *\n * As Modernizr suggests (http://modernizr.com/docs/#prefixed), an `ms` prefix\n * is converted to `-ms-`.\n */\n\nfunction hyphenateStyleName(name) {\n  return name.replace(uppercasePattern, '-$1').toLowerCase().replace(msPattern, '-ms-');\n}\n\nfunction isCustomComponent(tagName, props) {\n  if (tagName.indexOf('-') === -1) {\n    return typeof props.is === 'string';\n  }\n\n  switch (tagName) {\n    // These are reserved SVG and MathML elements.\n    // We don't mind this list too much because we expect it to never grow.\n    // The alternative is to track the namespace in a few places which is convoluted.\n    // https://w3c.github.io/webcomponents/spec/custom/#custom-elements-core-concepts\n    case 'annotation-xml':\n    case 'color-profile':\n    case 'font-face':\n    case 'font-face-src':\n    case 'font-face-uri':\n    case 'font-face-format':\n    case 'font-face-name':\n    case 'missing-glyph':\n      return false;\n\n    default:\n      return true;\n  }\n}\n\nvar warnValidStyle = function () {};\n\n{\n  // 'msTransform' is correct, but the other prefixes should be capitalized\n  var badVendoredStyleNamePattern = /^(?:webkit|moz|o)[A-Z]/;\n  var msPattern$1 = /^-ms-/;\n  var hyphenPattern = /-(.)/g; // style values shouldn't contain a semicolon\n\n  var badStyleValueWithSemicolonPattern = /;\\s*$/;\n  var warnedStyleNames = {};\n  var warnedStyleValues = {};\n  var warnedForNaNValue = false;\n  var warnedForInfinityValue = false;\n\n  var camelize = function (string) {\n    return string.replace(hyphenPattern, function (_, character) {\n      return character.toUpperCase();\n    });\n  };\n\n  var warnHyphenatedStyleName = function (name) {\n    if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {\n      return;\n    }\n\n    warnedStyleNames[name] = true;\n\n    error('Unsupported style property %s. Did you mean %s?', name, // As Andi Smith suggests\n    // (http://www.andismith.com/blog/2012/02/modernizr-prefixed/), an `-ms` prefix\n    // is converted to lowercase `ms`.\n    camelize(name.replace(msPattern$1, 'ms-')));\n  };\n\n  var warnBadVendoredStyleName = function (name) {\n    if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {\n      return;\n    }\n\n    warnedStyleNames[name] = true;\n\n    error('Unsupported vendor-prefixed style property %s. Did you mean %s?', name, name.charAt(0).toUpperCase() + name.slice(1));\n  };\n\n  var warnStyleValueWithSemicolon = function (name, value) {\n    if (warnedStyleValues.hasOwnProperty(value) && warnedStyleValues[value]) {\n      return;\n    }\n\n    warnedStyleValues[value] = true;\n\n    error(\"Style property values shouldn't contain a semicolon. \" + 'Try \"%s: %s\" instead.', name, value.replace(badStyleValueWithSemicolonPattern, ''));\n  };\n\n  var warnStyleValueIsNaN = function (name, value) {\n    if (warnedForNaNValue) {\n      return;\n    }\n\n    warnedForNaNValue = true;\n\n    error('`NaN` is an invalid value for the `%s` css style property.', name);\n  };\n\n  var warnStyleValueIsInfinity = function (name, value) {\n    if (warnedForInfinityValue) {\n      return;\n    }\n\n    warnedForInfinityValue = true;\n\n    error('`Infinity` is an invalid value for the `%s` css style property.', name);\n  };\n\n  warnValidStyle = function (name, value) {\n    if (name.indexOf('-') > -1) {\n      warnHyphenatedStyleName(name);\n    } else if (badVendoredStyleNamePattern.test(name)) {\n      warnBadVendoredStyleName(name);\n    } else if (badStyleValueWithSemicolonPattern.test(value)) {\n      warnStyleValueWithSemicolon(name, value);\n    }\n\n    if (typeof value === 'number') {\n      if (isNaN(value)) {\n        warnStyleValueIsNaN(name, value);\n      } else if (!isFinite(value)) {\n        warnStyleValueIsInfinity(name, value);\n      }\n    }\n  };\n}\n\nvar warnValidStyle$1 = warnValidStyle;\n\nvar ariaProperties = {\n  'aria-current': 0,\n  // state\n  'aria-details': 0,\n  'aria-disabled': 0,\n  // state\n  'aria-hidden': 0,\n  // state\n  'aria-invalid': 0,\n  // state\n  'aria-keyshortcuts': 0,\n  'aria-label': 0,\n  'aria-roledescription': 0,\n  // Widget Attributes\n  'aria-autocomplete': 0,\n  'aria-checked': 0,\n  'aria-expanded': 0,\n  'aria-haspopup': 0,\n  'aria-level': 0,\n  'aria-modal': 0,\n  'aria-multiline': 0,\n  'aria-multiselectable': 0,\n  'aria-orientation': 0,\n  'aria-placeholder': 0,\n  'aria-pressed': 0,\n  'aria-readonly': 0,\n  'aria-required': 0,\n  'aria-selected': 0,\n  'aria-sort': 0,\n  'aria-valuemax': 0,\n  'aria-valuemin': 0,\n  'aria-valuenow': 0,\n  'aria-valuetext': 0,\n  // Live Region Attributes\n  'aria-atomic': 0,\n  'aria-busy': 0,\n  'aria-live': 0,\n  'aria-relevant': 0,\n  // Drag-and-Drop Attributes\n  'aria-dropeffect': 0,\n  'aria-grabbed': 0,\n  // Relationship Attributes\n  'aria-activedescendant': 0,\n  'aria-colcount': 0,\n  'aria-colindex': 0,\n  'aria-colspan': 0,\n  'aria-controls': 0,\n  'aria-describedby': 0,\n  'aria-errormessage': 0,\n  'aria-flowto': 0,\n  'aria-labelledby': 0,\n  'aria-owns': 0,\n  'aria-posinset': 0,\n  'aria-rowcount': 0,\n  'aria-rowindex': 0,\n  'aria-rowspan': 0,\n  'aria-setsize': 0\n};\n\nvar warnedProperties = {};\nvar rARIA = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');\nvar rARIACamel = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');\nvar hasOwnProperty$1 = Object.prototype.hasOwnProperty;\n\nfunction validateProperty(tagName, name) {\n  {\n    if (hasOwnProperty$1.call(warnedProperties, name) && warnedProperties[name]) {\n      return true;\n    }\n\n    if (rARIACamel.test(name)) {\n      var ariaName = 'aria-' + name.slice(4).toLowerCase();\n      var correctName = ariaProperties.hasOwnProperty(ariaName) ? ariaName : null; // If this is an aria-* attribute, but is not listed in the known DOM\n      // DOM properties, then it is an invalid aria-* attribute.\n\n      if (correctName == null) {\n        error('Invalid ARIA attribute `%s`. ARIA attributes follow the pattern aria-* and must be lowercase.', name);\n\n        warnedProperties[name] = true;\n        return true;\n      } // aria-* attributes should be lowercase; suggest the lowercase version.\n\n\n      if (name !== correctName) {\n        error('Invalid ARIA attribute `%s`. Did you mean `%s`?', name, correctName);\n\n        warnedProperties[name] = true;\n        return true;\n      }\n    }\n\n    if (rARIA.test(name)) {\n      var lowerCasedName = name.toLowerCase();\n      var standardName = ariaProperties.hasOwnProperty(lowerCasedName) ? lowerCasedName : null; // If this is an aria-* attribute, but is not listed in the known DOM\n      // DOM properties, then it is an invalid aria-* attribute.\n\n      if (standardName == null) {\n        warnedProperties[name] = true;\n        return false;\n      } // aria-* attributes should be lowercase; suggest the lowercase version.\n\n\n      if (name !== standardName) {\n        error('Unknown ARIA attribute `%s`. Did you mean `%s`?', name, standardName);\n\n        warnedProperties[name] = true;\n        return true;\n      }\n    }\n  }\n\n  return true;\n}\n\nfunction warnInvalidARIAProps(type, props) {\n  {\n    var invalidProps = [];\n\n    for (var key in props) {\n      var isValid = validateProperty(type, key);\n\n      if (!isValid) {\n        invalidProps.push(key);\n      }\n    }\n\n    var unknownPropString = invalidProps.map(function (prop) {\n      return '`' + prop + '`';\n    }).join(', ');\n\n    if (invalidProps.length === 1) {\n      error('Invalid aria prop %s on <%s> tag. ' + 'For details, see https://reactjs.org/link/invalid-aria-props', unknownPropString, type);\n    } else if (invalidProps.length > 1) {\n      error('Invalid aria props %s on <%s> tag. ' + 'For details, see https://reactjs.org/link/invalid-aria-props', unknownPropString, type);\n    }\n  }\n}\n\nfunction validateProperties(type, props) {\n  if (isCustomComponent(type, props)) {\n    return;\n  }\n\n  warnInvalidARIAProps(type, props);\n}\n\nvar didWarnValueNull = false;\nfunction validateProperties$1(type, props) {\n  {\n    if (type !== 'input' && type !== 'textarea' && type !== 'select') {\n      return;\n    }\n\n    if (props != null && props.value === null && !didWarnValueNull) {\n      didWarnValueNull = true;\n\n      if (type === 'select' && props.multiple) {\n        error('`value` prop on `%s` should not be null. ' + 'Consider using an empty array when `multiple` is set to `true` ' + 'to clear the component or `undefined` for uncontrolled components.', type);\n      } else {\n        error('`value` prop on `%s` should not be null. ' + 'Consider using an empty string to clear the component or `undefined` ' + 'for uncontrolled components.', type);\n      }\n    }\n  }\n}\n\n// When adding attributes to the HTML or SVG allowed attribute list, be sure to\n// also add them to this module to ensure casing and incorrect name\n// warnings.\nvar possibleStandardNames = {\n  // HTML\n  accept: 'accept',\n  acceptcharset: 'acceptCharset',\n  'accept-charset': 'acceptCharset',\n  accesskey: 'accessKey',\n  action: 'action',\n  allowfullscreen: 'allowFullScreen',\n  alt: 'alt',\n  as: 'as',\n  async: 'async',\n  autocapitalize: 'autoCapitalize',\n  autocomplete: 'autoComplete',\n  autocorrect: 'autoCorrect',\n  autofocus: 'autoFocus',\n  autoplay: 'autoPlay',\n  autosave: 'autoSave',\n  capture: 'capture',\n  cellpadding: 'cellPadding',\n  cellspacing: 'cellSpacing',\n  challenge: 'challenge',\n  charset: 'charSet',\n  checked: 'checked',\n  children: 'children',\n  cite: 'cite',\n  class: 'className',\n  classid: 'classID',\n  classname: 'className',\n  cols: 'cols',\n  colspan: 'colSpan',\n  content: 'content',\n  contenteditable: 'contentEditable',\n  contextmenu: 'contextMenu',\n  controls: 'controls',\n  controlslist: 'controlsList',\n  coords: 'coords',\n  crossorigin: 'crossOrigin',\n  dangerouslysetinnerhtml: 'dangerouslySetInnerHTML',\n  data: 'data',\n  datetime: 'dateTime',\n  default: 'default',\n  defaultchecked: 'defaultChecked',\n  defaultvalue: 'defaultValue',\n  defer: 'defer',\n  dir: 'dir',\n  disabled: 'disabled',\n  disablepictureinpicture: 'disablePictureInPicture',\n  disableremoteplayback: 'disableRemotePlayback',\n  download: 'download',\n  draggable: 'draggable',\n  enctype: 'encType',\n  enterkeyhint: 'enterKeyHint',\n  for: 'htmlFor',\n  form: 'form',\n  formmethod: 'formMethod',\n  formaction: 'formAction',\n  formenctype: 'formEncType',\n  formnovalidate: 'formNoValidate',\n  formtarget: 'formTarget',\n  frameborder: 'frameBorder',\n  headers: 'headers',\n  height: 'height',\n  hidden: 'hidden',\n  high: 'high',\n  href: 'href',\n  hreflang: 'hrefLang',\n  htmlfor: 'htmlFor',\n  httpequiv: 'httpEquiv',\n  'http-equiv': 'httpEquiv',\n  icon: 'icon',\n  id: 'id',\n  innerhtml: 'innerHTML',\n  inputmode: 'inputMode',\n  integrity: 'integrity',\n  is: 'is',\n  itemid: 'itemID',\n  itemprop: 'itemProp',\n  itemref: 'itemRef',\n  itemscope: 'itemScope',\n  itemtype: 'itemType',\n  keyparams: 'keyParams',\n  keytype: 'keyType',\n  kind: 'kind',\n  label: 'label',\n  lang: 'lang',\n  list: 'list',\n  loop: 'loop',\n  low: 'low',\n  manifest: 'manifest',\n  marginwidth: 'marginWidth',\n  marginheight: 'marginHeight',\n  max: 'max',\n  maxlength: 'maxLength',\n  media: 'media',\n  mediagroup: 'mediaGroup',\n  method: 'method',\n  min: 'min',\n  minlength: 'minLength',\n  multiple: 'multiple',\n  muted: 'muted',\n  name: 'name',\n  nomodule: 'noModule',\n  nonce: 'nonce',\n  novalidate: 'noValidate',\n  open: 'open',\n  optimum: 'optimum',\n  pattern: 'pattern',\n  placeholder: 'placeholder',\n  playsinline: 'playsInline',\n  poster: 'poster',\n  preload: 'preload',\n  profile: 'profile',\n  radiogroup: 'radioGroup',\n  readonly: 'readOnly',\n  referrerpolicy: 'referrerPolicy',\n  rel: 'rel',\n  required: 'required',\n  reversed: 'reversed',\n  role: 'role',\n  rows: 'rows',\n  rowspan: 'rowSpan',\n  sandbox: 'sandbox',\n  scope: 'scope',\n  scoped: 'scoped',\n  scrolling: 'scrolling',\n  seamless: 'seamless',\n  selected: 'selected',\n  shape: 'shape',\n  size: 'size',\n  sizes: 'sizes',\n  span: 'span',\n  spellcheck: 'spellCheck',\n  src: 'src',\n  srcdoc: 'srcDoc',\n  srclang: 'srcLang',\n  srcset: 'srcSet',\n  start: 'start',\n  step: 'step',\n  style: 'style',\n  summary: 'summary',\n  tabindex: 'tabIndex',\n  target: 'target',\n  title: 'title',\n  type: 'type',\n  usemap: 'useMap',\n  value: 'value',\n  width: 'width',\n  wmode: 'wmode',\n  wrap: 'wrap',\n  // SVG\n  about: 'about',\n  accentheight: 'accentHeight',\n  'accent-height': 'accentHeight',\n  accumulate: 'accumulate',\n  additive: 'additive',\n  alignmentbaseline: 'alignmentBaseline',\n  'alignment-baseline': 'alignmentBaseline',\n  allowreorder: 'allowReorder',\n  alphabetic: 'alphabetic',\n  amplitude: 'amplitude',\n  arabicform: 'arabicForm',\n  'arabic-form': 'arabicForm',\n  ascent: 'ascent',\n  attributename: 'attributeName',\n  attributetype: 'attributeType',\n  autoreverse: 'autoReverse',\n  azimuth: 'azimuth',\n  basefrequency: 'baseFrequency',\n  baselineshift: 'baselineShift',\n  'baseline-shift': 'baselineShift',\n  baseprofile: 'baseProfile',\n  bbox: 'bbox',\n  begin: 'begin',\n  bias: 'bias',\n  by: 'by',\n  calcmode: 'calcMode',\n  capheight: 'capHeight',\n  'cap-height': 'capHeight',\n  clip: 'clip',\n  clippath: 'clipPath',\n  'clip-path': 'clipPath',\n  clippathunits: 'clipPathUnits',\n  cliprule: 'clipRule',\n  'clip-rule': 'clipRule',\n  color: 'color',\n  colorinterpolation: 'colorInterpolation',\n  'color-interpolation': 'colorInterpolation',\n  colorinterpolationfilters: 'colorInterpolationFilters',\n  'color-interpolation-filters': 'colorInterpolationFilters',\n  colorprofile: 'colorProfile',\n  'color-profile': 'colorProfile',\n  colorrendering: 'colorRendering',\n  'color-rendering': 'colorRendering',\n  contentscripttype: 'contentScriptType',\n  contentstyletype: 'contentStyleType',\n  cursor: 'cursor',\n  cx: 'cx',\n  cy: 'cy',\n  d: 'd',\n  datatype: 'datatype',\n  decelerate: 'decelerate',\n  descent: 'descent',\n  diffuseconstant: 'diffuseConstant',\n  direction: 'direction',\n  display: 'display',\n  divisor: 'divisor',\n  dominantbaseline: 'dominantBaseline',\n  'dominant-baseline': 'dominantBaseline',\n  dur: 'dur',\n  dx: 'dx',\n  dy: 'dy',\n  edgemode: 'edgeMode',\n  elevation: 'elevation',\n  enablebackground: 'enableBackground',\n  'enable-background': 'enableBackground',\n  end: 'end',\n  exponent: 'exponent',\n  externalresourcesrequired: 'externalResourcesRequired',\n  fill: 'fill',\n  fillopacity: 'fillOpacity',\n  'fill-opacity': 'fillOpacity',\n  fillrule: 'fillRule',\n  'fill-rule': 'fillRule',\n  filter: 'filter',\n  filterres: 'filterRes',\n  filterunits: 'filterUnits',\n  floodopacity: 'floodOpacity',\n  'flood-opacity': 'floodOpacity',\n  floodcolor: 'floodColor',\n  'flood-color': 'floodColor',\n  focusable: 'focusable',\n  fontfamily: 'fontFamily',\n  'font-family': 'fontFamily',\n  fontsize: 'fontSize',\n  'font-size': 'fontSize',\n  fontsizeadjust: 'fontSizeAdjust',\n  'font-size-adjust': 'fontSizeAdjust',\n  fontstretch: 'fontStretch',\n  'font-stretch': 'fontStretch',\n  fontstyle: 'fontStyle',\n  'font-style': 'fontStyle',\n  fontvariant: 'fontVariant',\n  'font-variant': 'fontVariant',\n  fontweight: 'fontWeight',\n  'font-weight': 'fontWeight',\n  format: 'format',\n  from: 'from',\n  fx: 'fx',\n  fy: 'fy',\n  g1: 'g1',\n  g2: 'g2',\n  glyphname: 'glyphName',\n  'glyph-name': 'glyphName',\n  glyphorientationhorizontal: 'glyphOrientationHorizontal',\n  'glyph-orientation-horizontal': 'glyphOrientationHorizontal',\n  glyphorientationvertical: 'glyphOrientationVertical',\n  'glyph-orientation-vertical': 'glyphOrientationVertical',\n  glyphref: 'glyphRef',\n  gradienttransform: 'gradientTransform',\n  gradientunits: 'gradientUnits',\n  hanging: 'hanging',\n  horizadvx: 'horizAdvX',\n  'horiz-adv-x': 'horizAdvX',\n  horizoriginx: 'horizOriginX',\n  'horiz-origin-x': 'horizOriginX',\n  ideographic: 'ideographic',\n  imagerendering: 'imageRendering',\n  'image-rendering': 'imageRendering',\n  in2: 'in2',\n  in: 'in',\n  inlist: 'inlist',\n  intercept: 'intercept',\n  k1: 'k1',\n  k2: 'k2',\n  k3: 'k3',\n  k4: 'k4',\n  k: 'k',\n  kernelmatrix: 'kernelMatrix',\n  kernelunitlength: 'kernelUnitLength',\n  kerning: 'kerning',\n  keypoints: 'keyPoints',\n  keysplines: 'keySplines',\n  keytimes: 'keyTimes',\n  lengthadjust: 'lengthAdjust',\n  letterspacing: 'letterSpacing',\n  'letter-spacing': 'letterSpacing',\n  lightingcolor: 'lightingColor',\n  'lighting-color': 'lightingColor',\n  limitingconeangle: 'limitingConeAngle',\n  local: 'local',\n  markerend: 'markerEnd',\n  'marker-end': 'markerEnd',\n  markerheight: 'markerHeight',\n  markermid: 'markerMid',\n  'marker-mid': 'markerMid',\n  markerstart: 'markerStart',\n  'marker-start': 'markerStart',\n  markerunits: 'markerUnits',\n  markerwidth: 'markerWidth',\n  mask: 'mask',\n  maskcontentunits: 'maskContentUnits',\n  maskunits: 'maskUnits',\n  mathematical: 'mathematical',\n  mode: 'mode',\n  numoctaves: 'numOctaves',\n  offset: 'offset',\n  opacity: 'opacity',\n  operator: 'operator',\n  order: 'order',\n  orient: 'orient',\n  orientation: 'orientation',\n  origin: 'origin',\n  overflow: 'overflow',\n  overlineposition: 'overlinePosition',\n  'overline-position': 'overlinePosition',\n  overlinethickness: 'overlineThickness',\n  'overline-thickness': 'overlineThickness',\n  paintorder: 'paintOrder',\n  'paint-order': 'paintOrder',\n  panose1: 'panose1',\n  'panose-1': 'panose1',\n  pathlength: 'pathLength',\n  patterncontentunits: 'patternContentUnits',\n  patterntransform: 'patternTransform',\n  patternunits: 'patternUnits',\n  pointerevents: 'pointerEvents',\n  'pointer-events': 'pointerEvents',\n  points: 'points',\n  pointsatx: 'pointsAtX',\n  pointsaty: 'pointsAtY',\n  pointsatz: 'pointsAtZ',\n  prefix: 'prefix',\n  preservealpha: 'preserveAlpha',\n  preserveaspectratio: 'preserveAspectRatio',\n  primitiveunits: 'primitiveUnits',\n  property: 'property',\n  r: 'r',\n  radius: 'radius',\n  refx: 'refX',\n  refy: 'refY',\n  renderingintent: 'renderingIntent',\n  'rendering-intent': 'renderingIntent',\n  repeatcount: 'repeatCount',\n  repeatdur: 'repeatDur',\n  requiredextensions: 'requiredExtensions',\n  requiredfeatures: 'requiredFeatures',\n  resource: 'resource',\n  restart: 'restart',\n  result: 'result',\n  results: 'results',\n  rotate: 'rotate',\n  rx: 'rx',\n  ry: 'ry',\n  scale: 'scale',\n  security: 'security',\n  seed: 'seed',\n  shaperendering: 'shapeRendering',\n  'shape-rendering': 'shapeRendering',\n  slope: 'slope',\n  spacing: 'spacing',\n  specularconstant: 'specularConstant',\n  specularexponent: 'specularExponent',\n  speed: 'speed',\n  spreadmethod: 'spreadMethod',\n  startoffset: 'startOffset',\n  stddeviation: 'stdDeviation',\n  stemh: 'stemh',\n  stemv: 'stemv',\n  stitchtiles: 'stitchTiles',\n  stopcolor: 'stopColor',\n  'stop-color': 'stopColor',\n  stopopacity: 'stopOpacity',\n  'stop-opacity': 'stopOpacity',\n  strikethroughposition: 'strikethroughPosition',\n  'strikethrough-position': 'strikethroughPosition',\n  strikethroughthickness: 'strikethroughThickness',\n  'strikethrough-thickness': 'strikethroughThickness',\n  string: 'string',\n  stroke: 'stroke',\n  strokedasharray: 'strokeDasharray',\n  'stroke-dasharray': 'strokeDasharray',\n  strokedashoffset: 'strokeDashoffset',\n  'stroke-dashoffset': 'strokeDashoffset',\n  strokelinecap: 'strokeLinecap',\n  'stroke-linecap': 'strokeLinecap',\n  strokelinejoin: 'strokeLinejoin',\n  'stroke-linejoin': 'strokeLinejoin',\n  strokemiterlimit: 'strokeMiterlimit',\n  'stroke-miterlimit': 'strokeMiterlimit',\n  strokewidth: 'strokeWidth',\n  'stroke-width': 'strokeWidth',\n  strokeopacity: 'strokeOpacity',\n  'stroke-opacity': 'strokeOpacity',\n  suppresscontenteditablewarning: 'suppressContentEditableWarning',\n  suppresshydrationwarning: 'suppressHydrationWarning',\n  surfacescale: 'surfaceScale',\n  systemlanguage: 'systemLanguage',\n  tablevalues: 'tableValues',\n  targetx: 'targetX',\n  targety: 'targetY',\n  textanchor: 'textAnchor',\n  'text-anchor': 'textAnchor',\n  textdecoration: 'textDecoration',\n  'text-decoration': 'textDecoration',\n  textlength: 'textLength',\n  textrendering: 'textRendering',\n  'text-rendering': 'textRendering',\n  to: 'to',\n  transform: 'transform',\n  typeof: 'typeof',\n  u1: 'u1',\n  u2: 'u2',\n  underlineposition: 'underlinePosition',\n  'underline-position': 'underlinePosition',\n  underlinethickness: 'underlineThickness',\n  'underline-thickness': 'underlineThickness',\n  unicode: 'unicode',\n  unicodebidi: 'unicodeBidi',\n  'unicode-bidi': 'unicodeBidi',\n  unicoderange: 'unicodeRange',\n  'unicode-range': 'unicodeRange',\n  unitsperem: 'unitsPerEm',\n  'units-per-em': 'unitsPerEm',\n  unselectable: 'unselectable',\n  valphabetic: 'vAlphabetic',\n  'v-alphabetic': 'vAlphabetic',\n  values: 'values',\n  vectoreffect: 'vectorEffect',\n  'vector-effect': 'vectorEffect',\n  version: 'version',\n  vertadvy: 'vertAdvY',\n  'vert-adv-y': 'vertAdvY',\n  vertoriginx: 'vertOriginX',\n  'vert-origin-x': 'vertOriginX',\n  vertoriginy: 'vertOriginY',\n  'vert-origin-y': 'vertOriginY',\n  vhanging: 'vHanging',\n  'v-hanging': 'vHanging',\n  videographic: 'vIdeographic',\n  'v-ideographic': 'vIdeographic',\n  viewbox: 'viewBox',\n  viewtarget: 'viewTarget',\n  visibility: 'visibility',\n  vmathematical: 'vMathematical',\n  'v-mathematical': 'vMathematical',\n  vocab: 'vocab',\n  widths: 'widths',\n  wordspacing: 'wordSpacing',\n  'word-spacing': 'wordSpacing',\n  writingmode: 'writingMode',\n  'writing-mode': 'writingMode',\n  x1: 'x1',\n  x2: 'x2',\n  x: 'x',\n  xchannelselector: 'xChannelSelector',\n  xheight: 'xHeight',\n  'x-height': 'xHeight',\n  xlinkactuate: 'xlinkActuate',\n  'xlink:actuate': 'xlinkActuate',\n  xlinkarcrole: 'xlinkArcrole',\n  'xlink:arcrole': 'xlinkArcrole',\n  xlinkhref: 'xlinkHref',\n  'xlink:href': 'xlinkHref',\n  xlinkrole: 'xlinkRole',\n  'xlink:role': 'xlinkRole',\n  xlinkshow: 'xlinkShow',\n  'xlink:show': 'xlinkShow',\n  xlinktitle: 'xlinkTitle',\n  'xlink:title': 'xlinkTitle',\n  xlinktype: 'xlinkType',\n  'xlink:type': 'xlinkType',\n  xmlbase: 'xmlBase',\n  'xml:base': 'xmlBase',\n  xmllang: 'xmlLang',\n  'xml:lang': 'xmlLang',\n  xmlns: 'xmlns',\n  'xml:space': 'xmlSpace',\n  xmlnsxlink: 'xmlnsXlink',\n  'xmlns:xlink': 'xmlnsXlink',\n  xmlspace: 'xmlSpace',\n  y1: 'y1',\n  y2: 'y2',\n  y: 'y',\n  ychannelselector: 'yChannelSelector',\n  z: 'z',\n  zoomandpan: 'zoomAndPan'\n};\n\nvar validateProperty$1 = function () {};\n\n{\n  var warnedProperties$1 = {};\n  var _hasOwnProperty = Object.prototype.hasOwnProperty;\n  var EVENT_NAME_REGEX = /^on./;\n  var INVALID_EVENT_NAME_REGEX = /^on[^A-Z]/;\n  var rARIA$1 = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');\n  var rARIACamel$1 = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');\n\n  validateProperty$1 = function (tagName, name, value, eventRegistry) {\n    if (_hasOwnProperty.call(warnedProperties$1, name) && warnedProperties$1[name]) {\n      return true;\n    }\n\n    var lowerCasedName = name.toLowerCase();\n\n    if (lowerCasedName === 'onfocusin' || lowerCasedName === 'onfocusout') {\n      error('React uses onFocus and onBlur instead of onFocusIn and onFocusOut. ' + 'All React events are normalized to bubble, so onFocusIn and onFocusOut ' + 'are not needed/supported by React.');\n\n      warnedProperties$1[name] = true;\n      return true;\n    } // We can't rely on the event system being injected on the server.\n\n\n    if (eventRegistry != null) {\n      var registrationNameDependencies = eventRegistry.registrationNameDependencies,\n          possibleRegistrationNames = eventRegistry.possibleRegistrationNames;\n\n      if (registrationNameDependencies.hasOwnProperty(name)) {\n        return true;\n      }\n\n      var registrationName = possibleRegistrationNames.hasOwnProperty(lowerCasedName) ? possibleRegistrationNames[lowerCasedName] : null;\n\n      if (registrationName != null) {\n        error('Invalid event handler property `%s`. Did you mean `%s`?', name, registrationName);\n\n        warnedProperties$1[name] = true;\n        return true;\n      }\n\n      if (EVENT_NAME_REGEX.test(name)) {\n        error('Unknown event handler property `%s`. It will be ignored.', name);\n\n        warnedProperties$1[name] = true;\n        return true;\n      }\n    } else if (EVENT_NAME_REGEX.test(name)) {\n      // If no event plugins have been injected, we are in a server environment.\n      // So we can't tell if the event name is correct for sure, but we can filter\n      // out known bad ones like `onclick`. We can't suggest a specific replacement though.\n      if (INVALID_EVENT_NAME_REGEX.test(name)) {\n        error('Invalid event handler property `%s`. ' + 'React events use the camelCase naming convention, for example `onClick`.', name);\n      }\n\n      warnedProperties$1[name] = true;\n      return true;\n    } // Let the ARIA attribute hook validate ARIA attributes\n\n\n    if (rARIA$1.test(name) || rARIACamel$1.test(name)) {\n      return true;\n    }\n\n    if (lowerCasedName === 'innerhtml') {\n      error('Directly setting property `innerHTML` is not permitted. ' + 'For more information, lookup documentation on `dangerouslySetInnerHTML`.');\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    if (lowerCasedName === 'aria') {\n      error('The `aria` attribute is reserved for future use in React. ' + 'Pass individual `aria-` attributes instead.');\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    if (lowerCasedName === 'is' && value !== null && value !== undefined && typeof value !== 'string') {\n      error('Received a `%s` for a string attribute `is`. If this is expected, cast ' + 'the value to a string.', typeof value);\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    if (typeof value === 'number' && isNaN(value)) {\n      error('Received NaN for the `%s` attribute. If this is expected, cast ' + 'the value to a string.', name);\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    var propertyInfo = getPropertyInfo(name);\n    var isReserved = propertyInfo !== null && propertyInfo.type === RESERVED; // Known attributes should match the casing specified in the property config.\n\n    if (possibleStandardNames.hasOwnProperty(lowerCasedName)) {\n      var standardName = possibleStandardNames[lowerCasedName];\n\n      if (standardName !== name) {\n        error('Invalid DOM property `%s`. Did you mean `%s`?', name, standardName);\n\n        warnedProperties$1[name] = true;\n        return true;\n      }\n    } else if (!isReserved && name !== lowerCasedName) {\n      // Unknown attributes should have lowercase casing since that's how they\n      // will be cased anyway with server rendering.\n      error('React does not recognize the `%s` prop on a DOM element. If you ' + 'intentionally want it to appear in the DOM as a custom ' + 'attribute, spell it as lowercase `%s` instead. ' + 'If you accidentally passed it from a parent component, remove ' + 'it from the DOM element.', name, lowerCasedName);\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    if (typeof value === 'boolean' && shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {\n      if (value) {\n        error('Received `%s` for a non-boolean attribute `%s`.\\n\\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s=\"%s\" or %s={value.toString()}.', value, name, name, value, name);\n      } else {\n        error('Received `%s` for a non-boolean attribute `%s`.\\n\\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s=\"%s\" or %s={value.toString()}.\\n\\n' + 'If you used to conditionally omit it with %s={condition && value}, ' + 'pass %s={condition ? value : undefined} instead.', value, name, name, value, name, name, name);\n      }\n\n      warnedProperties$1[name] = true;\n      return true;\n    } // Now that we've validated casing, do not validate\n    // data types for reserved props\n\n\n    if (isReserved) {\n      return true;\n    } // Warn when a known attribute is a bad type\n\n\n    if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {\n      warnedProperties$1[name] = true;\n      return false;\n    } // Warn when passing the strings 'false' or 'true' into a boolean prop\n\n\n    if ((value === 'false' || value === 'true') && propertyInfo !== null && propertyInfo.type === BOOLEAN) {\n      error('Received the string `%s` for the boolean attribute `%s`. ' + '%s ' + 'Did you mean %s={%s}?', value, name, value === 'false' ? 'The browser will interpret it as a truthy value.' : 'Although this works, it will not work as expected if you pass the string \"false\".', name, value);\n\n      warnedProperties$1[name] = true;\n      return true;\n    }\n\n    return true;\n  };\n}\n\nvar warnUnknownProperties = function (type, props, eventRegistry) {\n  {\n    var unknownProps = [];\n\n    for (var key in props) {\n      var isValid = validateProperty$1(type, key, props[key], eventRegistry);\n\n      if (!isValid) {\n        unknownProps.push(key);\n      }\n    }\n\n    var unknownPropString = unknownProps.map(function (prop) {\n      return '`' + prop + '`';\n    }).join(', ');\n\n    if (unknownProps.length === 1) {\n      error('Invalid value for prop %s on <%s> tag. Either remove it from the element, ' + 'or pass a string or number value to keep it in the DOM. ' + 'For details, see https://reactjs.org/link/attribute-behavior ', unknownPropString, type);\n    } else if (unknownProps.length > 1) {\n      error('Invalid values for props %s on <%s> tag. Either remove them from the element, ' + 'or pass a string or number value to keep them in the DOM. ' + 'For details, see https://reactjs.org/link/attribute-behavior ', unknownPropString, type);\n    }\n  }\n};\n\nfunction validateProperties$2(type, props, eventRegistry) {\n  if (isCustomComponent(type, props)) {\n    return;\n  }\n\n  warnUnknownProperties(type, props, eventRegistry);\n}\n\nvar toArray = React.Children.toArray; // This is only used in DEV.\n// Each entry is `this.stack` from a currently executing renderer instance.\n// (There may be more than one because ReactDOMServer is reentrant).\n// Each stack is an array of frames which may contain nested stacks of elements.\n\nvar currentDebugStacks = [];\nvar ReactCurrentDispatcher$1 = ReactSharedInternals.ReactCurrentDispatcher;\nvar ReactDebugCurrentFrame$1;\nvar prevGetCurrentStackImpl = null;\n\nvar getCurrentServerStackImpl = function () {\n  return '';\n};\n\nvar describeStackFrame = function (element) {\n  return '';\n};\n\nvar validatePropertiesInDevelopment = function (type, props) {};\n\nvar pushCurrentDebugStack = function (stack) {};\n\nvar pushElementToDebugStack = function (element) {};\n\nvar popCurrentDebugStack = function () {};\n\nvar hasWarnedAboutUsingContextAsConsumer = false;\n\n{\n  ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;\n\n  validatePropertiesInDevelopment = function (type, props) {\n    validateProperties(type, props);\n    validateProperties$1(type, props);\n    validateProperties$2(type, props, null);\n  };\n\n  describeStackFrame = function (element) {\n    return describeUnknownElementTypeFrameInDEV(element.type, element._source, null);\n  };\n\n  pushCurrentDebugStack = function (stack) {\n    currentDebugStacks.push(stack);\n\n    if (currentDebugStacks.length === 1) {\n      // We are entering a server renderer.\n      // Remember the previous (e.g. client) global stack implementation.\n      prevGetCurrentStackImpl = ReactDebugCurrentFrame$1.getCurrentStack;\n      ReactDebugCurrentFrame$1.getCurrentStack = getCurrentServerStackImpl;\n    }\n  };\n\n  pushElementToDebugStack = function (element) {\n    // For the innermost executing ReactDOMServer call,\n    var stack = currentDebugStacks[currentDebugStacks.length - 1]; // Take the innermost executing frame (e.g. <Foo>),\n\n    var frame = stack[stack.length - 1]; // and record that it has one more element associated with it.\n\n    frame.debugElementStack.push(element); // We only need this because we tail-optimize single-element\n    // children and directly handle them in an inner loop instead of\n    // creating separate frames for them.\n  };\n\n  popCurrentDebugStack = function () {\n    currentDebugStacks.pop();\n\n    if (currentDebugStacks.length === 0) {\n      // We are exiting the server renderer.\n      // Restore the previous (e.g. client) global stack implementation.\n      ReactDebugCurrentFrame$1.getCurrentStack = prevGetCurrentStackImpl;\n      prevGetCurrentStackImpl = null;\n    }\n  };\n\n  getCurrentServerStackImpl = function () {\n    if (currentDebugStacks.length === 0) {\n      // Nothing is currently rendering.\n      return '';\n    } // ReactDOMServer is reentrant so there may be multiple calls at the same time.\n    // Take the frames from the innermost call which is the last in the array.\n\n\n    var frames = currentDebugStacks[currentDebugStacks.length - 1];\n    var stack = ''; // Go through every frame in the stack from the innermost one.\n\n    for (var i = frames.length - 1; i >= 0; i--) {\n      var frame = frames[i]; // Every frame might have more than one debug element stack entry associated with it.\n      // This is because single-child nesting doesn't create materialized frames.\n      // Instead it would push them through `pushElementToDebugStack()`.\n\n      var debugElementStack = frame.debugElementStack;\n\n      for (var ii = debugElementStack.length - 1; ii >= 0; ii--) {\n        stack += describeStackFrame(debugElementStack[ii]);\n      }\n    }\n\n    return stack;\n  };\n}\n\nvar didWarnDefaultInputValue = false;\nvar didWarnDefaultChecked = false;\nvar didWarnDefaultSelectValue = false;\nvar didWarnDefaultTextareaValue = false;\nvar didWarnInvalidOptionChildren = false;\nvar didWarnAboutNoopUpdateForComponent = {};\nvar didWarnAboutBadClass = {};\nvar didWarnAboutModulePatternComponent = {};\nvar didWarnAboutDeprecatedWillMount = {};\nvar didWarnAboutUndefinedDerivedState = {};\nvar didWarnAboutUninitializedState = {};\nvar valuePropNames = ['value', 'defaultValue'];\nvar newlineEatingTags = {\n  listing: true,\n  pre: true,\n  textarea: true\n}; // We accept any tag to be rendered but since this gets injected into arbitrary\n// HTML, we want to make sure that it's a safe tag.\n// http://www.w3.org/TR/REC-xml/#NT-Name\n\nvar VALID_TAG_REGEX = /^[a-zA-Z][a-zA-Z:_\\.\\-\\d]*$/; // Simplified subset\n\nvar validatedTagCache = {};\n\nfunction validateDangerousTag(tag) {\n  if (!validatedTagCache.hasOwnProperty(tag)) {\n    if (!VALID_TAG_REGEX.test(tag)) {\n      {\n        throw Error( \"Invalid tag: \" + tag );\n      }\n    }\n\n    validatedTagCache[tag] = true;\n  }\n}\n\nvar styleNameCache = {};\n\nvar processStyleName = function (styleName) {\n  if (styleNameCache.hasOwnProperty(styleName)) {\n    return styleNameCache[styleName];\n  }\n\n  var result = hyphenateStyleName(styleName);\n  styleNameCache[styleName] = result;\n  return result;\n};\n\nfunction createMarkupForStyles(styles) {\n  var serialized = '';\n  var delimiter = '';\n\n  for (var styleName in styles) {\n    if (!styles.hasOwnProperty(styleName)) {\n      continue;\n    }\n\n    var isCustomProperty = styleName.indexOf('--') === 0;\n    var styleValue = styles[styleName];\n\n    {\n      if (!isCustomProperty) {\n        warnValidStyle$1(styleName, styleValue);\n      }\n    }\n\n    if (styleValue != null) {\n      serialized += delimiter + (isCustomProperty ? styleName : processStyleName(styleName)) + ':';\n      serialized += dangerousStyleValue(styleName, styleValue, isCustomProperty);\n      delimiter = ';';\n    }\n  }\n\n  return serialized || null;\n}\n\nfunction warnNoop(publicInstance, callerName) {\n  {\n    var _constructor = publicInstance.constructor;\n    var componentName = _constructor && getComponentName(_constructor) || 'ReactClass';\n    var warningKey = componentName + '.' + callerName;\n\n    if (didWarnAboutNoopUpdateForComponent[warningKey]) {\n      return;\n    }\n\n    error('%s(...): Can only update a mounting component. ' + 'This usually means you called %s() outside componentWillMount() on the server. ' + 'This is a no-op.\\n\\nPlease check the code for the %s component.', callerName, callerName, componentName);\n\n    didWarnAboutNoopUpdateForComponent[warningKey] = true;\n  }\n}\n\nfunction shouldConstruct$1(Component) {\n  return Component.prototype && Component.prototype.isReactComponent;\n}\n\nfunction getNonChildrenInnerMarkup(props) {\n  var innerHTML = props.dangerouslySetInnerHTML;\n\n  if (innerHTML != null) {\n    if (innerHTML.__html != null) {\n      return innerHTML.__html;\n    }\n  } else {\n    var content = props.children;\n\n    if (typeof content === 'string' || typeof content === 'number') {\n      return escapeTextForBrowser(content);\n    }\n  }\n\n  return null;\n}\n\nfunction flattenTopLevelChildren(children) {\n  if (!React.isValidElement(children)) {\n    return toArray(children);\n  }\n\n  var element = children;\n\n  if (element.type !== REACT_FRAGMENT_TYPE) {\n    return [element];\n  }\n\n  var fragmentChildren = element.props.children;\n\n  if (!React.isValidElement(fragmentChildren)) {\n    return toArray(fragmentChildren);\n  }\n\n  var fragmentChildElement = fragmentChildren;\n  return [fragmentChildElement];\n}\n\nfunction flattenOptionChildren(children) {\n  if (children === undefined || children === null) {\n    return children;\n  }\n\n  var content = ''; // Flatten children and warn if they aren't strings or numbers;\n  // invalid types are ignored.\n\n  React.Children.forEach(children, function (child) {\n    if (child == null) {\n      return;\n    }\n\n    content += child;\n\n    {\n      if (!didWarnInvalidOptionChildren && typeof child !== 'string' && typeof child !== 'number') {\n        didWarnInvalidOptionChildren = true;\n\n        error('Only strings and numbers are supported as <option> children.');\n      }\n    }\n  });\n  return content;\n}\n\nvar hasOwnProperty$2 = Object.prototype.hasOwnProperty;\nvar STYLE = 'style';\nvar RESERVED_PROPS = {\n  children: null,\n  dangerouslySetInnerHTML: null,\n  suppressContentEditableWarning: null,\n  suppressHydrationWarning: null\n};\n\nfunction createOpenTagMarkup(tagVerbatim, tagLowercase, props, namespace, makeStaticMarkup, isRootElement) {\n  var ret = '<' + tagVerbatim;\n  var isCustomComponent$1 = isCustomComponent(tagLowercase, props);\n\n  for (var propKey in props) {\n    if (!hasOwnProperty$2.call(props, propKey)) {\n      continue;\n    }\n\n    var propValue = props[propKey];\n\n    if (propValue == null) {\n      continue;\n    }\n\n    if (propKey === STYLE) {\n      propValue = createMarkupForStyles(propValue);\n    }\n\n    var markup = null;\n\n    if (isCustomComponent$1) {\n      if (!RESERVED_PROPS.hasOwnProperty(propKey)) {\n        markup = createMarkupForCustomAttribute(propKey, propValue);\n      }\n    } else {\n      markup = createMarkupForProperty(propKey, propValue);\n    }\n\n    if (markup) {\n      ret += ' ' + markup;\n    }\n  } // For static pages, no need to put React ID and checksum. Saves lots of\n  // bytes.\n\n\n  if (makeStaticMarkup) {\n    return ret;\n  }\n\n  if (isRootElement) {\n    ret += ' ' + createMarkupForRoot();\n  }\n\n  return ret;\n}\n\nfunction validateRenderResult(child, type) {\n  if (child === undefined) {\n    {\n      {\n        throw Error( (getComponentName(type) || 'Component') + \"(...): Nothing was returned from render. This usually means a return statement is missing. Or, to render nothing, return null.\" );\n      }\n    }\n  }\n}\n\nfunction resolve(child, context, threadID) {\n  while (React.isValidElement(child)) {\n    // Safe because we just checked it's an element.\n    var element = child;\n    var Component = element.type;\n\n    {\n      pushElementToDebugStack(element);\n    }\n\n    if (typeof Component !== 'function') {\n      break;\n    }\n\n    processChild(element, Component);\n  } // Extra closure so queue and replace can be captured properly\n\n\n  function processChild(element, Component) {\n    var isClass = shouldConstruct$1(Component);\n    var publicContext = processContext(Component, context, threadID, isClass);\n    var queue = [];\n    var replace = false;\n    var updater = {\n      isMounted: function (publicInstance) {\n        return false;\n      },\n      enqueueForceUpdate: function (publicInstance) {\n        if (queue === null) {\n          warnNoop(publicInstance, 'forceUpdate');\n          return null;\n        }\n      },\n      enqueueReplaceState: function (publicInstance, completeState) {\n        replace = true;\n        queue = [completeState];\n      },\n      enqueueSetState: function (publicInstance, currentPartialState) {\n        if (queue === null) {\n          warnNoop(publicInstance, 'setState');\n          return null;\n        }\n\n        queue.push(currentPartialState);\n      }\n    };\n    var inst;\n\n    if (isClass) {\n      inst = new Component(element.props, publicContext, updater);\n\n      if (typeof Component.getDerivedStateFromProps === 'function') {\n        {\n          if (inst.state === null || inst.state === undefined) {\n            var componentName = getComponentName(Component) || 'Unknown';\n\n            if (!didWarnAboutUninitializedState[componentName]) {\n              error('`%s` uses `getDerivedStateFromProps` but its initial state is ' + '%s. This is not recommended. Instead, define the initial state by ' + 'assigning an object to `this.state` in the constructor of `%s`. ' + 'This ensures that `getDerivedStateFromProps` arguments have a consistent shape.', componentName, inst.state === null ? 'null' : 'undefined', componentName);\n\n              didWarnAboutUninitializedState[componentName] = true;\n            }\n          }\n        }\n\n        var partialState = Component.getDerivedStateFromProps.call(null, element.props, inst.state);\n\n        {\n          if (partialState === undefined) {\n            var _componentName = getComponentName(Component) || 'Unknown';\n\n            if (!didWarnAboutUndefinedDerivedState[_componentName]) {\n              error('%s.getDerivedStateFromProps(): A valid state object (or null) must be returned. ' + 'You have returned undefined.', _componentName);\n\n              didWarnAboutUndefinedDerivedState[_componentName] = true;\n            }\n          }\n        }\n\n        if (partialState != null) {\n          inst.state = _assign({}, inst.state, partialState);\n        }\n      }\n    } else {\n      {\n        if (Component.prototype && typeof Component.prototype.render === 'function') {\n          var _componentName2 = getComponentName(Component) || 'Unknown';\n\n          if (!didWarnAboutBadClass[_componentName2]) {\n            error(\"The <%s /> component appears to have a render method, but doesn't extend React.Component. \" + 'This is likely to cause errors. Change %s to extend React.Component instead.', _componentName2, _componentName2);\n\n            didWarnAboutBadClass[_componentName2] = true;\n          }\n        }\n      }\n\n      var componentIdentity = {};\n      prepareToUseHooks(componentIdentity);\n      inst = Component(element.props, publicContext, updater);\n      inst = finishHooks(Component, element.props, inst, publicContext);\n\n      {\n        // Support for module components is deprecated and is removed behind a flag.\n        // Whether or not it would crash later, we want to show a good message in DEV first.\n        if (inst != null && inst.render != null) {\n          var _componentName3 = getComponentName(Component) || 'Unknown';\n\n          if (!didWarnAboutModulePatternComponent[_componentName3]) {\n            error('The <%s /> component appears to be a function component that returns a class instance. ' + 'Change %s to a class that extends React.Component instead. ' + \"If you can't use a class try assigning the prototype on the function as a workaround. \" + \"`%s.prototype = React.Component.prototype`. Don't use an arrow function since it \" + 'cannot be called with `new` by React.', _componentName3, _componentName3, _componentName3);\n\n            didWarnAboutModulePatternComponent[_componentName3] = true;\n          }\n        }\n      } // If the flag is on, everything is assumed to be a function component.\n      // Otherwise, we also do the unfortunate dynamic checks.\n\n\n      if ( inst == null || inst.render == null) {\n        child = inst;\n        validateRenderResult(child, Component);\n        return;\n      }\n    }\n\n    inst.props = element.props;\n    inst.context = publicContext;\n    inst.updater = updater;\n    var initialState = inst.state;\n\n    if (initialState === undefined) {\n      inst.state = initialState = null;\n    }\n\n    if (typeof inst.UNSAFE_componentWillMount === 'function' || typeof inst.componentWillMount === 'function') {\n      if (typeof inst.componentWillMount === 'function') {\n        {\n          if ( inst.componentWillMount.__suppressDeprecationWarning !== true) {\n            var _componentName4 = getComponentName(Component) || 'Unknown';\n\n            if (!didWarnAboutDeprecatedWillMount[_componentName4]) {\n              warn( // keep this warning in sync with ReactStrictModeWarning.js\n              'componentWillMount has been renamed, and is not recommended for use. ' + 'See https://reactjs.org/link/unsafe-component-lifecycles for details.\\n\\n' + '* Move code from componentWillMount to componentDidMount (preferred in most cases) ' + 'or the constructor.\\n' + '\\nPlease update the following components: %s', _componentName4);\n\n              didWarnAboutDeprecatedWillMount[_componentName4] = true;\n            }\n          }\n        } // In order to support react-lifecycles-compat polyfilled components,\n        // Unsafe lifecycles should not be invoked for any component with the new gDSFP.\n\n\n        if (typeof Component.getDerivedStateFromProps !== 'function') {\n          inst.componentWillMount();\n        }\n      }\n\n      if (typeof inst.UNSAFE_componentWillMount === 'function' && typeof Component.getDerivedStateFromProps !== 'function') {\n        // In order to support react-lifecycles-compat polyfilled components,\n        // Unsafe lifecycles should not be invoked for any component with the new gDSFP.\n        inst.UNSAFE_componentWillMount();\n      }\n\n      if (queue.length) {\n        var oldQueue = queue;\n        var oldReplace = replace;\n        queue = null;\n        replace = false;\n\n        if (oldReplace && oldQueue.length === 1) {\n          inst.state = oldQueue[0];\n        } else {\n          var nextState = oldReplace ? oldQueue[0] : inst.state;\n          var dontMutate = true;\n\n          for (var i = oldReplace ? 1 : 0; i < oldQueue.length; i++) {\n            var partial = oldQueue[i];\n\n            var _partialState = typeof partial === 'function' ? partial.call(inst, nextState, element.props, publicContext) : partial;\n\n            if (_partialState != null) {\n              if (dontMutate) {\n                dontMutate = false;\n                nextState = _assign({}, nextState, _partialState);\n              } else {\n                _assign(nextState, _partialState);\n              }\n            }\n          }\n\n          inst.state = nextState;\n        }\n      } else {\n        queue = null;\n      }\n    }\n\n    child = inst.render();\n\n    {\n      if (child === undefined && inst.render._isMockFunction) {\n        // This is probably bad practice. Consider warning here and\n        // deprecating this convenience.\n        child = null;\n      }\n    }\n\n    validateRenderResult(child, Component);\n    var childContext;\n\n    {\n      if (typeof inst.getChildContext === 'function') {\n        var _childContextTypes = Component.childContextTypes;\n\n        if (typeof _childContextTypes === 'object') {\n          childContext = inst.getChildContext();\n\n          for (var contextKey in childContext) {\n            if (!(contextKey in _childContextTypes)) {\n              {\n                throw Error( (getComponentName(Component) || 'Unknown') + \".getChildContext(): key \\\"\" + contextKey + \"\\\" is not defined in childContextTypes.\" );\n              }\n            }\n          }\n        } else {\n          {\n            error('%s.getChildContext(): childContextTypes must be defined in order to ' + 'use getChildContext().', getComponentName(Component) || 'Unknown');\n          }\n        }\n      }\n\n      if (childContext) {\n        context = _assign({}, context, childContext);\n      }\n    }\n  }\n\n  return {\n    child: child,\n    context: context\n  };\n}\n\nvar ReactDOMServerRenderer = /*#__PURE__*/function () {\n  // TODO: type this more strictly:\n  // DEV-only\n  function ReactDOMServerRenderer(children, makeStaticMarkup, options) {\n    var flatChildren = flattenTopLevelChildren(children);\n    var topFrame = {\n      type: null,\n      // Assume all trees start in the HTML namespace (not totally true, but\n      // this is what we did historically)\n      domNamespace: Namespaces.html,\n      children: flatChildren,\n      childIndex: 0,\n      context: emptyObject,\n      footer: ''\n    };\n\n    {\n      topFrame.debugElementStack = [];\n    }\n\n    this.threadID = allocThreadID();\n    this.stack = [topFrame];\n    this.exhausted = false;\n    this.currentSelectValue = null;\n    this.previousWasTextNode = false;\n    this.makeStaticMarkup = makeStaticMarkup;\n    this.suspenseDepth = 0; // Context (new API)\n\n    this.contextIndex = -1;\n    this.contextStack = [];\n    this.contextValueStack = []; // useOpaqueIdentifier ID\n\n    this.uniqueID = 0;\n    this.identifierPrefix = options && options.identifierPrefix || '';\n\n    {\n      this.contextProviderStack = [];\n    }\n  }\n\n  var _proto = ReactDOMServerRenderer.prototype;\n\n  _proto.destroy = function destroy() {\n    if (!this.exhausted) {\n      this.exhausted = true;\n      this.clearProviders();\n      freeThreadID(this.threadID);\n    }\n  }\n  /**\n   * Note: We use just two stacks regardless of how many context providers you have.\n   * Providers are always popped in the reverse order to how they were pushed\n   * so we always know on the way down which provider you'll encounter next on the way up.\n   * On the way down, we push the current provider, and its context value *before*\n   * we mutated it, onto the stacks. Therefore, on the way up, we always know which\n   * provider needs to be \"restored\" to which value.\n   * https://github.com/facebook/react/pull/12985#issuecomment-396301248\n   */\n  ;\n\n  _proto.pushProvider = function pushProvider(provider) {\n    var index = ++this.contextIndex;\n    var context = provider.type._context;\n    var threadID = this.threadID;\n    validateContextBounds(context, threadID);\n    var previousValue = context[threadID]; // Remember which value to restore this context to on our way up.\n\n    this.contextStack[index] = context;\n    this.contextValueStack[index] = previousValue;\n\n    {\n      // Only used for push/pop mismatch warnings.\n      this.contextProviderStack[index] = provider;\n    } // Mutate the current value.\n\n\n    context[threadID] = provider.props.value;\n  };\n\n  _proto.popProvider = function popProvider(provider) {\n    var index = this.contextIndex;\n\n    {\n      if (index < 0 || provider !== this.contextProviderStack[index]) {\n        error('Unexpected pop.');\n      }\n    }\n\n    var context = this.contextStack[index];\n    var previousValue = this.contextValueStack[index]; // \"Hide\" these null assignments from Flow by using `any`\n    // because conceptually they are deletions--as long as we\n    // promise to never access values beyond `this.contextIndex`.\n\n    this.contextStack[index] = null;\n    this.contextValueStack[index] = null;\n\n    {\n      this.contextProviderStack[index] = null;\n    }\n\n    this.contextIndex--; // Restore to the previous value we stored as we were walking down.\n    // We've already verified that this context has been expanded to accommodate\n    // this thread id, so we don't need to do it again.\n\n    context[this.threadID] = previousValue;\n  };\n\n  _proto.clearProviders = function clearProviders() {\n    // Restore any remaining providers on the stack to previous values\n    for (var index = this.contextIndex; index >= 0; index--) {\n      var context = this.contextStack[index];\n      var previousValue = this.contextValueStack[index];\n      context[this.threadID] = previousValue;\n    }\n  };\n\n  _proto.read = function read(bytes) {\n    if (this.exhausted) {\n      return null;\n    }\n\n    var prevPartialRenderer = currentPartialRenderer;\n    setCurrentPartialRenderer(this);\n    var prevDispatcher = ReactCurrentDispatcher$1.current;\n    ReactCurrentDispatcher$1.current = Dispatcher;\n\n    try {\n      // Markup generated within <Suspense> ends up buffered until we know\n      // nothing in that boundary suspended\n      var out = [''];\n      var suspended = false;\n\n      while (out[0].length < bytes) {\n        if (this.stack.length === 0) {\n          this.exhausted = true;\n          freeThreadID(this.threadID);\n          break;\n        }\n\n        var frame = this.stack[this.stack.length - 1];\n\n        if (suspended || frame.childIndex >= frame.children.length) {\n          var footer = frame.footer;\n\n          if (footer !== '') {\n            this.previousWasTextNode = false;\n          }\n\n          this.stack.pop();\n\n          if (frame.type === 'select') {\n            this.currentSelectValue = null;\n          } else if (frame.type != null && frame.type.type != null && frame.type.type.$$typeof === REACT_PROVIDER_TYPE) {\n            var provider = frame.type;\n            this.popProvider(provider);\n          } else if (frame.type === REACT_SUSPENSE_TYPE) {\n            this.suspenseDepth--;\n            var buffered = out.pop();\n\n            if (suspended) {\n              suspended = false; // If rendering was suspended at this boundary, render the fallbackFrame\n\n              var fallbackFrame = frame.fallbackFrame;\n\n              if (!fallbackFrame) {\n                {\n                  throw Error(true ? \"ReactDOMServer did not find an internal fallback frame for Suspense. This is a bug in React. Please file an issue.\" : formatProdErrorMessage(303));\n                }\n              }\n\n              this.stack.push(fallbackFrame);\n              out[this.suspenseDepth] += '<!--$!-->'; // Skip flushing output since we're switching to the fallback\n\n              continue;\n            } else {\n              out[this.suspenseDepth] += buffered;\n            }\n          } // Flush output\n\n\n          out[this.suspenseDepth] += footer;\n          continue;\n        }\n\n        var child = frame.children[frame.childIndex++];\n        var outBuffer = '';\n\n        if (true) {\n          pushCurrentDebugStack(this.stack); // We're starting work on this frame, so reset its inner stack.\n\n          frame.debugElementStack.length = 0;\n        }\n\n        try {\n          outBuffer += this.render(child, frame.context, frame.domNamespace);\n        } catch (err) {\n          if (err != null && typeof err.then === 'function') {\n            if (enableSuspenseServerRenderer) {\n              if (!(this.suspenseDepth > 0)) {\n                {\n                  throw Error(true ? \"A React component suspended while rendering, but no fallback UI was specified.\\n\\nAdd a <Suspense fallback=...> component higher in the tree to provide a loading indicator or placeholder to display.\" : formatProdErrorMessage(342));\n                }\n              }\n\n              suspended = true;\n            } else {\n              if (!false) {\n                {\n                  throw Error(true ? \"ReactDOMServer does not yet support Suspense.\" : formatProdErrorMessage(294));\n                }\n              }\n            }\n          } else {\n            throw err;\n          }\n        } finally {\n          if (true) {\n            popCurrentDebugStack();\n          }\n        }\n\n        if (out.length <= this.suspenseDepth) {\n          out.push('');\n        }\n\n        out[this.suspenseDepth] += outBuffer;\n      }\n\n      return out[0];\n    } finally {\n      ReactCurrentDispatcher$1.current = prevDispatcher;\n      setCurrentPartialRenderer(prevPartialRenderer);\n      resetHooksState();\n    }\n  };\n\n  _proto.render = function render(child, context, parentNamespace) {\n    if (typeof child === 'string' || typeof child === 'number') {\n      var text = '' + child;\n\n      if (text === '') {\n        return '';\n      }\n\n      if (this.makeStaticMarkup) {\n        return escapeTextForBrowser(text);\n      }\n\n      if (this.previousWasTextNode) {\n        return '<!-- -->' + escapeTextForBrowser(text);\n      }\n\n      this.previousWasTextNode = true;\n      return escapeTextForBrowser(text);\n    } else {\n      var nextChild;\n\n      var _resolve = resolve(child, context, this.threadID);\n\n      nextChild = _resolve.child;\n      context = _resolve.context;\n\n      if (nextChild === null || nextChild === false) {\n        return '';\n      } else if (!React.isValidElement(nextChild)) {\n        if (nextChild != null && nextChild.$$typeof != null) {\n          // Catch unexpected special types early.\n          var $$typeof = nextChild.$$typeof;\n\n          if (!($$typeof !== REACT_PORTAL_TYPE)) {\n            {\n              throw Error( \"Portals are not currently supported by the server renderer. Render them conditionally so that they only appear on the client render.\" );\n            }\n          } // Catch-all to prevent an infinite loop if React.Children.toArray() supports some new type.\n\n\n          {\n            {\n              throw Error( \"Unknown element-like object type: \" + $$typeof.toString() + \". This is likely a bug in React. Please file an issue.\" );\n            }\n          }\n        }\n\n        var nextChildren = toArray(nextChild);\n        var frame = {\n          type: null,\n          domNamespace: parentNamespace,\n          children: nextChildren,\n          childIndex: 0,\n          context: context,\n          footer: ''\n        };\n\n        {\n          frame.debugElementStack = [];\n        }\n\n        this.stack.push(frame);\n        return '';\n      } // Safe because we just checked it's an element.\n\n\n      var nextElement = nextChild;\n      var elementType = nextElement.type;\n\n      if (typeof elementType === 'string') {\n        return this.renderDOM(nextElement, context, parentNamespace);\n      }\n\n      switch (elementType) {\n        // TODO: LegacyHidden acts the same as a fragment. This only works\n        // because we currently assume that every instance of LegacyHidden is\n        // accompanied by a host component wrapper. In the hidden mode, the host\n        // component is given a `hidden` attribute, which ensures that the\n        // initial HTML is not visible. To support the use of LegacyHidden as a\n        // true fragment, without an extra DOM node, we would have to hide the\n        // initial HTML in some other way.\n        case REACT_LEGACY_HIDDEN_TYPE:\n        case REACT_DEBUG_TRACING_MODE_TYPE:\n        case REACT_STRICT_MODE_TYPE:\n        case REACT_PROFILER_TYPE:\n        case REACT_SUSPENSE_LIST_TYPE:\n        case REACT_FRAGMENT_TYPE:\n          {\n            var _nextChildren = toArray(nextChild.props.children);\n\n            var _frame = {\n              type: null,\n              domNamespace: parentNamespace,\n              children: _nextChildren,\n              childIndex: 0,\n              context: context,\n              footer: ''\n            };\n\n            {\n              _frame.debugElementStack = [];\n            }\n\n            this.stack.push(_frame);\n            return '';\n          }\n\n        case REACT_SUSPENSE_TYPE:\n          {\n            {\n              {\n                {\n                  throw Error( \"ReactDOMServer does not yet support Suspense.\" );\n                }\n              }\n            }\n          }\n        // eslint-disable-next-line-no-fallthrough\n\n        case REACT_SCOPE_TYPE:\n          {\n\n            {\n              {\n                throw Error( \"ReactDOMServer does not yet support scope components.\" );\n              }\n            }\n          }\n      }\n\n      if (typeof elementType === 'object' && elementType !== null) {\n        switch (elementType.$$typeof) {\n          case REACT_FORWARD_REF_TYPE:\n            {\n              var element = nextChild;\n\n              var _nextChildren5;\n\n              var componentIdentity = {};\n              prepareToUseHooks(componentIdentity);\n              _nextChildren5 = elementType.render(element.props, element.ref);\n              _nextChildren5 = finishHooks(elementType.render, element.props, _nextChildren5, element.ref);\n              _nextChildren5 = toArray(_nextChildren5);\n              var _frame5 = {\n                type: null,\n                domNamespace: parentNamespace,\n                children: _nextChildren5,\n                childIndex: 0,\n                context: context,\n                footer: ''\n              };\n\n              {\n                _frame5.debugElementStack = [];\n              }\n\n              this.stack.push(_frame5);\n              return '';\n            }\n\n          case REACT_MEMO_TYPE:\n            {\n              var _element = nextChild;\n              var _nextChildren6 = [React.createElement(elementType.type, _assign({\n                ref: _element.ref\n              }, _element.props))];\n              var _frame6 = {\n                type: null,\n                domNamespace: parentNamespace,\n                children: _nextChildren6,\n                childIndex: 0,\n                context: context,\n                footer: ''\n              };\n\n              {\n                _frame6.debugElementStack = [];\n              }\n\n              this.stack.push(_frame6);\n              return '';\n            }\n\n          case REACT_PROVIDER_TYPE:\n            {\n              var provider = nextChild;\n              var nextProps = provider.props;\n\n              var _nextChildren7 = toArray(nextProps.children);\n\n              var _frame7 = {\n                type: provider,\n                domNamespace: parentNamespace,\n                children: _nextChildren7,\n                childIndex: 0,\n                context: context,\n                footer: ''\n              };\n\n              {\n                _frame7.debugElementStack = [];\n              }\n\n              this.pushProvider(provider);\n              this.stack.push(_frame7);\n              return '';\n            }\n\n          case REACT_CONTEXT_TYPE:\n            {\n              var reactContext = nextChild.type; // The logic below for Context differs depending on PROD or DEV mode. In\n              // DEV mode, we create a separate object for Context.Consumer that acts\n              // like a proxy to Context. This proxy object adds unnecessary code in PROD\n              // so we use the old behaviour (Context.Consumer references Context) to\n              // reduce size and overhead. The separate object references context via\n              // a property called \"_context\", which also gives us the ability to check\n              // in DEV mode if this property exists or not and warn if it does not.\n\n              {\n                if (reactContext._context === undefined) {\n                  // This may be because it's a Context (rather than a Consumer).\n                  // Or it may be because it's older React where they're the same thing.\n                  // We only want to warn if we're sure it's a new React.\n                  if (reactContext !== reactContext.Consumer) {\n                    if (!hasWarnedAboutUsingContextAsConsumer) {\n                      hasWarnedAboutUsingContextAsConsumer = true;\n\n                      error('Rendering <Context> directly is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Consumer> instead?');\n                    }\n                  }\n                } else {\n                  reactContext = reactContext._context;\n                }\n              }\n\n              var _nextProps = nextChild.props;\n              var threadID = this.threadID;\n              validateContextBounds(reactContext, threadID);\n              var nextValue = reactContext[threadID];\n\n              var _nextChildren8 = toArray(_nextProps.children(nextValue));\n\n              var _frame8 = {\n                type: nextChild,\n                domNamespace: parentNamespace,\n                children: _nextChildren8,\n                childIndex: 0,\n                context: context,\n                footer: ''\n              };\n\n              {\n                _frame8.debugElementStack = [];\n              }\n\n              this.stack.push(_frame8);\n              return '';\n            }\n          // eslint-disable-next-line-no-fallthrough\n\n          case REACT_FUNDAMENTAL_TYPE:\n            {\n\n              {\n                {\n                  throw Error( \"ReactDOMServer does not yet support the fundamental API.\" );\n                }\n              }\n            }\n          // eslint-disable-next-line-no-fallthrough\n\n          case REACT_LAZY_TYPE:\n            {\n              var _element2 = nextChild;\n              var lazyComponent = nextChild.type; // Attempt to initialize lazy component regardless of whether the\n              // suspense server-side renderer is enabled so synchronously\n              // resolved constructors are supported.\n\n              var payload = lazyComponent._payload;\n              var init = lazyComponent._init;\n              var result = init(payload);\n              var _nextChildren10 = [React.createElement(result, _assign({\n                ref: _element2.ref\n              }, _element2.props))];\n              var _frame10 = {\n                type: null,\n                domNamespace: parentNamespace,\n                children: _nextChildren10,\n                childIndex: 0,\n                context: context,\n                footer: ''\n              };\n\n              {\n                _frame10.debugElementStack = [];\n              }\n\n              this.stack.push(_frame10);\n              return '';\n            }\n        }\n      }\n\n      var info = '';\n\n      {\n        var owner = nextElement._owner;\n\n        if (elementType === undefined || typeof elementType === 'object' && elementType !== null && Object.keys(elementType).length === 0) {\n          info += ' You likely forgot to export your component from the file ' + \"it's defined in, or you might have mixed up default and \" + 'named imports.';\n        }\n\n        var ownerName = owner ? getComponentName(owner) : null;\n\n        if (ownerName) {\n          info += '\\n\\nCheck the render method of `' + ownerName + '`.';\n        }\n      }\n\n      {\n        {\n          throw Error( \"Element type is invalid: expected a string (for built-in components) or a class/function (for composite components) but got: \" + (elementType == null ? elementType : typeof elementType) + \".\" + info );\n        }\n      }\n    }\n  };\n\n  _proto.renderDOM = function renderDOM(element, context, parentNamespace) {\n    var tag = element.type.toLowerCase();\n    var namespace = parentNamespace;\n\n    if (parentNamespace === Namespaces.html) {\n      namespace = getIntrinsicNamespace(tag);\n    }\n\n    {\n      if (namespace === Namespaces.html) {\n        // Should this check be gated by parent namespace? Not sure we want to\n        // allow <SVG> or <mATH>.\n        if (tag !== element.type) {\n          error('<%s /> is using incorrect casing. ' + 'Use PascalCase for React components, ' + 'or lowercase for HTML elements.', element.type);\n        }\n      }\n    }\n\n    validateDangerousTag(tag);\n    var props = element.props;\n\n    if (tag === 'input') {\n      {\n        checkControlledValueProps('input', props);\n\n        if (props.checked !== undefined && props.defaultChecked !== undefined && !didWarnDefaultChecked) {\n          error('%s contains an input of type %s with both checked and defaultChecked props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the checked prop, or the defaultChecked prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components', 'A component', props.type);\n\n          didWarnDefaultChecked = true;\n        }\n\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultInputValue) {\n          error('%s contains an input of type %s with both value and defaultValue props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components', 'A component', props.type);\n\n          didWarnDefaultInputValue = true;\n        }\n      }\n\n      props = _assign({\n        type: undefined\n      }, props, {\n        defaultChecked: undefined,\n        defaultValue: undefined,\n        value: props.value != null ? props.value : props.defaultValue,\n        checked: props.checked != null ? props.checked : props.defaultChecked\n      });\n    } else if (tag === 'textarea') {\n      {\n        checkControlledValueProps('textarea', props);\n\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultTextareaValue) {\n          error('Textarea elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled textarea ' + 'and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components');\n\n          didWarnDefaultTextareaValue = true;\n        }\n      }\n\n      var initialValue = props.value;\n\n      if (initialValue == null) {\n        var defaultValue = props.defaultValue; // TODO (yungsters): Remove support for children content in <textarea>.\n\n        var textareaChildren = props.children;\n\n        if (textareaChildren != null) {\n          {\n            error('Use the `defaultValue` or `value` props instead of setting ' + 'children on <textarea>.');\n          }\n\n          if (!(defaultValue == null)) {\n            {\n              throw Error( \"If you supply `defaultValue` on a <textarea>, do not pass children.\" );\n            }\n          }\n\n          if (Array.isArray(textareaChildren)) {\n            if (!(textareaChildren.length <= 1)) {\n              {\n                throw Error( \"<textarea> can only have at most one child.\" );\n              }\n            }\n\n            textareaChildren = textareaChildren[0];\n          }\n\n          defaultValue = '' + textareaChildren;\n        }\n\n        if (defaultValue == null) {\n          defaultValue = '';\n        }\n\n        initialValue = defaultValue;\n      }\n\n      props = _assign({}, props, {\n        value: undefined,\n        children: '' + initialValue\n      });\n    } else if (tag === 'select') {\n      {\n        checkControlledValueProps('select', props);\n\n        for (var i = 0; i < valuePropNames.length; i++) {\n          var propName = valuePropNames[i];\n\n          if (props[propName] == null) {\n            continue;\n          }\n\n          var isArray = Array.isArray(props[propName]);\n\n          if (props.multiple && !isArray) {\n            error('The `%s` prop supplied to <select> must be an array if ' + '`multiple` is true.', propName);\n          } else if (!props.multiple && isArray) {\n            error('The `%s` prop supplied to <select> must be a scalar ' + 'value if `multiple` is false.', propName);\n          }\n        }\n\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultSelectValue) {\n          error('Select elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled select ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components');\n\n          didWarnDefaultSelectValue = true;\n        }\n      }\n\n      this.currentSelectValue = props.value != null ? props.value : props.defaultValue;\n      props = _assign({}, props, {\n        value: undefined\n      });\n    } else if (tag === 'option') {\n      var selected = null;\n      var selectValue = this.currentSelectValue;\n      var optionChildren = flattenOptionChildren(props.children);\n\n      if (selectValue != null) {\n        var value;\n\n        if (props.value != null) {\n          value = props.value + '';\n        } else {\n          value = optionChildren;\n        }\n\n        selected = false;\n\n        if (Array.isArray(selectValue)) {\n          // multiple\n          for (var j = 0; j < selectValue.length; j++) {\n            if ('' + selectValue[j] === value) {\n              selected = true;\n              break;\n            }\n          }\n        } else {\n          selected = '' + selectValue === value;\n        }\n\n        props = _assign({\n          selected: undefined,\n          children: undefined\n        }, props, {\n          selected: selected,\n          children: optionChildren\n        });\n      }\n    }\n\n    {\n      validatePropertiesInDevelopment(tag, props);\n    }\n\n    assertValidProps(tag, props);\n    var out = createOpenTagMarkup(element.type, tag, props, namespace, this.makeStaticMarkup, this.stack.length === 1);\n    var footer = '';\n\n    if (omittedCloseTags.hasOwnProperty(tag)) {\n      out += '/>';\n    } else {\n      out += '>';\n      footer = '</' + element.type + '>';\n    }\n\n    var children;\n    var innerMarkup = getNonChildrenInnerMarkup(props);\n\n    if (innerMarkup != null) {\n      children = [];\n\n      if (newlineEatingTags.hasOwnProperty(tag) && innerMarkup.charAt(0) === '\\n') {\n        // text/html ignores the first character in these tags if it's a newline\n        // Prefer to break application/xml over text/html (for now) by adding\n        // a newline specifically to get eaten by the parser. (Alternately for\n        // textareas, replacing \"^\\n\" with \"\\r\\n\" doesn't get eaten, and the first\n        // \\r is normalized out by HTMLTextAreaElement#value.)\n        // See: <http://www.w3.org/TR/html-polyglot/#newlines-in-textarea-and-pre>\n        // See: <http://www.w3.org/TR/html5/syntax.html#element-restrictions>\n        // See: <http://www.w3.org/TR/html5/syntax.html#newlines>\n        // See: Parsing of \"textarea\" \"listing\" and \"pre\" elements\n        //  from <http://www.w3.org/TR/html5/syntax.html#parsing-main-inbody>\n        out += '\\n';\n      }\n\n      out += innerMarkup;\n    } else {\n      children = toArray(props.children);\n    }\n\n    var frame = {\n      domNamespace: getChildNamespace(parentNamespace, element.type),\n      type: tag,\n      children: children,\n      childIndex: 0,\n      context: context,\n      footer: footer\n    };\n\n    {\n      frame.debugElementStack = [];\n    }\n\n    this.stack.push(frame);\n    this.previousWasTextNode = false;\n    return out;\n  };\n\n  return ReactDOMServerRenderer;\n}();\n\n/**\n * Render a ReactElement to its initial HTML. This should only be used on the\n * server.\n * See https://reactjs.org/docs/react-dom-server.html#rendertostring\n */\n\nfunction renderToString(element, options) {\n  var renderer = new ReactDOMServerRenderer(element, false, options);\n\n  try {\n    var markup = renderer.read(Infinity);\n    return markup;\n  } finally {\n    renderer.destroy();\n  }\n}\n/**\n * Similar to renderToString, except this doesn't create extra DOM attributes\n * such as data-react-id that React uses internally.\n * See https://reactjs.org/docs/react-dom-server.html#rendertostaticmarkup\n */\n\nfunction renderToStaticMarkup(element, options) {\n  var renderer = new ReactDOMServerRenderer(element, true, options);\n\n  try {\n    var markup = renderer.read(Infinity);\n    return markup;\n  } finally {\n    renderer.destroy();\n  }\n}\n\nfunction renderToNodeStream() {\n  {\n    {\n      throw Error( \"ReactDOMServer.renderToNodeStream(): The streaming API is not available in the browser. Use ReactDOMServer.renderToString() instead.\" );\n    }\n  }\n}\n\nfunction renderToStaticNodeStream() {\n  {\n    {\n      throw Error( \"ReactDOMServer.renderToStaticNodeStream(): The streaming API is not available in the browser. Use ReactDOMServer.renderToStaticMarkup() instead.\" );\n    }\n  }\n}\n\nexports.renderToNodeStream = renderToNodeStream;\nexports.renderToStaticMarkup = renderToStaticMarkup;\nexports.renderToStaticNodeStream = renderToStaticNodeStream;\nexports.renderToString = renderToString;\nexports.version = ReactVersion;\n  })();\n}\n\n};","~:removed-requires",["~#set",["~$module$node_modules$object_assign$index","~$module$react"]],"~:actual-requires",["^5",["~$shadow.js"]],"~:properties",["^5",[]],"~:compiled-at",1766065009878,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$react_dom$cjs$react_dom_server_browser_development.js\",\n\"lineCount\":1,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC;\",\n\"sources\":[\"node_modules/react-dom/cjs/react-dom-server.browser.development.js\"],\n\"sourcesContent\":[\"shadow$provide[618] = function(global,require,module,exports) {\\n/** @license React v17.0.2\\n * react-dom-server.browser.development.js\\n *\\n * Copyright (c) Facebook, Inc. and its affiliates.\\n *\\n * This source code is licensed under the MIT license found in the\\n * LICENSE file in the root directory of this source tree.\\n */\\n\\n'use strict';\\n\\nif (process.env.NODE_ENV !== \\\"production\\\") {\\n  (function() {\\n'use strict';\\n\\nvar React = require('react');\\nvar _assign = require('object-assign');\\n\\n// Do not require this module directly! Use normal `invariant` calls with\\n// template literal strings. The messages will be replaced with error codes\\n// during build.\\nfunction formatProdErrorMessage(code) {\\n  var url = 'https://reactjs.org/docs/error-decoder.html?invariant=' + code;\\n\\n  for (var i = 1; i < arguments.length; i++) {\\n    url += '&args[]=' + encodeURIComponent(arguments[i]);\\n  }\\n\\n  return \\\"Minified React error #\\\" + code + \\\"; visit \\\" + url + \\\" for the full message or \\\" + 'use the non-minified dev environment for full errors and additional ' + 'helpful warnings.';\\n}\\n\\n// TODO: this is special because it gets imported during build.\\nvar ReactVersion = '17.0.2';\\n\\nvar ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;\\n\\n// by calls to these methods by a Babel plugin.\\n//\\n// In PROD (or in packages without access to React internals),\\n// they are left as they are instead.\\n\\nfunction warn(format) {\\n  {\\n    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\\n      args[_key - 1] = arguments[_key];\\n    }\\n\\n    printWarning('warn', format, args);\\n  }\\n}\\nfunction error(format) {\\n  {\\n    for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {\\n      args[_key2 - 1] = arguments[_key2];\\n    }\\n\\n    printWarning('error', format, args);\\n  }\\n}\\n\\nfunction printWarning(level, format, args) {\\n  // When changing this logic, you might want to also\\n  // update consoleWithStackDev.www.js as well.\\n  {\\n    var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;\\n    var stack = ReactDebugCurrentFrame.getStackAddendum();\\n\\n    if (stack !== '') {\\n      format += '%s';\\n      args = args.concat([stack]);\\n    }\\n\\n    var argsWithFormat = args.map(function (item) {\\n      return '' + item;\\n    }); // Careful: RN currently depends on this prefix\\n\\n    argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it\\n    // breaks IE9: https://github.com/facebook/react/issues/13610\\n    // eslint-disable-next-line react-internal/no-production-logging\\n\\n    Function.prototype.apply.call(console[level], console, argsWithFormat);\\n  }\\n}\\n\\n// ATTENTION\\n// When adding new symbols to this file,\\n// Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'\\n// The Symbol used to tag the ReactElement-like types. If there is no native Symbol\\n// nor polyfill, then a plain number is used for performance.\\nvar REACT_ELEMENT_TYPE = 0xeac7;\\nvar REACT_PORTAL_TYPE = 0xeaca;\\nvar REACT_FRAGMENT_TYPE = 0xeacb;\\nvar REACT_STRICT_MODE_TYPE = 0xeacc;\\nvar REACT_PROFILER_TYPE = 0xead2;\\nvar REACT_PROVIDER_TYPE = 0xeacd;\\nvar REACT_CONTEXT_TYPE = 0xeace;\\nvar REACT_FORWARD_REF_TYPE = 0xead0;\\nvar REACT_SUSPENSE_TYPE = 0xead1;\\nvar REACT_SUSPENSE_LIST_TYPE = 0xead8;\\nvar REACT_MEMO_TYPE = 0xead3;\\nvar REACT_LAZY_TYPE = 0xead4;\\nvar REACT_BLOCK_TYPE = 0xead9;\\nvar REACT_SERVER_BLOCK_TYPE = 0xeada;\\nvar REACT_FUNDAMENTAL_TYPE = 0xead5;\\nvar REACT_SCOPE_TYPE = 0xead7;\\nvar REACT_OPAQUE_ID_TYPE = 0xeae0;\\nvar REACT_DEBUG_TRACING_MODE_TYPE = 0xeae1;\\nvar REACT_OFFSCREEN_TYPE = 0xeae2;\\nvar REACT_LEGACY_HIDDEN_TYPE = 0xeae3;\\n\\nif (typeof Symbol === 'function' && Symbol.for) {\\n  var symbolFor = Symbol.for;\\n  REACT_ELEMENT_TYPE = symbolFor('react.element');\\n  REACT_PORTAL_TYPE = symbolFor('react.portal');\\n  REACT_FRAGMENT_TYPE = symbolFor('react.fragment');\\n  REACT_STRICT_MODE_TYPE = symbolFor('react.strict_mode');\\n  REACT_PROFILER_TYPE = symbolFor('react.profiler');\\n  REACT_PROVIDER_TYPE = symbolFor('react.provider');\\n  REACT_CONTEXT_TYPE = symbolFor('react.context');\\n  REACT_FORWARD_REF_TYPE = symbolFor('react.forward_ref');\\n  REACT_SUSPENSE_TYPE = symbolFor('react.suspense');\\n  REACT_SUSPENSE_LIST_TYPE = symbolFor('react.suspense_list');\\n  REACT_MEMO_TYPE = symbolFor('react.memo');\\n  REACT_LAZY_TYPE = symbolFor('react.lazy');\\n  REACT_BLOCK_TYPE = symbolFor('react.block');\\n  REACT_SERVER_BLOCK_TYPE = symbolFor('react.server.block');\\n  REACT_FUNDAMENTAL_TYPE = symbolFor('react.fundamental');\\n  REACT_SCOPE_TYPE = symbolFor('react.scope');\\n  REACT_OPAQUE_ID_TYPE = symbolFor('react.opaque.id');\\n  REACT_DEBUG_TRACING_MODE_TYPE = symbolFor('react.debug_trace_mode');\\n  REACT_OFFSCREEN_TYPE = symbolFor('react.offscreen');\\n  REACT_LEGACY_HIDDEN_TYPE = symbolFor('react.legacy_hidden');\\n}\\n\\nfunction getWrappedName(outerType, innerType, wrapperName) {\\n  var functionName = innerType.displayName || innerType.name || '';\\n  return outerType.displayName || (functionName !== '' ? wrapperName + \\\"(\\\" + functionName + \\\")\\\" : wrapperName);\\n}\\n\\nfunction getContextName(type) {\\n  return type.displayName || 'Context';\\n}\\n\\nfunction getComponentName(type) {\\n  if (type == null) {\\n    // Host root, text node or just invalid type.\\n    return null;\\n  }\\n\\n  {\\n    if (typeof type.tag === 'number') {\\n      error('Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');\\n    }\\n  }\\n\\n  if (typeof type === 'function') {\\n    return type.displayName || type.name || null;\\n  }\\n\\n  if (typeof type === 'string') {\\n    return type;\\n  }\\n\\n  switch (type) {\\n    case REACT_FRAGMENT_TYPE:\\n      return 'Fragment';\\n\\n    case REACT_PORTAL_TYPE:\\n      return 'Portal';\\n\\n    case REACT_PROFILER_TYPE:\\n      return 'Profiler';\\n\\n    case REACT_STRICT_MODE_TYPE:\\n      return 'StrictMode';\\n\\n    case REACT_SUSPENSE_TYPE:\\n      return 'Suspense';\\n\\n    case REACT_SUSPENSE_LIST_TYPE:\\n      return 'SuspenseList';\\n  }\\n\\n  if (typeof type === 'object') {\\n    switch (type.$$typeof) {\\n      case REACT_CONTEXT_TYPE:\\n        var context = type;\\n        return getContextName(context) + '.Consumer';\\n\\n      case REACT_PROVIDER_TYPE:\\n        var provider = type;\\n        return getContextName(provider._context) + '.Provider';\\n\\n      case REACT_FORWARD_REF_TYPE:\\n        return getWrappedName(type, type.render, 'ForwardRef');\\n\\n      case REACT_MEMO_TYPE:\\n        return getComponentName(type.type);\\n\\n      case REACT_BLOCK_TYPE:\\n        return getComponentName(type._render);\\n\\n      case REACT_LAZY_TYPE:\\n        {\\n          var lazyComponent = type;\\n          var payload = lazyComponent._payload;\\n          var init = lazyComponent._init;\\n\\n          try {\\n            return getComponentName(init(payload));\\n          } catch (x) {\\n            return null;\\n          }\\n        }\\n    }\\n  }\\n\\n  return null;\\n}\\n\\n// Filter certain DOM attributes (e.g. src, href) if their values are empty strings.\\n\\nvar enableSuspenseServerRenderer = false;\\n\\n// Helpers to patch console.logs to avoid logging during side-effect free\\n// replaying on render function. This currently only patches the object\\n// lazily which won't cover if the log function was extracted eagerly.\\n// We could also eagerly patch the method.\\nvar disabledDepth = 0;\\nvar prevLog;\\nvar prevInfo;\\nvar prevWarn;\\nvar prevError;\\nvar prevGroup;\\nvar prevGroupCollapsed;\\nvar prevGroupEnd;\\n\\nfunction disabledLog() {}\\n\\ndisabledLog.__reactDisabledLog = true;\\nfunction disableLogs() {\\n  {\\n    if (disabledDepth === 0) {\\n      /* eslint-disable react-internal/no-production-logging */\\n      prevLog = console.log;\\n      prevInfo = console.info;\\n      prevWarn = console.warn;\\n      prevError = console.error;\\n      prevGroup = console.group;\\n      prevGroupCollapsed = console.groupCollapsed;\\n      prevGroupEnd = console.groupEnd; // https://github.com/facebook/react/issues/19099\\n\\n      var props = {\\n        configurable: true,\\n        enumerable: true,\\n        value: disabledLog,\\n        writable: true\\n      }; // $FlowFixMe Flow thinks console is immutable.\\n\\n      Object.defineProperties(console, {\\n        info: props,\\n        log: props,\\n        warn: props,\\n        error: props,\\n        group: props,\\n        groupCollapsed: props,\\n        groupEnd: props\\n      });\\n      /* eslint-enable react-internal/no-production-logging */\\n    }\\n\\n    disabledDepth++;\\n  }\\n}\\nfunction reenableLogs() {\\n  {\\n    disabledDepth--;\\n\\n    if (disabledDepth === 0) {\\n      /* eslint-disable react-internal/no-production-logging */\\n      var props = {\\n        configurable: true,\\n        enumerable: true,\\n        writable: true\\n      }; // $FlowFixMe Flow thinks console is immutable.\\n\\n      Object.defineProperties(console, {\\n        log: _assign({}, props, {\\n          value: prevLog\\n        }),\\n        info: _assign({}, props, {\\n          value: prevInfo\\n        }),\\n        warn: _assign({}, props, {\\n          value: prevWarn\\n        }),\\n        error: _assign({}, props, {\\n          value: prevError\\n        }),\\n        group: _assign({}, props, {\\n          value: prevGroup\\n        }),\\n        groupCollapsed: _assign({}, props, {\\n          value: prevGroupCollapsed\\n        }),\\n        groupEnd: _assign({}, props, {\\n          value: prevGroupEnd\\n        })\\n      });\\n      /* eslint-enable react-internal/no-production-logging */\\n    }\\n\\n    if (disabledDepth < 0) {\\n      error('disabledDepth fell below zero. ' + 'This is a bug in React. Please file an issue.');\\n    }\\n  }\\n}\\n\\nvar ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;\\nvar prefix;\\nfunction describeBuiltInComponentFrame(name, source, ownerFn) {\\n  {\\n    if (prefix === undefined) {\\n      // Extract the VM specific prefix used by each line.\\n      try {\\n        throw Error();\\n      } catch (x) {\\n        var match = x.stack.trim().match(/\\\\n( *(at )?)/);\\n        prefix = match && match[1] || '';\\n      }\\n    } // We use the prefix to ensure our stacks line up with native stack frames.\\n\\n\\n    return '\\\\n' + prefix + name;\\n  }\\n}\\nvar reentry = false;\\nvar componentFrameCache;\\n\\n{\\n  var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;\\n  componentFrameCache = new PossiblyWeakMap();\\n}\\n\\nfunction describeNativeComponentFrame(fn, construct) {\\n  // If something asked for a stack inside a fake render, it should get ignored.\\n  if (!fn || reentry) {\\n    return '';\\n  }\\n\\n  {\\n    var frame = componentFrameCache.get(fn);\\n\\n    if (frame !== undefined) {\\n      return frame;\\n    }\\n  }\\n\\n  var control;\\n  reentry = true;\\n  var previousPrepareStackTrace = Error.prepareStackTrace; // $FlowFixMe It does accept undefined.\\n\\n  Error.prepareStackTrace = undefined;\\n  var previousDispatcher;\\n\\n  {\\n    previousDispatcher = ReactCurrentDispatcher.current; // Set the dispatcher in DEV because this might be call in the render function\\n    // for warnings.\\n\\n    ReactCurrentDispatcher.current = null;\\n    disableLogs();\\n  }\\n\\n  try {\\n    // This should throw.\\n    if (construct) {\\n      // Something should be setting the props in the constructor.\\n      var Fake = function () {\\n        throw Error();\\n      }; // $FlowFixMe\\n\\n\\n      Object.defineProperty(Fake.prototype, 'props', {\\n        set: function () {\\n          // We use a throwing setter instead of frozen or non-writable props\\n          // because that won't throw in a non-strict mode function.\\n          throw Error();\\n        }\\n      });\\n\\n      if (typeof Reflect === 'object' && Reflect.construct) {\\n        // We construct a different control for this case to include any extra\\n        // frames added by the construct call.\\n        try {\\n          Reflect.construct(Fake, []);\\n        } catch (x) {\\n          control = x;\\n        }\\n\\n        Reflect.construct(fn, [], Fake);\\n      } else {\\n        try {\\n          Fake.call();\\n        } catch (x) {\\n          control = x;\\n        }\\n\\n        fn.call(Fake.prototype);\\n      }\\n    } else {\\n      try {\\n        throw Error();\\n      } catch (x) {\\n        control = x;\\n      }\\n\\n      fn();\\n    }\\n  } catch (sample) {\\n    // This is inlined manually because closure doesn't do it for us.\\n    if (sample && control && typeof sample.stack === 'string') {\\n      // This extracts the first frame from the sample that isn't also in the control.\\n      // Skipping one frame that we assume is the frame that calls the two.\\n      var sampleLines = sample.stack.split('\\\\n');\\n      var controlLines = control.stack.split('\\\\n');\\n      var s = sampleLines.length - 1;\\n      var c = controlLines.length - 1;\\n\\n      while (s >= 1 && c >= 0 && sampleLines[s] !== controlLines[c]) {\\n        // We expect at least one stack frame to be shared.\\n        // Typically this will be the root most one. However, stack frames may be\\n        // cut off due to maximum stack limits. In this case, one maybe cut off\\n        // earlier than the other. We assume that the sample is longer or the same\\n        // and there for cut off earlier. So we should find the root most frame in\\n        // the sample somewhere in the control.\\n        c--;\\n      }\\n\\n      for (; s >= 1 && c >= 0; s--, c--) {\\n        // Next we find the first one that isn't the same which should be the\\n        // frame that called our sample function and the control.\\n        if (sampleLines[s] !== controlLines[c]) {\\n          // In V8, the first line is describing the message but other VMs don't.\\n          // If we're about to return the first line, and the control is also on the same\\n          // line, that's a pretty good indicator that our sample threw at same line as\\n          // the control. I.e. before we entered the sample frame. So we ignore this result.\\n          // This can happen if you passed a class to function component, or non-function.\\n          if (s !== 1 || c !== 1) {\\n            do {\\n              s--;\\n              c--; // We may still have similar intermediate frames from the construct call.\\n              // The next one that isn't the same should be our match though.\\n\\n              if (c < 0 || sampleLines[s] !== controlLines[c]) {\\n                // V8 adds a \\\"new\\\" prefix for native classes. Let's remove it to make it prettier.\\n                var _frame = '\\\\n' + sampleLines[s].replace(' at new ', ' at ');\\n\\n                {\\n                  if (typeof fn === 'function') {\\n                    componentFrameCache.set(fn, _frame);\\n                  }\\n                } // Return the line we found.\\n\\n\\n                return _frame;\\n              }\\n            } while (s >= 1 && c >= 0);\\n          }\\n\\n          break;\\n        }\\n      }\\n    }\\n  } finally {\\n    reentry = false;\\n\\n    {\\n      ReactCurrentDispatcher.current = previousDispatcher;\\n      reenableLogs();\\n    }\\n\\n    Error.prepareStackTrace = previousPrepareStackTrace;\\n  } // Fallback to just using the name if we couldn't make it throw.\\n\\n\\n  var name = fn ? fn.displayName || fn.name : '';\\n  var syntheticFrame = name ? describeBuiltInComponentFrame(name) : '';\\n\\n  {\\n    if (typeof fn === 'function') {\\n      componentFrameCache.set(fn, syntheticFrame);\\n    }\\n  }\\n\\n  return syntheticFrame;\\n}\\nfunction describeFunctionComponentFrame(fn, source, ownerFn) {\\n  {\\n    return describeNativeComponentFrame(fn, false);\\n  }\\n}\\n\\nfunction shouldConstruct(Component) {\\n  var prototype = Component.prototype;\\n  return !!(prototype && prototype.isReactComponent);\\n}\\n\\nfunction describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {\\n\\n  if (type == null) {\\n    return '';\\n  }\\n\\n  if (typeof type === 'function') {\\n    {\\n      return describeNativeComponentFrame(type, shouldConstruct(type));\\n    }\\n  }\\n\\n  if (typeof type === 'string') {\\n    return describeBuiltInComponentFrame(type);\\n  }\\n\\n  switch (type) {\\n    case REACT_SUSPENSE_TYPE:\\n      return describeBuiltInComponentFrame('Suspense');\\n\\n    case REACT_SUSPENSE_LIST_TYPE:\\n      return describeBuiltInComponentFrame('SuspenseList');\\n  }\\n\\n  if (typeof type === 'object') {\\n    switch (type.$$typeof) {\\n      case REACT_FORWARD_REF_TYPE:\\n        return describeFunctionComponentFrame(type.render);\\n\\n      case REACT_MEMO_TYPE:\\n        // Memo may contain any component type so we recursively resolve it.\\n        return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);\\n\\n      case REACT_BLOCK_TYPE:\\n        return describeFunctionComponentFrame(type._render);\\n\\n      case REACT_LAZY_TYPE:\\n        {\\n          var lazyComponent = type;\\n          var payload = lazyComponent._payload;\\n          var init = lazyComponent._init;\\n\\n          try {\\n            // Lazy may contain any component type so we recursively resolve it.\\n            return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);\\n          } catch (x) {}\\n        }\\n    }\\n  }\\n\\n  return '';\\n}\\n\\nvar loggedTypeFailures = {};\\nvar ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;\\n\\nfunction setCurrentlyValidatingElement(element) {\\n  {\\n    if (element) {\\n      var owner = element._owner;\\n      var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);\\n      ReactDebugCurrentFrame.setExtraStackFrame(stack);\\n    } else {\\n      ReactDebugCurrentFrame.setExtraStackFrame(null);\\n    }\\n  }\\n}\\n\\nfunction checkPropTypes(typeSpecs, values, location, componentName, element) {\\n  {\\n    // $FlowFixMe This is okay but Flow doesn't know it.\\n    var has = Function.call.bind(Object.prototype.hasOwnProperty);\\n\\n    for (var typeSpecName in typeSpecs) {\\n      if (has(typeSpecs, typeSpecName)) {\\n        var error$1 = void 0; // Prop type validation may throw. In case they do, we don't want to\\n        // fail the render phase where it didn't fail before. So we log it.\\n        // After these have been cleaned up, we'll let them throw.\\n\\n        try {\\n          // This is intentionally an invariant that gets caught. It's the same\\n          // behavior as without this statement except with a better message.\\n          if (typeof typeSpecs[typeSpecName] !== 'function') {\\n            var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');\\n            err.name = 'Invariant Violation';\\n            throw err;\\n          }\\n\\n          error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED');\\n        } catch (ex) {\\n          error$1 = ex;\\n        }\\n\\n        if (error$1 && !(error$1 instanceof Error)) {\\n          setCurrentlyValidatingElement(element);\\n\\n          error('%s: type specification of %s' + ' `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error$1);\\n\\n          setCurrentlyValidatingElement(null);\\n        }\\n\\n        if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {\\n          // Only monitor this failure once because there tends to be a lot of the\\n          // same error.\\n          loggedTypeFailures[error$1.message] = true;\\n          setCurrentlyValidatingElement(element);\\n\\n          error('Failed %s type: %s', location, error$1.message);\\n\\n          setCurrentlyValidatingElement(null);\\n        }\\n      }\\n    }\\n  }\\n}\\n\\nvar didWarnAboutInvalidateContextType;\\n\\n{\\n  didWarnAboutInvalidateContextType = new Set();\\n}\\n\\nvar emptyObject = {};\\n\\n{\\n  Object.freeze(emptyObject);\\n}\\n\\nfunction maskContext(type, context) {\\n  var contextTypes = type.contextTypes;\\n\\n  if (!contextTypes) {\\n    return emptyObject;\\n  }\\n\\n  var maskedContext = {};\\n\\n  for (var contextName in contextTypes) {\\n    maskedContext[contextName] = context[contextName];\\n  }\\n\\n  return maskedContext;\\n}\\n\\nfunction checkContextTypes(typeSpecs, values, location) {\\n  {\\n    checkPropTypes(typeSpecs, values, location, 'Component');\\n  }\\n}\\n\\nfunction validateContextBounds(context, threadID) {\\n  // If we don't have enough slots in this context to store this threadID,\\n  // fill it in without leaving any holes to ensure that the VM optimizes\\n  // this as non-holey index properties.\\n  // (Note: If `react` package is < 16.6, _threadCount is undefined.)\\n  for (var i = context._threadCount | 0; i <= threadID; i++) {\\n    // We assume that this is the same as the defaultValue which might not be\\n    // true if we're rendering inside a secondary renderer but they are\\n    // secondary because these use cases are very rare.\\n    context[i] = context._currentValue2;\\n    context._threadCount = i + 1;\\n  }\\n}\\nfunction processContext(type, context, threadID, isClass) {\\n  if (isClass) {\\n    var contextType = type.contextType;\\n\\n    {\\n      if ('contextType' in type) {\\n        var isValid = // Allow null for conditional declaration\\n        contextType === null || contextType !== undefined && contextType.$$typeof === REACT_CONTEXT_TYPE && contextType._context === undefined; // Not a <Context.Consumer>\\n\\n        if (!isValid && !didWarnAboutInvalidateContextType.has(type)) {\\n          didWarnAboutInvalidateContextType.add(type);\\n          var addendum = '';\\n\\n          if (contextType === undefined) {\\n            addendum = ' However, it is set to undefined. ' + 'This can be caused by a typo or by mixing up named and default imports. ' + 'This can also happen due to a circular dependency, so ' + 'try moving the createContext() call to a separate file.';\\n          } else if (typeof contextType !== 'object') {\\n            addendum = ' However, it is set to a ' + typeof contextType + '.';\\n          } else if (contextType.$$typeof === REACT_PROVIDER_TYPE) {\\n            addendum = ' Did you accidentally pass the Context.Provider instead?';\\n          } else if (contextType._context !== undefined) {\\n            // <Context.Consumer>\\n            addendum = ' Did you accidentally pass the Context.Consumer instead?';\\n          } else {\\n            addendum = ' However, it is set to an object with keys {' + Object.keys(contextType).join(', ') + '}.';\\n          }\\n\\n          error('%s defines an invalid contextType. ' + 'contextType should point to the Context object returned by React.createContext().%s', getComponentName(type) || 'Component', addendum);\\n        }\\n      }\\n    }\\n\\n    if (typeof contextType === 'object' && contextType !== null) {\\n      validateContextBounds(contextType, threadID);\\n      return contextType[threadID];\\n    }\\n\\n    {\\n      var maskedContext = maskContext(type, context);\\n\\n      {\\n        if (type.contextTypes) {\\n          checkContextTypes(type.contextTypes, maskedContext, 'context');\\n        }\\n      }\\n\\n      return maskedContext;\\n    }\\n  } else {\\n    {\\n      var _maskedContext = maskContext(type, context);\\n\\n      {\\n        if (type.contextTypes) {\\n          checkContextTypes(type.contextTypes, _maskedContext, 'context');\\n        }\\n      }\\n\\n      return _maskedContext;\\n    }\\n  }\\n}\\n\\nvar nextAvailableThreadIDs = new Uint16Array(16);\\n\\nfor (var i = 0; i < 15; i++) {\\n  nextAvailableThreadIDs[i] = i + 1;\\n}\\n\\nnextAvailableThreadIDs[15] = 0;\\n\\nfunction growThreadCountAndReturnNextAvailable() {\\n  var oldArray = nextAvailableThreadIDs;\\n  var oldSize = oldArray.length;\\n  var newSize = oldSize * 2;\\n\\n  if (!(newSize <= 0x10000)) {\\n    {\\n      throw Error( \\\"Maximum number of concurrent React renderers exceeded. This can happen if you are not properly destroying the Readable provided by React. Ensure that you call .destroy() on it if you no longer want to read from it, and did not read to the end. If you use .pipe() this should be automatic.\\\" );\\n    }\\n  }\\n\\n  var newArray = new Uint16Array(newSize);\\n  newArray.set(oldArray);\\n  nextAvailableThreadIDs = newArray;\\n  nextAvailableThreadIDs[0] = oldSize + 1;\\n\\n  for (var _i = oldSize; _i < newSize - 1; _i++) {\\n    nextAvailableThreadIDs[_i] = _i + 1;\\n  }\\n\\n  nextAvailableThreadIDs[newSize - 1] = 0;\\n  return oldSize;\\n}\\n\\nfunction allocThreadID() {\\n  var nextID = nextAvailableThreadIDs[0];\\n\\n  if (nextID === 0) {\\n    return growThreadCountAndReturnNextAvailable();\\n  }\\n\\n  nextAvailableThreadIDs[0] = nextAvailableThreadIDs[nextID];\\n  return nextID;\\n}\\nfunction freeThreadID(id) {\\n  nextAvailableThreadIDs[id] = nextAvailableThreadIDs[0];\\n  nextAvailableThreadIDs[0] = id;\\n}\\n\\n// A reserved attribute.\\n// It is handled by React separately and shouldn't be written to the DOM.\\nvar RESERVED = 0; // A simple string attribute.\\n// Attributes that aren't in the filter are presumed to have this type.\\n\\nvar STRING = 1; // A string attribute that accepts booleans in React. In HTML, these are called\\n// \\\"enumerated\\\" attributes with \\\"true\\\" and \\\"false\\\" as possible values.\\n// When true, it should be set to a \\\"true\\\" string.\\n// When false, it should be set to a \\\"false\\\" string.\\n\\nvar BOOLEANISH_STRING = 2; // A real boolean attribute.\\n// When true, it should be present (set either to an empty string or its name).\\n// When false, it should be omitted.\\n\\nvar BOOLEAN = 3; // An attribute that can be used as a flag as well as with a value.\\n// When true, it should be present (set either to an empty string or its name).\\n// When false, it should be omitted.\\n// For any other value, should be present with that value.\\n\\nvar OVERLOADED_BOOLEAN = 4; // An attribute that must be numeric or parse as a numeric.\\n// When falsy, it should be removed.\\n\\nvar NUMERIC = 5; // An attribute that must be positive numeric or parse as a positive numeric.\\n// When falsy, it should be removed.\\n\\nvar POSITIVE_NUMERIC = 6;\\n\\n/* eslint-disable max-len */\\nvar ATTRIBUTE_NAME_START_CHAR = \\\":A-Z_a-z\\\\\\\\u00C0-\\\\\\\\u00D6\\\\\\\\u00D8-\\\\\\\\u00F6\\\\\\\\u00F8-\\\\\\\\u02FF\\\\\\\\u0370-\\\\\\\\u037D\\\\\\\\u037F-\\\\\\\\u1FFF\\\\\\\\u200C-\\\\\\\\u200D\\\\\\\\u2070-\\\\\\\\u218F\\\\\\\\u2C00-\\\\\\\\u2FEF\\\\\\\\u3001-\\\\\\\\uD7FF\\\\\\\\uF900-\\\\\\\\uFDCF\\\\\\\\uFDF0-\\\\\\\\uFFFD\\\";\\n/* eslint-enable max-len */\\n\\nvar ATTRIBUTE_NAME_CHAR = ATTRIBUTE_NAME_START_CHAR + \\\"\\\\\\\\-.0-9\\\\\\\\u00B7\\\\\\\\u0300-\\\\\\\\u036F\\\\\\\\u203F-\\\\\\\\u2040\\\";\\nvar ROOT_ATTRIBUTE_NAME = 'data-reactroot';\\nvar VALID_ATTRIBUTE_NAME_REGEX = new RegExp('^[' + ATTRIBUTE_NAME_START_CHAR + '][' + ATTRIBUTE_NAME_CHAR + ']*$');\\nvar hasOwnProperty = Object.prototype.hasOwnProperty;\\nvar illegalAttributeNameCache = {};\\nvar validatedAttributeNameCache = {};\\nfunction isAttributeNameSafe(attributeName) {\\n  if (hasOwnProperty.call(validatedAttributeNameCache, attributeName)) {\\n    return true;\\n  }\\n\\n  if (hasOwnProperty.call(illegalAttributeNameCache, attributeName)) {\\n    return false;\\n  }\\n\\n  if (VALID_ATTRIBUTE_NAME_REGEX.test(attributeName)) {\\n    validatedAttributeNameCache[attributeName] = true;\\n    return true;\\n  }\\n\\n  illegalAttributeNameCache[attributeName] = true;\\n\\n  {\\n    error('Invalid attribute name: `%s`', attributeName);\\n  }\\n\\n  return false;\\n}\\nfunction shouldIgnoreAttribute(name, propertyInfo, isCustomComponentTag) {\\n  if (propertyInfo !== null) {\\n    return propertyInfo.type === RESERVED;\\n  }\\n\\n  if (isCustomComponentTag) {\\n    return false;\\n  }\\n\\n  if (name.length > 2 && (name[0] === 'o' || name[0] === 'O') && (name[1] === 'n' || name[1] === 'N')) {\\n    return true;\\n  }\\n\\n  return false;\\n}\\nfunction shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag) {\\n  if (propertyInfo !== null && propertyInfo.type === RESERVED) {\\n    return false;\\n  }\\n\\n  switch (typeof value) {\\n    case 'function': // $FlowIssue symbol is perfectly valid here\\n\\n    case 'symbol':\\n      // eslint-disable-line\\n      return true;\\n\\n    case 'boolean':\\n      {\\n        if (isCustomComponentTag) {\\n          return false;\\n        }\\n\\n        if (propertyInfo !== null) {\\n          return !propertyInfo.acceptsBooleans;\\n        } else {\\n          var prefix = name.toLowerCase().slice(0, 5);\\n          return prefix !== 'data-' && prefix !== 'aria-';\\n        }\\n      }\\n\\n    default:\\n      return false;\\n  }\\n}\\nfunction shouldRemoveAttribute(name, value, propertyInfo, isCustomComponentTag) {\\n  if (value === null || typeof value === 'undefined') {\\n    return true;\\n  }\\n\\n  if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, isCustomComponentTag)) {\\n    return true;\\n  }\\n\\n  if (isCustomComponentTag) {\\n    return false;\\n  }\\n\\n  if (propertyInfo !== null) {\\n\\n    switch (propertyInfo.type) {\\n      case BOOLEAN:\\n        return !value;\\n\\n      case OVERLOADED_BOOLEAN:\\n        return value === false;\\n\\n      case NUMERIC:\\n        return isNaN(value);\\n\\n      case POSITIVE_NUMERIC:\\n        return isNaN(value) || value < 1;\\n    }\\n  }\\n\\n  return false;\\n}\\nfunction getPropertyInfo(name) {\\n  return properties.hasOwnProperty(name) ? properties[name] : null;\\n}\\n\\nfunction PropertyInfoRecord(name, type, mustUseProperty, attributeName, attributeNamespace, sanitizeURL, removeEmptyString) {\\n  this.acceptsBooleans = type === BOOLEANISH_STRING || type === BOOLEAN || type === OVERLOADED_BOOLEAN;\\n  this.attributeName = attributeName;\\n  this.attributeNamespace = attributeNamespace;\\n  this.mustUseProperty = mustUseProperty;\\n  this.propertyName = name;\\n  this.type = type;\\n  this.sanitizeURL = sanitizeURL;\\n  this.removeEmptyString = removeEmptyString;\\n} // When adding attributes to this list, be sure to also add them to\\n// the `possibleStandardNames` module to ensure casing and incorrect\\n// name warnings.\\n\\n\\nvar properties = {}; // These props are reserved by React. They shouldn't be written to the DOM.\\n\\nvar reservedProps = ['children', 'dangerouslySetInnerHTML', // TODO: This prevents the assignment of defaultValue to regular\\n// elements (not just inputs). Now that ReactDOMInput assigns to the\\n// defaultValue property -- do we need this?\\n'defaultValue', 'defaultChecked', 'innerHTML', 'suppressContentEditableWarning', 'suppressHydrationWarning', 'style'];\\nreservedProps.forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, RESERVED, false, // mustUseProperty\\n  name, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // A few React string attributes have a different name.\\n// This is a mapping from React prop names to the attribute names.\\n\\n[['acceptCharset', 'accept-charset'], ['className', 'class'], ['htmlFor', 'for'], ['httpEquiv', 'http-equiv']].forEach(function (_ref) {\\n  var name = _ref[0],\\n      attributeName = _ref[1];\\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\\n  attributeName, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are \\\"enumerated\\\" HTML attributes that accept \\\"true\\\" and \\\"false\\\".\\n// In React, we let users pass `true` and `false` even though technically\\n// these aren't boolean attributes (they are coerced to strings).\\n\\n['contentEditable', 'draggable', 'spellCheck', 'value'].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty\\n  name.toLowerCase(), // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are \\\"enumerated\\\" SVG attributes that accept \\\"true\\\" and \\\"false\\\".\\n// In React, we let users pass `true` and `false` even though technically\\n// these aren't boolean attributes (they are coerced to strings).\\n// Since these are SVG attributes, their attribute names are case-sensitive.\\n\\n['autoReverse', 'externalResourcesRequired', 'focusable', 'preserveAlpha'].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, BOOLEANISH_STRING, false, // mustUseProperty\\n  name, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are HTML boolean attributes.\\n\\n['allowFullScreen', 'async', // Note: there is a special case that prevents it from being written to the DOM\\n// on the client side because the browsers are inconsistent. Instead we call focus().\\n'autoFocus', 'autoPlay', 'controls', 'default', 'defer', 'disabled', 'disablePictureInPicture', 'disableRemotePlayback', 'formNoValidate', 'hidden', 'loop', 'noModule', 'noValidate', 'open', 'playsInline', 'readOnly', 'required', 'reversed', 'scoped', 'seamless', // Microdata\\n'itemScope'].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, BOOLEAN, false, // mustUseProperty\\n  name.toLowerCase(), // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are the few React props that we set as DOM properties\\n// rather than attributes. These are all booleans.\\n\\n['checked', // Note: `option.selected` is not updated if `select.multiple` is\\n// disabled with `removeAttribute`. We have special logic for handling this.\\n'multiple', 'muted', 'selected' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, BOOLEAN, true, // mustUseProperty\\n  name, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are HTML attributes that are \\\"overloaded booleans\\\": they behave like\\n// booleans, but can also accept a string value.\\n\\n['capture', 'download' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, OVERLOADED_BOOLEAN, false, // mustUseProperty\\n  name, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are HTML attributes that must be positive numbers.\\n\\n['cols', 'rows', 'size', 'span' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, POSITIVE_NUMERIC, false, // mustUseProperty\\n  name, // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These are HTML attributes that must be numbers.\\n\\n['rowSpan', 'start'].forEach(function (name) {\\n  properties[name] = new PropertyInfoRecord(name, NUMERIC, false, // mustUseProperty\\n  name.toLowerCase(), // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n});\\nvar CAMELIZE = /[\\\\-\\\\:]([a-z])/g;\\n\\nvar capitalize = function (token) {\\n  return token[1].toUpperCase();\\n}; // This is a list of all SVG attributes that need special casing, namespacing,\\n// or boolean value assignment. Regular attributes that just accept strings\\n// and have the same names are omitted, just like in the HTML attribute filter.\\n// Some of these attributes can be hard to find. This list was created by\\n// scraping the MDN documentation.\\n\\n\\n['accent-height', 'alignment-baseline', 'arabic-form', 'baseline-shift', 'cap-height', 'clip-path', 'clip-rule', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'dominant-baseline', 'enable-background', 'fill-opacity', 'fill-rule', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'glyph-name', 'glyph-orientation-horizontal', 'glyph-orientation-vertical', 'horiz-adv-x', 'horiz-origin-x', 'image-rendering', 'letter-spacing', 'lighting-color', 'marker-end', 'marker-mid', 'marker-start', 'overline-position', 'overline-thickness', 'paint-order', 'panose-1', 'pointer-events', 'rendering-intent', 'shape-rendering', 'stop-color', 'stop-opacity', 'strikethrough-position', 'strikethrough-thickness', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'text-anchor', 'text-decoration', 'text-rendering', 'underline-position', 'underline-thickness', 'unicode-bidi', 'unicode-range', 'units-per-em', 'v-alphabetic', 'v-hanging', 'v-ideographic', 'v-mathematical', 'vector-effect', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'word-spacing', 'writing-mode', 'xmlns:xlink', 'x-height' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (attributeName) {\\n  var name = attributeName.replace(CAMELIZE, capitalize);\\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\\n  attributeName, null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // String SVG attributes with the xlink namespace.\\n\\n['xlink:actuate', 'xlink:arcrole', 'xlink:role', 'xlink:show', 'xlink:title', 'xlink:type' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (attributeName) {\\n  var name = attributeName.replace(CAMELIZE, capitalize);\\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\\n  attributeName, 'http://www.w3.org/1999/xlink', false, // sanitizeURL\\n  false);\\n}); // String SVG attributes with the xml namespace.\\n\\n['xml:base', 'xml:lang', 'xml:space' // NOTE: if you add a camelCased prop to this list,\\n// you'll need to set attributeName to name.toLowerCase()\\n// instead in the assignment below.\\n].forEach(function (attributeName) {\\n  var name = attributeName.replace(CAMELIZE, capitalize);\\n  properties[name] = new PropertyInfoRecord(name, STRING, false, // mustUseProperty\\n  attributeName, 'http://www.w3.org/XML/1998/namespace', false, // sanitizeURL\\n  false);\\n}); // These attribute exists both in HTML and SVG.\\n// The attribute name is case-sensitive in SVG so we can't just use\\n// the React name like we do for attributes that exist only in HTML.\\n\\n['tabIndex', 'crossOrigin'].forEach(function (attributeName) {\\n  properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty\\n  attributeName.toLowerCase(), // attributeName\\n  null, // attributeNamespace\\n  false, // sanitizeURL\\n  false);\\n}); // These attributes accept URLs. These must not allow javascript: URLS.\\n// These will also need to accept Trusted Types object in the future.\\n\\nvar xlinkHref = 'xlinkHref';\\nproperties[xlinkHref] = new PropertyInfoRecord('xlinkHref', STRING, false, // mustUseProperty\\n'xlink:href', 'http://www.w3.org/1999/xlink', true, // sanitizeURL\\nfalse);\\n['src', 'href', 'action', 'formAction'].forEach(function (attributeName) {\\n  properties[attributeName] = new PropertyInfoRecord(attributeName, STRING, false, // mustUseProperty\\n  attributeName.toLowerCase(), // attributeName\\n  null, // attributeNamespace\\n  true, // sanitizeURL\\n  true);\\n});\\n\\n// and any newline or tab are filtered out as if they're not part of the URL.\\n// https://url.spec.whatwg.org/#url-parsing\\n// Tab or newline are defined as \\\\r\\\\n\\\\t:\\n// https://infra.spec.whatwg.org/#ascii-tab-or-newline\\n// A C0 control is a code point in the range \\\\u0000 NULL to \\\\u001F\\n// INFORMATION SEPARATOR ONE, inclusive:\\n// https://infra.spec.whatwg.org/#c0-control-or-space\\n\\n/* eslint-disable max-len */\\n\\nvar isJavaScriptProtocol = /^[\\\\u0000-\\\\u001F ]*j[\\\\r\\\\n\\\\t]*a[\\\\r\\\\n\\\\t]*v[\\\\r\\\\n\\\\t]*a[\\\\r\\\\n\\\\t]*s[\\\\r\\\\n\\\\t]*c[\\\\r\\\\n\\\\t]*r[\\\\r\\\\n\\\\t]*i[\\\\r\\\\n\\\\t]*p[\\\\r\\\\n\\\\t]*t[\\\\r\\\\n\\\\t]*\\\\:/i;\\nvar didWarn = false;\\n\\nfunction sanitizeURL(url) {\\n  {\\n    if (!didWarn && isJavaScriptProtocol.test(url)) {\\n      didWarn = true;\\n\\n      error('A future version of React will block javascript: URLs as a security precaution. ' + 'Use event handlers instead if you can. If you need to generate unsafe HTML try ' + 'using dangerouslySetInnerHTML instead. React was passed %s.', JSON.stringify(url));\\n    }\\n  }\\n}\\n\\n// code copied and modified from escape-html\\n\\n/**\\n * Module variables.\\n * @private\\n */\\nvar matchHtmlRegExp = /[\\\"'&<>]/;\\n/**\\n * Escapes special characters and HTML entities in a given html string.\\n *\\n * @param  {string} string HTML string to escape for later insertion\\n * @return {string}\\n * @public\\n */\\n\\nfunction escapeHtml(string) {\\n  var str = '' + string;\\n  var match = matchHtmlRegExp.exec(str);\\n\\n  if (!match) {\\n    return str;\\n  }\\n\\n  var escape;\\n  var html = '';\\n  var index;\\n  var lastIndex = 0;\\n\\n  for (index = match.index; index < str.length; index++) {\\n    switch (str.charCodeAt(index)) {\\n      case 34:\\n        // \\\"\\n        escape = '&quot;';\\n        break;\\n\\n      case 38:\\n        // &\\n        escape = '&amp;';\\n        break;\\n\\n      case 39:\\n        // '\\n        escape = '&#x27;'; // modified from escape-html; used to be '&#39'\\n\\n        break;\\n\\n      case 60:\\n        // <\\n        escape = '&lt;';\\n        break;\\n\\n      case 62:\\n        // >\\n        escape = '&gt;';\\n        break;\\n\\n      default:\\n        continue;\\n    }\\n\\n    if (lastIndex !== index) {\\n      html += str.substring(lastIndex, index);\\n    }\\n\\n    lastIndex = index + 1;\\n    html += escape;\\n  }\\n\\n  return lastIndex !== index ? html + str.substring(lastIndex, index) : html;\\n} // end code copied and modified from escape-html\\n\\n/**\\n * Escapes text to prevent scripting attacks.\\n *\\n * @param {*} text Text value to escape.\\n * @return {string} An escaped string.\\n */\\n\\n\\nfunction escapeTextForBrowser(text) {\\n  if (typeof text === 'boolean' || typeof text === 'number') {\\n    // this shortcircuit helps perf for types that we know will never have\\n    // special characters, especially given that this function is used often\\n    // for numeric dom ids.\\n    return '' + text;\\n  }\\n\\n  return escapeHtml(text);\\n}\\n\\n/**\\n * Escapes attribute value to prevent scripting attacks.\\n *\\n * @param {*} value Value to escape.\\n * @return {string} An escaped string.\\n */\\n\\nfunction quoteAttributeValueForBrowser(value) {\\n  return '\\\"' + escapeTextForBrowser(value) + '\\\"';\\n}\\n\\nfunction createMarkupForRoot() {\\n  return ROOT_ATTRIBUTE_NAME + '=\\\"\\\"';\\n}\\n/**\\n * Creates markup for a property.\\n *\\n * @param {string} name\\n * @param {*} value\\n * @return {?string} Markup string, or null if the property was invalid.\\n */\\n\\nfunction createMarkupForProperty(name, value) {\\n  var propertyInfo = getPropertyInfo(name);\\n\\n  if (name !== 'style' && shouldIgnoreAttribute(name, propertyInfo, false)) {\\n    return '';\\n  }\\n\\n  if (shouldRemoveAttribute(name, value, propertyInfo, false)) {\\n    return '';\\n  }\\n\\n  if (propertyInfo !== null) {\\n    var attributeName = propertyInfo.attributeName;\\n    var type = propertyInfo.type;\\n\\n    if (type === BOOLEAN || type === OVERLOADED_BOOLEAN && value === true) {\\n      return attributeName + '=\\\"\\\"';\\n    } else {\\n      if (propertyInfo.sanitizeURL) {\\n        value = '' + value;\\n        sanitizeURL(value);\\n      }\\n\\n      return attributeName + '=' + quoteAttributeValueForBrowser(value);\\n    }\\n  } else if (isAttributeNameSafe(name)) {\\n    return name + '=' + quoteAttributeValueForBrowser(value);\\n  }\\n\\n  return '';\\n}\\n/**\\n * Creates markup for a custom property.\\n *\\n * @param {string} name\\n * @param {*} value\\n * @return {string} Markup string, or empty string if the property was invalid.\\n */\\n\\nfunction createMarkupForCustomAttribute(name, value) {\\n  if (!isAttributeNameSafe(name) || value == null) {\\n    return '';\\n  }\\n\\n  return name + '=' + quoteAttributeValueForBrowser(value);\\n}\\n\\n/**\\n * inlined Object.is polyfill to avoid requiring consumers ship their own\\n * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is\\n */\\nfunction is(x, y) {\\n  return x === y && (x !== 0 || 1 / x === 1 / y) || x !== x && y !== y // eslint-disable-line no-self-compare\\n  ;\\n}\\n\\nvar objectIs = typeof Object.is === 'function' ? Object.is : is;\\n\\nvar currentlyRenderingComponent = null;\\nvar firstWorkInProgressHook = null;\\nvar workInProgressHook = null; // Whether the work-in-progress hook is a re-rendered hook\\n\\nvar isReRender = false; // Whether an update was scheduled during the currently executing render pass.\\n\\nvar didScheduleRenderPhaseUpdate = false; // Lazily created map of render-phase updates\\n\\nvar renderPhaseUpdates = null; // Counter to prevent infinite loops.\\n\\nvar numberOfReRenders = 0;\\nvar RE_RENDER_LIMIT = 25;\\nvar isInHookUserCodeInDev = false; // In DEV, this is the name of the currently executing primitive hook\\n\\nvar currentHookNameInDev;\\n\\nfunction resolveCurrentlyRenderingComponent() {\\n  if (!(currentlyRenderingComponent !== null)) {\\n    {\\n      throw Error( \\\"Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\\\\n1. You might have mismatching versions of React and the renderer (such as React DOM)\\\\n2. You might be breaking the Rules of Hooks\\\\n3. You might have more than one copy of React in the same app\\\\nSee https://reactjs.org/link/invalid-hook-call for tips about how to debug and fix this problem.\\\" );\\n    }\\n  }\\n\\n  {\\n    if (isInHookUserCodeInDev) {\\n      error('Do not call Hooks inside useEffect(...), useMemo(...), or other built-in Hooks. ' + 'You can only call Hooks at the top level of your React function. ' + 'For more information, see ' + 'https://reactjs.org/link/rules-of-hooks');\\n    }\\n  }\\n\\n  return currentlyRenderingComponent;\\n}\\n\\nfunction areHookInputsEqual(nextDeps, prevDeps) {\\n  if (prevDeps === null) {\\n    {\\n      error('%s received a final argument during this render, but not during ' + 'the previous render. Even though the final argument is optional, ' + 'its type cannot change between renders.', currentHookNameInDev);\\n    }\\n\\n    return false;\\n  }\\n\\n  {\\n    // Don't bother comparing lengths in prod because these arrays should be\\n    // passed inline.\\n    if (nextDeps.length !== prevDeps.length) {\\n      error('The final argument passed to %s changed size between renders. The ' + 'order and size of this array must remain constant.\\\\n\\\\n' + 'Previous: %s\\\\n' + 'Incoming: %s', currentHookNameInDev, \\\"[\\\" + nextDeps.join(', ') + \\\"]\\\", \\\"[\\\" + prevDeps.join(', ') + \\\"]\\\");\\n    }\\n  }\\n\\n  for (var i = 0; i < prevDeps.length && i < nextDeps.length; i++) {\\n    if (objectIs(nextDeps[i], prevDeps[i])) {\\n      continue;\\n    }\\n\\n    return false;\\n  }\\n\\n  return true;\\n}\\n\\nfunction createHook() {\\n  if (numberOfReRenders > 0) {\\n    {\\n      {\\n        throw Error( \\\"Rendered more hooks than during the previous render\\\" );\\n      }\\n    }\\n  }\\n\\n  return {\\n    memoizedState: null,\\n    queue: null,\\n    next: null\\n  };\\n}\\n\\nfunction createWorkInProgressHook() {\\n  if (workInProgressHook === null) {\\n    // This is the first hook in the list\\n    if (firstWorkInProgressHook === null) {\\n      isReRender = false;\\n      firstWorkInProgressHook = workInProgressHook = createHook();\\n    } else {\\n      // There's already a work-in-progress. Reuse it.\\n      isReRender = true;\\n      workInProgressHook = firstWorkInProgressHook;\\n    }\\n  } else {\\n    if (workInProgressHook.next === null) {\\n      isReRender = false; // Append to the end of the list\\n\\n      workInProgressHook = workInProgressHook.next = createHook();\\n    } else {\\n      // There's already a work-in-progress. Reuse it.\\n      isReRender = true;\\n      workInProgressHook = workInProgressHook.next;\\n    }\\n  }\\n\\n  return workInProgressHook;\\n}\\n\\nfunction prepareToUseHooks(componentIdentity) {\\n  currentlyRenderingComponent = componentIdentity;\\n\\n  {\\n    isInHookUserCodeInDev = false;\\n  } // The following should have already been reset\\n  // didScheduleRenderPhaseUpdate = false;\\n  // firstWorkInProgressHook = null;\\n  // numberOfReRenders = 0;\\n  // renderPhaseUpdates = null;\\n  // workInProgressHook = null;\\n\\n}\\nfunction finishHooks(Component, props, children, refOrContext) {\\n  // This must be called after every function component to prevent hooks from\\n  // being used in classes.\\n  while (didScheduleRenderPhaseUpdate) {\\n    // Updates were scheduled during the render phase. They are stored in\\n    // the `renderPhaseUpdates` map. Call the component again, reusing the\\n    // work-in-progress hooks and applying the additional updates on top. Keep\\n    // restarting until no more updates are scheduled.\\n    didScheduleRenderPhaseUpdate = false;\\n    numberOfReRenders += 1; // Start over from the beginning of the list\\n\\n    workInProgressHook = null;\\n    children = Component(props, refOrContext);\\n  }\\n\\n  resetHooksState();\\n  return children;\\n} // Reset the internal hooks state if an error occurs while rendering a component\\n\\nfunction resetHooksState() {\\n  {\\n    isInHookUserCodeInDev = false;\\n  }\\n\\n  currentlyRenderingComponent = null;\\n  didScheduleRenderPhaseUpdate = false;\\n  firstWorkInProgressHook = null;\\n  numberOfReRenders = 0;\\n  renderPhaseUpdates = null;\\n  workInProgressHook = null;\\n}\\n\\nfunction readContext(context, observedBits) {\\n  var threadID = currentPartialRenderer.threadID;\\n  validateContextBounds(context, threadID);\\n\\n  {\\n    if (isInHookUserCodeInDev) {\\n      error('Context can only be read while React is rendering. ' + 'In classes, you can read it in the render method or getDerivedStateFromProps. ' + 'In function components, you can read it directly in the function body, but not ' + 'inside Hooks like useReducer() or useMemo().');\\n    }\\n  }\\n\\n  return context[threadID];\\n}\\n\\nfunction useContext(context, observedBits) {\\n  {\\n    currentHookNameInDev = 'useContext';\\n  }\\n\\n  resolveCurrentlyRenderingComponent();\\n  var threadID = currentPartialRenderer.threadID;\\n  validateContextBounds(context, threadID);\\n  return context[threadID];\\n}\\n\\nfunction basicStateReducer(state, action) {\\n  // $FlowFixMe: Flow doesn't like mixed types\\n  return typeof action === 'function' ? action(state) : action;\\n}\\n\\nfunction useState(initialState) {\\n  {\\n    currentHookNameInDev = 'useState';\\n  }\\n\\n  return useReducer(basicStateReducer, // useReducer has a special case to support lazy useState initializers\\n  initialState);\\n}\\nfunction useReducer(reducer, initialArg, init) {\\n  {\\n    if (reducer !== basicStateReducer) {\\n      currentHookNameInDev = 'useReducer';\\n    }\\n  }\\n\\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\\n  workInProgressHook = createWorkInProgressHook();\\n\\n  if (isReRender) {\\n    // This is a re-render. Apply the new render phase updates to the previous\\n    // current hook.\\n    var queue = workInProgressHook.queue;\\n    var dispatch = queue.dispatch;\\n\\n    if (renderPhaseUpdates !== null) {\\n      // Render phase updates are stored in a map of queue -> linked list\\n      var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);\\n\\n      if (firstRenderPhaseUpdate !== undefined) {\\n        renderPhaseUpdates.delete(queue);\\n        var newState = workInProgressHook.memoizedState;\\n        var update = firstRenderPhaseUpdate;\\n\\n        do {\\n          // Process this render phase update. We don't have to check the\\n          // priority because it will always be the same as the current\\n          // render's.\\n          var action = update.action;\\n\\n          {\\n            isInHookUserCodeInDev = true;\\n          }\\n\\n          newState = reducer(newState, action);\\n\\n          {\\n            isInHookUserCodeInDev = false;\\n          }\\n\\n          update = update.next;\\n        } while (update !== null);\\n\\n        workInProgressHook.memoizedState = newState;\\n        return [newState, dispatch];\\n      }\\n    }\\n\\n    return [workInProgressHook.memoizedState, dispatch];\\n  } else {\\n    {\\n      isInHookUserCodeInDev = true;\\n    }\\n\\n    var initialState;\\n\\n    if (reducer === basicStateReducer) {\\n      // Special case for `useState`.\\n      initialState = typeof initialArg === 'function' ? initialArg() : initialArg;\\n    } else {\\n      initialState = init !== undefined ? init(initialArg) : initialArg;\\n    }\\n\\n    {\\n      isInHookUserCodeInDev = false;\\n    }\\n\\n    workInProgressHook.memoizedState = initialState;\\n\\n    var _queue = workInProgressHook.queue = {\\n      last: null,\\n      dispatch: null\\n    };\\n\\n    var _dispatch = _queue.dispatch = dispatchAction.bind(null, currentlyRenderingComponent, _queue);\\n\\n    return [workInProgressHook.memoizedState, _dispatch];\\n  }\\n}\\n\\nfunction useMemo(nextCreate, deps) {\\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\\n  workInProgressHook = createWorkInProgressHook();\\n  var nextDeps = deps === undefined ? null : deps;\\n\\n  if (workInProgressHook !== null) {\\n    var prevState = workInProgressHook.memoizedState;\\n\\n    if (prevState !== null) {\\n      if (nextDeps !== null) {\\n        var prevDeps = prevState[1];\\n\\n        if (areHookInputsEqual(nextDeps, prevDeps)) {\\n          return prevState[0];\\n        }\\n      }\\n    }\\n  }\\n\\n  {\\n    isInHookUserCodeInDev = true;\\n  }\\n\\n  var nextValue = nextCreate();\\n\\n  {\\n    isInHookUserCodeInDev = false;\\n  }\\n\\n  workInProgressHook.memoizedState = [nextValue, nextDeps];\\n  return nextValue;\\n}\\n\\nfunction useRef(initialValue) {\\n  currentlyRenderingComponent = resolveCurrentlyRenderingComponent();\\n  workInProgressHook = createWorkInProgressHook();\\n  var previousRef = workInProgressHook.memoizedState;\\n\\n  if (previousRef === null) {\\n    var ref = {\\n      current: initialValue\\n    };\\n\\n    {\\n      Object.seal(ref);\\n    }\\n\\n    workInProgressHook.memoizedState = ref;\\n    return ref;\\n  } else {\\n    return previousRef;\\n  }\\n}\\n\\nfunction useLayoutEffect(create, inputs) {\\n  {\\n    currentHookNameInDev = 'useLayoutEffect';\\n\\n    error('useLayoutEffect does nothing on the server, because its effect cannot ' + \\\"be encoded into the server renderer's output format. This will lead \\\" + 'to a mismatch between the initial, non-hydrated UI and the intended ' + 'UI. To avoid this, useLayoutEffect should only be used in ' + 'components that render exclusively on the client. ' + 'See https://reactjs.org/link/uselayouteffect-ssr for common fixes.');\\n  }\\n}\\n\\nfunction dispatchAction(componentIdentity, queue, action) {\\n  if (!(numberOfReRenders < RE_RENDER_LIMIT)) {\\n    {\\n      throw Error( \\\"Too many re-renders. React limits the number of renders to prevent an infinite loop.\\\" );\\n    }\\n  }\\n\\n  if (componentIdentity === currentlyRenderingComponent) {\\n    // This is a render phase update. Stash it in a lazily-created map of\\n    // queue -> linked list of updates. After this render pass, we'll restart\\n    // and apply the stashed updates on top of the work-in-progress hook.\\n    didScheduleRenderPhaseUpdate = true;\\n    var update = {\\n      action: action,\\n      next: null\\n    };\\n\\n    if (renderPhaseUpdates === null) {\\n      renderPhaseUpdates = new Map();\\n    }\\n\\n    var firstRenderPhaseUpdate = renderPhaseUpdates.get(queue);\\n\\n    if (firstRenderPhaseUpdate === undefined) {\\n      renderPhaseUpdates.set(queue, update);\\n    } else {\\n      // Append the update to the end of the list.\\n      var lastRenderPhaseUpdate = firstRenderPhaseUpdate;\\n\\n      while (lastRenderPhaseUpdate.next !== null) {\\n        lastRenderPhaseUpdate = lastRenderPhaseUpdate.next;\\n      }\\n\\n      lastRenderPhaseUpdate.next = update;\\n    }\\n  }\\n}\\n\\nfunction useCallback(callback, deps) {\\n  return useMemo(function () {\\n    return callback;\\n  }, deps);\\n} // TODO Decide on how to implement this hook for server rendering.\\n// If a mutation occurs during render, consider triggering a Suspense boundary\\n// and falling back to client rendering.\\n\\nfunction useMutableSource(source, getSnapshot, subscribe) {\\n  resolveCurrentlyRenderingComponent();\\n  return getSnapshot(source._source);\\n}\\n\\nfunction useDeferredValue(value) {\\n  resolveCurrentlyRenderingComponent();\\n  return value;\\n}\\n\\nfunction useTransition() {\\n  resolveCurrentlyRenderingComponent();\\n\\n  var startTransition = function (callback) {\\n    callback();\\n  };\\n\\n  return [startTransition, false];\\n}\\n\\nfunction useOpaqueIdentifier() {\\n  return (currentPartialRenderer.identifierPrefix || '') + 'R:' + (currentPartialRenderer.uniqueID++).toString(36);\\n}\\n\\nfunction noop() {}\\n\\nvar currentPartialRenderer = null;\\nfunction setCurrentPartialRenderer(renderer) {\\n  currentPartialRenderer = renderer;\\n}\\nvar Dispatcher = {\\n  readContext: readContext,\\n  useContext: useContext,\\n  useMemo: useMemo,\\n  useReducer: useReducer,\\n  useRef: useRef,\\n  useState: useState,\\n  useLayoutEffect: useLayoutEffect,\\n  useCallback: useCallback,\\n  // useImperativeHandle is not run in the server environment\\n  useImperativeHandle: noop,\\n  // Effects are not run in the server environment.\\n  useEffect: noop,\\n  // Debugging effect\\n  useDebugValue: noop,\\n  useDeferredValue: useDeferredValue,\\n  useTransition: useTransition,\\n  useOpaqueIdentifier: useOpaqueIdentifier,\\n  // Subscriptions are not setup in a server environment.\\n  useMutableSource: useMutableSource\\n};\\n\\nvar HTML_NAMESPACE = 'http://www.w3.org/1999/xhtml';\\nvar MATH_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';\\nvar SVG_NAMESPACE = 'http://www.w3.org/2000/svg';\\nvar Namespaces = {\\n  html: HTML_NAMESPACE,\\n  mathml: MATH_NAMESPACE,\\n  svg: SVG_NAMESPACE\\n}; // Assumes there is no parent namespace.\\n\\nfunction getIntrinsicNamespace(type) {\\n  switch (type) {\\n    case 'svg':\\n      return SVG_NAMESPACE;\\n\\n    case 'math':\\n      return MATH_NAMESPACE;\\n\\n    default:\\n      return HTML_NAMESPACE;\\n  }\\n}\\nfunction getChildNamespace(parentNamespace, type) {\\n  if (parentNamespace == null || parentNamespace === HTML_NAMESPACE) {\\n    // No (or default) parent namespace: potential entry point.\\n    return getIntrinsicNamespace(type);\\n  }\\n\\n  if (parentNamespace === SVG_NAMESPACE && type === 'foreignObject') {\\n    // We're leaving SVG.\\n    return HTML_NAMESPACE;\\n  } // By default, pass namespace below.\\n\\n\\n  return parentNamespace;\\n}\\n\\nvar hasReadOnlyValue = {\\n  button: true,\\n  checkbox: true,\\n  image: true,\\n  hidden: true,\\n  radio: true,\\n  reset: true,\\n  submit: true\\n};\\nfunction checkControlledValueProps(tagName, props) {\\n  {\\n    if (!(hasReadOnlyValue[props.type] || props.onChange || props.onInput || props.readOnly || props.disabled || props.value == null)) {\\n      error('You provided a `value` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultValue`. Otherwise, ' + 'set either `onChange` or `readOnly`.');\\n    }\\n\\n    if (!(props.onChange || props.readOnly || props.disabled || props.checked == null)) {\\n      error('You provided a `checked` prop to a form field without an ' + '`onChange` handler. This will render a read-only field. If ' + 'the field should be mutable use `defaultChecked`. Otherwise, ' + 'set either `onChange` or `readOnly`.');\\n    }\\n  }\\n}\\n\\n// For HTML, certain tags should omit their close tag. We keep a list for\\n// those special-case tags.\\nvar omittedCloseTags = {\\n  area: true,\\n  base: true,\\n  br: true,\\n  col: true,\\n  embed: true,\\n  hr: true,\\n  img: true,\\n  input: true,\\n  keygen: true,\\n  link: true,\\n  meta: true,\\n  param: true,\\n  source: true,\\n  track: true,\\n  wbr: true // NOTE: menuitem's close tag should be omitted, but that causes problems.\\n\\n};\\n\\n// `omittedCloseTags` except that `menuitem` should still have its closing tag.\\n\\nvar voidElementTags = _assign({\\n  menuitem: true\\n}, omittedCloseTags);\\n\\nvar HTML = '__html';\\n\\nfunction assertValidProps(tag, props) {\\n  if (!props) {\\n    return;\\n  } // Note the use of `==` which checks for null or undefined.\\n\\n\\n  if (voidElementTags[tag]) {\\n    if (!(props.children == null && props.dangerouslySetInnerHTML == null)) {\\n      {\\n        throw Error( tag + \\\" is a void element tag and must neither have `children` nor use `dangerouslySetInnerHTML`.\\\" );\\n      }\\n    }\\n  }\\n\\n  if (props.dangerouslySetInnerHTML != null) {\\n    if (!(props.children == null)) {\\n      {\\n        throw Error( \\\"Can only set one of `children` or `props.dangerouslySetInnerHTML`.\\\" );\\n      }\\n    }\\n\\n    if (!(typeof props.dangerouslySetInnerHTML === 'object' && HTML in props.dangerouslySetInnerHTML)) {\\n      {\\n        throw Error( \\\"`props.dangerouslySetInnerHTML` must be in the form `{__html: ...}`. Please visit https://reactjs.org/link/dangerously-set-inner-html for more information.\\\" );\\n      }\\n    }\\n  }\\n\\n  {\\n    if (!props.suppressContentEditableWarning && props.contentEditable && props.children != null) {\\n      error('A component is `contentEditable` and contains `children` managed by ' + 'React. It is now your responsibility to guarantee that none of ' + 'those nodes are unexpectedly modified or duplicated. This is ' + 'probably not intentional.');\\n    }\\n  }\\n\\n  if (!(props.style == null || typeof props.style === 'object')) {\\n    {\\n      throw Error( \\\"The `style` prop expects a mapping from style properties to values, not a string. For example, style={{marginRight: spacing + 'em'}} when using JSX.\\\" );\\n    }\\n  }\\n}\\n\\n/**\\n * CSS properties which accept numbers but are not in units of \\\"px\\\".\\n */\\nvar isUnitlessNumber = {\\n  animationIterationCount: true,\\n  borderImageOutset: true,\\n  borderImageSlice: true,\\n  borderImageWidth: true,\\n  boxFlex: true,\\n  boxFlexGroup: true,\\n  boxOrdinalGroup: true,\\n  columnCount: true,\\n  columns: true,\\n  flex: true,\\n  flexGrow: true,\\n  flexPositive: true,\\n  flexShrink: true,\\n  flexNegative: true,\\n  flexOrder: true,\\n  gridArea: true,\\n  gridRow: true,\\n  gridRowEnd: true,\\n  gridRowSpan: true,\\n  gridRowStart: true,\\n  gridColumn: true,\\n  gridColumnEnd: true,\\n  gridColumnSpan: true,\\n  gridColumnStart: true,\\n  fontWeight: true,\\n  lineClamp: true,\\n  lineHeight: true,\\n  opacity: true,\\n  order: true,\\n  orphans: true,\\n  tabSize: true,\\n  widows: true,\\n  zIndex: true,\\n  zoom: true,\\n  // SVG-related properties\\n  fillOpacity: true,\\n  floodOpacity: true,\\n  stopOpacity: true,\\n  strokeDasharray: true,\\n  strokeDashoffset: true,\\n  strokeMiterlimit: true,\\n  strokeOpacity: true,\\n  strokeWidth: true\\n};\\n/**\\n * @param {string} prefix vendor-specific prefix, eg: Webkit\\n * @param {string} key style name, eg: transitionDuration\\n * @return {string} style name prefixed with `prefix`, properly camelCased, eg:\\n * WebkitTransitionDuration\\n */\\n\\nfunction prefixKey(prefix, key) {\\n  return prefix + key.charAt(0).toUpperCase() + key.substring(1);\\n}\\n/**\\n * Support style names that may come passed in prefixed by adding permutations\\n * of vendor prefixes.\\n */\\n\\n\\nvar prefixes = ['Webkit', 'ms', 'Moz', 'O']; // Using Object.keys here, or else the vanilla for-in loop makes IE8 go into an\\n// infinite loop, because it iterates over the newly added props too.\\n\\nObject.keys(isUnitlessNumber).forEach(function (prop) {\\n  prefixes.forEach(function (prefix) {\\n    isUnitlessNumber[prefixKey(prefix, prop)] = isUnitlessNumber[prop];\\n  });\\n});\\n\\n/**\\n * Convert a value into the proper css writable value. The style name `name`\\n * should be logical (no hyphens), as specified\\n * in `CSSProperty.isUnitlessNumber`.\\n *\\n * @param {string} name CSS property name such as `topMargin`.\\n * @param {*} value CSS property value such as `10px`.\\n * @return {string} Normalized style value with dimensions applied.\\n */\\n\\nfunction dangerousStyleValue(name, value, isCustomProperty) {\\n  // Note that we've removed escapeTextForBrowser() calls here since the\\n  // whole string will be escaped when the attribute is injected into\\n  // the markup. If you provide unsafe user data here they can inject\\n  // arbitrary CSS which may be problematic (I couldn't repro this):\\n  // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet\\n  // http://www.thespanner.co.uk/2007/11/26/ultimate-xss-css-injection/\\n  // This is not an XSS hole but instead a potential CSS injection issue\\n  // which has lead to a greater discussion about how we're going to\\n  // trust URLs moving forward. See #2115901\\n  var isEmpty = value == null || typeof value === 'boolean' || value === '';\\n\\n  if (isEmpty) {\\n    return '';\\n  }\\n\\n  if (!isCustomProperty && typeof value === 'number' && value !== 0 && !(isUnitlessNumber.hasOwnProperty(name) && isUnitlessNumber[name])) {\\n    return value + 'px'; // Presumes implicit 'px' suffix for unitless numbers\\n  }\\n\\n  return ('' + value).trim();\\n}\\n\\nvar uppercasePattern = /([A-Z])/g;\\nvar msPattern = /^ms-/;\\n/**\\n * Hyphenates a camelcased CSS property name, for example:\\n *\\n *   > hyphenateStyleName('backgroundColor')\\n *   < \\\"background-color\\\"\\n *   > hyphenateStyleName('MozTransition')\\n *   < \\\"-moz-transition\\\"\\n *   > hyphenateStyleName('msTransition')\\n *   < \\\"-ms-transition\\\"\\n *\\n * As Modernizr suggests (http://modernizr.com/docs/#prefixed), an `ms` prefix\\n * is converted to `-ms-`.\\n */\\n\\nfunction hyphenateStyleName(name) {\\n  return name.replace(uppercasePattern, '-$1').toLowerCase().replace(msPattern, '-ms-');\\n}\\n\\nfunction isCustomComponent(tagName, props) {\\n  if (tagName.indexOf('-') === -1) {\\n    return typeof props.is === 'string';\\n  }\\n\\n  switch (tagName) {\\n    // These are reserved SVG and MathML elements.\\n    // We don't mind this list too much because we expect it to never grow.\\n    // The alternative is to track the namespace in a few places which is convoluted.\\n    // https://w3c.github.io/webcomponents/spec/custom/#custom-elements-core-concepts\\n    case 'annotation-xml':\\n    case 'color-profile':\\n    case 'font-face':\\n    case 'font-face-src':\\n    case 'font-face-uri':\\n    case 'font-face-format':\\n    case 'font-face-name':\\n    case 'missing-glyph':\\n      return false;\\n\\n    default:\\n      return true;\\n  }\\n}\\n\\nvar warnValidStyle = function () {};\\n\\n{\\n  // 'msTransform' is correct, but the other prefixes should be capitalized\\n  var badVendoredStyleNamePattern = /^(?:webkit|moz|o)[A-Z]/;\\n  var msPattern$1 = /^-ms-/;\\n  var hyphenPattern = /-(.)/g; // style values shouldn't contain a semicolon\\n\\n  var badStyleValueWithSemicolonPattern = /;\\\\s*$/;\\n  var warnedStyleNames = {};\\n  var warnedStyleValues = {};\\n  var warnedForNaNValue = false;\\n  var warnedForInfinityValue = false;\\n\\n  var camelize = function (string) {\\n    return string.replace(hyphenPattern, function (_, character) {\\n      return character.toUpperCase();\\n    });\\n  };\\n\\n  var warnHyphenatedStyleName = function (name) {\\n    if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {\\n      return;\\n    }\\n\\n    warnedStyleNames[name] = true;\\n\\n    error('Unsupported style property %s. Did you mean %s?', name, // As Andi Smith suggests\\n    // (http://www.andismith.com/blog/2012/02/modernizr-prefixed/), an `-ms` prefix\\n    // is converted to lowercase `ms`.\\n    camelize(name.replace(msPattern$1, 'ms-')));\\n  };\\n\\n  var warnBadVendoredStyleName = function (name) {\\n    if (warnedStyleNames.hasOwnProperty(name) && warnedStyleNames[name]) {\\n      return;\\n    }\\n\\n    warnedStyleNames[name] = true;\\n\\n    error('Unsupported vendor-prefixed style property %s. Did you mean %s?', name, name.charAt(0).toUpperCase() + name.slice(1));\\n  };\\n\\n  var warnStyleValueWithSemicolon = function (name, value) {\\n    if (warnedStyleValues.hasOwnProperty(value) && warnedStyleValues[value]) {\\n      return;\\n    }\\n\\n    warnedStyleValues[value] = true;\\n\\n    error(\\\"Style property values shouldn't contain a semicolon. \\\" + 'Try \\\"%s: %s\\\" instead.', name, value.replace(badStyleValueWithSemicolonPattern, ''));\\n  };\\n\\n  var warnStyleValueIsNaN = function (name, value) {\\n    if (warnedForNaNValue) {\\n      return;\\n    }\\n\\n    warnedForNaNValue = true;\\n\\n    error('`NaN` is an invalid value for the `%s` css style property.', name);\\n  };\\n\\n  var warnStyleValueIsInfinity = function (name, value) {\\n    if (warnedForInfinityValue) {\\n      return;\\n    }\\n\\n    warnedForInfinityValue = true;\\n\\n    error('`Infinity` is an invalid value for the `%s` css style property.', name);\\n  };\\n\\n  warnValidStyle = function (name, value) {\\n    if (name.indexOf('-') > -1) {\\n      warnHyphenatedStyleName(name);\\n    } else if (badVendoredStyleNamePattern.test(name)) {\\n      warnBadVendoredStyleName(name);\\n    } else if (badStyleValueWithSemicolonPattern.test(value)) {\\n      warnStyleValueWithSemicolon(name, value);\\n    }\\n\\n    if (typeof value === 'number') {\\n      if (isNaN(value)) {\\n        warnStyleValueIsNaN(name, value);\\n      } else if (!isFinite(value)) {\\n        warnStyleValueIsInfinity(name, value);\\n      }\\n    }\\n  };\\n}\\n\\nvar warnValidStyle$1 = warnValidStyle;\\n\\nvar ariaProperties = {\\n  'aria-current': 0,\\n  // state\\n  'aria-details': 0,\\n  'aria-disabled': 0,\\n  // state\\n  'aria-hidden': 0,\\n  // state\\n  'aria-invalid': 0,\\n  // state\\n  'aria-keyshortcuts': 0,\\n  'aria-label': 0,\\n  'aria-roledescription': 0,\\n  // Widget Attributes\\n  'aria-autocomplete': 0,\\n  'aria-checked': 0,\\n  'aria-expanded': 0,\\n  'aria-haspopup': 0,\\n  'aria-level': 0,\\n  'aria-modal': 0,\\n  'aria-multiline': 0,\\n  'aria-multiselectable': 0,\\n  'aria-orientation': 0,\\n  'aria-placeholder': 0,\\n  'aria-pressed': 0,\\n  'aria-readonly': 0,\\n  'aria-required': 0,\\n  'aria-selected': 0,\\n  'aria-sort': 0,\\n  'aria-valuemax': 0,\\n  'aria-valuemin': 0,\\n  'aria-valuenow': 0,\\n  'aria-valuetext': 0,\\n  // Live Region Attributes\\n  'aria-atomic': 0,\\n  'aria-busy': 0,\\n  'aria-live': 0,\\n  'aria-relevant': 0,\\n  // Drag-and-Drop Attributes\\n  'aria-dropeffect': 0,\\n  'aria-grabbed': 0,\\n  // Relationship Attributes\\n  'aria-activedescendant': 0,\\n  'aria-colcount': 0,\\n  'aria-colindex': 0,\\n  'aria-colspan': 0,\\n  'aria-controls': 0,\\n  'aria-describedby': 0,\\n  'aria-errormessage': 0,\\n  'aria-flowto': 0,\\n  'aria-labelledby': 0,\\n  'aria-owns': 0,\\n  'aria-posinset': 0,\\n  'aria-rowcount': 0,\\n  'aria-rowindex': 0,\\n  'aria-rowspan': 0,\\n  'aria-setsize': 0\\n};\\n\\nvar warnedProperties = {};\\nvar rARIA = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');\\nvar rARIACamel = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');\\nvar hasOwnProperty$1 = Object.prototype.hasOwnProperty;\\n\\nfunction validateProperty(tagName, name) {\\n  {\\n    if (hasOwnProperty$1.call(warnedProperties, name) && warnedProperties[name]) {\\n      return true;\\n    }\\n\\n    if (rARIACamel.test(name)) {\\n      var ariaName = 'aria-' + name.slice(4).toLowerCase();\\n      var correctName = ariaProperties.hasOwnProperty(ariaName) ? ariaName : null; // If this is an aria-* attribute, but is not listed in the known DOM\\n      // DOM properties, then it is an invalid aria-* attribute.\\n\\n      if (correctName == null) {\\n        error('Invalid ARIA attribute `%s`. ARIA attributes follow the pattern aria-* and must be lowercase.', name);\\n\\n        warnedProperties[name] = true;\\n        return true;\\n      } // aria-* attributes should be lowercase; suggest the lowercase version.\\n\\n\\n      if (name !== correctName) {\\n        error('Invalid ARIA attribute `%s`. Did you mean `%s`?', name, correctName);\\n\\n        warnedProperties[name] = true;\\n        return true;\\n      }\\n    }\\n\\n    if (rARIA.test(name)) {\\n      var lowerCasedName = name.toLowerCase();\\n      var standardName = ariaProperties.hasOwnProperty(lowerCasedName) ? lowerCasedName : null; // If this is an aria-* attribute, but is not listed in the known DOM\\n      // DOM properties, then it is an invalid aria-* attribute.\\n\\n      if (standardName == null) {\\n        warnedProperties[name] = true;\\n        return false;\\n      } // aria-* attributes should be lowercase; suggest the lowercase version.\\n\\n\\n      if (name !== standardName) {\\n        error('Unknown ARIA attribute `%s`. Did you mean `%s`?', name, standardName);\\n\\n        warnedProperties[name] = true;\\n        return true;\\n      }\\n    }\\n  }\\n\\n  return true;\\n}\\n\\nfunction warnInvalidARIAProps(type, props) {\\n  {\\n    var invalidProps = [];\\n\\n    for (var key in props) {\\n      var isValid = validateProperty(type, key);\\n\\n      if (!isValid) {\\n        invalidProps.push(key);\\n      }\\n    }\\n\\n    var unknownPropString = invalidProps.map(function (prop) {\\n      return '`' + prop + '`';\\n    }).join(', ');\\n\\n    if (invalidProps.length === 1) {\\n      error('Invalid aria prop %s on <%s> tag. ' + 'For details, see https://reactjs.org/link/invalid-aria-props', unknownPropString, type);\\n    } else if (invalidProps.length > 1) {\\n      error('Invalid aria props %s on <%s> tag. ' + 'For details, see https://reactjs.org/link/invalid-aria-props', unknownPropString, type);\\n    }\\n  }\\n}\\n\\nfunction validateProperties(type, props) {\\n  if (isCustomComponent(type, props)) {\\n    return;\\n  }\\n\\n  warnInvalidARIAProps(type, props);\\n}\\n\\nvar didWarnValueNull = false;\\nfunction validateProperties$1(type, props) {\\n  {\\n    if (type !== 'input' && type !== 'textarea' && type !== 'select') {\\n      return;\\n    }\\n\\n    if (props != null && props.value === null && !didWarnValueNull) {\\n      didWarnValueNull = true;\\n\\n      if (type === 'select' && props.multiple) {\\n        error('`value` prop on `%s` should not be null. ' + 'Consider using an empty array when `multiple` is set to `true` ' + 'to clear the component or `undefined` for uncontrolled components.', type);\\n      } else {\\n        error('`value` prop on `%s` should not be null. ' + 'Consider using an empty string to clear the component or `undefined` ' + 'for uncontrolled components.', type);\\n      }\\n    }\\n  }\\n}\\n\\n// When adding attributes to the HTML or SVG allowed attribute list, be sure to\\n// also add them to this module to ensure casing and incorrect name\\n// warnings.\\nvar possibleStandardNames = {\\n  // HTML\\n  accept: 'accept',\\n  acceptcharset: 'acceptCharset',\\n  'accept-charset': 'acceptCharset',\\n  accesskey: 'accessKey',\\n  action: 'action',\\n  allowfullscreen: 'allowFullScreen',\\n  alt: 'alt',\\n  as: 'as',\\n  async: 'async',\\n  autocapitalize: 'autoCapitalize',\\n  autocomplete: 'autoComplete',\\n  autocorrect: 'autoCorrect',\\n  autofocus: 'autoFocus',\\n  autoplay: 'autoPlay',\\n  autosave: 'autoSave',\\n  capture: 'capture',\\n  cellpadding: 'cellPadding',\\n  cellspacing: 'cellSpacing',\\n  challenge: 'challenge',\\n  charset: 'charSet',\\n  checked: 'checked',\\n  children: 'children',\\n  cite: 'cite',\\n  class: 'className',\\n  classid: 'classID',\\n  classname: 'className',\\n  cols: 'cols',\\n  colspan: 'colSpan',\\n  content: 'content',\\n  contenteditable: 'contentEditable',\\n  contextmenu: 'contextMenu',\\n  controls: 'controls',\\n  controlslist: 'controlsList',\\n  coords: 'coords',\\n  crossorigin: 'crossOrigin',\\n  dangerouslysetinnerhtml: 'dangerouslySetInnerHTML',\\n  data: 'data',\\n  datetime: 'dateTime',\\n  default: 'default',\\n  defaultchecked: 'defaultChecked',\\n  defaultvalue: 'defaultValue',\\n  defer: 'defer',\\n  dir: 'dir',\\n  disabled: 'disabled',\\n  disablepictureinpicture: 'disablePictureInPicture',\\n  disableremoteplayback: 'disableRemotePlayback',\\n  download: 'download',\\n  draggable: 'draggable',\\n  enctype: 'encType',\\n  enterkeyhint: 'enterKeyHint',\\n  for: 'htmlFor',\\n  form: 'form',\\n  formmethod: 'formMethod',\\n  formaction: 'formAction',\\n  formenctype: 'formEncType',\\n  formnovalidate: 'formNoValidate',\\n  formtarget: 'formTarget',\\n  frameborder: 'frameBorder',\\n  headers: 'headers',\\n  height: 'height',\\n  hidden: 'hidden',\\n  high: 'high',\\n  href: 'href',\\n  hreflang: 'hrefLang',\\n  htmlfor: 'htmlFor',\\n  httpequiv: 'httpEquiv',\\n  'http-equiv': 'httpEquiv',\\n  icon: 'icon',\\n  id: 'id',\\n  innerhtml: 'innerHTML',\\n  inputmode: 'inputMode',\\n  integrity: 'integrity',\\n  is: 'is',\\n  itemid: 'itemID',\\n  itemprop: 'itemProp',\\n  itemref: 'itemRef',\\n  itemscope: 'itemScope',\\n  itemtype: 'itemType',\\n  keyparams: 'keyParams',\\n  keytype: 'keyType',\\n  kind: 'kind',\\n  label: 'label',\\n  lang: 'lang',\\n  list: 'list',\\n  loop: 'loop',\\n  low: 'low',\\n  manifest: 'manifest',\\n  marginwidth: 'marginWidth',\\n  marginheight: 'marginHeight',\\n  max: 'max',\\n  maxlength: 'maxLength',\\n  media: 'media',\\n  mediagroup: 'mediaGroup',\\n  method: 'method',\\n  min: 'min',\\n  minlength: 'minLength',\\n  multiple: 'multiple',\\n  muted: 'muted',\\n  name: 'name',\\n  nomodule: 'noModule',\\n  nonce: 'nonce',\\n  novalidate: 'noValidate',\\n  open: 'open',\\n  optimum: 'optimum',\\n  pattern: 'pattern',\\n  placeholder: 'placeholder',\\n  playsinline: 'playsInline',\\n  poster: 'poster',\\n  preload: 'preload',\\n  profile: 'profile',\\n  radiogroup: 'radioGroup',\\n  readonly: 'readOnly',\\n  referrerpolicy: 'referrerPolicy',\\n  rel: 'rel',\\n  required: 'required',\\n  reversed: 'reversed',\\n  role: 'role',\\n  rows: 'rows',\\n  rowspan: 'rowSpan',\\n  sandbox: 'sandbox',\\n  scope: 'scope',\\n  scoped: 'scoped',\\n  scrolling: 'scrolling',\\n  seamless: 'seamless',\\n  selected: 'selected',\\n  shape: 'shape',\\n  size: 'size',\\n  sizes: 'sizes',\\n  span: 'span',\\n  spellcheck: 'spellCheck',\\n  src: 'src',\\n  srcdoc: 'srcDoc',\\n  srclang: 'srcLang',\\n  srcset: 'srcSet',\\n  start: 'start',\\n  step: 'step',\\n  style: 'style',\\n  summary: 'summary',\\n  tabindex: 'tabIndex',\\n  target: 'target',\\n  title: 'title',\\n  type: 'type',\\n  usemap: 'useMap',\\n  value: 'value',\\n  width: 'width',\\n  wmode: 'wmode',\\n  wrap: 'wrap',\\n  // SVG\\n  about: 'about',\\n  accentheight: 'accentHeight',\\n  'accent-height': 'accentHeight',\\n  accumulate: 'accumulate',\\n  additive: 'additive',\\n  alignmentbaseline: 'alignmentBaseline',\\n  'alignment-baseline': 'alignmentBaseline',\\n  allowreorder: 'allowReorder',\\n  alphabetic: 'alphabetic',\\n  amplitude: 'amplitude',\\n  arabicform: 'arabicForm',\\n  'arabic-form': 'arabicForm',\\n  ascent: 'ascent',\\n  attributename: 'attributeName',\\n  attributetype: 'attributeType',\\n  autoreverse: 'autoReverse',\\n  azimuth: 'azimuth',\\n  basefrequency: 'baseFrequency',\\n  baselineshift: 'baselineShift',\\n  'baseline-shift': 'baselineShift',\\n  baseprofile: 'baseProfile',\\n  bbox: 'bbox',\\n  begin: 'begin',\\n  bias: 'bias',\\n  by: 'by',\\n  calcmode: 'calcMode',\\n  capheight: 'capHeight',\\n  'cap-height': 'capHeight',\\n  clip: 'clip',\\n  clippath: 'clipPath',\\n  'clip-path': 'clipPath',\\n  clippathunits: 'clipPathUnits',\\n  cliprule: 'clipRule',\\n  'clip-rule': 'clipRule',\\n  color: 'color',\\n  colorinterpolation: 'colorInterpolation',\\n  'color-interpolation': 'colorInterpolation',\\n  colorinterpolationfilters: 'colorInterpolationFilters',\\n  'color-interpolation-filters': 'colorInterpolationFilters',\\n  colorprofile: 'colorProfile',\\n  'color-profile': 'colorProfile',\\n  colorrendering: 'colorRendering',\\n  'color-rendering': 'colorRendering',\\n  contentscripttype: 'contentScriptType',\\n  contentstyletype: 'contentStyleType',\\n  cursor: 'cursor',\\n  cx: 'cx',\\n  cy: 'cy',\\n  d: 'd',\\n  datatype: 'datatype',\\n  decelerate: 'decelerate',\\n  descent: 'descent',\\n  diffuseconstant: 'diffuseConstant',\\n  direction: 'direction',\\n  display: 'display',\\n  divisor: 'divisor',\\n  dominantbaseline: 'dominantBaseline',\\n  'dominant-baseline': 'dominantBaseline',\\n  dur: 'dur',\\n  dx: 'dx',\\n  dy: 'dy',\\n  edgemode: 'edgeMode',\\n  elevation: 'elevation',\\n  enablebackground: 'enableBackground',\\n  'enable-background': 'enableBackground',\\n  end: 'end',\\n  exponent: 'exponent',\\n  externalresourcesrequired: 'externalResourcesRequired',\\n  fill: 'fill',\\n  fillopacity: 'fillOpacity',\\n  'fill-opacity': 'fillOpacity',\\n  fillrule: 'fillRule',\\n  'fill-rule': 'fillRule',\\n  filter: 'filter',\\n  filterres: 'filterRes',\\n  filterunits: 'filterUnits',\\n  floodopacity: 'floodOpacity',\\n  'flood-opacity': 'floodOpacity',\\n  floodcolor: 'floodColor',\\n  'flood-color': 'floodColor',\\n  focusable: 'focusable',\\n  fontfamily: 'fontFamily',\\n  'font-family': 'fontFamily',\\n  fontsize: 'fontSize',\\n  'font-size': 'fontSize',\\n  fontsizeadjust: 'fontSizeAdjust',\\n  'font-size-adjust': 'fontSizeAdjust',\\n  fontstretch: 'fontStretch',\\n  'font-stretch': 'fontStretch',\\n  fontstyle: 'fontStyle',\\n  'font-style': 'fontStyle',\\n  fontvariant: 'fontVariant',\\n  'font-variant': 'fontVariant',\\n  fontweight: 'fontWeight',\\n  'font-weight': 'fontWeight',\\n  format: 'format',\\n  from: 'from',\\n  fx: 'fx',\\n  fy: 'fy',\\n  g1: 'g1',\\n  g2: 'g2',\\n  glyphname: 'glyphName',\\n  'glyph-name': 'glyphName',\\n  glyphorientationhorizontal: 'glyphOrientationHorizontal',\\n  'glyph-orientation-horizontal': 'glyphOrientationHorizontal',\\n  glyphorientationvertical: 'glyphOrientationVertical',\\n  'glyph-orientation-vertical': 'glyphOrientationVertical',\\n  glyphref: 'glyphRef',\\n  gradienttransform: 'gradientTransform',\\n  gradientunits: 'gradientUnits',\\n  hanging: 'hanging',\\n  horizadvx: 'horizAdvX',\\n  'horiz-adv-x': 'horizAdvX',\\n  horizoriginx: 'horizOriginX',\\n  'horiz-origin-x': 'horizOriginX',\\n  ideographic: 'ideographic',\\n  imagerendering: 'imageRendering',\\n  'image-rendering': 'imageRendering',\\n  in2: 'in2',\\n  in: 'in',\\n  inlist: 'inlist',\\n  intercept: 'intercept',\\n  k1: 'k1',\\n  k2: 'k2',\\n  k3: 'k3',\\n  k4: 'k4',\\n  k: 'k',\\n  kernelmatrix: 'kernelMatrix',\\n  kernelunitlength: 'kernelUnitLength',\\n  kerning: 'kerning',\\n  keypoints: 'keyPoints',\\n  keysplines: 'keySplines',\\n  keytimes: 'keyTimes',\\n  lengthadjust: 'lengthAdjust',\\n  letterspacing: 'letterSpacing',\\n  'letter-spacing': 'letterSpacing',\\n  lightingcolor: 'lightingColor',\\n  'lighting-color': 'lightingColor',\\n  limitingconeangle: 'limitingConeAngle',\\n  local: 'local',\\n  markerend: 'markerEnd',\\n  'marker-end': 'markerEnd',\\n  markerheight: 'markerHeight',\\n  markermid: 'markerMid',\\n  'marker-mid': 'markerMid',\\n  markerstart: 'markerStart',\\n  'marker-start': 'markerStart',\\n  markerunits: 'markerUnits',\\n  markerwidth: 'markerWidth',\\n  mask: 'mask',\\n  maskcontentunits: 'maskContentUnits',\\n  maskunits: 'maskUnits',\\n  mathematical: 'mathematical',\\n  mode: 'mode',\\n  numoctaves: 'numOctaves',\\n  offset: 'offset',\\n  opacity: 'opacity',\\n  operator: 'operator',\\n  order: 'order',\\n  orient: 'orient',\\n  orientation: 'orientation',\\n  origin: 'origin',\\n  overflow: 'overflow',\\n  overlineposition: 'overlinePosition',\\n  'overline-position': 'overlinePosition',\\n  overlinethickness: 'overlineThickness',\\n  'overline-thickness': 'overlineThickness',\\n  paintorder: 'paintOrder',\\n  'paint-order': 'paintOrder',\\n  panose1: 'panose1',\\n  'panose-1': 'panose1',\\n  pathlength: 'pathLength',\\n  patterncontentunits: 'patternContentUnits',\\n  patterntransform: 'patternTransform',\\n  patternunits: 'patternUnits',\\n  pointerevents: 'pointerEvents',\\n  'pointer-events': 'pointerEvents',\\n  points: 'points',\\n  pointsatx: 'pointsAtX',\\n  pointsaty: 'pointsAtY',\\n  pointsatz: 'pointsAtZ',\\n  prefix: 'prefix',\\n  preservealpha: 'preserveAlpha',\\n  preserveaspectratio: 'preserveAspectRatio',\\n  primitiveunits: 'primitiveUnits',\\n  property: 'property',\\n  r: 'r',\\n  radius: 'radius',\\n  refx: 'refX',\\n  refy: 'refY',\\n  renderingintent: 'renderingIntent',\\n  'rendering-intent': 'renderingIntent',\\n  repeatcount: 'repeatCount',\\n  repeatdur: 'repeatDur',\\n  requiredextensions: 'requiredExtensions',\\n  requiredfeatures: 'requiredFeatures',\\n  resource: 'resource',\\n  restart: 'restart',\\n  result: 'result',\\n  results: 'results',\\n  rotate: 'rotate',\\n  rx: 'rx',\\n  ry: 'ry',\\n  scale: 'scale',\\n  security: 'security',\\n  seed: 'seed',\\n  shaperendering: 'shapeRendering',\\n  'shape-rendering': 'shapeRendering',\\n  slope: 'slope',\\n  spacing: 'spacing',\\n  specularconstant: 'specularConstant',\\n  specularexponent: 'specularExponent',\\n  speed: 'speed',\\n  spreadmethod: 'spreadMethod',\\n  startoffset: 'startOffset',\\n  stddeviation: 'stdDeviation',\\n  stemh: 'stemh',\\n  stemv: 'stemv',\\n  stitchtiles: 'stitchTiles',\\n  stopcolor: 'stopColor',\\n  'stop-color': 'stopColor',\\n  stopopacity: 'stopOpacity',\\n  'stop-opacity': 'stopOpacity',\\n  strikethroughposition: 'strikethroughPosition',\\n  'strikethrough-position': 'strikethroughPosition',\\n  strikethroughthickness: 'strikethroughThickness',\\n  'strikethrough-thickness': 'strikethroughThickness',\\n  string: 'string',\\n  stroke: 'stroke',\\n  strokedasharray: 'strokeDasharray',\\n  'stroke-dasharray': 'strokeDasharray',\\n  strokedashoffset: 'strokeDashoffset',\\n  'stroke-dashoffset': 'strokeDashoffset',\\n  strokelinecap: 'strokeLinecap',\\n  'stroke-linecap': 'strokeLinecap',\\n  strokelinejoin: 'strokeLinejoin',\\n  'stroke-linejoin': 'strokeLinejoin',\\n  strokemiterlimit: 'strokeMiterlimit',\\n  'stroke-miterlimit': 'strokeMiterlimit',\\n  strokewidth: 'strokeWidth',\\n  'stroke-width': 'strokeWidth',\\n  strokeopacity: 'strokeOpacity',\\n  'stroke-opacity': 'strokeOpacity',\\n  suppresscontenteditablewarning: 'suppressContentEditableWarning',\\n  suppresshydrationwarning: 'suppressHydrationWarning',\\n  surfacescale: 'surfaceScale',\\n  systemlanguage: 'systemLanguage',\\n  tablevalues: 'tableValues',\\n  targetx: 'targetX',\\n  targety: 'targetY',\\n  textanchor: 'textAnchor',\\n  'text-anchor': 'textAnchor',\\n  textdecoration: 'textDecoration',\\n  'text-decoration': 'textDecoration',\\n  textlength: 'textLength',\\n  textrendering: 'textRendering',\\n  'text-rendering': 'textRendering',\\n  to: 'to',\\n  transform: 'transform',\\n  typeof: 'typeof',\\n  u1: 'u1',\\n  u2: 'u2',\\n  underlineposition: 'underlinePosition',\\n  'underline-position': 'underlinePosition',\\n  underlinethickness: 'underlineThickness',\\n  'underline-thickness': 'underlineThickness',\\n  unicode: 'unicode',\\n  unicodebidi: 'unicodeBidi',\\n  'unicode-bidi': 'unicodeBidi',\\n  unicoderange: 'unicodeRange',\\n  'unicode-range': 'unicodeRange',\\n  unitsperem: 'unitsPerEm',\\n  'units-per-em': 'unitsPerEm',\\n  unselectable: 'unselectable',\\n  valphabetic: 'vAlphabetic',\\n  'v-alphabetic': 'vAlphabetic',\\n  values: 'values',\\n  vectoreffect: 'vectorEffect',\\n  'vector-effect': 'vectorEffect',\\n  version: 'version',\\n  vertadvy: 'vertAdvY',\\n  'vert-adv-y': 'vertAdvY',\\n  vertoriginx: 'vertOriginX',\\n  'vert-origin-x': 'vertOriginX',\\n  vertoriginy: 'vertOriginY',\\n  'vert-origin-y': 'vertOriginY',\\n  vhanging: 'vHanging',\\n  'v-hanging': 'vHanging',\\n  videographic: 'vIdeographic',\\n  'v-ideographic': 'vIdeographic',\\n  viewbox: 'viewBox',\\n  viewtarget: 'viewTarget',\\n  visibility: 'visibility',\\n  vmathematical: 'vMathematical',\\n  'v-mathematical': 'vMathematical',\\n  vocab: 'vocab',\\n  widths: 'widths',\\n  wordspacing: 'wordSpacing',\\n  'word-spacing': 'wordSpacing',\\n  writingmode: 'writingMode',\\n  'writing-mode': 'writingMode',\\n  x1: 'x1',\\n  x2: 'x2',\\n  x: 'x',\\n  xchannelselector: 'xChannelSelector',\\n  xheight: 'xHeight',\\n  'x-height': 'xHeight',\\n  xlinkactuate: 'xlinkActuate',\\n  'xlink:actuate': 'xlinkActuate',\\n  xlinkarcrole: 'xlinkArcrole',\\n  'xlink:arcrole': 'xlinkArcrole',\\n  xlinkhref: 'xlinkHref',\\n  'xlink:href': 'xlinkHref',\\n  xlinkrole: 'xlinkRole',\\n  'xlink:role': 'xlinkRole',\\n  xlinkshow: 'xlinkShow',\\n  'xlink:show': 'xlinkShow',\\n  xlinktitle: 'xlinkTitle',\\n  'xlink:title': 'xlinkTitle',\\n  xlinktype: 'xlinkType',\\n  'xlink:type': 'xlinkType',\\n  xmlbase: 'xmlBase',\\n  'xml:base': 'xmlBase',\\n  xmllang: 'xmlLang',\\n  'xml:lang': 'xmlLang',\\n  xmlns: 'xmlns',\\n  'xml:space': 'xmlSpace',\\n  xmlnsxlink: 'xmlnsXlink',\\n  'xmlns:xlink': 'xmlnsXlink',\\n  xmlspace: 'xmlSpace',\\n  y1: 'y1',\\n  y2: 'y2',\\n  y: 'y',\\n  ychannelselector: 'yChannelSelector',\\n  z: 'z',\\n  zoomandpan: 'zoomAndPan'\\n};\\n\\nvar validateProperty$1 = function () {};\\n\\n{\\n  var warnedProperties$1 = {};\\n  var _hasOwnProperty = Object.prototype.hasOwnProperty;\\n  var EVENT_NAME_REGEX = /^on./;\\n  var INVALID_EVENT_NAME_REGEX = /^on[^A-Z]/;\\n  var rARIA$1 = new RegExp('^(aria)-[' + ATTRIBUTE_NAME_CHAR + ']*$');\\n  var rARIACamel$1 = new RegExp('^(aria)[A-Z][' + ATTRIBUTE_NAME_CHAR + ']*$');\\n\\n  validateProperty$1 = function (tagName, name, value, eventRegistry) {\\n    if (_hasOwnProperty.call(warnedProperties$1, name) && warnedProperties$1[name]) {\\n      return true;\\n    }\\n\\n    var lowerCasedName = name.toLowerCase();\\n\\n    if (lowerCasedName === 'onfocusin' || lowerCasedName === 'onfocusout') {\\n      error('React uses onFocus and onBlur instead of onFocusIn and onFocusOut. ' + 'All React events are normalized to bubble, so onFocusIn and onFocusOut ' + 'are not needed/supported by React.');\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    } // We can't rely on the event system being injected on the server.\\n\\n\\n    if (eventRegistry != null) {\\n      var registrationNameDependencies = eventRegistry.registrationNameDependencies,\\n          possibleRegistrationNames = eventRegistry.possibleRegistrationNames;\\n\\n      if (registrationNameDependencies.hasOwnProperty(name)) {\\n        return true;\\n      }\\n\\n      var registrationName = possibleRegistrationNames.hasOwnProperty(lowerCasedName) ? possibleRegistrationNames[lowerCasedName] : null;\\n\\n      if (registrationName != null) {\\n        error('Invalid event handler property `%s`. Did you mean `%s`?', name, registrationName);\\n\\n        warnedProperties$1[name] = true;\\n        return true;\\n      }\\n\\n      if (EVENT_NAME_REGEX.test(name)) {\\n        error('Unknown event handler property `%s`. It will be ignored.', name);\\n\\n        warnedProperties$1[name] = true;\\n        return true;\\n      }\\n    } else if (EVENT_NAME_REGEX.test(name)) {\\n      // If no event plugins have been injected, we are in a server environment.\\n      // So we can't tell if the event name is correct for sure, but we can filter\\n      // out known bad ones like `onclick`. We can't suggest a specific replacement though.\\n      if (INVALID_EVENT_NAME_REGEX.test(name)) {\\n        error('Invalid event handler property `%s`. ' + 'React events use the camelCase naming convention, for example `onClick`.', name);\\n      }\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    } // Let the ARIA attribute hook validate ARIA attributes\\n\\n\\n    if (rARIA$1.test(name) || rARIACamel$1.test(name)) {\\n      return true;\\n    }\\n\\n    if (lowerCasedName === 'innerhtml') {\\n      error('Directly setting property `innerHTML` is not permitted. ' + 'For more information, lookup documentation on `dangerouslySetInnerHTML`.');\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    if (lowerCasedName === 'aria') {\\n      error('The `aria` attribute is reserved for future use in React. ' + 'Pass individual `aria-` attributes instead.');\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    if (lowerCasedName === 'is' && value !== null && value !== undefined && typeof value !== 'string') {\\n      error('Received a `%s` for a string attribute `is`. If this is expected, cast ' + 'the value to a string.', typeof value);\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    if (typeof value === 'number' && isNaN(value)) {\\n      error('Received NaN for the `%s` attribute. If this is expected, cast ' + 'the value to a string.', name);\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    var propertyInfo = getPropertyInfo(name);\\n    var isReserved = propertyInfo !== null && propertyInfo.type === RESERVED; // Known attributes should match the casing specified in the property config.\\n\\n    if (possibleStandardNames.hasOwnProperty(lowerCasedName)) {\\n      var standardName = possibleStandardNames[lowerCasedName];\\n\\n      if (standardName !== name) {\\n        error('Invalid DOM property `%s`. Did you mean `%s`?', name, standardName);\\n\\n        warnedProperties$1[name] = true;\\n        return true;\\n      }\\n    } else if (!isReserved && name !== lowerCasedName) {\\n      // Unknown attributes should have lowercase casing since that's how they\\n      // will be cased anyway with server rendering.\\n      error('React does not recognize the `%s` prop on a DOM element. If you ' + 'intentionally want it to appear in the DOM as a custom ' + 'attribute, spell it as lowercase `%s` instead. ' + 'If you accidentally passed it from a parent component, remove ' + 'it from the DOM element.', name, lowerCasedName);\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    if (typeof value === 'boolean' && shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {\\n      if (value) {\\n        error('Received `%s` for a non-boolean attribute `%s`.\\\\n\\\\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s=\\\"%s\\\" or %s={value.toString()}.', value, name, name, value, name);\\n      } else {\\n        error('Received `%s` for a non-boolean attribute `%s`.\\\\n\\\\n' + 'If you want to write it to the DOM, pass a string instead: ' + '%s=\\\"%s\\\" or %s={value.toString()}.\\\\n\\\\n' + 'If you used to conditionally omit it with %s={condition && value}, ' + 'pass %s={condition ? value : undefined} instead.', value, name, name, value, name, name, name);\\n      }\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    } // Now that we've validated casing, do not validate\\n    // data types for reserved props\\n\\n\\n    if (isReserved) {\\n      return true;\\n    } // Warn when a known attribute is a bad type\\n\\n\\n    if (shouldRemoveAttributeWithWarning(name, value, propertyInfo, false)) {\\n      warnedProperties$1[name] = true;\\n      return false;\\n    } // Warn when passing the strings 'false' or 'true' into a boolean prop\\n\\n\\n    if ((value === 'false' || value === 'true') && propertyInfo !== null && propertyInfo.type === BOOLEAN) {\\n      error('Received the string `%s` for the boolean attribute `%s`. ' + '%s ' + 'Did you mean %s={%s}?', value, name, value === 'false' ? 'The browser will interpret it as a truthy value.' : 'Although this works, it will not work as expected if you pass the string \\\"false\\\".', name, value);\\n\\n      warnedProperties$1[name] = true;\\n      return true;\\n    }\\n\\n    return true;\\n  };\\n}\\n\\nvar warnUnknownProperties = function (type, props, eventRegistry) {\\n  {\\n    var unknownProps = [];\\n\\n    for (var key in props) {\\n      var isValid = validateProperty$1(type, key, props[key], eventRegistry);\\n\\n      if (!isValid) {\\n        unknownProps.push(key);\\n      }\\n    }\\n\\n    var unknownPropString = unknownProps.map(function (prop) {\\n      return '`' + prop + '`';\\n    }).join(', ');\\n\\n    if (unknownProps.length === 1) {\\n      error('Invalid value for prop %s on <%s> tag. Either remove it from the element, ' + 'or pass a string or number value to keep it in the DOM. ' + 'For details, see https://reactjs.org/link/attribute-behavior ', unknownPropString, type);\\n    } else if (unknownProps.length > 1) {\\n      error('Invalid values for props %s on <%s> tag. Either remove them from the element, ' + 'or pass a string or number value to keep them in the DOM. ' + 'For details, see https://reactjs.org/link/attribute-behavior ', unknownPropString, type);\\n    }\\n  }\\n};\\n\\nfunction validateProperties$2(type, props, eventRegistry) {\\n  if (isCustomComponent(type, props)) {\\n    return;\\n  }\\n\\n  warnUnknownProperties(type, props, eventRegistry);\\n}\\n\\nvar toArray = React.Children.toArray; // This is only used in DEV.\\n// Each entry is `this.stack` from a currently executing renderer instance.\\n// (There may be more than one because ReactDOMServer is reentrant).\\n// Each stack is an array of frames which may contain nested stacks of elements.\\n\\nvar currentDebugStacks = [];\\nvar ReactCurrentDispatcher$1 = ReactSharedInternals.ReactCurrentDispatcher;\\nvar ReactDebugCurrentFrame$1;\\nvar prevGetCurrentStackImpl = null;\\n\\nvar getCurrentServerStackImpl = function () {\\n  return '';\\n};\\n\\nvar describeStackFrame = function (element) {\\n  return '';\\n};\\n\\nvar validatePropertiesInDevelopment = function (type, props) {};\\n\\nvar pushCurrentDebugStack = function (stack) {};\\n\\nvar pushElementToDebugStack = function (element) {};\\n\\nvar popCurrentDebugStack = function () {};\\n\\nvar hasWarnedAboutUsingContextAsConsumer = false;\\n\\n{\\n  ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;\\n\\n  validatePropertiesInDevelopment = function (type, props) {\\n    validateProperties(type, props);\\n    validateProperties$1(type, props);\\n    validateProperties$2(type, props, null);\\n  };\\n\\n  describeStackFrame = function (element) {\\n    return describeUnknownElementTypeFrameInDEV(element.type, element._source, null);\\n  };\\n\\n  pushCurrentDebugStack = function (stack) {\\n    currentDebugStacks.push(stack);\\n\\n    if (currentDebugStacks.length === 1) {\\n      // We are entering a server renderer.\\n      // Remember the previous (e.g. client) global stack implementation.\\n      prevGetCurrentStackImpl = ReactDebugCurrentFrame$1.getCurrentStack;\\n      ReactDebugCurrentFrame$1.getCurrentStack = getCurrentServerStackImpl;\\n    }\\n  };\\n\\n  pushElementToDebugStack = function (element) {\\n    // For the innermost executing ReactDOMServer call,\\n    var stack = currentDebugStacks[currentDebugStacks.length - 1]; // Take the innermost executing frame (e.g. <Foo>),\\n\\n    var frame = stack[stack.length - 1]; // and record that it has one more element associated with it.\\n\\n    frame.debugElementStack.push(element); // We only need this because we tail-optimize single-element\\n    // children and directly handle them in an inner loop instead of\\n    // creating separate frames for them.\\n  };\\n\\n  popCurrentDebugStack = function () {\\n    currentDebugStacks.pop();\\n\\n    if (currentDebugStacks.length === 0) {\\n      // We are exiting the server renderer.\\n      // Restore the previous (e.g. client) global stack implementation.\\n      ReactDebugCurrentFrame$1.getCurrentStack = prevGetCurrentStackImpl;\\n      prevGetCurrentStackImpl = null;\\n    }\\n  };\\n\\n  getCurrentServerStackImpl = function () {\\n    if (currentDebugStacks.length === 0) {\\n      // Nothing is currently rendering.\\n      return '';\\n    } // ReactDOMServer is reentrant so there may be multiple calls at the same time.\\n    // Take the frames from the innermost call which is the last in the array.\\n\\n\\n    var frames = currentDebugStacks[currentDebugStacks.length - 1];\\n    var stack = ''; // Go through every frame in the stack from the innermost one.\\n\\n    for (var i = frames.length - 1; i >= 0; i--) {\\n      var frame = frames[i]; // Every frame might have more than one debug element stack entry associated with it.\\n      // This is because single-child nesting doesn't create materialized frames.\\n      // Instead it would push them through `pushElementToDebugStack()`.\\n\\n      var debugElementStack = frame.debugElementStack;\\n\\n      for (var ii = debugElementStack.length - 1; ii >= 0; ii--) {\\n        stack += describeStackFrame(debugElementStack[ii]);\\n      }\\n    }\\n\\n    return stack;\\n  };\\n}\\n\\nvar didWarnDefaultInputValue = false;\\nvar didWarnDefaultChecked = false;\\nvar didWarnDefaultSelectValue = false;\\nvar didWarnDefaultTextareaValue = false;\\nvar didWarnInvalidOptionChildren = false;\\nvar didWarnAboutNoopUpdateForComponent = {};\\nvar didWarnAboutBadClass = {};\\nvar didWarnAboutModulePatternComponent = {};\\nvar didWarnAboutDeprecatedWillMount = {};\\nvar didWarnAboutUndefinedDerivedState = {};\\nvar didWarnAboutUninitializedState = {};\\nvar valuePropNames = ['value', 'defaultValue'];\\nvar newlineEatingTags = {\\n  listing: true,\\n  pre: true,\\n  textarea: true\\n}; // We accept any tag to be rendered but since this gets injected into arbitrary\\n// HTML, we want to make sure that it's a safe tag.\\n// http://www.w3.org/TR/REC-xml/#NT-Name\\n\\nvar VALID_TAG_REGEX = /^[a-zA-Z][a-zA-Z:_\\\\.\\\\-\\\\d]*$/; // Simplified subset\\n\\nvar validatedTagCache = {};\\n\\nfunction validateDangerousTag(tag) {\\n  if (!validatedTagCache.hasOwnProperty(tag)) {\\n    if (!VALID_TAG_REGEX.test(tag)) {\\n      {\\n        throw Error( \\\"Invalid tag: \\\" + tag );\\n      }\\n    }\\n\\n    validatedTagCache[tag] = true;\\n  }\\n}\\n\\nvar styleNameCache = {};\\n\\nvar processStyleName = function (styleName) {\\n  if (styleNameCache.hasOwnProperty(styleName)) {\\n    return styleNameCache[styleName];\\n  }\\n\\n  var result = hyphenateStyleName(styleName);\\n  styleNameCache[styleName] = result;\\n  return result;\\n};\\n\\nfunction createMarkupForStyles(styles) {\\n  var serialized = '';\\n  var delimiter = '';\\n\\n  for (var styleName in styles) {\\n    if (!styles.hasOwnProperty(styleName)) {\\n      continue;\\n    }\\n\\n    var isCustomProperty = styleName.indexOf('--') === 0;\\n    var styleValue = styles[styleName];\\n\\n    {\\n      if (!isCustomProperty) {\\n        warnValidStyle$1(styleName, styleValue);\\n      }\\n    }\\n\\n    if (styleValue != null) {\\n      serialized += delimiter + (isCustomProperty ? styleName : processStyleName(styleName)) + ':';\\n      serialized += dangerousStyleValue(styleName, styleValue, isCustomProperty);\\n      delimiter = ';';\\n    }\\n  }\\n\\n  return serialized || null;\\n}\\n\\nfunction warnNoop(publicInstance, callerName) {\\n  {\\n    var _constructor = publicInstance.constructor;\\n    var componentName = _constructor && getComponentName(_constructor) || 'ReactClass';\\n    var warningKey = componentName + '.' + callerName;\\n\\n    if (didWarnAboutNoopUpdateForComponent[warningKey]) {\\n      return;\\n    }\\n\\n    error('%s(...): Can only update a mounting component. ' + 'This usually means you called %s() outside componentWillMount() on the server. ' + 'This is a no-op.\\\\n\\\\nPlease check the code for the %s component.', callerName, callerName, componentName);\\n\\n    didWarnAboutNoopUpdateForComponent[warningKey] = true;\\n  }\\n}\\n\\nfunction shouldConstruct$1(Component) {\\n  return Component.prototype && Component.prototype.isReactComponent;\\n}\\n\\nfunction getNonChildrenInnerMarkup(props) {\\n  var innerHTML = props.dangerouslySetInnerHTML;\\n\\n  if (innerHTML != null) {\\n    if (innerHTML.__html != null) {\\n      return innerHTML.__html;\\n    }\\n  } else {\\n    var content = props.children;\\n\\n    if (typeof content === 'string' || typeof content === 'number') {\\n      return escapeTextForBrowser(content);\\n    }\\n  }\\n\\n  return null;\\n}\\n\\nfunction flattenTopLevelChildren(children) {\\n  if (!React.isValidElement(children)) {\\n    return toArray(children);\\n  }\\n\\n  var element = children;\\n\\n  if (element.type !== REACT_FRAGMENT_TYPE) {\\n    return [element];\\n  }\\n\\n  var fragmentChildren = element.props.children;\\n\\n  if (!React.isValidElement(fragmentChildren)) {\\n    return toArray(fragmentChildren);\\n  }\\n\\n  var fragmentChildElement = fragmentChildren;\\n  return [fragmentChildElement];\\n}\\n\\nfunction flattenOptionChildren(children) {\\n  if (children === undefined || children === null) {\\n    return children;\\n  }\\n\\n  var content = ''; // Flatten children and warn if they aren't strings or numbers;\\n  // invalid types are ignored.\\n\\n  React.Children.forEach(children, function (child) {\\n    if (child == null) {\\n      return;\\n    }\\n\\n    content += child;\\n\\n    {\\n      if (!didWarnInvalidOptionChildren && typeof child !== 'string' && typeof child !== 'number') {\\n        didWarnInvalidOptionChildren = true;\\n\\n        error('Only strings and numbers are supported as <option> children.');\\n      }\\n    }\\n  });\\n  return content;\\n}\\n\\nvar hasOwnProperty$2 = Object.prototype.hasOwnProperty;\\nvar STYLE = 'style';\\nvar RESERVED_PROPS = {\\n  children: null,\\n  dangerouslySetInnerHTML: null,\\n  suppressContentEditableWarning: null,\\n  suppressHydrationWarning: null\\n};\\n\\nfunction createOpenTagMarkup(tagVerbatim, tagLowercase, props, namespace, makeStaticMarkup, isRootElement) {\\n  var ret = '<' + tagVerbatim;\\n  var isCustomComponent$1 = isCustomComponent(tagLowercase, props);\\n\\n  for (var propKey in props) {\\n    if (!hasOwnProperty$2.call(props, propKey)) {\\n      continue;\\n    }\\n\\n    var propValue = props[propKey];\\n\\n    if (propValue == null) {\\n      continue;\\n    }\\n\\n    if (propKey === STYLE) {\\n      propValue = createMarkupForStyles(propValue);\\n    }\\n\\n    var markup = null;\\n\\n    if (isCustomComponent$1) {\\n      if (!RESERVED_PROPS.hasOwnProperty(propKey)) {\\n        markup = createMarkupForCustomAttribute(propKey, propValue);\\n      }\\n    } else {\\n      markup = createMarkupForProperty(propKey, propValue);\\n    }\\n\\n    if (markup) {\\n      ret += ' ' + markup;\\n    }\\n  } // For static pages, no need to put React ID and checksum. Saves lots of\\n  // bytes.\\n\\n\\n  if (makeStaticMarkup) {\\n    return ret;\\n  }\\n\\n  if (isRootElement) {\\n    ret += ' ' + createMarkupForRoot();\\n  }\\n\\n  return ret;\\n}\\n\\nfunction validateRenderResult(child, type) {\\n  if (child === undefined) {\\n    {\\n      {\\n        throw Error( (getComponentName(type) || 'Component') + \\\"(...): Nothing was returned from render. This usually means a return statement is missing. Or, to render nothing, return null.\\\" );\\n      }\\n    }\\n  }\\n}\\n\\nfunction resolve(child, context, threadID) {\\n  while (React.isValidElement(child)) {\\n    // Safe because we just checked it's an element.\\n    var element = child;\\n    var Component = element.type;\\n\\n    {\\n      pushElementToDebugStack(element);\\n    }\\n\\n    if (typeof Component !== 'function') {\\n      break;\\n    }\\n\\n    processChild(element, Component);\\n  } // Extra closure so queue and replace can be captured properly\\n\\n\\n  function processChild(element, Component) {\\n    var isClass = shouldConstruct$1(Component);\\n    var publicContext = processContext(Component, context, threadID, isClass);\\n    var queue = [];\\n    var replace = false;\\n    var updater = {\\n      isMounted: function (publicInstance) {\\n        return false;\\n      },\\n      enqueueForceUpdate: function (publicInstance) {\\n        if (queue === null) {\\n          warnNoop(publicInstance, 'forceUpdate');\\n          return null;\\n        }\\n      },\\n      enqueueReplaceState: function (publicInstance, completeState) {\\n        replace = true;\\n        queue = [completeState];\\n      },\\n      enqueueSetState: function (publicInstance, currentPartialState) {\\n        if (queue === null) {\\n          warnNoop(publicInstance, 'setState');\\n          return null;\\n        }\\n\\n        queue.push(currentPartialState);\\n      }\\n    };\\n    var inst;\\n\\n    if (isClass) {\\n      inst = new Component(element.props, publicContext, updater);\\n\\n      if (typeof Component.getDerivedStateFromProps === 'function') {\\n        {\\n          if (inst.state === null || inst.state === undefined) {\\n            var componentName = getComponentName(Component) || 'Unknown';\\n\\n            if (!didWarnAboutUninitializedState[componentName]) {\\n              error('`%s` uses `getDerivedStateFromProps` but its initial state is ' + '%s. This is not recommended. Instead, define the initial state by ' + 'assigning an object to `this.state` in the constructor of `%s`. ' + 'This ensures that `getDerivedStateFromProps` arguments have a consistent shape.', componentName, inst.state === null ? 'null' : 'undefined', componentName);\\n\\n              didWarnAboutUninitializedState[componentName] = true;\\n            }\\n          }\\n        }\\n\\n        var partialState = Component.getDerivedStateFromProps.call(null, element.props, inst.state);\\n\\n        {\\n          if (partialState === undefined) {\\n            var _componentName = getComponentName(Component) || 'Unknown';\\n\\n            if (!didWarnAboutUndefinedDerivedState[_componentName]) {\\n              error('%s.getDerivedStateFromProps(): A valid state object (or null) must be returned. ' + 'You have returned undefined.', _componentName);\\n\\n              didWarnAboutUndefinedDerivedState[_componentName] = true;\\n            }\\n          }\\n        }\\n\\n        if (partialState != null) {\\n          inst.state = _assign({}, inst.state, partialState);\\n        }\\n      }\\n    } else {\\n      {\\n        if (Component.prototype && typeof Component.prototype.render === 'function') {\\n          var _componentName2 = getComponentName(Component) || 'Unknown';\\n\\n          if (!didWarnAboutBadClass[_componentName2]) {\\n            error(\\\"The <%s /> component appears to have a render method, but doesn't extend React.Component. \\\" + 'This is likely to cause errors. Change %s to extend React.Component instead.', _componentName2, _componentName2);\\n\\n            didWarnAboutBadClass[_componentName2] = true;\\n          }\\n        }\\n      }\\n\\n      var componentIdentity = {};\\n      prepareToUseHooks(componentIdentity);\\n      inst = Component(element.props, publicContext, updater);\\n      inst = finishHooks(Component, element.props, inst, publicContext);\\n\\n      {\\n        // Support for module components is deprecated and is removed behind a flag.\\n        // Whether or not it would crash later, we want to show a good message in DEV first.\\n        if (inst != null && inst.render != null) {\\n          var _componentName3 = getComponentName(Component) || 'Unknown';\\n\\n          if (!didWarnAboutModulePatternComponent[_componentName3]) {\\n            error('The <%s /> component appears to be a function component that returns a class instance. ' + 'Change %s to a class that extends React.Component instead. ' + \\\"If you can't use a class try assigning the prototype on the function as a workaround. \\\" + \\\"`%s.prototype = React.Component.prototype`. Don't use an arrow function since it \\\" + 'cannot be called with `new` by React.', _componentName3, _componentName3, _componentName3);\\n\\n            didWarnAboutModulePatternComponent[_componentName3] = true;\\n          }\\n        }\\n      } // If the flag is on, everything is assumed to be a function component.\\n      // Otherwise, we also do the unfortunate dynamic checks.\\n\\n\\n      if ( inst == null || inst.render == null) {\\n        child = inst;\\n        validateRenderResult(child, Component);\\n        return;\\n      }\\n    }\\n\\n    inst.props = element.props;\\n    inst.context = publicContext;\\n    inst.updater = updater;\\n    var initialState = inst.state;\\n\\n    if (initialState === undefined) {\\n      inst.state = initialState = null;\\n    }\\n\\n    if (typeof inst.UNSAFE_componentWillMount === 'function' || typeof inst.componentWillMount === 'function') {\\n      if (typeof inst.componentWillMount === 'function') {\\n        {\\n          if ( inst.componentWillMount.__suppressDeprecationWarning !== true) {\\n            var _componentName4 = getComponentName(Component) || 'Unknown';\\n\\n            if (!didWarnAboutDeprecatedWillMount[_componentName4]) {\\n              warn( // keep this warning in sync with ReactStrictModeWarning.js\\n              'componentWillMount has been renamed, and is not recommended for use. ' + 'See https://reactjs.org/link/unsafe-component-lifecycles for details.\\\\n\\\\n' + '* Move code from componentWillMount to componentDidMount (preferred in most cases) ' + 'or the constructor.\\\\n' + '\\\\nPlease update the following components: %s', _componentName4);\\n\\n              didWarnAboutDeprecatedWillMount[_componentName4] = true;\\n            }\\n          }\\n        } // In order to support react-lifecycles-compat polyfilled components,\\n        // Unsafe lifecycles should not be invoked for any component with the new gDSFP.\\n\\n\\n        if (typeof Component.getDerivedStateFromProps !== 'function') {\\n          inst.componentWillMount();\\n        }\\n      }\\n\\n      if (typeof inst.UNSAFE_componentWillMount === 'function' && typeof Component.getDerivedStateFromProps !== 'function') {\\n        // In order to support react-lifecycles-compat polyfilled components,\\n        // Unsafe lifecycles should not be invoked for any component with the new gDSFP.\\n        inst.UNSAFE_componentWillMount();\\n      }\\n\\n      if (queue.length) {\\n        var oldQueue = queue;\\n        var oldReplace = replace;\\n        queue = null;\\n        replace = false;\\n\\n        if (oldReplace && oldQueue.length === 1) {\\n          inst.state = oldQueue[0];\\n        } else {\\n          var nextState = oldReplace ? oldQueue[0] : inst.state;\\n          var dontMutate = true;\\n\\n          for (var i = oldReplace ? 1 : 0; i < oldQueue.length; i++) {\\n            var partial = oldQueue[i];\\n\\n            var _partialState = typeof partial === 'function' ? partial.call(inst, nextState, element.props, publicContext) : partial;\\n\\n            if (_partialState != null) {\\n              if (dontMutate) {\\n                dontMutate = false;\\n                nextState = _assign({}, nextState, _partialState);\\n              } else {\\n                _assign(nextState, _partialState);\\n              }\\n            }\\n          }\\n\\n          inst.state = nextState;\\n        }\\n      } else {\\n        queue = null;\\n      }\\n    }\\n\\n    child = inst.render();\\n\\n    {\\n      if (child === undefined && inst.render._isMockFunction) {\\n        // This is probably bad practice. Consider warning here and\\n        // deprecating this convenience.\\n        child = null;\\n      }\\n    }\\n\\n    validateRenderResult(child, Component);\\n    var childContext;\\n\\n    {\\n      if (typeof inst.getChildContext === 'function') {\\n        var _childContextTypes = Component.childContextTypes;\\n\\n        if (typeof _childContextTypes === 'object') {\\n          childContext = inst.getChildContext();\\n\\n          for (var contextKey in childContext) {\\n            if (!(contextKey in _childContextTypes)) {\\n              {\\n                throw Error( (getComponentName(Component) || 'Unknown') + \\\".getChildContext(): key \\\\\\\"\\\" + contextKey + \\\"\\\\\\\" is not defined in childContextTypes.\\\" );\\n              }\\n            }\\n          }\\n        } else {\\n          {\\n            error('%s.getChildContext(): childContextTypes must be defined in order to ' + 'use getChildContext().', getComponentName(Component) || 'Unknown');\\n          }\\n        }\\n      }\\n\\n      if (childContext) {\\n        context = _assign({}, context, childContext);\\n      }\\n    }\\n  }\\n\\n  return {\\n    child: child,\\n    context: context\\n  };\\n}\\n\\nvar ReactDOMServerRenderer = /*#__PURE__*/function () {\\n  // TODO: type this more strictly:\\n  // DEV-only\\n  function ReactDOMServerRenderer(children, makeStaticMarkup, options) {\\n    var flatChildren = flattenTopLevelChildren(children);\\n    var topFrame = {\\n      type: null,\\n      // Assume all trees start in the HTML namespace (not totally true, but\\n      // this is what we did historically)\\n      domNamespace: Namespaces.html,\\n      children: flatChildren,\\n      childIndex: 0,\\n      context: emptyObject,\\n      footer: ''\\n    };\\n\\n    {\\n      topFrame.debugElementStack = [];\\n    }\\n\\n    this.threadID = allocThreadID();\\n    this.stack = [topFrame];\\n    this.exhausted = false;\\n    this.currentSelectValue = null;\\n    this.previousWasTextNode = false;\\n    this.makeStaticMarkup = makeStaticMarkup;\\n    this.suspenseDepth = 0; // Context (new API)\\n\\n    this.contextIndex = -1;\\n    this.contextStack = [];\\n    this.contextValueStack = []; // useOpaqueIdentifier ID\\n\\n    this.uniqueID = 0;\\n    this.identifierPrefix = options && options.identifierPrefix || '';\\n\\n    {\\n      this.contextProviderStack = [];\\n    }\\n  }\\n\\n  var _proto = ReactDOMServerRenderer.prototype;\\n\\n  _proto.destroy = function destroy() {\\n    if (!this.exhausted) {\\n      this.exhausted = true;\\n      this.clearProviders();\\n      freeThreadID(this.threadID);\\n    }\\n  }\\n  /**\\n   * Note: We use just two stacks regardless of how many context providers you have.\\n   * Providers are always popped in the reverse order to how they were pushed\\n   * so we always know on the way down which provider you'll encounter next on the way up.\\n   * On the way down, we push the current provider, and its context value *before*\\n   * we mutated it, onto the stacks. Therefore, on the way up, we always know which\\n   * provider needs to be \\\"restored\\\" to which value.\\n   * https://github.com/facebook/react/pull/12985#issuecomment-396301248\\n   */\\n  ;\\n\\n  _proto.pushProvider = function pushProvider(provider) {\\n    var index = ++this.contextIndex;\\n    var context = provider.type._context;\\n    var threadID = this.threadID;\\n    validateContextBounds(context, threadID);\\n    var previousValue = context[threadID]; // Remember which value to restore this context to on our way up.\\n\\n    this.contextStack[index] = context;\\n    this.contextValueStack[index] = previousValue;\\n\\n    {\\n      // Only used for push/pop mismatch warnings.\\n      this.contextProviderStack[index] = provider;\\n    } // Mutate the current value.\\n\\n\\n    context[threadID] = provider.props.value;\\n  };\\n\\n  _proto.popProvider = function popProvider(provider) {\\n    var index = this.contextIndex;\\n\\n    {\\n      if (index < 0 || provider !== this.contextProviderStack[index]) {\\n        error('Unexpected pop.');\\n      }\\n    }\\n\\n    var context = this.contextStack[index];\\n    var previousValue = this.contextValueStack[index]; // \\\"Hide\\\" these null assignments from Flow by using `any`\\n    // because conceptually they are deletions--as long as we\\n    // promise to never access values beyond `this.contextIndex`.\\n\\n    this.contextStack[index] = null;\\n    this.contextValueStack[index] = null;\\n\\n    {\\n      this.contextProviderStack[index] = null;\\n    }\\n\\n    this.contextIndex--; // Restore to the previous value we stored as we were walking down.\\n    // We've already verified that this context has been expanded to accommodate\\n    // this thread id, so we don't need to do it again.\\n\\n    context[this.threadID] = previousValue;\\n  };\\n\\n  _proto.clearProviders = function clearProviders() {\\n    // Restore any remaining providers on the stack to previous values\\n    for (var index = this.contextIndex; index >= 0; index--) {\\n      var context = this.contextStack[index];\\n      var previousValue = this.contextValueStack[index];\\n      context[this.threadID] = previousValue;\\n    }\\n  };\\n\\n  _proto.read = function read(bytes) {\\n    if (this.exhausted) {\\n      return null;\\n    }\\n\\n    var prevPartialRenderer = currentPartialRenderer;\\n    setCurrentPartialRenderer(this);\\n    var prevDispatcher = ReactCurrentDispatcher$1.current;\\n    ReactCurrentDispatcher$1.current = Dispatcher;\\n\\n    try {\\n      // Markup generated within <Suspense> ends up buffered until we know\\n      // nothing in that boundary suspended\\n      var out = [''];\\n      var suspended = false;\\n\\n      while (out[0].length < bytes) {\\n        if (this.stack.length === 0) {\\n          this.exhausted = true;\\n          freeThreadID(this.threadID);\\n          break;\\n        }\\n\\n        var frame = this.stack[this.stack.length - 1];\\n\\n        if (suspended || frame.childIndex >= frame.children.length) {\\n          var footer = frame.footer;\\n\\n          if (footer !== '') {\\n            this.previousWasTextNode = false;\\n          }\\n\\n          this.stack.pop();\\n\\n          if (frame.type === 'select') {\\n            this.currentSelectValue = null;\\n          } else if (frame.type != null && frame.type.type != null && frame.type.type.$$typeof === REACT_PROVIDER_TYPE) {\\n            var provider = frame.type;\\n            this.popProvider(provider);\\n          } else if (frame.type === REACT_SUSPENSE_TYPE) {\\n            this.suspenseDepth--;\\n            var buffered = out.pop();\\n\\n            if (suspended) {\\n              suspended = false; // If rendering was suspended at this boundary, render the fallbackFrame\\n\\n              var fallbackFrame = frame.fallbackFrame;\\n\\n              if (!fallbackFrame) {\\n                {\\n                  throw Error(true ? \\\"ReactDOMServer did not find an internal fallback frame for Suspense. This is a bug in React. Please file an issue.\\\" : formatProdErrorMessage(303));\\n                }\\n              }\\n\\n              this.stack.push(fallbackFrame);\\n              out[this.suspenseDepth] += '\\u003c!--$!--\\u003e'; // Skip flushing output since we're switching to the fallback\\n\\n              continue;\\n            } else {\\n              out[this.suspenseDepth] += buffered;\\n            }\\n          } // Flush output\\n\\n\\n          out[this.suspenseDepth] += footer;\\n          continue;\\n        }\\n\\n        var child = frame.children[frame.childIndex++];\\n        var outBuffer = '';\\n\\n        if (true) {\\n          pushCurrentDebugStack(this.stack); // We're starting work on this frame, so reset its inner stack.\\n\\n          frame.debugElementStack.length = 0;\\n        }\\n\\n        try {\\n          outBuffer += this.render(child, frame.context, frame.domNamespace);\\n        } catch (err) {\\n          if (err != null && typeof err.then === 'function') {\\n            if (enableSuspenseServerRenderer) {\\n              if (!(this.suspenseDepth > 0)) {\\n                {\\n                  throw Error(true ? \\\"A React component suspended while rendering, but no fallback UI was specified.\\\\n\\\\nAdd a <Suspense fallback=...> component higher in the tree to provide a loading indicator or placeholder to display.\\\" : formatProdErrorMessage(342));\\n                }\\n              }\\n\\n              suspended = true;\\n            } else {\\n              if (!false) {\\n                {\\n                  throw Error(true ? \\\"ReactDOMServer does not yet support Suspense.\\\" : formatProdErrorMessage(294));\\n                }\\n              }\\n            }\\n          } else {\\n            throw err;\\n          }\\n        } finally {\\n          if (true) {\\n            popCurrentDebugStack();\\n          }\\n        }\\n\\n        if (out.length <= this.suspenseDepth) {\\n          out.push('');\\n        }\\n\\n        out[this.suspenseDepth] += outBuffer;\\n      }\\n\\n      return out[0];\\n    } finally {\\n      ReactCurrentDispatcher$1.current = prevDispatcher;\\n      setCurrentPartialRenderer(prevPartialRenderer);\\n      resetHooksState();\\n    }\\n  };\\n\\n  _proto.render = function render(child, context, parentNamespace) {\\n    if (typeof child === 'string' || typeof child === 'number') {\\n      var text = '' + child;\\n\\n      if (text === '') {\\n        return '';\\n      }\\n\\n      if (this.makeStaticMarkup) {\\n        return escapeTextForBrowser(text);\\n      }\\n\\n      if (this.previousWasTextNode) {\\n        return '\\u003c!-- --\\u003e' + escapeTextForBrowser(text);\\n      }\\n\\n      this.previousWasTextNode = true;\\n      return escapeTextForBrowser(text);\\n    } else {\\n      var nextChild;\\n\\n      var _resolve = resolve(child, context, this.threadID);\\n\\n      nextChild = _resolve.child;\\n      context = _resolve.context;\\n\\n      if (nextChild === null || nextChild === false) {\\n        return '';\\n      } else if (!React.isValidElement(nextChild)) {\\n        if (nextChild != null && nextChild.$$typeof != null) {\\n          // Catch unexpected special types early.\\n          var $$typeof = nextChild.$$typeof;\\n\\n          if (!($$typeof !== REACT_PORTAL_TYPE)) {\\n            {\\n              throw Error( \\\"Portals are not currently supported by the server renderer. Render them conditionally so that they only appear on the client render.\\\" );\\n            }\\n          } // Catch-all to prevent an infinite loop if React.Children.toArray() supports some new type.\\n\\n\\n          {\\n            {\\n              throw Error( \\\"Unknown element-like object type: \\\" + $$typeof.toString() + \\\". This is likely a bug in React. Please file an issue.\\\" );\\n            }\\n          }\\n        }\\n\\n        var nextChildren = toArray(nextChild);\\n        var frame = {\\n          type: null,\\n          domNamespace: parentNamespace,\\n          children: nextChildren,\\n          childIndex: 0,\\n          context: context,\\n          footer: ''\\n        };\\n\\n        {\\n          frame.debugElementStack = [];\\n        }\\n\\n        this.stack.push(frame);\\n        return '';\\n      } // Safe because we just checked it's an element.\\n\\n\\n      var nextElement = nextChild;\\n      var elementType = nextElement.type;\\n\\n      if (typeof elementType === 'string') {\\n        return this.renderDOM(nextElement, context, parentNamespace);\\n      }\\n\\n      switch (elementType) {\\n        // TODO: LegacyHidden acts the same as a fragment. This only works\\n        // because we currently assume that every instance of LegacyHidden is\\n        // accompanied by a host component wrapper. In the hidden mode, the host\\n        // component is given a `hidden` attribute, which ensures that the\\n        // initial HTML is not visible. To support the use of LegacyHidden as a\\n        // true fragment, without an extra DOM node, we would have to hide the\\n        // initial HTML in some other way.\\n        case REACT_LEGACY_HIDDEN_TYPE:\\n        case REACT_DEBUG_TRACING_MODE_TYPE:\\n        case REACT_STRICT_MODE_TYPE:\\n        case REACT_PROFILER_TYPE:\\n        case REACT_SUSPENSE_LIST_TYPE:\\n        case REACT_FRAGMENT_TYPE:\\n          {\\n            var _nextChildren = toArray(nextChild.props.children);\\n\\n            var _frame = {\\n              type: null,\\n              domNamespace: parentNamespace,\\n              children: _nextChildren,\\n              childIndex: 0,\\n              context: context,\\n              footer: ''\\n            };\\n\\n            {\\n              _frame.debugElementStack = [];\\n            }\\n\\n            this.stack.push(_frame);\\n            return '';\\n          }\\n\\n        case REACT_SUSPENSE_TYPE:\\n          {\\n            {\\n              {\\n                {\\n                  throw Error( \\\"ReactDOMServer does not yet support Suspense.\\\" );\\n                }\\n              }\\n            }\\n          }\\n        // eslint-disable-next-line-no-fallthrough\\n\\n        case REACT_SCOPE_TYPE:\\n          {\\n\\n            {\\n              {\\n                throw Error( \\\"ReactDOMServer does not yet support scope components.\\\" );\\n              }\\n            }\\n          }\\n      }\\n\\n      if (typeof elementType === 'object' && elementType !== null) {\\n        switch (elementType.$$typeof) {\\n          case REACT_FORWARD_REF_TYPE:\\n            {\\n              var element = nextChild;\\n\\n              var _nextChildren5;\\n\\n              var componentIdentity = {};\\n              prepareToUseHooks(componentIdentity);\\n              _nextChildren5 = elementType.render(element.props, element.ref);\\n              _nextChildren5 = finishHooks(elementType.render, element.props, _nextChildren5, element.ref);\\n              _nextChildren5 = toArray(_nextChildren5);\\n              var _frame5 = {\\n                type: null,\\n                domNamespace: parentNamespace,\\n                children: _nextChildren5,\\n                childIndex: 0,\\n                context: context,\\n                footer: ''\\n              };\\n\\n              {\\n                _frame5.debugElementStack = [];\\n              }\\n\\n              this.stack.push(_frame5);\\n              return '';\\n            }\\n\\n          case REACT_MEMO_TYPE:\\n            {\\n              var _element = nextChild;\\n              var _nextChildren6 = [React.createElement(elementType.type, _assign({\\n                ref: _element.ref\\n              }, _element.props))];\\n              var _frame6 = {\\n                type: null,\\n                domNamespace: parentNamespace,\\n                children: _nextChildren6,\\n                childIndex: 0,\\n                context: context,\\n                footer: ''\\n              };\\n\\n              {\\n                _frame6.debugElementStack = [];\\n              }\\n\\n              this.stack.push(_frame6);\\n              return '';\\n            }\\n\\n          case REACT_PROVIDER_TYPE:\\n            {\\n              var provider = nextChild;\\n              var nextProps = provider.props;\\n\\n              var _nextChildren7 = toArray(nextProps.children);\\n\\n              var _frame7 = {\\n                type: provider,\\n                domNamespace: parentNamespace,\\n                children: _nextChildren7,\\n                childIndex: 0,\\n                context: context,\\n                footer: ''\\n              };\\n\\n              {\\n                _frame7.debugElementStack = [];\\n              }\\n\\n              this.pushProvider(provider);\\n              this.stack.push(_frame7);\\n              return '';\\n            }\\n\\n          case REACT_CONTEXT_TYPE:\\n            {\\n              var reactContext = nextChild.type; // The logic below for Context differs depending on PROD or DEV mode. In\\n              // DEV mode, we create a separate object for Context.Consumer that acts\\n              // like a proxy to Context. This proxy object adds unnecessary code in PROD\\n              // so we use the old behaviour (Context.Consumer references Context) to\\n              // reduce size and overhead. The separate object references context via\\n              // a property called \\\"_context\\\", which also gives us the ability to check\\n              // in DEV mode if this property exists or not and warn if it does not.\\n\\n              {\\n                if (reactContext._context === undefined) {\\n                  // This may be because it's a Context (rather than a Consumer).\\n                  // Or it may be because it's older React where they're the same thing.\\n                  // We only want to warn if we're sure it's a new React.\\n                  if (reactContext !== reactContext.Consumer) {\\n                    if (!hasWarnedAboutUsingContextAsConsumer) {\\n                      hasWarnedAboutUsingContextAsConsumer = true;\\n\\n                      error('Rendering <Context> directly is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Consumer> instead?');\\n                    }\\n                  }\\n                } else {\\n                  reactContext = reactContext._context;\\n                }\\n              }\\n\\n              var _nextProps = nextChild.props;\\n              var threadID = this.threadID;\\n              validateContextBounds(reactContext, threadID);\\n              var nextValue = reactContext[threadID];\\n\\n              var _nextChildren8 = toArray(_nextProps.children(nextValue));\\n\\n              var _frame8 = {\\n                type: nextChild,\\n                domNamespace: parentNamespace,\\n                children: _nextChildren8,\\n                childIndex: 0,\\n                context: context,\\n                footer: ''\\n              };\\n\\n              {\\n                _frame8.debugElementStack = [];\\n              }\\n\\n              this.stack.push(_frame8);\\n              return '';\\n            }\\n          // eslint-disable-next-line-no-fallthrough\\n\\n          case REACT_FUNDAMENTAL_TYPE:\\n            {\\n\\n              {\\n                {\\n                  throw Error( \\\"ReactDOMServer does not yet support the fundamental API.\\\" );\\n                }\\n              }\\n            }\\n          // eslint-disable-next-line-no-fallthrough\\n\\n          case REACT_LAZY_TYPE:\\n            {\\n              var _element2 = nextChild;\\n              var lazyComponent = nextChild.type; // Attempt to initialize lazy component regardless of whether the\\n              // suspense server-side renderer is enabled so synchronously\\n              // resolved constructors are supported.\\n\\n              var payload = lazyComponent._payload;\\n              var init = lazyComponent._init;\\n              var result = init(payload);\\n              var _nextChildren10 = [React.createElement(result, _assign({\\n                ref: _element2.ref\\n              }, _element2.props))];\\n              var _frame10 = {\\n                type: null,\\n                domNamespace: parentNamespace,\\n                children: _nextChildren10,\\n                childIndex: 0,\\n                context: context,\\n                footer: ''\\n              };\\n\\n              {\\n                _frame10.debugElementStack = [];\\n              }\\n\\n              this.stack.push(_frame10);\\n              return '';\\n            }\\n        }\\n      }\\n\\n      var info = '';\\n\\n      {\\n        var owner = nextElement._owner;\\n\\n        if (elementType === undefined || typeof elementType === 'object' && elementType !== null && Object.keys(elementType).length === 0) {\\n          info += ' You likely forgot to export your component from the file ' + \\\"it's defined in, or you might have mixed up default and \\\" + 'named imports.';\\n        }\\n\\n        var ownerName = owner ? getComponentName(owner) : null;\\n\\n        if (ownerName) {\\n          info += '\\\\n\\\\nCheck the render method of `' + ownerName + '`.';\\n        }\\n      }\\n\\n      {\\n        {\\n          throw Error( \\\"Element type is invalid: expected a string (for built-in components) or a class/function (for composite components) but got: \\\" + (elementType == null ? elementType : typeof elementType) + \\\".\\\" + info );\\n        }\\n      }\\n    }\\n  };\\n\\n  _proto.renderDOM = function renderDOM(element, context, parentNamespace) {\\n    var tag = element.type.toLowerCase();\\n    var namespace = parentNamespace;\\n\\n    if (parentNamespace === Namespaces.html) {\\n      namespace = getIntrinsicNamespace(tag);\\n    }\\n\\n    {\\n      if (namespace === Namespaces.html) {\\n        // Should this check be gated by parent namespace? Not sure we want to\\n        // allow <SVG> or <mATH>.\\n        if (tag !== element.type) {\\n          error('<%s /> is using incorrect casing. ' + 'Use PascalCase for React components, ' + 'or lowercase for HTML elements.', element.type);\\n        }\\n      }\\n    }\\n\\n    validateDangerousTag(tag);\\n    var props = element.props;\\n\\n    if (tag === 'input') {\\n      {\\n        checkControlledValueProps('input', props);\\n\\n        if (props.checked !== undefined && props.defaultChecked !== undefined && !didWarnDefaultChecked) {\\n          error('%s contains an input of type %s with both checked and defaultChecked props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the checked prop, or the defaultChecked prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components', 'A component', props.type);\\n\\n          didWarnDefaultChecked = true;\\n        }\\n\\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultInputValue) {\\n          error('%s contains an input of type %s with both value and defaultValue props. ' + 'Input elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled input ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components', 'A component', props.type);\\n\\n          didWarnDefaultInputValue = true;\\n        }\\n      }\\n\\n      props = _assign({\\n        type: undefined\\n      }, props, {\\n        defaultChecked: undefined,\\n        defaultValue: undefined,\\n        value: props.value != null ? props.value : props.defaultValue,\\n        checked: props.checked != null ? props.checked : props.defaultChecked\\n      });\\n    } else if (tag === 'textarea') {\\n      {\\n        checkControlledValueProps('textarea', props);\\n\\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultTextareaValue) {\\n          error('Textarea elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled textarea ' + 'and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components');\\n\\n          didWarnDefaultTextareaValue = true;\\n        }\\n      }\\n\\n      var initialValue = props.value;\\n\\n      if (initialValue == null) {\\n        var defaultValue = props.defaultValue; // TODO (yungsters): Remove support for children content in <textarea>.\\n\\n        var textareaChildren = props.children;\\n\\n        if (textareaChildren != null) {\\n          {\\n            error('Use the `defaultValue` or `value` props instead of setting ' + 'children on <textarea>.');\\n          }\\n\\n          if (!(defaultValue == null)) {\\n            {\\n              throw Error( \\\"If you supply `defaultValue` on a <textarea>, do not pass children.\\\" );\\n            }\\n          }\\n\\n          if (Array.isArray(textareaChildren)) {\\n            if (!(textareaChildren.length <= 1)) {\\n              {\\n                throw Error( \\\"<textarea> can only have at most one child.\\\" );\\n              }\\n            }\\n\\n            textareaChildren = textareaChildren[0];\\n          }\\n\\n          defaultValue = '' + textareaChildren;\\n        }\\n\\n        if (defaultValue == null) {\\n          defaultValue = '';\\n        }\\n\\n        initialValue = defaultValue;\\n      }\\n\\n      props = _assign({}, props, {\\n        value: undefined,\\n        children: '' + initialValue\\n      });\\n    } else if (tag === 'select') {\\n      {\\n        checkControlledValueProps('select', props);\\n\\n        for (var i = 0; i < valuePropNames.length; i++) {\\n          var propName = valuePropNames[i];\\n\\n          if (props[propName] == null) {\\n            continue;\\n          }\\n\\n          var isArray = Array.isArray(props[propName]);\\n\\n          if (props.multiple && !isArray) {\\n            error('The `%s` prop supplied to <select> must be an array if ' + '`multiple` is true.', propName);\\n          } else if (!props.multiple && isArray) {\\n            error('The `%s` prop supplied to <select> must be a scalar ' + 'value if `multiple` is false.', propName);\\n          }\\n        }\\n\\n        if (props.value !== undefined && props.defaultValue !== undefined && !didWarnDefaultSelectValue) {\\n          error('Select elements must be either controlled or uncontrolled ' + '(specify either the value prop, or the defaultValue prop, but not ' + 'both). Decide between using a controlled or uncontrolled select ' + 'element and remove one of these props. More info: ' + 'https://reactjs.org/link/controlled-components');\\n\\n          didWarnDefaultSelectValue = true;\\n        }\\n      }\\n\\n      this.currentSelectValue = props.value != null ? props.value : props.defaultValue;\\n      props = _assign({}, props, {\\n        value: undefined\\n      });\\n    } else if (tag === 'option') {\\n      var selected = null;\\n      var selectValue = this.currentSelectValue;\\n      var optionChildren = flattenOptionChildren(props.children);\\n\\n      if (selectValue != null) {\\n        var value;\\n\\n        if (props.value != null) {\\n          value = props.value + '';\\n        } else {\\n          value = optionChildren;\\n        }\\n\\n        selected = false;\\n\\n        if (Array.isArray(selectValue)) {\\n          // multiple\\n          for (var j = 0; j < selectValue.length; j++) {\\n            if ('' + selectValue[j] === value) {\\n              selected = true;\\n              break;\\n            }\\n          }\\n        } else {\\n          selected = '' + selectValue === value;\\n        }\\n\\n        props = _assign({\\n          selected: undefined,\\n          children: undefined\\n        }, props, {\\n          selected: selected,\\n          children: optionChildren\\n        });\\n      }\\n    }\\n\\n    {\\n      validatePropertiesInDevelopment(tag, props);\\n    }\\n\\n    assertValidProps(tag, props);\\n    var out = createOpenTagMarkup(element.type, tag, props, namespace, this.makeStaticMarkup, this.stack.length === 1);\\n    var footer = '';\\n\\n    if (omittedCloseTags.hasOwnProperty(tag)) {\\n      out += '/>';\\n    } else {\\n      out += '>';\\n      footer = '</' + element.type + '>';\\n    }\\n\\n    var children;\\n    var innerMarkup = getNonChildrenInnerMarkup(props);\\n\\n    if (innerMarkup != null) {\\n      children = [];\\n\\n      if (newlineEatingTags.hasOwnProperty(tag) && innerMarkup.charAt(0) === '\\\\n') {\\n        // text/html ignores the first character in these tags if it's a newline\\n        // Prefer to break application/xml over text/html (for now) by adding\\n        // a newline specifically to get eaten by the parser. (Alternately for\\n        // textareas, replacing \\\"^\\\\n\\\" with \\\"\\\\r\\\\n\\\" doesn't get eaten, and the first\\n        // \\\\r is normalized out by HTMLTextAreaElement#value.)\\n        // See: <http://www.w3.org/TR/html-polyglot/#newlines-in-textarea-and-pre>\\n        // See: <http://www.w3.org/TR/html5/syntax.html#element-restrictions>\\n        // See: <http://www.w3.org/TR/html5/syntax.html#newlines>\\n        // See: Parsing of \\\"textarea\\\" \\\"listing\\\" and \\\"pre\\\" elements\\n        //  from <http://www.w3.org/TR/html5/syntax.html#parsing-main-inbody>\\n        out += '\\\\n';\\n      }\\n\\n      out += innerMarkup;\\n    } else {\\n      children = toArray(props.children);\\n    }\\n\\n    var frame = {\\n      domNamespace: getChildNamespace(parentNamespace, element.type),\\n      type: tag,\\n      children: children,\\n      childIndex: 0,\\n      context: context,\\n      footer: footer\\n    };\\n\\n    {\\n      frame.debugElementStack = [];\\n    }\\n\\n    this.stack.push(frame);\\n    this.previousWasTextNode = false;\\n    return out;\\n  };\\n\\n  return ReactDOMServerRenderer;\\n}();\\n\\n/**\\n * Render a ReactElement to its initial HTML. This should only be used on the\\n * server.\\n * See https://reactjs.org/docs/react-dom-server.html#rendertostring\\n */\\n\\nfunction renderToString(element, options) {\\n  var renderer = new ReactDOMServerRenderer(element, false, options);\\n\\n  try {\\n    var markup = renderer.read(Infinity);\\n    return markup;\\n  } finally {\\n    renderer.destroy();\\n  }\\n}\\n/**\\n * Similar to renderToString, except this doesn't create extra DOM attributes\\n * such as data-react-id that React uses internally.\\n * See https://reactjs.org/docs/react-dom-server.html#rendertostaticmarkup\\n */\\n\\nfunction renderToStaticMarkup(element, options) {\\n  var renderer = new ReactDOMServerRenderer(element, true, options);\\n\\n  try {\\n    var markup = renderer.read(Infinity);\\n    return markup;\\n  } finally {\\n    renderer.destroy();\\n  }\\n}\\n\\nfunction renderToNodeStream() {\\n  {\\n    {\\n      throw Error( \\\"ReactDOMServer.renderToNodeStream(): The streaming API is not available in the browser. Use ReactDOMServer.renderToString() instead.\\\" );\\n    }\\n  }\\n}\\n\\nfunction renderToStaticNodeStream() {\\n  {\\n    {\\n      throw Error( \\\"ReactDOMServer.renderToStaticNodeStream(): The streaming API is not available in the browser. Use ReactDOMServer.renderToStaticMarkup() instead.\\\" );\\n    }\\n  }\\n}\\n\\nexports.renderToNodeStream = renderToNodeStream;\\nexports.renderToStaticMarkup = renderToStaticMarkup;\\nexports.renderToStaticNodeStream = renderToStaticNodeStream;\\nexports.renderToString = renderToString;\\nexports.version = ReactVersion;\\n  })();\\n}\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\"]\n}\n"]