["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/prop-types/checkPropTypes.js"],"~:js","shadow$provide[242]=function(ra,X,Ra,P){function w(Z,B,p,c,u){}w.resetWarningCache=function(){};Ra.exports=w}","~:source","shadow$provide[242] = function(global,require,module,exports) {\n/**\n * Copyright (c) 2013-present, Facebook, Inc.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n'use strict';\n\nvar printWarning = function() {};\n\nif (process.env.NODE_ENV !== 'production') {\n  var ReactPropTypesSecret = require('./lib/ReactPropTypesSecret');\n  var loggedTypeFailures = {};\n  var has = require('./lib/has');\n\n  printWarning = function(text) {\n    var message = 'Warning: ' + text;\n    if (typeof console !== 'undefined') {\n      console.error(message);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      throw new Error(message);\n    } catch (x) { /**/ }\n  };\n}\n\n/**\n * Assert that the values match with the type specs.\n * Error messages are memorized and will only be shown once.\n *\n * @param {object} typeSpecs Map of name to a ReactPropType\n * @param {object} values Runtime values that need to be type-checked\n * @param {string} location e.g. \"prop\", \"context\", \"child context\"\n * @param {string} componentName Name of the component for error messages.\n * @param {?Function} getStack Returns the component stack.\n * @private\n */\nfunction checkPropTypes(typeSpecs, values, location, componentName, getStack) {\n  if (process.env.NODE_ENV !== 'production') {\n    for (var typeSpecName in typeSpecs) {\n      if (has(typeSpecs, typeSpecName)) {\n        var error;\n        // Prop type validation may throw. In case they do, we don't want to\n        // fail the render phase where it didn't fail before. So we log it.\n        // After these have been cleaned up, we'll let them throw.\n        try {\n          // This is intentionally an invariant that gets caught. It's the same\n          // behavior as without this statement except with a better message.\n          if (typeof typeSpecs[typeSpecName] !== 'function') {\n            var err = Error(\n              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +\n              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' +\n              'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.'\n            );\n            err.name = 'Invariant Violation';\n            throw err;\n          }\n          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);\n        } catch (ex) {\n          error = ex;\n        }\n        if (error && !(error instanceof Error)) {\n          printWarning(\n            (componentName || 'React class') + ': type specification of ' +\n            location + ' `' + typeSpecName + '` is invalid; the type checker ' +\n            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +\n            'You may have forgotten to pass an argument to the type checker ' +\n            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +\n            'shape all require an argument).'\n          );\n        }\n        if (error instanceof Error && !(error.message in loggedTypeFailures)) {\n          // Only monitor this failure once because there tends to be a lot of the\n          // same error.\n          loggedTypeFailures[error.message] = true;\n\n          var stack = getStack ? getStack() : '';\n\n          printWarning(\n            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')\n          );\n        }\n      }\n    }\n  }\n}\n\n/**\n * Resets warning cache when testing.\n *\n * @private\n */\ncheckPropTypes.resetWarningCache = function() {\n  if (process.env.NODE_ENV !== 'production') {\n    loggedTypeFailures = {};\n  }\n}\n\nmodule.exports = checkPropTypes;\n\n};","~:removed-requires",["~#set",["~$module$node_modules$prop_types$lib$has","~$module$node_modules$prop_types$lib$ReactPropTypesSecret"]],"~:actual-requires",["^5",["~$shadow.js"]],"~:properties",["^5",["resetWarningCache"]],"~:compiled-at",1766065009599,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$prop_types$checkPropTypes.js\",\n\"lineCount\":1,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CA0C9DC,QAASA,EAAc,CAACC,CAAD,CAAYC,CAAZ,CAAoBC,CAApB,CAA8BC,CAA9B,CAA6CC,CAA7C,CAAuD,EAuD9EL,CAAeM,CAAAA,iBAAf,CAAmCC,QAAQ,EAAG,EAM9CT,GAAOC,CAAAA,OAAP,CAAiBC,CAvG6C;\",\n\"sources\":[\"node_modules/prop-types/checkPropTypes.js\"],\n\"sourcesContent\":[\"shadow$provide[242] = function(global,require,module,exports) {\\n/**\\n * Copyright (c) 2013-present, Facebook, Inc.\\n *\\n * This source code is licensed under the MIT license found in the\\n * LICENSE file in the root directory of this source tree.\\n */\\n\\n'use strict';\\n\\nvar printWarning = function() {};\\n\\nif (process.env.NODE_ENV !== 'production') {\\n  var ReactPropTypesSecret = require('./lib/ReactPropTypesSecret');\\n  var loggedTypeFailures = {};\\n  var has = require('./lib/has');\\n\\n  printWarning = function(text) {\\n    var message = 'Warning: ' + text;\\n    if (typeof console !== 'undefined') {\\n      console.error(message);\\n    }\\n    try {\\n      // --- Welcome to debugging React ---\\n      // This error was thrown as a convenience so that you can use this stack\\n      // to find the callsite that caused this warning to fire.\\n      throw new Error(message);\\n    } catch (x) { /**/ }\\n  };\\n}\\n\\n/**\\n * Assert that the values match with the type specs.\\n * Error messages are memorized and will only be shown once.\\n *\\n * @param {object} typeSpecs Map of name to a ReactPropType\\n * @param {object} values Runtime values that need to be type-checked\\n * @param {string} location e.g. \\\"prop\\\", \\\"context\\\", \\\"child context\\\"\\n * @param {string} componentName Name of the component for error messages.\\n * @param {?Function} getStack Returns the component stack.\\n * @private\\n */\\nfunction checkPropTypes(typeSpecs, values, location, componentName, getStack) {\\n  if (process.env.NODE_ENV !== 'production') {\\n    for (var typeSpecName in typeSpecs) {\\n      if (has(typeSpecs, typeSpecName)) {\\n        var error;\\n        // Prop type validation may throw. In case they do, we don't want to\\n        // fail the render phase where it didn't fail before. So we log it.\\n        // After these have been cleaned up, we'll let them throw.\\n        try {\\n          // This is intentionally an invariant that gets caught. It's the same\\n          // behavior as without this statement except with a better message.\\n          if (typeof typeSpecs[typeSpecName] !== 'function') {\\n            var err = Error(\\n              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +\\n              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' +\\n              'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.'\\n            );\\n            err.name = 'Invariant Violation';\\n            throw err;\\n          }\\n          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);\\n        } catch (ex) {\\n          error = ex;\\n        }\\n        if (error && !(error instanceof Error)) {\\n          printWarning(\\n            (componentName || 'React class') + ': type specification of ' +\\n            location + ' `' + typeSpecName + '` is invalid; the type checker ' +\\n            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +\\n            'You may have forgotten to pass an argument to the type checker ' +\\n            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +\\n            'shape all require an argument).'\\n          );\\n        }\\n        if (error instanceof Error && !(error.message in loggedTypeFailures)) {\\n          // Only monitor this failure once because there tends to be a lot of the\\n          // same error.\\n          loggedTypeFailures[error.message] = true;\\n\\n          var stack = getStack ? getStack() : '';\\n\\n          printWarning(\\n            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')\\n          );\\n        }\\n      }\\n    }\\n  }\\n}\\n\\n/**\\n * Resets warning cache when testing.\\n *\\n * @private\\n */\\ncheckPropTypes.resetWarningCache = function() {\\n  if (process.env.NODE_ENV !== 'production') {\\n    loggedTypeFailures = {};\\n  }\\n}\\n\\nmodule.exports = checkPropTypes;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"checkPropTypes\",\"typeSpecs\",\"values\",\"location\",\"componentName\",\"getStack\",\"resetWarningCache\",\"checkPropTypes.resetWarningCache\"]\n}\n"]