["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/pako/lib/deflate.js"],"~:js","shadow$provide[177]=function(ra,X,Ra,P){function w(x){if(!(this instanceof w))return new w(x);x=this.options=p.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:\"\"},x||{});x.raw&&0<x.windowBits?x.windowBits=-x.windowBits:x.gzip&&0<x.windowBits&&16>x.windowBits&&(x.windowBits+=16);this.err=0;this.msg=\"\";this.ended=!1;this.chunks=[];this.strm=new A;this.strm.avail_out=0;var Q=B.deflateInit2(this.strm,x.level,x.method,x.windowBits,x.memLevel,x.strategy);if(0!==Q)throw Error(u[Q]);\nx.header&&B.deflateSetHeader(this.strm,x.header);if(x.dictionary){x=\"string\"===typeof x.dictionary?c.string2buf(x.dictionary):\"[object ArrayBuffer]\"===y.call(x.dictionary)?new Uint8Array(x.dictionary):x.dictionary;Q=B.deflateSetDictionary(this.strm,x);if(0!==Q)throw Error(u[Q]);this._dict_set=!0}}function Z(x,Q){Q=new w(Q);Q.push(x,!0);if(Q.err)throw Q.msg||u[Q.err];return Q.result}var B=X(174),p=X(169),c=X(175),u=X(173),A=X(176),y=Object.prototype.toString;w.prototype.push=function(x,Q){var g=this.strm,\nh=this.options.chunkSize;if(this.ended)return!1;Q=Q===~~Q?Q:!0===Q?4:0;\"string\"===typeof x?g.input=c.string2buf(x):\"[object ArrayBuffer]\"===y.call(x)?g.input=new Uint8Array(x):g.input=x;g.next_in=0;g.avail_in=g.input.length;do{0===g.avail_out&&(g.output=new p.Buf8(h),g.next_out=0,g.avail_out=h);x=B.deflate(g,Q);if(1!==x&&0!==x)return this.onEnd(x),this.ended=!0,!1;if(0===g.avail_out||0===g.avail_in&&(4===Q||2===Q))if(\"string\"===this.options.to)this.onData(c.buf2binstring(p.shrinkBuf(g.output,g.next_out)));\nelse this.onData(p.shrinkBuf(g.output,g.next_out))}while((0<g.avail_in||0===g.avail_out)&&1!==x);if(4===Q)return x=B.deflateEnd(this.strm),this.onEnd(x),this.ended=!0,0===x;2===Q&&(this.onEnd(0),g.avail_out=0);return!0};w.prototype.onData=function(x){this.chunks.push(x)};w.prototype.onEnd=function(x){0===x&&(this.result=\"string\"===this.options.to?this.chunks.join(\"\"):p.flattenChunks(this.chunks));this.chunks=[];this.err=x;this.msg=this.strm.msg};P.Deflate=w;P.deflate=Z;P.deflateRaw=function(x,Q){Q=\nQ||{};Q.raw=!0;return Z(x,Q)};P.gzip=function(x,Q){Q=Q||{};Q.gzip=!0;return Z(x,Q)}}","~:source","shadow$provide[177] = function(global,require,module,exports) {\n'use strict';\n\n\nvar zlib_deflate = require('./zlib/deflate');\nvar utils        = require('./utils/common');\nvar strings      = require('./utils/strings');\nvar msg          = require('./zlib/messages');\nvar ZStream      = require('./zlib/zstream');\n\nvar toString = Object.prototype.toString;\n\n/* Public constants ==========================================================*/\n/* ===========================================================================*/\n\nvar Z_NO_FLUSH      = 0;\nvar Z_FINISH        = 4;\n\nvar Z_OK            = 0;\nvar Z_STREAM_END    = 1;\nvar Z_SYNC_FLUSH    = 2;\n\nvar Z_DEFAULT_COMPRESSION = -1;\n\nvar Z_DEFAULT_STRATEGY    = 0;\n\nvar Z_DEFLATED  = 8;\n\n/* ===========================================================================*/\n\n\n/**\n * class Deflate\n *\n * Generic JS-style wrapper for zlib calls. If you don't need\n * streaming behaviour - use more simple functions: [[deflate]],\n * [[deflateRaw]] and [[gzip]].\n **/\n\n/* internal\n * Deflate.chunks -> Array\n *\n * Chunks of output data, if [[Deflate#onData]] not overridden.\n **/\n\n/**\n * Deflate.result -> Uint8Array|Array\n *\n * Compressed result, generated by default [[Deflate#onData]]\n * and [[Deflate#onEnd]] handlers. Filled after you push last chunk\n * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you\n * push a chunk with explicit flush (call [[Deflate#push]] with\n * `Z_SYNC_FLUSH` param).\n **/\n\n/**\n * Deflate.err -> Number\n *\n * Error code after deflate finished. 0 (Z_OK) on success.\n * You will not need it in real life, because deflate errors\n * are possible only on wrong options or bad `onData` / `onEnd`\n * custom handlers.\n **/\n\n/**\n * Deflate.msg -> String\n *\n * Error message, if [[Deflate.err]] != 0\n **/\n\n\n/**\n * new Deflate(options)\n * - options (Object): zlib deflate options.\n *\n * Creates new deflator instance with specified params. Throws exception\n * on bad params. Supported options:\n *\n * - `level`\n * - `windowBits`\n * - `memLevel`\n * - `strategy`\n * - `dictionary`\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information on these.\n *\n * Additional options, for internal needs:\n *\n * - `chunkSize` - size of generated data chunks (16K by default)\n * - `raw` (Boolean) - do raw deflate\n * - `gzip` (Boolean) - create gzip wrapper\n * - `to` (String) - if equal to 'string', then result will be \"binary string\"\n *    (each char code [0..255])\n * - `header` (Object) - custom header for gzip\n *   - `text` (Boolean) - true if compressed data believed to be text\n *   - `time` (Number) - modification time, unix timestamp\n *   - `os` (Number) - operation system code\n *   - `extra` (Array) - array of bytes with extra data (max 65536)\n *   - `name` (String) - file name (binary string)\n *   - `comment` (String) - comment (binary string)\n *   - `hcrc` (Boolean) - true if header crc should be added\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])\n *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);\n *\n * var deflate = new pako.Deflate({ level: 3});\n *\n * deflate.push(chunk1, false);\n * deflate.push(chunk2, true);  // true -> last chunk\n *\n * if (deflate.err) { throw new Error(deflate.err); }\n *\n * console.log(deflate.result);\n * ```\n **/\nfunction Deflate(options) {\n  if (!(this instanceof Deflate)) return new Deflate(options);\n\n  this.options = utils.assign({\n    level: Z_DEFAULT_COMPRESSION,\n    method: Z_DEFLATED,\n    chunkSize: 16384,\n    windowBits: 15,\n    memLevel: 8,\n    strategy: Z_DEFAULT_STRATEGY,\n    to: ''\n  }, options || {});\n\n  var opt = this.options;\n\n  if (opt.raw && (opt.windowBits > 0)) {\n    opt.windowBits = -opt.windowBits;\n  }\n\n  else if (opt.gzip && (opt.windowBits > 0) && (opt.windowBits < 16)) {\n    opt.windowBits += 16;\n  }\n\n  this.err    = 0;      // error code, if happens (0 = Z_OK)\n  this.msg    = '';     // error message\n  this.ended  = false;  // used to avoid multiple onEnd() calls\n  this.chunks = [];     // chunks of compressed data\n\n  this.strm = new ZStream();\n  this.strm.avail_out = 0;\n\n  var status = zlib_deflate.deflateInit2(\n    this.strm,\n    opt.level,\n    opt.method,\n    opt.windowBits,\n    opt.memLevel,\n    opt.strategy\n  );\n\n  if (status !== Z_OK) {\n    throw new Error(msg[status]);\n  }\n\n  if (opt.header) {\n    zlib_deflate.deflateSetHeader(this.strm, opt.header);\n  }\n\n  if (opt.dictionary) {\n    var dict;\n    // Convert data if needed\n    if (typeof opt.dictionary === 'string') {\n      // If we need to compress text, change encoding to utf8.\n      dict = strings.string2buf(opt.dictionary);\n    } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {\n      dict = new Uint8Array(opt.dictionary);\n    } else {\n      dict = opt.dictionary;\n    }\n\n    status = zlib_deflate.deflateSetDictionary(this.strm, dict);\n\n    if (status !== Z_OK) {\n      throw new Error(msg[status]);\n    }\n\n    this._dict_set = true;\n  }\n}\n\n/**\n * Deflate#push(data[, mode]) -> Boolean\n * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be\n *   converted to utf8 byte sequence.\n * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.\n *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.\n *\n * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with\n * new compressed chunks. Returns `true` on success. The last data block must have\n * mode Z_FINISH (or `true`). That will flush internal pending buffers and call\n * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you\n * can use mode Z_SYNC_FLUSH, keeping the compression context.\n *\n * On fail call [[Deflate#onEnd]] with error code and return false.\n *\n * We strongly recommend to use `Uint8Array` on input for best speed (output\n * array format is detected automatically). Also, don't skip last param and always\n * use the same type in your code (boolean or number). That will improve JS speed.\n *\n * For regular `Array`-s make sure all elements are [0..255].\n *\n * ##### Example\n *\n * ```javascript\n * push(chunk, false); // push one of data chunks\n * ...\n * push(chunk, true);  // push last chunk\n * ```\n **/\nDeflate.prototype.push = function (data, mode) {\n  var strm = this.strm;\n  var chunkSize = this.options.chunkSize;\n  var status, _mode;\n\n  if (this.ended) { return false; }\n\n  _mode = (mode === ~~mode) ? mode : ((mode === true) ? Z_FINISH : Z_NO_FLUSH);\n\n  // Convert data if needed\n  if (typeof data === 'string') {\n    // If we need to compress text, change encoding to utf8.\n    strm.input = strings.string2buf(data);\n  } else if (toString.call(data) === '[object ArrayBuffer]') {\n    strm.input = new Uint8Array(data);\n  } else {\n    strm.input = data;\n  }\n\n  strm.next_in = 0;\n  strm.avail_in = strm.input.length;\n\n  do {\n    if (strm.avail_out === 0) {\n      strm.output = new utils.Buf8(chunkSize);\n      strm.next_out = 0;\n      strm.avail_out = chunkSize;\n    }\n    status = zlib_deflate.deflate(strm, _mode);    /* no bad return value */\n\n    if (status !== Z_STREAM_END && status !== Z_OK) {\n      this.onEnd(status);\n      this.ended = true;\n      return false;\n    }\n    if (strm.avail_out === 0 || (strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH))) {\n      if (this.options.to === 'string') {\n        this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));\n      } else {\n        this.onData(utils.shrinkBuf(strm.output, strm.next_out));\n      }\n    }\n  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END);\n\n  // Finalize on the last chunk.\n  if (_mode === Z_FINISH) {\n    status = zlib_deflate.deflateEnd(this.strm);\n    this.onEnd(status);\n    this.ended = true;\n    return status === Z_OK;\n  }\n\n  // callback interim results if Z_SYNC_FLUSH.\n  if (_mode === Z_SYNC_FLUSH) {\n    this.onEnd(Z_OK);\n    strm.avail_out = 0;\n    return true;\n  }\n\n  return true;\n};\n\n\n/**\n * Deflate#onData(chunk) -> Void\n * - chunk (Uint8Array|Array|String): output data. Type of array depends\n *   on js engine support. When string output requested, each chunk\n *   will be string.\n *\n * By default, stores data blocks in `chunks[]` property and glue\n * those in `onEnd`. Override this handler, if you need another behaviour.\n **/\nDeflate.prototype.onData = function (chunk) {\n  this.chunks.push(chunk);\n};\n\n\n/**\n * Deflate#onEnd(status) -> Void\n * - status (Number): deflate status. 0 (Z_OK) on success,\n *   other if not.\n *\n * Called once after you tell deflate that the input stream is\n * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)\n * or if an error happened. By default - join collected chunks,\n * free memory and fill `results` / `err` properties.\n **/\nDeflate.prototype.onEnd = function (status) {\n  // On success - join\n  if (status === Z_OK) {\n    if (this.options.to === 'string') {\n      this.result = this.chunks.join('');\n    } else {\n      this.result = utils.flattenChunks(this.chunks);\n    }\n  }\n  this.chunks = [];\n  this.err = status;\n  this.msg = this.strm.msg;\n};\n\n\n/**\n * deflate(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * Compress `data` with deflate algorithm and `options`.\n *\n * Supported options are:\n *\n * - level\n * - windowBits\n * - memLevel\n * - strategy\n * - dictionary\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information on these.\n *\n * Sugar (options):\n *\n * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify\n *   negative windowBits implicitly.\n * - `to` (String) - if equal to 'string', then result will be \"binary string\"\n *    (each char code [0..255])\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);\n *\n * console.log(pako.deflate(data));\n * ```\n **/\nfunction deflate(input, options) {\n  var deflator = new Deflate(options);\n\n  deflator.push(input, true);\n\n  // That will never happens, if you don't cheat with options :)\n  if (deflator.err) { throw deflator.msg || msg[deflator.err]; }\n\n  return deflator.result;\n}\n\n\n/**\n * deflateRaw(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * The same as [[deflate]], but creates raw data, without wrapper\n * (header and adler32 crc).\n **/\nfunction deflateRaw(input, options) {\n  options = options || {};\n  options.raw = true;\n  return deflate(input, options);\n}\n\n\n/**\n * gzip(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * The same as [[deflate]], but create gzip wrapper instead of\n * deflate one.\n **/\nfunction gzip(input, options) {\n  options = options || {};\n  options.gzip = true;\n  return deflate(input, options);\n}\n\n\nexports.Deflate = Deflate;\nexports.deflate = deflate;\nexports.deflateRaw = deflateRaw;\nexports.gzip = gzip;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$shadow.js","~$module$node_modules$pako$lib$utils$strings","~$module$node_modules$pako$lib$zlib$deflate","~$module$node_modules$pako$lib$utils$common","~$module$node_modules$pako$lib$zlib$messages","~$module$node_modules$pako$lib$zlib$zstream"]],"~:properties",["^5",["Deflate","chunks","output","next_out","strategy","chunkSize","memLevel","err","avail_out","msg","deflateRaw","ended","method","gzip","avail_in","strm","push","onEnd","level","onData","input","deflate","next_in","_dict_set","raw","options","to","result","windowBits"]],"~:compiled-at",1766065009562,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$pako$lib$deflate.js\",\n\"lineCount\":5,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAwH9DC,QAASA,EAAO,CAACC,CAAD,CAAU,CACxB,GAAI,EAAE,IAAF,WAAkBD,EAAlB,CAAJ,CAAgC,MAAO,KAAIA,CAAJ,CAAYC,CAAZ,CAYnCC,EAAAA,CAVJ,IAAKD,CAAAA,OAUDC,CAVWC,CAAMC,CAAAA,MAAN,CAAa,CAC1BC,MAtGwBC,CAAC,CAqGC,CAE1BC,OAnGcC,CAiGY,CAG1BC,UAAW,KAHe,CAI1BC,WAAY,EAJc,CAK1BC,SAAU,CALgB,CAM1BC,SAzGwBC,CAmGE,CAO1BC,GAAI,EAPsB,CAAb,CAQZb,CARY,EAQD,EARC,CAYXC,EAAIa,CAAAA,GAAR,EAAiC,CAAjC,CAAgBb,CAAIQ,CAAAA,UAApB,CACER,CAAIQ,CAAAA,UADN,CACmB,CAACR,CAAIQ,CAAAA,UADxB,CAISR,CAAIc,CAAAA,IAJb,EAIuC,CAJvC,CAIsBd,CAAIQ,CAAAA,UAJ1B,EAI+D,EAJ/D,CAI8CR,CAAIQ,CAAAA,UAJlD,GAKER,CAAIQ,CAAAA,UALN,EAKoB,EALpB,CAQA,KAAKO,CAAAA,GAAL,CAAc,CACd,KAAKC,CAAAA,GAAL,CAAc,EACd,KAAKC,CAAAA,KAAL,CAAc,CAAA,CACd,KAAKC,CAAAA,MAAL,CAAc,EAEd,KAAKC,CAAAA,IAAL,CAAY,IAAIC,CAChB,KAAKD,CAAAA,IAAKE,CAAAA,SAAV,CAAsB,CAEtB,KAAIC,EAASC,CAAaC,CAAAA,YAAb,CACX,IAAKL,CAAAA,IADM,CAEXnB,CAAIG,CAAAA,KAFO,CAGXH,CAAIK,CAAAA,MAHO,CAIXL,CAAIQ,CAAAA,UAJO,CAKXR,CAAIS,CAAAA,QALO,CAMXT,CAAIU,CAAAA,QANO,CASb,IA9IoBe,CA8IpB,GAAIH,CAAJ,CACE,KAAUI,MAAJ,CAAUV,CAAA,CAAIM,CAAJ,CAAV,CAAN;AAGEtB,CAAI2B,CAAAA,MAAR,EACEJ,CAAaK,CAAAA,gBAAb,CAA8B,IAAKT,CAAAA,IAAnC,CAAyCnB,CAAI2B,CAAAA,MAA7C,CAGF,IAAI3B,CAAI6B,CAAAA,UAAR,CAAoB,CAKhBC,CAAA,CAF4B,QAA9B,GAAI,MAAO9B,EAAI6B,CAAAA,UAAf,CAESE,CAAQC,CAAAA,UAAR,CAAmBhC,CAAI6B,CAAAA,UAAvB,CAFT,CAG6C,sBAAtC,GAAII,CAASC,CAAAA,IAAT,CAAclC,CAAI6B,CAAAA,UAAlB,CAAJ,CACE,IAAIM,UAAJ,CAAenC,CAAI6B,CAAAA,UAAnB,CADF,CAGE7B,CAAI6B,CAAAA,UAGbP,EAAA,CAASC,CAAaa,CAAAA,oBAAb,CAAkC,IAAKjB,CAAAA,IAAvC,CAA6CW,CAA7C,CAET,IApKkBL,CAoKlB,GAAIH,CAAJ,CACE,KAAUI,MAAJ,CAAUV,CAAA,CAAIM,CAAJ,CAAV,CAAN,CAGF,IAAKe,CAAAA,SAAL,CAAiB,CAAA,CAlBC,CAhDI,CA2O1BC,QAASA,EAAO,CAACC,CAAD,CAAQxC,CAAR,CAAiB,CAC3ByC,CAAAA,CAAW,IAAI1C,CAAJ,CAAYC,CAAZ,CAEfyC,EAASC,CAAAA,IAAT,CAAcF,CAAd,CAAqB,CAAA,CAArB,CAGA,IAAIC,CAASzB,CAAAA,GAAb,CAAoB,KAAMyB,EAASxB,CAAAA,GAAf,EAAsBA,CAAA,CAAIwB,CAASzB,CAAAA,GAAb,CAAtB,CAEpB,MAAOyB,EAASE,CAAAA,MARe,CA/VjC,IAAInB,EAAe5B,CAAA,CAAQ,GAAR,CAAnB,CACIM,EAAeN,CAAA,CAAQ,GAAR,CADnB,CAEIoC,EAAepC,CAAA,CAAQ,GAAR,CAFnB,CAGIqB,EAAerB,CAAA,CAAQ,GAAR,CAHnB,CAIIyB,EAAezB,CAAA,CAAQ,GAAR,CAJnB,CAMIsC,EAAWU,MAAOC,CAAAA,SAAUX,CAAAA,QAiNhCnC,EAAQ8C,CAAAA,SAAUH,CAAAA,IAAlB,CAAyBI,QAAS,CAACC,CAAD,CAAOC,CAAP,CAAa,CAC7C,IAAI5B,EAAO,IAAKA,CAAAA,IAAhB;AACIZ,EAAY,IAAKR,CAAAA,OAAQQ,CAAAA,SAG7B,IAAI,IAAKU,CAAAA,KAAT,CAAkB,MAAO,CAAA,CAEzB+B,EAAA,CAASD,CAAD,GAAU,CAAC,CAACA,CAAZ,CAAoBA,CAApB,CAAsC,CAAA,CAAV,GAACA,CAAD,CAlNhBE,CAkNgB,CAnNhBC,CAsNA,SAApB,GAAI,MAAOJ,EAAX,CAEE3B,CAAKoB,CAAAA,KAFP,CAEeR,CAAQC,CAAAA,UAAR,CAAmBc,CAAnB,CAFf,CAGmC,sBAA5B,GAAIb,CAASC,CAAAA,IAAT,CAAcY,CAAd,CAAJ,CACL3B,CAAKoB,CAAAA,KADA,CACQ,IAAIJ,UAAJ,CAAeW,CAAf,CADR,CAGL3B,CAAKoB,CAAAA,KAHA,CAGQO,CAGf3B,EAAKgC,CAAAA,OAAL,CAAe,CACfhC,EAAKiC,CAAAA,QAAL,CAAgBjC,CAAKoB,CAAAA,KAAMc,CAAAA,MAE3B,GAAG,CACsB,CAAvB,GAAIlC,CAAKE,CAAAA,SAAT,GACEF,CAAKmC,CAAAA,MAEL,CAFc,IAAIrD,CAAMsD,CAAAA,IAAV,CAAehD,CAAf,CAEd,CADAY,CAAKqC,CAAAA,QACL,CADgB,CAChB,CAAArC,CAAKE,CAAAA,SAAL,CAAiBd,CAHnB,CAKAe,EAAA,CAASC,CAAae,CAAAA,OAAb,CAAqBnB,CAArB,CAA2B6B,CAA3B,CAET,IAtOkBS,CAsOlB,GAAInC,CAAJ,EAvOkBG,CAuOlB,GAA+BH,CAA/B,CAGE,MAFA,KAAKoC,CAAAA,KAAL,CAAWpC,CAAX,CAEO,CADP,IAAKL,CAAAA,KACE,CADM,CAAA,CACN,CAAA,CAAA,CAET,IAAuB,CAAvB,GAAIE,CAAKE,CAAAA,SAAT,EAA+C,CAA/C,GAA6BF,CAAKiC,CAAAA,QAAlC,GA9OkBH,CA8OlB,GAAqDD,CAArD,EA1OkBW,CA0OlB,GAA2EX,CAA3E,EACE,GAAwB,QAAxB,GAAI,IAAKjD,CAAAA,OAAQa,CAAAA,EAAjB,CACE,IAAKgD,CAAAA,MAAL,CAAY7B,CAAQ8B,CAAAA,aAAR,CAAsB5D,CAAM6D,CAAAA,SAAN,CAAgB3C,CAAKmC,CAAAA,MAArB,CAA6BnC,CAAKqC,CAAAA,QAAlC,CAAtB,CAAZ,CADF;IAGE,KAAKI,CAAAA,MAAL,CAAY3D,CAAM6D,CAAAA,SAAN,CAAgB3C,CAAKmC,CAAAA,MAArB,CAA6BnC,CAAKqC,CAAAA,QAAlC,CAAZ,CAjBH,CAAH,OAoB0B,CApB1B,CAoBUrC,CAAKiC,CAAAA,QApBf,EAoBkD,CApBlD,GAoB+BjC,CAAKE,CAAAA,SApBpC,GA9NoBoC,CA8NpB,GAoBwDnC,CApBxD,CAuBA,IAxPoB2B,CAwPpB,GAAID,CAAJ,CAIE,MAHA1B,EAGO,CAHEC,CAAawC,CAAAA,UAAb,CAAwB,IAAK5C,CAAAA,IAA7B,CAGF,CAFP,IAAKuC,CAAAA,KAAL,CAAWpC,CAAX,CAEO,CADP,IAAKL,CAAAA,KACE,CADM,CAAA,CACN,CA1PWQ,CA0PX,GAAAH,CAxPWqC,EA4PpB,GAAIX,CAAJ,GACE,IAAKU,CAAAA,KAAL,CA/PkBjC,CA+PlB,CACA,CAAAN,CAAKE,CAAAA,SAAL,CAAiB,CAFnB,CAMA,OAAO,CAAA,CA3DsC,CAwE/CvB,EAAQ8C,CAAAA,SAAUgB,CAAAA,MAAlB,CAA2BI,QAAS,CAACC,CAAD,CAAQ,CAC1C,IAAK/C,CAAAA,MAAOuB,CAAAA,IAAZ,CAAiBwB,CAAjB,CAD0C,CAe5CnE,EAAQ8C,CAAAA,SAAUc,CAAAA,KAAlB,CAA0BQ,QAAS,CAAC5C,CAAD,CAAS,CAhStBG,CAkSpB,GAAIH,CAAJ,GAEI,IAAKoB,CAAAA,MAFT,CAC0B,QAAxB,GAAI,IAAK3C,CAAAA,OAAQa,CAAAA,EAAjB,CACgB,IAAKM,CAAAA,MAAOiD,CAAAA,IAAZ,CAAiB,EAAjB,CADhB,CAGgBlE,CAAMmE,CAAAA,aAAN,CAAoB,IAAKlD,CAAAA,MAAzB,CAJlB,CAOA,KAAKA,CAAAA,MAAL,CAAc,EACd,KAAKH,CAAAA,GAAL,CAAWO,CACX,KAAKN,CAAAA,GAAL,CAAW,IAAKG,CAAAA,IAAKH,CAAAA,GAXqB,CA2F5CnB,EAAQC,CAAAA,OAAR,CAAkBA,CAClBD,EAAQyC,CAAAA,OAAR,CAAkBA,CAClBzC,EAAQwE,CAAAA,UAAR,CAxBAA,QAAmB,CAAC9B,CAAD,CAAQxC,CAAR,CAAiB,CAClCA,CAAA;AAAUA,CAAV,EAAqB,EACrBA,EAAQc,CAAAA,GAAR,CAAc,CAAA,CACd,OAAOyB,EAAA,CAAQC,CAAR,CAAexC,CAAf,CAH2B,CAyBpCF,EAAQiB,CAAAA,IAAR,CAVAA,QAAa,CAACyB,CAAD,CAAQxC,CAAR,CAAiB,CAC5BA,CAAA,CAAUA,CAAV,EAAqB,EACrBA,EAAQe,CAAAA,IAAR,CAAe,CAAA,CACf,OAAOwB,EAAA,CAAQC,CAAR,CAAexC,CAAf,CAHqB,CAtYgC;\",\n\"sources\":[\"node_modules/pako/lib/deflate.js\"],\n\"sourcesContent\":[\"shadow$provide[177] = function(global,require,module,exports) {\\n'use strict';\\n\\n\\nvar zlib_deflate = require('./zlib/deflate');\\nvar utils        = require('./utils/common');\\nvar strings      = require('./utils/strings');\\nvar msg          = require('./zlib/messages');\\nvar ZStream      = require('./zlib/zstream');\\n\\nvar toString = Object.prototype.toString;\\n\\n/* Public constants ==========================================================*/\\n/* ===========================================================================*/\\n\\nvar Z_NO_FLUSH      = 0;\\nvar Z_FINISH        = 4;\\n\\nvar Z_OK            = 0;\\nvar Z_STREAM_END    = 1;\\nvar Z_SYNC_FLUSH    = 2;\\n\\nvar Z_DEFAULT_COMPRESSION = -1;\\n\\nvar Z_DEFAULT_STRATEGY    = 0;\\n\\nvar Z_DEFLATED  = 8;\\n\\n/* ===========================================================================*/\\n\\n\\n/**\\n * class Deflate\\n *\\n * Generic JS-style wrapper for zlib calls. If you don't need\\n * streaming behaviour - use more simple functions: [[deflate]],\\n * [[deflateRaw]] and [[gzip]].\\n **/\\n\\n/* internal\\n * Deflate.chunks -> Array\\n *\\n * Chunks of output data, if [[Deflate#onData]] not overridden.\\n **/\\n\\n/**\\n * Deflate.result -> Uint8Array|Array\\n *\\n * Compressed result, generated by default [[Deflate#onData]]\\n * and [[Deflate#onEnd]] handlers. Filled after you push last chunk\\n * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you\\n * push a chunk with explicit flush (call [[Deflate#push]] with\\n * `Z_SYNC_FLUSH` param).\\n **/\\n\\n/**\\n * Deflate.err -> Number\\n *\\n * Error code after deflate finished. 0 (Z_OK) on success.\\n * You will not need it in real life, because deflate errors\\n * are possible only on wrong options or bad `onData` / `onEnd`\\n * custom handlers.\\n **/\\n\\n/**\\n * Deflate.msg -> String\\n *\\n * Error message, if [[Deflate.err]] != 0\\n **/\\n\\n\\n/**\\n * new Deflate(options)\\n * - options (Object): zlib deflate options.\\n *\\n * Creates new deflator instance with specified params. Throws exception\\n * on bad params. Supported options:\\n *\\n * - `level`\\n * - `windowBits`\\n * - `memLevel`\\n * - `strategy`\\n * - `dictionary`\\n *\\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\\n * for more information on these.\\n *\\n * Additional options, for internal needs:\\n *\\n * - `chunkSize` - size of generated data chunks (16K by default)\\n * - `raw` (Boolean) - do raw deflate\\n * - `gzip` (Boolean) - create gzip wrapper\\n * - `to` (String) - if equal to 'string', then result will be \\\"binary string\\\"\\n *    (each char code [0..255])\\n * - `header` (Object) - custom header for gzip\\n *   - `text` (Boolean) - true if compressed data believed to be text\\n *   - `time` (Number) - modification time, unix timestamp\\n *   - `os` (Number) - operation system code\\n *   - `extra` (Array) - array of bytes with extra data (max 65536)\\n *   - `name` (String) - file name (binary string)\\n *   - `comment` (String) - comment (binary string)\\n *   - `hcrc` (Boolean) - true if header crc should be added\\n *\\n * ##### Example:\\n *\\n * ```javascript\\n * var pako = require('pako')\\n *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])\\n *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);\\n *\\n * var deflate = new pako.Deflate({ level: 3});\\n *\\n * deflate.push(chunk1, false);\\n * deflate.push(chunk2, true);  // true -> last chunk\\n *\\n * if (deflate.err) { throw new Error(deflate.err); }\\n *\\n * console.log(deflate.result);\\n * ```\\n **/\\nfunction Deflate(options) {\\n  if (!(this instanceof Deflate)) return new Deflate(options);\\n\\n  this.options = utils.assign({\\n    level: Z_DEFAULT_COMPRESSION,\\n    method: Z_DEFLATED,\\n    chunkSize: 16384,\\n    windowBits: 15,\\n    memLevel: 8,\\n    strategy: Z_DEFAULT_STRATEGY,\\n    to: ''\\n  }, options || {});\\n\\n  var opt = this.options;\\n\\n  if (opt.raw && (opt.windowBits > 0)) {\\n    opt.windowBits = -opt.windowBits;\\n  }\\n\\n  else if (opt.gzip && (opt.windowBits > 0) && (opt.windowBits < 16)) {\\n    opt.windowBits += 16;\\n  }\\n\\n  this.err    = 0;      // error code, if happens (0 = Z_OK)\\n  this.msg    = '';     // error message\\n  this.ended  = false;  // used to avoid multiple onEnd() calls\\n  this.chunks = [];     // chunks of compressed data\\n\\n  this.strm = new ZStream();\\n  this.strm.avail_out = 0;\\n\\n  var status = zlib_deflate.deflateInit2(\\n    this.strm,\\n    opt.level,\\n    opt.method,\\n    opt.windowBits,\\n    opt.memLevel,\\n    opt.strategy\\n  );\\n\\n  if (status !== Z_OK) {\\n    throw new Error(msg[status]);\\n  }\\n\\n  if (opt.header) {\\n    zlib_deflate.deflateSetHeader(this.strm, opt.header);\\n  }\\n\\n  if (opt.dictionary) {\\n    var dict;\\n    // Convert data if needed\\n    if (typeof opt.dictionary === 'string') {\\n      // If we need to compress text, change encoding to utf8.\\n      dict = strings.string2buf(opt.dictionary);\\n    } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {\\n      dict = new Uint8Array(opt.dictionary);\\n    } else {\\n      dict = opt.dictionary;\\n    }\\n\\n    status = zlib_deflate.deflateSetDictionary(this.strm, dict);\\n\\n    if (status !== Z_OK) {\\n      throw new Error(msg[status]);\\n    }\\n\\n    this._dict_set = true;\\n  }\\n}\\n\\n/**\\n * Deflate#push(data[, mode]) -> Boolean\\n * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be\\n *   converted to utf8 byte sequence.\\n * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.\\n *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.\\n *\\n * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with\\n * new compressed chunks. Returns `true` on success. The last data block must have\\n * mode Z_FINISH (or `true`). That will flush internal pending buffers and call\\n * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you\\n * can use mode Z_SYNC_FLUSH, keeping the compression context.\\n *\\n * On fail call [[Deflate#onEnd]] with error code and return false.\\n *\\n * We strongly recommend to use `Uint8Array` on input for best speed (output\\n * array format is detected automatically). Also, don't skip last param and always\\n * use the same type in your code (boolean or number). That will improve JS speed.\\n *\\n * For regular `Array`-s make sure all elements are [0..255].\\n *\\n * ##### Example\\n *\\n * ```javascript\\n * push(chunk, false); // push one of data chunks\\n * ...\\n * push(chunk, true);  // push last chunk\\n * ```\\n **/\\nDeflate.prototype.push = function (data, mode) {\\n  var strm = this.strm;\\n  var chunkSize = this.options.chunkSize;\\n  var status, _mode;\\n\\n  if (this.ended) { return false; }\\n\\n  _mode = (mode === ~~mode) ? mode : ((mode === true) ? Z_FINISH : Z_NO_FLUSH);\\n\\n  // Convert data if needed\\n  if (typeof data === 'string') {\\n    // If we need to compress text, change encoding to utf8.\\n    strm.input = strings.string2buf(data);\\n  } else if (toString.call(data) === '[object ArrayBuffer]') {\\n    strm.input = new Uint8Array(data);\\n  } else {\\n    strm.input = data;\\n  }\\n\\n  strm.next_in = 0;\\n  strm.avail_in = strm.input.length;\\n\\n  do {\\n    if (strm.avail_out === 0) {\\n      strm.output = new utils.Buf8(chunkSize);\\n      strm.next_out = 0;\\n      strm.avail_out = chunkSize;\\n    }\\n    status = zlib_deflate.deflate(strm, _mode);    /* no bad return value */\\n\\n    if (status !== Z_STREAM_END && status !== Z_OK) {\\n      this.onEnd(status);\\n      this.ended = true;\\n      return false;\\n    }\\n    if (strm.avail_out === 0 || (strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH))) {\\n      if (this.options.to === 'string') {\\n        this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));\\n      } else {\\n        this.onData(utils.shrinkBuf(strm.output, strm.next_out));\\n      }\\n    }\\n  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END);\\n\\n  // Finalize on the last chunk.\\n  if (_mode === Z_FINISH) {\\n    status = zlib_deflate.deflateEnd(this.strm);\\n    this.onEnd(status);\\n    this.ended = true;\\n    return status === Z_OK;\\n  }\\n\\n  // callback interim results if Z_SYNC_FLUSH.\\n  if (_mode === Z_SYNC_FLUSH) {\\n    this.onEnd(Z_OK);\\n    strm.avail_out = 0;\\n    return true;\\n  }\\n\\n  return true;\\n};\\n\\n\\n/**\\n * Deflate#onData(chunk) -> Void\\n * - chunk (Uint8Array|Array|String): output data. Type of array depends\\n *   on js engine support. When string output requested, each chunk\\n *   will be string.\\n *\\n * By default, stores data blocks in `chunks[]` property and glue\\n * those in `onEnd`. Override this handler, if you need another behaviour.\\n **/\\nDeflate.prototype.onData = function (chunk) {\\n  this.chunks.push(chunk);\\n};\\n\\n\\n/**\\n * Deflate#onEnd(status) -> Void\\n * - status (Number): deflate status. 0 (Z_OK) on success,\\n *   other if not.\\n *\\n * Called once after you tell deflate that the input stream is\\n * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)\\n * or if an error happened. By default - join collected chunks,\\n * free memory and fill `results` / `err` properties.\\n **/\\nDeflate.prototype.onEnd = function (status) {\\n  // On success - join\\n  if (status === Z_OK) {\\n    if (this.options.to === 'string') {\\n      this.result = this.chunks.join('');\\n    } else {\\n      this.result = utils.flattenChunks(this.chunks);\\n    }\\n  }\\n  this.chunks = [];\\n  this.err = status;\\n  this.msg = this.strm.msg;\\n};\\n\\n\\n/**\\n * deflate(data[, options]) -> Uint8Array|Array|String\\n * - data (Uint8Array|Array|String): input data to compress.\\n * - options (Object): zlib deflate options.\\n *\\n * Compress `data` with deflate algorithm and `options`.\\n *\\n * Supported options are:\\n *\\n * - level\\n * - windowBits\\n * - memLevel\\n * - strategy\\n * - dictionary\\n *\\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\\n * for more information on these.\\n *\\n * Sugar (options):\\n *\\n * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify\\n *   negative windowBits implicitly.\\n * - `to` (String) - if equal to 'string', then result will be \\\"binary string\\\"\\n *    (each char code [0..255])\\n *\\n * ##### Example:\\n *\\n * ```javascript\\n * var pako = require('pako')\\n *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);\\n *\\n * console.log(pako.deflate(data));\\n * ```\\n **/\\nfunction deflate(input, options) {\\n  var deflator = new Deflate(options);\\n\\n  deflator.push(input, true);\\n\\n  // That will never happens, if you don't cheat with options :)\\n  if (deflator.err) { throw deflator.msg || msg[deflator.err]; }\\n\\n  return deflator.result;\\n}\\n\\n\\n/**\\n * deflateRaw(data[, options]) -> Uint8Array|Array|String\\n * - data (Uint8Array|Array|String): input data to compress.\\n * - options (Object): zlib deflate options.\\n *\\n * The same as [[deflate]], but creates raw data, without wrapper\\n * (header and adler32 crc).\\n **/\\nfunction deflateRaw(input, options) {\\n  options = options || {};\\n  options.raw = true;\\n  return deflate(input, options);\\n}\\n\\n\\n/**\\n * gzip(data[, options]) -> Uint8Array|Array|String\\n * - data (Uint8Array|Array|String): input data to compress.\\n * - options (Object): zlib deflate options.\\n *\\n * The same as [[deflate]], but create gzip wrapper instead of\\n * deflate one.\\n **/\\nfunction gzip(input, options) {\\n  options = options || {};\\n  options.gzip = true;\\n  return deflate(input, options);\\n}\\n\\n\\nexports.Deflate = Deflate;\\nexports.deflate = deflate;\\nexports.deflateRaw = deflateRaw;\\nexports.gzip = gzip;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"Deflate\",\"options\",\"opt\",\"utils\",\"assign\",\"level\",\"Z_DEFAULT_COMPRESSION\",\"method\",\"Z_DEFLATED\",\"chunkSize\",\"windowBits\",\"memLevel\",\"strategy\",\"Z_DEFAULT_STRATEGY\",\"to\",\"raw\",\"gzip\",\"err\",\"msg\",\"ended\",\"chunks\",\"strm\",\"ZStream\",\"avail_out\",\"status\",\"zlib_deflate\",\"deflateInit2\",\"Z_OK\",\"Error\",\"header\",\"deflateSetHeader\",\"dictionary\",\"dict\",\"strings\",\"string2buf\",\"toString\",\"call\",\"Uint8Array\",\"deflateSetDictionary\",\"_dict_set\",\"deflate\",\"input\",\"deflator\",\"push\",\"result\",\"Object\",\"prototype\",\"Deflate.prototype.push\",\"data\",\"mode\",\"_mode\",\"Z_FINISH\",\"Z_NO_FLUSH\",\"next_in\",\"avail_in\",\"length\",\"output\",\"Buf8\",\"next_out\",\"Z_STREAM_END\",\"onEnd\",\"Z_SYNC_FLUSH\",\"onData\",\"buf2binstring\",\"shrinkBuf\",\"deflateEnd\",\"Deflate.prototype.onData\",\"chunk\",\"Deflate.prototype.onEnd\",\"join\",\"flattenChunks\",\"deflateRaw\"]\n}\n"]