["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/zipEntry.js"],"~:js","shadow$provide[198]=function(ra,X,Ra,P){function w(x,Q){this.options=x;this.loadOptions=Q}var Z=X(197),B=X(156),p=X(167),c=X(164),u=X(158),A=X(186),y=X(149);w.prototype={isEncrypted:function(){return 1===(this.bitFlag&1)},useUTF8:function(){return 2048===(this.bitFlag&2048)},readLocalPart:function(x){x.skip(22);this.fileNameLength=x.readInt(2);var Q=x.readInt(2);this.fileName=x.readData(this.fileNameLength);x.skip(Q);if(-1===this.compressedSize||-1===this.uncompressedSize)throw Error(\"Bug or corrupted zip : didn't get enough information from the central directory (compressedSize \\x3d\\x3d\\x3d -1 || uncompressedSize \\x3d\\x3d\\x3d -1)\");\na:{Q=this.compressionMethod;for(g in A)if(A.hasOwnProperty(g)&&A[g].magic===Q){var g=A[g];break a}g=null}if(null===g)throw Error(\"Corrupted zip : compression \"+B.pretty(this.compressionMethod)+\" unknown (inner file : \"+B.transformTo(\"string\",this.fileName)+\")\");this.decompressed=new p(this.compressedSize,this.uncompressedSize,this.crc32,g,x.readData(this.compressedSize))},readCentralPart:function(x){this.versionMadeBy=x.readInt(2);x.skip(2);this.bitFlag=x.readInt(2);this.compressionMethod=x.readString(2);\nthis.date=x.readDate();this.crc32=x.readInt(4);this.compressedSize=x.readInt(4);this.uncompressedSize=x.readInt(4);var Q=x.readInt(2);this.extraFieldsLength=x.readInt(2);this.fileCommentLength=x.readInt(2);this.diskNumberStart=x.readInt(2);this.internalFileAttributes=x.readInt(2);this.externalFileAttributes=x.readInt(4);this.localHeaderOffset=x.readInt(4);if(this.isEncrypted())throw Error(\"Encrypted zip are not supported\");x.skip(Q);this.readExtraFields(x);this.parseZIP64ExtraField(x);this.fileComment=\nx.readData(this.fileCommentLength)},processAttributes:function(){this.dosPermissions=this.unixPermissions=null;var x=this.versionMadeBy>>8;this.dir=this.externalFileAttributes&16?!0:!1;0===x&&(this.dosPermissions=this.externalFileAttributes&63);3===x&&(this.unixPermissions=this.externalFileAttributes>>16&65535);this.dir||\"/\"!==this.fileNameStr.slice(-1)||(this.dir=!0)},parseZIP64ExtraField:function(x){this.extraFields[1]&&(x=Z(this.extraFields[1].value),this.uncompressedSize===B.MAX_VALUE_32BITS&&\n(this.uncompressedSize=x.readInt(8)),this.compressedSize===B.MAX_VALUE_32BITS&&(this.compressedSize=x.readInt(8)),this.localHeaderOffset===B.MAX_VALUE_32BITS&&(this.localHeaderOffset=x.readInt(8)),this.diskNumberStart===B.MAX_VALUE_32BITS&&(this.diskNumberStart=x.readInt(4)))},readExtraFields:function(x){var Q=x.index+this.extraFieldsLength;this.extraFields||(this.extraFields={});for(;x.index+4<Q;){var g=x.readInt(2);var h=x.readInt(2);var b=x.readData(h);this.extraFields[g]={id:g,length:h,value:b}}x.setIndex(Q)},\nhandleUTF8:function(){var x=y.uint8array?\"uint8array\":\"array\";if(this.useUTF8())this.fileNameStr=u.utf8decode(this.fileName),this.fileCommentStr=u.utf8decode(this.fileComment);else{var Q=this.findExtraFieldUnicodePath();null!==Q?this.fileNameStr=Q:(Q=B.transformTo(x,this.fileName),this.fileNameStr=this.loadOptions.decodeFileName(Q));Q=this.findExtraFieldUnicodeComment();null!==Q?this.fileCommentStr=Q:(x=B.transformTo(x,this.fileComment),this.fileCommentStr=this.loadOptions.decodeFileName(x))}},findExtraFieldUnicodePath:function(){var x=\nthis.extraFields[28789];if(x){var Q=Z(x.value);return 1!==Q.readInt(1)||c(this.fileName)!==Q.readInt(4)?null:u.utf8decode(Q.readData(x.length-5))}return null},findExtraFieldUnicodeComment:function(){var x=this.extraFields[25461];if(x){var Q=Z(x.value);return 1!==Q.readInt(1)||c(this.fileComment)!==Q.readInt(4)?null:u.utf8decode(Q.readData(x.length-5))}return null}};Ra.exports=w}","~:source","shadow$provide[198] = function(global,require,module,exports) {\n'use strict';\nvar readerFor = require('./reader/readerFor');\nvar utils = require('./utils');\nvar CompressedObject = require('./compressedObject');\nvar crc32fn = require('./crc32');\nvar utf8 = require('./utf8');\nvar compressions = require('./compressions');\nvar support = require('./support');\n\nvar MADE_BY_DOS = 0x00;\nvar MADE_BY_UNIX = 0x03;\n\n/**\n * Find a compression registered in JSZip.\n * @param {string} compressionMethod the method magic to find.\n * @return {Object|null} the JSZip compression object, null if none found.\n */\nvar findCompression = function(compressionMethod) {\n    for (var method in compressions) {\n        if (!compressions.hasOwnProperty(method)) {\n            continue;\n        }\n        if (compressions[method].magic === compressionMethod) {\n            return compressions[method];\n        }\n    }\n    return null;\n};\n\n// class ZipEntry {{{\n/**\n * An entry in the zip file.\n * @constructor\n * @param {Object} options Options of the current file.\n * @param {Object} loadOptions Options for loading the stream.\n */\nfunction ZipEntry(options, loadOptions) {\n    this.options = options;\n    this.loadOptions = loadOptions;\n}\nZipEntry.prototype = {\n    /**\n     * say if the file is encrypted.\n     * @return {boolean} true if the file is encrypted, false otherwise.\n     */\n    isEncrypted: function() {\n        // bit 1 is set\n        return (this.bitFlag & 0x0001) === 0x0001;\n    },\n    /**\n     * say if the file has utf-8 filename/comment.\n     * @return {boolean} true if the filename/comment is in utf-8, false otherwise.\n     */\n    useUTF8: function() {\n        // bit 11 is set\n        return (this.bitFlag & 0x0800) === 0x0800;\n    },\n    /**\n     * Read the local part of a zip file and add the info in this object.\n     * @param {DataReader} reader the reader to use.\n     */\n    readLocalPart: function(reader) {\n        var compression, localExtraFieldsLength;\n\n        // we already know everything from the central dir !\n        // If the central dir data are false, we are doomed.\n        // On the bright side, the local part is scary  : zip64, data descriptors, both, etc.\n        // The less data we get here, the more reliable this should be.\n        // Let's skip the whole header and dash to the data !\n        reader.skip(22);\n        // in some zip created on windows, the filename stored in the central dir contains \\ instead of /.\n        // Strangely, the filename here is OK.\n        // I would love to treat these zip files as corrupted (see http://www.info-zip.org/FAQ.html#backslashes\n        // or APPNOTE#4.4.17.1, \"All slashes MUST be forward slashes '/'\") but there are a lot of bad zip generators...\n        // Search \"unzip mismatching \"local\" filename continuing with \"central\" filename version\" on\n        // the internet.\n        //\n        // I think I see the logic here : the central directory is used to display\n        // content and the local directory is used to extract the files. Mixing / and \\\n        // may be used to display \\ to windows users and use / when extracting the files.\n        // Unfortunately, this lead also to some issues : http://seclists.org/fulldisclosure/2009/Sep/394\n        this.fileNameLength = reader.readInt(2);\n        localExtraFieldsLength = reader.readInt(2); // can't be sure this will be the same as the central dir\n        // the fileName is stored as binary data, the handleUTF8 method will take care of the encoding.\n        this.fileName = reader.readData(this.fileNameLength);\n        reader.skip(localExtraFieldsLength);\n\n        if (this.compressedSize === -1 || this.uncompressedSize === -1) {\n            throw new Error(\"Bug or corrupted zip : didn't get enough information from the central directory \" + \"(compressedSize === -1 || uncompressedSize === -1)\");\n        }\n\n        compression = findCompression(this.compressionMethod);\n        if (compression === null) { // no compression found\n            throw new Error(\"Corrupted zip : compression \" + utils.pretty(this.compressionMethod) + \" unknown (inner file : \" + utils.transformTo(\"string\", this.fileName) + \")\");\n        }\n        this.decompressed = new CompressedObject(this.compressedSize, this.uncompressedSize, this.crc32, compression, reader.readData(this.compressedSize));\n    },\n\n    /**\n     * Read the central part of a zip file and add the info in this object.\n     * @param {DataReader} reader the reader to use.\n     */\n    readCentralPart: function(reader) {\n        this.versionMadeBy = reader.readInt(2);\n        reader.skip(2);\n        // this.versionNeeded = reader.readInt(2);\n        this.bitFlag = reader.readInt(2);\n        this.compressionMethod = reader.readString(2);\n        this.date = reader.readDate();\n        this.crc32 = reader.readInt(4);\n        this.compressedSize = reader.readInt(4);\n        this.uncompressedSize = reader.readInt(4);\n        var fileNameLength = reader.readInt(2);\n        this.extraFieldsLength = reader.readInt(2);\n        this.fileCommentLength = reader.readInt(2);\n        this.diskNumberStart = reader.readInt(2);\n        this.internalFileAttributes = reader.readInt(2);\n        this.externalFileAttributes = reader.readInt(4);\n        this.localHeaderOffset = reader.readInt(4);\n\n        if (this.isEncrypted()) {\n            throw new Error(\"Encrypted zip are not supported\");\n        }\n\n        // will be read in the local part, see the comments there\n        reader.skip(fileNameLength);\n        this.readExtraFields(reader);\n        this.parseZIP64ExtraField(reader);\n        this.fileComment = reader.readData(this.fileCommentLength);\n    },\n\n    /**\n     * Parse the external file attributes and get the unix/dos permissions.\n     */\n    processAttributes: function () {\n        this.unixPermissions = null;\n        this.dosPermissions = null;\n        var madeBy = this.versionMadeBy >> 8;\n\n        // Check if we have the DOS directory flag set.\n        // We look for it in the DOS and UNIX permissions\n        // but some unknown platform could set it as a compatibility flag.\n        this.dir = this.externalFileAttributes & 0x0010 ? true : false;\n\n        if(madeBy === MADE_BY_DOS) {\n            // first 6 bits (0 to 5)\n            this.dosPermissions = this.externalFileAttributes & 0x3F;\n        }\n\n        if(madeBy === MADE_BY_UNIX) {\n            this.unixPermissions = (this.externalFileAttributes >> 16) & 0xFFFF;\n            // the octal permissions are in (this.unixPermissions & 0x01FF).toString(8);\n        }\n\n        // fail safe : if the name ends with a / it probably means a folder\n        if (!this.dir && this.fileNameStr.slice(-1) === '/') {\n            this.dir = true;\n        }\n    },\n\n    /**\n     * Parse the ZIP64 extra field and merge the info in the current ZipEntry.\n     * @param {DataReader} reader the reader to use.\n     */\n    parseZIP64ExtraField: function(reader) {\n\n        if (!this.extraFields[0x0001]) {\n            return;\n        }\n\n        // should be something, preparing the extra reader\n        var extraReader = readerFor(this.extraFields[0x0001].value);\n\n        // I really hope that these 64bits integer can fit in 32 bits integer, because js\n        // won't let us have more.\n        if (this.uncompressedSize === utils.MAX_VALUE_32BITS) {\n            this.uncompressedSize = extraReader.readInt(8);\n        }\n        if (this.compressedSize === utils.MAX_VALUE_32BITS) {\n            this.compressedSize = extraReader.readInt(8);\n        }\n        if (this.localHeaderOffset === utils.MAX_VALUE_32BITS) {\n            this.localHeaderOffset = extraReader.readInt(8);\n        }\n        if (this.diskNumberStart === utils.MAX_VALUE_32BITS) {\n            this.diskNumberStart = extraReader.readInt(4);\n        }\n    },\n    /**\n     * Read the central part of a zip file and add the info in this object.\n     * @param {DataReader} reader the reader to use.\n     */\n    readExtraFields: function(reader) {\n        var end = reader.index + this.extraFieldsLength,\n            extraFieldId,\n            extraFieldLength,\n            extraFieldValue;\n\n        if (!this.extraFields) {\n            this.extraFields = {};\n        }\n\n        while (reader.index + 4 < end) {\n            extraFieldId = reader.readInt(2);\n            extraFieldLength = reader.readInt(2);\n            extraFieldValue = reader.readData(extraFieldLength);\n\n            this.extraFields[extraFieldId] = {\n                id: extraFieldId,\n                length: extraFieldLength,\n                value: extraFieldValue\n            };\n        }\n\n        reader.setIndex(end);\n    },\n    /**\n     * Apply an UTF8 transformation if needed.\n     */\n    handleUTF8: function() {\n        var decodeParamType = support.uint8array ? \"uint8array\" : \"array\";\n        if (this.useUTF8()) {\n            this.fileNameStr = utf8.utf8decode(this.fileName);\n            this.fileCommentStr = utf8.utf8decode(this.fileComment);\n        } else {\n            var upath = this.findExtraFieldUnicodePath();\n            if (upath !== null) {\n                this.fileNameStr = upath;\n            } else {\n                // ASCII text or unsupported code page\n                var fileNameByteArray =  utils.transformTo(decodeParamType, this.fileName);\n                this.fileNameStr = this.loadOptions.decodeFileName(fileNameByteArray);\n            }\n\n            var ucomment = this.findExtraFieldUnicodeComment();\n            if (ucomment !== null) {\n                this.fileCommentStr = ucomment;\n            } else {\n                // ASCII text or unsupported code page\n                var commentByteArray =  utils.transformTo(decodeParamType, this.fileComment);\n                this.fileCommentStr = this.loadOptions.decodeFileName(commentByteArray);\n            }\n        }\n    },\n\n    /**\n     * Find the unicode path declared in the extra field, if any.\n     * @return {String} the unicode path, null otherwise.\n     */\n    findExtraFieldUnicodePath: function() {\n        var upathField = this.extraFields[0x7075];\n        if (upathField) {\n            var extraReader = readerFor(upathField.value);\n\n            // wrong version\n            if (extraReader.readInt(1) !== 1) {\n                return null;\n            }\n\n            // the crc of the filename changed, this field is out of date.\n            if (crc32fn(this.fileName) !== extraReader.readInt(4)) {\n                return null;\n            }\n\n            return utf8.utf8decode(extraReader.readData(upathField.length - 5));\n        }\n        return null;\n    },\n\n    /**\n     * Find the unicode comment declared in the extra field, if any.\n     * @return {String} the unicode comment, null otherwise.\n     */\n    findExtraFieldUnicodeComment: function() {\n        var ucommentField = this.extraFields[0x6375];\n        if (ucommentField) {\n            var extraReader = readerFor(ucommentField.value);\n\n            // wrong version\n            if (extraReader.readInt(1) !== 1) {\n                return null;\n            }\n\n            // the crc of the comment changed, this field is out of date.\n            if (crc32fn(this.fileComment) !== extraReader.readInt(4)) {\n                return null;\n            }\n\n            return utf8.utf8decode(extraReader.readData(ucommentField.length - 5));\n        }\n        return null;\n    }\n};\nmodule.exports = ZipEntry;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$compressions","~$shadow.js","~$module$node_modules$jszip$lib$utf8","~$module$node_modules$jszip$lib$support","~$module$node_modules$jszip$lib$reader$readerFor","~$module$node_modules$jszip$lib$compressedObject","~$module$node_modules$jszip$lib$utils","~$module$node_modules$jszip$lib$crc32"]],"~:properties",["^5",["internalFileAttributes","extraFields","readExtraFields","prototype","isEncrypted","versionMadeBy","fileNameStr","unixPermissions","fileComment","id","parseZIP64ExtraField","findExtraFieldUnicodeComment","useUTF8","decompressed","findExtraFieldUnicodePath","fileNameLength","uncompressedSize","fileCommentStr","value","bitFlag","dosPermissions","processAttributes","handleUTF8","readLocalPart","extraFieldsLength","dir","fileName","length","crc32","loadOptions","date","diskNumberStart","localHeaderOffset","compressedSize","compressionMethod","fileCommentLength","options","readCentralPart","externalFileAttributes"]],"~:compiled-at",1766065009569,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$zipEntry.js\",\n\"lineCount\":7,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAqC9DC,QAASA,EAAQ,CAACC,CAAD,CAAUC,CAAV,CAAuB,CACpC,IAAKD,CAAAA,OAAL,CAAeA,CACf,KAAKC,CAAAA,WAAL,CAAmBA,CAFiB,CAnCxC,IAAIC,EAAYN,CAAA,CAAQ,GAAR,CAAhB,CACIO,EAAQP,CAAA,CAAQ,GAAR,CADZ,CAEIQ,EAAmBR,CAAA,CAAQ,GAAR,CAFvB,CAGIS,EAAUT,CAAA,CAAQ,GAAR,CAHd,CAIIU,EAAOV,CAAA,CAAQ,GAAR,CAJX,CAKIW,EAAeX,CAAA,CAAQ,GAAR,CALnB,CAMIY,EAAUZ,CAAA,CAAQ,GAAR,CAiCdG,EAASU,CAAAA,SAAT,CAAqB,CAKjBC,YAAaA,QAAQ,EAAG,CAEpB,MAAmC,EAAnC,IAAQ,IAAKC,CAAAA,OAAb,CAAuB,CAAvB,CAFoB,CALP,CAajBC,QAASA,QAAQ,EAAG,CAEhB,MAAmC,KAAnC,IAAQ,IAAKD,CAAAA,OAAb,CAAuB,IAAvB,CAFgB,CAbH,CAqBjBE,cAAeA,QAAQ,CAACC,CAAD,CAAS,CAQ5BA,CAAOC,CAAAA,IAAP,CAAY,EAAZ,CAYA,KAAKC,CAAAA,cAAL,CAAsBF,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACtB,KAAAC,EAAyBJ,CAAOG,CAAAA,OAAP,CAAe,CAAf,CAEzB,KAAKE,CAAAA,QAAL,CAAgBL,CAAOM,CAAAA,QAAP,CAAgB,IAAKJ,CAAAA,cAArB,CAChBF,EAAOC,CAAAA,IAAP,CAAYG,CAAZ,CAEA,IAA4B,CAAC,CAA7B,GAAI,IAAKG,CAAAA,cAAT,EAA4D,CAAC,CAA7D,GAAkC,IAAKC,CAAAA,gBAAvC,CACI,KAAUC,MAAJ,CAAU,sJAAV,CAAN;AAvEsC,CAAA,CAAA,CA0EPC,CAAAA,CAALA,IAAKA,CAAAA,iBAzEvC,KAASC,CAAT,GAAmBlB,EAAnB,CACI,GAAKA,CAAamB,CAAAA,cAAb,CAA4BD,CAA5B,CAAL,EAGIlB,CAAA,CAAakB,CAAb,CAAqBE,CAAAA,KAHzB,GAGmCH,CAHnC,CAGsD,CAClD,IAAA,EAAOjB,CAAA,CAAakB,CAAb,CAAP,OAAA,CADkD,CAI1D,CAAA,CAAO,IATuC,CA2E1C,GAAoB,IAApB,GAAIG,CAAJ,CACI,KAAUL,MAAJ,CAAU,8BAAV,CAA2CpB,CAAM0B,CAAAA,MAAN,CAAa,IAAKL,CAAAA,iBAAlB,CAA3C,CAAkF,yBAAlF,CAA8GrB,CAAM2B,CAAAA,WAAN,CAAkB,QAAlB,CAA4B,IAAKX,CAAAA,QAAjC,CAA9G,CAA2J,GAA3J,CAAN,CAEJ,IAAKY,CAAAA,YAAL,CAAoB,IAAI3B,CAAJ,CAAqB,IAAKiB,CAAAA,cAA1B,CAA0C,IAAKC,CAAAA,gBAA/C,CAAiE,IAAKU,CAAAA,KAAtE,CAA6EJ,CAA7E,CAA0Fd,CAAOM,CAAAA,QAAP,CAAgB,IAAKC,CAAAA,cAArB,CAA1F,CAlCQ,CArBf,CA8DjBY,gBAAiBA,QAAQ,CAACnB,CAAD,CAAS,CAC9B,IAAKoB,CAAAA,aAAL,CAAqBpB,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACrBH,EAAOC,CAAAA,IAAP,CAAY,CAAZ,CAEA,KAAKJ,CAAAA,OAAL,CAAeG,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACf,KAAKO,CAAAA,iBAAL,CAAyBV,CAAOqB,CAAAA,UAAP,CAAkB,CAAlB,CACzB;IAAKC,CAAAA,IAAL,CAAYtB,CAAOuB,CAAAA,QAAP,EACZ,KAAKL,CAAAA,KAAL,CAAalB,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACb,KAAKI,CAAAA,cAAL,CAAsBP,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACtB,KAAKK,CAAAA,gBAAL,CAAwBR,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACxB,KAAID,EAAiBF,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACrB,KAAKqB,CAAAA,iBAAL,CAAyBxB,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACzB,KAAKsB,CAAAA,iBAAL,CAAyBzB,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACzB,KAAKuB,CAAAA,eAAL,CAAuB1B,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACvB,KAAKwB,CAAAA,sBAAL,CAA8B3B,CAAOG,CAAAA,OAAP,CAAe,CAAf,CAC9B,KAAKyB,CAAAA,sBAAL,CAA8B5B,CAAOG,CAAAA,OAAP,CAAe,CAAf,CAC9B,KAAK0B,CAAAA,iBAAL,CAAyB7B,CAAOG,CAAAA,OAAP,CAAe,CAAf,CAEzB,IAAI,IAAKP,CAAAA,WAAL,EAAJ,CACI,KAAUa,MAAJ,CAAU,iCAAV,CAAN,CAIJT,CAAOC,CAAAA,IAAP,CAAYC,CAAZ,CACA,KAAK4B,CAAAA,eAAL,CAAqB9B,CAArB,CACA,KAAK+B,CAAAA,oBAAL,CAA0B/B,CAA1B,CACA,KAAKgC,CAAAA,WAAL;AAAmBhC,CAAOM,CAAAA,QAAP,CAAgB,IAAKmB,CAAAA,iBAArB,CA1BW,CA9DjB,CA8FjBQ,kBAAmBA,QAAS,EAAG,CAE3B,IAAKC,CAAAA,cAAL,CADA,IAAKC,CAAAA,eACL,CADuB,IAEvB,KAAIC,EAAS,IAAKhB,CAAAA,aAAdgB,EAA+B,CAKnC,KAAKC,CAAAA,GAAL,CAAW,IAAKT,CAAAA,sBAAL,CAA8B,EAA9B,CAAuC,CAAA,CAAvC,CAA8C,CAAA,CArI/CU,EAuIV,GAAGF,CAAH,GAEI,IAAKF,CAAAA,cAFT,CAE0B,IAAKN,CAAAA,sBAF/B,CAEwD,EAFxD,CAtIWW,EA2IX,GAAGH,CAAH,GACI,IAAKD,CAAAA,eADT,CAC4B,IAAKP,CAAAA,sBADjC,EAC2D,EAD3D,CACiE,KADjE,CAMK,KAAKS,CAAAA,GAAV,EAAgD,GAAhD,GAAiB,IAAKG,CAAAA,WAAYC,CAAAA,KAAjB,CAAuB,CAAC,CAAxB,CAAjB,GACI,IAAKJ,CAAAA,GADT,CACe,CAAA,CADf,CArB2B,CA9Fd,CA4HjBN,qBAAsBA,QAAQ,CAAC/B,CAAD,CAAS,CAE9B,IAAK0C,CAAAA,WAAL,CAAiB,CAAjB,CAAL,GAKIC,CAaJ,CAbkBvD,CAAA,CAAU,IAAKsD,CAAAA,WAAL,CAAiB,CAAjB,CAAyBE,CAAAA,KAAnC,CAalB,CATI,IAAKpC,CAAAA,gBAST,GAT8BnB,CAAMwD,CAAAA,gBASpC;CARI,IAAKrC,CAAAA,gBAQT,CAR4BmC,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAQ5B,EANI,IAAKI,CAAAA,cAMT,GAN4BlB,CAAMwD,CAAAA,gBAMlC,GALI,IAAKtC,CAAAA,cAKT,CAL0BoC,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAK1B,EAHI,IAAK0B,CAAAA,iBAGT,GAH+BxC,CAAMwD,CAAAA,gBAGrC,GAFI,IAAKhB,CAAAA,iBAET,CAF6Bc,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAE7B,EAAI,IAAKuB,CAAAA,eAAT,GAA6BrC,CAAMwD,CAAAA,gBAAnC,GACI,IAAKnB,CAAAA,eADT,CAC2BiB,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAD3B,CAlBA,CAFmC,CA5HtB,CAwJjB2B,gBAAiBA,QAAQ,CAAC9B,CAAD,CAAS,CAAA,IAC1B8C,EAAM9C,CAAO+C,CAAAA,KAAbD,CAAqB,IAAKtB,CAAAA,iBAKzB,KAAKkB,CAAAA,WAAV,GACI,IAAKA,CAAAA,WADT,CACuB,EADvB,CAIA,KAAA,CAAO1C,CAAO+C,CAAAA,KAAd,CAAsB,CAAtB,CAA0BD,CAA1B,CAAA,CAA+B,CAC3B,IAAAE,EAAehD,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACf,KAAA8C,EAAmBjD,CAAOG,CAAAA,OAAP,CAAe,CAAf,CACnB,KAAA+C,EAAkBlD,CAAOM,CAAAA,QAAP,CAAgB2C,CAAhB,CAElB,KAAKP,CAAAA,WAAL,CAAiBM,CAAjB,CAAA,CAAiC,CAC7BG,GAAIH,CADyB,CAE7BI,OAAQH,CAFqB,CAG7BL,MAAOM,CAHsB,CALN,CAY/BlD,CAAOqD,CAAAA,QAAP,CAAgBP,CAAhB,CAtB8B,CAxJjB;AAmLjBQ,WAAYA,QAAQ,EAAG,CACnB,IAAIC,EAAkB7D,CAAQ8D,CAAAA,UAAR,CAAqB,YAArB,CAAoC,OAC1D,IAAI,IAAK1D,CAAAA,OAAL,EAAJ,CACI,IAAK0C,CAAAA,WACL,CADmBhD,CAAKiE,CAAAA,UAAL,CAAgB,IAAKpD,CAAAA,QAArB,CACnB,CAAA,IAAKqD,CAAAA,cAAL,CAAsBlE,CAAKiE,CAAAA,UAAL,CAAgB,IAAKzB,CAAAA,WAArB,CAF1B,KAGO,CACH,IAAI2B,EAAQ,IAAKC,CAAAA,yBAAL,EACE,KAAd,GAAID,CAAJ,CACI,IAAKnB,CAAAA,WADT,CACuBmB,CADvB,EAIQE,CACJ,CADyBxE,CAAM2B,CAAAA,WAAN,CAAkBuC,CAAlB,CAAmC,IAAKlD,CAAAA,QAAxC,CACzB,CAAA,IAAKmC,CAAAA,WAAL,CAAmB,IAAKrD,CAAAA,WAAY2E,CAAAA,cAAjB,CAAgCD,CAAhC,CALvB,CAQIE,EAAAA,CAAW,IAAKC,CAAAA,4BAAL,EACE,KAAjB,GAAID,CAAJ,CACI,IAAKL,CAAAA,cADT,CAC0BK,CAD1B,EAIQE,CACJ,CADwB5E,CAAM2B,CAAAA,WAAN,CAAkBuC,CAAlB,CAAmC,IAAKvB,CAAAA,WAAxC,CACxB,CAAA,IAAK0B,CAAAA,cAAL,CAAsB,IAAKvE,CAAAA,WAAY2E,CAAAA,cAAjB,CAAgCG,CAAhC,CAL1B,CAXG,CALY,CAnLN,CAiNjBL,0BAA2BA,QAAQ,EAAG,CAClC,IAAIM;AAAa,IAAKxB,CAAAA,WAAL,CAAiB,KAAjB,CACjB,IAAIwB,CAAJ,CAAgB,CACZ,IAAIvB,EAAcvD,CAAA,CAAU8E,CAAWtB,CAAAA,KAArB,CAQlB,OAL+B,EAK/B,GALID,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAKJ,EAAIZ,CAAA,CAAQ,IAAKc,CAAAA,QAAb,CAAJ,GAA+BsC,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAA/B,CACW,IADX,CAIOX,CAAKiE,CAAAA,UAAL,CAAgBd,CAAYrC,CAAAA,QAAZ,CAAqB4D,CAAWd,CAAAA,MAAhC,CAAyC,CAAzC,CAAhB,CAbK,CAehB,MAAO,KAjB2B,CAjNrB,CAyOjBY,6BAA8BA,QAAQ,EAAG,CACrC,IAAIG,EAAgB,IAAKzB,CAAAA,WAAL,CAAiB,KAAjB,CACpB,IAAIyB,CAAJ,CAAmB,CACf,IAAIxB,EAAcvD,CAAA,CAAU+E,CAAcvB,CAAAA,KAAxB,CAQlB,OAL+B,EAK/B,GALID,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAKJ,EAAIZ,CAAA,CAAQ,IAAKyC,CAAAA,WAAb,CAAJ,GAAkCW,CAAYxC,CAAAA,OAAZ,CAAoB,CAApB,CAAlC,CACW,IADX,CAIOX,CAAKiE,CAAAA,UAAL,CAAgBd,CAAYrC,CAAAA,QAAZ,CAAqB6D,CAAcf,CAAAA,MAAnC,CAA4C,CAA5C,CAAhB,CAbQ,CAenB,MAAO,KAjB8B,CAzOxB,CA6PrBrE,GAAOC,CAAAA,OAAP,CAAiBC,CAtS6C;\",\n\"sources\":[\"node_modules/jszip/lib/zipEntry.js\"],\n\"sourcesContent\":[\"shadow$provide[198] = function(global,require,module,exports) {\\n'use strict';\\nvar readerFor = require('./reader/readerFor');\\nvar utils = require('./utils');\\nvar CompressedObject = require('./compressedObject');\\nvar crc32fn = require('./crc32');\\nvar utf8 = require('./utf8');\\nvar compressions = require('./compressions');\\nvar support = require('./support');\\n\\nvar MADE_BY_DOS = 0x00;\\nvar MADE_BY_UNIX = 0x03;\\n\\n/**\\n * Find a compression registered in JSZip.\\n * @param {string} compressionMethod the method magic to find.\\n * @return {Object|null} the JSZip compression object, null if none found.\\n */\\nvar findCompression = function(compressionMethod) {\\n    for (var method in compressions) {\\n        if (!compressions.hasOwnProperty(method)) {\\n            continue;\\n        }\\n        if (compressions[method].magic === compressionMethod) {\\n            return compressions[method];\\n        }\\n    }\\n    return null;\\n};\\n\\n// class ZipEntry {{{\\n/**\\n * An entry in the zip file.\\n * @constructor\\n * @param {Object} options Options of the current file.\\n * @param {Object} loadOptions Options for loading the stream.\\n */\\nfunction ZipEntry(options, loadOptions) {\\n    this.options = options;\\n    this.loadOptions = loadOptions;\\n}\\nZipEntry.prototype = {\\n    /**\\n     * say if the file is encrypted.\\n     * @return {boolean} true if the file is encrypted, false otherwise.\\n     */\\n    isEncrypted: function() {\\n        // bit 1 is set\\n        return (this.bitFlag & 0x0001) === 0x0001;\\n    },\\n    /**\\n     * say if the file has utf-8 filename/comment.\\n     * @return {boolean} true if the filename/comment is in utf-8, false otherwise.\\n     */\\n    useUTF8: function() {\\n        // bit 11 is set\\n        return (this.bitFlag & 0x0800) === 0x0800;\\n    },\\n    /**\\n     * Read the local part of a zip file and add the info in this object.\\n     * @param {DataReader} reader the reader to use.\\n     */\\n    readLocalPart: function(reader) {\\n        var compression, localExtraFieldsLength;\\n\\n        // we already know everything from the central dir !\\n        // If the central dir data are false, we are doomed.\\n        // On the bright side, the local part is scary  : zip64, data descriptors, both, etc.\\n        // The less data we get here, the more reliable this should be.\\n        // Let's skip the whole header and dash to the data !\\n        reader.skip(22);\\n        // in some zip created on windows, the filename stored in the central dir contains \\\\ instead of /.\\n        // Strangely, the filename here is OK.\\n        // I would love to treat these zip files as corrupted (see http://www.info-zip.org/FAQ.html#backslashes\\n        // or APPNOTE#4.4.17.1, \\\"All slashes MUST be forward slashes '/'\\\") but there are a lot of bad zip generators...\\n        // Search \\\"unzip mismatching \\\"local\\\" filename continuing with \\\"central\\\" filename version\\\" on\\n        // the internet.\\n        //\\n        // I think I see the logic here : the central directory is used to display\\n        // content and the local directory is used to extract the files. Mixing / and \\\\\\n        // may be used to display \\\\ to windows users and use / when extracting the files.\\n        // Unfortunately, this lead also to some issues : http://seclists.org/fulldisclosure/2009/Sep/394\\n        this.fileNameLength = reader.readInt(2);\\n        localExtraFieldsLength = reader.readInt(2); // can't be sure this will be the same as the central dir\\n        // the fileName is stored as binary data, the handleUTF8 method will take care of the encoding.\\n        this.fileName = reader.readData(this.fileNameLength);\\n        reader.skip(localExtraFieldsLength);\\n\\n        if (this.compressedSize === -1 || this.uncompressedSize === -1) {\\n            throw new Error(\\\"Bug or corrupted zip : didn't get enough information from the central directory \\\" + \\\"(compressedSize === -1 || uncompressedSize === -1)\\\");\\n        }\\n\\n        compression = findCompression(this.compressionMethod);\\n        if (compression === null) { // no compression found\\n            throw new Error(\\\"Corrupted zip : compression \\\" + utils.pretty(this.compressionMethod) + \\\" unknown (inner file : \\\" + utils.transformTo(\\\"string\\\", this.fileName) + \\\")\\\");\\n        }\\n        this.decompressed = new CompressedObject(this.compressedSize, this.uncompressedSize, this.crc32, compression, reader.readData(this.compressedSize));\\n    },\\n\\n    /**\\n     * Read the central part of a zip file and add the info in this object.\\n     * @param {DataReader} reader the reader to use.\\n     */\\n    readCentralPart: function(reader) {\\n        this.versionMadeBy = reader.readInt(2);\\n        reader.skip(2);\\n        // this.versionNeeded = reader.readInt(2);\\n        this.bitFlag = reader.readInt(2);\\n        this.compressionMethod = reader.readString(2);\\n        this.date = reader.readDate();\\n        this.crc32 = reader.readInt(4);\\n        this.compressedSize = reader.readInt(4);\\n        this.uncompressedSize = reader.readInt(4);\\n        var fileNameLength = reader.readInt(2);\\n        this.extraFieldsLength = reader.readInt(2);\\n        this.fileCommentLength = reader.readInt(2);\\n        this.diskNumberStart = reader.readInt(2);\\n        this.internalFileAttributes = reader.readInt(2);\\n        this.externalFileAttributes = reader.readInt(4);\\n        this.localHeaderOffset = reader.readInt(4);\\n\\n        if (this.isEncrypted()) {\\n            throw new Error(\\\"Encrypted zip are not supported\\\");\\n        }\\n\\n        // will be read in the local part, see the comments there\\n        reader.skip(fileNameLength);\\n        this.readExtraFields(reader);\\n        this.parseZIP64ExtraField(reader);\\n        this.fileComment = reader.readData(this.fileCommentLength);\\n    },\\n\\n    /**\\n     * Parse the external file attributes and get the unix/dos permissions.\\n     */\\n    processAttributes: function () {\\n        this.unixPermissions = null;\\n        this.dosPermissions = null;\\n        var madeBy = this.versionMadeBy >> 8;\\n\\n        // Check if we have the DOS directory flag set.\\n        // We look for it in the DOS and UNIX permissions\\n        // but some unknown platform could set it as a compatibility flag.\\n        this.dir = this.externalFileAttributes & 0x0010 ? true : false;\\n\\n        if(madeBy === MADE_BY_DOS) {\\n            // first 6 bits (0 to 5)\\n            this.dosPermissions = this.externalFileAttributes & 0x3F;\\n        }\\n\\n        if(madeBy === MADE_BY_UNIX) {\\n            this.unixPermissions = (this.externalFileAttributes >> 16) & 0xFFFF;\\n            // the octal permissions are in (this.unixPermissions & 0x01FF).toString(8);\\n        }\\n\\n        // fail safe : if the name ends with a / it probably means a folder\\n        if (!this.dir && this.fileNameStr.slice(-1) === '/') {\\n            this.dir = true;\\n        }\\n    },\\n\\n    /**\\n     * Parse the ZIP64 extra field and merge the info in the current ZipEntry.\\n     * @param {DataReader} reader the reader to use.\\n     */\\n    parseZIP64ExtraField: function(reader) {\\n\\n        if (!this.extraFields[0x0001]) {\\n            return;\\n        }\\n\\n        // should be something, preparing the extra reader\\n        var extraReader = readerFor(this.extraFields[0x0001].value);\\n\\n        // I really hope that these 64bits integer can fit in 32 bits integer, because js\\n        // won't let us have more.\\n        if (this.uncompressedSize === utils.MAX_VALUE_32BITS) {\\n            this.uncompressedSize = extraReader.readInt(8);\\n        }\\n        if (this.compressedSize === utils.MAX_VALUE_32BITS) {\\n            this.compressedSize = extraReader.readInt(8);\\n        }\\n        if (this.localHeaderOffset === utils.MAX_VALUE_32BITS) {\\n            this.localHeaderOffset = extraReader.readInt(8);\\n        }\\n        if (this.diskNumberStart === utils.MAX_VALUE_32BITS) {\\n            this.diskNumberStart = extraReader.readInt(4);\\n        }\\n    },\\n    /**\\n     * Read the central part of a zip file and add the info in this object.\\n     * @param {DataReader} reader the reader to use.\\n     */\\n    readExtraFields: function(reader) {\\n        var end = reader.index + this.extraFieldsLength,\\n            extraFieldId,\\n            extraFieldLength,\\n            extraFieldValue;\\n\\n        if (!this.extraFields) {\\n            this.extraFields = {};\\n        }\\n\\n        while (reader.index + 4 < end) {\\n            extraFieldId = reader.readInt(2);\\n            extraFieldLength = reader.readInt(2);\\n            extraFieldValue = reader.readData(extraFieldLength);\\n\\n            this.extraFields[extraFieldId] = {\\n                id: extraFieldId,\\n                length: extraFieldLength,\\n                value: extraFieldValue\\n            };\\n        }\\n\\n        reader.setIndex(end);\\n    },\\n    /**\\n     * Apply an UTF8 transformation if needed.\\n     */\\n    handleUTF8: function() {\\n        var decodeParamType = support.uint8array ? \\\"uint8array\\\" : \\\"array\\\";\\n        if (this.useUTF8()) {\\n            this.fileNameStr = utf8.utf8decode(this.fileName);\\n            this.fileCommentStr = utf8.utf8decode(this.fileComment);\\n        } else {\\n            var upath = this.findExtraFieldUnicodePath();\\n            if (upath !== null) {\\n                this.fileNameStr = upath;\\n            } else {\\n                // ASCII text or unsupported code page\\n                var fileNameByteArray =  utils.transformTo(decodeParamType, this.fileName);\\n                this.fileNameStr = this.loadOptions.decodeFileName(fileNameByteArray);\\n            }\\n\\n            var ucomment = this.findExtraFieldUnicodeComment();\\n            if (ucomment !== null) {\\n                this.fileCommentStr = ucomment;\\n            } else {\\n                // ASCII text or unsupported code page\\n                var commentByteArray =  utils.transformTo(decodeParamType, this.fileComment);\\n                this.fileCommentStr = this.loadOptions.decodeFileName(commentByteArray);\\n            }\\n        }\\n    },\\n\\n    /**\\n     * Find the unicode path declared in the extra field, if any.\\n     * @return {String} the unicode path, null otherwise.\\n     */\\n    findExtraFieldUnicodePath: function() {\\n        var upathField = this.extraFields[0x7075];\\n        if (upathField) {\\n            var extraReader = readerFor(upathField.value);\\n\\n            // wrong version\\n            if (extraReader.readInt(1) !== 1) {\\n                return null;\\n            }\\n\\n            // the crc of the filename changed, this field is out of date.\\n            if (crc32fn(this.fileName) !== extraReader.readInt(4)) {\\n                return null;\\n            }\\n\\n            return utf8.utf8decode(extraReader.readData(upathField.length - 5));\\n        }\\n        return null;\\n    },\\n\\n    /**\\n     * Find the unicode comment declared in the extra field, if any.\\n     * @return {String} the unicode comment, null otherwise.\\n     */\\n    findExtraFieldUnicodeComment: function() {\\n        var ucommentField = this.extraFields[0x6375];\\n        if (ucommentField) {\\n            var extraReader = readerFor(ucommentField.value);\\n\\n            // wrong version\\n            if (extraReader.readInt(1) !== 1) {\\n                return null;\\n            }\\n\\n            // the crc of the comment changed, this field is out of date.\\n            if (crc32fn(this.fileComment) !== extraReader.readInt(4)) {\\n                return null;\\n            }\\n\\n            return utf8.utf8decode(extraReader.readData(ucommentField.length - 5));\\n        }\\n        return null;\\n    }\\n};\\nmodule.exports = ZipEntry;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"ZipEntry\",\"options\",\"loadOptions\",\"readerFor\",\"utils\",\"CompressedObject\",\"crc32fn\",\"utf8\",\"compressions\",\"support\",\"prototype\",\"isEncrypted\",\"bitFlag\",\"useUTF8\",\"readLocalPart\",\"reader\",\"skip\",\"fileNameLength\",\"readInt\",\"localExtraFieldsLength\",\"fileName\",\"readData\",\"compressedSize\",\"uncompressedSize\",\"Error\",\"compressionMethod\",\"method\",\"hasOwnProperty\",\"magic\",\"compression\",\"pretty\",\"transformTo\",\"decompressed\",\"crc32\",\"readCentralPart\",\"versionMadeBy\",\"readString\",\"date\",\"readDate\",\"extraFieldsLength\",\"fileCommentLength\",\"diskNumberStart\",\"internalFileAttributes\",\"externalFileAttributes\",\"localHeaderOffset\",\"readExtraFields\",\"parseZIP64ExtraField\",\"fileComment\",\"processAttributes\",\"dosPermissions\",\"unixPermissions\",\"madeBy\",\"dir\",\"MADE_BY_DOS\",\"MADE_BY_UNIX\",\"fileNameStr\",\"slice\",\"extraFields\",\"extraReader\",\"value\",\"MAX_VALUE_32BITS\",\"end\",\"index\",\"extraFieldId\",\"extraFieldLength\",\"extraFieldValue\",\"id\",\"length\",\"setIndex\",\"handleUTF8\",\"decodeParamType\",\"uint8array\",\"utf8decode\",\"fileCommentStr\",\"upath\",\"findExtraFieldUnicodePath\",\"fileNameByteArray\",\"decodeFileName\",\"ucomment\",\"findExtraFieldUnicodeComment\",\"commentByteArray\",\"upathField\",\"ucommentField\"]\n}\n"]