["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/zipEntries.js"],"~:js","shadow$provide[199]=function(ra,X,Ra,P){function w(A){this.files=[];this.loadOptions=A}var Z=X(197),B=X(156),p=X(187),c=X(198);X(158);var u=X(149);w.prototype={checkSignature:function(A){if(!this.reader.readAndCheckSignature(A)){this.reader.index-=4;var y=this.reader.readString(4);throw Error(\"Corrupted zip or bug: unexpected signature (\"+B.pretty(y)+\", expected \"+B.pretty(A)+\")\");}},isSignature:function(A,y){var x=this.reader.index;this.reader.setIndex(A);A=this.reader.readString(4)===y;this.reader.setIndex(x);\nreturn A},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2);this.diskWithCentralDirStart=this.reader.readInt(2);this.centralDirRecordsOnThisDisk=this.reader.readInt(2);this.centralDirRecords=this.reader.readInt(2);this.centralDirSize=this.reader.readInt(4);this.centralDirOffset=this.reader.readInt(4);this.zipCommentLength=this.reader.readInt(2);var A=this.reader.readData(this.zipCommentLength);A=B.transformTo(u.uint8array?\"uint8array\":\"array\",A);this.zipComment=this.loadOptions.decodeFileName(A)},\nreadBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8);this.reader.skip(4);this.diskNumber=this.reader.readInt(4);this.diskWithCentralDirStart=this.reader.readInt(4);this.centralDirRecordsOnThisDisk=this.reader.readInt(8);this.centralDirRecords=this.reader.readInt(8);this.centralDirSize=this.reader.readInt(8);this.centralDirOffset=this.reader.readInt(8);this.zip64ExtensibleData={};for(var A=this.zip64EndOfCentralSize-44,y,x,Q;0<A;)y=this.reader.readInt(2),x=this.reader.readInt(4),\nQ=this.reader.readData(x),this.zip64ExtensibleData[y]={id:y,length:x,value:Q}},readBlockZip64EndOfCentralLocator:function(){this.diskWithZip64CentralDirStart=this.reader.readInt(4);this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8);this.disksCount=this.reader.readInt(4);if(1<this.disksCount)throw Error(\"Multi-volumes zip are not supported\");},readLocalFiles:function(){var A;for(A=0;A<this.files.length;A++){var y=this.files[A];this.reader.setIndex(y.localHeaderOffset);this.checkSignature(p.LOCAL_FILE_HEADER);\ny.readLocalPart(this.reader);y.handleUTF8();y.processAttributes()}},readCentralDir:function(){for(this.reader.setIndex(this.centralDirOffset);this.reader.readAndCheckSignature(p.CENTRAL_FILE_HEADER);){var A=new c({zip64:this.zip64},this.loadOptions);A.readCentralPart(this.reader);this.files.push(A)}if(this.centralDirRecords!==this.files.length&&0!==this.centralDirRecords&&0===this.files.length)throw Error(\"Corrupted zip or bug: expected \"+this.centralDirRecords+\" records in central dir, got \"+this.files.length);\n},readEndOfCentral:function(){var A=this.reader.lastIndexOfSignature(p.CENTRAL_DIRECTORY_END);if(0>A){if(this.isSignature(0,p.LOCAL_FILE_HEADER))throw Error(\"Corrupted zip: can't find end of central directory\");throw Error(\"Can't find end of central directory : is this a zip file ? If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html\");}this.reader.setIndex(A);var y=A;this.checkSignature(p.CENTRAL_DIRECTORY_END);this.readBlockEndOfCentral();if(this.diskNumber===B.MAX_VALUE_16BITS||\nthis.diskWithCentralDirStart===B.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===B.MAX_VALUE_16BITS||this.centralDirRecords===B.MAX_VALUE_16BITS||this.centralDirSize===B.MAX_VALUE_32BITS||this.centralDirOffset===B.MAX_VALUE_32BITS){this.zip64=!0;A=this.reader.lastIndexOfSignature(p.ZIP64_CENTRAL_DIRECTORY_LOCATOR);if(0>A)throw Error(\"Corrupted zip: can't find the ZIP64 end of central directory locator\");this.reader.setIndex(A);this.checkSignature(p.ZIP64_CENTRAL_DIRECTORY_LOCATOR);this.readBlockZip64EndOfCentralLocator();\nif(!this.isSignature(this.relativeOffsetEndOfZip64CentralDir,p.ZIP64_CENTRAL_DIRECTORY_END)&&(this.relativeOffsetEndOfZip64CentralDir=this.reader.lastIndexOfSignature(p.ZIP64_CENTRAL_DIRECTORY_END),0>this.relativeOffsetEndOfZip64CentralDir))throw Error(\"Corrupted zip: can't find the ZIP64 end of central directory\");this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);this.checkSignature(p.ZIP64_CENTRAL_DIRECTORY_END);this.readBlockZip64EndOfCentral()}A=this.centralDirOffset+this.centralDirSize;\nthis.zip64&&(A=A+20+(12+this.zip64EndOfCentralSize));A=y-A;if(0<A)this.isSignature(y,p.CENTRAL_FILE_HEADER)||(this.reader.zero=A);else if(0>A)throw Error(\"Corrupted zip: missing \"+Math.abs(A)+\" bytes.\");},prepareReader:function(A){this.reader=Z(A)},load:function(A){this.prepareReader(A);this.readEndOfCentral();this.readCentralDir();this.readLocalFiles()}};Ra.exports=w}","~:source","shadow$provide[199] = function(global,require,module,exports) {\n'use strict';\nvar readerFor = require('./reader/readerFor');\nvar utils = require('./utils');\nvar sig = require('./signature');\nvar ZipEntry = require('./zipEntry');\nvar utf8 = require('./utf8');\nvar support = require('./support');\n//  class ZipEntries {{{\n/**\n * All the entries in the zip file.\n * @constructor\n * @param {Object} loadOptions Options for loading the stream.\n */\nfunction ZipEntries(loadOptions) {\n    this.files = [];\n    this.loadOptions = loadOptions;\n}\nZipEntries.prototype = {\n    /**\n     * Check that the reader is on the specified signature.\n     * @param {string} expectedSignature the expected signature.\n     * @throws {Error} if it is an other signature.\n     */\n    checkSignature: function(expectedSignature) {\n        if (!this.reader.readAndCheckSignature(expectedSignature)) {\n            this.reader.index -= 4;\n            var signature = this.reader.readString(4);\n            throw new Error(\"Corrupted zip or bug: unexpected signature \" + \"(\" + utils.pretty(signature) + \", expected \" + utils.pretty(expectedSignature) + \")\");\n        }\n    },\n    /**\n     * Check if the given signature is at the given index.\n     * @param {number} askedIndex the index to check.\n     * @param {string} expectedSignature the signature to expect.\n     * @return {boolean} true if the signature is here, false otherwise.\n     */\n    isSignature: function(askedIndex, expectedSignature) {\n        var currentIndex = this.reader.index;\n        this.reader.setIndex(askedIndex);\n        var signature = this.reader.readString(4);\n        var result = signature === expectedSignature;\n        this.reader.setIndex(currentIndex);\n        return result;\n    },\n    /**\n     * Read the end of the central directory.\n     */\n    readBlockEndOfCentral: function() {\n        this.diskNumber = this.reader.readInt(2);\n        this.diskWithCentralDirStart = this.reader.readInt(2);\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(2);\n        this.centralDirRecords = this.reader.readInt(2);\n        this.centralDirSize = this.reader.readInt(4);\n        this.centralDirOffset = this.reader.readInt(4);\n\n        this.zipCommentLength = this.reader.readInt(2);\n        // warning : the encoding depends of the system locale\n        // On a linux machine with LANG=en_US.utf8, this field is utf8 encoded.\n        // On a windows machine, this field is encoded with the localized windows code page.\n        var zipComment = this.reader.readData(this.zipCommentLength);\n        var decodeParamType = support.uint8array ? \"uint8array\" : \"array\";\n        // To get consistent behavior with the generation part, we will assume that\n        // this is utf8 encoded unless specified otherwise.\n        var decodeContent = utils.transformTo(decodeParamType, zipComment);\n        this.zipComment = this.loadOptions.decodeFileName(decodeContent);\n    },\n    /**\n     * Read the end of the Zip 64 central directory.\n     * Not merged with the method readEndOfCentral :\n     * The end of central can coexist with its Zip64 brother,\n     * I don't want to read the wrong number of bytes !\n     */\n    readBlockZip64EndOfCentral: function() {\n        this.zip64EndOfCentralSize = this.reader.readInt(8);\n        this.reader.skip(4);\n        // this.versionMadeBy = this.reader.readString(2);\n        // this.versionNeeded = this.reader.readInt(2);\n        this.diskNumber = this.reader.readInt(4);\n        this.diskWithCentralDirStart = this.reader.readInt(4);\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(8);\n        this.centralDirRecords = this.reader.readInt(8);\n        this.centralDirSize = this.reader.readInt(8);\n        this.centralDirOffset = this.reader.readInt(8);\n\n        this.zip64ExtensibleData = {};\n        var extraDataSize = this.zip64EndOfCentralSize - 44,\n            index = 0,\n            extraFieldId,\n            extraFieldLength,\n            extraFieldValue;\n        while (index < extraDataSize) {\n            extraFieldId = this.reader.readInt(2);\n            extraFieldLength = this.reader.readInt(4);\n            extraFieldValue = this.reader.readData(extraFieldLength);\n            this.zip64ExtensibleData[extraFieldId] = {\n                id: extraFieldId,\n                length: extraFieldLength,\n                value: extraFieldValue\n            };\n        }\n    },\n    /**\n     * Read the end of the Zip 64 central directory locator.\n     */\n    readBlockZip64EndOfCentralLocator: function() {\n        this.diskWithZip64CentralDirStart = this.reader.readInt(4);\n        this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8);\n        this.disksCount = this.reader.readInt(4);\n        if (this.disksCount > 1) {\n            throw new Error(\"Multi-volumes zip are not supported\");\n        }\n    },\n    /**\n     * Read the local files, based on the offset read in the central part.\n     */\n    readLocalFiles: function() {\n        var i, file;\n        for (i = 0; i < this.files.length; i++) {\n            file = this.files[i];\n            this.reader.setIndex(file.localHeaderOffset);\n            this.checkSignature(sig.LOCAL_FILE_HEADER);\n            file.readLocalPart(this.reader);\n            file.handleUTF8();\n            file.processAttributes();\n        }\n    },\n    /**\n     * Read the central directory.\n     */\n    readCentralDir: function() {\n        var file;\n\n        this.reader.setIndex(this.centralDirOffset);\n        while (this.reader.readAndCheckSignature(sig.CENTRAL_FILE_HEADER)) {\n            file = new ZipEntry({\n                zip64: this.zip64\n            }, this.loadOptions);\n            file.readCentralPart(this.reader);\n            this.files.push(file);\n        }\n\n        if (this.centralDirRecords !== this.files.length) {\n            if (this.centralDirRecords !== 0 && this.files.length === 0) {\n                // We expected some records but couldn't find ANY.\n                // This is really suspicious, as if something went wrong.\n                throw new Error(\"Corrupted zip or bug: expected \" + this.centralDirRecords + \" records in central dir, got \" + this.files.length);\n            } else {\n                // We found some records but not all.\n                // Something is wrong but we got something for the user: no error here.\n                // console.warn(\"expected\", this.centralDirRecords, \"records in central dir, got\", this.files.length);\n            }\n        }\n    },\n    /**\n     * Read the end of central directory.\n     */\n    readEndOfCentral: function() {\n        var offset = this.reader.lastIndexOfSignature(sig.CENTRAL_DIRECTORY_END);\n        if (offset < 0) {\n            // Check if the content is a truncated zip or complete garbage.\n            // A \"LOCAL_FILE_HEADER\" is not required at the beginning (auto\n            // extractible zip for example) but it can give a good hint.\n            // If an ajax request was used without responseType, we will also\n            // get unreadable data.\n            var isGarbage = !this.isSignature(0, sig.LOCAL_FILE_HEADER);\n\n            if (isGarbage) {\n                throw new Error(\"Can't find end of central directory : is this a zip file ? \" +\n                                \"If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html\");\n            } else {\n                throw new Error(\"Corrupted zip: can't find end of central directory\");\n            }\n\n        }\n        this.reader.setIndex(offset);\n        var endOfCentralDirOffset = offset;\n        this.checkSignature(sig.CENTRAL_DIRECTORY_END);\n        this.readBlockEndOfCentral();\n\n\n        /* extract from the zip spec :\n            4)  If one of the fields in the end of central directory\n                record is too small to hold required data, the field\n                should be set to -1 (0xFFFF or 0xFFFFFFFF) and the\n                ZIP64 format record should be created.\n            5)  The end of central directory record and the\n                Zip64 end of central directory locator record must\n                reside on the same disk when splitting or spanning\n                an archive.\n         */\n        if (this.diskNumber === utils.MAX_VALUE_16BITS || this.diskWithCentralDirStart === utils.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === utils.MAX_VALUE_16BITS || this.centralDirRecords === utils.MAX_VALUE_16BITS || this.centralDirSize === utils.MAX_VALUE_32BITS || this.centralDirOffset === utils.MAX_VALUE_32BITS) {\n            this.zip64 = true;\n\n            /*\n            Warning : the zip64 extension is supported, but ONLY if the 64bits integer read from\n            the zip file can fit into a 32bits integer. This cannot be solved : JavaScript represents\n            all numbers as 64-bit double precision IEEE 754 floating point numbers.\n            So, we have 53bits for integers and bitwise operations treat everything as 32bits.\n            see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Operators/Bitwise_Operators\n            and http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf section 8.5\n            */\n\n            // should look for a zip64 EOCD locator\n            offset = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\n            if (offset < 0) {\n                throw new Error(\"Corrupted zip: can't find the ZIP64 end of central directory locator\");\n            }\n            this.reader.setIndex(offset);\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\n            this.readBlockZip64EndOfCentralLocator();\n\n            // now the zip64 EOCD record\n            if (!this.isSignature(this.relativeOffsetEndOfZip64CentralDir, sig.ZIP64_CENTRAL_DIRECTORY_END)) {\n                // console.warn(\"ZIP64 end of central directory not where expected.\");\n                this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\n                if (this.relativeOffsetEndOfZip64CentralDir < 0) {\n                    throw new Error(\"Corrupted zip: can't find the ZIP64 end of central directory\");\n                }\n            }\n            this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\n            this.readBlockZip64EndOfCentral();\n        }\n\n        var expectedEndOfCentralDirOffset = this.centralDirOffset + this.centralDirSize;\n        if (this.zip64) {\n            expectedEndOfCentralDirOffset += 20; // end of central dir 64 locator\n            expectedEndOfCentralDirOffset += 12 /* should not include the leading 12 bytes */ + this.zip64EndOfCentralSize;\n        }\n\n        var extraBytes = endOfCentralDirOffset - expectedEndOfCentralDirOffset;\n\n        if (extraBytes > 0) {\n            // console.warn(extraBytes, \"extra bytes at beginning or within zipfile\");\n            if (this.isSignature(endOfCentralDirOffset, sig.CENTRAL_FILE_HEADER)) {\n                // The offsets seem wrong, but we have something at the specified offset.\n                // So… we keep it.\n            } else {\n                // the offset is wrong, update the \"zero\" of the reader\n                // this happens if data has been prepended (crx files for example)\n                this.reader.zero = extraBytes;\n            }\n        } else if (extraBytes < 0) {\n            throw new Error(\"Corrupted zip: missing \" + Math.abs(extraBytes) + \" bytes.\");\n        }\n    },\n    prepareReader: function(data) {\n        this.reader = readerFor(data);\n    },\n    /**\n     * Read a zip file and create ZipEntries.\n     * @param {String|ArrayBuffer|Uint8Array|Buffer} data the binary string representing a zip file.\n     */\n    load: function(data) {\n        this.prepareReader(data);\n        this.readEndOfCentral();\n        this.readCentralDir();\n        this.readLocalFiles();\n    }\n};\n// }}} end of ZipEntries\nmodule.exports = ZipEntries;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$zipEntry","~$shadow.js","~$module$node_modules$jszip$lib$utf8","~$module$node_modules$jszip$lib$support","~$module$node_modules$jszip$lib$signature","~$module$node_modules$jszip$lib$reader$readerFor","~$module$node_modules$jszip$lib$utils"]],"~:properties",["^5",["relativeOffsetEndOfZip64CentralDir","checkSignature","index","reader","prototype","load","readBlockZip64EndOfCentralLocator","readBlockEndOfCentral","zipComment","readLocalFiles","id","zipCommentLength","files","zero","disksCount","centralDirRecords","zip64ExtensibleData","prepareReader","readEndOfCentral","value","readCentralDir","length","centralDirRecordsOnThisDisk","loadOptions","diskWithZip64CentralDirStart","isSignature","zip64EndOfCentralSize","diskWithCentralDirStart","zip64","readBlockZip64EndOfCentral","centralDirOffset","centralDirSize","diskNumber"]],"~:compiled-at",1766065009570,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$zipEntries.js\",\n\"lineCount\":9,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CAc9DC,QAASA,EAAU,CAACC,CAAD,CAAc,CAC7B,IAAKC,CAAAA,KAAL,CAAa,EACb,KAAKD,CAAAA,WAAL,CAAmBA,CAFU,CAZjC,IAAIE,EAAYN,CAAA,CAAQ,GAAR,CAAhB,CACIO,EAAQP,CAAA,CAAQ,GAAR,CADZ,CAEIQ,EAAMR,CAAA,CAAQ,GAAR,CAFV,CAGIS,EAAWT,CAAA,CAAQ,GAAR,CACJA,EAAA,CAAQ,GAAR,CACX,KAAIU,EAAUV,CAAA,CAAQ,GAAR,CAWdG,EAAWQ,CAAAA,SAAX,CAAuB,CAMnBC,eAAgBA,QAAQ,CAACC,CAAD,CAAoB,CACxC,GAAI,CAAC,IAAKC,CAAAA,MAAOC,CAAAA,qBAAZ,CAAkCF,CAAlC,CAAL,CAA2D,CACvD,IAAKC,CAAAA,MAAOE,CAAAA,KAAZ,EAAqB,CACrB,KAAIC,EAAY,IAAKH,CAAAA,MAAOI,CAAAA,UAAZ,CAAuB,CAAvB,CAChB,MAAUC,MAAJ,CAAU,8CAAV,CAAgEZ,CAAMa,CAAAA,MAAN,CAAaH,CAAb,CAAhE,CAA0F,aAA1F,CAA0GV,CAAMa,CAAAA,MAAN,CAAaP,CAAb,CAA1G,CAA4I,GAA5I,CAAN,CAHuD,CADnB,CANzB,CAmBnBQ,YAAaA,QAAQ,CAACC,CAAD,CAAaT,CAAb,CAAgC,CACjD,IAAIU,EAAe,IAAKT,CAAAA,MAAOE,CAAAA,KAC/B,KAAKF,CAAAA,MAAOU,CAAAA,QAAZ,CAAqBF,CAArB,CAEIG,EAAAA,CADY,IAAKX,CAAAA,MAAOI,CAAAA,UAAZD,CAAuB,CAAvBA,CACZQ,GAAuBZ,CAC3B,KAAKC,CAAAA,MAAOU,CAAAA,QAAZ,CAAqBD,CAArB,CACA;MAAOE,EAN0C,CAnBlC,CA8BnBC,sBAAuBA,QAAQ,EAAG,CAC9B,IAAKC,CAAAA,UAAL,CAAkB,IAAKb,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAClB,KAAKC,CAAAA,uBAAL,CAA+B,IAAKf,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAC/B,KAAKE,CAAAA,2BAAL,CAAmC,IAAKhB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACnC,KAAKG,CAAAA,iBAAL,CAAyB,IAAKjB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACzB,KAAKI,CAAAA,cAAL,CAAsB,IAAKlB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACtB,KAAKK,CAAAA,gBAAL,CAAwB,IAAKnB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAExB,KAAKM,CAAAA,gBAAL,CAAwB,IAAKpB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAIxB,KAAIO,EAAa,IAAKrB,CAAAA,MAAOsB,CAAAA,QAAZ,CAAqB,IAAKF,CAAAA,gBAA1B,CAIbG,EAAAA,CAAgB9B,CAAM+B,CAAAA,WAAN,CAHE5B,CAAQ6B,CAAAA,UAARC,CAAqB,YAArBA,CAAoC,OAGtC,CAAmCL,CAAnC,CACpB,KAAKA,CAAAA,UAAL,CAAkB,IAAK/B,CAAAA,WAAYqC,CAAAA,cAAjB,CAAgCJ,CAAhC,CAjBY,CA9Bf;AAuDnBK,2BAA4BA,QAAQ,EAAG,CACnC,IAAKC,CAAAA,qBAAL,CAA6B,IAAK7B,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAC7B,KAAKd,CAAAA,MAAO8B,CAAAA,IAAZ,CAAiB,CAAjB,CAGA,KAAKjB,CAAAA,UAAL,CAAkB,IAAKb,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAClB,KAAKC,CAAAA,uBAAL,CAA+B,IAAKf,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAC/B,KAAKE,CAAAA,2BAAL,CAAmC,IAAKhB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACnC,KAAKG,CAAAA,iBAAL,CAAyB,IAAKjB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACzB,KAAKI,CAAAA,cAAL,CAAsB,IAAKlB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACtB,KAAKK,CAAAA,gBAAL,CAAwB,IAAKnB,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAExB,KAAKiB,CAAAA,mBAAL,CAA2B,EAM3B,KAlBmC,IAa/BC,EAAgB,IAAKH,CAAAA,qBAArBG,CAA6C,EAbd,CAe/BC,CAf+B,CAgB/BC,CAhB+B,CAiB/BC,CACJ,CAJYjC,CAIZ,CAAe8B,CAAf,CAAA,CACIC,CAGA,CAHe,IAAKjC,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAGf,CAFAoB,CAEA,CAFmB,IAAKlC,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAEnB;AADAqB,CACA,CADkB,IAAKnC,CAAAA,MAAOsB,CAAAA,QAAZ,CAAqBY,CAArB,CAClB,CAAA,IAAKH,CAAAA,mBAAL,CAAyBE,CAAzB,CAAA,CAAyC,CACrCG,GAAIH,CADiC,CAErCI,OAAQH,CAF6B,CAGrCI,MAAOH,CAH8B,CAtBV,CAvDpB,CAuFnBI,kCAAmCA,QAAQ,EAAG,CAC1C,IAAKC,CAAAA,4BAAL,CAAoC,IAAKxC,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CACpC,KAAK2B,CAAAA,kCAAL,CAA0C,IAAKzC,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAC1C,KAAK4B,CAAAA,UAAL,CAAkB,IAAK1C,CAAAA,MAAOc,CAAAA,OAAZ,CAAoB,CAApB,CAClB,IAAsB,CAAtB,CAAI,IAAK4B,CAAAA,UAAT,CACI,KAAUrC,MAAJ,CAAU,qCAAV,CAAN,CALsC,CAvF3B,CAkGnBsC,eAAgBA,QAAQ,EAAG,CAAA,IACnBC,CACJ,KAAKA,CAAL,CAAS,CAAT,CAAYA,CAAZ,CAAgB,IAAKrD,CAAAA,KAAM8C,CAAAA,MAA3B,CAAmCO,CAAA,EAAnC,CAAwC,CACpC,IAAAC,EAAO,IAAKtD,CAAAA,KAAL,CAAWqD,CAAX,CACP,KAAK5C,CAAAA,MAAOU,CAAAA,QAAZ,CAAqBmC,CAAKC,CAAAA,iBAA1B,CACA,KAAKhD,CAAAA,cAAL,CAAoBJ,CAAIqD,CAAAA,iBAAxB,CACAF;CAAKG,CAAAA,aAAL,CAAmB,IAAKhD,CAAAA,MAAxB,CACA6C,EAAKI,CAAAA,UAAL,EACAJ,EAAKK,CAAAA,iBAAL,EANoC,CAFjB,CAlGR,CAgHnBC,eAAgBA,QAAQ,EAAG,CAIvB,IADA,IAAKnD,CAAAA,MAAOU,CAAAA,QAAZ,CAAqB,IAAKS,CAAAA,gBAA1B,CACA,CAAO,IAAKnB,CAAAA,MAAOC,CAAAA,qBAAZ,CAAkCP,CAAI0D,CAAAA,mBAAtC,CAAP,CAAA,CAAmE,CAC/D,IAAAP,EAAO,IAAIlD,CAAJ,CAAa,CAChB0D,MAAO,IAAKA,CAAAA,KADI,CAAb,CAEJ,IAAK/D,CAAAA,WAFD,CAGPuD,EAAKS,CAAAA,eAAL,CAAqB,IAAKtD,CAAAA,MAA1B,CACA,KAAKT,CAAAA,KAAMgE,CAAAA,IAAX,CAAgBV,CAAhB,CAL+D,CAQnE,GAAI,IAAK5B,CAAAA,iBAAT,GAA+B,IAAK1B,CAAAA,KAAM8C,CAAAA,MAA1C,EACmC,CADnC,GACQ,IAAKpB,CAAAA,iBADb,EAC8D,CAD9D,GACwC,IAAK1B,CAAAA,KAAM8C,CAAAA,MADnD,CAIQ,KAAUhC,MAAJ,CAAU,iCAAV,CAA8C,IAAKY,CAAAA,iBAAnD,CAAuE,+BAAvE,CAAyG,IAAK1B,CAAAA,KAAM8C,CAAAA,MAApH,CAAN;AAhBe,CAhHR,CA2InBmB,iBAAkBA,QAAQ,EAAG,CACzB,IAAIC,EAAS,IAAKzD,CAAAA,MAAO0D,CAAAA,oBAAZ,CAAiChE,CAAIiE,CAAAA,qBAArC,CACb,IAAa,CAAb,CAAIF,CAAJ,CAAgB,CAQZ,GAFiB,IAAKlD,CAAAA,WAALqD,CAAiB,CAAjBA,CAAoBlE,CAAIqD,CAAAA,iBAAxBa,CAEjB,CAII,KAAUvD,MAAJ,CAAU,oDAAV,CAAN,CAHA,KAAUA,MAAJ,CAAU,yIAAV,CAAN,CATQ,CAgBhB,IAAKL,CAAAA,MAAOU,CAAAA,QAAZ,CAAqB+C,CAArB,CACA,KAAII,EAAwBJ,CAC5B,KAAK3D,CAAAA,cAAL,CAAoBJ,CAAIiE,CAAAA,qBAAxB,CACA,KAAK/C,CAAAA,qBAAL,EAaA,IAAI,IAAKC,CAAAA,UAAT,GAAwBpB,CAAMqE,CAAAA,gBAA9B;AAAkD,IAAK/C,CAAAA,uBAAvD,GAAmFtB,CAAMqE,CAAAA,gBAAzF,EAA6G,IAAK9C,CAAAA,2BAAlH,GAAkJvB,CAAMqE,CAAAA,gBAAxJ,EAA4K,IAAK7C,CAAAA,iBAAjL,GAAuMxB,CAAMqE,CAAAA,gBAA7M,EAAiO,IAAK5C,CAAAA,cAAtO,GAAyPzB,CAAMsE,CAAAA,gBAA/P,EAAmR,IAAK5C,CAAAA,gBAAxR,GAA6S1B,CAAMsE,CAAAA,gBAAnT,CAAqU,CACjU,IAAKV,CAAAA,KAAL,CAAa,CAAA,CAYbI,EAAA,CAAS,IAAKzD,CAAAA,MAAO0D,CAAAA,oBAAZ,CAAiChE,CAAIsE,CAAAA,+BAArC,CACT,IAAa,CAAb,CAAIP,CAAJ,CACI,KAAUpD,MAAJ,CAAU,sEAAV,CAAN,CAEJ,IAAKL,CAAAA,MAAOU,CAAAA,QAAZ,CAAqB+C,CAArB,CACA,KAAK3D,CAAAA,cAAL,CAAoBJ,CAAIsE,CAAAA,+BAAxB,CACA,KAAKzB,CAAAA,iCAAL,EAGA;GAAI,CAAC,IAAKhC,CAAAA,WAAL,CAAiB,IAAKkC,CAAAA,kCAAtB,CAA0D/C,CAAIuE,CAAAA,2BAA9D,CAAL,GAEI,IAAKxB,CAAAA,kCACD,CADsC,IAAKzC,CAAAA,MAAO0D,CAAAA,oBAAZ,CAAiChE,CAAIuE,CAAAA,2BAArC,CACtC,CAA0C,CAA1C,CAAA,IAAKxB,CAAAA,kCAHb,EAIQ,KAAUpC,MAAJ,CAAU,8DAAV,CAAN,CAGR,IAAKL,CAAAA,MAAOU,CAAAA,QAAZ,CAAqB,IAAK+B,CAAAA,kCAA1B,CACA,KAAK3C,CAAAA,cAAL,CAAoBJ,CAAIuE,CAAAA,2BAAxB,CACA,KAAKrC,CAAAA,0BAAL,EA/BiU,CAkCjUsC,CAAAA,CAAgC,IAAK/C,CAAAA,gBAArC+C,CAAwD,IAAKhD,CAAAA,cAC7D;IAAKmC,CAAAA,KAAT,GAEIa,CAFJ,CACIA,CADJ,CACqC,EADrC,EAEqC,EAFrC,CAEwF,IAAKrC,CAAAA,qBAF7F,EAKIsC,EAAAA,CAAaN,CAAbM,CAAqCD,CAEzC,IAAiB,CAAjB,CAAIC,CAAJ,CAEQ,IAAK5D,CAAAA,WAAL,CAAiBsD,CAAjB,CAAwCnE,CAAI0D,CAAAA,mBAA5C,CAAJ,GAMI,IAAKpD,CAAAA,MAAOoE,CAAAA,IANhB,CAMuBD,CANvB,CAFJ,KAUO,IAAiB,CAAjB,CAAIA,CAAJ,CACH,KAAU9D,MAAJ,CAAU,yBAAV,CAAsCgE,IAAKC,CAAAA,GAAL,CAASH,CAAT,CAAtC,CAA6D,SAA7D,CAAN,CAvFqB,CA3IV,CAqOnBI,cAAeA,QAAQ,CAACC,CAAD,CAAO,CAC1B,IAAKxE,CAAAA,MAAL,CAAcR,CAAA,CAAUgF,CAAV,CADY,CArOX,CA4OnBC,KAAMA,QAAQ,CAACD,CAAD,CAAO,CACjB,IAAKD,CAAAA,aAAL,CAAmBC,CAAnB,CACA,KAAKhB,CAAAA,gBAAL,EACA,KAAKL,CAAAA,cAAL,EACA,KAAKR,CAAAA,cAAL,EAJiB,CA5OF,CAoPvBxD,GAAOC,CAAAA,OAAP,CAAiBC,CAtQ6C;\",\n\"sources\":[\"node_modules/jszip/lib/zipEntries.js\"],\n\"sourcesContent\":[\"shadow$provide[199] = function(global,require,module,exports) {\\n'use strict';\\nvar readerFor = require('./reader/readerFor');\\nvar utils = require('./utils');\\nvar sig = require('./signature');\\nvar ZipEntry = require('./zipEntry');\\nvar utf8 = require('./utf8');\\nvar support = require('./support');\\n//  class ZipEntries {{{\\n/**\\n * All the entries in the zip file.\\n * @constructor\\n * @param {Object} loadOptions Options for loading the stream.\\n */\\nfunction ZipEntries(loadOptions) {\\n    this.files = [];\\n    this.loadOptions = loadOptions;\\n}\\nZipEntries.prototype = {\\n    /**\\n     * Check that the reader is on the specified signature.\\n     * @param {string} expectedSignature the expected signature.\\n     * @throws {Error} if it is an other signature.\\n     */\\n    checkSignature: function(expectedSignature) {\\n        if (!this.reader.readAndCheckSignature(expectedSignature)) {\\n            this.reader.index -= 4;\\n            var signature = this.reader.readString(4);\\n            throw new Error(\\\"Corrupted zip or bug: unexpected signature \\\" + \\\"(\\\" + utils.pretty(signature) + \\\", expected \\\" + utils.pretty(expectedSignature) + \\\")\\\");\\n        }\\n    },\\n    /**\\n     * Check if the given signature is at the given index.\\n     * @param {number} askedIndex the index to check.\\n     * @param {string} expectedSignature the signature to expect.\\n     * @return {boolean} true if the signature is here, false otherwise.\\n     */\\n    isSignature: function(askedIndex, expectedSignature) {\\n        var currentIndex = this.reader.index;\\n        this.reader.setIndex(askedIndex);\\n        var signature = this.reader.readString(4);\\n        var result = signature === expectedSignature;\\n        this.reader.setIndex(currentIndex);\\n        return result;\\n    },\\n    /**\\n     * Read the end of the central directory.\\n     */\\n    readBlockEndOfCentral: function() {\\n        this.diskNumber = this.reader.readInt(2);\\n        this.diskWithCentralDirStart = this.reader.readInt(2);\\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(2);\\n        this.centralDirRecords = this.reader.readInt(2);\\n        this.centralDirSize = this.reader.readInt(4);\\n        this.centralDirOffset = this.reader.readInt(4);\\n\\n        this.zipCommentLength = this.reader.readInt(2);\\n        // warning : the encoding depends of the system locale\\n        // On a linux machine with LANG=en_US.utf8, this field is utf8 encoded.\\n        // On a windows machine, this field is encoded with the localized windows code page.\\n        var zipComment = this.reader.readData(this.zipCommentLength);\\n        var decodeParamType = support.uint8array ? \\\"uint8array\\\" : \\\"array\\\";\\n        // To get consistent behavior with the generation part, we will assume that\\n        // this is utf8 encoded unless specified otherwise.\\n        var decodeContent = utils.transformTo(decodeParamType, zipComment);\\n        this.zipComment = this.loadOptions.decodeFileName(decodeContent);\\n    },\\n    /**\\n     * Read the end of the Zip 64 central directory.\\n     * Not merged with the method readEndOfCentral :\\n     * The end of central can coexist with its Zip64 brother,\\n     * I don't want to read the wrong number of bytes !\\n     */\\n    readBlockZip64EndOfCentral: function() {\\n        this.zip64EndOfCentralSize = this.reader.readInt(8);\\n        this.reader.skip(4);\\n        // this.versionMadeBy = this.reader.readString(2);\\n        // this.versionNeeded = this.reader.readInt(2);\\n        this.diskNumber = this.reader.readInt(4);\\n        this.diskWithCentralDirStart = this.reader.readInt(4);\\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(8);\\n        this.centralDirRecords = this.reader.readInt(8);\\n        this.centralDirSize = this.reader.readInt(8);\\n        this.centralDirOffset = this.reader.readInt(8);\\n\\n        this.zip64ExtensibleData = {};\\n        var extraDataSize = this.zip64EndOfCentralSize - 44,\\n            index = 0,\\n            extraFieldId,\\n            extraFieldLength,\\n            extraFieldValue;\\n        while (index < extraDataSize) {\\n            extraFieldId = this.reader.readInt(2);\\n            extraFieldLength = this.reader.readInt(4);\\n            extraFieldValue = this.reader.readData(extraFieldLength);\\n            this.zip64ExtensibleData[extraFieldId] = {\\n                id: extraFieldId,\\n                length: extraFieldLength,\\n                value: extraFieldValue\\n            };\\n        }\\n    },\\n    /**\\n     * Read the end of the Zip 64 central directory locator.\\n     */\\n    readBlockZip64EndOfCentralLocator: function() {\\n        this.diskWithZip64CentralDirStart = this.reader.readInt(4);\\n        this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8);\\n        this.disksCount = this.reader.readInt(4);\\n        if (this.disksCount > 1) {\\n            throw new Error(\\\"Multi-volumes zip are not supported\\\");\\n        }\\n    },\\n    /**\\n     * Read the local files, based on the offset read in the central part.\\n     */\\n    readLocalFiles: function() {\\n        var i, file;\\n        for (i = 0; i < this.files.length; i++) {\\n            file = this.files[i];\\n            this.reader.setIndex(file.localHeaderOffset);\\n            this.checkSignature(sig.LOCAL_FILE_HEADER);\\n            file.readLocalPart(this.reader);\\n            file.handleUTF8();\\n            file.processAttributes();\\n        }\\n    },\\n    /**\\n     * Read the central directory.\\n     */\\n    readCentralDir: function() {\\n        var file;\\n\\n        this.reader.setIndex(this.centralDirOffset);\\n        while (this.reader.readAndCheckSignature(sig.CENTRAL_FILE_HEADER)) {\\n            file = new ZipEntry({\\n                zip64: this.zip64\\n            }, this.loadOptions);\\n            file.readCentralPart(this.reader);\\n            this.files.push(file);\\n        }\\n\\n        if (this.centralDirRecords !== this.files.length) {\\n            if (this.centralDirRecords !== 0 && this.files.length === 0) {\\n                // We expected some records but couldn't find ANY.\\n                // This is really suspicious, as if something went wrong.\\n                throw new Error(\\\"Corrupted zip or bug: expected \\\" + this.centralDirRecords + \\\" records in central dir, got \\\" + this.files.length);\\n            } else {\\n                // We found some records but not all.\\n                // Something is wrong but we got something for the user: no error here.\\n                // console.warn(\\\"expected\\\", this.centralDirRecords, \\\"records in central dir, got\\\", this.files.length);\\n            }\\n        }\\n    },\\n    /**\\n     * Read the end of central directory.\\n     */\\n    readEndOfCentral: function() {\\n        var offset = this.reader.lastIndexOfSignature(sig.CENTRAL_DIRECTORY_END);\\n        if (offset < 0) {\\n            // Check if the content is a truncated zip or complete garbage.\\n            // A \\\"LOCAL_FILE_HEADER\\\" is not required at the beginning (auto\\n            // extractible zip for example) but it can give a good hint.\\n            // If an ajax request was used without responseType, we will also\\n            // get unreadable data.\\n            var isGarbage = !this.isSignature(0, sig.LOCAL_FILE_HEADER);\\n\\n            if (isGarbage) {\\n                throw new Error(\\\"Can't find end of central directory : is this a zip file ? \\\" +\\n                                \\\"If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html\\\");\\n            } else {\\n                throw new Error(\\\"Corrupted zip: can't find end of central directory\\\");\\n            }\\n\\n        }\\n        this.reader.setIndex(offset);\\n        var endOfCentralDirOffset = offset;\\n        this.checkSignature(sig.CENTRAL_DIRECTORY_END);\\n        this.readBlockEndOfCentral();\\n\\n\\n        /* extract from the zip spec :\\n            4)  If one of the fields in the end of central directory\\n                record is too small to hold required data, the field\\n                should be set to -1 (0xFFFF or 0xFFFFFFFF) and the\\n                ZIP64 format record should be created.\\n            5)  The end of central directory record and the\\n                Zip64 end of central directory locator record must\\n                reside on the same disk when splitting or spanning\\n                an archive.\\n         */\\n        if (this.diskNumber === utils.MAX_VALUE_16BITS || this.diskWithCentralDirStart === utils.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === utils.MAX_VALUE_16BITS || this.centralDirRecords === utils.MAX_VALUE_16BITS || this.centralDirSize === utils.MAX_VALUE_32BITS || this.centralDirOffset === utils.MAX_VALUE_32BITS) {\\n            this.zip64 = true;\\n\\n            /*\\n            Warning : the zip64 extension is supported, but ONLY if the 64bits integer read from\\n            the zip file can fit into a 32bits integer. This cannot be solved : JavaScript represents\\n            all numbers as 64-bit double precision IEEE 754 floating point numbers.\\n            So, we have 53bits for integers and bitwise operations treat everything as 32bits.\\n            see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Operators/Bitwise_Operators\\n            and http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf section 8.5\\n            */\\n\\n            // should look for a zip64 EOCD locator\\n            offset = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\\n            if (offset < 0) {\\n                throw new Error(\\\"Corrupted zip: can't find the ZIP64 end of central directory locator\\\");\\n            }\\n            this.reader.setIndex(offset);\\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\\n            this.readBlockZip64EndOfCentralLocator();\\n\\n            // now the zip64 EOCD record\\n            if (!this.isSignature(this.relativeOffsetEndOfZip64CentralDir, sig.ZIP64_CENTRAL_DIRECTORY_END)) {\\n                // console.warn(\\\"ZIP64 end of central directory not where expected.\\\");\\n                this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\\n                if (this.relativeOffsetEndOfZip64CentralDir < 0) {\\n                    throw new Error(\\\"Corrupted zip: can't find the ZIP64 end of central directory\\\");\\n                }\\n            }\\n            this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);\\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\\n            this.readBlockZip64EndOfCentral();\\n        }\\n\\n        var expectedEndOfCentralDirOffset = this.centralDirOffset + this.centralDirSize;\\n        if (this.zip64) {\\n            expectedEndOfCentralDirOffset += 20; // end of central dir 64 locator\\n            expectedEndOfCentralDirOffset += 12 /* should not include the leading 12 bytes */ + this.zip64EndOfCentralSize;\\n        }\\n\\n        var extraBytes = endOfCentralDirOffset - expectedEndOfCentralDirOffset;\\n\\n        if (extraBytes > 0) {\\n            // console.warn(extraBytes, \\\"extra bytes at beginning or within zipfile\\\");\\n            if (this.isSignature(endOfCentralDirOffset, sig.CENTRAL_FILE_HEADER)) {\\n                // The offsets seem wrong, but we have something at the specified offset.\\n                // So\\u2026 we keep it.\\n            } else {\\n                // the offset is wrong, update the \\\"zero\\\" of the reader\\n                // this happens if data has been prepended (crx files for example)\\n                this.reader.zero = extraBytes;\\n            }\\n        } else if (extraBytes < 0) {\\n            throw new Error(\\\"Corrupted zip: missing \\\" + Math.abs(extraBytes) + \\\" bytes.\\\");\\n        }\\n    },\\n    prepareReader: function(data) {\\n        this.reader = readerFor(data);\\n    },\\n    /**\\n     * Read a zip file and create ZipEntries.\\n     * @param {String|ArrayBuffer|Uint8Array|Buffer} data the binary string representing a zip file.\\n     */\\n    load: function(data) {\\n        this.prepareReader(data);\\n        this.readEndOfCentral();\\n        this.readCentralDir();\\n        this.readLocalFiles();\\n    }\\n};\\n// }}} end of ZipEntries\\nmodule.exports = ZipEntries;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"ZipEntries\",\"loadOptions\",\"files\",\"readerFor\",\"utils\",\"sig\",\"ZipEntry\",\"support\",\"prototype\",\"checkSignature\",\"expectedSignature\",\"reader\",\"readAndCheckSignature\",\"index\",\"signature\",\"readString\",\"Error\",\"pretty\",\"isSignature\",\"askedIndex\",\"currentIndex\",\"setIndex\",\"result\",\"readBlockEndOfCentral\",\"diskNumber\",\"readInt\",\"diskWithCentralDirStart\",\"centralDirRecordsOnThisDisk\",\"centralDirRecords\",\"centralDirSize\",\"centralDirOffset\",\"zipCommentLength\",\"zipComment\",\"readData\",\"decodeContent\",\"transformTo\",\"uint8array\",\"decodeParamType\",\"decodeFileName\",\"readBlockZip64EndOfCentral\",\"zip64EndOfCentralSize\",\"skip\",\"zip64ExtensibleData\",\"extraDataSize\",\"extraFieldId\",\"extraFieldLength\",\"extraFieldValue\",\"id\",\"length\",\"value\",\"readBlockZip64EndOfCentralLocator\",\"diskWithZip64CentralDirStart\",\"relativeOffsetEndOfZip64CentralDir\",\"disksCount\",\"readLocalFiles\",\"i\",\"file\",\"localHeaderOffset\",\"LOCAL_FILE_HEADER\",\"readLocalPart\",\"handleUTF8\",\"processAttributes\",\"readCentralDir\",\"CENTRAL_FILE_HEADER\",\"zip64\",\"readCentralPart\",\"push\",\"readEndOfCentral\",\"offset\",\"lastIndexOfSignature\",\"CENTRAL_DIRECTORY_END\",\"isGarbage\",\"endOfCentralDirOffset\",\"MAX_VALUE_16BITS\",\"MAX_VALUE_32BITS\",\"ZIP64_CENTRAL_DIRECTORY_LOCATOR\",\"ZIP64_CENTRAL_DIRECTORY_END\",\"expectedEndOfCentralDirOffset\",\"extraBytes\",\"zero\",\"Math\",\"abs\",\"prepareReader\",\"data\",\"load\"]\n}\n"]