["^ ","~:resource-id",["~:shadow.build.npm/resource","node_modules/jszip/lib/stream/StreamHelper.js"],"~:js","shadow$provide[161]=function(ra,X,Ra,P){function w(g,h){var b,l=0,k=0;for(b=0;b<h.length;b++)k+=h[b].length;switch(g){case \"string\":return h.join(\"\");case \"array\":return Array.prototype.concat.apply([],h);case \"uint8array\":g=new Uint8Array(k);for(b=0;b<h.length;b++)g.set(h[b],l),l+=h[b].length;return g;case \"nodebuffer\":return p.concat(h);default:throw Error(\"concat : unsupported type '\"+g+\"'\");}}function Z(g,h){return new x.Promise(function(b,l){var k=[],r=g._internalType,D=g._outputType,v=g._mimeType;\ng.on(\"data\",function(t,q){k.push(t);h&&h(q)}).on(\"error\",function(t){k=[];l(t)}).on(\"end\",function(){try{a:{var t=w(r,k);switch(D){case \"blob\":var q=c.newBlob(c.transformTo(\"arraybuffer\",t),v);break a;case \"base64\":q=y.encode(t);break a;default:q=c.transformTo(D,t)}}b(q)}catch(f){l(f)}k=[]}).resume()})}function B(g,h,b){var l=h;switch(h){case \"blob\":case \"arraybuffer\":l=\"uint8array\";break;case \"base64\":l=\"string\"}try{this._internalType=l,this._outputType=h,this._mimeType=b,c.checkSupport(l),this._worker=\ng.pipe(new u(l)),g.lock()}catch(k){this._worker=new A(\"error\"),this._worker.error(k)}}var p=X(131).Buffer;\"use strict\";var c=X(156),u=X(159),A=X(157),y=X(150);ra=X(149);var x=X(155),Q=null;if(ra.nodestream)try{Q=X(160)}catch(g){}B.prototype={accumulate:function(g){return Z(this,g)},on:function(g,h){var b=this;if(\"data\"===g)this._worker.on(g,function(l){h.call(b,l.data,l.meta)});else this._worker.on(g,function(){c.delay(h,arguments,b)});return this},resume:function(){c.delay(this._worker.resume,[],\nthis._worker);return this},pause:function(){this._worker.pause();return this},toNodejsStream:function(g){c.checkSupport(\"nodestream\");if(\"nodebuffer\"!==this._outputType)throw Error(this._outputType+\" is not supported by this method\");return new Q(this,{objectMode:\"nodebuffer\"!==this._outputType},g)}};Ra.exports=B}","~:source","shadow$provide[161] = function(global,require,module,exports) {\nvar Buffer = require('buffer').Buffer;\n'use strict';\n\nvar utils = require('../utils');\nvar ConvertWorker = require('./ConvertWorker');\nvar GenericWorker = require('./GenericWorker');\nvar base64 = require('../base64');\nvar support = require(\"../support\");\nvar external = require(\"../external\");\n\nvar NodejsStreamOutputAdapter = null;\nif (support.nodestream) {\n    try {\n        NodejsStreamOutputAdapter = require('../nodejs/NodejsStreamOutputAdapter');\n    } catch(e) {}\n}\n\n/**\n * Apply the final transformation of the data. If the user wants a Blob for\n * example, it's easier to work with an U8intArray and finally do the\n * ArrayBuffer/Blob conversion.\n * @param {String} type the name of the final type\n * @param {String|Uint8Array|Buffer} content the content to transform\n * @param {String} mimeType the mime type of the content, if applicable.\n * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the content in the right format.\n */\nfunction transformZipOutput(type, content, mimeType) {\n    switch(type) {\n        case \"blob\" :\n            return utils.newBlob(utils.transformTo(\"arraybuffer\", content), mimeType);\n        case \"base64\" :\n            return base64.encode(content);\n        default :\n            return utils.transformTo(type, content);\n    }\n}\n\n/**\n * Concatenate an array of data of the given type.\n * @param {String} type the type of the data in the given array.\n * @param {Array} dataArray the array containing the data chunks to concatenate\n * @return {String|Uint8Array|Buffer} the concatenated data\n * @throws Error if the asked type is unsupported\n */\nfunction concat (type, dataArray) {\n    var i, index = 0, res = null, totalLength = 0;\n    for(i = 0; i < dataArray.length; i++) {\n        totalLength += dataArray[i].length;\n    }\n    switch(type) {\n        case \"string\":\n            return dataArray.join(\"\");\n          case \"array\":\n            return Array.prototype.concat.apply([], dataArray);\n        case \"uint8array\":\n            res = new Uint8Array(totalLength);\n            for(i = 0; i < dataArray.length; i++) {\n                res.set(dataArray[i], index);\n                index += dataArray[i].length;\n            }\n            return res;\n        case \"nodebuffer\":\n            return Buffer.concat(dataArray);\n        default:\n            throw new Error(\"concat : unsupported type '\"  + type + \"'\");\n    }\n}\n\n/**\n * Listen a StreamHelper, accumulate its content and concatenate it into a\n * complete block.\n * @param {StreamHelper} helper the helper to use.\n * @param {Function} updateCallback a callback called on each update. Called\n * with one arg :\n * - the metadata linked to the update received.\n * @return Promise the promise for the accumulation.\n */\nfunction accumulate(helper, updateCallback) {\n    return new external.Promise(function (resolve, reject){\n        var dataArray = [];\n        var chunkType = helper._internalType,\n            resultType = helper._outputType,\n            mimeType = helper._mimeType;\n        helper\n        .on('data', function (data, meta) {\n            dataArray.push(data);\n            if(updateCallback) {\n                updateCallback(meta);\n            }\n        })\n        .on('error', function(err) {\n            dataArray = [];\n            reject(err);\n        })\n        .on('end', function (){\n            try {\n                var result = transformZipOutput(resultType, concat(chunkType, dataArray), mimeType);\n                resolve(result);\n            } catch (e) {\n                reject(e);\n            }\n            dataArray = [];\n        })\n        .resume();\n    });\n}\n\n/**\n * An helper to easily use workers outside of JSZip.\n * @constructor\n * @param {Worker} worker the worker to wrap\n * @param {String} outputType the type of data expected by the use\n * @param {String} mimeType the mime type of the content, if applicable.\n */\nfunction StreamHelper(worker, outputType, mimeType) {\n    var internalType = outputType;\n    switch(outputType) {\n        case \"blob\":\n        case \"arraybuffer\":\n            internalType = \"uint8array\";\n        break;\n        case \"base64\":\n            internalType = \"string\";\n        break;\n    }\n\n    try {\n        // the type used internally\n        this._internalType = internalType;\n        // the type used to output results\n        this._outputType = outputType;\n        // the mime type\n        this._mimeType = mimeType;\n        utils.checkSupport(internalType);\n        this._worker = worker.pipe(new ConvertWorker(internalType));\n        // the last workers can be rewired without issues but we need to\n        // prevent any updates on previous workers.\n        worker.lock();\n    } catch(e) {\n        this._worker = new GenericWorker(\"error\");\n        this._worker.error(e);\n    }\n}\n\nStreamHelper.prototype = {\n    /**\n     * Listen a StreamHelper, accumulate its content and concatenate it into a\n     * complete block.\n     * @param {Function} updateCb the update callback.\n     * @return Promise the promise for the accumulation.\n     */\n    accumulate : function (updateCb) {\n        return accumulate(this, updateCb);\n    },\n    /**\n     * Add a listener on an event triggered on a stream.\n     * @param {String} evt the name of the event\n     * @param {Function} fn the listener\n     * @return {StreamHelper} the current helper.\n     */\n    on : function (evt, fn) {\n        var self = this;\n\n        if(evt === \"data\") {\n            this._worker.on(evt, function (chunk) {\n                fn.call(self, chunk.data, chunk.meta);\n            });\n        } else {\n            this._worker.on(evt, function () {\n                utils.delay(fn, arguments, self);\n            });\n        }\n        return this;\n    },\n    /**\n     * Resume the flow of chunks.\n     * @return {StreamHelper} the current helper.\n     */\n    resume : function () {\n        utils.delay(this._worker.resume, [], this._worker);\n        return this;\n    },\n    /**\n     * Pause the flow of chunks.\n     * @return {StreamHelper} the current helper.\n     */\n    pause : function () {\n        this._worker.pause();\n        return this;\n    },\n    /**\n     * Return a nodejs stream for this helper.\n     * @param {Function} updateCb the update callback.\n     * @return {NodejsStreamOutputAdapter} the nodejs stream.\n     */\n    toNodejsStream : function (updateCb) {\n        utils.checkSupport(\"nodestream\");\n        if (this._outputType !== \"nodebuffer\") {\n            // an object stream containing blob/arraybuffer/uint8array/string\n            // is strange and I don't know if it would be useful.\n            // I you find this comment and have a good usecase, please open a\n            // bug report !\n            throw new Error(this._outputType + \" is not supported by this method\");\n        }\n\n        return new NodejsStreamOutputAdapter(this, {\n            objectMode : this._outputType !== \"nodebuffer\"\n        }, updateCb);\n    }\n};\n\n\nmodule.exports = StreamHelper;\n\n};","~:removed-requires",["~#set",[]],"~:actual-requires",["^5",["~$module$node_modules$jszip$lib$stream$GenericWorker","~$shadow.js","~$module$node_modules$jszip$lib$nodejs$NodejsStreamOutputAdapter","~$module$node_modules$jszip$lib$support","~$module$node_modules$jszip$lib$base64","~$module$node_modules$jszip$lib$stream$ConvertWorker","~$module$node_modules$buffer$index","~$module$node_modules$jszip$lib$utils","~$module$node_modules$jszip$lib$external"]],"~:properties",["^5",["prototype","_outputType","_internalType","_mimeType","pause","on","accumulate","_worker","toNodejsStream","objectMode","resume"]],"~:compiled-at",1766065009556,"~:source-map-json","{\n\"version\":3,\n\"file\":\"module$node_modules$jszip$lib$stream$StreamHelper.js\",\n\"lineCount\":4,\n\"mappings\":\"AAAAA,cAAA,CAAe,GAAf,CAAA,CAAsB,QAAQ,CAACC,EAAD,CAAQC,CAAR,CAAgBC,EAAhB,CAAuBC,CAAvB,CAAgC,CA6C9DC,QAASA,EAAO,CAACC,CAAD,CAAOC,CAAP,CAAkB,CAAA,IAC1BC,CAD0B,CACvBC,EAAQ,CADe,CACAC,EAAc,CAC5C,KAAIF,CAAJ,CAAQ,CAAR,CAAWA,CAAX,CAAeD,CAAUI,CAAAA,MAAzB,CAAiCH,CAAA,EAAjC,CACIE,CAAA,EAAeH,CAAA,CAAUC,CAAV,CAAaG,CAAAA,MAEhC,QAAOL,CAAP,EACI,KAAK,QAAL,CACI,MAAOC,EAAUK,CAAAA,IAAV,CAAe,EAAf,CACT,MAAK,OAAL,CACE,MAAOC,MAAMC,CAAAA,SAAUT,CAAAA,MAAOU,CAAAA,KAAvB,CAA6B,EAA7B,CAAiCR,CAAjC,CACX,MAAK,YAAL,CACIS,CAAA,CAAM,IAAIC,UAAJ,CAAeP,CAAf,CACN,KAAIF,CAAJ,CAAQ,CAAR,CAAWA,CAAX,CAAeD,CAAUI,CAAAA,MAAzB,CAAiCH,CAAA,EAAjC,CACIQ,CAAIE,CAAAA,GAAJ,CAAQX,CAAA,CAAUC,CAAV,CAAR,CAAsBC,CAAtB,CACA,CAAAA,CAAA,EAASF,CAAA,CAAUC,CAAV,CAAaG,CAAAA,MAE1B,OAAOK,EACX,MAAK,YAAL,CACI,MAAOG,EAAOd,CAAAA,MAAP,CAAcE,CAAd,CACX,SACI,KAAUa,MAAJ,CAAU,6BAAV,CAA2Cd,CAA3C,CAAkD,GAAlD,CAAN,CAfR,CAL8B,CAiClCe,QAASA,EAAU,CAACC,CAAD,CAASC,CAAT,CAAyB,CACxC,MAAO,KAAIC,CAASC,CAAAA,OAAb,CAAqB,QAAS,CAACC,CAAD,CAAUC,CAAV,CAAiB,CAClD,IAAIpB,EAAY,EAAhB,CACIqB,EAAYN,CAAOO,CAAAA,aADvB,CAEIC,EAAaR,CAAOS,CAAAA,WAFxB,CAGIC,EAAWV,CAAOW,CAAAA,SACtBX;CACCY,CAAAA,EADD,CACI,MADJ,CACY,QAAS,CAACC,CAAD,CAAOC,CAAP,CAAa,CAC9B7B,CAAU8B,CAAAA,IAAV,CAAeF,CAAf,CACGZ,EAAH,EACIA,CAAA,CAAea,CAAf,CAH0B,CADlC,CAOCF,CAAAA,EAPD,CAOI,OAPJ,CAOa,QAAQ,CAACI,CAAD,CAAM,CACvB/B,CAAA,CAAY,EACZoB,EAAA,CAAOW,CAAP,CAFuB,CAP3B,CAWCJ,CAAAA,EAXD,CAWI,KAXJ,CAWW,QAAS,EAAE,CAClB,GAAI,CArEqC,CAAA,CAAA,CAsEO,IAAA,EAAA7B,CAAA,CAAOuB,CAAP,CAAkBrB,CAAlB,CArExD,QAqE4CuB,CArE5C,EACI,KAAK,MAAL,CACI,IAAA,EAAOS,CAAMC,CAAAA,OAAN,CAAcD,CAAME,CAAAA,WAAN,CAAkB,aAAlB,CAAiCC,CAAjC,CAAd,CAmEuEV,CAnEvE,CAAP,OAAA,CACJ,MAAK,QAAL,CACI,CAAA,CAAOW,CAAOC,CAAAA,MAAP,CAAcF,CAAd,CAAP,OAAA,CACJ,SACI,CAAA,CAAOH,CAAME,CAAAA,WAAN,CA+D6BX,CA/D7B,CAAwBY,CAAxB,CANf,CADiD,CAuErChB,CAAA,CAAQmB,CAAR,CAFA,CAGF,MAAOC,CAAP,CAAU,CACRnB,CAAA,CAAOmB,CAAP,CADQ,CAGZvC,CAAA,CAAY,EAPM,CAXtB,CAoBCwC,CAAAA,MApBD,EALkD,CAA/C,CADiC,CAqC5CC,QAASA,EAAY,CAACC,CAAD,CAASC,CAAT,CAAqBlB,CAArB,CAA+B,CAChD,IAAImB,EAAeD,CACnB,QAAOA,CAAP,EACI,KAAK,MAAL,CACA,KAAK,aAAL,CACIC,CAAA,CAAe,YACnB,MACA,MAAK,QAAL,CACIA,CAAA,CAAe,QANvB,CAUA,GAAI,CAEA,IAAKtB,CAAAA,aASL,CATqBsB,CASrB,CAPA,IAAKpB,CAAAA,WAOL,CAPmBmB,CAOnB,CALA,IAAKjB,CAAAA,SAKL,CALiBD,CAKjB,CAJAO,CAAMa,CAAAA,YAAN,CAAmBD,CAAnB,CAIA,CAHA,IAAKE,CAAAA,OAGL;AAHeJ,CAAOK,CAAAA,IAAP,CAAY,IAAIC,CAAJ,CAAkBJ,CAAlB,CAAZ,CAGf,CAAAF,CAAOO,CAAAA,IAAP,EAXA,CAYF,MAAMV,CAAN,CAAS,CACP,IAAKO,CAAAA,OACL,CADe,IAAII,CAAJ,CAAkB,OAAlB,CACf,CAAA,IAAKJ,CAAAA,OAAQK,CAAAA,KAAb,CAAmBZ,CAAnB,CAFO,CAxBqC,CAlHpD,IAAI3B,EAASjB,CAAA,CAAQ,GAAR,CAAkBiB,CAAAA,MAC/B,aAEA,KAAIoB,EAAQrC,CAAA,CAAQ,GAAR,CAAZ,CACIqD,EAAgBrD,CAAA,CAAQ,GAAR,CADpB,CAEIuD,EAAgBvD,CAAA,CAAQ,GAAR,CAFpB,CAGIyC,EAASzC,CAAA,CAAQ,GAAR,CACTyD,GAAAA,CAAUzD,CAAA,CAAQ,GAAR,CACd,KAAIsB,EAAWtB,CAAA,CAAQ,GAAR,CAAf,CAEI0D,EAA4B,IAChC,IAAID,EAAQE,CAAAA,UAAZ,CACI,GAAI,CACAD,CAAA,CAA4B1D,CAAA,CAAQ,GAAR,CAD5B,CAEF,MAAM4C,CAAN,CAAS,EAkIfE,CAAalC,CAAAA,SAAb,CAAyB,CAOrBO,WAAaA,QAAS,CAACyC,CAAD,CAAW,CAC7B,MAAOzC,EAAA,CAAW,IAAX,CAAiByC,CAAjB,CADsB,CAPZ,CAgBrB5B,GAAKA,QAAS,CAAC6B,CAAD,CAAMC,CAAN,CAAU,CACpB,IAAIC,EAAO,IAEX,IAAW,MAAX,GAAGF,CAAH,CACI,IAAKV,CAAAA,OAAQnB,CAAAA,EAAb,CAAgB6B,CAAhB,CAAqB,QAAS,CAACG,CAAD,CAAQ,CAClCF,CAAGG,CAAAA,IAAH,CAAQF,CAAR,CAAcC,CAAM/B,CAAAA,IAApB,CAA0B+B,CAAM9B,CAAAA,IAAhC,CADkC,CAAtC,CADJ,KAKI,KAAKiB,CAAAA,OAAQnB,CAAAA,EAAb,CAAgB6B,CAAhB,CAAqB,QAAS,EAAG,CAC7BxB,CAAM6B,CAAAA,KAAN,CAAYJ,CAAZ,CAAgBK,SAAhB,CAA2BJ,CAA3B,CAD6B,CAAjC,CAIJ,OAAO,KAZa,CAhBH,CAkCrBlB,OAASA,QAAS,EAAG,CACjBR,CAAM6B,CAAAA,KAAN,CAAY,IAAKf,CAAAA,OAAQN,CAAAA,MAAzB,CAAiC,EAAjC;AAAqC,IAAKM,CAAAA,OAA1C,CACA,OAAO,KAFU,CAlCA,CA0CrBiB,MAAQA,QAAS,EAAG,CAChB,IAAKjB,CAAAA,OAAQiB,CAAAA,KAAb,EACA,OAAO,KAFS,CA1CC,CAmDrBC,eAAiBA,QAAS,CAACT,CAAD,CAAW,CACjCvB,CAAMa,CAAAA,YAAN,CAAmB,YAAnB,CACA,IAAyB,YAAzB,GAAI,IAAKrB,CAAAA,WAAT,CAKI,KAAUX,MAAJ,CAAU,IAAKW,CAAAA,WAAf,CAA6B,kCAA7B,CAAN,CAGJ,MAAO,KAAI6B,CAAJ,CAA8B,IAA9B,CAAoC,CACvCY,WAAkC,YAAlCA,GAAa,IAAKzC,CAAAA,WADqB,CAApC,CAEJ+B,CAFI,CAV0B,CAnDhB,CAoEzB3D,GAAOC,CAAAA,OAAP,CAAiB4C,CArN6C;\",\n\"sources\":[\"node_modules/jszip/lib/stream/StreamHelper.js\"],\n\"sourcesContent\":[\"shadow$provide[161] = function(global,require,module,exports) {\\nvar Buffer = require('buffer').Buffer;\\n'use strict';\\n\\nvar utils = require('../utils');\\nvar ConvertWorker = require('./ConvertWorker');\\nvar GenericWorker = require('./GenericWorker');\\nvar base64 = require('../base64');\\nvar support = require(\\\"../support\\\");\\nvar external = require(\\\"../external\\\");\\n\\nvar NodejsStreamOutputAdapter = null;\\nif (support.nodestream) {\\n    try {\\n        NodejsStreamOutputAdapter = require('../nodejs/NodejsStreamOutputAdapter');\\n    } catch(e) {}\\n}\\n\\n/**\\n * Apply the final transformation of the data. If the user wants a Blob for\\n * example, it's easier to work with an U8intArray and finally do the\\n * ArrayBuffer/Blob conversion.\\n * @param {String} type the name of the final type\\n * @param {String|Uint8Array|Buffer} content the content to transform\\n * @param {String} mimeType the mime type of the content, if applicable.\\n * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the content in the right format.\\n */\\nfunction transformZipOutput(type, content, mimeType) {\\n    switch(type) {\\n        case \\\"blob\\\" :\\n            return utils.newBlob(utils.transformTo(\\\"arraybuffer\\\", content), mimeType);\\n        case \\\"base64\\\" :\\n            return base64.encode(content);\\n        default :\\n            return utils.transformTo(type, content);\\n    }\\n}\\n\\n/**\\n * Concatenate an array of data of the given type.\\n * @param {String} type the type of the data in the given array.\\n * @param {Array} dataArray the array containing the data chunks to concatenate\\n * @return {String|Uint8Array|Buffer} the concatenated data\\n * @throws Error if the asked type is unsupported\\n */\\nfunction concat (type, dataArray) {\\n    var i, index = 0, res = null, totalLength = 0;\\n    for(i = 0; i < dataArray.length; i++) {\\n        totalLength += dataArray[i].length;\\n    }\\n    switch(type) {\\n        case \\\"string\\\":\\n            return dataArray.join(\\\"\\\");\\n          case \\\"array\\\":\\n            return Array.prototype.concat.apply([], dataArray);\\n        case \\\"uint8array\\\":\\n            res = new Uint8Array(totalLength);\\n            for(i = 0; i < dataArray.length; i++) {\\n                res.set(dataArray[i], index);\\n                index += dataArray[i].length;\\n            }\\n            return res;\\n        case \\\"nodebuffer\\\":\\n            return Buffer.concat(dataArray);\\n        default:\\n            throw new Error(\\\"concat : unsupported type '\\\"  + type + \\\"'\\\");\\n    }\\n}\\n\\n/**\\n * Listen a StreamHelper, accumulate its content and concatenate it into a\\n * complete block.\\n * @param {StreamHelper} helper the helper to use.\\n * @param {Function} updateCallback a callback called on each update. Called\\n * with one arg :\\n * - the metadata linked to the update received.\\n * @return Promise the promise for the accumulation.\\n */\\nfunction accumulate(helper, updateCallback) {\\n    return new external.Promise(function (resolve, reject){\\n        var dataArray = [];\\n        var chunkType = helper._internalType,\\n            resultType = helper._outputType,\\n            mimeType = helper._mimeType;\\n        helper\\n        .on('data', function (data, meta) {\\n            dataArray.push(data);\\n            if(updateCallback) {\\n                updateCallback(meta);\\n            }\\n        })\\n        .on('error', function(err) {\\n            dataArray = [];\\n            reject(err);\\n        })\\n        .on('end', function (){\\n            try {\\n                var result = transformZipOutput(resultType, concat(chunkType, dataArray), mimeType);\\n                resolve(result);\\n            } catch (e) {\\n                reject(e);\\n            }\\n            dataArray = [];\\n        })\\n        .resume();\\n    });\\n}\\n\\n/**\\n * An helper to easily use workers outside of JSZip.\\n * @constructor\\n * @param {Worker} worker the worker to wrap\\n * @param {String} outputType the type of data expected by the use\\n * @param {String} mimeType the mime type of the content, if applicable.\\n */\\nfunction StreamHelper(worker, outputType, mimeType) {\\n    var internalType = outputType;\\n    switch(outputType) {\\n        case \\\"blob\\\":\\n        case \\\"arraybuffer\\\":\\n            internalType = \\\"uint8array\\\";\\n        break;\\n        case \\\"base64\\\":\\n            internalType = \\\"string\\\";\\n        break;\\n    }\\n\\n    try {\\n        // the type used internally\\n        this._internalType = internalType;\\n        // the type used to output results\\n        this._outputType = outputType;\\n        // the mime type\\n        this._mimeType = mimeType;\\n        utils.checkSupport(internalType);\\n        this._worker = worker.pipe(new ConvertWorker(internalType));\\n        // the last workers can be rewired without issues but we need to\\n        // prevent any updates on previous workers.\\n        worker.lock();\\n    } catch(e) {\\n        this._worker = new GenericWorker(\\\"error\\\");\\n        this._worker.error(e);\\n    }\\n}\\n\\nStreamHelper.prototype = {\\n    /**\\n     * Listen a StreamHelper, accumulate its content and concatenate it into a\\n     * complete block.\\n     * @param {Function} updateCb the update callback.\\n     * @return Promise the promise for the accumulation.\\n     */\\n    accumulate : function (updateCb) {\\n        return accumulate(this, updateCb);\\n    },\\n    /**\\n     * Add a listener on an event triggered on a stream.\\n     * @param {String} evt the name of the event\\n     * @param {Function} fn the listener\\n     * @return {StreamHelper} the current helper.\\n     */\\n    on : function (evt, fn) {\\n        var self = this;\\n\\n        if(evt === \\\"data\\\") {\\n            this._worker.on(evt, function (chunk) {\\n                fn.call(self, chunk.data, chunk.meta);\\n            });\\n        } else {\\n            this._worker.on(evt, function () {\\n                utils.delay(fn, arguments, self);\\n            });\\n        }\\n        return this;\\n    },\\n    /**\\n     * Resume the flow of chunks.\\n     * @return {StreamHelper} the current helper.\\n     */\\n    resume : function () {\\n        utils.delay(this._worker.resume, [], this._worker);\\n        return this;\\n    },\\n    /**\\n     * Pause the flow of chunks.\\n     * @return {StreamHelper} the current helper.\\n     */\\n    pause : function () {\\n        this._worker.pause();\\n        return this;\\n    },\\n    /**\\n     * Return a nodejs stream for this helper.\\n     * @param {Function} updateCb the update callback.\\n     * @return {NodejsStreamOutputAdapter} the nodejs stream.\\n     */\\n    toNodejsStream : function (updateCb) {\\n        utils.checkSupport(\\\"nodestream\\\");\\n        if (this._outputType !== \\\"nodebuffer\\\") {\\n            // an object stream containing blob/arraybuffer/uint8array/string\\n            // is strange and I don't know if it would be useful.\\n            // I you find this comment and have a good usecase, please open a\\n            // bug report !\\n            throw new Error(this._outputType + \\\" is not supported by this method\\\");\\n        }\\n\\n        return new NodejsStreamOutputAdapter(this, {\\n            objectMode : this._outputType !== \\\"nodebuffer\\\"\\n        }, updateCb);\\n    }\\n};\\n\\n\\nmodule.exports = StreamHelper;\\n\\n};\"],\n\"names\":[\"shadow$provide\",\"global\",\"require\",\"module\",\"exports\",\"concat\",\"type\",\"dataArray\",\"i\",\"index\",\"totalLength\",\"length\",\"join\",\"Array\",\"prototype\",\"apply\",\"res\",\"Uint8Array\",\"set\",\"Buffer\",\"Error\",\"accumulate\",\"helper\",\"updateCallback\",\"external\",\"Promise\",\"resolve\",\"reject\",\"chunkType\",\"_internalType\",\"resultType\",\"_outputType\",\"mimeType\",\"_mimeType\",\"on\",\"data\",\"meta\",\"push\",\"err\",\"utils\",\"newBlob\",\"transformTo\",\"content\",\"base64\",\"encode\",\"result\",\"e\",\"resume\",\"StreamHelper\",\"worker\",\"outputType\",\"internalType\",\"checkSupport\",\"_worker\",\"pipe\",\"ConvertWorker\",\"lock\",\"GenericWorker\",\"error\",\"support\",\"NodejsStreamOutputAdapter\",\"nodestream\",\"updateCb\",\"evt\",\"fn\",\"self\",\"chunk\",\"call\",\"delay\",\"arguments\",\"pause\",\"toNodejsStream\",\"objectMode\"]\n}\n"]